package translatortext

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/satori/go.uuid"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/cognitiveservices/v1.0_preview.1/translatortext"

// Code enumerates the values for code.
type Code string

const (
	// InternalServerError ...
	InternalServerError Code = "InternalServerError"
	// InvalidArgument ...
	InvalidArgument Code = "InvalidArgument"
	// InvalidRequest ...
	InvalidRequest Code = "InvalidRequest"
	// RequestRateTooHigh ...
	RequestRateTooHigh Code = "RequestRateTooHigh"
	// ResourceNotFound ...
	ResourceNotFound Code = "ResourceNotFound"
	// ServiceUnavailable ...
	ServiceUnavailable Code = "ServiceUnavailable"
	// Unauthorized ...
	Unauthorized Code = "Unauthorized"
)

// PossibleCodeValues returns an array of possible values for the Code const type.
func PossibleCodeValues() []Code {
	return []Code{InternalServerError, InvalidArgument, InvalidRequest, RequestRateTooHigh, ResourceNotFound, ServiceUnavailable, Unauthorized}
}

// Status enumerates the values for status.
type Status string

const (
	// Cancelled ...
	Cancelled Status = "Cancelled"
	// Cancelling ...
	Cancelling Status = "Cancelling"
	// Failed ...
	Failed Status = "Failed"
	// NotStarted ...
	NotStarted Status = "NotStarted"
	// Running ...
	Running Status = "Running"
	// Succeeded ...
	Succeeded Status = "Succeeded"
)

// PossibleStatusValues returns an array of possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{Cancelled, Cancelling, Failed, NotStarted, Running, Succeeded}
}

// Status1 enumerates the values for status 1.
type Status1 string

const (
	// Status1Cancelled ...
	Status1Cancelled Status1 = "Cancelled"
	// Status1Cancelling ...
	Status1Cancelling Status1 = "Cancelling"
	// Status1Failed ...
	Status1Failed Status1 = "Failed"
	// Status1NotStarted ...
	Status1NotStarted Status1 = "NotStarted"
	// Status1Running ...
	Status1Running Status1 = "Running"
	// Status1Succeeded ...
	Status1Succeeded Status1 = "Succeeded"
)

// PossibleStatus1Values returns an array of possible values for the Status1 const type.
func PossibleStatus1Values() []Status1 {
	return []Status1{Status1Cancelled, Status1Cancelling, Status1Failed, Status1NotStarted, Status1Running, Status1Succeeded}
}

// StorageSource enumerates the values for storage source.
type StorageSource string

const (
	// AzureBlob ...
	AzureBlob StorageSource = "AzureBlob"
)

// PossibleStorageSourceValues returns an array of possible values for the StorageSource const type.
func PossibleStorageSourceValues() []StorageSource {
	return []StorageSource{AzureBlob}
}

// StorageSource1 enumerates the values for storage source 1.
type StorageSource1 string

const (
	// StorageSource1AzureBlob ...
	StorageSource1AzureBlob StorageSource1 = "AzureBlob"
)

// PossibleStorageSource1Values returns an array of possible values for the StorageSource1 const type.
func PossibleStorageSource1Values() []StorageSource1 {
	return []StorageSource1{StorageSource1AzureBlob}
}

// BatchRequest definition for the input batch translation request
type BatchRequest struct {
	Source *SourceInput `json:"source,omitempty"`
	// Targets - Location of the destination for the output
	Targets *[]TargetInput `json:"targets,omitempty"`
}

// BatchStatusDetail job status response
type BatchStatusDetail struct {
	// ID - Id of the operation.
	ID *uuid.UUID `json:"id,omitempty"`
	// CreatedDateTimeUtc - Operation created date time
	CreatedDateTimeUtc *date.Time `json:"createdDateTimeUtc,omitempty"`
	// LastActionDateTimeUtc - Date time in which the operation's status has been updated
	LastActionDateTimeUtc *date.Time `json:"lastActionDateTimeUtc,omitempty"`
	// Status - Possible values include: 'NotStarted', 'Running', 'Succeeded', 'Failed', 'Cancelled', 'Cancelling'
	Status  Status         `json:"status,omitempty"`
	Summary *StatusSummary `json:"summary,omitempty"`
}

// BatchStatusResponse document Status Response
type BatchStatusResponse struct {
	// Value - The summary status of individual operation
	Value *[]BatchStatusDetail `json:"value,omitempty"`
	// NextLink - Url for the next page.  Null if no more pages available
	NextLink *string `json:"@nextLink,omitempty"`
}

// BatchSubmissionRequest job submission batch request
type BatchSubmissionRequest struct {
	// Inputs - The input list of documents or folders containing documents
	Inputs *[]BatchRequest `json:"inputs,omitempty"`
}

// DocumentFilter ...
type DocumentFilter struct {
	// Prefix - A case-sensitive prefix string to filter documents in the source path for translation.
	// For example, when using a Azure storage blob Uri, use the prefix to restrict sub folders for translation.
	Prefix *string `json:"prefix,omitempty"`
	// Suffix - A case-sensitive suffix string to filter documents in the source path for translation.
	// This is most often use for file extensions
	Suffix *string `json:"suffix,omitempty"`
}

// DocumentStatusDetail ...
type DocumentStatusDetail struct {
	// Path - Location of the document or folder
	Path *string `json:"path,omitempty"`
	// CreatedDateTimeUtc - Operation created date time
	CreatedDateTimeUtc *date.Time `json:"createdDateTimeUtc,omitempty"`
	// LastActionDateTimeUtc - Date time in which the operation's status has been updated
	LastActionDateTimeUtc *date.Time `json:"lastActionDateTimeUtc,omitempty"`
	// Status - Possible values include: 'Status1NotStarted', 'Status1Running', 'Status1Succeeded', 'Status1Failed', 'Status1Cancelled', 'Status1Cancelling'
	Status Status1 `json:"status,omitempty"`
	// DetectedLanguage - Detected language of the original document (to be implemented)
	DetectedLanguage *string `json:"detectedLanguage,omitempty"`
	// To - To language
	To    *string  `json:"to,omitempty"`
	Error *ErrorV2 `json:"error,omitempty"`
	// Progress - Progress of the translation if available
	Progress *float64 `json:"progress,omitempty"`
	// ID - Document Id
	ID *uuid.UUID `json:"id,omitempty"`
}

// DocumentStatusResponse document Status Response
type DocumentStatusResponse struct {
	// Value - The detail status of individual documents
	Value *[]DocumentStatusDetail `json:"value,omitempty"`
	// NextLink - Url for the next page.  Null if no more pages available
	NextLink *string `json:"@nextLink,omitempty"`
}

// ErrorResponseV2 contains unified error information used for HTTP responses across any Cognitive Service.
// Instances
// can be created either through Microsoft.CloudAI.Containers.HttpStatusExceptionV2 or by returning it
// directly from
// a controller.
type ErrorResponseV2 struct {
	autorest.Response `json:"-"`
	Error             *ErrorV2 `json:"error,omitempty"`
}

// ErrorV2 this contains an outer error with error code, message, details, target and an inner error with
// more descriptive details.
type ErrorV2 struct {
	// Code - Possible values include: 'InvalidRequest', 'InvalidArgument', 'InternalServerError', 'ServiceUnavailable', 'ResourceNotFound', 'Unauthorized', 'RequestRateTooHigh'
	Code Code `json:"code,omitempty"`
	// Message - READ-ONLY; Gets high level error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; Gets the source of the error.
	// For example it would be "documents" or "document id" in case of invalid document.
	Target     *string       `json:"target,omitempty"`
	InnerError *InnerErrorV2 `json:"innerError,omitempty"`
}

// FileFormat ...
type FileFormat struct {
	// Format - Name of the format
	Format *string `json:"format,omitempty"`
	// FileExtensions - Supported file extension for this format
	FileExtensions *[]string `json:"fileExtensions,omitempty"`
	// ContentTypes - Supported Content-Types for this format
	ContentTypes *[]string `json:"contentTypes,omitempty"`
	// Versions - Supported Version
	Versions *[]string `json:"versions,omitempty"`
}

// FileFormatListResult base type for List return in our api
type FileFormatListResult struct {
	// Value - list of objects
	Value *[]FileFormat `json:"value,omitempty"`
}

// Glossary glossary / translation memory for the request
type Glossary struct {
	// GlossaryURL - Location of the glossary.
	// We will use the file extension to extract the formating if the format parameter is not supplied.
	//
	// If the translation language pair is not present in the glossary, it will not be applied
	GlossaryURL *string `json:"glossaryUrl,omitempty"`
	// Format - Format
	Format *string `json:"format,omitempty"`
	// Version - Version
	Version *string `json:"version,omitempty"`
}

// InnerErrorV2 new Inner Error format which conforms to Cognitive Services API Guidelines which is
// available at
// https://microsoft.sharepoint.com/%3Aw%3A/t/CognitiveServicesPMO/EUoytcrjuJdKpeOKIK_QRC8BPtUYQpKBi8JsWyeDMRsWlQ?e=CPq8ow.
// This contains required properties ErrorCode, message and optional properties target, details(key value
// pair), inner error(this can be nested).
type InnerErrorV2 struct {
	// Code - READ-ONLY; Gets detailed error code.
	Code *int32 `json:"code,omitempty"`
	// Error - READ-ONLY; Gets detailed error string.
	Error *string `json:"error,omitempty"`
	// Message - READ-ONLY; Gets high level error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; Gets the source of the error.
	// For example it would be "documents" or "document id" in case of invalid document.
	Target     *string       `json:"target,omitempty"`
	InnerError *InnerErrorV2 `json:"innerError,omitempty"`
}

// SetObject ...
type SetObject struct {
	autorest.Response `json:"-"`
	Value             interface{} `json:"value,omitempty"`
}

// SourceInput source of the input documents
type SourceInput struct {
	// SourceURL - Location of the folder / container with your documents
	SourceURL *string         `json:"sourceUrl,omitempty"`
	Filter    *DocumentFilter `json:"filter,omitempty"`
	// Language - Language code
	// If none is specified, we will perform auto detect on the document
	Language *string `json:"language,omitempty"`
	// StorageSource - Possible values include: 'AzureBlob'
	StorageSource StorageSource `json:"storageSource,omitempty"`
}

// StatusSummary ...
type StatusSummary struct {
	// Total - Total count
	Total *int32 `json:"total,omitempty"`
	// Failed - Failed count
	Failed *int32 `json:"failed,omitempty"`
	// Success - Number of Success
	Success *int32 `json:"success,omitempty"`
	// InProgress - Number of in progress
	InProgress *int32 `json:"inProgress,omitempty"`
	// NotYetStarted - Count of not yet started
	NotYetStarted *int32 `json:"notYetStarted,omitempty"`
	// Cancelled - Number of cancelled
	Cancelled *int32 `json:"cancelled,omitempty"`
}

// StorageSourceListResult base type for List return in our api
type StorageSourceListResult struct {
	// Value - list of objects
	Value *[]string `json:"value,omitempty"`
}

// TargetInput destination for the finished translated documents
type TargetInput struct {
	// TargetURL - Location of the folder / container with your documents
	TargetURL *string `json:"targetUrl,omitempty"`
	// Category - Category / custom system for translation request
	Category *string `json:"category,omitempty"`
	// Language - Target Language
	Language *string `json:"language,omitempty"`
	// Glossaries - List of Glossary
	Glossaries *[]Glossary `json:"glossaries,omitempty"`
	// StorageSource - Possible values include: 'StorageSource1AzureBlob'
	StorageSource StorageSource1 `json:"storageSource,omitempty"`
}
