package billing

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/satori/go.uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/billing/mgmt/2020-05-01/billing"

// AcceptanceMode enumerates the values for acceptance mode.
type AcceptanceMode string

const (
	// ClickToAccept ...
	ClickToAccept AcceptanceMode = "ClickToAccept"
	// ESignEmbedded ...
	ESignEmbedded AcceptanceMode = "ESignEmbedded"
	// ESignOffline ...
	ESignOffline AcceptanceMode = "ESignOffline"
)

// PossibleAcceptanceModeValues returns an array of possible values for the AcceptanceMode const type.
func PossibleAcceptanceModeValues() []AcceptanceMode {
	return []AcceptanceMode{ClickToAccept, ESignEmbedded, ESignOffline}
}

// AccountStatus enumerates the values for account status.
type AccountStatus string

const (
	// Active ...
	Active AccountStatus = "Active"
	// Deleted ...
	Deleted AccountStatus = "Deleted"
	// Disabled ...
	Disabled AccountStatus = "Disabled"
	// Expired ...
	Expired AccountStatus = "Expired"
	// Extended ...
	Extended AccountStatus = "Extended"
	// Terminated ...
	Terminated AccountStatus = "Terminated"
	// Transferred ...
	Transferred AccountStatus = "Transferred"
)

// PossibleAccountStatusValues returns an array of possible values for the AccountStatus const type.
func PossibleAccountStatusValues() []AccountStatus {
	return []AccountStatus{Active, Deleted, Disabled, Expired, Extended, Terminated, Transferred}
}

// AccountType enumerates the values for account type.
type AccountType string

const (
	// Enterprise ...
	Enterprise AccountType = "Enterprise"
	// Individual ...
	Individual AccountType = "Individual"
	// Partner ...
	Partner AccountType = "Partner"
)

// PossibleAccountTypeValues returns an array of possible values for the AccountType const type.
func PossibleAccountTypeValues() []AccountType {
	return []AccountType{Enterprise, Individual, Partner}
}

// AddressValidationStatus enumerates the values for address validation status.
type AddressValidationStatus string

const (
	// Invalid ...
	Invalid AddressValidationStatus = "Invalid"
	// Valid ...
	Valid AddressValidationStatus = "Valid"
)

// PossibleAddressValidationStatusValues returns an array of possible values for the AddressValidationStatus const type.
func PossibleAddressValidationStatusValues() []AddressValidationStatus {
	return []AddressValidationStatus{Invalid, Valid}
}

// AgreementType enumerates the values for agreement type.
type AgreementType string

const (
	// EnterpriseAgreement ...
	EnterpriseAgreement AgreementType = "EnterpriseAgreement"
	// MicrosoftCustomerAgreement ...
	MicrosoftCustomerAgreement AgreementType = "MicrosoftCustomerAgreement"
	// MicrosoftOnlineServicesProgram ...
	MicrosoftOnlineServicesProgram AgreementType = "MicrosoftOnlineServicesProgram"
	// MicrosoftPartnerAgreement ...
	MicrosoftPartnerAgreement AgreementType = "MicrosoftPartnerAgreement"
)

// PossibleAgreementTypeValues returns an array of possible values for the AgreementType const type.
func PossibleAgreementTypeValues() []AgreementType {
	return []AgreementType{EnterpriseAgreement, MicrosoftCustomerAgreement, MicrosoftOnlineServicesProgram, MicrosoftPartnerAgreement}
}

// AutoRenew enumerates the values for auto renew.
type AutoRenew string

const (
	// Off ...
	Off AutoRenew = "Off"
	// On ...
	On AutoRenew = "On"
)

// PossibleAutoRenewValues returns an array of possible values for the AutoRenew const type.
func PossibleAutoRenewValues() []AutoRenew {
	return []AutoRenew{Off, On}
}

// Category enumerates the values for category.
type Category string

const (
	// CategoryAffiliatePurchaseTerms ...
	CategoryAffiliatePurchaseTerms Category = "AffiliatePurchaseTerms"
	// CategoryMicrosoftCustomerAgreement ...
	CategoryMicrosoftCustomerAgreement Category = "MicrosoftCustomerAgreement"
	// CategoryOther ...
	CategoryOther Category = "Other"
)

// PossibleCategoryValues returns an array of possible values for the Category const type.
func PossibleCategoryValues() []Category {
	return []Category{CategoryAffiliatePurchaseTerms, CategoryMicrosoftCustomerAgreement, CategoryOther}
}

// DocumentSource enumerates the values for document source.
type DocumentSource string

const (
	// DRS ...
	DRS DocumentSource = "DRS"
	// ENF ...
	ENF DocumentSource = "ENF"
)

// PossibleDocumentSourceValues returns an array of possible values for the DocumentSource const type.
func PossibleDocumentSourceValues() []DocumentSource {
	return []DocumentSource{DRS, ENF}
}

// DocumentType enumerates the values for document type.
type DocumentType string

const (
	// DocumentTypeCreditNote ...
	DocumentTypeCreditNote DocumentType = "CreditNote"
	// DocumentTypeInvoice ...
	DocumentTypeInvoice DocumentType = "Invoice"
	// DocumentTypeTaxReceipt ...
	DocumentTypeTaxReceipt DocumentType = "TaxReceipt"
	// DocumentTypeVoidNote ...
	DocumentTypeVoidNote DocumentType = "VoidNote"
)

// PossibleDocumentTypeValues returns an array of possible values for the DocumentType const type.
func PossibleDocumentTypeValues() []DocumentType {
	return []DocumentType{DocumentTypeCreditNote, DocumentTypeInvoice, DocumentTypeTaxReceipt, DocumentTypeVoidNote}
}

// Frequency enumerates the values for frequency.
type Frequency string

const (
	// Monthly ...
	Monthly Frequency = "Monthly"
	// OneTime ...
	OneTime Frequency = "OneTime"
	// UsageBased ...
	UsageBased Frequency = "UsageBased"
)

// PossibleFrequencyValues returns an array of possible values for the Frequency const type.
func PossibleFrequencyValues() []Frequency {
	return []Frequency{Monthly, OneTime, UsageBased}
}

// InvoiceStatus enumerates the values for invoice status.
type InvoiceStatus string

const (
	// Due ...
	Due InvoiceStatus = "Due"
	// OverDue ...
	OverDue InvoiceStatus = "OverDue"
	// Paid ...
	Paid InvoiceStatus = "Paid"
)

// PossibleInvoiceStatusValues returns an array of possible values for the InvoiceStatus const type.
func PossibleInvoiceStatusValues() []InvoiceStatus {
	return []InvoiceStatus{Due, OverDue, Paid}
}

// InvoiceType enumerates the values for invoice type.
type InvoiceType string

const (
	// AzureMarketplace ...
	AzureMarketplace InvoiceType = "AzureMarketplace"
	// AzureService ...
	AzureService InvoiceType = "AzureService"
	// AzureSupport ...
	AzureSupport InvoiceType = "AzureSupport"
)

// PossibleInvoiceTypeValues returns an array of possible values for the InvoiceType const type.
func PossibleInvoiceTypeValues() []InvoiceType {
	return []InvoiceType{AzureMarketplace, AzureService, AzureSupport}
}

// MarketplacePurchasesPolicy enumerates the values for marketplace purchases policy.
type MarketplacePurchasesPolicy string

const (
	// AllAllowed ...
	AllAllowed MarketplacePurchasesPolicy = "AllAllowed"
	// NotAllowed ...
	NotAllowed MarketplacePurchasesPolicy = "NotAllowed"
	// OnlyFreeAllowed ...
	OnlyFreeAllowed MarketplacePurchasesPolicy = "OnlyFreeAllowed"
)

// PossibleMarketplacePurchasesPolicyValues returns an array of possible values for the MarketplacePurchasesPolicy const type.
func PossibleMarketplacePurchasesPolicyValues() []MarketplacePurchasesPolicy {
	return []MarketplacePurchasesPolicy{AllAllowed, NotAllowed, OnlyFreeAllowed}
}

// PaymentMethodFamily enumerates the values for payment method family.
type PaymentMethodFamily string

const (
	// CheckWire ...
	CheckWire PaymentMethodFamily = "CheckWire"
	// CreditCard ...
	CreditCard PaymentMethodFamily = "CreditCard"
	// Credits ...
	Credits PaymentMethodFamily = "Credits"
	// None ...
	None PaymentMethodFamily = "None"
)

// PossiblePaymentMethodFamilyValues returns an array of possible values for the PaymentMethodFamily const type.
func PossiblePaymentMethodFamilyValues() []PaymentMethodFamily {
	return []PaymentMethodFamily{CheckWire, CreditCard, Credits, None}
}

// ProductStatusType enumerates the values for product status type.
type ProductStatusType string

const (
	// ProductStatusTypeActive ...
	ProductStatusTypeActive ProductStatusType = "Active"
	// ProductStatusTypeAutoRenew ...
	ProductStatusTypeAutoRenew ProductStatusType = "AutoRenew"
	// ProductStatusTypeCancelled ...
	ProductStatusTypeCancelled ProductStatusType = "Cancelled"
	// ProductStatusTypeDisabled ...
	ProductStatusTypeDisabled ProductStatusType = "Disabled"
	// ProductStatusTypeExpired ...
	ProductStatusTypeExpired ProductStatusType = "Expired"
	// ProductStatusTypeExpiring ...
	ProductStatusTypeExpiring ProductStatusType = "Expiring"
	// ProductStatusTypeInactive ...
	ProductStatusTypeInactive ProductStatusType = "Inactive"
	// ProductStatusTypePastDue ...
	ProductStatusTypePastDue ProductStatusType = "PastDue"
)

// PossibleProductStatusTypeValues returns an array of possible values for the ProductStatusType const type.
func PossibleProductStatusTypeValues() []ProductStatusType {
	return []ProductStatusType{ProductStatusTypeActive, ProductStatusTypeAutoRenew, ProductStatusTypeCancelled, ProductStatusTypeDisabled, ProductStatusTypeExpired, ProductStatusTypeExpiring, ProductStatusTypeInactive, ProductStatusTypePastDue}
}

// ProductTransferValidationErrorCode enumerates the values for product transfer validation error code.
type ProductTransferValidationErrorCode string

const (
	// CrossBillingAccountNotAllowed ...
	CrossBillingAccountNotAllowed ProductTransferValidationErrorCode = "CrossBillingAccountNotAllowed"
	// DestinationBillingProfilePastDue ...
	DestinationBillingProfilePastDue ProductTransferValidationErrorCode = "DestinationBillingProfilePastDue"
	// InsufficientPermissionOnDestination ...
	InsufficientPermissionOnDestination ProductTransferValidationErrorCode = "InsufficientPermissionOnDestination"
	// InsufficientPermissionOnSource ...
	InsufficientPermissionOnSource ProductTransferValidationErrorCode = "InsufficientPermissionOnSource"
	// InvalidSource ...
	InvalidSource ProductTransferValidationErrorCode = "InvalidSource"
	// NotAvailableForDestinationMarket ...
	NotAvailableForDestinationMarket ProductTransferValidationErrorCode = "NotAvailableForDestinationMarket"
	// OneTimePurchaseProductTransferNotAllowed ...
	OneTimePurchaseProductTransferNotAllowed ProductTransferValidationErrorCode = "OneTimePurchaseProductTransferNotAllowed"
	// ProductNotActive ...
	ProductNotActive ProductTransferValidationErrorCode = "ProductNotActive"
	// ProductTypeNotSupported ...
	ProductTypeNotSupported ProductTransferValidationErrorCode = "ProductTypeNotSupported"
)

// PossibleProductTransferValidationErrorCodeValues returns an array of possible values for the ProductTransferValidationErrorCode const type.
func PossibleProductTransferValidationErrorCodeValues() []ProductTransferValidationErrorCode {
	return []ProductTransferValidationErrorCode{CrossBillingAccountNotAllowed, DestinationBillingProfilePastDue, InsufficientPermissionOnDestination, InsufficientPermissionOnSource, InvalidSource, NotAvailableForDestinationMarket, OneTimePurchaseProductTransferNotAllowed, ProductNotActive, ProductTypeNotSupported}
}

// ProfileSpendingLimit enumerates the values for profile spending limit.
type ProfileSpendingLimit string

const (
	// ProfileSpendingLimitOff ...
	ProfileSpendingLimitOff ProfileSpendingLimit = "Off"
	// ProfileSpendingLimitOn ...
	ProfileSpendingLimitOn ProfileSpendingLimit = "On"
)

// PossibleProfileSpendingLimitValues returns an array of possible values for the ProfileSpendingLimit const type.
func PossibleProfileSpendingLimitValues() []ProfileSpendingLimit {
	return []ProfileSpendingLimit{ProfileSpendingLimitOff, ProfileSpendingLimitOn}
}

// ProfileStatus enumerates the values for profile status.
type ProfileStatus string

const (
	// ProfileStatusActive ...
	ProfileStatusActive ProfileStatus = "Active"
	// ProfileStatusDisabled ...
	ProfileStatusDisabled ProfileStatus = "Disabled"
	// ProfileStatusWarned ...
	ProfileStatusWarned ProfileStatus = "Warned"
)

// PossibleProfileStatusValues returns an array of possible values for the ProfileStatus const type.
func PossibleProfileStatusValues() []ProfileStatus {
	return []ProfileStatus{ProfileStatusActive, ProfileStatusDisabled, ProfileStatusWarned}
}

// ProfileStatusReasonCode enumerates the values for profile status reason code.
type ProfileStatusReasonCode string

const (
	// PastDue ...
	PastDue ProfileStatusReasonCode = "PastDue"
	// SpendingLimitExpired ...
	SpendingLimitExpired ProfileStatusReasonCode = "SpendingLimitExpired"
	// SpendingLimitReached ...
	SpendingLimitReached ProfileStatusReasonCode = "SpendingLimitReached"
)

// PossibleProfileStatusReasonCodeValues returns an array of possible values for the ProfileStatusReasonCode const type.
func PossibleProfileStatusReasonCodeValues() []ProfileStatusReasonCode {
	return []ProfileStatusReasonCode{PastDue, SpendingLimitExpired, SpendingLimitReached}
}

// ReservationPurchasesPolicy enumerates the values for reservation purchases policy.
type ReservationPurchasesPolicy string

const (
	// ReservationPurchasesPolicyAllowed ...
	ReservationPurchasesPolicyAllowed ReservationPurchasesPolicy = "Allowed"
	// ReservationPurchasesPolicyNotAllowed ...
	ReservationPurchasesPolicyNotAllowed ReservationPurchasesPolicy = "NotAllowed"
)

// PossibleReservationPurchasesPolicyValues returns an array of possible values for the ReservationPurchasesPolicy const type.
func PossibleReservationPurchasesPolicyValues() []ReservationPurchasesPolicy {
	return []ReservationPurchasesPolicy{ReservationPurchasesPolicyAllowed, ReservationPurchasesPolicyNotAllowed}
}

// ReservationType enumerates the values for reservation type.
type ReservationType string

const (
	// Purchase ...
	Purchase ReservationType = "Purchase"
	// UsageCharge ...
	UsageCharge ReservationType = "Usage Charge"
)

// PossibleReservationTypeValues returns an array of possible values for the ReservationType const type.
func PossibleReservationTypeValues() []ReservationType {
	return []ReservationType{Purchase, UsageCharge}
}

// SpendingLimit enumerates the values for spending limit.
type SpendingLimit string

const (
	// SpendingLimitOff ...
	SpendingLimitOff SpendingLimit = "Off"
	// SpendingLimitOn ...
	SpendingLimitOn SpendingLimit = "On"
)

// PossibleSpendingLimitValues returns an array of possible values for the SpendingLimit const type.
func PossibleSpendingLimitValues() []SpendingLimit {
	return []SpendingLimit{SpendingLimitOff, SpendingLimitOn}
}

// SpendingLimitForBillingProfile enumerates the values for spending limit for billing profile.
type SpendingLimitForBillingProfile string

const (
	// SpendingLimitForBillingProfileOff ...
	SpendingLimitForBillingProfileOff SpendingLimitForBillingProfile = "Off"
	// SpendingLimitForBillingProfileOn ...
	SpendingLimitForBillingProfileOn SpendingLimitForBillingProfile = "On"
)

// PossibleSpendingLimitForBillingProfileValues returns an array of possible values for the SpendingLimitForBillingProfile const type.
func PossibleSpendingLimitForBillingProfileValues() []SpendingLimitForBillingProfile {
	return []SpendingLimitForBillingProfile{SpendingLimitForBillingProfileOff, SpendingLimitForBillingProfileOn}
}

// StatusReasonCode enumerates the values for status reason code.
type StatusReasonCode string

const (
	// StatusReasonCodePastDue ...
	StatusReasonCodePastDue StatusReasonCode = "PastDue"
	// StatusReasonCodeSpendingLimitExpired ...
	StatusReasonCodeSpendingLimitExpired StatusReasonCode = "SpendingLimitExpired"
	// StatusReasonCodeSpendingLimitReached ...
	StatusReasonCodeSpendingLimitReached StatusReasonCode = "SpendingLimitReached"
)

// PossibleStatusReasonCodeValues returns an array of possible values for the StatusReasonCode const type.
func PossibleStatusReasonCodeValues() []StatusReasonCode {
	return []StatusReasonCode{StatusReasonCodePastDue, StatusReasonCodeSpendingLimitExpired, StatusReasonCodeSpendingLimitReached}
}

// StatusReasonCodeForBillingProfile enumerates the values for status reason code for billing profile.
type StatusReasonCodeForBillingProfile string

const (
	// StatusReasonCodeForBillingProfilePastDue ...
	StatusReasonCodeForBillingProfilePastDue StatusReasonCodeForBillingProfile = "PastDue"
	// StatusReasonCodeForBillingProfileSpendingLimitExpired ...
	StatusReasonCodeForBillingProfileSpendingLimitExpired StatusReasonCodeForBillingProfile = "SpendingLimitExpired"
	// StatusReasonCodeForBillingProfileSpendingLimitReached ...
	StatusReasonCodeForBillingProfileSpendingLimitReached StatusReasonCodeForBillingProfile = "SpendingLimitReached"
)

// PossibleStatusReasonCodeForBillingProfileValues returns an array of possible values for the StatusReasonCodeForBillingProfile const type.
func PossibleStatusReasonCodeForBillingProfileValues() []StatusReasonCodeForBillingProfile {
	return []StatusReasonCodeForBillingProfile{StatusReasonCodeForBillingProfilePastDue, StatusReasonCodeForBillingProfileSpendingLimitExpired, StatusReasonCodeForBillingProfileSpendingLimitReached}
}

// SubscriptionStatusType enumerates the values for subscription status type.
type SubscriptionStatusType string

const (
	// SubscriptionStatusTypeAbandoned ...
	SubscriptionStatusTypeAbandoned SubscriptionStatusType = "Abandoned"
	// SubscriptionStatusTypeActive ...
	SubscriptionStatusTypeActive SubscriptionStatusType = "Active"
	// SubscriptionStatusTypeDeleted ...
	SubscriptionStatusTypeDeleted SubscriptionStatusType = "Deleted"
	// SubscriptionStatusTypeInactive ...
	SubscriptionStatusTypeInactive SubscriptionStatusType = "Inactive"
	// SubscriptionStatusTypeWarning ...
	SubscriptionStatusTypeWarning SubscriptionStatusType = "Warning"
)

// PossibleSubscriptionStatusTypeValues returns an array of possible values for the SubscriptionStatusType const type.
func PossibleSubscriptionStatusTypeValues() []SubscriptionStatusType {
	return []SubscriptionStatusType{SubscriptionStatusTypeAbandoned, SubscriptionStatusTypeActive, SubscriptionStatusTypeDeleted, SubscriptionStatusTypeInactive, SubscriptionStatusTypeWarning}
}

// SubscriptionTransferValidationErrorCode enumerates the values for subscription transfer validation error
// code.
type SubscriptionTransferValidationErrorCode string

const (
	// SubscriptionTransferValidationErrorCodeCrossBillingAccountNotAllowed ...
	SubscriptionTransferValidationErrorCodeCrossBillingAccountNotAllowed SubscriptionTransferValidationErrorCode = "CrossBillingAccountNotAllowed"
	// SubscriptionTransferValidationErrorCodeDestinationBillingProfilePastDue ...
	SubscriptionTransferValidationErrorCodeDestinationBillingProfilePastDue SubscriptionTransferValidationErrorCode = "DestinationBillingProfilePastDue"
	// SubscriptionTransferValidationErrorCodeInsufficientPermissionOnDestination ...
	SubscriptionTransferValidationErrorCodeInsufficientPermissionOnDestination SubscriptionTransferValidationErrorCode = "InsufficientPermissionOnDestination"
	// SubscriptionTransferValidationErrorCodeInsufficientPermissionOnSource ...
	SubscriptionTransferValidationErrorCodeInsufficientPermissionOnSource SubscriptionTransferValidationErrorCode = "InsufficientPermissionOnSource"
	// SubscriptionTransferValidationErrorCodeInvalidSource ...
	SubscriptionTransferValidationErrorCodeInvalidSource SubscriptionTransferValidationErrorCode = "InvalidSource"
	// SubscriptionTransferValidationErrorCodeNotAvailableForDestinationMarket ...
	SubscriptionTransferValidationErrorCodeNotAvailableForDestinationMarket SubscriptionTransferValidationErrorCode = "NotAvailableForDestinationMarket"
	// SubscriptionTransferValidationErrorCodeSubscriptionNotActive ...
	SubscriptionTransferValidationErrorCodeSubscriptionNotActive SubscriptionTransferValidationErrorCode = "SubscriptionNotActive"
	// SubscriptionTransferValidationErrorCodeSubscriptionTypeNotSupported ...
	SubscriptionTransferValidationErrorCodeSubscriptionTypeNotSupported SubscriptionTransferValidationErrorCode = "SubscriptionTypeNotSupported"
)

// PossibleSubscriptionTransferValidationErrorCodeValues returns an array of possible values for the SubscriptionTransferValidationErrorCode const type.
func PossibleSubscriptionTransferValidationErrorCodeValues() []SubscriptionTransferValidationErrorCode {
	return []SubscriptionTransferValidationErrorCode{SubscriptionTransferValidationErrorCodeCrossBillingAccountNotAllowed, SubscriptionTransferValidationErrorCodeDestinationBillingProfilePastDue, SubscriptionTransferValidationErrorCodeInsufficientPermissionOnDestination, SubscriptionTransferValidationErrorCodeInsufficientPermissionOnSource, SubscriptionTransferValidationErrorCodeInvalidSource, SubscriptionTransferValidationErrorCodeNotAvailableForDestinationMarket, SubscriptionTransferValidationErrorCodeSubscriptionNotActive, SubscriptionTransferValidationErrorCodeSubscriptionTypeNotSupported}
}

// TransactionTypeKind enumerates the values for transaction type kind.
type TransactionTypeKind string

const (
	// All ...
	All TransactionTypeKind = "all"
	// Reservation ...
	Reservation TransactionTypeKind = "reservation"
)

// PossibleTransactionTypeKindValues returns an array of possible values for the TransactionTypeKind const type.
func PossibleTransactionTypeKindValues() []TransactionTypeKind {
	return []TransactionTypeKind{All, Reservation}
}

// ViewCharges enumerates the values for view charges.
type ViewCharges string

const (
	// ViewChargesAllowed ...
	ViewChargesAllowed ViewCharges = "Allowed"
	// ViewChargesNotAllowed ...
	ViewChargesNotAllowed ViewCharges = "NotAllowed"
)

// PossibleViewChargesValues returns an array of possible values for the ViewCharges const type.
func PossibleViewChargesValues() []ViewCharges {
	return []ViewCharges{ViewChargesAllowed, ViewChargesNotAllowed}
}

// ViewChargesPolicy enumerates the values for view charges policy.
type ViewChargesPolicy string

const (
	// ViewChargesPolicyAllowed ...
	ViewChargesPolicyAllowed ViewChargesPolicy = "Allowed"
	// ViewChargesPolicyNotAllowed ...
	ViewChargesPolicyNotAllowed ViewChargesPolicy = "NotAllowed"
)

// PossibleViewChargesPolicyValues returns an array of possible values for the ViewChargesPolicy const type.
func PossibleViewChargesPolicyValues() []ViewChargesPolicy {
	return []ViewChargesPolicy{ViewChargesPolicyAllowed, ViewChargesPolicyNotAllowed}
}

// Account a billing account.
type Account struct {
	autorest.Response `json:"-"`
	// AccountProperties - The properties of the billing account.
	*AccountProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Account.
func (a Account) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.AccountProperties != nil {
		objectMap["properties"] = a.AccountProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Account struct.
func (a *Account) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var accountProperties AccountProperties
				err = json.Unmarshal(*v, &accountProperties)
				if err != nil {
					return err
				}
				a.AccountProperties = &accountProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		}
	}

	return nil
}

// AccountListResult the list of billing accounts.
type AccountListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of billing accounts.
	Value *[]Account `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// AccountListResultIterator provides access to a complete listing of Account values.
type AccountListResultIterator struct {
	i    int
	page AccountListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AccountListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AccountListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AccountListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AccountListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AccountListResultIterator) Response() AccountListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AccountListResultIterator) Value() Account {
	if !iter.page.NotDone() {
		return Account{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AccountListResultIterator type.
func NewAccountListResultIterator(page AccountListResultPage) AccountListResultIterator {
	return AccountListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (alr AccountListResult) IsEmpty() bool {
	return alr.Value == nil || len(*alr.Value) == 0
}

// accountListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (alr AccountListResult) accountListResultPreparer(ctx context.Context) (*http.Request, error) {
	if alr.NextLink == nil || len(to.String(alr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(alr.NextLink)))
}

// AccountListResultPage contains a page of Account values.
type AccountListResultPage struct {
	fn  func(context.Context, AccountListResult) (AccountListResult, error)
	alr AccountListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AccountListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AccountListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.alr)
	if err != nil {
		return err
	}
	page.alr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AccountListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AccountListResultPage) NotDone() bool {
	return !page.alr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AccountListResultPage) Response() AccountListResult {
	return page.alr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AccountListResultPage) Values() []Account {
	if page.alr.IsEmpty() {
		return nil
	}
	return *page.alr.Value
}

// Creates a new instance of the AccountListResultPage type.
func NewAccountListResultPage(getNextPage func(context.Context, AccountListResult) (AccountListResult, error)) AccountListResultPage {
	return AccountListResultPage{fn: getNextPage}
}

// AccountProperties the properties of the billing account.
type AccountProperties struct {
	// DisplayName - The billing account name.
	DisplayName *string `json:"displayName,omitempty"`
	// SoldTo - The address of the individual or organization that is responsible for the billing account.
	SoldTo *AddressDetails `json:"soldTo,omitempty"`
	// AgreementType - READ-ONLY; The type of agreement. Possible values include: 'MicrosoftCustomerAgreement', 'EnterpriseAgreement', 'MicrosoftOnlineServicesProgram', 'MicrosoftPartnerAgreement'
	AgreementType AgreementType `json:"agreementType,omitempty"`
	// AccountType - READ-ONLY; The type of customer. Possible values include: 'Enterprise', 'Individual', 'Partner'
	AccountType AccountType `json:"accountType,omitempty"`
	// AccountStatus - READ-ONLY; The current status of the billing account. Possible values include: 'Active', 'Deleted', 'Disabled', 'Expired', 'Transferred', 'Extended', 'Terminated'
	AccountStatus AccountStatus `json:"accountStatus,omitempty"`
	// BillingProfiles - The billing profiles associated with the billing account. By default this is not populated, unless it's specified in $expand.
	BillingProfiles *ProfilesOnExpand `json:"billingProfiles,omitempty"`
	// EnrollmentDetails - READ-ONLY; The details about the associated legacy enrollment. By default this is not populated, unless it's specified in $expand.
	EnrollmentDetails *Enrollment `json:"enrollmentDetails,omitempty"`
	// Departments - The departments associated to the enrollment.
	Departments *[]Department `json:"departments,omitempty"`
	// EnrollmentAccounts - The accounts associated to the enrollment.
	EnrollmentAccounts *[]EnrollmentAccount `json:"enrollmentAccounts,omitempty"`
	// HasReadAccess - READ-ONLY; Indicates whether user has read access to the billing account.
	HasReadAccess *bool `json:"hasReadAccess,omitempty"`
}

// AccountsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AccountsUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *AccountsUpdateFuture) Result(client AccountsClient) (a Account, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.AccountsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("billing.AccountsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if a.Response.Response, err = future.GetResult(sender); err == nil && a.Response.Response.StatusCode != http.StatusNoContent {
		a, err = client.UpdateResponder(a.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "billing.AccountsUpdateFuture", "Result", a.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AccountUpdateRequest the request properties of the billing account that can be updated.
type AccountUpdateRequest struct {
	// AccountProperties - A billing property.
	*AccountProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountUpdateRequest.
func (aur AccountUpdateRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aur.AccountProperties != nil {
		objectMap["properties"] = aur.AccountProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AccountUpdateRequest struct.
func (aur *AccountUpdateRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var accountProperties AccountProperties
				err = json.Unmarshal(*v, &accountProperties)
				if err != nil {
					return err
				}
				aur.AccountProperties = &accountProperties
			}
		}
	}

	return nil
}

// AddressDetails address details.
type AddressDetails struct {
	// FirstName - First name.
	FirstName *string `json:"firstName,omitempty"`
	// LastName - Last name.
	LastName *string `json:"lastName,omitempty"`
	// CompanyName - Company name.
	CompanyName *string `json:"companyName,omitempty"`
	// AddressLine1 - Address line 1.
	AddressLine1 *string `json:"addressLine1,omitempty"`
	// AddressLine2 - Address line 2.
	AddressLine2 *string `json:"addressLine2,omitempty"`
	// AddressLine3 - Address line 3.
	AddressLine3 *string `json:"addressLine3,omitempty"`
	// City - Address city.
	City *string `json:"city,omitempty"`
	// District - Address district.
	District *string `json:"district,omitempty"`
	// Region - Address region.
	Region *string `json:"region,omitempty"`
	// Country - Country code uses ISO2, 2-digit format.
	Country *string `json:"country,omitempty"`
	// PostalCode - Postal code.
	PostalCode *string `json:"postalCode,omitempty"`
	// Email - Email address.
	Email *string `json:"email,omitempty"`
	// PhoneNumber - Phone number.
	PhoneNumber *string `json:"phoneNumber,omitempty"`
}

// Agreement an agreement.
type Agreement struct {
	autorest.Response `json:"-"`
	// AgreementProperties - The properties of an agreement.
	*AgreementProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Agreement.
func (a Agreement) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.AgreementProperties != nil {
		objectMap["properties"] = a.AgreementProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Agreement struct.
func (a *Agreement) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var agreementProperties AgreementProperties
				err = json.Unmarshal(*v, &agreementProperties)
				if err != nil {
					return err
				}
				a.AgreementProperties = &agreementProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		}
	}

	return nil
}

// AgreementListResult result of listing agreements.
type AgreementListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of agreements.
	Value *[]Agreement `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// AgreementListResultIterator provides access to a complete listing of Agreement values.
type AgreementListResultIterator struct {
	i    int
	page AgreementListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AgreementListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AgreementListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AgreementListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AgreementListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AgreementListResultIterator) Response() AgreementListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AgreementListResultIterator) Value() Agreement {
	if !iter.page.NotDone() {
		return Agreement{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AgreementListResultIterator type.
func NewAgreementListResultIterator(page AgreementListResultPage) AgreementListResultIterator {
	return AgreementListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (alr AgreementListResult) IsEmpty() bool {
	return alr.Value == nil || len(*alr.Value) == 0
}

// agreementListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (alr AgreementListResult) agreementListResultPreparer(ctx context.Context) (*http.Request, error) {
	if alr.NextLink == nil || len(to.String(alr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(alr.NextLink)))
}

// AgreementListResultPage contains a page of Agreement values.
type AgreementListResultPage struct {
	fn  func(context.Context, AgreementListResult) (AgreementListResult, error)
	alr AgreementListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AgreementListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AgreementListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.alr)
	if err != nil {
		return err
	}
	page.alr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AgreementListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AgreementListResultPage) NotDone() bool {
	return !page.alr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AgreementListResultPage) Response() AgreementListResult {
	return page.alr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AgreementListResultPage) Values() []Agreement {
	if page.alr.IsEmpty() {
		return nil
	}
	return *page.alr.Value
}

// Creates a new instance of the AgreementListResultPage type.
func NewAgreementListResultPage(getNextPage func(context.Context, AgreementListResult) (AgreementListResult, error)) AgreementListResultPage {
	return AgreementListResultPage{fn: getNextPage}
}

// AgreementProperties the properties of an agreement.
type AgreementProperties struct {
	// AgreementLink - READ-ONLY; The URL to download the agreement.
	AgreementLink *string `json:"agreementLink,omitempty"`
	// Category - READ-ONLY; The category of the agreement signed by a customer. Possible values include: 'CategoryMicrosoftCustomerAgreement', 'CategoryAffiliatePurchaseTerms', 'CategoryOther'
	Category Category `json:"category,omitempty"`
	// AcceptanceMode - READ-ONLY; The mode of acceptance for an agreement. Possible values include: 'ClickToAccept', 'ESignEmbedded', 'ESignOffline'
	AcceptanceMode AcceptanceMode `json:"acceptanceMode,omitempty"`
	// EffectiveDate - READ-ONLY; The date from which the agreement is effective.
	EffectiveDate *date.Time `json:"effectiveDate,omitempty"`
	// ExpirationDate - READ-ONLY; The date when the agreement expires.
	ExpirationDate *date.Time `json:"expirationDate,omitempty"`
	// Participants - The list of participants that participates in acceptance of an agreement.
	Participants *[]Participants `json:"participants,omitempty"`
	// Status - READ-ONLY; The current status of the agreement.
	Status *string `json:"status,omitempty"`
}

// Amount the amount.
type Amount struct {
	// Currency - READ-ONLY; The currency for the amount value.
	Currency *string `json:"currency,omitempty"`
	// Value - Amount value.
	Value *float64 `json:"value,omitempty"`
}

// AvailableBalance the latest Azure credit balance. This is the balance available for pay now.
type AvailableBalance struct {
	autorest.Response           `json:"-"`
	*AvailableBalanceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AvailableBalance.
func (ab AvailableBalance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ab.AvailableBalanceProperties != nil {
		objectMap["properties"] = ab.AvailableBalanceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AvailableBalance struct.
func (ab *AvailableBalance) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var availableBalanceProperties AvailableBalanceProperties
				err = json.Unmarshal(*v, &availableBalanceProperties)
				if err != nil {
					return err
				}
				ab.AvailableBalanceProperties = &availableBalanceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ab.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ab.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ab.Type = &typeVar
			}
		}
	}

	return nil
}

// AvailableBalanceProperties the properties of available balance.
type AvailableBalanceProperties struct {
	// Amount - READ-ONLY; Balance amount.
	Amount *Amount `json:"amount,omitempty"`
}

// AzurePlan details of the Azure plan.
type AzurePlan struct {
	// SkuID - The sku id.
	SkuID *string `json:"skuId,omitempty"`
	// SkuDescription - READ-ONLY; The sku description.
	SkuDescription *string `json:"skuDescription,omitempty"`
}

// Customer a partner's customer.
type Customer struct {
	autorest.Response `json:"-"`
	// CustomerProperties - The customer.
	*CustomerProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Customer.
func (c Customer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.CustomerProperties != nil {
		objectMap["properties"] = c.CustomerProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Customer struct.
func (c *Customer) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var customerProperties CustomerProperties
				err = json.Unmarshal(*v, &customerProperties)
				if err != nil {
					return err
				}
				c.CustomerProperties = &customerProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		}
	}

	return nil
}

// CustomerListResult the list of customers.
type CustomerListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of customers.
	Value *[]Customer `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// CustomerListResultIterator provides access to a complete listing of Customer values.
type CustomerListResultIterator struct {
	i    int
	page CustomerListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CustomerListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CustomerListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CustomerListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CustomerListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CustomerListResultIterator) Response() CustomerListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CustomerListResultIterator) Value() Customer {
	if !iter.page.NotDone() {
		return Customer{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CustomerListResultIterator type.
func NewCustomerListResultIterator(page CustomerListResultPage) CustomerListResultIterator {
	return CustomerListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (clr CustomerListResult) IsEmpty() bool {
	return clr.Value == nil || len(*clr.Value) == 0
}

// customerListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (clr CustomerListResult) customerListResultPreparer(ctx context.Context) (*http.Request, error) {
	if clr.NextLink == nil || len(to.String(clr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(clr.NextLink)))
}

// CustomerListResultPage contains a page of Customer values.
type CustomerListResultPage struct {
	fn  func(context.Context, CustomerListResult) (CustomerListResult, error)
	clr CustomerListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CustomerListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CustomerListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.clr)
	if err != nil {
		return err
	}
	page.clr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CustomerListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CustomerListResultPage) NotDone() bool {
	return !page.clr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CustomerListResultPage) Response() CustomerListResult {
	return page.clr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CustomerListResultPage) Values() []Customer {
	if page.clr.IsEmpty() {
		return nil
	}
	return *page.clr.Value
}

// Creates a new instance of the CustomerListResultPage type.
func NewCustomerListResultPage(getNextPage func(context.Context, CustomerListResult) (CustomerListResult, error)) CustomerListResultPage {
	return CustomerListResultPage{fn: getNextPage}
}

// CustomerPolicy the customer's Policy.
type CustomerPolicy struct {
	autorest.Response         `json:"-"`
	*CustomerPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomerPolicy.
func (cp CustomerPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.CustomerPolicyProperties != nil {
		objectMap["properties"] = cp.CustomerPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CustomerPolicy struct.
func (cp *CustomerPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var customerPolicyProperties CustomerPolicyProperties
				err = json.Unmarshal(*v, &customerPolicyProperties)
				if err != nil {
					return err
				}
				cp.CustomerPolicyProperties = &customerPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cp.Type = &typeVar
			}
		}
	}

	return nil
}

// CustomerPolicyProperties the properties of a customer's policy.
type CustomerPolicyProperties struct {
	// ViewCharges - The policy that controls whether the users in customer's organization can view charges at pay-as-you-go prices. Possible values include: 'ViewChargesAllowed', 'ViewChargesNotAllowed'
	ViewCharges ViewCharges `json:"viewCharges,omitempty"`
}

// CustomerProperties the properties of a customer.
type CustomerProperties struct {
	// BillingProfileID - READ-ONLY; The ID of the billing profile for the invoice section.
	BillingProfileID *string `json:"billingProfileId,omitempty"`
	// BillingProfileDisplayName - READ-ONLY; The name of the billing profile for the invoice section.
	BillingProfileDisplayName *string `json:"billingProfileDisplayName,omitempty"`
	// DisplayName - The name of the customer.
	DisplayName *string `json:"displayName,omitempty"`
	// EnabledAzurePlans - Azure plans enabled for the customer.
	EnabledAzurePlans *[]AzurePlan `json:"enabledAzurePlans,omitempty"`
	// Resellers - The list of resellers for which an Azure plan is enabled for the customer.
	Resellers *[]Reseller `json:"resellers,omitempty"`
}

// Department a department.
type Department struct {
	// DepartmentProperties - A department.
	*DepartmentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Department.
func (d Department) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.DepartmentProperties != nil {
		objectMap["properties"] = d.DepartmentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Department struct.
func (d *Department) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var departmentProperties DepartmentProperties
				err = json.Unmarshal(*v, &departmentProperties)
				if err != nil {
					return err
				}
				d.DepartmentProperties = &departmentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d.Type = &typeVar
			}
		}
	}

	return nil
}

// DepartmentProperties the properties of a department.
type DepartmentProperties struct {
	// DepartmentName - The name of the department.
	DepartmentName *string `json:"departmentName,omitempty"`
	// CostCenter - The cost center associated with the department.
	CostCenter *string `json:"costCenter,omitempty"`
	// Status - The status of the department.
	Status *string `json:"status,omitempty"`
	// EnrollmentAccounts - Associated enrollment accounts. By default this is not populated, unless it's specified in $expand.
	EnrollmentAccounts *[]EnrollmentAccount `json:"enrollmentAccounts,omitempty"`
}

// Document the properties of a document.
type Document struct {
	// Kind - READ-ONLY; The type of the document. Possible values include: 'DocumentTypeInvoice', 'DocumentTypeVoidNote', 'DocumentTypeTaxReceipt', 'DocumentTypeCreditNote'
	Kind DocumentType `json:"kind,omitempty"`
	// URL - READ-ONLY; Document URL.
	URL *string `json:"url,omitempty"`
	// Source - READ-ONLY; The source of the document. ENF for Brazil and DRS for rest of the world. Possible values include: 'DRS', 'ENF'
	Source DocumentSource `json:"source,omitempty"`
}

// DownloadURL a secure URL that can be used to download a an entity until the URL expires.
type DownloadURL struct {
	autorest.Response `json:"-"`
	// ExpiryTime - READ-ONLY; The time in UTC when the download URL will expire.
	ExpiryTime *date.Time `json:"expiryTime,omitempty"`
	// URL - READ-ONLY; The URL to the PDF file.
	URL *string `json:"url,omitempty"`
}

// Enrollment the properties of an enrollment.
type Enrollment struct {
	// StartDate - The start date of the enrollment.
	StartDate *date.Time `json:"startDate,omitempty"`
	// EndDate - The end date of the enrollment.
	EndDate *date.Time `json:"endDate,omitempty"`
	// Currency - READ-ONLY; The billing currency for the enrollment.
	Currency *string `json:"currency,omitempty"`
	// Channel - READ-ONLY; The channel type of the enrollment.
	Channel *string `json:"channel,omitempty"`
	// Policies - READ-ONLY; The policies for Enterprise Agreement enrollments.
	Policies *EnrollmentPolicies `json:"policies,omitempty"`
	// Language - READ-ONLY; The language for the enrollment.
	Language *string `json:"language,omitempty"`
	// CountryCode - READ-ONLY; The country code of the enrollment.
	CountryCode *string `json:"countryCode,omitempty"`
	// Status - READ-ONLY; The current status of the enrollment.
	Status *string `json:"status,omitempty"`
	// BillingCycle - READ-ONLY; The billing cycle for the enrollment.
	BillingCycle *string `json:"billingCycle,omitempty"`
}

// EnrollmentAccount an enrollment account.
type EnrollmentAccount struct {
	// EnrollmentAccountProperties - The properties of an enrollment account.
	*EnrollmentAccountProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EnrollmentAccount.
func (ea EnrollmentAccount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ea.EnrollmentAccountProperties != nil {
		objectMap["properties"] = ea.EnrollmentAccountProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EnrollmentAccount struct.
func (ea *EnrollmentAccount) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var enrollmentAccountProperties EnrollmentAccountProperties
				err = json.Unmarshal(*v, &enrollmentAccountProperties)
				if err != nil {
					return err
				}
				ea.EnrollmentAccountProperties = &enrollmentAccountProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ea.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ea.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ea.Type = &typeVar
			}
		}
	}

	return nil
}

// EnrollmentAccountContext the enrollment account context
type EnrollmentAccountContext struct {
	// CostCenter - The cost center associated with the enrollment account.
	CostCenter *string `json:"costCenter,omitempty"`
	// StartDate - The start date of the enrollment account.
	StartDate *date.Time `json:"startDate,omitempty"`
	// EndDate - The end date of the enrollment account.
	EndDate *date.Time `json:"endDate,omitempty"`
	// EnrollmentAccountName - The ID of the enrollment account.
	EnrollmentAccountName *string `json:"enrollmentAccountName,omitempty"`
}

// EnrollmentAccountProperties the properties of an enrollment account.
type EnrollmentAccountProperties struct {
	// AccountName - The name of the enrollment account.
	AccountName *string `json:"accountName,omitempty"`
	// CostCenter - The cost center associated with the enrollment account.
	CostCenter *string `json:"costCenter,omitempty"`
	// AccountOwner - The owner of the enrollment account.
	AccountOwner *string `json:"accountOwner,omitempty"`
	// Status - The status of the enrollment account.
	Status *string `json:"status,omitempty"`
	// StartDate - The start date of the enrollment account.
	StartDate *date.Time `json:"startDate,omitempty"`
	// EndDate - The end date of the enrollment account.
	EndDate *date.Time `json:"endDate,omitempty"`
	// Department - Associated department. By default this is not populated, unless it's specified in $expand.
	Department *Department `json:"department,omitempty"`
}

// EnrollmentPolicies the policies for Enterprise Agreement enrollments.
type EnrollmentPolicies struct {
	// AccountOwnerViewCharges - READ-ONLY; The policy that controls whether Account Owners can view charges.
	AccountOwnerViewCharges *bool `json:"accountOwnerViewCharges,omitempty"`
	// DepartmentAdminViewCharges - READ-ONLY; The policy that controls whether Department Administrators can view charges.
	DepartmentAdminViewCharges *bool `json:"departmentAdminViewCharges,omitempty"`
	// MarketplacesEnabled - READ-ONLY; The policy that controls whether Azure marketplace purchases are allowed in the enrollment.
	MarketplacesEnabled *bool `json:"marketplacesEnabled,omitempty"`
	// ReservedInstancesEnabled - READ-ONLY; The policy that controls whether Azure reservation purchases are allowed in the enrollment.
	ReservedInstancesEnabled *bool `json:"reservedInstancesEnabled,omitempty"`
}

// ErrorDetails the details of the error.
type ErrorDetails struct {
	// Code - READ-ONLY; Error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The target of the particular error.
	Target *string `json:"target,omitempty"`
}

// ErrorResponse error response indicates that the service is not able to process the incoming request. The
// reason is provided in the error message.
type ErrorResponse struct {
	// Error - The details of the error.
	Error *ErrorDetails `json:"error,omitempty"`
}

// Instruction an instruction.
type Instruction struct {
	autorest.Response `json:"-"`
	// InstructionProperties - A billing instruction used during invoice generation.
	*InstructionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Instruction.
func (i Instruction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.InstructionProperties != nil {
		objectMap["properties"] = i.InstructionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Instruction struct.
func (i *Instruction) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var instructionProperties InstructionProperties
				err = json.Unmarshal(*v, &instructionProperties)
				if err != nil {
					return err
				}
				i.InstructionProperties = &instructionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				i.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				i.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				i.Type = &typeVar
			}
		}
	}

	return nil
}

// InstructionListResult the list of billing instructions used during invoice generation.
type InstructionListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of billing instructions used during invoice generation.
	Value *[]Instruction `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// InstructionListResultIterator provides access to a complete listing of Instruction values.
type InstructionListResultIterator struct {
	i    int
	page InstructionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *InstructionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InstructionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *InstructionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter InstructionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter InstructionListResultIterator) Response() InstructionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter InstructionListResultIterator) Value() Instruction {
	if !iter.page.NotDone() {
		return Instruction{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the InstructionListResultIterator type.
func NewInstructionListResultIterator(page InstructionListResultPage) InstructionListResultIterator {
	return InstructionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ilr InstructionListResult) IsEmpty() bool {
	return ilr.Value == nil || len(*ilr.Value) == 0
}

// instructionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ilr InstructionListResult) instructionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if ilr.NextLink == nil || len(to.String(ilr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ilr.NextLink)))
}

// InstructionListResultPage contains a page of Instruction values.
type InstructionListResultPage struct {
	fn  func(context.Context, InstructionListResult) (InstructionListResult, error)
	ilr InstructionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *InstructionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InstructionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ilr)
	if err != nil {
		return err
	}
	page.ilr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *InstructionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page InstructionListResultPage) NotDone() bool {
	return !page.ilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page InstructionListResultPage) Response() InstructionListResult {
	return page.ilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page InstructionListResultPage) Values() []Instruction {
	if page.ilr.IsEmpty() {
		return nil
	}
	return *page.ilr.Value
}

// Creates a new instance of the InstructionListResultPage type.
func NewInstructionListResultPage(getNextPage func(context.Context, InstructionListResult) (InstructionListResult, error)) InstructionListResultPage {
	return InstructionListResultPage{fn: getNextPage}
}

// InstructionProperties a billing instruction used during invoice generation.
type InstructionProperties struct {
	// Amount - The amount budgeted for this billing instruction.
	Amount *float64 `json:"amount,omitempty"`
	// StartDate - The date this billing instruction goes into effect.
	StartDate *date.Time `json:"startDate,omitempty"`
	// EndDate - The date this billing instruction is no longer in effect.
	EndDate *date.Time `json:"endDate,omitempty"`
	// CreationDate - The date this billing instruction was created.
	CreationDate *date.Time `json:"creationDate,omitempty"`
}

// Invoice an invoice.
type Invoice struct {
	autorest.Response `json:"-"`
	// InvoiceProperties - An invoice.
	*InvoiceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Invoice.
func (i Invoice) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.InvoiceProperties != nil {
		objectMap["properties"] = i.InvoiceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Invoice struct.
func (i *Invoice) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var invoiceProperties InvoiceProperties
				err = json.Unmarshal(*v, &invoiceProperties)
				if err != nil {
					return err
				}
				i.InvoiceProperties = &invoiceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				i.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				i.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				i.Type = &typeVar
			}
		}
	}

	return nil
}

// InvoiceListResult the list of invoices.
type InvoiceListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of invoices.
	Value *[]Invoice `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// InvoiceListResultIterator provides access to a complete listing of Invoice values.
type InvoiceListResultIterator struct {
	i    int
	page InvoiceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *InvoiceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InvoiceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *InvoiceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter InvoiceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter InvoiceListResultIterator) Response() InvoiceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter InvoiceListResultIterator) Value() Invoice {
	if !iter.page.NotDone() {
		return Invoice{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the InvoiceListResultIterator type.
func NewInvoiceListResultIterator(page InvoiceListResultPage) InvoiceListResultIterator {
	return InvoiceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ilr InvoiceListResult) IsEmpty() bool {
	return ilr.Value == nil || len(*ilr.Value) == 0
}

// invoiceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ilr InvoiceListResult) invoiceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if ilr.NextLink == nil || len(to.String(ilr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ilr.NextLink)))
}

// InvoiceListResultPage contains a page of Invoice values.
type InvoiceListResultPage struct {
	fn  func(context.Context, InvoiceListResult) (InvoiceListResult, error)
	ilr InvoiceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *InvoiceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InvoiceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ilr)
	if err != nil {
		return err
	}
	page.ilr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *InvoiceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page InvoiceListResultPage) NotDone() bool {
	return !page.ilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page InvoiceListResultPage) Response() InvoiceListResult {
	return page.ilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page InvoiceListResultPage) Values() []Invoice {
	if page.ilr.IsEmpty() {
		return nil
	}
	return *page.ilr.Value
}

// Creates a new instance of the InvoiceListResultPage type.
func NewInvoiceListResultPage(getNextPage func(context.Context, InvoiceListResult) (InvoiceListResult, error)) InvoiceListResultPage {
	return InvoiceListResultPage{fn: getNextPage}
}

// InvoiceProperties the properties of the invoice.
type InvoiceProperties struct {
	// DueDate - READ-ONLY; The due date for the invoice.
	DueDate *date.Time `json:"dueDate,omitempty"`
	// InvoiceDate - READ-ONLY; The date when the invoice was generated.
	InvoiceDate *date.Time `json:"invoiceDate,omitempty"`
	// Status - READ-ONLY; The current status of the invoice. Possible values include: 'Due', 'OverDue', 'Paid'
	Status InvoiceStatus `json:"status,omitempty"`
	// AmountDue - READ-ONLY; The amount due as of now.
	AmountDue *Amount `json:"amountDue,omitempty"`
	// AzurePrepaymentApplied - READ-ONLY; The amount of Azure prepayment applied to the charges. This field is applicable to billing accounts with agreement type Microsoft Customer Agreement.
	AzurePrepaymentApplied *Amount `json:"azurePrepaymentApplied,omitempty"`
	// BilledAmount - READ-ONLY; The total charges for the invoice billing period.
	BilledAmount *Amount `json:"billedAmount,omitempty"`
	// CreditAmount - READ-ONLY; The total refund for returns and cancellations during the invoice billing period. This field is applicable to billing accounts with agreement type Microsoft Customer Agreement.
	CreditAmount *Amount `json:"creditAmount,omitempty"`
	// FreeAzureCreditApplied - READ-ONLY; The amount of free Azure credits applied to the charges. This field is applicable to billing accounts with agreement type Microsoft Customer Agreement.
	FreeAzureCreditApplied *Amount `json:"freeAzureCreditApplied,omitempty"`
	// SubTotal - READ-ONLY; The pre-tax amount due. This field is applicable to billing accounts with agreement type Microsoft Customer Agreement.
	SubTotal *Amount `json:"subTotal,omitempty"`
	// TaxAmount - READ-ONLY; The amount of tax charged for the billing period. This field is applicable to billing accounts with agreement type Microsoft Customer Agreement.
	TaxAmount *Amount `json:"taxAmount,omitempty"`
	// TotalAmount - READ-ONLY; The amount due when the invoice was generated. This field is applicable to billing accounts with agreement type Microsoft Customer Agreement.
	TotalAmount *Amount `json:"totalAmount,omitempty"`
	// InvoicePeriodStartDate - READ-ONLY; The start date of the billing period for which the invoice is generated.
	InvoicePeriodStartDate *date.Time `json:"invoicePeriodStartDate,omitempty"`
	// InvoicePeriodEndDate - READ-ONLY; The end date of the billing period for which the invoice is generated.
	InvoicePeriodEndDate *date.Time `json:"invoicePeriodEndDate,omitempty"`
	// InvoiceType - READ-ONLY; Invoice type. Possible values include: 'AzureService', 'AzureMarketplace', 'AzureSupport'
	InvoiceType InvoiceType `json:"invoiceType,omitempty"`
	// IsMonthlyInvoice - READ-ONLY; Specifies if the invoice is generated as part of monthly invoicing cycle or not. This field is applicable to billing accounts with agreement type Microsoft Customer Agreement.
	IsMonthlyInvoice *bool `json:"isMonthlyInvoice,omitempty"`
	// BillingProfileID - READ-ONLY; The ID of the billing profile for which the invoice is generated.
	BillingProfileID *string `json:"billingProfileId,omitempty"`
	// BillingProfileDisplayName - READ-ONLY; The name of the billing profile for which the invoice is generated.
	BillingProfileDisplayName *string `json:"billingProfileDisplayName,omitempty"`
	// PurchaseOrderNumber - READ-ONLY; An optional purchase order number for the invoice.
	PurchaseOrderNumber *string `json:"purchaseOrderNumber,omitempty"`
	// Documents - READ-ONLY; List of documents available to download such as invoice and tax receipt.
	Documents *[]Document `json:"documents,omitempty"`
	// Payments - READ-ONLY; List of payments.
	Payments *[]PaymentProperties `json:"payments,omitempty"`
	// SubscriptionID - READ-ONLY; The ID of the subscription for which the invoice is generated.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
}

// InvoicesDownloadBillingSubscriptionInvoiceFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type InvoicesDownloadBillingSubscriptionInvoiceFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *InvoicesDownloadBillingSubscriptionInvoiceFuture) Result(client InvoicesClient) (du DownloadURL, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.InvoicesDownloadBillingSubscriptionInvoiceFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("billing.InvoicesDownloadBillingSubscriptionInvoiceFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if du.Response.Response, err = future.GetResult(sender); err == nil && du.Response.Response.StatusCode != http.StatusNoContent {
		du, err = client.DownloadBillingSubscriptionInvoiceResponder(du.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "billing.InvoicesDownloadBillingSubscriptionInvoiceFuture", "Result", du.Response.Response, "Failure responding to request")
		}
	}
	return
}

// InvoicesDownloadInvoiceFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type InvoicesDownloadInvoiceFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *InvoicesDownloadInvoiceFuture) Result(client InvoicesClient) (du DownloadURL, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.InvoicesDownloadInvoiceFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("billing.InvoicesDownloadInvoiceFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if du.Response.Response, err = future.GetResult(sender); err == nil && du.Response.Response.StatusCode != http.StatusNoContent {
		du, err = client.DownloadInvoiceResponder(du.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "billing.InvoicesDownloadInvoiceFuture", "Result", du.Response.Response, "Failure responding to request")
		}
	}
	return
}

// InvoiceSection an invoice section.
type InvoiceSection struct {
	autorest.Response `json:"-"`
	// InvoiceSectionProperties - The properties of an invoice section.
	*InvoiceSectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for InvoiceSection.
func (is InvoiceSection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if is.InvoiceSectionProperties != nil {
		objectMap["properties"] = is.InvoiceSectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InvoiceSection struct.
func (is *InvoiceSection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var invoiceSectionProperties InvoiceSectionProperties
				err = json.Unmarshal(*v, &invoiceSectionProperties)
				if err != nil {
					return err
				}
				is.InvoiceSectionProperties = &invoiceSectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				is.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				is.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				is.Type = &typeVar
			}
		}
	}

	return nil
}

// InvoiceSectionCreationRequest the properties of the invoice section.
type InvoiceSectionCreationRequest struct {
	// DisplayName - The name of the invoice section.
	DisplayName *string `json:"displayName,omitempty"`
}

// InvoiceSectionListResult the list of invoice sections.
type InvoiceSectionListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of invoice sections.
	Value *[]InvoiceSection `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// InvoiceSectionListResultIterator provides access to a complete listing of InvoiceSection values.
type InvoiceSectionListResultIterator struct {
	i    int
	page InvoiceSectionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *InvoiceSectionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InvoiceSectionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *InvoiceSectionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter InvoiceSectionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter InvoiceSectionListResultIterator) Response() InvoiceSectionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter InvoiceSectionListResultIterator) Value() InvoiceSection {
	if !iter.page.NotDone() {
		return InvoiceSection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the InvoiceSectionListResultIterator type.
func NewInvoiceSectionListResultIterator(page InvoiceSectionListResultPage) InvoiceSectionListResultIterator {
	return InvoiceSectionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (islr InvoiceSectionListResult) IsEmpty() bool {
	return islr.Value == nil || len(*islr.Value) == 0
}

// invoiceSectionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (islr InvoiceSectionListResult) invoiceSectionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if islr.NextLink == nil || len(to.String(islr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(islr.NextLink)))
}

// InvoiceSectionListResultPage contains a page of InvoiceSection values.
type InvoiceSectionListResultPage struct {
	fn   func(context.Context, InvoiceSectionListResult) (InvoiceSectionListResult, error)
	islr InvoiceSectionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *InvoiceSectionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InvoiceSectionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.islr)
	if err != nil {
		return err
	}
	page.islr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *InvoiceSectionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page InvoiceSectionListResultPage) NotDone() bool {
	return !page.islr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page InvoiceSectionListResultPage) Response() InvoiceSectionListResult {
	return page.islr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page InvoiceSectionListResultPage) Values() []InvoiceSection {
	if page.islr.IsEmpty() {
		return nil
	}
	return *page.islr.Value
}

// Creates a new instance of the InvoiceSectionListResultPage type.
func NewInvoiceSectionListResultPage(getNextPage func(context.Context, InvoiceSectionListResult) (InvoiceSectionListResult, error)) InvoiceSectionListResultPage {
	return InvoiceSectionListResultPage{fn: getNextPage}
}

// InvoiceSectionListWithCreateSubPermissionResult the list of invoice section properties with create
// subscription permission.
type InvoiceSectionListWithCreateSubPermissionResult struct {
	autorest.Response `json:"-"`
	// Value - The list of invoice section properties with create subscription permission.
	Value *[]InvoiceSectionWithCreateSubPermission `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// InvoiceSectionListWithCreateSubPermissionResultIterator provides access to a complete listing of
// InvoiceSectionWithCreateSubPermission values.
type InvoiceSectionListWithCreateSubPermissionResultIterator struct {
	i    int
	page InvoiceSectionListWithCreateSubPermissionResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *InvoiceSectionListWithCreateSubPermissionResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InvoiceSectionListWithCreateSubPermissionResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *InvoiceSectionListWithCreateSubPermissionResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter InvoiceSectionListWithCreateSubPermissionResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter InvoiceSectionListWithCreateSubPermissionResultIterator) Response() InvoiceSectionListWithCreateSubPermissionResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter InvoiceSectionListWithCreateSubPermissionResultIterator) Value() InvoiceSectionWithCreateSubPermission {
	if !iter.page.NotDone() {
		return InvoiceSectionWithCreateSubPermission{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the InvoiceSectionListWithCreateSubPermissionResultIterator type.
func NewInvoiceSectionListWithCreateSubPermissionResultIterator(page InvoiceSectionListWithCreateSubPermissionResultPage) InvoiceSectionListWithCreateSubPermissionResultIterator {
	return InvoiceSectionListWithCreateSubPermissionResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (islwcspr InvoiceSectionListWithCreateSubPermissionResult) IsEmpty() bool {
	return islwcspr.Value == nil || len(*islwcspr.Value) == 0
}

// invoiceSectionListWithCreateSubPermissionResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (islwcspr InvoiceSectionListWithCreateSubPermissionResult) invoiceSectionListWithCreateSubPermissionResultPreparer(ctx context.Context) (*http.Request, error) {
	if islwcspr.NextLink == nil || len(to.String(islwcspr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(islwcspr.NextLink)))
}

// InvoiceSectionListWithCreateSubPermissionResultPage contains a page of
// InvoiceSectionWithCreateSubPermission values.
type InvoiceSectionListWithCreateSubPermissionResultPage struct {
	fn       func(context.Context, InvoiceSectionListWithCreateSubPermissionResult) (InvoiceSectionListWithCreateSubPermissionResult, error)
	islwcspr InvoiceSectionListWithCreateSubPermissionResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *InvoiceSectionListWithCreateSubPermissionResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InvoiceSectionListWithCreateSubPermissionResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.islwcspr)
	if err != nil {
		return err
	}
	page.islwcspr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *InvoiceSectionListWithCreateSubPermissionResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page InvoiceSectionListWithCreateSubPermissionResultPage) NotDone() bool {
	return !page.islwcspr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page InvoiceSectionListWithCreateSubPermissionResultPage) Response() InvoiceSectionListWithCreateSubPermissionResult {
	return page.islwcspr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page InvoiceSectionListWithCreateSubPermissionResultPage) Values() []InvoiceSectionWithCreateSubPermission {
	if page.islwcspr.IsEmpty() {
		return nil
	}
	return *page.islwcspr.Value
}

// Creates a new instance of the InvoiceSectionListWithCreateSubPermissionResultPage type.
func NewInvoiceSectionListWithCreateSubPermissionResultPage(getNextPage func(context.Context, InvoiceSectionListWithCreateSubPermissionResult) (InvoiceSectionListWithCreateSubPermissionResult, error)) InvoiceSectionListWithCreateSubPermissionResultPage {
	return InvoiceSectionListWithCreateSubPermissionResultPage{fn: getNextPage}
}

// InvoiceSectionProperties the properties of an invoice section.
type InvoiceSectionProperties struct {
	// DisplayName - The name of the invoice section.
	DisplayName *string `json:"displayName,omitempty"`
	// Labels - Dictionary of metadata associated with the invoice section.
	Labels map[string]*string `json:"labels"`
	// SystemID - READ-ONLY; The system generated unique identifier for an invoice section.
	SystemID *string `json:"systemId,omitempty"`
}

// MarshalJSON is the custom marshaler for InvoiceSectionProperties.
func (isp InvoiceSectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if isp.DisplayName != nil {
		objectMap["displayName"] = isp.DisplayName
	}
	if isp.Labels != nil {
		objectMap["labels"] = isp.Labels
	}
	return json.Marshal(objectMap)
}

// InvoiceSectionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type InvoiceSectionsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *InvoiceSectionsCreateOrUpdateFuture) Result(client InvoiceSectionsClient) (is InvoiceSection, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.InvoiceSectionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("billing.InvoiceSectionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if is.Response.Response, err = future.GetResult(sender); err == nil && is.Response.Response.StatusCode != http.StatusNoContent {
		is, err = client.CreateOrUpdateResponder(is.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "billing.InvoiceSectionsCreateOrUpdateFuture", "Result", is.Response.Response, "Failure responding to request")
		}
	}
	return
}

// InvoiceSectionsOnExpand the invoice sections associated to the billing profile. By default this is not
// populated, unless it's specified in $expand.
type InvoiceSectionsOnExpand struct {
	// HasMoreResults - READ-ONLY; Indicates whether there are more invoice sections than the ones listed in this collection. The collection lists a maximum of 50 invoice sections. To get all invoice sections, use the list invoice sections API.
	HasMoreResults *bool `json:"hasMoreResults,omitempty"`
	// Value - The invoice sections associated to the billing profile.
	Value *[]InvoiceSection `json:"value,omitempty"`
}

// InvoiceSectionWithCreateSubPermission invoice section properties with create subscription permission.
type InvoiceSectionWithCreateSubPermission struct {
	// InvoiceSectionID - READ-ONLY; The ID of the invoice section.
	InvoiceSectionID *string `json:"invoiceSectionId,omitempty"`
	// InvoiceSectionDisplayName - READ-ONLY; The name of the invoice section.
	InvoiceSectionDisplayName *string `json:"invoiceSectionDisplayName,omitempty"`
	// InvoiceSectionSystemID - READ-ONLY; The system generated unique identifier for an invoice section.
	InvoiceSectionSystemID *string `json:"invoiceSectionSystemId,omitempty"`
	// BillingProfileID - READ-ONLY; The ID of the billing profile for the invoice section.
	BillingProfileID *string `json:"billingProfileId,omitempty"`
	// BillingProfileDisplayName - READ-ONLY; The name of the billing profile for the invoice section.
	BillingProfileDisplayName *string `json:"billingProfileDisplayName,omitempty"`
	// BillingProfileStatus - READ-ONLY; The status of the billing profile. Possible values include: 'ProfileStatusActive', 'ProfileStatusDisabled', 'ProfileStatusWarned'
	BillingProfileStatus ProfileStatus `json:"billingProfileStatus,omitempty"`
	// BillingProfileStatusReasonCode - READ-ONLY; Reason for the specified billing profile status. Possible values include: 'StatusReasonCodeForBillingProfilePastDue', 'StatusReasonCodeForBillingProfileSpendingLimitReached', 'StatusReasonCodeForBillingProfileSpendingLimitExpired'
	BillingProfileStatusReasonCode StatusReasonCodeForBillingProfile `json:"billingProfileStatusReasonCode,omitempty"`
	// BillingProfileSpendingLimit - READ-ONLY; The billing profile spending limit. Possible values include: 'SpendingLimitForBillingProfileOff', 'SpendingLimitForBillingProfileOn'
	BillingProfileSpendingLimit SpendingLimitForBillingProfile `json:"billingProfileSpendingLimit,omitempty"`
	// BillingProfileSystemID - READ-ONLY; The system generated unique identifier for a billing profile.
	BillingProfileSystemID *string `json:"billingProfileSystemId,omitempty"`
	// EnabledAzurePlans - Enabled azure plans for the associated billing profile.
	EnabledAzurePlans *[]AzurePlan `json:"enabledAzurePlans,omitempty"`
}

// Operation a Billing REST API operation.
type Operation struct {
	// Name - READ-ONLY; Operation name: {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - READ-ONLY; Service provider: Microsoft.Billing.
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; Resource on which the operation is performed such as invoice and billing subscription.
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; Operation type such as read, write and delete.
	Operation *string `json:"operation,omitempty"`
}

// OperationListResult the list of billing operations and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of billing operations supported by the Microsoft.Billing resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if olr.NextLink == nil || len(to.String(olr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.olr)
	if err != nil {
		return err
	}
	page.olr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{fn: getNextPage}
}

// Participants the details about a participant.
type Participants struct {
	// Status - READ-ONLY; The acceptance status of the participant.
	Status *string `json:"status,omitempty"`
	// StatusDate - READ-ONLY; The date when the status got changed.
	StatusDate *date.Time `json:"statusDate,omitempty"`
	// Email - READ-ONLY; The email address of the participant.
	Email *string `json:"email,omitempty"`
}

// PaymentProperties the properties of a payment.
type PaymentProperties struct {
	// PaymentType - READ-ONLY; The type of payment.
	PaymentType *string `json:"paymentType,omitempty"`
	// Amount - READ-ONLY; The paid amount.
	Amount *Amount `json:"amount,omitempty"`
	// Date - READ-ONLY; The date when the payment was made.
	Date *date.Time `json:"date,omitempty"`
	// PaymentMethodFamily - The family of payment method. Possible values include: 'Credits', 'CheckWire', 'CreditCard', 'None'
	PaymentMethodFamily PaymentMethodFamily `json:"paymentMethodFamily,omitempty"`
	// PaymentMethodType - READ-ONLY; The type of payment method.
	PaymentMethodType *string `json:"paymentMethodType,omitempty"`
}

// PermissionsListResult result of list billingPermissions a caller has on a billing account.
type PermissionsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of billingPermissions a caller has on a billing account.
	Value *[]PermissionsProperties `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// PermissionsListResultIterator provides access to a complete listing of PermissionsProperties values.
type PermissionsListResultIterator struct {
	i    int
	page PermissionsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PermissionsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PermissionsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PermissionsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PermissionsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PermissionsListResultIterator) Response() PermissionsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PermissionsListResultIterator) Value() PermissionsProperties {
	if !iter.page.NotDone() {
		return PermissionsProperties{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PermissionsListResultIterator type.
func NewPermissionsListResultIterator(page PermissionsListResultPage) PermissionsListResultIterator {
	return PermissionsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (plr PermissionsListResult) IsEmpty() bool {
	return plr.Value == nil || len(*plr.Value) == 0
}

// permissionsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plr PermissionsListResult) permissionsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if plr.NextLink == nil || len(to.String(plr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plr.NextLink)))
}

// PermissionsListResultPage contains a page of PermissionsProperties values.
type PermissionsListResultPage struct {
	fn  func(context.Context, PermissionsListResult) (PermissionsListResult, error)
	plr PermissionsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PermissionsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PermissionsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.plr)
	if err != nil {
		return err
	}
	page.plr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PermissionsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PermissionsListResultPage) NotDone() bool {
	return !page.plr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PermissionsListResultPage) Response() PermissionsListResult {
	return page.plr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PermissionsListResultPage) Values() []PermissionsProperties {
	if page.plr.IsEmpty() {
		return nil
	}
	return *page.plr.Value
}

// Creates a new instance of the PermissionsListResultPage type.
func NewPermissionsListResultPage(getNextPage func(context.Context, PermissionsListResult) (PermissionsListResult, error)) PermissionsListResultPage {
	return PermissionsListResultPage{fn: getNextPage}
}

// PermissionsProperties the set of allowed action and not allowed actions a caller has on a billing
// account
type PermissionsProperties struct {
	// Actions - READ-ONLY; The set of actions that the caller is allowed to perform.
	Actions *[]string `json:"actions,omitempty"`
	// NotActions - READ-ONLY; The set of actions that the caller is not allowed to perform.
	NotActions *[]string `json:"notActions,omitempty"`
}

// Policy a policy.
type Policy struct {
	autorest.Response `json:"-"`
	*PolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Policy.
func (p Policy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.PolicyProperties != nil {
		objectMap["properties"] = p.PolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Policy struct.
func (p *Policy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var policyProperties PolicyProperties
				err = json.Unmarshal(*v, &policyProperties)
				if err != nil {
					return err
				}
				p.PolicyProperties = &policyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				p.Type = &typeVar
			}
		}
	}

	return nil
}

// PolicyProperties the properties of a policy.
type PolicyProperties struct {
	// MarketplacePurchases - The policy that controls whether Azure marketplace purchases are allowed for a billing profile. Possible values include: 'AllAllowed', 'OnlyFreeAllowed', 'NotAllowed'
	MarketplacePurchases MarketplacePurchasesPolicy `json:"marketplacePurchases,omitempty"`
	// ReservationPurchases - The policy that controls whether Azure reservation purchases are allowed for a billing profile. Possible values include: 'ReservationPurchasesPolicyAllowed', 'ReservationPurchasesPolicyNotAllowed'
	ReservationPurchases ReservationPurchasesPolicy `json:"reservationPurchases,omitempty"`
	// ViewCharges - The policy that controls whether users with Azure RBAC access to a subscription can view its charges. Possible values include: 'ViewChargesPolicyAllowed', 'ViewChargesPolicyNotAllowed'
	ViewCharges ViewChargesPolicy `json:"viewCharges,omitempty"`
}

// Product a product.
type Product struct {
	autorest.Response  `json:"-"`
	*ProductProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Product.
func (p Product) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.ProductProperties != nil {
		objectMap["properties"] = p.ProductProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Product struct.
func (p *Product) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var productProperties ProductProperties
				err = json.Unmarshal(*v, &productProperties)
				if err != nil {
					return err
				}
				p.ProductProperties = &productProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				p.Type = &typeVar
			}
		}
	}

	return nil
}

// ProductProperties the properties of a product.
type ProductProperties struct {
	// AutoRenew - Indicates whether auto renewal is turned on or off for a product. Possible values include: 'Off', 'On'
	AutoRenew AutoRenew `json:"autoRenew,omitempty"`
	// DisplayName - READ-ONLY; The display name of the product.
	DisplayName *string `json:"displayName,omitempty"`
	// PurchaseDate - READ-ONLY; The date when the product was purchased.
	PurchaseDate *date.Time `json:"purchaseDate,omitempty"`
	// ProductTypeID - READ-ONLY; The ID of the type of product.
	ProductTypeID *string `json:"productTypeId,omitempty"`
	// ProductType - READ-ONLY; The description of the type of product.
	ProductType *string `json:"productType,omitempty"`
	// Status - The current status of the product. Possible values include: 'ProductStatusTypeActive', 'ProductStatusTypeInactive', 'ProductStatusTypePastDue', 'ProductStatusTypeExpiring', 'ProductStatusTypeExpired', 'ProductStatusTypeDisabled', 'ProductStatusTypeCancelled', 'ProductStatusTypeAutoRenew'
	Status ProductStatusType `json:"status,omitempty"`
	// EndDate - READ-ONLY; The date when the product will be renewed or canceled.
	EndDate *date.Time `json:"endDate,omitempty"`
	// BillingFrequency - The frequency at which the product will be billed. Possible values include: 'OneTime', 'Monthly', 'UsageBased'
	BillingFrequency Frequency `json:"billingFrequency,omitempty"`
	// LastCharge - READ-ONLY; The last month charges.
	LastCharge *Amount `json:"lastCharge,omitempty"`
	// LastChargeDate - READ-ONLY; The date of the last charge.
	LastChargeDate *date.Time `json:"lastChargeDate,omitempty"`
	// Quantity - READ-ONLY; The quantity purchased for the product.
	Quantity *float64 `json:"quantity,omitempty"`
	// SkuID - READ-ONLY; The sku ID of the product.
	SkuID *string `json:"skuId,omitempty"`
	// SkuDescription - READ-ONLY; The sku description of the product.
	SkuDescription *string `json:"skuDescription,omitempty"`
	// TenantID - READ-ONLY; The id of the tenant in which the product is used.
	TenantID *string `json:"tenantId,omitempty"`
	// AvailabilityID - READ-ONLY; The availability of the product.
	AvailabilityID *string `json:"availabilityId,omitempty"`
	// InvoiceSectionID - READ-ONLY; The ID of the invoice section to which the product is billed.
	InvoiceSectionID *string `json:"invoiceSectionId,omitempty"`
	// InvoiceSectionDisplayName - READ-ONLY; The name of the invoice section to which the product is billed.
	InvoiceSectionDisplayName *string `json:"invoiceSectionDisplayName,omitempty"`
	// BillingProfileID - READ-ONLY; The ID of the billing profile to which the product is billed.
	BillingProfileID *string `json:"billingProfileId,omitempty"`
	// BillingProfileDisplayName - READ-ONLY; The name of the billing profile to which the product is billed.
	BillingProfileDisplayName *string `json:"billingProfileDisplayName,omitempty"`
	// CustomerID - READ-ONLY; The ID of the customer for whom the product was purchased. The field is applicable only for Microsoft Partner Agreement billing account.
	CustomerID *string `json:"customerId,omitempty"`
	// CustomerDisplayName - READ-ONLY; The name of the customer for whom the product was purchased. The field is applicable only for Microsoft Partner Agreement billing account.
	CustomerDisplayName *string `json:"customerDisplayName,omitempty"`
	// Reseller - READ-ONLY; Reseller for this product.
	Reseller *Reseller `json:"reseller,omitempty"`
}

// ProductsListResult the list of products. It contains a list of available product summaries in reverse
// chronological order by purchase date.
type ProductsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of products.
	Value *[]Product `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProductsListResultIterator provides access to a complete listing of Product values.
type ProductsListResultIterator struct {
	i    int
	page ProductsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProductsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProductsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProductsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProductsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProductsListResultIterator) Response() ProductsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProductsListResultIterator) Value() Product {
	if !iter.page.NotDone() {
		return Product{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProductsListResultIterator type.
func NewProductsListResultIterator(page ProductsListResultPage) ProductsListResultIterator {
	return ProductsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (plr ProductsListResult) IsEmpty() bool {
	return plr.Value == nil || len(*plr.Value) == 0
}

// productsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plr ProductsListResult) productsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if plr.NextLink == nil || len(to.String(plr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plr.NextLink)))
}

// ProductsListResultPage contains a page of Product values.
type ProductsListResultPage struct {
	fn  func(context.Context, ProductsListResult) (ProductsListResult, error)
	plr ProductsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProductsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProductsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.plr)
	if err != nil {
		return err
	}
	page.plr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProductsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProductsListResultPage) NotDone() bool {
	return !page.plr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProductsListResultPage) Response() ProductsListResult {
	return page.plr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProductsListResultPage) Values() []Product {
	if page.plr.IsEmpty() {
		return nil
	}
	return *page.plr.Value
}

// Creates a new instance of the ProductsListResultPage type.
func NewProductsListResultPage(getNextPage func(context.Context, ProductsListResult) (ProductsListResult, error)) ProductsListResultPage {
	return ProductsListResultPage{fn: getNextPage}
}

// Profile a billing profile.
type Profile struct {
	autorest.Response `json:"-"`
	// ProfileProperties - The properties of the billing profile.
	*ProfileProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Profile.
func (p Profile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.ProfileProperties != nil {
		objectMap["properties"] = p.ProfileProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Profile struct.
func (p *Profile) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var profileProperties ProfileProperties
				err = json.Unmarshal(*v, &profileProperties)
				if err != nil {
					return err
				}
				p.ProfileProperties = &profileProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				p.Type = &typeVar
			}
		}
	}

	return nil
}

// ProfileCreationRequest the request parameters for creating a new billing profile.
type ProfileCreationRequest struct {
	// DisplayName - The name of the billing profile.
	DisplayName *string `json:"displayName,omitempty"`
	// PoNumber - The purchase order name that will appear on the invoices generated for the billing profile.
	PoNumber *string `json:"poNumber,omitempty"`
	// BillTo - The address of the individual or organization that is responsible for the billing profile.
	BillTo *AddressDetails `json:"billTo,omitempty"`
	// InvoiceEmailOptIn - Flag controlling whether the invoices for the billing profile are sent through email.
	InvoiceEmailOptIn *bool `json:"invoiceEmailOptIn,omitempty"`
	// EnabledAzurePlans - Enabled azure plans for the billing profile.
	EnabledAzurePlans *[]AzurePlan `json:"enabledAzurePlans,omitempty"`
}

// ProfileListResult the list of billing profiles.
type ProfileListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of billing profiles.
	Value *[]Profile `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProfileListResultIterator provides access to a complete listing of Profile values.
type ProfileListResultIterator struct {
	i    int
	page ProfileListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProfileListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProfileListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProfileListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProfileListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProfileListResultIterator) Response() ProfileListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProfileListResultIterator) Value() Profile {
	if !iter.page.NotDone() {
		return Profile{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProfileListResultIterator type.
func NewProfileListResultIterator(page ProfileListResultPage) ProfileListResultIterator {
	return ProfileListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (plr ProfileListResult) IsEmpty() bool {
	return plr.Value == nil || len(*plr.Value) == 0
}

// profileListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plr ProfileListResult) profileListResultPreparer(ctx context.Context) (*http.Request, error) {
	if plr.NextLink == nil || len(to.String(plr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plr.NextLink)))
}

// ProfileListResultPage contains a page of Profile values.
type ProfileListResultPage struct {
	fn  func(context.Context, ProfileListResult) (ProfileListResult, error)
	plr ProfileListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProfileListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProfileListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.plr)
	if err != nil {
		return err
	}
	page.plr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProfileListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProfileListResultPage) NotDone() bool {
	return !page.plr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProfileListResultPage) Response() ProfileListResult {
	return page.plr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProfileListResultPage) Values() []Profile {
	if page.plr.IsEmpty() {
		return nil
	}
	return *page.plr.Value
}

// Creates a new instance of the ProfileListResultPage type.
func NewProfileListResultPage(getNextPage func(context.Context, ProfileListResult) (ProfileListResult, error)) ProfileListResultPage {
	return ProfileListResultPage{fn: getNextPage}
}

// ProfileProperties the properties of the billing profile.
type ProfileProperties struct {
	// DisplayName - The name of the billing profile.
	DisplayName *string `json:"displayName,omitempty"`
	// PoNumber - The purchase order name that will appear on the invoices generated for the billing profile.
	PoNumber *string `json:"poNumber,omitempty"`
	// BillTo - Billing address.
	BillTo *AddressDetails `json:"billTo,omitempty"`
	// InvoiceEmailOptIn - Flag controlling whether the invoices for the billing profile are sent through email.
	InvoiceEmailOptIn *bool `json:"invoiceEmailOptIn,omitempty"`
	// InvoiceDay - READ-ONLY; The day of the month when the invoice for the billing profile is generated.
	InvoiceDay *int32 `json:"invoiceDay,omitempty"`
	// Currency - READ-ONLY; The currency in which the charges for the billing profile are billed.
	Currency *string `json:"currency,omitempty"`
	// EnabledAzurePlans - Information about the enabled azure plans.
	EnabledAzurePlans *[]AzurePlan `json:"enabledAzurePlans,omitempty"`
	// InvoiceSections - The invoice sections associated to the billing profile. By default this is not populated, unless it's specified in $expand.
	InvoiceSections *InvoiceSectionsOnExpand `json:"invoiceSections,omitempty"`
	// HasReadAccess - READ-ONLY; Indicates whether user has read access to the billing profile.
	HasReadAccess *bool `json:"hasReadAccess,omitempty"`
	// SystemID - READ-ONLY; The system generated unique identifier for a billing profile.
	SystemID *string `json:"systemId,omitempty"`
	// Status - READ-ONLY; The status of the billing profile. Possible values include: 'ProfileStatusActive', 'ProfileStatusDisabled', 'ProfileStatusWarned'
	Status ProfileStatus `json:"status,omitempty"`
	// StatusReasonCode - READ-ONLY; Reason for the specified billing profile status. Possible values include: 'StatusReasonCodePastDue', 'StatusReasonCodeSpendingLimitReached', 'StatusReasonCodeSpendingLimitExpired'
	StatusReasonCode StatusReasonCode `json:"statusReasonCode,omitempty"`
	// SpendingLimit - READ-ONLY; The billing profile spending limit. Possible values include: 'SpendingLimitOff', 'SpendingLimitOn'
	SpendingLimit SpendingLimit `json:"spendingLimit,omitempty"`
}

// ProfilesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ProfilesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ProfilesCreateOrUpdateFuture) Result(client ProfilesClient) (p Profile, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.ProfilesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("billing.ProfilesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if p.Response.Response, err = future.GetResult(sender); err == nil && p.Response.Response.StatusCode != http.StatusNoContent {
		p, err = client.CreateOrUpdateResponder(p.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "billing.ProfilesCreateOrUpdateFuture", "Result", p.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ProfilesOnExpand the billing profiles associated with the billing account. By default this is not
// populated, unless it's specified in $expand.
type ProfilesOnExpand struct {
	// HasMoreResults - READ-ONLY; Indicates whether there are more billing profiles than the ones listed in this collection. The collection lists a maximum of 50 billing profiles. To get all billing profiles, use the list billing profiles API.
	HasMoreResults *bool `json:"hasMoreResults,omitempty"`
	// Value - The billing profiles associated with the billing account.
	Value *[]Profile `json:"value,omitempty"`
}

// Property a billing property.
type Property struct {
	autorest.Response `json:"-"`
	// PropertyProperties - A billing property.
	*PropertyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Property.
func (p Property) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.PropertyProperties != nil {
		objectMap["properties"] = p.PropertyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Property struct.
func (p *Property) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var propertyProperties PropertyProperties
				err = json.Unmarshal(*v, &propertyProperties)
				if err != nil {
					return err
				}
				p.PropertyProperties = &propertyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				p.Type = &typeVar
			}
		}
	}

	return nil
}

// PropertyProperties the billing property.
type PropertyProperties struct {
	// AccountAdminNotificationEmailAddress - READ-ONLY; The email address on which the account admin gets all Azure notifications.
	AccountAdminNotificationEmailAddress *string `json:"accountAdminNotificationEmailAddress,omitempty"`
	// BillingTenantID - READ-ONLY; The Azure AD tenant ID of the billing account for the subscription.
	BillingTenantID *string `json:"billingTenantId,omitempty"`
	// BillingAccountID - READ-ONLY; The ID of the billing account to which the subscription is billed.
	BillingAccountID *string `json:"billingAccountId,omitempty"`
	// BillingAccountDisplayName - READ-ONLY; The name of the billing account to which the subscription is billed.
	BillingAccountDisplayName *string `json:"billingAccountDisplayName,omitempty"`
	// BillingProfileID - READ-ONLY; The ID of the billing profile to which the subscription is billed.
	BillingProfileID *string `json:"billingProfileId,omitempty"`
	// BillingProfileDisplayName - READ-ONLY; The name of the billing profile to which the subscription is billed.
	BillingProfileDisplayName *string `json:"billingProfileDisplayName,omitempty"`
	// BillingProfileStatus - READ-ONLY; The status of the billing profile. Possible values include: 'ProfileStatusActive', 'ProfileStatusDisabled', 'ProfileStatusWarned'
	BillingProfileStatus ProfileStatus `json:"billingProfileStatus,omitempty"`
	// BillingProfileStatusReasonCode - READ-ONLY; Reason for the specified billing profile status. Possible values include: 'PastDue', 'SpendingLimitReached', 'SpendingLimitExpired'
	BillingProfileStatusReasonCode ProfileStatusReasonCode `json:"billingProfileStatusReasonCode,omitempty"`
	// BillingProfileSpendingLimit - READ-ONLY; The billing profile spending limit. Possible values include: 'ProfileSpendingLimitOff', 'ProfileSpendingLimitOn'
	BillingProfileSpendingLimit ProfileSpendingLimit `json:"billingProfileSpendingLimit,omitempty"`
	// CostCenter - The cost center applied to the subscription.
	CostCenter *string `json:"costCenter,omitempty"`
	// InvoiceSectionID - READ-ONLY; The ID of the invoice section to which the subscription is billed.
	InvoiceSectionID *string `json:"invoiceSectionId,omitempty"`
	// InvoiceSectionDisplayName - READ-ONLY; The name of the invoice section to which the subscription is billed.
	InvoiceSectionDisplayName *string `json:"invoiceSectionDisplayName,omitempty"`
	// IsAccountAdmin - READ-ONLY; Indicates whether user is the account admin.
	IsAccountAdmin *bool `json:"isAccountAdmin,omitempty"`
	// ProductID - READ-ONLY; The product ID of the Azure plan.
	ProductID *string `json:"productId,omitempty"`
	// ProductName - READ-ONLY; The product name of the Azure plan.
	ProductName *string `json:"productName,omitempty"`
	// SkuID - READ-ONLY; The sku ID of the Azure plan for the subscription.
	SkuID *string `json:"skuId,omitempty"`
	// SkuDescription - READ-ONLY; The sku description of the Azure plan for the subscription.
	SkuDescription *string `json:"skuDescription,omitempty"`
}

// Reseller details of the reseller.
type Reseller struct {
	// ResellerID - READ-ONLY; The MPN ID of the reseller.
	ResellerID *string `json:"resellerId,omitempty"`
	// Description - READ-ONLY; The name of the reseller.
	Description *string `json:"description,omitempty"`
}

// Resource the Resource model definition.
type Resource struct {
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// RoleAssignment the role assignment
type RoleAssignment struct {
	autorest.Response `json:"-"`
	// RoleAssignmentProperties - The properties of the role assignment.
	*RoleAssignmentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RoleAssignment.
func (ra RoleAssignment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ra.RoleAssignmentProperties != nil {
		objectMap["properties"] = ra.RoleAssignmentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RoleAssignment struct.
func (ra *RoleAssignment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var roleAssignmentProperties RoleAssignmentProperties
				err = json.Unmarshal(*v, &roleAssignmentProperties)
				if err != nil {
					return err
				}
				ra.RoleAssignmentProperties = &roleAssignmentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ra.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ra.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ra.Type = &typeVar
			}
		}
	}

	return nil
}

// RoleAssignmentListResult the list of role assignments.
type RoleAssignmentListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of role assignments.
	Value *[]RoleAssignment `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RoleAssignmentListResultIterator provides access to a complete listing of RoleAssignment values.
type RoleAssignmentListResultIterator struct {
	i    int
	page RoleAssignmentListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RoleAssignmentListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RoleAssignmentListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RoleAssignmentListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RoleAssignmentListResultIterator) Response() RoleAssignmentListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RoleAssignmentListResultIterator) Value() RoleAssignment {
	if !iter.page.NotDone() {
		return RoleAssignment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RoleAssignmentListResultIterator type.
func NewRoleAssignmentListResultIterator(page RoleAssignmentListResultPage) RoleAssignmentListResultIterator {
	return RoleAssignmentListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ralr RoleAssignmentListResult) IsEmpty() bool {
	return ralr.Value == nil || len(*ralr.Value) == 0
}

// roleAssignmentListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ralr RoleAssignmentListResult) roleAssignmentListResultPreparer(ctx context.Context) (*http.Request, error) {
	if ralr.NextLink == nil || len(to.String(ralr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ralr.NextLink)))
}

// RoleAssignmentListResultPage contains a page of RoleAssignment values.
type RoleAssignmentListResultPage struct {
	fn   func(context.Context, RoleAssignmentListResult) (RoleAssignmentListResult, error)
	ralr RoleAssignmentListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RoleAssignmentListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ralr)
	if err != nil {
		return err
	}
	page.ralr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RoleAssignmentListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RoleAssignmentListResultPage) NotDone() bool {
	return !page.ralr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RoleAssignmentListResultPage) Response() RoleAssignmentListResult {
	return page.ralr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RoleAssignmentListResultPage) Values() []RoleAssignment {
	if page.ralr.IsEmpty() {
		return nil
	}
	return *page.ralr.Value
}

// Creates a new instance of the RoleAssignmentListResultPage type.
func NewRoleAssignmentListResultPage(getNextPage func(context.Context, RoleAssignmentListResult) (RoleAssignmentListResult, error)) RoleAssignmentListResultPage {
	return RoleAssignmentListResultPage{fn: getNextPage}
}

// RoleAssignmentProperties the properties of the role assignment.
type RoleAssignmentProperties struct {
	// CreatedOn - READ-ONLY; The date the role assignment was created.
	CreatedOn *string `json:"createdOn,omitempty"`
	// CreatedByPrincipalTenantID - READ-ONLY; The tenant Id of the user who created the role assignment.
	CreatedByPrincipalTenantID *string `json:"createdByPrincipalTenantId,omitempty"`
	// CreatedByPrincipalID - READ-ONLY; The principal Id of the user who created the role assignment.
	CreatedByPrincipalID *string `json:"createdByPrincipalId,omitempty"`
	// CreatedByUserEmailAddress - READ-ONLY; The email address of the user who created the role assignment.
	CreatedByUserEmailAddress *string `json:"createdByUserEmailAddress,omitempty"`
	// PrincipalID - The principal id of the user to whom the role was assigned.
	PrincipalID *string `json:"principalId,omitempty"`
	// PrincipalTenantID - The principal tenant id of the user to whom the role was assigned.
	PrincipalTenantID *string `json:"principalTenantId,omitempty"`
	// RoleDefinitionID - The ID of the role definition.
	RoleDefinitionID *string `json:"roleDefinitionId,omitempty"`
	// Scope - READ-ONLY; The scope at which the role was assigned.
	Scope *string `json:"scope,omitempty"`
	// UserAuthenticationType - The authentication type.
	UserAuthenticationType *string `json:"userAuthenticationType,omitempty"`
	// UserEmailAddress - The email address of the user.
	UserEmailAddress *string `json:"userEmailAddress,omitempty"`
}

// RoleDefinition the properties of a role definition.
type RoleDefinition struct {
	autorest.Response `json:"-"`
	// RoleDefinitionProperties - The properties of the a role definition.
	*RoleDefinitionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RoleDefinition.
func (rd RoleDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rd.RoleDefinitionProperties != nil {
		objectMap["properties"] = rd.RoleDefinitionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RoleDefinition struct.
func (rd *RoleDefinition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var roleDefinitionProperties RoleDefinitionProperties
				err = json.Unmarshal(*v, &roleDefinitionProperties)
				if err != nil {
					return err
				}
				rd.RoleDefinitionProperties = &roleDefinitionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rd.Type = &typeVar
			}
		}
	}

	return nil
}

// RoleDefinitionListResult the list of role definitions.
type RoleDefinitionListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The role definitions.
	Value *[]RoleDefinition `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RoleDefinitionListResultIterator provides access to a complete listing of RoleDefinition values.
type RoleDefinitionListResultIterator struct {
	i    int
	page RoleDefinitionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RoleDefinitionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleDefinitionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RoleDefinitionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RoleDefinitionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RoleDefinitionListResultIterator) Response() RoleDefinitionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RoleDefinitionListResultIterator) Value() RoleDefinition {
	if !iter.page.NotDone() {
		return RoleDefinition{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RoleDefinitionListResultIterator type.
func NewRoleDefinitionListResultIterator(page RoleDefinitionListResultPage) RoleDefinitionListResultIterator {
	return RoleDefinitionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rdlr RoleDefinitionListResult) IsEmpty() bool {
	return rdlr.Value == nil || len(*rdlr.Value) == 0
}

// roleDefinitionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rdlr RoleDefinitionListResult) roleDefinitionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if rdlr.NextLink == nil || len(to.String(rdlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rdlr.NextLink)))
}

// RoleDefinitionListResultPage contains a page of RoleDefinition values.
type RoleDefinitionListResultPage struct {
	fn   func(context.Context, RoleDefinitionListResult) (RoleDefinitionListResult, error)
	rdlr RoleDefinitionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RoleDefinitionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleDefinitionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.rdlr)
	if err != nil {
		return err
	}
	page.rdlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RoleDefinitionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RoleDefinitionListResultPage) NotDone() bool {
	return !page.rdlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RoleDefinitionListResultPage) Response() RoleDefinitionListResult {
	return page.rdlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RoleDefinitionListResultPage) Values() []RoleDefinition {
	if page.rdlr.IsEmpty() {
		return nil
	}
	return *page.rdlr.Value
}

// Creates a new instance of the RoleDefinitionListResultPage type.
func NewRoleDefinitionListResultPage(getNextPage func(context.Context, RoleDefinitionListResult) (RoleDefinitionListResult, error)) RoleDefinitionListResultPage {
	return RoleDefinitionListResultPage{fn: getNextPage}
}

// RoleDefinitionProperties the properties of the a role definition.
type RoleDefinitionProperties struct {
	// Description - READ-ONLY; The role description
	Description *string `json:"description,omitempty"`
	// Permissions - The billingPermissions the role has
	Permissions *[]PermissionsProperties `json:"permissions,omitempty"`
	// RoleName - READ-ONLY; The name of the role
	RoleName *string `json:"roleName,omitempty"`
}

// Subscription a billing subscription.
type Subscription struct {
	autorest.Response       `json:"-"`
	*SubscriptionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Subscription.
func (s Subscription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.SubscriptionProperties != nil {
		objectMap["properties"] = s.SubscriptionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Subscription struct.
func (s *Subscription) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var subscriptionProperties SubscriptionProperties
				err = json.Unmarshal(*v, &subscriptionProperties)
				if err != nil {
					return err
				}
				s.SubscriptionProperties = &subscriptionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		}
	}

	return nil
}

// SubscriptionProperties the billing properties of a subscription.
type SubscriptionProperties struct {
	// DisplayName - READ-ONLY; The name of the subscription.
	DisplayName *string `json:"displayName,omitempty"`
	// SubscriptionID - READ-ONLY; The ID of the subscription.
	SubscriptionID *uuid.UUID `json:"subscriptionId,omitempty"`
	// SubscriptionBillingStatus - The current billing status of the subscription. Possible values include: 'SubscriptionStatusTypeActive', 'SubscriptionStatusTypeInactive', 'SubscriptionStatusTypeAbandoned', 'SubscriptionStatusTypeDeleted', 'SubscriptionStatusTypeWarning'
	SubscriptionBillingStatus SubscriptionStatusType `json:"subscriptionBillingStatus,omitempty"`
	// LastMonthCharges - READ-ONLY; The last month charges.
	LastMonthCharges *Amount `json:"lastMonthCharges,omitempty"`
	// MonthToDateCharges - READ-ONLY; The current month to date charges.
	MonthToDateCharges *Amount `json:"monthToDateCharges,omitempty"`
	// BillingProfileID - READ-ONLY; The ID of the billing profile to which the subscription is billed.
	BillingProfileID *string `json:"billingProfileId,omitempty"`
	// BillingProfileDisplayName - READ-ONLY; The name of the billing profile to which the subscription is billed.
	BillingProfileDisplayName *string `json:"billingProfileDisplayName,omitempty"`
	// CostCenter - The cost center applied to the subscription.
	CostCenter *string `json:"costCenter,omitempty"`
	// CustomerID - READ-ONLY; The ID of the customer for whom the subscription was created. The field is applicable only for Microsoft Partner Agreement billing account.
	CustomerID *string `json:"customerId,omitempty"`
	// CustomerDisplayName - READ-ONLY; The name of the customer for whom the subscription was created. The field is applicable only for Microsoft Partner Agreement billing account.
	CustomerDisplayName *string `json:"customerDisplayName,omitempty"`
	// InvoiceSectionID - READ-ONLY; The ID of the invoice section to which the subscription is billed.
	InvoiceSectionID *string `json:"invoiceSectionId,omitempty"`
	// InvoiceSectionDisplayName - READ-ONLY; The name of the invoice section to which the subscription is billed.
	InvoiceSectionDisplayName *string `json:"invoiceSectionDisplayName,omitempty"`
	// Reseller - READ-ONLY; Reseller for this subscription.
	Reseller *Reseller `json:"reseller,omitempty"`
	// SkuID - The sku ID of the Azure plan for the subscription.
	SkuID *string `json:"skuId,omitempty"`
	// SkuDescription - READ-ONLY; The sku description of the Azure plan for the subscription.
	SkuDescription *string `json:"skuDescription,omitempty"`
}

// SubscriptionsListResult the list of billing subscriptions.
type SubscriptionsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of billing subscriptions.
	Value *[]Subscription `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SubscriptionsListResultIterator provides access to a complete listing of Subscription values.
type SubscriptionsListResultIterator struct {
	i    int
	page SubscriptionsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SubscriptionsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubscriptionsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SubscriptionsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SubscriptionsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SubscriptionsListResultIterator) Response() SubscriptionsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SubscriptionsListResultIterator) Value() Subscription {
	if !iter.page.NotDone() {
		return Subscription{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SubscriptionsListResultIterator type.
func NewSubscriptionsListResultIterator(page SubscriptionsListResultPage) SubscriptionsListResultIterator {
	return SubscriptionsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (slr SubscriptionsListResult) IsEmpty() bool {
	return slr.Value == nil || len(*slr.Value) == 0
}

// subscriptionsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (slr SubscriptionsListResult) subscriptionsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if slr.NextLink == nil || len(to.String(slr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(slr.NextLink)))
}

// SubscriptionsListResultPage contains a page of Subscription values.
type SubscriptionsListResultPage struct {
	fn  func(context.Context, SubscriptionsListResult) (SubscriptionsListResult, error)
	slr SubscriptionsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SubscriptionsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubscriptionsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.slr)
	if err != nil {
		return err
	}
	page.slr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SubscriptionsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SubscriptionsListResultPage) NotDone() bool {
	return !page.slr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SubscriptionsListResultPage) Response() SubscriptionsListResult {
	return page.slr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SubscriptionsListResultPage) Values() []Subscription {
	if page.slr.IsEmpty() {
		return nil
	}
	return *page.slr.Value
}

// Creates a new instance of the SubscriptionsListResultPage type.
func NewSubscriptionsListResultPage(getNextPage func(context.Context, SubscriptionsListResult) (SubscriptionsListResult, error)) SubscriptionsListResultPage {
	return SubscriptionsListResultPage{fn: getNextPage}
}

// SubscriptionsMoveFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SubscriptionsMoveFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SubscriptionsMoveFuture) Result(client SubscriptionsClient) (s Subscription, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "billing.SubscriptionsMoveFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("billing.SubscriptionsMoveFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if s.Response.Response, err = future.GetResult(sender); err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
		s, err = client.MoveResponder(s.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "billing.SubscriptionsMoveFuture", "Result", s.Response.Response, "Failure responding to request")
		}
	}
	return
}

// Transaction a transaction.
type Transaction struct {
	*TransactionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Transaction.
func (t Transaction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if t.TransactionProperties != nil {
		objectMap["properties"] = t.TransactionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Transaction struct.
func (t *Transaction) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var transactionProperties TransactionProperties
				err = json.Unmarshal(*v, &transactionProperties)
				if err != nil {
					return err
				}
				t.TransactionProperties = &transactionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				t.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				t.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				t.Type = &typeVar
			}
		}
	}

	return nil
}

// TransactionListResult the list of transactions.
type TransactionListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of transactions.
	Value *[]Transaction `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// TransactionListResultIterator provides access to a complete listing of Transaction values.
type TransactionListResultIterator struct {
	i    int
	page TransactionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TransactionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TransactionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TransactionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TransactionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TransactionListResultIterator) Response() TransactionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TransactionListResultIterator) Value() Transaction {
	if !iter.page.NotDone() {
		return Transaction{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TransactionListResultIterator type.
func NewTransactionListResultIterator(page TransactionListResultPage) TransactionListResultIterator {
	return TransactionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tlr TransactionListResult) IsEmpty() bool {
	return tlr.Value == nil || len(*tlr.Value) == 0
}

// transactionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tlr TransactionListResult) transactionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if tlr.NextLink == nil || len(to.String(tlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tlr.NextLink)))
}

// TransactionListResultPage contains a page of Transaction values.
type TransactionListResultPage struct {
	fn  func(context.Context, TransactionListResult) (TransactionListResult, error)
	tlr TransactionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TransactionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TransactionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.tlr)
	if err != nil {
		return err
	}
	page.tlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TransactionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TransactionListResultPage) NotDone() bool {
	return !page.tlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TransactionListResultPage) Response() TransactionListResult {
	return page.tlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TransactionListResultPage) Values() []Transaction {
	if page.tlr.IsEmpty() {
		return nil
	}
	return *page.tlr.Value
}

// Creates a new instance of the TransactionListResultPage type.
func NewTransactionListResultPage(getNextPage func(context.Context, TransactionListResult) (TransactionListResult, error)) TransactionListResultPage {
	return TransactionListResultPage{fn: getNextPage}
}

// TransactionProperties the properties of a transaction.
type TransactionProperties struct {
	// Kind - The kind of transaction. Options are all or reservation. Possible values include: 'All', 'Reservation'
	Kind TransactionTypeKind `json:"kind,omitempty"`
	// Date - READ-ONLY; The date of transaction.
	Date *date.Time `json:"date,omitempty"`
	// Invoice - READ-ONLY; Invoice on which the transaction was billed or 'pending' if the transaction is not billed.
	Invoice *string `json:"invoice,omitempty"`
	// InvoiceID - READ-ONLY; The ID of the invoice on which the transaction was billed. This field is only applicable for transactions which are billed.
	InvoiceID *string `json:"invoiceId,omitempty"`
	// OrderID - READ-ONLY; The order ID of the reservation. The field is only applicable for transaction of kind reservation.
	OrderID *string `json:"orderId,omitempty"`
	// OrderName - READ-ONLY; The name of the reservation order. The field is only applicable for transactions of kind reservation.
	OrderName *string `json:"orderName,omitempty"`
	// ProductFamily - READ-ONLY; The family of the product for which the transaction took place.
	ProductFamily *string `json:"productFamily,omitempty"`
	// ProductTypeID - READ-ONLY; The ID of the product type for which the transaction took place.
	ProductTypeID *string `json:"productTypeId,omitempty"`
	// ProductType - READ-ONLY; The type of the product for which the transaction took place.
	ProductType *string `json:"productType,omitempty"`
	// ProductDescription - READ-ONLY; The description of the product for which the transaction took place.
	ProductDescription *string `json:"productDescription,omitempty"`
	// TransactionType - The type of transaction. Possible values include: 'Purchase', 'UsageCharge'
	TransactionType ReservationType `json:"transactionType,omitempty"`
	// TransactionAmount - READ-ONLY; The charge associated with the transaction.
	TransactionAmount *Amount `json:"transactionAmount,omitempty"`
	// Quantity - READ-ONLY; The quantity purchased in the transaction.
	Quantity *int32 `json:"quantity,omitempty"`
	// InvoiceSectionID - READ-ONLY; The ID of the invoice section which will be billed for the transaction.
	InvoiceSectionID *string `json:"invoiceSectionId,omitempty"`
	// InvoiceSectionDisplayName - READ-ONLY; The name of the invoice section which will be billed for the transaction.
	InvoiceSectionDisplayName *string `json:"invoiceSectionDisplayName,omitempty"`
	// BillingProfileID - READ-ONLY; The ID of the billing profile which will be billed for the transaction.
	BillingProfileID *string `json:"billingProfileId,omitempty"`
	// BillingProfileDisplayName - READ-ONLY; The name of the billing profile which will be billed for the transaction.
	BillingProfileDisplayName *string `json:"billingProfileDisplayName,omitempty"`
	// CustomerID - READ-ONLY; The ID of the customer for which the transaction took place. The field is applicable only for Microsoft Partner Agreement billing account.
	CustomerID *string `json:"customerId,omitempty"`
	// CustomerDisplayName - READ-ONLY; The name of the customer for which the transaction took place. The field is applicable only for Microsoft Partner Agreement billing account.
	CustomerDisplayName *string `json:"customerDisplayName,omitempty"`
	// SubscriptionID - READ-ONLY; The ID of the subscription that was used for the transaction. The field is only applicable for transaction of kind reservation.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// SubscriptionName - READ-ONLY; The name of the subscription that was used for the transaction. The field is only applicable for transaction of kind reservation.
	SubscriptionName *string `json:"subscriptionName,omitempty"`
	// AzurePlan - READ-ONLY; The type of azure plan of the subscription that was used for the transaction.
	AzurePlan *string `json:"azurePlan,omitempty"`
	// AzureCreditApplied - READ-ONLY; The amount of any Azure credits automatically applied to this transaction.
	AzureCreditApplied *Amount `json:"azureCreditApplied,omitempty"`
	// BillingCurrency - READ-ONLY; The ISO 4217 code for the currency in which this transaction is billed.
	BillingCurrency *string `json:"billingCurrency,omitempty"`
	// Discount - READ-ONLY; The percentage discount, if any, applied to this transaction.
	Discount *float64 `json:"discount,omitempty"`
	// EffectivePrice - READ-ONLY; The price of the product after applying any discounts.
	EffectivePrice *Amount `json:"effectivePrice,omitempty"`
	// ExchangeRate - READ-ONLY; The exchange rate used to convert charged amount to billing currency, if applicable.
	ExchangeRate *float64 `json:"exchangeRate,omitempty"`
	// MarketPrice - READ-ONLY; The retail price of the product.
	MarketPrice *Amount `json:"marketPrice,omitempty"`
	// PricingCurrency - READ-ONLY; The ISO 4217 code for the currency in which the product is priced.
	PricingCurrency *string `json:"pricingCurrency,omitempty"`
	// ServicePeriodStartDate - READ-ONLY; The date of the purchase of the product, or the start date of the month in which usage started.
	ServicePeriodStartDate *date.Time `json:"servicePeriodStartDate,omitempty"`
	// ServicePeriodEndDate - READ-ONLY; The end date of the product term, or the end date of the month in which usage ended.
	ServicePeriodEndDate *date.Time `json:"servicePeriodEndDate,omitempty"`
	// SubTotal - READ-ONLY; The pre-tax charged amount for the transaction.
	SubTotal *Amount `json:"subTotal,omitempty"`
	// Tax - READ-ONLY; The tax amount applied to the transaction.
	Tax *Amount `json:"tax,omitempty"`
	// UnitOfMeasure - READ-ONLY; The unit of measure used to bill for the product. For example, compute services are billed per hour.
	UnitOfMeasure *string `json:"unitOfMeasure,omitempty"`
	// Units - READ-ONLY; The number of units used for a given product.
	Units *float64 `json:"units,omitempty"`
	// UnitType - READ-ONLY; The description for the unit of measure for a given product.
	UnitType *string `json:"unitType,omitempty"`
}

// TransferBillingSubscriptionRequestProperties request parameters to transfer billing subscription.
type TransferBillingSubscriptionRequestProperties struct {
	// DestinationInvoiceSectionID - The destination invoice section id.
	DestinationInvoiceSectionID *string `json:"destinationInvoiceSectionId,omitempty"`
}

// TransferProductRequestProperties the properties of the product to initiate a transfer.
type TransferProductRequestProperties struct {
	// DestinationInvoiceSectionID - The destination invoice section id.
	DestinationInvoiceSectionID *string `json:"destinationInvoiceSectionId,omitempty"`
}

// ValidateAddressResponse result of the address validation
type ValidateAddressResponse struct {
	autorest.Response `json:"-"`
	// Status - status of the address validation. Possible values include: 'Valid', 'Invalid'
	Status AddressValidationStatus `json:"status,omitempty"`
	// SuggestedAddresses - The list of suggested addresses.
	SuggestedAddresses *[]AddressDetails `json:"suggestedAddresses,omitempty"`
	// ValidationMessage - Validation error message.
	ValidationMessage *string `json:"validationMessage,omitempty"`
}

// ValidateProductTransferEligibilityError error details of the product transfer eligibility validation.
type ValidateProductTransferEligibilityError struct {
	// Code - Error code for the product transfer validation. Possible values include: 'InvalidSource', 'ProductNotActive', 'InsufficientPermissionOnSource', 'InsufficientPermissionOnDestination', 'DestinationBillingProfilePastDue', 'ProductTypeNotSupported', 'CrossBillingAccountNotAllowed', 'NotAvailableForDestinationMarket', 'OneTimePurchaseProductTransferNotAllowed'
	Code ProductTransferValidationErrorCode `json:"code,omitempty"`
	// Message - The error message.
	Message *string `json:"message,omitempty"`
	// Details - Detailed error message explaining the error.
	Details *string `json:"details,omitempty"`
}

// ValidateProductTransferEligibilityResult result of the product transfer eligibility validation.
type ValidateProductTransferEligibilityResult struct {
	autorest.Response `json:"-"`
	// IsMoveEligible - READ-ONLY; Specifies whether the transfer is eligible or not.
	IsMoveEligible *bool `json:"isMoveEligible,omitempty"`
	// ErrorDetails - Validation error details.
	ErrorDetails *ValidateProductTransferEligibilityError `json:"errorDetails,omitempty"`
}

// ValidateSubscriptionTransferEligibilityError error details of the transfer eligibility validation
type ValidateSubscriptionTransferEligibilityError struct {
	// Code - Error code for the product transfer validation. Possible values include: 'SubscriptionTransferValidationErrorCodeInvalidSource', 'SubscriptionTransferValidationErrorCodeSubscriptionNotActive', 'SubscriptionTransferValidationErrorCodeInsufficientPermissionOnSource', 'SubscriptionTransferValidationErrorCodeInsufficientPermissionOnDestination', 'SubscriptionTransferValidationErrorCodeDestinationBillingProfilePastDue', 'SubscriptionTransferValidationErrorCodeSubscriptionTypeNotSupported', 'SubscriptionTransferValidationErrorCodeCrossBillingAccountNotAllowed', 'SubscriptionTransferValidationErrorCodeNotAvailableForDestinationMarket'
	Code SubscriptionTransferValidationErrorCode `json:"code,omitempty"`
	// Message - The error message.
	Message *string `json:"message,omitempty"`
	// Details - Detailed error message explaining the error.
	Details *string `json:"details,omitempty"`
}

// ValidateSubscriptionTransferEligibilityResult result of the transfer eligibility validation.
type ValidateSubscriptionTransferEligibilityResult struct {
	autorest.Response `json:"-"`
	// IsMoveEligible - READ-ONLY; Specifies whether the subscription is eligible to be transferred.
	IsMoveEligible *bool `json:"isMoveEligible,omitempty"`
	// ErrorDetails - Validation error details.
	ErrorDetails *ValidateSubscriptionTransferEligibilityError `json:"errorDetails,omitempty"`
}
