package adhybridhealthservice

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/tracing"
	"github.com/satori/go.uuid"
	"net/http"
)

// AddsServicesClient is the REST APIs for Azure Active Directory Connect Health
type AddsServicesClient struct {
	BaseClient
}

// NewAddsServicesClient creates an instance of the AddsServicesClient client.
func NewAddsServicesClient() AddsServicesClient {
	return NewAddsServicesClientWithBaseURI(DefaultBaseURI)
}

// NewAddsServicesClientWithBaseURI creates an instance of the AddsServicesClient client using a custom endpoint.  Use
// this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewAddsServicesClientWithBaseURI(baseURI string) AddsServicesClient {
	return AddsServicesClient{NewWithBaseURI(baseURI)}
}

// Add onboards a service for a given tenant in Azure Active Directory Connect Health.
// Parameters:
// service - the service object.
func (client AddsServicesClient) Add(ctx context.Context, service ServiceProperties) (result ServiceProperties, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AddsServicesClient.Add")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.AddPreparer(ctx, service)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "Add", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "Add", resp, "Failure sending request")
		return
	}

	result, err = client.AddResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "Add", resp, "Failure responding to request")
	}

	return
}

// AddPreparer prepares the Add request.
func (client AddsServicesClient) AddPreparer(ctx context.Context, service ServiceProperties) (*http.Request, error) {
	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/providers/Microsoft.ADHybridHealthService/addsservices"),
		autorest.WithJSON(service),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddSender sends the Add request. The method will close the
// http.Response Body if it receives an error.
func (client AddsServicesClient) AddSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddResponder handles the response to the Add request. The method always
// closes the http.Response Body.
func (client AddsServicesClient) AddResponder(resp *http.Response) (result ServiceProperties, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete deletes an Active Directory Domain Service which is onboarded to Azure Active Directory Connect Health.
// Parameters:
// serviceName - the name of the service which needs to be deleted.
// confirm - indicates if the service will be permanently deleted or disabled. True indicates that the service
// will be permanently deleted and False indicates that the service will be marked disabled and then deleted
// after 30 days, if it is not re-registered.
func (client AddsServicesClient) Delete(ctx context.Context, serviceName string, confirm *bool) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AddsServicesClient.Delete")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeletePreparer(ctx, serviceName, confirm)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "Delete", resp, "Failure responding to request")
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client AddsServicesClient) DeletePreparer(ctx context.Context, serviceName string, confirm *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"serviceName": autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if confirm != nil {
		queryParameters["confirm"] = autorest.Encode("query", *confirm)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/addsservices/{serviceName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client AddsServicesClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client AddsServicesClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get gets the details of an Active Directory Domain Service for a tenant having Azure AD Premium license and is
// onboarded to Azure Active Directory Connect Health.
// Parameters:
// serviceName - the name of the service.
func (client AddsServicesClient) Get(ctx context.Context, serviceName string) (result ServiceProperties, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AddsServicesClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, serviceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client AddsServicesClient) GetPreparer(ctx context.Context, serviceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"serviceName": autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/addsservices/{serviceName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client AddsServicesClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client AddsServicesClient) GetResponder(resp *http.Response) (result ServiceProperties, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetForestSummary gets the forest summary for a given Active Directory Domain Service, that is onboarded to Azure
// Active Directory Connect Health.
// Parameters:
// serviceName - the name of the service.
func (client AddsServicesClient) GetForestSummary(ctx context.Context, serviceName string) (result ForestSummary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AddsServicesClient.GetForestSummary")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetForestSummaryPreparer(ctx, serviceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "GetForestSummary", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetForestSummarySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "GetForestSummary", resp, "Failure sending request")
		return
	}

	result, err = client.GetForestSummaryResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "GetForestSummary", resp, "Failure responding to request")
	}

	return
}

// GetForestSummaryPreparer prepares the GetForestSummary request.
func (client AddsServicesClient) GetForestSummaryPreparer(ctx context.Context, serviceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"serviceName": autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/addsservices/{serviceName}/forestsummary", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetForestSummarySender sends the GetForestSummary request. The method will close the
// http.Response Body if it receives an error.
func (client AddsServicesClient) GetForestSummarySender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetForestSummaryResponder handles the response to the GetForestSummary request. The method always
// closes the http.Response Body.
func (client AddsServicesClient) GetForestSummaryResponder(resp *http.Response) (result ForestSummary, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetMetricMetadata gets the service related metric information.
// Parameters:
// serviceName - the name of the service.
// metricName - the metric name
func (client AddsServicesClient) GetMetricMetadata(ctx context.Context, serviceName string, metricName string) (result MetricMetadata, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AddsServicesClient.GetMetricMetadata")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetMetricMetadataPreparer(ctx, serviceName, metricName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "GetMetricMetadata", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetMetricMetadataSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "GetMetricMetadata", resp, "Failure sending request")
		return
	}

	result, err = client.GetMetricMetadataResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "GetMetricMetadata", resp, "Failure responding to request")
	}

	return
}

// GetMetricMetadataPreparer prepares the GetMetricMetadata request.
func (client AddsServicesClient) GetMetricMetadataPreparer(ctx context.Context, serviceName string, metricName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"metricName":  autorest.Encode("path", metricName),
		"serviceName": autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/addsservices/{serviceName}/metricmetadata/{metricName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetMetricMetadataSender sends the GetMetricMetadata request. The method will close the
// http.Response Body if it receives an error.
func (client AddsServicesClient) GetMetricMetadataSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetMetricMetadataResponder handles the response to the GetMetricMetadata request. The method always
// closes the http.Response Body.
func (client AddsServicesClient) GetMetricMetadataResponder(resp *http.Response) (result MetricMetadata, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetMetricMetadataForGroup gets the service related metrics for a given metric and group combination.
// Parameters:
// serviceName - the name of the service.
// metricName - the metric name
// groupName - the group name
// groupKey - the group key
// fromDate - the start date.
// toDate - the end date.
func (client AddsServicesClient) GetMetricMetadataForGroup(ctx context.Context, serviceName string, metricName string, groupName string, groupKey string, fromDate *date.Time, toDate *date.Time) (result MetricSets, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AddsServicesClient.GetMetricMetadataForGroup")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetMetricMetadataForGroupPreparer(ctx, serviceName, metricName, groupName, groupKey, fromDate, toDate)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "GetMetricMetadataForGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetMetricMetadataForGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "GetMetricMetadataForGroup", resp, "Failure sending request")
		return
	}

	result, err = client.GetMetricMetadataForGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "GetMetricMetadataForGroup", resp, "Failure responding to request")
	}

	return
}

// GetMetricMetadataForGroupPreparer prepares the GetMetricMetadataForGroup request.
func (client AddsServicesClient) GetMetricMetadataForGroupPreparer(ctx context.Context, serviceName string, metricName string, groupName string, groupKey string, fromDate *date.Time, toDate *date.Time) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"groupName":   autorest.Encode("path", groupName),
		"metricName":  autorest.Encode("path", metricName),
		"serviceName": autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(groupKey) > 0 {
		queryParameters["groupKey"] = autorest.Encode("query", groupKey)
	}
	if fromDate != nil {
		queryParameters["fromDate"] = autorest.Encode("query", *fromDate)
	}
	if toDate != nil {
		queryParameters["toDate"] = autorest.Encode("query", *toDate)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/addsservices/{serviceName}/metricmetadata/{metricName}/groups/{groupName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetMetricMetadataForGroupSender sends the GetMetricMetadataForGroup request. The method will close the
// http.Response Body if it receives an error.
func (client AddsServicesClient) GetMetricMetadataForGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetMetricMetadataForGroupResponder handles the response to the GetMetricMetadataForGroup request. The method always
// closes the http.Response Body.
func (client AddsServicesClient) GetMetricMetadataForGroupResponder(resp *http.Response) (result MetricSets, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List gets the details of Active Directory Domain Service, for a tenant, that are onboarded to Azure Active Directory
// Connect Health.
// Parameters:
// filter - the service property filter to apply.
// serviceType - the service type for the services onboarded to Azure Active Directory Connect Health.
// Depending on whether the service is monitoring, ADFS, Sync or ADDS roles, the service type can either be
// AdFederationService or AadSyncService or AdDomainService.
// skipCount - the skip count, which specifies the number of elements that can be bypassed from a sequence and
// then return the remaining elements.
// takeCount - the take count , which specifies the number of elements that can be returned from a sequence.
func (client AddsServicesClient) List(ctx context.Context, filter string, serviceType string, skipCount *int32, takeCount *int32) (result ServicesPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AddsServicesClient.List")
		defer func() {
			sc := -1
			if result.s.Response.Response != nil {
				sc = result.s.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, filter, serviceType, skipCount, takeCount)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.s.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "List", resp, "Failure sending request")
		return
	}

	result.s, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client AddsServicesClient) ListPreparer(ctx context.Context, filter string, serviceType string, skipCount *int32, takeCount *int32) (*http.Request, error) {
	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(serviceType) > 0 {
		queryParameters["serviceType"] = autorest.Encode("query", serviceType)
	}
	if skipCount != nil {
		queryParameters["skipCount"] = autorest.Encode("query", *skipCount)
	}
	if takeCount != nil {
		queryParameters["takeCount"] = autorest.Encode("query", *takeCount)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/providers/Microsoft.ADHybridHealthService/addsservices"),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client AddsServicesClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client AddsServicesClient) ListResponder(resp *http.Response) (result Services, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client AddsServicesClient) listNextResults(ctx context.Context, lastResults Services) (result Services, err error) {
	req, err := lastResults.servicesPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client AddsServicesClient) ListComplete(ctx context.Context, filter string, serviceType string, skipCount *int32, takeCount *int32) (result ServicesIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AddsServicesClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx, filter, serviceType, skipCount, takeCount)
	return
}

// ListMetricMetadata gets the service related metrics information.
// Parameters:
// serviceName - the name of the service.
// filter - the metric metadata property filter to apply.
// perfCounter - indicates if only performance counter metrics are requested.
func (client AddsServicesClient) ListMetricMetadata(ctx context.Context, serviceName string, filter string, perfCounter *bool) (result MetricMetadataListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AddsServicesClient.ListMetricMetadata")
		defer func() {
			sc := -1
			if result.mml.Response.Response != nil {
				sc = result.mml.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listMetricMetadataNextResults
	req, err := client.ListMetricMetadataPreparer(ctx, serviceName, filter, perfCounter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "ListMetricMetadata", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMetricMetadataSender(req)
	if err != nil {
		result.mml.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "ListMetricMetadata", resp, "Failure sending request")
		return
	}

	result.mml, err = client.ListMetricMetadataResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "ListMetricMetadata", resp, "Failure responding to request")
	}

	return
}

// ListMetricMetadataPreparer prepares the ListMetricMetadata request.
func (client AddsServicesClient) ListMetricMetadataPreparer(ctx context.Context, serviceName string, filter string, perfCounter *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"serviceName": autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if perfCounter != nil {
		queryParameters["perfCounter"] = autorest.Encode("query", *perfCounter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/addsservices/{serviceName}/metricmetadata", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListMetricMetadataSender sends the ListMetricMetadata request. The method will close the
// http.Response Body if it receives an error.
func (client AddsServicesClient) ListMetricMetadataSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListMetricMetadataResponder handles the response to the ListMetricMetadata request. The method always
// closes the http.Response Body.
func (client AddsServicesClient) ListMetricMetadataResponder(resp *http.Response) (result MetricMetadataList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listMetricMetadataNextResults retrieves the next set of results, if any.
func (client AddsServicesClient) listMetricMetadataNextResults(ctx context.Context, lastResults MetricMetadataList) (result MetricMetadataList, err error) {
	req, err := lastResults.metricMetadataListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "listMetricMetadataNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListMetricMetadataSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "listMetricMetadataNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListMetricMetadataResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "listMetricMetadataNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListMetricMetadataComplete enumerates all values, automatically crossing page boundaries as required.
func (client AddsServicesClient) ListMetricMetadataComplete(ctx context.Context, serviceName string, filter string, perfCounter *bool) (result MetricMetadataListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AddsServicesClient.ListMetricMetadata")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListMetricMetadata(ctx, serviceName, filter, perfCounter)
	return
}

// ListMetricsAverage gets the average of the metric values for a given metric and group combination.
// Parameters:
// serviceName - the name of the service.
// metricName - the metric name
// groupName - the group name
func (client AddsServicesClient) ListMetricsAverage(ctx context.Context, serviceName string, metricName string, groupName string) (result MetricsPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AddsServicesClient.ListMetricsAverage")
		defer func() {
			sc := -1
			if result.mVar.Response.Response != nil {
				sc = result.mVar.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listMetricsAverageNextResults
	req, err := client.ListMetricsAveragePreparer(ctx, serviceName, metricName, groupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "ListMetricsAverage", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMetricsAverageSender(req)
	if err != nil {
		result.mVar.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "ListMetricsAverage", resp, "Failure sending request")
		return
	}

	result.mVar, err = client.ListMetricsAverageResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "ListMetricsAverage", resp, "Failure responding to request")
	}

	return
}

// ListMetricsAveragePreparer prepares the ListMetricsAverage request.
func (client AddsServicesClient) ListMetricsAveragePreparer(ctx context.Context, serviceName string, metricName string, groupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"groupName":   autorest.Encode("path", groupName),
		"metricName":  autorest.Encode("path", metricName),
		"serviceName": autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/addsservices/{serviceName}/metrics/{metricName}/groups/{groupName}/average", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListMetricsAverageSender sends the ListMetricsAverage request. The method will close the
// http.Response Body if it receives an error.
func (client AddsServicesClient) ListMetricsAverageSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListMetricsAverageResponder handles the response to the ListMetricsAverage request. The method always
// closes the http.Response Body.
func (client AddsServicesClient) ListMetricsAverageResponder(resp *http.Response) (result Metrics, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listMetricsAverageNextResults retrieves the next set of results, if any.
func (client AddsServicesClient) listMetricsAverageNextResults(ctx context.Context, lastResults Metrics) (result Metrics, err error) {
	req, err := lastResults.metricsPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "listMetricsAverageNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListMetricsAverageSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "listMetricsAverageNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListMetricsAverageResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "listMetricsAverageNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListMetricsAverageComplete enumerates all values, automatically crossing page boundaries as required.
func (client AddsServicesClient) ListMetricsAverageComplete(ctx context.Context, serviceName string, metricName string, groupName string) (result MetricsIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AddsServicesClient.ListMetricsAverage")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListMetricsAverage(ctx, serviceName, metricName, groupName)
	return
}

// ListMetricsSum gets the sum of the metric values for a given metric and group combination.
// Parameters:
// serviceName - the name of the service.
// metricName - the metric name
// groupName - the group name
func (client AddsServicesClient) ListMetricsSum(ctx context.Context, serviceName string, metricName string, groupName string) (result MetricsPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AddsServicesClient.ListMetricsSum")
		defer func() {
			sc := -1
			if result.mVar.Response.Response != nil {
				sc = result.mVar.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listMetricsSumNextResults
	req, err := client.ListMetricsSumPreparer(ctx, serviceName, metricName, groupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "ListMetricsSum", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMetricsSumSender(req)
	if err != nil {
		result.mVar.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "ListMetricsSum", resp, "Failure sending request")
		return
	}

	result.mVar, err = client.ListMetricsSumResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "ListMetricsSum", resp, "Failure responding to request")
	}

	return
}

// ListMetricsSumPreparer prepares the ListMetricsSum request.
func (client AddsServicesClient) ListMetricsSumPreparer(ctx context.Context, serviceName string, metricName string, groupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"groupName":   autorest.Encode("path", groupName),
		"metricName":  autorest.Encode("path", metricName),
		"serviceName": autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/addsservices/{serviceName}/metrics/{metricName}/groups/{groupName}/sum", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListMetricsSumSender sends the ListMetricsSum request. The method will close the
// http.Response Body if it receives an error.
func (client AddsServicesClient) ListMetricsSumSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListMetricsSumResponder handles the response to the ListMetricsSum request. The method always
// closes the http.Response Body.
func (client AddsServicesClient) ListMetricsSumResponder(resp *http.Response) (result Metrics, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listMetricsSumNextResults retrieves the next set of results, if any.
func (client AddsServicesClient) listMetricsSumNextResults(ctx context.Context, lastResults Metrics) (result Metrics, err error) {
	req, err := lastResults.metricsPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "listMetricsSumNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListMetricsSumSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "listMetricsSumNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListMetricsSumResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "listMetricsSumNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListMetricsSumComplete enumerates all values, automatically crossing page boundaries as required.
func (client AddsServicesClient) ListMetricsSumComplete(ctx context.Context, serviceName string, metricName string, groupName string) (result MetricsIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AddsServicesClient.ListMetricsSum")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListMetricsSum(ctx, serviceName, metricName, groupName)
	return
}

// ListPremiumServices gets the details of Active Directory Domain Services for a tenant having Azure AD Premium
// license and is onboarded to Azure Active Directory Connect Health.
// Parameters:
// filter - the service property filter to apply.
// serviceType - the service type for the services onboarded to Azure Active Directory Connect Health.
// Depending on whether the service is monitoring, ADFS, Sync or ADDS roles, the service type can either be
// AdFederationService or AadSyncService or AdDomainService.
// skipCount - the skip count, which specifies the number of elements that can be bypassed from a sequence and
// then return the remaining elements.
// takeCount - the take count , which specifies the number of elements that can be returned from a sequence.
func (client AddsServicesClient) ListPremiumServices(ctx context.Context, filter string, serviceType string, skipCount *int32, takeCount *int32) (result ServicesPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AddsServicesClient.ListPremiumServices")
		defer func() {
			sc := -1
			if result.s.Response.Response != nil {
				sc = result.s.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listPremiumServicesNextResults
	req, err := client.ListPremiumServicesPreparer(ctx, filter, serviceType, skipCount, takeCount)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "ListPremiumServices", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListPremiumServicesSender(req)
	if err != nil {
		result.s.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "ListPremiumServices", resp, "Failure sending request")
		return
	}

	result.s, err = client.ListPremiumServicesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "ListPremiumServices", resp, "Failure responding to request")
	}

	return
}

// ListPremiumServicesPreparer prepares the ListPremiumServices request.
func (client AddsServicesClient) ListPremiumServicesPreparer(ctx context.Context, filter string, serviceType string, skipCount *int32, takeCount *int32) (*http.Request, error) {
	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(serviceType) > 0 {
		queryParameters["serviceType"] = autorest.Encode("query", serviceType)
	}
	if skipCount != nil {
		queryParameters["skipCount"] = autorest.Encode("query", *skipCount)
	}
	if takeCount != nil {
		queryParameters["takeCount"] = autorest.Encode("query", *takeCount)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/providers/Microsoft.ADHybridHealthService/addsservices/premiumCheck"),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListPremiumServicesSender sends the ListPremiumServices request. The method will close the
// http.Response Body if it receives an error.
func (client AddsServicesClient) ListPremiumServicesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListPremiumServicesResponder handles the response to the ListPremiumServices request. The method always
// closes the http.Response Body.
func (client AddsServicesClient) ListPremiumServicesResponder(resp *http.Response) (result Services, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listPremiumServicesNextResults retrieves the next set of results, if any.
func (client AddsServicesClient) listPremiumServicesNextResults(ctx context.Context, lastResults Services) (result Services, err error) {
	req, err := lastResults.servicesPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "listPremiumServicesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListPremiumServicesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "listPremiumServicesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListPremiumServicesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "listPremiumServicesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListPremiumServicesComplete enumerates all values, automatically crossing page boundaries as required.
func (client AddsServicesClient) ListPremiumServicesComplete(ctx context.Context, filter string, serviceType string, skipCount *int32, takeCount *int32) (result ServicesIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AddsServicesClient.ListPremiumServices")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListPremiumServices(ctx, filter, serviceType, skipCount, takeCount)
	return
}

// ListReplicationDetails gets complete domain controller list along with replication details for a given Active
// Directory Domain Service, that is onboarded to Azure Active Directory Connect Health.
// Parameters:
// serviceName - the name of the service.
// filter - the server property filter to apply.
// withDetails - indicates if InboundReplicationNeighbor details are required or not.
func (client AddsServicesClient) ListReplicationDetails(ctx context.Context, serviceName string, filter string, withDetails *bool) (result ReplicationDetailsList, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AddsServicesClient.ListReplicationDetails")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListReplicationDetailsPreparer(ctx, serviceName, filter, withDetails)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "ListReplicationDetails", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListReplicationDetailsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "ListReplicationDetails", resp, "Failure sending request")
		return
	}

	result, err = client.ListReplicationDetailsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "ListReplicationDetails", resp, "Failure responding to request")
	}

	return
}

// ListReplicationDetailsPreparer prepares the ListReplicationDetails request.
func (client AddsServicesClient) ListReplicationDetailsPreparer(ctx context.Context, serviceName string, filter string, withDetails *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"serviceName": autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if withDetails != nil {
		queryParameters["withDetails"] = autorest.Encode("query", *withDetails)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/addsservices/{serviceName}/replicationdetails", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListReplicationDetailsSender sends the ListReplicationDetails request. The method will close the
// http.Response Body if it receives an error.
func (client AddsServicesClient) ListReplicationDetailsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListReplicationDetailsResponder handles the response to the ListReplicationDetails request. The method always
// closes the http.Response Body.
func (client AddsServicesClient) ListReplicationDetailsResponder(resp *http.Response) (result ReplicationDetailsList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListReplicationSummary gets complete domain controller list along with replication details for a given Active
// Directory Domain Service, that is onboarded to Azure Active Directory Connect Health.
// Parameters:
// serviceName - the name of the service.
// isGroupbySite - indicates if the result should be grouped by site or not.
// query - the custom query.
// filter - the server property filter to apply.
// takeCount - the take count , which specifies the number of elements that can be returned from a sequence.
func (client AddsServicesClient) ListReplicationSummary(ctx context.Context, serviceName string, isGroupbySite bool, query string, filter string, takeCount *int32) (result ReplicationSummaryList, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AddsServicesClient.ListReplicationSummary")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListReplicationSummaryPreparer(ctx, serviceName, isGroupbySite, query, filter, takeCount)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "ListReplicationSummary", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListReplicationSummarySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "ListReplicationSummary", resp, "Failure sending request")
		return
	}

	result, err = client.ListReplicationSummaryResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "ListReplicationSummary", resp, "Failure responding to request")
	}

	return
}

// ListReplicationSummaryPreparer prepares the ListReplicationSummary request.
func (client AddsServicesClient) ListReplicationSummaryPreparer(ctx context.Context, serviceName string, isGroupbySite bool, query string, filter string, takeCount *int32) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"serviceName": autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version":      APIVersion,
		"isGroupbySite":    autorest.Encode("query", isGroupbySite),
		"nextPartitionKey": autorest.Encode("query", ""),
		"nextRowKey":       autorest.Encode("query", ""),
		"query":            autorest.Encode("query", query),
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if takeCount != nil {
		queryParameters["takeCount"] = autorest.Encode("query", *takeCount)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/addsservices/{serviceName}/replicationsummary", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListReplicationSummarySender sends the ListReplicationSummary request. The method will close the
// http.Response Body if it receives an error.
func (client AddsServicesClient) ListReplicationSummarySender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListReplicationSummaryResponder handles the response to the ListReplicationSummary request. The method always
// closes the http.Response Body.
func (client AddsServicesClient) ListReplicationSummaryResponder(resp *http.Response) (result ReplicationSummaryList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListServerAlerts gets the details of an alert for a given Active Directory Domain Controller service and server
// combination.
// Parameters:
// serviceMemberID - the server Id for which the alert details needs to be queried.
// serviceName - the name of the service.
// filter - the alert property filter to apply.
// state - the alert state to query for.
// from - the start date to query for.
// toParameter - the end date till when to query for.
func (client AddsServicesClient) ListServerAlerts(ctx context.Context, serviceMemberID uuid.UUID, serviceName string, filter string, state string, from *date.Time, toParameter *date.Time) (result AlertsPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AddsServicesClient.ListServerAlerts")
		defer func() {
			sc := -1
			if result.a.Response.Response != nil {
				sc = result.a.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listServerAlertsNextResults
	req, err := client.ListServerAlertsPreparer(ctx, serviceMemberID, serviceName, filter, state, from, toParameter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "ListServerAlerts", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListServerAlertsSender(req)
	if err != nil {
		result.a.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "ListServerAlerts", resp, "Failure sending request")
		return
	}

	result.a, err = client.ListServerAlertsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "ListServerAlerts", resp, "Failure responding to request")
	}

	return
}

// ListServerAlertsPreparer prepares the ListServerAlerts request.
func (client AddsServicesClient) ListServerAlertsPreparer(ctx context.Context, serviceMemberID uuid.UUID, serviceName string, filter string, state string, from *date.Time, toParameter *date.Time) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"serviceMemberId": autorest.Encode("path", serviceMemberID),
		"serviceName":     autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(state) > 0 {
		queryParameters["state"] = autorest.Encode("query", state)
	}
	if from != nil {
		queryParameters["from"] = autorest.Encode("query", *from)
	}
	if toParameter != nil {
		queryParameters["to"] = autorest.Encode("query", *toParameter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/addsservices/{serviceName}/servicemembers/{serviceMemberId}/alerts", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListServerAlertsSender sends the ListServerAlerts request. The method will close the
// http.Response Body if it receives an error.
func (client AddsServicesClient) ListServerAlertsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListServerAlertsResponder handles the response to the ListServerAlerts request. The method always
// closes the http.Response Body.
func (client AddsServicesClient) ListServerAlertsResponder(resp *http.Response) (result Alerts, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listServerAlertsNextResults retrieves the next set of results, if any.
func (client AddsServicesClient) listServerAlertsNextResults(ctx context.Context, lastResults Alerts) (result Alerts, err error) {
	req, err := lastResults.alertsPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "listServerAlertsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListServerAlertsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "listServerAlertsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListServerAlertsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "listServerAlertsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListServerAlertsComplete enumerates all values, automatically crossing page boundaries as required.
func (client AddsServicesClient) ListServerAlertsComplete(ctx context.Context, serviceMemberID uuid.UUID, serviceName string, filter string, state string, from *date.Time, toParameter *date.Time) (result AlertsIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AddsServicesClient.ListServerAlerts")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListServerAlerts(ctx, serviceMemberID, serviceName, filter, state, from, toParameter)
	return
}

// Update updates an Active Directory Domain Service properties of an onboarded service.
// Parameters:
// serviceName - the name of the service which needs to be deleted.
// service - the service object.
func (client AddsServicesClient) Update(ctx context.Context, serviceName string, service ServiceProperties) (result ServiceProperties, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AddsServicesClient.Update")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdatePreparer(ctx, serviceName, service)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "Update", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "Update", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.AddsServicesClient", "Update", resp, "Failure responding to request")
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client AddsServicesClient) UpdatePreparer(ctx context.Context, serviceName string, service ServiceProperties) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"serviceName": autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/addsservices/{serviceName}", pathParameters),
		autorest.WithJSON(service),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client AddsServicesClient) UpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client AddsServicesClient) UpdateResponder(resp *http.Response) (result ServiceProperties, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
