// Package web implements the Azure ARM Web service API version 2018-02-01.
//
// WebSite Management Client
package web

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

const (
	// DefaultBaseURI is the default URI used for the service Web
	DefaultBaseURI = "https://management.azure.com"
)

// BaseClient is the base client for Web.
type BaseClient struct {
	autorest.Client
	BaseURI        string
	SubscriptionID string
}

// New creates an instance of the BaseClient client.
func New(subscriptionID string) BaseClient {
	return NewWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewWithBaseURI creates an instance of the BaseClient client using a custom endpoint.  Use this when interacting with
// an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return BaseClient{
		Client:         autorest.NewClientWithUserAgent(UserAgent()),
		BaseURI:        baseURI,
		SubscriptionID: subscriptionID,
	}
}

// CheckNameAvailability check if a resource name is available.
// Parameters:
// request - name availability request.
func (client BaseClient) CheckNameAvailability(ctx context.Context, request ResourceNameAvailabilityRequest) (result ResourceNameAvailability, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.CheckNameAvailability")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: request,
			Constraints: []validation.Constraint{{Target: "request.Name", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.BaseClient", "CheckNameAvailability", err.Error())
	}

	req, err := client.CheckNameAvailabilityPreparer(ctx, request)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "CheckNameAvailability", nil, "Failure preparing request")
		return
	}

	resp, err := client.CheckNameAvailabilitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.BaseClient", "CheckNameAvailability", resp, "Failure sending request")
		return
	}

	result, err = client.CheckNameAvailabilityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "CheckNameAvailability", resp, "Failure responding to request")
	}

	return
}

// CheckNameAvailabilityPreparer prepares the CheckNameAvailability request.
func (client BaseClient) CheckNameAvailabilityPreparer(ctx context.Context, request ResourceNameAvailabilityRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Web/checknameavailability", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CheckNameAvailabilitySender sends the CheckNameAvailability request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) CheckNameAvailabilitySender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CheckNameAvailabilityResponder handles the response to the CheckNameAvailability request. The method always
// closes the http.Response Body.
func (client BaseClient) CheckNameAvailabilityResponder(resp *http.Response) (result ResourceNameAvailability, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetPublishingUser gets publishing user
func (client BaseClient) GetPublishingUser(ctx context.Context) (result User, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetPublishingUser")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPublishingUserPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "GetPublishingUser", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetPublishingUserSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.BaseClient", "GetPublishingUser", resp, "Failure sending request")
		return
	}

	result, err = client.GetPublishingUserResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "GetPublishingUser", resp, "Failure responding to request")
	}

	return
}

// GetPublishingUserPreparer prepares the GetPublishingUser request.
func (client BaseClient) GetPublishingUserPreparer(ctx context.Context) (*http.Request, error) {
	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/providers/Microsoft.Web/publishingUsers/web"),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetPublishingUserSender sends the GetPublishingUser request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetPublishingUserSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetPublishingUserResponder handles the response to the GetPublishingUser request. The method always
// closes the http.Response Body.
func (client BaseClient) GetPublishingUserResponder(resp *http.Response) (result User, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSourceControl gets source control token
// Parameters:
// sourceControlType - type of source control
func (client BaseClient) GetSourceControl(ctx context.Context, sourceControlType string) (result SourceControl, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetSourceControl")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSourceControlPreparer(ctx, sourceControlType)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "GetSourceControl", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSourceControlSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.BaseClient", "GetSourceControl", resp, "Failure sending request")
		return
	}

	result, err = client.GetSourceControlResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "GetSourceControl", resp, "Failure responding to request")
	}

	return
}

// GetSourceControlPreparer prepares the GetSourceControl request.
func (client BaseClient) GetSourceControlPreparer(ctx context.Context, sourceControlType string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"sourceControlType": autorest.Encode("path", sourceControlType),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Web/sourcecontrols/{sourceControlType}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSourceControlSender sends the GetSourceControl request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetSourceControlSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetSourceControlResponder handles the response to the GetSourceControl request. The method always
// closes the http.Response Body.
func (client BaseClient) GetSourceControlResponder(resp *http.Response) (result SourceControl, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSubscriptionDeploymentLocations gets list of available geo regions plus ministamps
func (client BaseClient) GetSubscriptionDeploymentLocations(ctx context.Context) (result DeploymentLocations, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetSubscriptionDeploymentLocations")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSubscriptionDeploymentLocationsPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "GetSubscriptionDeploymentLocations", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSubscriptionDeploymentLocationsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.BaseClient", "GetSubscriptionDeploymentLocations", resp, "Failure sending request")
		return
	}

	result, err = client.GetSubscriptionDeploymentLocationsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "GetSubscriptionDeploymentLocations", resp, "Failure responding to request")
	}

	return
}

// GetSubscriptionDeploymentLocationsPreparer prepares the GetSubscriptionDeploymentLocations request.
func (client BaseClient) GetSubscriptionDeploymentLocationsPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Web/deploymentLocations", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSubscriptionDeploymentLocationsSender sends the GetSubscriptionDeploymentLocations request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetSubscriptionDeploymentLocationsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSubscriptionDeploymentLocationsResponder handles the response to the GetSubscriptionDeploymentLocations request. The method always
// closes the http.Response Body.
func (client BaseClient) GetSubscriptionDeploymentLocationsResponder(resp *http.Response) (result DeploymentLocations, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListBillingMeters gets a list of meters for a given location.
// Parameters:
// billingLocation - azure Location of billable resource
// osType - app Service OS type meters used for
func (client BaseClient) ListBillingMeters(ctx context.Context, billingLocation string, osType string) (result BillingMeterCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.ListBillingMeters")
		defer func() {
			sc := -1
			if result.bmc.Response.Response != nil {
				sc = result.bmc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listBillingMetersNextResults
	req, err := client.ListBillingMetersPreparer(ctx, billingLocation, osType)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "ListBillingMeters", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListBillingMetersSender(req)
	if err != nil {
		result.bmc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.BaseClient", "ListBillingMeters", resp, "Failure sending request")
		return
	}

	result.bmc, err = client.ListBillingMetersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "ListBillingMeters", resp, "Failure responding to request")
	}

	return
}

// ListBillingMetersPreparer prepares the ListBillingMeters request.
func (client BaseClient) ListBillingMetersPreparer(ctx context.Context, billingLocation string, osType string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(billingLocation) > 0 {
		queryParameters["billingLocation"] = autorest.Encode("query", billingLocation)
	}
	if len(osType) > 0 {
		queryParameters["osType"] = autorest.Encode("query", osType)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Web/billingMeters", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListBillingMetersSender sends the ListBillingMeters request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) ListBillingMetersSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListBillingMetersResponder handles the response to the ListBillingMeters request. The method always
// closes the http.Response Body.
func (client BaseClient) ListBillingMetersResponder(resp *http.Response) (result BillingMeterCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listBillingMetersNextResults retrieves the next set of results, if any.
func (client BaseClient) listBillingMetersNextResults(ctx context.Context, lastResults BillingMeterCollection) (result BillingMeterCollection, err error) {
	req, err := lastResults.billingMeterCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.BaseClient", "listBillingMetersNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListBillingMetersSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.BaseClient", "listBillingMetersNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListBillingMetersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "listBillingMetersNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListBillingMetersComplete enumerates all values, automatically crossing page boundaries as required.
func (client BaseClient) ListBillingMetersComplete(ctx context.Context, billingLocation string, osType string) (result BillingMeterCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.ListBillingMeters")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListBillingMeters(ctx, billingLocation, osType)
	return
}

// ListGeoRegions get a list of available geographical regions.
// Parameters:
// sku - name of SKU used to filter the regions.
// linuxWorkersEnabled - specify <code>true</code> if you want to filter to only regions that support Linux
// workers.
// xenonWorkersEnabled - specify <code>true</code> if you want to filter to only regions that support Xenon
// workers.
// linuxDynamicWorkersEnabled - specify <code>true</code> if you want to filter to only regions that support
// Linux Consumption Workers.
func (client BaseClient) ListGeoRegions(ctx context.Context, sku SkuName, linuxWorkersEnabled *bool, xenonWorkersEnabled *bool, linuxDynamicWorkersEnabled *bool) (result GeoRegionCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.ListGeoRegions")
		defer func() {
			sc := -1
			if result.grc.Response.Response != nil {
				sc = result.grc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listGeoRegionsNextResults
	req, err := client.ListGeoRegionsPreparer(ctx, sku, linuxWorkersEnabled, xenonWorkersEnabled, linuxDynamicWorkersEnabled)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "ListGeoRegions", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListGeoRegionsSender(req)
	if err != nil {
		result.grc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.BaseClient", "ListGeoRegions", resp, "Failure sending request")
		return
	}

	result.grc, err = client.ListGeoRegionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "ListGeoRegions", resp, "Failure responding to request")
	}

	return
}

// ListGeoRegionsPreparer prepares the ListGeoRegions request.
func (client BaseClient) ListGeoRegionsPreparer(ctx context.Context, sku SkuName, linuxWorkersEnabled *bool, xenonWorkersEnabled *bool, linuxDynamicWorkersEnabled *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(string(sku)) > 0 {
		queryParameters["sku"] = autorest.Encode("query", sku)
	}
	if linuxWorkersEnabled != nil {
		queryParameters["linuxWorkersEnabled"] = autorest.Encode("query", *linuxWorkersEnabled)
	}
	if xenonWorkersEnabled != nil {
		queryParameters["xenonWorkersEnabled"] = autorest.Encode("query", *xenonWorkersEnabled)
	}
	if linuxDynamicWorkersEnabled != nil {
		queryParameters["linuxDynamicWorkersEnabled"] = autorest.Encode("query", *linuxDynamicWorkersEnabled)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Web/geoRegions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListGeoRegionsSender sends the ListGeoRegions request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) ListGeoRegionsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListGeoRegionsResponder handles the response to the ListGeoRegions request. The method always
// closes the http.Response Body.
func (client BaseClient) ListGeoRegionsResponder(resp *http.Response) (result GeoRegionCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listGeoRegionsNextResults retrieves the next set of results, if any.
func (client BaseClient) listGeoRegionsNextResults(ctx context.Context, lastResults GeoRegionCollection) (result GeoRegionCollection, err error) {
	req, err := lastResults.geoRegionCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.BaseClient", "listGeoRegionsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListGeoRegionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.BaseClient", "listGeoRegionsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListGeoRegionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "listGeoRegionsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListGeoRegionsComplete enumerates all values, automatically crossing page boundaries as required.
func (client BaseClient) ListGeoRegionsComplete(ctx context.Context, sku SkuName, linuxWorkersEnabled *bool, xenonWorkersEnabled *bool, linuxDynamicWorkersEnabled *bool) (result GeoRegionCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.ListGeoRegions")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListGeoRegions(ctx, sku, linuxWorkersEnabled, xenonWorkersEnabled, linuxDynamicWorkersEnabled)
	return
}

// ListPremierAddOnOffers list all premier add-on offers.
func (client BaseClient) ListPremierAddOnOffers(ctx context.Context) (result PremierAddOnOfferCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.ListPremierAddOnOffers")
		defer func() {
			sc := -1
			if result.paooc.Response.Response != nil {
				sc = result.paooc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listPremierAddOnOffersNextResults
	req, err := client.ListPremierAddOnOffersPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "ListPremierAddOnOffers", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListPremierAddOnOffersSender(req)
	if err != nil {
		result.paooc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.BaseClient", "ListPremierAddOnOffers", resp, "Failure sending request")
		return
	}

	result.paooc, err = client.ListPremierAddOnOffersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "ListPremierAddOnOffers", resp, "Failure responding to request")
	}

	return
}

// ListPremierAddOnOffersPreparer prepares the ListPremierAddOnOffers request.
func (client BaseClient) ListPremierAddOnOffersPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Web/premieraddonoffers", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListPremierAddOnOffersSender sends the ListPremierAddOnOffers request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) ListPremierAddOnOffersSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListPremierAddOnOffersResponder handles the response to the ListPremierAddOnOffers request. The method always
// closes the http.Response Body.
func (client BaseClient) ListPremierAddOnOffersResponder(resp *http.Response) (result PremierAddOnOfferCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listPremierAddOnOffersNextResults retrieves the next set of results, if any.
func (client BaseClient) listPremierAddOnOffersNextResults(ctx context.Context, lastResults PremierAddOnOfferCollection) (result PremierAddOnOfferCollection, err error) {
	req, err := lastResults.premierAddOnOfferCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.BaseClient", "listPremierAddOnOffersNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListPremierAddOnOffersSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.BaseClient", "listPremierAddOnOffersNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListPremierAddOnOffersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "listPremierAddOnOffersNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListPremierAddOnOffersComplete enumerates all values, automatically crossing page boundaries as required.
func (client BaseClient) ListPremierAddOnOffersComplete(ctx context.Context) (result PremierAddOnOfferCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.ListPremierAddOnOffers")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListPremierAddOnOffers(ctx)
	return
}

// ListSiteIdentifiersAssignedToHostName list all apps that are assigned to a hostname.
// Parameters:
// nameIdentifier - hostname information.
func (client BaseClient) ListSiteIdentifiersAssignedToHostName(ctx context.Context, nameIdentifier NameIdentifier) (result IdentifierCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.ListSiteIdentifiersAssignedToHostName")
		defer func() {
			sc := -1
			if result.ic.Response.Response != nil {
				sc = result.ic.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listSiteIdentifiersAssignedToHostNameNextResults
	req, err := client.ListSiteIdentifiersAssignedToHostNamePreparer(ctx, nameIdentifier)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "ListSiteIdentifiersAssignedToHostName", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSiteIdentifiersAssignedToHostNameSender(req)
	if err != nil {
		result.ic.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.BaseClient", "ListSiteIdentifiersAssignedToHostName", resp, "Failure sending request")
		return
	}

	result.ic, err = client.ListSiteIdentifiersAssignedToHostNameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "ListSiteIdentifiersAssignedToHostName", resp, "Failure responding to request")
	}

	return
}

// ListSiteIdentifiersAssignedToHostNamePreparer prepares the ListSiteIdentifiersAssignedToHostName request.
func (client BaseClient) ListSiteIdentifiersAssignedToHostNamePreparer(ctx context.Context, nameIdentifier NameIdentifier) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Web/listSitesAssignedToHostName", pathParameters),
		autorest.WithJSON(nameIdentifier),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSiteIdentifiersAssignedToHostNameSender sends the ListSiteIdentifiersAssignedToHostName request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) ListSiteIdentifiersAssignedToHostNameSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSiteIdentifiersAssignedToHostNameResponder handles the response to the ListSiteIdentifiersAssignedToHostName request. The method always
// closes the http.Response Body.
func (client BaseClient) ListSiteIdentifiersAssignedToHostNameResponder(resp *http.Response) (result IdentifierCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listSiteIdentifiersAssignedToHostNameNextResults retrieves the next set of results, if any.
func (client BaseClient) listSiteIdentifiersAssignedToHostNameNextResults(ctx context.Context, lastResults IdentifierCollection) (result IdentifierCollection, err error) {
	req, err := lastResults.identifierCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.BaseClient", "listSiteIdentifiersAssignedToHostNameNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSiteIdentifiersAssignedToHostNameSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.BaseClient", "listSiteIdentifiersAssignedToHostNameNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListSiteIdentifiersAssignedToHostNameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "listSiteIdentifiersAssignedToHostNameNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListSiteIdentifiersAssignedToHostNameComplete enumerates all values, automatically crossing page boundaries as required.
func (client BaseClient) ListSiteIdentifiersAssignedToHostNameComplete(ctx context.Context, nameIdentifier NameIdentifier) (result IdentifierCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.ListSiteIdentifiersAssignedToHostName")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListSiteIdentifiersAssignedToHostName(ctx, nameIdentifier)
	return
}

// ListSkus list all SKUs.
func (client BaseClient) ListSkus(ctx context.Context) (result SkuInfos, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.ListSkus")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListSkusPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "ListSkus", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSkusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.BaseClient", "ListSkus", resp, "Failure sending request")
		return
	}

	result, err = client.ListSkusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "ListSkus", resp, "Failure responding to request")
	}

	return
}

// ListSkusPreparer prepares the ListSkus request.
func (client BaseClient) ListSkusPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Web/skus", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSkusSender sends the ListSkus request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) ListSkusSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSkusResponder handles the response to the ListSkus request. The method always
// closes the http.Response Body.
func (client BaseClient) ListSkusResponder(resp *http.Response) (result SkuInfos, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSourceControls gets the source controls available for Azure websites.
func (client BaseClient) ListSourceControls(ctx context.Context) (result SourceControlCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.ListSourceControls")
		defer func() {
			sc := -1
			if result.scc.Response.Response != nil {
				sc = result.scc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listSourceControlsNextResults
	req, err := client.ListSourceControlsPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "ListSourceControls", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSourceControlsSender(req)
	if err != nil {
		result.scc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.BaseClient", "ListSourceControls", resp, "Failure sending request")
		return
	}

	result.scc, err = client.ListSourceControlsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "ListSourceControls", resp, "Failure responding to request")
	}

	return
}

// ListSourceControlsPreparer prepares the ListSourceControls request.
func (client BaseClient) ListSourceControlsPreparer(ctx context.Context) (*http.Request, error) {
	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/providers/Microsoft.Web/sourcecontrols"),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSourceControlsSender sends the ListSourceControls request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) ListSourceControlsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListSourceControlsResponder handles the response to the ListSourceControls request. The method always
// closes the http.Response Body.
func (client BaseClient) ListSourceControlsResponder(resp *http.Response) (result SourceControlCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listSourceControlsNextResults retrieves the next set of results, if any.
func (client BaseClient) listSourceControlsNextResults(ctx context.Context, lastResults SourceControlCollection) (result SourceControlCollection, err error) {
	req, err := lastResults.sourceControlCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.BaseClient", "listSourceControlsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSourceControlsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.BaseClient", "listSourceControlsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListSourceControlsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "listSourceControlsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListSourceControlsComplete enumerates all values, automatically crossing page boundaries as required.
func (client BaseClient) ListSourceControlsComplete(ctx context.Context) (result SourceControlCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.ListSourceControls")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListSourceControls(ctx)
	return
}

// Move move resources between resource groups.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// moveResourceEnvelope - object that represents the resource to move.
func (client BaseClient) Move(ctx context.Context, resourceGroupName string, moveResourceEnvelope CsmMoveResourceEnvelope) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.Move")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: moveResourceEnvelope,
			Constraints: []validation.Constraint{{Target: "moveResourceEnvelope.TargetResourceGroup", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "moveResourceEnvelope.TargetResourceGroup", Name: validation.MaxLength, Rule: 90, Chain: nil},
					{Target: "moveResourceEnvelope.TargetResourceGroup", Name: validation.MinLength, Rule: 1, Chain: nil},
					{Target: "moveResourceEnvelope.TargetResourceGroup", Name: validation.Pattern, Rule: ` ^[-\w\._\(\)]+[^\.]$`, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("web.BaseClient", "Move", err.Error())
	}

	req, err := client.MovePreparer(ctx, resourceGroupName, moveResourceEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "Move", nil, "Failure preparing request")
		return
	}

	resp, err := client.MoveSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.BaseClient", "Move", resp, "Failure sending request")
		return
	}

	result, err = client.MoveResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "Move", resp, "Failure responding to request")
	}

	return
}

// MovePreparer prepares the Move request.
func (client BaseClient) MovePreparer(ctx context.Context, resourceGroupName string, moveResourceEnvelope CsmMoveResourceEnvelope) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/moveResources", pathParameters),
		autorest.WithJSON(moveResourceEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// MoveSender sends the Move request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) MoveSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// MoveResponder handles the response to the Move request. The method always
// closes the http.Response Body.
func (client BaseClient) MoveResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// UpdatePublishingUser updates publishing user
// Parameters:
// userDetails - details of publishing user
func (client BaseClient) UpdatePublishingUser(ctx context.Context, userDetails User) (result User, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.UpdatePublishingUser")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: userDetails,
			Constraints: []validation.Constraint{{Target: "userDetails.UserProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "userDetails.UserProperties.PublishingUserName", Name: validation.Null, Rule: true, Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("web.BaseClient", "UpdatePublishingUser", err.Error())
	}

	req, err := client.UpdatePublishingUserPreparer(ctx, userDetails)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "UpdatePublishingUser", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdatePublishingUserSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.BaseClient", "UpdatePublishingUser", resp, "Failure sending request")
		return
	}

	result, err = client.UpdatePublishingUserResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "UpdatePublishingUser", resp, "Failure responding to request")
	}

	return
}

// UpdatePublishingUserPreparer prepares the UpdatePublishingUser request.
func (client BaseClient) UpdatePublishingUserPreparer(ctx context.Context, userDetails User) (*http.Request, error) {
	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/providers/Microsoft.Web/publishingUsers/web"),
		autorest.WithJSON(userDetails),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdatePublishingUserSender sends the UpdatePublishingUser request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) UpdatePublishingUserSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdatePublishingUserResponder handles the response to the UpdatePublishingUser request. The method always
// closes the http.Response Body.
func (client BaseClient) UpdatePublishingUserResponder(resp *http.Response) (result User, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSourceControl updates source control token
// Parameters:
// sourceControlType - type of source control
// requestMessage - source control token information
func (client BaseClient) UpdateSourceControl(ctx context.Context, sourceControlType string, requestMessage SourceControl) (result SourceControl, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.UpdateSourceControl")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateSourceControlPreparer(ctx, sourceControlType, requestMessage)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "UpdateSourceControl", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSourceControlSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.BaseClient", "UpdateSourceControl", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateSourceControlResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "UpdateSourceControl", resp, "Failure responding to request")
	}

	return
}

// UpdateSourceControlPreparer prepares the UpdateSourceControl request.
func (client BaseClient) UpdateSourceControlPreparer(ctx context.Context, sourceControlType string, requestMessage SourceControl) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"sourceControlType": autorest.Encode("path", sourceControlType),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Web/sourcecontrols/{sourceControlType}", pathParameters),
		autorest.WithJSON(requestMessage),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSourceControlSender sends the UpdateSourceControl request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) UpdateSourceControlSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateSourceControlResponder handles the response to the UpdateSourceControl request. The method always
// closes the http.Response Body.
func (client BaseClient) UpdateSourceControlResponder(resp *http.Response) (result SourceControl, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Validate validate if a resource can be created.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// validateRequest - request with the resources to validate.
func (client BaseClient) Validate(ctx context.Context, resourceGroupName string, validateRequest ValidateRequest) (result ValidateResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.Validate")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: validateRequest,
			Constraints: []validation.Constraint{{Target: "validateRequest.Name", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "validateRequest.Location", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "validateRequest.ValidateProperties", Name: validation.Null, Rule: true,
					Chain: []validation.Constraint{{Target: "validateRequest.ValidateProperties.Capacity", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "validateRequest.ValidateProperties.Capacity", Name: validation.InclusiveMinimum, Rule: int64(1), Chain: nil}}},
					}}}}}); err != nil {
		return result, validation.NewError("web.BaseClient", "Validate", err.Error())
	}

	req, err := client.ValidatePreparer(ctx, resourceGroupName, validateRequest)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "Validate", nil, "Failure preparing request")
		return
	}

	resp, err := client.ValidateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.BaseClient", "Validate", resp, "Failure sending request")
		return
	}

	result, err = client.ValidateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "Validate", resp, "Failure responding to request")
	}

	return
}

// ValidatePreparer prepares the Validate request.
func (client BaseClient) ValidatePreparer(ctx context.Context, resourceGroupName string, validateRequest ValidateRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/validate", pathParameters),
		autorest.WithJSON(validateRequest),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ValidateSender sends the Validate request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) ValidateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ValidateResponder handles the response to the Validate request. The method always
// closes the http.Response Body.
func (client BaseClient) ValidateResponder(resp *http.Response) (result ValidateResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ValidateContainerSettings validate if the container settings are correct.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
func (client BaseClient) ValidateContainerSettings(ctx context.Context, validateContainerSettingsRequest ValidateContainerSettingsRequest, resourceGroupName string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.ValidateContainerSettings")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.BaseClient", "ValidateContainerSettings", err.Error())
	}

	req, err := client.ValidateContainerSettingsPreparer(ctx, validateContainerSettingsRequest, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "ValidateContainerSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.ValidateContainerSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.BaseClient", "ValidateContainerSettings", resp, "Failure sending request")
		return
	}

	result, err = client.ValidateContainerSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "ValidateContainerSettings", resp, "Failure responding to request")
	}

	return
}

// ValidateContainerSettingsPreparer prepares the ValidateContainerSettings request.
func (client BaseClient) ValidateContainerSettingsPreparer(ctx context.Context, validateContainerSettingsRequest ValidateContainerSettingsRequest, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/validateContainerSettings", pathParameters),
		autorest.WithJSON(validateContainerSettingsRequest),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ValidateContainerSettingsSender sends the ValidateContainerSettings request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) ValidateContainerSettingsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ValidateContainerSettingsResponder handles the response to the ValidateContainerSettings request. The method always
// closes the http.Response Body.
func (client BaseClient) ValidateContainerSettingsResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ValidateMove validate whether a resource can be moved.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// moveResourceEnvelope - object that represents the resource to move.
func (client BaseClient) ValidateMove(ctx context.Context, resourceGroupName string, moveResourceEnvelope CsmMoveResourceEnvelope) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.ValidateMove")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: moveResourceEnvelope,
			Constraints: []validation.Constraint{{Target: "moveResourceEnvelope.TargetResourceGroup", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "moveResourceEnvelope.TargetResourceGroup", Name: validation.MaxLength, Rule: 90, Chain: nil},
					{Target: "moveResourceEnvelope.TargetResourceGroup", Name: validation.MinLength, Rule: 1, Chain: nil},
					{Target: "moveResourceEnvelope.TargetResourceGroup", Name: validation.Pattern, Rule: ` ^[-\w\._\(\)]+[^\.]$`, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("web.BaseClient", "ValidateMove", err.Error())
	}

	req, err := client.ValidateMovePreparer(ctx, resourceGroupName, moveResourceEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "ValidateMove", nil, "Failure preparing request")
		return
	}

	resp, err := client.ValidateMoveSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.BaseClient", "ValidateMove", resp, "Failure sending request")
		return
	}

	result, err = client.ValidateMoveResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "ValidateMove", resp, "Failure responding to request")
	}

	return
}

// ValidateMovePreparer prepares the ValidateMove request.
func (client BaseClient) ValidateMovePreparer(ctx context.Context, resourceGroupName string, moveResourceEnvelope CsmMoveResourceEnvelope) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/validateMoveResources", pathParameters),
		autorest.WithJSON(moveResourceEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ValidateMoveSender sends the ValidateMove request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) ValidateMoveSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ValidateMoveResponder handles the response to the ValidateMove request. The method always
// closes the http.Response Body.
func (client BaseClient) ValidateMoveResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// VerifyHostingEnvironmentVnet verifies if this VNET is compatible with an App Service Environment by analyzing the
// Network Security Group rules.
// Parameters:
// parameters - VNET information
func (client BaseClient) VerifyHostingEnvironmentVnet(ctx context.Context, parameters VnetParameters) (result VnetValidationFailureDetails, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.VerifyHostingEnvironmentVnet")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.VerifyHostingEnvironmentVnetPreparer(ctx, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "VerifyHostingEnvironmentVnet", nil, "Failure preparing request")
		return
	}

	resp, err := client.VerifyHostingEnvironmentVnetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.BaseClient", "VerifyHostingEnvironmentVnet", resp, "Failure sending request")
		return
	}

	result, err = client.VerifyHostingEnvironmentVnetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.BaseClient", "VerifyHostingEnvironmentVnet", resp, "Failure responding to request")
	}

	return
}

// VerifyHostingEnvironmentVnetPreparer prepares the VerifyHostingEnvironmentVnet request.
func (client BaseClient) VerifyHostingEnvironmentVnetPreparer(ctx context.Context, parameters VnetParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Web/verifyHostingEnvironmentVnet", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// VerifyHostingEnvironmentVnetSender sends the VerifyHostingEnvironmentVnet request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) VerifyHostingEnvironmentVnetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// VerifyHostingEnvironmentVnetResponder handles the response to the VerifyHostingEnvironmentVnet request. The method always
// closes the http.Response Body.
func (client BaseClient) VerifyHostingEnvironmentVnetResponder(resp *http.Response) (result VnetValidationFailureDetails, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
