package siterecovery

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// MigrationRecoveryPointsClient is the client for the MigrationRecoveryPoints methods of the Siterecovery service.
type MigrationRecoveryPointsClient struct {
	BaseClient
}

// NewMigrationRecoveryPointsClient creates an instance of the MigrationRecoveryPointsClient client.
func NewMigrationRecoveryPointsClient(subscriptionID string, resourceGroupName string, resourceName string) MigrationRecoveryPointsClient {
	return NewMigrationRecoveryPointsClientWithBaseURI(DefaultBaseURI, subscriptionID, resourceGroupName, resourceName)
}

// NewMigrationRecoveryPointsClientWithBaseURI creates an instance of the MigrationRecoveryPointsClient client using a
// custom endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds,
// Azure stack).
func NewMigrationRecoveryPointsClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) MigrationRecoveryPointsClient {
	return MigrationRecoveryPointsClient{NewWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)}
}

// Get sends the get request.
// Parameters:
// fabricName - fabric unique name.
// protectionContainerName - protection container name.
// migrationItemName - migration item name.
// migrationRecoveryPointName - the migration recovery point name.
func (client MigrationRecoveryPointsClient) Get(ctx context.Context, fabricName string, protectionContainerName string, migrationItemName string, migrationRecoveryPointName string) (result MigrationRecoveryPoint, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MigrationRecoveryPointsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, fabricName, protectionContainerName, migrationItemName, migrationRecoveryPointName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.MigrationRecoveryPointsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "siterecovery.MigrationRecoveryPointsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.MigrationRecoveryPointsClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client MigrationRecoveryPointsClient) GetPreparer(ctx context.Context, fabricName string, protectionContainerName string, migrationItemName string, migrationRecoveryPointName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"fabricName":                 autorest.Encode("path", fabricName),
		"migrationItemName":          autorest.Encode("path", migrationItemName),
		"migrationRecoveryPointName": autorest.Encode("path", migrationRecoveryPointName),
		"protectionContainerName":    autorest.Encode("path", protectionContainerName),
		"resourceGroupName":          autorest.Encode("path", client.ResourceGroupName),
		"resourceName":               autorest.Encode("path", client.ResourceName),
		"subscriptionId":             autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-07-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationMigrationItems/{migrationItemName}/migrationRecoveryPoints/{migrationRecoveryPointName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client MigrationRecoveryPointsClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client MigrationRecoveryPointsClient) GetResponder(resp *http.Response) (result MigrationRecoveryPoint, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByReplicationMigrationItems sends the list by replication migration items request.
// Parameters:
// fabricName - fabric unique name.
// protectionContainerName - protection container name.
// migrationItemName - migration item name.
func (client MigrationRecoveryPointsClient) ListByReplicationMigrationItems(ctx context.Context, fabricName string, protectionContainerName string, migrationItemName string) (result MigrationRecoveryPointCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MigrationRecoveryPointsClient.ListByReplicationMigrationItems")
		defer func() {
			sc := -1
			if result.mrpc.Response.Response != nil {
				sc = result.mrpc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listByReplicationMigrationItemsNextResults
	req, err := client.ListByReplicationMigrationItemsPreparer(ctx, fabricName, protectionContainerName, migrationItemName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.MigrationRecoveryPointsClient", "ListByReplicationMigrationItems", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByReplicationMigrationItemsSender(req)
	if err != nil {
		result.mrpc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "siterecovery.MigrationRecoveryPointsClient", "ListByReplicationMigrationItems", resp, "Failure sending request")
		return
	}

	result.mrpc, err = client.ListByReplicationMigrationItemsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.MigrationRecoveryPointsClient", "ListByReplicationMigrationItems", resp, "Failure responding to request")
	}

	return
}

// ListByReplicationMigrationItemsPreparer prepares the ListByReplicationMigrationItems request.
func (client MigrationRecoveryPointsClient) ListByReplicationMigrationItemsPreparer(ctx context.Context, fabricName string, protectionContainerName string, migrationItemName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"fabricName":              autorest.Encode("path", fabricName),
		"migrationItemName":       autorest.Encode("path", migrationItemName),
		"protectionContainerName": autorest.Encode("path", protectionContainerName),
		"resourceGroupName":       autorest.Encode("path", client.ResourceGroupName),
		"resourceName":            autorest.Encode("path", client.ResourceName),
		"subscriptionId":          autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-07-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationMigrationItems/{migrationItemName}/migrationRecoveryPoints", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByReplicationMigrationItemsSender sends the ListByReplicationMigrationItems request. The method will close the
// http.Response Body if it receives an error.
func (client MigrationRecoveryPointsClient) ListByReplicationMigrationItemsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByReplicationMigrationItemsResponder handles the response to the ListByReplicationMigrationItems request. The method always
// closes the http.Response Body.
func (client MigrationRecoveryPointsClient) ListByReplicationMigrationItemsResponder(resp *http.Response) (result MigrationRecoveryPointCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByReplicationMigrationItemsNextResults retrieves the next set of results, if any.
func (client MigrationRecoveryPointsClient) listByReplicationMigrationItemsNextResults(ctx context.Context, lastResults MigrationRecoveryPointCollection) (result MigrationRecoveryPointCollection, err error) {
	req, err := lastResults.migrationRecoveryPointCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "siterecovery.MigrationRecoveryPointsClient", "listByReplicationMigrationItemsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByReplicationMigrationItemsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "siterecovery.MigrationRecoveryPointsClient", "listByReplicationMigrationItemsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByReplicationMigrationItemsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.MigrationRecoveryPointsClient", "listByReplicationMigrationItemsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByReplicationMigrationItemsComplete enumerates all values, automatically crossing page boundaries as required.
func (client MigrationRecoveryPointsClient) ListByReplicationMigrationItemsComplete(ctx context.Context, fabricName string, protectionContainerName string, migrationItemName string) (result MigrationRecoveryPointCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MigrationRecoveryPointsClient.ListByReplicationMigrationItems")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByReplicationMigrationItems(ctx, fabricName, protectionContainerName, migrationItemName)
	return
}
