package softwareplan

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// HybridUseBenefitRevisionClient is the azure software plans let users create and manage licenses for various software
// used in Azure.
type HybridUseBenefitRevisionClient struct {
	BaseClient
}

// NewHybridUseBenefitRevisionClient creates an instance of the HybridUseBenefitRevisionClient client.
func NewHybridUseBenefitRevisionClient(subscriptionID string) HybridUseBenefitRevisionClient {
	return NewHybridUseBenefitRevisionClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewHybridUseBenefitRevisionClientWithBaseURI creates an instance of the HybridUseBenefitRevisionClient client using
// a custom endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign
// clouds, Azure stack).
func NewHybridUseBenefitRevisionClientWithBaseURI(baseURI string, subscriptionID string) HybridUseBenefitRevisionClient {
	return HybridUseBenefitRevisionClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// List gets the version history of a hybrid use benefit
// Parameters:
// scope - the scope at which the operation is performed. This is limited to Microsoft.Compute/virtualMachines
// and Microsoft.Compute/hostGroups/hosts for now
// planID - this is a unique identifier for a plan. Should be a guid.
func (client HybridUseBenefitRevisionClient) List(ctx context.Context, scope string, planID string) (result HybridUseBenefitListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HybridUseBenefitRevisionClient.List")
		defer func() {
			sc := -1
			if result.hublr.Response.Response != nil {
				sc = result.hublr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, scope, planID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "softwareplan.HybridUseBenefitRevisionClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.hublr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "softwareplan.HybridUseBenefitRevisionClient", "List", resp, "Failure sending request")
		return
	}

	result.hublr, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "softwareplan.HybridUseBenefitRevisionClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client HybridUseBenefitRevisionClient) ListPreparer(ctx context.Context, scope string, planID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"planId": autorest.Encode("path", planID),
		"scope":  autorest.Encode("path", scope),
	}

	const APIVersion = "2019-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.SoftwarePlan/hybridUseBenefits/{planId}/revisions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client HybridUseBenefitRevisionClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client HybridUseBenefitRevisionClient) ListResponder(resp *http.Response) (result HybridUseBenefitListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client HybridUseBenefitRevisionClient) listNextResults(ctx context.Context, lastResults HybridUseBenefitListResult) (result HybridUseBenefitListResult, err error) {
	req, err := lastResults.hybridUseBenefitListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "softwareplan.HybridUseBenefitRevisionClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "softwareplan.HybridUseBenefitRevisionClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "softwareplan.HybridUseBenefitRevisionClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client HybridUseBenefitRevisionClient) ListComplete(ctx context.Context, scope string, planID string) (result HybridUseBenefitListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HybridUseBenefitRevisionClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx, scope, planID)
	return
}
