package migrate

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/migrate/mgmt/2018-09-01-preview/migrate"

// CleanupState enumerates the values for cleanup state.
type CleanupState string

const (
	// Completed ...
	Completed CleanupState = "Completed"
	// Failed ...
	Failed CleanupState = "Failed"
	// InProgress ...
	InProgress CleanupState = "InProgress"
	// None ...
	None CleanupState = "None"
	// Started ...
	Started CleanupState = "Started"
)

// PossibleCleanupStateValues returns an array of possible values for the CleanupState const type.
func PossibleCleanupStateValues() []CleanupState {
	return []CleanupState{Completed, Failed, InProgress, None, Started}
}

// ContainerElementKind enumerates the values for container element kind.
type ContainerElementKind string

const (
	// ContainerElementKindActionImport ...
	ContainerElementKindActionImport ContainerElementKind = "ActionImport"
	// ContainerElementKindEntitySet ...
	ContainerElementKindEntitySet ContainerElementKind = "EntitySet"
	// ContainerElementKindFunctionImport ...
	ContainerElementKindFunctionImport ContainerElementKind = "FunctionImport"
	// ContainerElementKindNone ...
	ContainerElementKindNone ContainerElementKind = "None"
	// ContainerElementKindSingleton ...
	ContainerElementKindSingleton ContainerElementKind = "Singleton"
)

// PossibleContainerElementKindValues returns an array of possible values for the ContainerElementKind const type.
func PossibleContainerElementKindValues() []ContainerElementKind {
	return []ContainerElementKind{ContainerElementKindActionImport, ContainerElementKindEntitySet, ContainerElementKindFunctionImport, ContainerElementKindNone, ContainerElementKindSingleton}
}

// ExpressionKind enumerates the values for expression kind.
type ExpressionKind string

const (
	// ExpressionKindAnnotationPath ...
	ExpressionKindAnnotationPath ExpressionKind = "AnnotationPath"
	// ExpressionKindBinaryConstant ...
	ExpressionKindBinaryConstant ExpressionKind = "BinaryConstant"
	// ExpressionKindBooleanConstant ...
	ExpressionKindBooleanConstant ExpressionKind = "BooleanConstant"
	// ExpressionKindCast ...
	ExpressionKindCast ExpressionKind = "Cast"
	// ExpressionKindCollection ...
	ExpressionKindCollection ExpressionKind = "Collection"
	// ExpressionKindDateConstant ...
	ExpressionKindDateConstant ExpressionKind = "DateConstant"
	// ExpressionKindDateTimeOffsetConstant ...
	ExpressionKindDateTimeOffsetConstant ExpressionKind = "DateTimeOffsetConstant"
	// ExpressionKindDecimalConstant ...
	ExpressionKindDecimalConstant ExpressionKind = "DecimalConstant"
	// ExpressionKindDurationConstant ...
	ExpressionKindDurationConstant ExpressionKind = "DurationConstant"
	// ExpressionKindEnumMember ...
	ExpressionKindEnumMember ExpressionKind = "EnumMember"
	// ExpressionKindFloatingConstant ...
	ExpressionKindFloatingConstant ExpressionKind = "FloatingConstant"
	// ExpressionKindFunctionApplication ...
	ExpressionKindFunctionApplication ExpressionKind = "FunctionApplication"
	// ExpressionKindGUIDConstant ...
	ExpressionKindGUIDConstant ExpressionKind = "GuidConstant"
	// ExpressionKindIf ...
	ExpressionKindIf ExpressionKind = "If"
	// ExpressionKindIntegerConstant ...
	ExpressionKindIntegerConstant ExpressionKind = "IntegerConstant"
	// ExpressionKindIsType ...
	ExpressionKindIsType ExpressionKind = "IsType"
	// ExpressionKindLabeled ...
	ExpressionKindLabeled ExpressionKind = "Labeled"
	// ExpressionKindLabeledExpressionReference ...
	ExpressionKindLabeledExpressionReference ExpressionKind = "LabeledExpressionReference"
	// ExpressionKindNavigationPropertyPath ...
	ExpressionKindNavigationPropertyPath ExpressionKind = "NavigationPropertyPath"
	// ExpressionKindNone ...
	ExpressionKindNone ExpressionKind = "None"
	// ExpressionKindNull ...
	ExpressionKindNull ExpressionKind = "Null"
	// ExpressionKindPath ...
	ExpressionKindPath ExpressionKind = "Path"
	// ExpressionKindPropertyPath ...
	ExpressionKindPropertyPath ExpressionKind = "PropertyPath"
	// ExpressionKindRecord ...
	ExpressionKindRecord ExpressionKind = "Record"
	// ExpressionKindStringConstant ...
	ExpressionKindStringConstant ExpressionKind = "StringConstant"
	// ExpressionKindTimeOfDayConstant ...
	ExpressionKindTimeOfDayConstant ExpressionKind = "TimeOfDayConstant"
)

// PossibleExpressionKindValues returns an array of possible values for the ExpressionKind const type.
func PossibleExpressionKindValues() []ExpressionKind {
	return []ExpressionKind{ExpressionKindAnnotationPath, ExpressionKindBinaryConstant, ExpressionKindBooleanConstant, ExpressionKindCast, ExpressionKindCollection, ExpressionKindDateConstant, ExpressionKindDateTimeOffsetConstant, ExpressionKindDecimalConstant, ExpressionKindDurationConstant, ExpressionKindEnumMember, ExpressionKindFloatingConstant, ExpressionKindFunctionApplication, ExpressionKindGUIDConstant, ExpressionKindIf, ExpressionKindIntegerConstant, ExpressionKindIsType, ExpressionKindLabeled, ExpressionKindLabeledExpressionReference, ExpressionKindNavigationPropertyPath, ExpressionKindNone, ExpressionKindNull, ExpressionKindPath, ExpressionKindPropertyPath, ExpressionKindRecord, ExpressionKindStringConstant, ExpressionKindTimeOfDayConstant}
}

// ExpressionKind1 enumerates the values for expression kind 1.
type ExpressionKind1 string

const (
	// ExpressionKind1AnnotationPath ...
	ExpressionKind1AnnotationPath ExpressionKind1 = "AnnotationPath"
	// ExpressionKind1BinaryConstant ...
	ExpressionKind1BinaryConstant ExpressionKind1 = "BinaryConstant"
	// ExpressionKind1BooleanConstant ...
	ExpressionKind1BooleanConstant ExpressionKind1 = "BooleanConstant"
	// ExpressionKind1Cast ...
	ExpressionKind1Cast ExpressionKind1 = "Cast"
	// ExpressionKind1Collection ...
	ExpressionKind1Collection ExpressionKind1 = "Collection"
	// ExpressionKind1DateConstant ...
	ExpressionKind1DateConstant ExpressionKind1 = "DateConstant"
	// ExpressionKind1DateTimeOffsetConstant ...
	ExpressionKind1DateTimeOffsetConstant ExpressionKind1 = "DateTimeOffsetConstant"
	// ExpressionKind1DecimalConstant ...
	ExpressionKind1DecimalConstant ExpressionKind1 = "DecimalConstant"
	// ExpressionKind1DurationConstant ...
	ExpressionKind1DurationConstant ExpressionKind1 = "DurationConstant"
	// ExpressionKind1EnumMember ...
	ExpressionKind1EnumMember ExpressionKind1 = "EnumMember"
	// ExpressionKind1FloatingConstant ...
	ExpressionKind1FloatingConstant ExpressionKind1 = "FloatingConstant"
	// ExpressionKind1FunctionApplication ...
	ExpressionKind1FunctionApplication ExpressionKind1 = "FunctionApplication"
	// ExpressionKind1GUIDConstant ...
	ExpressionKind1GUIDConstant ExpressionKind1 = "GuidConstant"
	// ExpressionKind1If ...
	ExpressionKind1If ExpressionKind1 = "If"
	// ExpressionKind1IntegerConstant ...
	ExpressionKind1IntegerConstant ExpressionKind1 = "IntegerConstant"
	// ExpressionKind1IsType ...
	ExpressionKind1IsType ExpressionKind1 = "IsType"
	// ExpressionKind1Labeled ...
	ExpressionKind1Labeled ExpressionKind1 = "Labeled"
	// ExpressionKind1LabeledExpressionReference ...
	ExpressionKind1LabeledExpressionReference ExpressionKind1 = "LabeledExpressionReference"
	// ExpressionKind1NavigationPropertyPath ...
	ExpressionKind1NavigationPropertyPath ExpressionKind1 = "NavigationPropertyPath"
	// ExpressionKind1None ...
	ExpressionKind1None ExpressionKind1 = "None"
	// ExpressionKind1Null ...
	ExpressionKind1Null ExpressionKind1 = "Null"
	// ExpressionKind1Path ...
	ExpressionKind1Path ExpressionKind1 = "Path"
	// ExpressionKind1PropertyPath ...
	ExpressionKind1PropertyPath ExpressionKind1 = "PropertyPath"
	// ExpressionKind1Record ...
	ExpressionKind1Record ExpressionKind1 = "Record"
	// ExpressionKind1StringConstant ...
	ExpressionKind1StringConstant ExpressionKind1 = "StringConstant"
	// ExpressionKind1TimeOfDayConstant ...
	ExpressionKind1TimeOfDayConstant ExpressionKind1 = "TimeOfDayConstant"
)

// PossibleExpressionKind1Values returns an array of possible values for the ExpressionKind1 const type.
func PossibleExpressionKind1Values() []ExpressionKind1 {
	return []ExpressionKind1{ExpressionKind1AnnotationPath, ExpressionKind1BinaryConstant, ExpressionKind1BooleanConstant, ExpressionKind1Cast, ExpressionKind1Collection, ExpressionKind1DateConstant, ExpressionKind1DateTimeOffsetConstant, ExpressionKind1DecimalConstant, ExpressionKind1DurationConstant, ExpressionKind1EnumMember, ExpressionKind1FloatingConstant, ExpressionKind1FunctionApplication, ExpressionKind1GUIDConstant, ExpressionKind1If, ExpressionKind1IntegerConstant, ExpressionKind1IsType, ExpressionKind1Labeled, ExpressionKind1LabeledExpressionReference, ExpressionKind1NavigationPropertyPath, ExpressionKind1None, ExpressionKind1Null, ExpressionKind1Path, ExpressionKind1PropertyPath, ExpressionKind1Record, ExpressionKind1StringConstant, ExpressionKind1TimeOfDayConstant}
}

// Goal enumerates the values for goal.
type Goal string

const (
	// Databases ...
	Databases Goal = "Databases"
	// Servers ...
	Servers Goal = "Servers"
)

// PossibleGoalValues returns an array of possible values for the Goal const type.
func PossibleGoalValues() []Goal {
	return []Goal{Databases, Servers}
}

// Goal1 enumerates the values for goal 1.
type Goal1 string

const (
	// Goal1Databases ...
	Goal1Databases Goal1 = "Databases"
	// Goal1Servers ...
	Goal1Servers Goal1 = "Servers"
)

// PossibleGoal1Values returns an array of possible values for the Goal1 const type.
func PossibleGoal1Values() []Goal1 {
	return []Goal1{Goal1Databases, Goal1Servers}
}

// InstanceType enumerates the values for instance type.
type InstanceType string

const (
	// InstanceTypeDatabases ...
	InstanceTypeDatabases InstanceType = "Databases"
	// InstanceTypeMigrateEventProperties ...
	InstanceTypeMigrateEventProperties InstanceType = "MigrateEventProperties"
	// InstanceTypeServers ...
	InstanceTypeServers InstanceType = "Servers"
)

// PossibleInstanceTypeValues returns an array of possible values for the InstanceType const type.
func PossibleInstanceTypeValues() []InstanceType {
	return []InstanceType{InstanceTypeDatabases, InstanceTypeMigrateEventProperties, InstanceTypeServers}
}

// InstanceTypeBasicProjectSummary enumerates the values for instance type basic project summary.
type InstanceTypeBasicProjectSummary string

const (
	// InstanceTypeBasicProjectSummaryInstanceTypeDatabases ...
	InstanceTypeBasicProjectSummaryInstanceTypeDatabases InstanceTypeBasicProjectSummary = "Databases"
	// InstanceTypeBasicProjectSummaryInstanceTypeProjectSummary ...
	InstanceTypeBasicProjectSummaryInstanceTypeProjectSummary InstanceTypeBasicProjectSummary = "ProjectSummary"
	// InstanceTypeBasicProjectSummaryInstanceTypeServers ...
	InstanceTypeBasicProjectSummaryInstanceTypeServers InstanceTypeBasicProjectSummary = "Servers"
)

// PossibleInstanceTypeBasicProjectSummaryValues returns an array of possible values for the InstanceTypeBasicProjectSummary const type.
func PossibleInstanceTypeBasicProjectSummaryValues() []InstanceTypeBasicProjectSummary {
	return []InstanceTypeBasicProjectSummary{InstanceTypeBasicProjectSummaryInstanceTypeDatabases, InstanceTypeBasicProjectSummaryInstanceTypeProjectSummary, InstanceTypeBasicProjectSummaryInstanceTypeServers}
}

// InstanceTypeBasicSolutionSummary enumerates the values for instance type basic solution summary.
type InstanceTypeBasicSolutionSummary string

const (
	// InstanceTypeBasicSolutionSummaryInstanceTypeDatabases ...
	InstanceTypeBasicSolutionSummaryInstanceTypeDatabases InstanceTypeBasicSolutionSummary = "Databases"
	// InstanceTypeBasicSolutionSummaryInstanceTypeServers ...
	InstanceTypeBasicSolutionSummaryInstanceTypeServers InstanceTypeBasicSolutionSummary = "Servers"
	// InstanceTypeBasicSolutionSummaryInstanceTypeSolutionSummary ...
	InstanceTypeBasicSolutionSummaryInstanceTypeSolutionSummary InstanceTypeBasicSolutionSummary = "SolutionSummary"
)

// PossibleInstanceTypeBasicSolutionSummaryValues returns an array of possible values for the InstanceTypeBasicSolutionSummary const type.
func PossibleInstanceTypeBasicSolutionSummaryValues() []InstanceTypeBasicSolutionSummary {
	return []InstanceTypeBasicSolutionSummary{InstanceTypeBasicSolutionSummaryInstanceTypeDatabases, InstanceTypeBasicSolutionSummaryInstanceTypeServers, InstanceTypeBasicSolutionSummaryInstanceTypeSolutionSummary}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// KindAggregatedCollectionPropertyNode ...
	KindAggregatedCollectionPropertyNode Kind = "AggregatedCollectionPropertyNode"
	// KindAll ...
	KindAll Kind = "All"
	// KindAny ...
	KindAny Kind = "Any"
	// KindBinaryOperator ...
	KindBinaryOperator Kind = "BinaryOperator"
	// KindCollectionComplexNode ...
	KindCollectionComplexNode Kind = "CollectionComplexNode"
	// KindCollectionConstant ...
	KindCollectionConstant Kind = "CollectionConstant"
	// KindCollectionFunctionCall ...
	KindCollectionFunctionCall Kind = "CollectionFunctionCall"
	// KindCollectionNavigationNode ...
	KindCollectionNavigationNode Kind = "CollectionNavigationNode"
	// KindCollectionOpenPropertyAccess ...
	KindCollectionOpenPropertyAccess Kind = "CollectionOpenPropertyAccess"
	// KindCollectionPropertyAccess ...
	KindCollectionPropertyAccess Kind = "CollectionPropertyAccess"
	// KindCollectionPropertyNode ...
	KindCollectionPropertyNode Kind = "CollectionPropertyNode"
	// KindCollectionResourceCast ...
	KindCollectionResourceCast Kind = "CollectionResourceCast"
	// KindCollectionResourceFunctionCall ...
	KindCollectionResourceFunctionCall Kind = "CollectionResourceFunctionCall"
	// KindConstant ...
	KindConstant Kind = "Constant"
	// KindConvert ...
	KindConvert Kind = "Convert"
	// KindCount ...
	KindCount Kind = "Count"
	// KindEntitySet ...
	KindEntitySet Kind = "EntitySet"
	// KindIn ...
	KindIn Kind = "In"
	// KindKeyLookup ...
	KindKeyLookup Kind = "KeyLookup"
	// KindNamedFunctionParameter ...
	KindNamedFunctionParameter Kind = "NamedFunctionParameter"
	// KindNone ...
	KindNone Kind = "None"
	// KindNonResourceRangeVariableReference ...
	KindNonResourceRangeVariableReference Kind = "NonResourceRangeVariableReference"
	// KindParameterAlias ...
	KindParameterAlias Kind = "ParameterAlias"
	// KindResourceRangeVariableReference ...
	KindResourceRangeVariableReference Kind = "ResourceRangeVariableReference"
	// KindSearchTerm ...
	KindSearchTerm Kind = "SearchTerm"
	// KindSingleComplexNode ...
	KindSingleComplexNode Kind = "SingleComplexNode"
	// KindSingleNavigationNode ...
	KindSingleNavigationNode Kind = "SingleNavigationNode"
	// KindSingleResourceCast ...
	KindSingleResourceCast Kind = "SingleResourceCast"
	// KindSingleResourceFunctionCall ...
	KindSingleResourceFunctionCall Kind = "SingleResourceFunctionCall"
	// KindSingleValueCast ...
	KindSingleValueCast Kind = "SingleValueCast"
	// KindSingleValueFunctionCall ...
	KindSingleValueFunctionCall Kind = "SingleValueFunctionCall"
	// KindSingleValueOpenPropertyAccess ...
	KindSingleValueOpenPropertyAccess Kind = "SingleValueOpenPropertyAccess"
	// KindSingleValuePropertyAccess ...
	KindSingleValuePropertyAccess Kind = "SingleValuePropertyAccess"
	// KindUnaryOperator ...
	KindUnaryOperator Kind = "UnaryOperator"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{KindAggregatedCollectionPropertyNode, KindAll, KindAny, KindBinaryOperator, KindCollectionComplexNode, KindCollectionConstant, KindCollectionFunctionCall, KindCollectionNavigationNode, KindCollectionOpenPropertyAccess, KindCollectionPropertyAccess, KindCollectionPropertyNode, KindCollectionResourceCast, KindCollectionResourceFunctionCall, KindConstant, KindConvert, KindCount, KindEntitySet, KindIn, KindKeyLookup, KindNamedFunctionParameter, KindNone, KindNonResourceRangeVariableReference, KindParameterAlias, KindResourceRangeVariableReference, KindSearchTerm, KindSingleComplexNode, KindSingleNavigationNode, KindSingleResourceCast, KindSingleResourceFunctionCall, KindSingleValueCast, KindSingleValueFunctionCall, KindSingleValueOpenPropertyAccess, KindSingleValuePropertyAccess, KindUnaryOperator}
}

// Kind1 enumerates the values for kind 1.
type Kind1 string

const (
	// Aggregate ...
	Aggregate Kind1 = "Aggregate"
	// Compute ...
	Compute Kind1 = "Compute"
	// Filter ...
	Filter Kind1 = "Filter"
	// GroupBy ...
	GroupBy Kind1 = "GroupBy"
)

// PossibleKind1Values returns an array of possible values for the Kind1 const type.
func PossibleKind1Values() []Kind1 {
	return []Kind1{Aggregate, Compute, Filter, GroupBy}
}

// OnDelete enumerates the values for on delete.
type OnDelete string

const (
	// OnDeleteCascade ...
	OnDeleteCascade OnDelete = "Cascade"
	// OnDeleteNone ...
	OnDeleteNone OnDelete = "None"
)

// PossibleOnDeleteValues returns an array of possible values for the OnDelete const type.
func PossibleOnDeleteValues() []OnDelete {
	return []OnDelete{OnDeleteCascade, OnDeleteNone}
}

// PropertyKind enumerates the values for property kind.
type PropertyKind string

const (
	// PropertyKindNavigation ...
	PropertyKindNavigation PropertyKind = "Navigation"
	// PropertyKindNone ...
	PropertyKindNone PropertyKind = "None"
	// PropertyKindStructural ...
	PropertyKindStructural PropertyKind = "Structural"
)

// PossiblePropertyKindValues returns an array of possible values for the PropertyKind const type.
func PossiblePropertyKindValues() []PropertyKind {
	return []PropertyKind{PropertyKindNavigation, PropertyKindNone, PropertyKindStructural}
}

// PropertyKind1 enumerates the values for property kind 1.
type PropertyKind1 string

const (
	// PropertyKind1Navigation ...
	PropertyKind1Navigation PropertyKind1 = "Navigation"
	// PropertyKind1None ...
	PropertyKind1None PropertyKind1 = "None"
	// PropertyKind1Structural ...
	PropertyKind1Structural PropertyKind1 = "Structural"
)

// PossiblePropertyKind1Values returns an array of possible values for the PropertyKind1 const type.
func PossiblePropertyKind1Values() []PropertyKind1 {
	return []PropertyKind1{PropertyKind1Navigation, PropertyKind1None, PropertyKind1Structural}
}

// PropertyKind2 enumerates the values for property kind 2.
type PropertyKind2 string

const (
	// PropertyKind2Navigation ...
	PropertyKind2Navigation PropertyKind2 = "Navigation"
	// PropertyKind2None ...
	PropertyKind2None PropertyKind2 = "None"
	// PropertyKind2Structural ...
	PropertyKind2Structural PropertyKind2 = "Structural"
)

// PossiblePropertyKind2Values returns an array of possible values for the PropertyKind2 const type.
func PossiblePropertyKind2Values() []PropertyKind2 {
	return []PropertyKind2{PropertyKind2Navigation, PropertyKind2None, PropertyKind2Structural}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateAccepted ...
	ProvisioningStateAccepted ProvisioningState = "Accepted"
	// ProvisioningStateCreating ...
	ProvisioningStateCreating ProvisioningState = "Creating"
	// ProvisioningStateDeleting ...
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateMoving ...
	ProvisioningStateMoving ProvisioningState = "Moving"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateAccepted, ProvisioningStateCreating, ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStateMoving, ProvisioningStateSucceeded}
}

// Purpose enumerates the values for purpose.
type Purpose string

const (
	// Assessment ...
	Assessment Purpose = "Assessment"
	// Discovery ...
	Discovery Purpose = "Discovery"
	// Migration ...
	Migration Purpose = "Migration"
)

// PossiblePurposeValues returns an array of possible values for the Purpose const type.
func PossiblePurposeValues() []Purpose {
	return []Purpose{Assessment, Discovery, Migration}
}

// RefreshSummaryState enumerates the values for refresh summary state.
type RefreshSummaryState string

const (
	// RefreshSummaryStateCompleted ...
	RefreshSummaryStateCompleted RefreshSummaryState = "Completed"
	// RefreshSummaryStateFailed ...
	RefreshSummaryStateFailed RefreshSummaryState = "Failed"
	// RefreshSummaryStateInProgress ...
	RefreshSummaryStateInProgress RefreshSummaryState = "InProgress"
	// RefreshSummaryStateStarted ...
	RefreshSummaryStateStarted RefreshSummaryState = "Started"
)

// PossibleRefreshSummaryStateValues returns an array of possible values for the RefreshSummaryState const type.
func PossibleRefreshSummaryStateValues() []RefreshSummaryState {
	return []RefreshSummaryState{RefreshSummaryStateCompleted, RefreshSummaryStateFailed, RefreshSummaryStateInProgress, RefreshSummaryStateStarted}
}

// RefreshSummaryState1 enumerates the values for refresh summary state 1.
type RefreshSummaryState1 string

const (
	// RefreshSummaryState1Completed ...
	RefreshSummaryState1Completed RefreshSummaryState1 = "Completed"
	// RefreshSummaryState1Failed ...
	RefreshSummaryState1Failed RefreshSummaryState1 = "Failed"
	// RefreshSummaryState1InProgress ...
	RefreshSummaryState1InProgress RefreshSummaryState1 = "InProgress"
	// RefreshSummaryState1Started ...
	RefreshSummaryState1Started RefreshSummaryState1 = "Started"
)

// PossibleRefreshSummaryState1Values returns an array of possible values for the RefreshSummaryState1 const type.
func PossibleRefreshSummaryState1Values() []RefreshSummaryState1 {
	return []RefreshSummaryState1{RefreshSummaryState1Completed, RefreshSummaryState1Failed, RefreshSummaryState1InProgress, RefreshSummaryState1Started}
}

// SchemaElementKind enumerates the values for schema element kind.
type SchemaElementKind string

const (
	// SchemaElementKindAction ...
	SchemaElementKindAction SchemaElementKind = "Action"
	// SchemaElementKindEntityContainer ...
	SchemaElementKindEntityContainer SchemaElementKind = "EntityContainer"
	// SchemaElementKindFunction ...
	SchemaElementKindFunction SchemaElementKind = "Function"
	// SchemaElementKindNone ...
	SchemaElementKindNone SchemaElementKind = "None"
	// SchemaElementKindTerm ...
	SchemaElementKindTerm SchemaElementKind = "Term"
	// SchemaElementKindTypeDefinition ...
	SchemaElementKindTypeDefinition SchemaElementKind = "TypeDefinition"
)

// PossibleSchemaElementKindValues returns an array of possible values for the SchemaElementKind const type.
func PossibleSchemaElementKindValues() []SchemaElementKind {
	return []SchemaElementKind{SchemaElementKindAction, SchemaElementKindEntityContainer, SchemaElementKindFunction, SchemaElementKindNone, SchemaElementKindTerm, SchemaElementKindTypeDefinition}
}

// SchemaElementKind1 enumerates the values for schema element kind 1.
type SchemaElementKind1 string

const (
	// SchemaElementKind1Action ...
	SchemaElementKind1Action SchemaElementKind1 = "Action"
	// SchemaElementKind1EntityContainer ...
	SchemaElementKind1EntityContainer SchemaElementKind1 = "EntityContainer"
	// SchemaElementKind1Function ...
	SchemaElementKind1Function SchemaElementKind1 = "Function"
	// SchemaElementKind1None ...
	SchemaElementKind1None SchemaElementKind1 = "None"
	// SchemaElementKind1Term ...
	SchemaElementKind1Term SchemaElementKind1 = "Term"
	// SchemaElementKind1TypeDefinition ...
	SchemaElementKind1TypeDefinition SchemaElementKind1 = "TypeDefinition"
)

// PossibleSchemaElementKind1Values returns an array of possible values for the SchemaElementKind1 const type.
func PossibleSchemaElementKind1Values() []SchemaElementKind1 {
	return []SchemaElementKind1{SchemaElementKind1Action, SchemaElementKind1EntityContainer, SchemaElementKind1Function, SchemaElementKind1None, SchemaElementKind1Term, SchemaElementKind1TypeDefinition}
}

// SchemaElementKind2 enumerates the values for schema element kind 2.
type SchemaElementKind2 string

const (
	// SchemaElementKind2Action ...
	SchemaElementKind2Action SchemaElementKind2 = "Action"
	// SchemaElementKind2EntityContainer ...
	SchemaElementKind2EntityContainer SchemaElementKind2 = "EntityContainer"
	// SchemaElementKind2Function ...
	SchemaElementKind2Function SchemaElementKind2 = "Function"
	// SchemaElementKind2None ...
	SchemaElementKind2None SchemaElementKind2 = "None"
	// SchemaElementKind2Term ...
	SchemaElementKind2Term SchemaElementKind2 = "Term"
	// SchemaElementKind2TypeDefinition ...
	SchemaElementKind2TypeDefinition SchemaElementKind2 = "TypeDefinition"
)

// PossibleSchemaElementKind2Values returns an array of possible values for the SchemaElementKind2 const type.
func PossibleSchemaElementKind2Values() []SchemaElementKind2 {
	return []SchemaElementKind2{SchemaElementKind2Action, SchemaElementKind2EntityContainer, SchemaElementKind2Function, SchemaElementKind2None, SchemaElementKind2Term, SchemaElementKind2TypeDefinition}
}

// Status enumerates the values for status.
type Status string

const (
	// Active ...
	Active Status = "Active"
	// Inactive ...
	Inactive Status = "Inactive"
)

// PossibleStatusValues returns an array of possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{Active, Inactive}
}

// Tool enumerates the values for tool.
type Tool string

const (
	// Carbonite ...
	Carbonite Tool = "Carbonite"
	// Cloudamize ...
	Cloudamize Tool = "Cloudamize"
	// CorentTech ...
	CorentTech Tool = "CorentTech"
	// DatabaseMigrationService ...
	DatabaseMigrationService Tool = "DatabaseMigrationService"
	// DataMigrationAssistant ...
	DataMigrationAssistant Tool = "DataMigrationAssistant"
	// ServerAssessment ...
	ServerAssessment Tool = "ServerAssessment"
	// ServerAssessmentV1 ...
	ServerAssessmentV1 Tool = "ServerAssessmentV1"
	// ServerDiscovery ...
	ServerDiscovery Tool = "ServerDiscovery"
	// ServerMigration ...
	ServerMigration Tool = "ServerMigration"
	// ServerMigrationReplication ...
	ServerMigrationReplication Tool = "ServerMigration_Replication"
	// Turbonomic ...
	Turbonomic Tool = "Turbonomic"
	// Zerto ...
	Zerto Tool = "Zerto"
)

// PossibleToolValues returns an array of possible values for the Tool const type.
func PossibleToolValues() []Tool {
	return []Tool{Carbonite, Cloudamize, CorentTech, DatabaseMigrationService, DataMigrationAssistant, ServerAssessment, ServerAssessmentV1, ServerDiscovery, ServerMigration, ServerMigrationReplication, Turbonomic, Zerto}
}

// Tool1 enumerates the values for tool 1.
type Tool1 string

const (
	// Tool1Carbonite ...
	Tool1Carbonite Tool1 = "Carbonite"
	// Tool1Cloudamize ...
	Tool1Cloudamize Tool1 = "Cloudamize"
	// Tool1CorentTech ...
	Tool1CorentTech Tool1 = "CorentTech"
	// Tool1DatabaseMigrationService ...
	Tool1DatabaseMigrationService Tool1 = "DatabaseMigrationService"
	// Tool1DataMigrationAssistant ...
	Tool1DataMigrationAssistant Tool1 = "DataMigrationAssistant"
	// Tool1ServerAssessment ...
	Tool1ServerAssessment Tool1 = "ServerAssessment"
	// Tool1ServerAssessmentV1 ...
	Tool1ServerAssessmentV1 Tool1 = "ServerAssessmentV1"
	// Tool1ServerDiscovery ...
	Tool1ServerDiscovery Tool1 = "ServerDiscovery"
	// Tool1ServerMigration ...
	Tool1ServerMigration Tool1 = "ServerMigration"
	// Tool1ServerMigrationReplication ...
	Tool1ServerMigrationReplication Tool1 = "ServerMigration_Replication"
	// Tool1Turbonomic ...
	Tool1Turbonomic Tool1 = "Turbonomic"
	// Tool1Zerto ...
	Tool1Zerto Tool1 = "Zerto"
)

// PossibleTool1Values returns an array of possible values for the Tool1 const type.
func PossibleTool1Values() []Tool1 {
	return []Tool1{Tool1Carbonite, Tool1Cloudamize, Tool1CorentTech, Tool1DatabaseMigrationService, Tool1DataMigrationAssistant, Tool1ServerAssessment, Tool1ServerAssessmentV1, Tool1ServerDiscovery, Tool1ServerMigration, Tool1ServerMigrationReplication, Tool1Turbonomic, Tool1Zerto}
}

// TypeKind enumerates the values for type kind.
type TypeKind string

const (
	// TypeKindCollection ...
	TypeKindCollection TypeKind = "Collection"
	// TypeKindComplex ...
	TypeKindComplex TypeKind = "Complex"
	// TypeKindEntity ...
	TypeKindEntity TypeKind = "Entity"
	// TypeKindEntityReference ...
	TypeKindEntityReference TypeKind = "EntityReference"
	// TypeKindEnum ...
	TypeKindEnum TypeKind = "Enum"
	// TypeKindNone ...
	TypeKindNone TypeKind = "None"
	// TypeKindPath ...
	TypeKindPath TypeKind = "Path"
	// TypeKindPrimitive ...
	TypeKindPrimitive TypeKind = "Primitive"
	// TypeKindTypeDefinition ...
	TypeKindTypeDefinition TypeKind = "TypeDefinition"
	// TypeKindUntyped ...
	TypeKindUntyped TypeKind = "Untyped"
)

// PossibleTypeKindValues returns an array of possible values for the TypeKind const type.
func PossibleTypeKindValues() []TypeKind {
	return []TypeKind{TypeKindCollection, TypeKindComplex, TypeKindEntity, TypeKindEntityReference, TypeKindEnum, TypeKindNone, TypeKindPath, TypeKindPrimitive, TypeKindTypeDefinition, TypeKindUntyped}
}

// TypeKind1 enumerates the values for type kind 1.
type TypeKind1 string

const (
	// TypeKind1Collection ...
	TypeKind1Collection TypeKind1 = "Collection"
	// TypeKind1Complex ...
	TypeKind1Complex TypeKind1 = "Complex"
	// TypeKind1Entity ...
	TypeKind1Entity TypeKind1 = "Entity"
	// TypeKind1EntityReference ...
	TypeKind1EntityReference TypeKind1 = "EntityReference"
	// TypeKind1Enum ...
	TypeKind1Enum TypeKind1 = "Enum"
	// TypeKind1None ...
	TypeKind1None TypeKind1 = "None"
	// TypeKind1Path ...
	TypeKind1Path TypeKind1 = "Path"
	// TypeKind1Primitive ...
	TypeKind1Primitive TypeKind1 = "Primitive"
	// TypeKind1TypeDefinition ...
	TypeKind1TypeDefinition TypeKind1 = "TypeDefinition"
	// TypeKind1Untyped ...
	TypeKind1Untyped TypeKind1 = "Untyped"
)

// PossibleTypeKind1Values returns an array of possible values for the TypeKind1 const type.
func PossibleTypeKind1Values() []TypeKind1 {
	return []TypeKind1{TypeKind1Collection, TypeKind1Complex, TypeKind1Entity, TypeKind1EntityReference, TypeKind1Enum, TypeKind1None, TypeKind1Path, TypeKind1Primitive, TypeKind1TypeDefinition, TypeKind1Untyped}
}

// ApplyClause ...
type ApplyClause struct {
	// Transformations - READ-ONLY
	Transformations *[]TransformationNode `json:"transformations,omitempty"`
}

// AssessmentDetails assessment properties that can be shared by various publishers.
type AssessmentDetails struct {
	// AssessmentID - Gets or sets the id of the assessment done on the machine.
	AssessmentID *string `json:"assessmentId,omitempty"`
	// TargetVMSize - Gets or sets the target VM size.
	TargetVMSize *string `json:"targetVMSize,omitempty"`
	// TargetVMLocation - Gets or sets the target VM location.
	TargetVMLocation *string `json:"targetVMLocation,omitempty"`
	// TargetStorageType - Gets or sets the target storage type.
	TargetStorageType map[string]*string `json:"targetStorageType"`
	// EnqueueTime - Gets or sets the time the message was enqueued.
	EnqueueTime *string `json:"enqueueTime,omitempty"`
	// SolutionName - Gets or sets the name of the solution that sent the data.
	SolutionName *string `json:"solutionName,omitempty"`
	// MachineID - Gets or sets the unique identifier of the machine.
	MachineID *string `json:"machineId,omitempty"`
	// MachineManagerID - Gets or sets the unique identifier of the virtual machine manager(vCenter/VMM).
	MachineManagerID *string `json:"machineManagerId,omitempty"`
	// FabricType - Gets or sets the fabric type.
	FabricType *string `json:"fabricType,omitempty"`
	// LastUpdatedTime - Gets or sets the time of the last modification of the machine details.
	LastUpdatedTime *date.Time `json:"lastUpdatedTime,omitempty"`
	// MachineName - Gets or sets the name of the machine.
	MachineName *string `json:"machineName,omitempty"`
	// IPAddresses - Gets or sets the list of IP addresses of the machine. IP addresses could be IP V4 or IP V6.
	IPAddresses *[]string `json:"ipAddresses,omitempty"`
	// Fqdn - Gets or sets the FQDN of the machine.
	Fqdn *string `json:"fqdn,omitempty"`
	// BiosID - Gets or sets the BIOS ID of the machine.
	BiosID *string `json:"biosId,omitempty"`
	// MacAddresses - Gets or sets the list of MAC addresses of the machine.
	MacAddresses *[]string `json:"macAddresses,omitempty"`
	// ExtendedInfo - Gets or sets the ISV specific extended information.
	ExtendedInfo map[string]*string `json:"extendedInfo"`
}

// MarshalJSON is the custom marshaler for AssessmentDetails.
func (ad AssessmentDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ad.AssessmentID != nil {
		objectMap["assessmentId"] = ad.AssessmentID
	}
	if ad.TargetVMSize != nil {
		objectMap["targetVMSize"] = ad.TargetVMSize
	}
	if ad.TargetVMLocation != nil {
		objectMap["targetVMLocation"] = ad.TargetVMLocation
	}
	if ad.TargetStorageType != nil {
		objectMap["targetStorageType"] = ad.TargetStorageType
	}
	if ad.EnqueueTime != nil {
		objectMap["enqueueTime"] = ad.EnqueueTime
	}
	if ad.SolutionName != nil {
		objectMap["solutionName"] = ad.SolutionName
	}
	if ad.MachineID != nil {
		objectMap["machineId"] = ad.MachineID
	}
	if ad.MachineManagerID != nil {
		objectMap["machineManagerId"] = ad.MachineManagerID
	}
	if ad.FabricType != nil {
		objectMap["fabricType"] = ad.FabricType
	}
	if ad.LastUpdatedTime != nil {
		objectMap["lastUpdatedTime"] = ad.LastUpdatedTime
	}
	if ad.MachineName != nil {
		objectMap["machineName"] = ad.MachineName
	}
	if ad.IPAddresses != nil {
		objectMap["ipAddresses"] = ad.IPAddresses
	}
	if ad.Fqdn != nil {
		objectMap["fqdn"] = ad.Fqdn
	}
	if ad.BiosID != nil {
		objectMap["biosId"] = ad.BiosID
	}
	if ad.MacAddresses != nil {
		objectMap["macAddresses"] = ad.MacAddresses
	}
	if ad.ExtendedInfo != nil {
		objectMap["extendedInfo"] = ad.ExtendedInfo
	}
	return json.Marshal(objectMap)
}

// Database database REST resource.
type Database struct {
	autorest.Response `json:"-"`
	// ID - Gets or sets the relative URL to get to this REST resource.
	ID *string `json:"id,omitempty"`
	// Name - Gets or sets the name of this REST resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Gets the type of this REST resource.
	Type *string `json:"type,omitempty"`
	// Properties - Gets or sets the properties of the database.
	Properties *DatabaseProperties `json:"properties,omitempty"`
}

// DatabaseAssessmentDetails assessment properties that can be shared by various publishers.
type DatabaseAssessmentDetails struct {
	// AssessmentID - Gets or sets the database assessment scope/Id.
	AssessmentID *string `json:"assessmentId,omitempty"`
	// MigrationBlockersCount - Gets or sets the number of blocking changes found.
	MigrationBlockersCount *int32 `json:"migrationBlockersCount,omitempty"`
	// BreakingChangesCount - Gets or sets the number of breaking changes found.
	BreakingChangesCount *int32 `json:"breakingChangesCount,omitempty"`
	// IsReadyForMigration - Gets or sets a value indicating whether the database is ready for migration.
	IsReadyForMigration *bool `json:"isReadyForMigration,omitempty"`
	// AssessmentTargetType - Gets or sets the assessed target database type.
	AssessmentTargetType *string `json:"assessmentTargetType,omitempty"`
	// LastAssessedTime - Gets or sets the time when the database was last assessed.
	LastAssessedTime *date.Time `json:"lastAssessedTime,omitempty"`
	// CompatibilityLevel - Gets or sets the compatibility level of the database.
	CompatibilityLevel *string `json:"compatibilityLevel,omitempty"`
	// DatabaseSizeInMB - Gets or sets the database size.
	DatabaseSizeInMB *string `json:"databaseSizeInMB,omitempty"`
	// LastUpdatedTime - Gets or sets the time of the last modification of the database details.
	LastUpdatedTime *date.Time `json:"lastUpdatedTime,omitempty"`
	// EnqueueTime - Gets or sets the time the message was enqueued.
	EnqueueTime *string `json:"enqueueTime,omitempty"`
	// SolutionName - Gets or sets the name of the solution that sent the data.
	SolutionName *string `json:"solutionName,omitempty"`
	// InstanceID - Gets or sets the database server instance Id.
	InstanceID *string `json:"instanceId,omitempty"`
	// DatabaseName - Gets or sets the database name.
	DatabaseName *string `json:"databaseName,omitempty"`
	// ExtendedInfo - Gets or sets the extended properties of the database.
	ExtendedInfo map[string]*string `json:"extendedInfo"`
}

// MarshalJSON is the custom marshaler for DatabaseAssessmentDetails.
func (dad DatabaseAssessmentDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dad.AssessmentID != nil {
		objectMap["assessmentId"] = dad.AssessmentID
	}
	if dad.MigrationBlockersCount != nil {
		objectMap["migrationBlockersCount"] = dad.MigrationBlockersCount
	}
	if dad.BreakingChangesCount != nil {
		objectMap["breakingChangesCount"] = dad.BreakingChangesCount
	}
	if dad.IsReadyForMigration != nil {
		objectMap["isReadyForMigration"] = dad.IsReadyForMigration
	}
	if dad.AssessmentTargetType != nil {
		objectMap["assessmentTargetType"] = dad.AssessmentTargetType
	}
	if dad.LastAssessedTime != nil {
		objectMap["lastAssessedTime"] = dad.LastAssessedTime
	}
	if dad.CompatibilityLevel != nil {
		objectMap["compatibilityLevel"] = dad.CompatibilityLevel
	}
	if dad.DatabaseSizeInMB != nil {
		objectMap["databaseSizeInMB"] = dad.DatabaseSizeInMB
	}
	if dad.LastUpdatedTime != nil {
		objectMap["lastUpdatedTime"] = dad.LastUpdatedTime
	}
	if dad.EnqueueTime != nil {
		objectMap["enqueueTime"] = dad.EnqueueTime
	}
	if dad.SolutionName != nil {
		objectMap["solutionName"] = dad.SolutionName
	}
	if dad.InstanceID != nil {
		objectMap["instanceId"] = dad.InstanceID
	}
	if dad.DatabaseName != nil {
		objectMap["databaseName"] = dad.DatabaseName
	}
	if dad.ExtendedInfo != nil {
		objectMap["extendedInfo"] = dad.ExtendedInfo
	}
	return json.Marshal(objectMap)
}

// DatabaseCollection collection of databases.
type DatabaseCollection struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets the databases.
	Value *[]Database `json:"value,omitempty"`
	// NextLink - Gets or sets the value of nextLink.
	NextLink *string `json:"nextLink,omitempty"`
}

// DatabaseInstance databaseInstance REST resource.
type DatabaseInstance struct {
	autorest.Response `json:"-"`
	// ID - Gets or sets the relative URL to get to this REST resource.
	ID *string `json:"id,omitempty"`
	// Name - Gets or sets the name of this REST resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Gets the type of this REST resource.
	Type *string `json:"type,omitempty"`
	// Properties - Gets or sets the properties of the machine.
	Properties *DatabaseInstanceProperties `json:"properties,omitempty"`
}

// DatabaseInstanceCollection collection of database instances.
type DatabaseInstanceCollection struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets the database instances.
	Value *[]DatabaseInstance `json:"value,omitempty"`
	// NextLink - Gets or sets the value of nextLink.
	NextLink *string `json:"nextLink,omitempty"`
}

// DatabaseInstanceDiscoveryDetails discovery properties that can be shared by various publishers.
type DatabaseInstanceDiscoveryDetails struct {
	// LastUpdatedTime - Gets or sets the time of the last modification of the database instance details.
	LastUpdatedTime *date.Time `json:"lastUpdatedTime,omitempty"`
	// InstanceID - Gets or sets the database instance Id.
	InstanceID *string `json:"instanceId,omitempty"`
	// EnqueueTime - Gets or sets the time the message was enqueued.
	EnqueueTime *string `json:"enqueueTime,omitempty"`
	// SolutionName - Gets or sets the name of the solution that sent the data.
	SolutionName *string `json:"solutionName,omitempty"`
	// InstanceName - Gets or sets the database instance name.
	InstanceName *string `json:"instanceName,omitempty"`
	// InstanceVersion - Gets or sets the database instance version.
	InstanceVersion *string `json:"instanceVersion,omitempty"`
	// InstanceType - Gets or sets the database instance type.
	InstanceType *string `json:"instanceType,omitempty"`
	// HostName - Gets or sets the host name of the database server.
	HostName *string `json:"hostName,omitempty"`
	// IPAddress - Gets or sets the IP addresses of the database server. IP addresses could be IP V4 or IP V6.
	IPAddress *string `json:"ipAddress,omitempty"`
	// PortNumber - Gets or sets the port number of the database server.
	PortNumber *int32 `json:"portNumber,omitempty"`
	// ExtendedInfo - Gets or sets the extended properties of the database server.
	ExtendedInfo map[string]*string `json:"extendedInfo"`
}

// MarshalJSON is the custom marshaler for DatabaseInstanceDiscoveryDetails.
func (didd DatabaseInstanceDiscoveryDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if didd.LastUpdatedTime != nil {
		objectMap["lastUpdatedTime"] = didd.LastUpdatedTime
	}
	if didd.InstanceID != nil {
		objectMap["instanceId"] = didd.InstanceID
	}
	if didd.EnqueueTime != nil {
		objectMap["enqueueTime"] = didd.EnqueueTime
	}
	if didd.SolutionName != nil {
		objectMap["solutionName"] = didd.SolutionName
	}
	if didd.InstanceName != nil {
		objectMap["instanceName"] = didd.InstanceName
	}
	if didd.InstanceVersion != nil {
		objectMap["instanceVersion"] = didd.InstanceVersion
	}
	if didd.InstanceType != nil {
		objectMap["instanceType"] = didd.InstanceType
	}
	if didd.HostName != nil {
		objectMap["hostName"] = didd.HostName
	}
	if didd.IPAddress != nil {
		objectMap["ipAddress"] = didd.IPAddress
	}
	if didd.PortNumber != nil {
		objectMap["portNumber"] = didd.PortNumber
	}
	if didd.ExtendedInfo != nil {
		objectMap["extendedInfo"] = didd.ExtendedInfo
	}
	return json.Marshal(objectMap)
}

// DatabaseInstanceProperties properties of the database instance resource.
type DatabaseInstanceProperties struct {
	// DiscoveryData - Gets or sets the assessment details of the database instance published by various sources.
	DiscoveryData *[]DatabaseInstanceDiscoveryDetails `json:"discoveryData,omitempty"`
	// Summary - Gets or sets the database instances summary per solution. The key of dictionary is the solution name and value is the corresponding database instance summary object.
	Summary map[string]*DatabaseInstanceSummary `json:"summary"`
	// LastUpdatedTime - Gets or sets the time of the last modification of the database.
	LastUpdatedTime *date.Time `json:"lastUpdatedTime,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseInstanceProperties.
func (dip DatabaseInstanceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dip.DiscoveryData != nil {
		objectMap["discoveryData"] = dip.DiscoveryData
	}
	if dip.Summary != nil {
		objectMap["summary"] = dip.Summary
	}
	if dip.LastUpdatedTime != nil {
		objectMap["lastUpdatedTime"] = dip.LastUpdatedTime
	}
	return json.Marshal(objectMap)
}

// DatabaseInstanceSummary class representing the database instance summary object.
type DatabaseInstanceSummary struct {
	// DatabasesAssessedCount - Gets or sets the count of databases assessed.
	DatabasesAssessedCount *int32 `json:"databasesAssessedCount,omitempty"`
	// MigrationReadyCount - Gets or sets the count of databases ready for migration.
	MigrationReadyCount *int32 `json:"migrationReadyCount,omitempty"`
}

// DatabaseMigrateEventProperties properties of the database error resource.
type DatabaseMigrateEventProperties struct {
	// Database - Gets or sets the database for which the error is being reported.
	Database *string `json:"database,omitempty"`
	// DatabaseInstanceID - Gets or sets the database instance for which the error is being reported.
	DatabaseInstanceID *string `json:"databaseInstanceId,omitempty"`
	// ErrorCode - Gets or sets the error code.
	ErrorCode *string `json:"errorCode,omitempty"`
	// ErrorMessage - Gets or sets the error message.
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// Recommendation - Gets or sets the recommendation for the error.
	Recommendation *string `json:"recommendation,omitempty"`
	// PossibleCauses - Gets or sets the possible causes for the error.
	PossibleCauses *string `json:"possibleCauses,omitempty"`
	// Solution - Gets or sets the solution for which the error is being reported.
	Solution *string `json:"solution,omitempty"`
	// ClientRequestID - Gets or sets the client request Id of the payload for which the event is being reported.
	ClientRequestID *string `json:"clientRequestId,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeMigrateEventProperties', 'InstanceTypeServers', 'InstanceTypeDatabases'
	InstanceType InstanceType `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseMigrateEventProperties.
func (dmep DatabaseMigrateEventProperties) MarshalJSON() ([]byte, error) {
	dmep.InstanceType = InstanceTypeDatabases
	objectMap := make(map[string]interface{})
	if dmep.Database != nil {
		objectMap["database"] = dmep.Database
	}
	if dmep.DatabaseInstanceID != nil {
		objectMap["databaseInstanceId"] = dmep.DatabaseInstanceID
	}
	if dmep.ErrorCode != nil {
		objectMap["errorCode"] = dmep.ErrorCode
	}
	if dmep.ErrorMessage != nil {
		objectMap["errorMessage"] = dmep.ErrorMessage
	}
	if dmep.Recommendation != nil {
		objectMap["recommendation"] = dmep.Recommendation
	}
	if dmep.PossibleCauses != nil {
		objectMap["possibleCauses"] = dmep.PossibleCauses
	}
	if dmep.Solution != nil {
		objectMap["solution"] = dmep.Solution
	}
	if dmep.ClientRequestID != nil {
		objectMap["clientRequestId"] = dmep.ClientRequestID
	}
	if dmep.InstanceType != "" {
		objectMap["instanceType"] = dmep.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsMachineMigrateEventProperties is the BasicEventProperties implementation for DatabaseMigrateEventProperties.
func (dmep DatabaseMigrateEventProperties) AsMachineMigrateEventProperties() (*MachineMigrateEventProperties, bool) {
	return nil, false
}

// AsDatabaseMigrateEventProperties is the BasicEventProperties implementation for DatabaseMigrateEventProperties.
func (dmep DatabaseMigrateEventProperties) AsDatabaseMigrateEventProperties() (*DatabaseMigrateEventProperties, bool) {
	return &dmep, true
}

// AsEventProperties is the BasicEventProperties implementation for DatabaseMigrateEventProperties.
func (dmep DatabaseMigrateEventProperties) AsEventProperties() (*EventProperties, bool) {
	return nil, false
}

// AsBasicEventProperties is the BasicEventProperties implementation for DatabaseMigrateEventProperties.
func (dmep DatabaseMigrateEventProperties) AsBasicEventProperties() (BasicEventProperties, bool) {
	return &dmep, true
}

// DatabaseProjectSummary the database project summary class.
type DatabaseProjectSummary struct {
	// RefreshSummaryState - Gets or sets the state of refresh summary. Possible values include: 'RefreshSummaryStateStarted', 'RefreshSummaryStateInProgress', 'RefreshSummaryStateCompleted', 'RefreshSummaryStateFailed'
	RefreshSummaryState RefreshSummaryState `json:"refreshSummaryState,omitempty"`
	// LastSummaryRefreshedTime - Gets or sets the time when summary was last refreshed.
	LastSummaryRefreshedTime *date.Time `json:"lastSummaryRefreshedTime,omitempty"`
	// ExtendedSummary - Gets or sets the extended summary.
	ExtendedSummary map[string]*string `json:"extendedSummary"`
	// InstanceType - Possible values include: 'InstanceTypeBasicProjectSummaryInstanceTypeProjectSummary', 'InstanceTypeBasicProjectSummaryInstanceTypeServers', 'InstanceTypeBasicProjectSummaryInstanceTypeDatabases'
	InstanceType InstanceTypeBasicProjectSummary `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseProjectSummary.
func (dps DatabaseProjectSummary) MarshalJSON() ([]byte, error) {
	dps.InstanceType = InstanceTypeBasicProjectSummaryInstanceTypeDatabases
	objectMap := make(map[string]interface{})
	if dps.RefreshSummaryState != "" {
		objectMap["refreshSummaryState"] = dps.RefreshSummaryState
	}
	if dps.LastSummaryRefreshedTime != nil {
		objectMap["lastSummaryRefreshedTime"] = dps.LastSummaryRefreshedTime
	}
	if dps.ExtendedSummary != nil {
		objectMap["extendedSummary"] = dps.ExtendedSummary
	}
	if dps.InstanceType != "" {
		objectMap["instanceType"] = dps.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsServersProjectSummary is the BasicProjectSummary implementation for DatabaseProjectSummary.
func (dps DatabaseProjectSummary) AsServersProjectSummary() (*ServersProjectSummary, bool) {
	return nil, false
}

// AsDatabaseProjectSummary is the BasicProjectSummary implementation for DatabaseProjectSummary.
func (dps DatabaseProjectSummary) AsDatabaseProjectSummary() (*DatabaseProjectSummary, bool) {
	return &dps, true
}

// AsProjectSummary is the BasicProjectSummary implementation for DatabaseProjectSummary.
func (dps DatabaseProjectSummary) AsProjectSummary() (*ProjectSummary, bool) {
	return nil, false
}

// AsBasicProjectSummary is the BasicProjectSummary implementation for DatabaseProjectSummary.
func (dps DatabaseProjectSummary) AsBasicProjectSummary() (BasicProjectSummary, bool) {
	return &dps, true
}

// DatabaseProperties properties of the database resource.
type DatabaseProperties struct {
	// AssessmentData - Gets or sets the assessment details of the database published by various sources.
	AssessmentData *[]DatabaseAssessmentDetails `json:"assessmentData,omitempty"`
	// LastUpdatedTime - Gets or sets the time of the last modification of the database.
	LastUpdatedTime *date.Time `json:"lastUpdatedTime,omitempty"`
}

// DatabasesSolutionSummary class representing the databases solution summary.
type DatabasesSolutionSummary struct {
	// DatabasesAssessedCount - Gets or sets the count of databases assessed.
	DatabasesAssessedCount *int32 `json:"databasesAssessedCount,omitempty"`
	// DatabaseInstancesAssessedCount - Gets or sets the count of database instances assessed.
	DatabaseInstancesAssessedCount *int32 `json:"databaseInstancesAssessedCount,omitempty"`
	// MigrationReadyCount - Gets or sets the count of databases ready for migration.
	MigrationReadyCount *int32 `json:"migrationReadyCount,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicSolutionSummaryInstanceTypeSolutionSummary', 'InstanceTypeBasicSolutionSummaryInstanceTypeServers', 'InstanceTypeBasicSolutionSummaryInstanceTypeDatabases'
	InstanceType InstanceTypeBasicSolutionSummary `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabasesSolutionSummary.
func (dss DatabasesSolutionSummary) MarshalJSON() ([]byte, error) {
	dss.InstanceType = InstanceTypeBasicSolutionSummaryInstanceTypeDatabases
	objectMap := make(map[string]interface{})
	if dss.DatabasesAssessedCount != nil {
		objectMap["databasesAssessedCount"] = dss.DatabasesAssessedCount
	}
	if dss.DatabaseInstancesAssessedCount != nil {
		objectMap["databaseInstancesAssessedCount"] = dss.DatabaseInstancesAssessedCount
	}
	if dss.MigrationReadyCount != nil {
		objectMap["migrationReadyCount"] = dss.MigrationReadyCount
	}
	if dss.InstanceType != "" {
		objectMap["instanceType"] = dss.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsServersSolutionSummary is the BasicSolutionSummary implementation for DatabasesSolutionSummary.
func (dss DatabasesSolutionSummary) AsServersSolutionSummary() (*ServersSolutionSummary, bool) {
	return nil, false
}

// AsDatabasesSolutionSummary is the BasicSolutionSummary implementation for DatabasesSolutionSummary.
func (dss DatabasesSolutionSummary) AsDatabasesSolutionSummary() (*DatabasesSolutionSummary, bool) {
	return &dss, true
}

// AsSolutionSummary is the BasicSolutionSummary implementation for DatabasesSolutionSummary.
func (dss DatabasesSolutionSummary) AsSolutionSummary() (*SolutionSummary, bool) {
	return nil, false
}

// AsBasicSolutionSummary is the BasicSolutionSummary implementation for DatabasesSolutionSummary.
func (dss DatabasesSolutionSummary) AsBasicSolutionSummary() (BasicSolutionSummary, bool) {
	return &dss, true
}

// DefaultQuerySettings ...
type DefaultQuerySettings struct {
	EnableExpand  *bool  `json:"enableExpand,omitempty"`
	EnableSelect  *bool  `json:"enableSelect,omitempty"`
	EnableCount   *bool  `json:"enableCount,omitempty"`
	EnableOrderBy *bool  `json:"enableOrderBy,omitempty"`
	EnableFilter  *bool  `json:"enableFilter,omitempty"`
	MaxTop        *int32 `json:"maxTop,omitempty"`
}

// DiscoveryDetails discovery properties that can be published by various ISVs.
type DiscoveryDetails struct {
	// OsType - Gets or sets the OS type.
	OsType *string `json:"osType,omitempty"`
	// OsName - Gets or sets the OS name.
	OsName *string `json:"osName,omitempty"`
	// OsVersion - Gets or sets the OS version.
	OsVersion *string `json:"osVersion,omitempty"`
	// EnqueueTime - Gets or sets the time the message was enqueued.
	EnqueueTime *string `json:"enqueueTime,omitempty"`
	// SolutionName - Gets or sets the name of the solution that sent the data.
	SolutionName *string `json:"solutionName,omitempty"`
	// MachineID - Gets or sets the unique identifier of the machine.
	MachineID *string `json:"machineId,omitempty"`
	// MachineManagerID - Gets or sets the unique identifier of the virtual machine manager(vCenter/VMM).
	MachineManagerID *string `json:"machineManagerId,omitempty"`
	// FabricType - Gets or sets the fabric type.
	FabricType *string `json:"fabricType,omitempty"`
	// LastUpdatedTime - Gets or sets the time of the last modification of the machine details.
	LastUpdatedTime *date.Time `json:"lastUpdatedTime,omitempty"`
	// MachineName - Gets or sets the name of the machine.
	MachineName *string `json:"machineName,omitempty"`
	// IPAddresses - Gets or sets the list of IP addresses of the machine. IP addresses could be IP V4 or IP V6.
	IPAddresses *[]string `json:"ipAddresses,omitempty"`
	// Fqdn - Gets or sets the FQDN of the machine.
	Fqdn *string `json:"fqdn,omitempty"`
	// BiosID - Gets or sets the BIOS ID of the machine.
	BiosID *string `json:"biosId,omitempty"`
	// MacAddresses - Gets or sets the list of MAC addresses of the machine.
	MacAddresses *[]string `json:"macAddresses,omitempty"`
	// ExtendedInfo - Gets or sets the ISV specific extended information.
	ExtendedInfo map[string]*string `json:"extendedInfo"`
}

// MarshalJSON is the custom marshaler for DiscoveryDetails.
func (dd DiscoveryDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dd.OsType != nil {
		objectMap["osType"] = dd.OsType
	}
	if dd.OsName != nil {
		objectMap["osName"] = dd.OsName
	}
	if dd.OsVersion != nil {
		objectMap["osVersion"] = dd.OsVersion
	}
	if dd.EnqueueTime != nil {
		objectMap["enqueueTime"] = dd.EnqueueTime
	}
	if dd.SolutionName != nil {
		objectMap["solutionName"] = dd.SolutionName
	}
	if dd.MachineID != nil {
		objectMap["machineId"] = dd.MachineID
	}
	if dd.MachineManagerID != nil {
		objectMap["machineManagerId"] = dd.MachineManagerID
	}
	if dd.FabricType != nil {
		objectMap["fabricType"] = dd.FabricType
	}
	if dd.LastUpdatedTime != nil {
		objectMap["lastUpdatedTime"] = dd.LastUpdatedTime
	}
	if dd.MachineName != nil {
		objectMap["machineName"] = dd.MachineName
	}
	if dd.IPAddresses != nil {
		objectMap["ipAddresses"] = dd.IPAddresses
	}
	if dd.Fqdn != nil {
		objectMap["fqdn"] = dd.Fqdn
	}
	if dd.BiosID != nil {
		objectMap["biosId"] = dd.BiosID
	}
	if dd.MacAddresses != nil {
		objectMap["macAddresses"] = dd.MacAddresses
	}
	if dd.ExtendedInfo != nil {
		objectMap["extendedInfo"] = dd.ExtendedInfo
	}
	return json.Marshal(objectMap)
}

// EdmReferentialConstraintPropertyPair ...
type EdmReferentialConstraintPropertyPair struct {
	// DependentProperty - READ-ONLY
	DependentProperty *IEdmStructuralProperty `json:"dependentProperty,omitempty"`
	// PrincipalProperty - READ-ONLY
	PrincipalProperty *IEdmStructuralProperty `json:"principalProperty,omitempty"`
}

// Event migrateEvent REST resource.
type Event struct {
	autorest.Response `json:"-"`
	// ID - Gets or sets the relative URL to get to this REST resource.
	ID *string `json:"id,omitempty"`
	// Name - Gets or sets the name of this REST resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Gets the type of this REST resource.
	Type *string `json:"type,omitempty"`
	// Properties - Gets or sets the properties of the event.
	Properties BasicEventProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for Event struct.
func (e *Event) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				e.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				e.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				e.Type = &typeVar
			}
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicEventProperties(*v)
				if err != nil {
					return err
				}
				e.Properties = properties
			}
		}
	}

	return nil
}

// EventCollection collection of events.
type EventCollection struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets the machines.
	Value *[]Event `json:"value,omitempty"`
	// NextLink - Gets or sets the value of nextLink.
	NextLink *string `json:"nextLink,omitempty"`
}

// BasicEventProperties properties of the error resource.
type BasicEventProperties interface {
	AsMachineMigrateEventProperties() (*MachineMigrateEventProperties, bool)
	AsDatabaseMigrateEventProperties() (*DatabaseMigrateEventProperties, bool)
	AsEventProperties() (*EventProperties, bool)
}

// EventProperties properties of the error resource.
type EventProperties struct {
	// ErrorCode - Gets or sets the error code.
	ErrorCode *string `json:"errorCode,omitempty"`
	// ErrorMessage - Gets or sets the error message.
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// Recommendation - Gets or sets the recommendation for the error.
	Recommendation *string `json:"recommendation,omitempty"`
	// PossibleCauses - Gets or sets the possible causes for the error.
	PossibleCauses *string `json:"possibleCauses,omitempty"`
	// Solution - Gets or sets the solution for which the error is being reported.
	Solution *string `json:"solution,omitempty"`
	// ClientRequestID - Gets or sets the client request Id of the payload for which the event is being reported.
	ClientRequestID *string `json:"clientRequestId,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeMigrateEventProperties', 'InstanceTypeServers', 'InstanceTypeDatabases'
	InstanceType InstanceType `json:"instanceType,omitempty"`
}

func unmarshalBasicEventProperties(body []byte) (BasicEventProperties, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeServers):
		var mmep MachineMigrateEventProperties
		err := json.Unmarshal(body, &mmep)
		return mmep, err
	case string(InstanceTypeDatabases):
		var dmep DatabaseMigrateEventProperties
		err := json.Unmarshal(body, &dmep)
		return dmep, err
	default:
		var ep EventProperties
		err := json.Unmarshal(body, &ep)
		return ep, err
	}
}
func unmarshalBasicEventPropertiesArray(body []byte) ([]BasicEventProperties, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	epArray := make([]BasicEventProperties, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ep, err := unmarshalBasicEventProperties(*rawMessage)
		if err != nil {
			return nil, err
		}
		epArray[index] = ep
	}
	return epArray, nil
}

// MarshalJSON is the custom marshaler for EventProperties.
func (ep EventProperties) MarshalJSON() ([]byte, error) {
	ep.InstanceType = InstanceTypeMigrateEventProperties
	objectMap := make(map[string]interface{})
	if ep.ErrorCode != nil {
		objectMap["errorCode"] = ep.ErrorCode
	}
	if ep.ErrorMessage != nil {
		objectMap["errorMessage"] = ep.ErrorMessage
	}
	if ep.Recommendation != nil {
		objectMap["recommendation"] = ep.Recommendation
	}
	if ep.PossibleCauses != nil {
		objectMap["possibleCauses"] = ep.PossibleCauses
	}
	if ep.Solution != nil {
		objectMap["solution"] = ep.Solution
	}
	if ep.ClientRequestID != nil {
		objectMap["clientRequestId"] = ep.ClientRequestID
	}
	if ep.InstanceType != "" {
		objectMap["instanceType"] = ep.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsMachineMigrateEventProperties is the BasicEventProperties implementation for EventProperties.
func (ep EventProperties) AsMachineMigrateEventProperties() (*MachineMigrateEventProperties, bool) {
	return nil, false
}

// AsDatabaseMigrateEventProperties is the BasicEventProperties implementation for EventProperties.
func (ep EventProperties) AsDatabaseMigrateEventProperties() (*DatabaseMigrateEventProperties, bool) {
	return nil, false
}

// AsEventProperties is the BasicEventProperties implementation for EventProperties.
func (ep EventProperties) AsEventProperties() (*EventProperties, bool) {
	return &ep, true
}

// AsBasicEventProperties is the BasicEventProperties implementation for EventProperties.
func (ep EventProperties) AsBasicEventProperties() (BasicEventProperties, bool) {
	return &ep, true
}

// FilterClause ...
type FilterClause struct {
	// Expression - READ-ONLY
	Expression *SingleValueNode `json:"expression,omitempty"`
	// RangeVariable - READ-ONLY
	RangeVariable *RangeVariable `json:"rangeVariable,omitempty"`
	// ItemType - READ-ONLY
	ItemType *IEdmTypeReference `json:"itemType,omitempty"`
}

// FilterQueryOption ...
type FilterQueryOption struct {
	// Context - READ-ONLY
	Context   *ODataQueryContext `json:"context,omitempty"`
	Validator interface{}        `json:"validator,omitempty"`
	// FilterClause - READ-ONLY
	FilterClause *FilterClause `json:"filterClause,omitempty"`
	// RawValue - READ-ONLY
	RawValue *string `json:"rawValue,omitempty"`
}

// IEdmEntityContainer ...
type IEdmEntityContainer struct {
	// Elements - READ-ONLY
	Elements *[]IEdmEntityContainerElement `json:"elements,omitempty"`
	// SchemaElementKind - READ-ONLY; Possible values include: 'SchemaElementKind2None', 'SchemaElementKind2TypeDefinition', 'SchemaElementKind2Term', 'SchemaElementKind2Action', 'SchemaElementKind2EntityContainer', 'SchemaElementKind2Function'
	SchemaElementKind SchemaElementKind2 `json:"schemaElementKind,omitempty"`
	// Namespace - READ-ONLY
	Namespace *string `json:"namespace,omitempty"`
	// Name - READ-ONLY
	Name *string `json:"name,omitempty"`
}

// IEdmEntityContainerElement ...
type IEdmEntityContainerElement struct {
	// ContainerElementKind - READ-ONLY; Possible values include: 'ContainerElementKindNone', 'ContainerElementKindEntitySet', 'ContainerElementKindActionImport', 'ContainerElementKindFunctionImport', 'ContainerElementKindSingleton'
	ContainerElementKind ContainerElementKind `json:"containerElementKind,omitempty"`
	// Container - READ-ONLY
	Container *IEdmEntityContainer `json:"container,omitempty"`
	// Name - READ-ONLY
	Name *string `json:"name,omitempty"`
}

// IEdmExpression ...
type IEdmExpression struct {
	// ExpressionKind - READ-ONLY; Possible values include: 'ExpressionKindNone', 'ExpressionKindBinaryConstant', 'ExpressionKindBooleanConstant', 'ExpressionKindDateTimeOffsetConstant', 'ExpressionKindDecimalConstant', 'ExpressionKindFloatingConstant', 'ExpressionKindGUIDConstant', 'ExpressionKindIntegerConstant', 'ExpressionKindStringConstant', 'ExpressionKindDurationConstant', 'ExpressionKindNull', 'ExpressionKindRecord', 'ExpressionKindCollection', 'ExpressionKindPath', 'ExpressionKindIf', 'ExpressionKindCast', 'ExpressionKindIsType', 'ExpressionKindFunctionApplication', 'ExpressionKindLabeledExpressionReference', 'ExpressionKindLabeled', 'ExpressionKindPropertyPath', 'ExpressionKindNavigationPropertyPath', 'ExpressionKindDateConstant', 'ExpressionKindTimeOfDayConstant', 'ExpressionKindEnumMember', 'ExpressionKindAnnotationPath'
	ExpressionKind ExpressionKind `json:"expressionKind,omitempty"`
}

// IEdmModel ...
type IEdmModel struct {
	// SchemaElements - READ-ONLY
	SchemaElements *[]IEdmSchemaElement `json:"schemaElements,omitempty"`
	// VocabularyAnnotations - READ-ONLY
	VocabularyAnnotations *[]IEdmVocabularyAnnotation `json:"vocabularyAnnotations,omitempty"`
	// ReferencedModels - READ-ONLY
	ReferencedModels *[]IEdmModel `json:"referencedModels,omitempty"`
	// DeclaredNamespaces - READ-ONLY
	DeclaredNamespaces *[]string `json:"declaredNamespaces,omitempty"`
	// DirectValueAnnotationsManager - READ-ONLY
	DirectValueAnnotationsManager interface{} `json:"directValueAnnotationsManager,omitempty"`
	// EntityContainer - READ-ONLY
	EntityContainer *IEdmEntityContainer `json:"entityContainer,omitempty"`
}

// IEdmNavigationProperty ...
type IEdmNavigationProperty struct {
	// Partner - READ-ONLY
	Partner *IEdmNavigationProperty `json:"partner,omitempty"`
	// OnDelete - READ-ONLY; Possible values include: 'OnDeleteNone', 'OnDeleteCascade'
	OnDelete OnDelete `json:"onDelete,omitempty"`
	// ContainsTarget - READ-ONLY
	ContainsTarget *bool `json:"containsTarget,omitempty"`
	// ReferentialConstraint - READ-ONLY
	ReferentialConstraint *IEdmReferentialConstraint `json:"referentialConstraint,omitempty"`
	// PropertyKind - READ-ONLY; Possible values include: 'PropertyKind2None', 'PropertyKind2Structural', 'PropertyKind2Navigation'
	PropertyKind PropertyKind2 `json:"propertyKind,omitempty"`
	// Type - READ-ONLY
	Type *IEdmTypeReference `json:"type,omitempty"`
	// DeclaringType - READ-ONLY
	DeclaringType *IEdmStructuredType `json:"declaringType,omitempty"`
	// Name - READ-ONLY
	Name *string `json:"name,omitempty"`
}

// IEdmNavigationPropertyBinding ...
type IEdmNavigationPropertyBinding struct {
	// NavigationProperty - READ-ONLY
	NavigationProperty *IEdmNavigationProperty `json:"navigationProperty,omitempty"`
	// Target - READ-ONLY
	Target *IEdmNavigationSource `json:"target,omitempty"`
	// Path - READ-ONLY
	Path *IEdmPathExpression `json:"path,omitempty"`
}

// IEdmNavigationSource ...
type IEdmNavigationSource struct {
	// NavigationPropertyBindings - READ-ONLY
	NavigationPropertyBindings *[]IEdmNavigationPropertyBinding `json:"navigationPropertyBindings,omitempty"`
	// Path - READ-ONLY
	Path *IEdmPathExpression `json:"path,omitempty"`
	// Type - READ-ONLY
	Type *IEdmType `json:"type,omitempty"`
	// Name - READ-ONLY
	Name *string `json:"name,omitempty"`
}

// IEdmPathExpression ...
type IEdmPathExpression struct {
	// PathSegments - READ-ONLY
	PathSegments *[]string `json:"pathSegments,omitempty"`
	// Path - READ-ONLY
	Path *string `json:"path,omitempty"`
	// ExpressionKind - READ-ONLY; Possible values include: 'ExpressionKind1None', 'ExpressionKind1BinaryConstant', 'ExpressionKind1BooleanConstant', 'ExpressionKind1DateTimeOffsetConstant', 'ExpressionKind1DecimalConstant', 'ExpressionKind1FloatingConstant', 'ExpressionKind1GUIDConstant', 'ExpressionKind1IntegerConstant', 'ExpressionKind1StringConstant', 'ExpressionKind1DurationConstant', 'ExpressionKind1Null', 'ExpressionKind1Record', 'ExpressionKind1Collection', 'ExpressionKind1Path', 'ExpressionKind1If', 'ExpressionKind1Cast', 'ExpressionKind1IsType', 'ExpressionKind1FunctionApplication', 'ExpressionKind1LabeledExpressionReference', 'ExpressionKind1Labeled', 'ExpressionKind1PropertyPath', 'ExpressionKind1NavigationPropertyPath', 'ExpressionKind1DateConstant', 'ExpressionKind1TimeOfDayConstant', 'ExpressionKind1EnumMember', 'ExpressionKind1AnnotationPath'
	ExpressionKind ExpressionKind1 `json:"expressionKind,omitempty"`
}

// IEdmProperty ...
type IEdmProperty struct {
	// PropertyKind - READ-ONLY; Possible values include: 'PropertyKindNone', 'PropertyKindStructural', 'PropertyKindNavigation'
	PropertyKind PropertyKind `json:"propertyKind,omitempty"`
	// Type - READ-ONLY
	Type *IEdmTypeReference `json:"type,omitempty"`
	// DeclaringType - READ-ONLY
	DeclaringType *IEdmStructuredType `json:"declaringType,omitempty"`
	// Name - READ-ONLY
	Name *string `json:"name,omitempty"`
}

// IEdmReferentialConstraint ...
type IEdmReferentialConstraint struct {
	// PropertyPairs - READ-ONLY
	PropertyPairs *[]EdmReferentialConstraintPropertyPair `json:"propertyPairs,omitempty"`
}

// IEdmSchemaElement ...
type IEdmSchemaElement struct {
	// SchemaElementKind - READ-ONLY; Possible values include: 'SchemaElementKindNone', 'SchemaElementKindTypeDefinition', 'SchemaElementKindTerm', 'SchemaElementKindAction', 'SchemaElementKindEntityContainer', 'SchemaElementKindFunction'
	SchemaElementKind SchemaElementKind `json:"schemaElementKind,omitempty"`
	// Namespace - READ-ONLY
	Namespace *string `json:"namespace,omitempty"`
	// Name - READ-ONLY
	Name *string `json:"name,omitempty"`
}

// IEdmStructuralProperty ...
type IEdmStructuralProperty struct {
	// DefaultValueString - READ-ONLY
	DefaultValueString *string `json:"defaultValueString,omitempty"`
	// PropertyKind - READ-ONLY; Possible values include: 'PropertyKind1None', 'PropertyKind1Structural', 'PropertyKind1Navigation'
	PropertyKind PropertyKind1 `json:"propertyKind,omitempty"`
	// Type - READ-ONLY
	Type *IEdmTypeReference `json:"type,omitempty"`
	// DeclaringType - READ-ONLY
	DeclaringType *IEdmStructuredType `json:"declaringType,omitempty"`
	// Name - READ-ONLY
	Name *string `json:"name,omitempty"`
}

// IEdmStructuredType ...
type IEdmStructuredType struct {
	// IsAbstract - READ-ONLY
	IsAbstract *bool `json:"isAbstract,omitempty"`
	// IsOpen - READ-ONLY
	IsOpen *bool `json:"isOpen,omitempty"`
	// BaseType - READ-ONLY
	BaseType *IEdmStructuredType `json:"baseType,omitempty"`
	// DeclaredProperties - READ-ONLY
	DeclaredProperties *[]IEdmProperty `json:"declaredProperties,omitempty"`
	// TypeKind - READ-ONLY; Possible values include: 'TypeKind1None', 'TypeKind1Primitive', 'TypeKind1Entity', 'TypeKind1Complex', 'TypeKind1Collection', 'TypeKind1EntityReference', 'TypeKind1Enum', 'TypeKind1TypeDefinition', 'TypeKind1Untyped', 'TypeKind1Path'
	TypeKind TypeKind1 `json:"typeKind,omitempty"`
}

// IEdmTerm ...
type IEdmTerm struct {
	// Type - READ-ONLY
	Type *IEdmTypeReference `json:"type,omitempty"`
	// AppliesTo - READ-ONLY
	AppliesTo *string `json:"appliesTo,omitempty"`
	// DefaultValue - READ-ONLY
	DefaultValue *string `json:"defaultValue,omitempty"`
	// SchemaElementKind - READ-ONLY; Possible values include: 'SchemaElementKind1None', 'SchemaElementKind1TypeDefinition', 'SchemaElementKind1Term', 'SchemaElementKind1Action', 'SchemaElementKind1EntityContainer', 'SchemaElementKind1Function'
	SchemaElementKind SchemaElementKind1 `json:"schemaElementKind,omitempty"`
	// Namespace - READ-ONLY
	Namespace *string `json:"namespace,omitempty"`
	// Name - READ-ONLY
	Name *string `json:"name,omitempty"`
}

// IEdmType ...
type IEdmType struct {
	// TypeKind - READ-ONLY; Possible values include: 'TypeKindNone', 'TypeKindPrimitive', 'TypeKindEntity', 'TypeKindComplex', 'TypeKindCollection', 'TypeKindEntityReference', 'TypeKindEnum', 'TypeKindTypeDefinition', 'TypeKindUntyped', 'TypeKindPath'
	TypeKind TypeKind `json:"typeKind,omitempty"`
}

// IEdmTypeReference ...
type IEdmTypeReference struct {
	// IsNullable - READ-ONLY
	IsNullable *bool `json:"isNullable,omitempty"`
	// Definition - READ-ONLY
	Definition *IEdmType `json:"definition,omitempty"`
}

// IEdmVocabularyAnnotation ...
type IEdmVocabularyAnnotation struct {
	// Qualifier - READ-ONLY
	Qualifier *string `json:"qualifier,omitempty"`
	// Term - READ-ONLY
	Term *IEdmTerm `json:"term,omitempty"`
	// Target - READ-ONLY
	Target interface{} `json:"target,omitempty"`
	// Value - READ-ONLY
	Value *IEdmExpression `json:"value,omitempty"`
}

// Machine machine REST resource.
type Machine struct {
	autorest.Response `json:"-"`
	// ID - Gets or sets the relative URL to get to this REST resource.
	ID *string `json:"id,omitempty"`
	// Name - Gets or sets the name of this REST resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Gets the type of this REST resource.
	Type *string `json:"type,omitempty"`
	// Properties - Gets or sets the properties of the machine.
	Properties *MachineProperties `json:"properties,omitempty"`
}

// MachineCollection collection of machines.
type MachineCollection struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets the machines.
	Value *[]Machine `json:"value,omitempty"`
	// NextLink - Gets or sets the value of nextLink.
	NextLink *string `json:"nextLink,omitempty"`
}

// MachineMigrateEventProperties properties of the machine error resource.
type MachineMigrateEventProperties struct {
	// Machine - Gets or sets the machine for which the error is being reported.
	Machine *string `json:"machine,omitempty"`
	// ErrorCode - Gets or sets the error code.
	ErrorCode *string `json:"errorCode,omitempty"`
	// ErrorMessage - Gets or sets the error message.
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// Recommendation - Gets or sets the recommendation for the error.
	Recommendation *string `json:"recommendation,omitempty"`
	// PossibleCauses - Gets or sets the possible causes for the error.
	PossibleCauses *string `json:"possibleCauses,omitempty"`
	// Solution - Gets or sets the solution for which the error is being reported.
	Solution *string `json:"solution,omitempty"`
	// ClientRequestID - Gets or sets the client request Id of the payload for which the event is being reported.
	ClientRequestID *string `json:"clientRequestId,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeMigrateEventProperties', 'InstanceTypeServers', 'InstanceTypeDatabases'
	InstanceType InstanceType `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for MachineMigrateEventProperties.
func (mmep MachineMigrateEventProperties) MarshalJSON() ([]byte, error) {
	mmep.InstanceType = InstanceTypeServers
	objectMap := make(map[string]interface{})
	if mmep.Machine != nil {
		objectMap["machine"] = mmep.Machine
	}
	if mmep.ErrorCode != nil {
		objectMap["errorCode"] = mmep.ErrorCode
	}
	if mmep.ErrorMessage != nil {
		objectMap["errorMessage"] = mmep.ErrorMessage
	}
	if mmep.Recommendation != nil {
		objectMap["recommendation"] = mmep.Recommendation
	}
	if mmep.PossibleCauses != nil {
		objectMap["possibleCauses"] = mmep.PossibleCauses
	}
	if mmep.Solution != nil {
		objectMap["solution"] = mmep.Solution
	}
	if mmep.ClientRequestID != nil {
		objectMap["clientRequestId"] = mmep.ClientRequestID
	}
	if mmep.InstanceType != "" {
		objectMap["instanceType"] = mmep.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsMachineMigrateEventProperties is the BasicEventProperties implementation for MachineMigrateEventProperties.
func (mmep MachineMigrateEventProperties) AsMachineMigrateEventProperties() (*MachineMigrateEventProperties, bool) {
	return &mmep, true
}

// AsDatabaseMigrateEventProperties is the BasicEventProperties implementation for MachineMigrateEventProperties.
func (mmep MachineMigrateEventProperties) AsDatabaseMigrateEventProperties() (*DatabaseMigrateEventProperties, bool) {
	return nil, false
}

// AsEventProperties is the BasicEventProperties implementation for MachineMigrateEventProperties.
func (mmep MachineMigrateEventProperties) AsEventProperties() (*EventProperties, bool) {
	return nil, false
}

// AsBasicEventProperties is the BasicEventProperties implementation for MachineMigrateEventProperties.
func (mmep MachineMigrateEventProperties) AsBasicEventProperties() (BasicEventProperties, bool) {
	return &mmep, true
}

// MachineProperties properties of the machine resource.
type MachineProperties struct {
	// DiscoveryData - Gets or sets the discovery details of the machine published by various sources.
	DiscoveryData *[]DiscoveryDetails `json:"discoveryData,omitempty"`
	// AssessmentData - Gets or sets the assessment details of the machine published by various sources.
	AssessmentData *[]AssessmentDetails `json:"assessmentData,omitempty"`
	// MigrationData - Gets or sets the migration details of the machine published by various sources.
	MigrationData *[]MigrationDetails `json:"migrationData,omitempty"`
	// LastUpdatedTime - Gets or sets the time of the last modification of the machine.
	LastUpdatedTime *date.Time `json:"lastUpdatedTime,omitempty"`
}

// MigrationDetails migration properties that can be shared by various publishers.
type MigrationDetails struct {
	// MigrationPhase - Gets or sets the phase of migration of the machine.
	MigrationPhase *string `json:"migrationPhase,omitempty"`
	// MigrationTested - Gets or sets a value indicating whether migration was tested on the machine.
	MigrationTested *bool `json:"migrationTested,omitempty"`
	// ReplicationProgressPercentage - Gets or sets the progress percentage of migration on the machine.
	ReplicationProgressPercentage *int32 `json:"replicationProgressPercentage,omitempty"`
	// TargetVMArmID - Gets or sets the ARM id the migrated VM.
	TargetVMArmID *string `json:"targetVMArmId,omitempty"`
	// EnqueueTime - Gets or sets the time the message was enqueued.
	EnqueueTime *string `json:"enqueueTime,omitempty"`
	// SolutionName - Gets or sets the name of the solution that sent the data.
	SolutionName *string `json:"solutionName,omitempty"`
	// MachineID - Gets or sets the unique identifier of the machine.
	MachineID *string `json:"machineId,omitempty"`
	// MachineManagerID - Gets or sets the unique identifier of the virtual machine manager(vCenter/VMM).
	MachineManagerID *string `json:"machineManagerId,omitempty"`
	// FabricType - Gets or sets the fabric type.
	FabricType *string `json:"fabricType,omitempty"`
	// LastUpdatedTime - Gets or sets the time of the last modification of the machine details.
	LastUpdatedTime *date.Time `json:"lastUpdatedTime,omitempty"`
	// MachineName - Gets or sets the name of the machine.
	MachineName *string `json:"machineName,omitempty"`
	// IPAddresses - Gets or sets the list of IP addresses of the machine. IP addresses could be IP V4 or IP V6.
	IPAddresses *[]string `json:"ipAddresses,omitempty"`
	// Fqdn - Gets or sets the FQDN of the machine.
	Fqdn *string `json:"fqdn,omitempty"`
	// BiosID - Gets or sets the BIOS ID of the machine.
	BiosID *string `json:"biosId,omitempty"`
	// MacAddresses - Gets or sets the list of MAC addresses of the machine.
	MacAddresses *[]string `json:"macAddresses,omitempty"`
	// ExtendedInfo - Gets or sets the ISV specific extended information.
	ExtendedInfo map[string]*string `json:"extendedInfo"`
}

// MarshalJSON is the custom marshaler for MigrationDetails.
func (md MigrationDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if md.MigrationPhase != nil {
		objectMap["migrationPhase"] = md.MigrationPhase
	}
	if md.MigrationTested != nil {
		objectMap["migrationTested"] = md.MigrationTested
	}
	if md.ReplicationProgressPercentage != nil {
		objectMap["replicationProgressPercentage"] = md.ReplicationProgressPercentage
	}
	if md.TargetVMArmID != nil {
		objectMap["targetVMArmId"] = md.TargetVMArmID
	}
	if md.EnqueueTime != nil {
		objectMap["enqueueTime"] = md.EnqueueTime
	}
	if md.SolutionName != nil {
		objectMap["solutionName"] = md.SolutionName
	}
	if md.MachineID != nil {
		objectMap["machineId"] = md.MachineID
	}
	if md.MachineManagerID != nil {
		objectMap["machineManagerId"] = md.MachineManagerID
	}
	if md.FabricType != nil {
		objectMap["fabricType"] = md.FabricType
	}
	if md.LastUpdatedTime != nil {
		objectMap["lastUpdatedTime"] = md.LastUpdatedTime
	}
	if md.MachineName != nil {
		objectMap["machineName"] = md.MachineName
	}
	if md.IPAddresses != nil {
		objectMap["ipAddresses"] = md.IPAddresses
	}
	if md.Fqdn != nil {
		objectMap["fqdn"] = md.Fqdn
	}
	if md.BiosID != nil {
		objectMap["biosId"] = md.BiosID
	}
	if md.MacAddresses != nil {
		objectMap["macAddresses"] = md.MacAddresses
	}
	if md.ExtendedInfo != nil {
		objectMap["extendedInfo"] = md.ExtendedInfo
	}
	return json.Marshal(objectMap)
}

// ODataPath ...
type ODataPath struct {
	// EdmType - READ-ONLY
	EdmType *IEdmType `json:"edmType,omitempty"`
	// NavigationSource - READ-ONLY
	NavigationSource *IEdmNavigationSource `json:"navigationSource,omitempty"`
	// Segments - READ-ONLY
	Segments *[]ODataPathSegment `json:"segments,omitempty"`
	// PathTemplate - READ-ONLY
	PathTemplate *string `json:"pathTemplate,omitempty"`
	// Path - READ-ONLY
	Path *[]ODataPathSegment `json:"path,omitempty"`
}

// ODataPathSegment ...
type ODataPathSegment struct {
	// EdmType - READ-ONLY
	EdmType    *IEdmType `json:"edmType,omitempty"`
	Identifier *string   `json:"identifier,omitempty"`
}

// ODataQueryContext ...
type ODataQueryContext struct {
	// DefaultQuerySettings - READ-ONLY
	DefaultQuerySettings *DefaultQuerySettings `json:"defaultQuerySettings,omitempty"`
	// Model - READ-ONLY
	Model *IEdmModel `json:"model,omitempty"`
	// ElementType - READ-ONLY
	ElementType *IEdmType `json:"elementType,omitempty"`
	// NavigationSource - READ-ONLY
	NavigationSource *IEdmNavigationSource `json:"navigationSource,omitempty"`
	// ElementClrType - READ-ONLY
	ElementClrType *string `json:"elementClrType,omitempty"`
	// Path - READ-ONLY
	Path *ODataPath `json:"path,omitempty"`
	// RequestContainer - READ-ONLY
	RequestContainer interface{} `json:"requestContainer,omitempty"`
}

// ODataQueryOptions1 ...
type ODataQueryOptions1 struct {
	// Filter - READ-ONLY
	Filter *FilterQueryOption `json:"filter,omitempty"`
}

// ODataRawQueryOptions ...
type ODataRawQueryOptions struct {
	// Filter - READ-ONLY
	Filter *string `json:"filter,omitempty"`
}

// Operation a REST API operation supported by the provider.
type Operation struct {
	// Name - READ-ONLY; Name of the operation.
	Name *string `json:"name,omitempty"`
	// Display - Displayable properties of the operation.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - READ-ONLY; Origin of the operation.
	Origin *string `json:"origin,omitempty"`
}

// OperationDisplay displayable properties of the operation.
type OperationDisplay struct {
	// Provider - READ-ONLY; Provider of the operation.
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; Resource operated on by the operation.
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; Operation Type.
	Operation *string `json:"operation,omitempty"`
	// Description - READ-ONLY; Description of the operation.
	Description *string `json:"description,omitempty"`
}

// OperationResultList list of API operations.
type OperationResultList struct {
	autorest.Response `json:"-"`
	// Value - List of operations.
	Value *[]Operation `json:"value,omitempty"`
}

// Project migrate Project REST Resource.
type Project struct {
	autorest.Response `json:"-"`
	// ETag - Gets or sets the eTag for concurrency control.
	ETag *string `json:"eTag,omitempty"`
	// Location - Gets or sets the Azure location in which migrate project is created.
	Location *string `json:"location,omitempty"`
	// Properties - Gets or sets the nested properties.
	Properties *ProjectProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Gets the relative URL to get this migrate project.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Gets the name of the migrate project.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Handled by resource provider. Type = Microsoft.Migrate/MigrateProject.
	Type *string `json:"type,omitempty"`
	// Tags - Gets or sets the tags.
	Tags *ProjectTags `json:"tags,omitempty"`
}

// ProjectProperties class for migrate project properties.
type ProjectProperties struct {
	// RegisteredTools - Gets or sets the list of tools registered with the migrate project.
	RegisteredTools *[]string `json:"registeredTools,omitempty"`
	// Summary - READ-ONLY; Gets the summary of the migrate project.
	Summary map[string]BasicProjectSummary `json:"summary"`
	// LastSummaryRefreshedTime - READ-ONLY; Gets the last time the project summary was refreshed.
	LastSummaryRefreshedTime *date.Time `json:"lastSummaryRefreshedTime,omitempty"`
	// RefreshSummaryState - READ-ONLY; Gets the refresh summary state. Possible values include: 'RefreshSummaryState1Started', 'RefreshSummaryState1InProgress', 'RefreshSummaryState1Completed', 'RefreshSummaryState1Failed'
	RefreshSummaryState RefreshSummaryState1 `json:"refreshSummaryState,omitempty"`
	// ProvisioningState - Provisioning state of the migrate project. Possible values include: 'ProvisioningStateAccepted', 'ProvisioningStateCreating', 'ProvisioningStateDeleting', 'ProvisioningStateFailed', 'ProvisioningStateMoving', 'ProvisioningStateSucceeded'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ProjectProperties.
func (pp ProjectProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pp.RegisteredTools != nil {
		objectMap["registeredTools"] = pp.RegisteredTools
	}
	if pp.ProvisioningState != "" {
		objectMap["provisioningState"] = pp.ProvisioningState
	}
	return json.Marshal(objectMap)
}

// BasicProjectSummary the project summary class.
type BasicProjectSummary interface {
	AsServersProjectSummary() (*ServersProjectSummary, bool)
	AsDatabaseProjectSummary() (*DatabaseProjectSummary, bool)
	AsProjectSummary() (*ProjectSummary, bool)
}

// ProjectSummary the project summary class.
type ProjectSummary struct {
	// RefreshSummaryState - Gets or sets the state of refresh summary. Possible values include: 'RefreshSummaryStateStarted', 'RefreshSummaryStateInProgress', 'RefreshSummaryStateCompleted', 'RefreshSummaryStateFailed'
	RefreshSummaryState RefreshSummaryState `json:"refreshSummaryState,omitempty"`
	// LastSummaryRefreshedTime - Gets or sets the time when summary was last refreshed.
	LastSummaryRefreshedTime *date.Time `json:"lastSummaryRefreshedTime,omitempty"`
	// ExtendedSummary - Gets or sets the extended summary.
	ExtendedSummary map[string]*string `json:"extendedSummary"`
	// InstanceType - Possible values include: 'InstanceTypeBasicProjectSummaryInstanceTypeProjectSummary', 'InstanceTypeBasicProjectSummaryInstanceTypeServers', 'InstanceTypeBasicProjectSummaryInstanceTypeDatabases'
	InstanceType InstanceTypeBasicProjectSummary `json:"instanceType,omitempty"`
}

func unmarshalBasicProjectSummary(body []byte) (BasicProjectSummary, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeBasicProjectSummaryInstanceTypeServers):
		var sps ServersProjectSummary
		err := json.Unmarshal(body, &sps)
		return sps, err
	case string(InstanceTypeBasicProjectSummaryInstanceTypeDatabases):
		var dps DatabaseProjectSummary
		err := json.Unmarshal(body, &dps)
		return dps, err
	default:
		var ps ProjectSummary
		err := json.Unmarshal(body, &ps)
		return ps, err
	}
}
func unmarshalBasicProjectSummaryArray(body []byte) ([]BasicProjectSummary, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	psArray := make([]BasicProjectSummary, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ps, err := unmarshalBasicProjectSummary(*rawMessage)
		if err != nil {
			return nil, err
		}
		psArray[index] = ps
	}
	return psArray, nil
}

// MarshalJSON is the custom marshaler for ProjectSummary.
func (ps ProjectSummary) MarshalJSON() ([]byte, error) {
	ps.InstanceType = InstanceTypeBasicProjectSummaryInstanceTypeProjectSummary
	objectMap := make(map[string]interface{})
	if ps.RefreshSummaryState != "" {
		objectMap["refreshSummaryState"] = ps.RefreshSummaryState
	}
	if ps.LastSummaryRefreshedTime != nil {
		objectMap["lastSummaryRefreshedTime"] = ps.LastSummaryRefreshedTime
	}
	if ps.ExtendedSummary != nil {
		objectMap["extendedSummary"] = ps.ExtendedSummary
	}
	if ps.InstanceType != "" {
		objectMap["instanceType"] = ps.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsServersProjectSummary is the BasicProjectSummary implementation for ProjectSummary.
func (ps ProjectSummary) AsServersProjectSummary() (*ServersProjectSummary, bool) {
	return nil, false
}

// AsDatabaseProjectSummary is the BasicProjectSummary implementation for ProjectSummary.
func (ps ProjectSummary) AsDatabaseProjectSummary() (*DatabaseProjectSummary, bool) {
	return nil, false
}

// AsProjectSummary is the BasicProjectSummary implementation for ProjectSummary.
func (ps ProjectSummary) AsProjectSummary() (*ProjectSummary, bool) {
	return &ps, true
}

// AsBasicProjectSummary is the BasicProjectSummary implementation for ProjectSummary.
func (ps ProjectSummary) AsBasicProjectSummary() (BasicProjectSummary, bool) {
	return &ps, true
}

// ProjectTags gets or sets the tags.
type ProjectTags struct {
	AdditionalProperties *string `json:"additionalProperties,omitempty"`
}

// RangeVariable ...
type RangeVariable struct {
	// Name - READ-ONLY
	Name *string `json:"name,omitempty"`
	// TypeReference - READ-ONLY
	TypeReference *IEdmTypeReference `json:"typeReference,omitempty"`
	// Kind - READ-ONLY
	Kind *int32 `json:"kind,omitempty"`
}

// RefreshSummaryInput class representing the refresh summary input.
type RefreshSummaryInput struct {
	// Goal - Gets or sets the goal for which summary needs to be refreshed. Possible values include: 'Servers', 'Databases'
	Goal Goal `json:"goal,omitempty"`
}

// RefreshSummaryResult class representing the refresh summary status of the migrate project.
type RefreshSummaryResult struct {
	autorest.Response `json:"-"`
	// IsRefreshed - Gets or sets a value indicating whether the migrate project summary is refreshed.
	IsRefreshed *bool `json:"isRefreshed,omitempty"`
}

// RegisterToolInput class representing the register tool input.
type RegisterToolInput struct {
	// Tool - Gets or sets the tool to be registered. Possible values include: 'ServerDiscovery', 'ServerAssessment', 'ServerMigration', 'Cloudamize', 'Turbonomic', 'Zerto', 'CorentTech', 'ServerAssessmentV1', 'ServerMigrationReplication', 'Carbonite', 'DataMigrationAssistant', 'DatabaseMigrationService'
	Tool Tool `json:"tool,omitempty"`
}

// RegistrationResult class representing the registration status of a tool with the migrate project.
type RegistrationResult struct {
	autorest.Response `json:"-"`
	// IsRegistered - Gets or sets a value indicating whether the tool is registered or not.
	IsRegistered *bool `json:"isRegistered,omitempty"`
}

// SelectExpandClause ...
type SelectExpandClause struct {
	// SelectedItems - READ-ONLY
	SelectedItems *[]interface{} `json:"selectedItems,omitempty"`
	// AllSelected - READ-ONLY
	AllSelected *bool `json:"allSelected,omitempty"`
}

// ServersProjectSummary class representing the servers project summary.
type ServersProjectSummary struct {
	// DiscoveredCount - Gets or sets the count of entities discovered.
	DiscoveredCount *int32 `json:"discoveredCount,omitempty"`
	// AssessedCount - Gets or sets the count of entities assessed.
	AssessedCount *int32 `json:"assessedCount,omitempty"`
	// ReplicatingCount - Gets or sets the count of entities being replicated.
	ReplicatingCount *int32 `json:"replicatingCount,omitempty"`
	// TestMigratedCount - Gets or sets the count of entities test migrated.
	TestMigratedCount *int32 `json:"testMigratedCount,omitempty"`
	// MigratedCount - Gets or sets the count of entities migrated.
	MigratedCount *int32 `json:"migratedCount,omitempty"`
	// RefreshSummaryState - Gets or sets the state of refresh summary. Possible values include: 'RefreshSummaryStateStarted', 'RefreshSummaryStateInProgress', 'RefreshSummaryStateCompleted', 'RefreshSummaryStateFailed'
	RefreshSummaryState RefreshSummaryState `json:"refreshSummaryState,omitempty"`
	// LastSummaryRefreshedTime - Gets or sets the time when summary was last refreshed.
	LastSummaryRefreshedTime *date.Time `json:"lastSummaryRefreshedTime,omitempty"`
	// ExtendedSummary - Gets or sets the extended summary.
	ExtendedSummary map[string]*string `json:"extendedSummary"`
	// InstanceType - Possible values include: 'InstanceTypeBasicProjectSummaryInstanceTypeProjectSummary', 'InstanceTypeBasicProjectSummaryInstanceTypeServers', 'InstanceTypeBasicProjectSummaryInstanceTypeDatabases'
	InstanceType InstanceTypeBasicProjectSummary `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for ServersProjectSummary.
func (sps ServersProjectSummary) MarshalJSON() ([]byte, error) {
	sps.InstanceType = InstanceTypeBasicProjectSummaryInstanceTypeServers
	objectMap := make(map[string]interface{})
	if sps.DiscoveredCount != nil {
		objectMap["discoveredCount"] = sps.DiscoveredCount
	}
	if sps.AssessedCount != nil {
		objectMap["assessedCount"] = sps.AssessedCount
	}
	if sps.ReplicatingCount != nil {
		objectMap["replicatingCount"] = sps.ReplicatingCount
	}
	if sps.TestMigratedCount != nil {
		objectMap["testMigratedCount"] = sps.TestMigratedCount
	}
	if sps.MigratedCount != nil {
		objectMap["migratedCount"] = sps.MigratedCount
	}
	if sps.RefreshSummaryState != "" {
		objectMap["refreshSummaryState"] = sps.RefreshSummaryState
	}
	if sps.LastSummaryRefreshedTime != nil {
		objectMap["lastSummaryRefreshedTime"] = sps.LastSummaryRefreshedTime
	}
	if sps.ExtendedSummary != nil {
		objectMap["extendedSummary"] = sps.ExtendedSummary
	}
	if sps.InstanceType != "" {
		objectMap["instanceType"] = sps.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsServersProjectSummary is the BasicProjectSummary implementation for ServersProjectSummary.
func (sps ServersProjectSummary) AsServersProjectSummary() (*ServersProjectSummary, bool) {
	return &sps, true
}

// AsDatabaseProjectSummary is the BasicProjectSummary implementation for ServersProjectSummary.
func (sps ServersProjectSummary) AsDatabaseProjectSummary() (*DatabaseProjectSummary, bool) {
	return nil, false
}

// AsProjectSummary is the BasicProjectSummary implementation for ServersProjectSummary.
func (sps ServersProjectSummary) AsProjectSummary() (*ProjectSummary, bool) {
	return nil, false
}

// AsBasicProjectSummary is the BasicProjectSummary implementation for ServersProjectSummary.
func (sps ServersProjectSummary) AsBasicProjectSummary() (BasicProjectSummary, bool) {
	return &sps, true
}

// ServersSolutionSummary class representing the servers solution summary.
type ServersSolutionSummary struct {
	// DiscoveredCount - Gets or sets the count of servers discovered.
	DiscoveredCount *int32 `json:"discoveredCount,omitempty"`
	// AssessedCount - Gets or sets the count of servers assessed.
	AssessedCount *int32 `json:"assessedCount,omitempty"`
	// ReplicatingCount - Gets or sets the count of servers being replicated.
	ReplicatingCount *int32 `json:"replicatingCount,omitempty"`
	// TestMigratedCount - Gets or sets the count of servers test migrated.
	TestMigratedCount *int32 `json:"testMigratedCount,omitempty"`
	// MigratedCount - Gets or sets the count of servers migrated.
	MigratedCount *int32 `json:"migratedCount,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicSolutionSummaryInstanceTypeSolutionSummary', 'InstanceTypeBasicSolutionSummaryInstanceTypeServers', 'InstanceTypeBasicSolutionSummaryInstanceTypeDatabases'
	InstanceType InstanceTypeBasicSolutionSummary `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for ServersSolutionSummary.
func (sss ServersSolutionSummary) MarshalJSON() ([]byte, error) {
	sss.InstanceType = InstanceTypeBasicSolutionSummaryInstanceTypeServers
	objectMap := make(map[string]interface{})
	if sss.DiscoveredCount != nil {
		objectMap["discoveredCount"] = sss.DiscoveredCount
	}
	if sss.AssessedCount != nil {
		objectMap["assessedCount"] = sss.AssessedCount
	}
	if sss.ReplicatingCount != nil {
		objectMap["replicatingCount"] = sss.ReplicatingCount
	}
	if sss.TestMigratedCount != nil {
		objectMap["testMigratedCount"] = sss.TestMigratedCount
	}
	if sss.MigratedCount != nil {
		objectMap["migratedCount"] = sss.MigratedCount
	}
	if sss.InstanceType != "" {
		objectMap["instanceType"] = sss.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsServersSolutionSummary is the BasicSolutionSummary implementation for ServersSolutionSummary.
func (sss ServersSolutionSummary) AsServersSolutionSummary() (*ServersSolutionSummary, bool) {
	return &sss, true
}

// AsDatabasesSolutionSummary is the BasicSolutionSummary implementation for ServersSolutionSummary.
func (sss ServersSolutionSummary) AsDatabasesSolutionSummary() (*DatabasesSolutionSummary, bool) {
	return nil, false
}

// AsSolutionSummary is the BasicSolutionSummary implementation for ServersSolutionSummary.
func (sss ServersSolutionSummary) AsSolutionSummary() (*SolutionSummary, bool) {
	return nil, false
}

// AsBasicSolutionSummary is the BasicSolutionSummary implementation for ServersSolutionSummary.
func (sss ServersSolutionSummary) AsBasicSolutionSummary() (BasicSolutionSummary, bool) {
	return &sss, true
}

// SingleValueNode ...
type SingleValueNode struct {
	// TypeReference - READ-ONLY
	TypeReference *IEdmTypeReference `json:"typeReference,omitempty"`
	// Kind - READ-ONLY; Possible values include: 'KindNone', 'KindConstant', 'KindConvert', 'KindNonResourceRangeVariableReference', 'KindBinaryOperator', 'KindUnaryOperator', 'KindSingleValuePropertyAccess', 'KindCollectionPropertyAccess', 'KindSingleValueFunctionCall', 'KindAny', 'KindCollectionNavigationNode', 'KindSingleNavigationNode', 'KindSingleValueOpenPropertyAccess', 'KindSingleResourceCast', 'KindAll', 'KindCollectionResourceCast', 'KindResourceRangeVariableReference', 'KindSingleResourceFunctionCall', 'KindCollectionFunctionCall', 'KindCollectionResourceFunctionCall', 'KindNamedFunctionParameter', 'KindParameterAlias', 'KindEntitySet', 'KindKeyLookup', 'KindSearchTerm', 'KindCollectionOpenPropertyAccess', 'KindCollectionComplexNode', 'KindSingleComplexNode', 'KindCount', 'KindSingleValueCast', 'KindCollectionPropertyNode', 'KindAggregatedCollectionPropertyNode', 'KindIn', 'KindCollectionConstant'
	Kind Kind `json:"kind,omitempty"`
}

// Solution solution REST Resource.
type Solution struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Gets the relative URL to get to this REST resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Gets the name of this REST resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Gets the type of this REST resource.
	Type *string `json:"type,omitempty"`
	// Etag - Gets or sets the ETAG for optimistic concurrency control.
	Etag *string `json:"etag,omitempty"`
	// Properties - Gets or sets the properties of the solution.
	Properties *SolutionProperties `json:"properties,omitempty"`
}

// SolutionConfig class representing the config for the solution in the migrate project.
type SolutionConfig struct {
	autorest.Response `json:"-"`
	// PublisherSasURI - Gets or sets the publisher sas uri for the solution.
	PublisherSasURI *string `json:"publisherSasUri,omitempty"`
}

// SolutionDetails class representing the details of the solution.
type SolutionDetails struct {
	// GroupCount - Gets or sets the count of groups reported by the solution.
	GroupCount *int32 `json:"groupCount,omitempty"`
	// AssessmentCount - Gets or sets the count of assessments reported by the solution.
	AssessmentCount *int32 `json:"assessmentCount,omitempty"`
	// ExtendedDetails - Gets or sets the extended details reported by the solution.
	ExtendedDetails map[string]*string `json:"extendedDetails"`
}

// MarshalJSON is the custom marshaler for SolutionDetails.
func (sd SolutionDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sd.GroupCount != nil {
		objectMap["groupCount"] = sd.GroupCount
	}
	if sd.AssessmentCount != nil {
		objectMap["assessmentCount"] = sd.AssessmentCount
	}
	if sd.ExtendedDetails != nil {
		objectMap["extendedDetails"] = sd.ExtendedDetails
	}
	return json.Marshal(objectMap)
}

// SolutionProperties class for solution properties.
type SolutionProperties struct {
	// Tool - Gets or sets the tool being used in the solution. Possible values include: 'Tool1ServerDiscovery', 'Tool1ServerAssessment', 'Tool1ServerMigration', 'Tool1Cloudamize', 'Tool1Turbonomic', 'Tool1Zerto', 'Tool1CorentTech', 'Tool1ServerAssessmentV1', 'Tool1ServerMigrationReplication', 'Tool1Carbonite', 'Tool1DataMigrationAssistant', 'Tool1DatabaseMigrationService'
	Tool Tool1 `json:"tool,omitempty"`
	// Purpose - Gets or sets the purpose of the solution. Possible values include: 'Discovery', 'Assessment', 'Migration'
	Purpose Purpose `json:"purpose,omitempty"`
	// Goal - Gets or sets the goal of the solution. Possible values include: 'Goal1Servers', 'Goal1Databases'
	Goal Goal1 `json:"goal,omitempty"`
	// Status - Gets or sets the current status of the solution. Possible values include: 'Inactive', 'Active'
	Status Status `json:"status,omitempty"`
	// CleanupState - Gets or sets the cleanup state of the solution. Possible values include: 'None', 'Started', 'InProgress', 'Completed', 'Failed'
	CleanupState CleanupState `json:"cleanupState,omitempty"`
	// Summary - Gets or sets the summary of the solution.
	Summary BasicSolutionSummary `json:"summary,omitempty"`
	// Details - Gets or sets the details of the solution.
	Details *SolutionDetails `json:"details,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for SolutionProperties struct.
func (sp *SolutionProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tool":
			if v != nil {
				var tool Tool1
				err = json.Unmarshal(*v, &tool)
				if err != nil {
					return err
				}
				sp.Tool = tool
			}
		case "purpose":
			if v != nil {
				var purpose Purpose
				err = json.Unmarshal(*v, &purpose)
				if err != nil {
					return err
				}
				sp.Purpose = purpose
			}
		case "goal":
			if v != nil {
				var goal Goal1
				err = json.Unmarshal(*v, &goal)
				if err != nil {
					return err
				}
				sp.Goal = goal
			}
		case "status":
			if v != nil {
				var status Status
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				sp.Status = status
			}
		case "cleanupState":
			if v != nil {
				var cleanupState CleanupState
				err = json.Unmarshal(*v, &cleanupState)
				if err != nil {
					return err
				}
				sp.CleanupState = cleanupState
			}
		case "summary":
			if v != nil {
				summary, err := unmarshalBasicSolutionSummary(*v)
				if err != nil {
					return err
				}
				sp.Summary = summary
			}
		case "details":
			if v != nil {
				var details SolutionDetails
				err = json.Unmarshal(*v, &details)
				if err != nil {
					return err
				}
				sp.Details = &details
			}
		}
	}

	return nil
}

// SolutionsCollection collection of solutions.
type SolutionsCollection struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets the list of solutions.
	Value *[]Solution `json:"value,omitempty"`
	// NextLink - Gets or sets the value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// BasicSolutionSummary the solution summary class.
type BasicSolutionSummary interface {
	AsServersSolutionSummary() (*ServersSolutionSummary, bool)
	AsDatabasesSolutionSummary() (*DatabasesSolutionSummary, bool)
	AsSolutionSummary() (*SolutionSummary, bool)
}

// SolutionSummary the solution summary class.
type SolutionSummary struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicSolutionSummaryInstanceTypeSolutionSummary', 'InstanceTypeBasicSolutionSummaryInstanceTypeServers', 'InstanceTypeBasicSolutionSummaryInstanceTypeDatabases'
	InstanceType InstanceTypeBasicSolutionSummary `json:"instanceType,omitempty"`
}

func unmarshalBasicSolutionSummary(body []byte) (BasicSolutionSummary, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeBasicSolutionSummaryInstanceTypeServers):
		var sss ServersSolutionSummary
		err := json.Unmarshal(body, &sss)
		return sss, err
	case string(InstanceTypeBasicSolutionSummaryInstanceTypeDatabases):
		var dss DatabasesSolutionSummary
		err := json.Unmarshal(body, &dss)
		return dss, err
	default:
		var ss SolutionSummary
		err := json.Unmarshal(body, &ss)
		return ss, err
	}
}
func unmarshalBasicSolutionSummaryArray(body []byte) ([]BasicSolutionSummary, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ssArray := make([]BasicSolutionSummary, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ss, err := unmarshalBasicSolutionSummary(*rawMessage)
		if err != nil {
			return nil, err
		}
		ssArray[index] = ss
	}
	return ssArray, nil
}

// MarshalJSON is the custom marshaler for SolutionSummary.
func (ss SolutionSummary) MarshalJSON() ([]byte, error) {
	ss.InstanceType = InstanceTypeBasicSolutionSummaryInstanceTypeSolutionSummary
	objectMap := make(map[string]interface{})
	if ss.InstanceType != "" {
		objectMap["instanceType"] = ss.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsServersSolutionSummary is the BasicSolutionSummary implementation for SolutionSummary.
func (ss SolutionSummary) AsServersSolutionSummary() (*ServersSolutionSummary, bool) {
	return nil, false
}

// AsDatabasesSolutionSummary is the BasicSolutionSummary implementation for SolutionSummary.
func (ss SolutionSummary) AsDatabasesSolutionSummary() (*DatabasesSolutionSummary, bool) {
	return nil, false
}

// AsSolutionSummary is the BasicSolutionSummary implementation for SolutionSummary.
func (ss SolutionSummary) AsSolutionSummary() (*SolutionSummary, bool) {
	return &ss, true
}

// AsBasicSolutionSummary is the BasicSolutionSummary implementation for SolutionSummary.
func (ss SolutionSummary) AsBasicSolutionSummary() (BasicSolutionSummary, bool) {
	return &ss, true
}

// TransformationNode ...
type TransformationNode struct {
	// Kind - READ-ONLY; Possible values include: 'Aggregate', 'GroupBy', 'Filter', 'Compute'
	Kind Kind1 `json:"kind,omitempty"`
}
