package digitaltwins

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// Client is the a service for managing and querying digital twins and digital twin models.
type Client struct {
	BaseClient
}

// NewClient creates an instance of the Client client.
func NewClient() Client {
	return NewClientWithBaseURI(DefaultBaseURI)
}

// NewClientWithBaseURI creates an instance of the Client client using a custom endpoint.  Use this when interacting
// with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewClientWithBaseURI(baseURI string) Client {
	return Client{NewWithBaseURI(baseURI)}
}

// Add adds or replaces a digital twin.
// Status codes:
// 200 (OK): Success.
// 400 (Bad Request): The request is invalid.
// 412 (Precondition Failed): The model is decommissioned or the digital twin already exists (when using If-None-Match:
// *).
// Parameters:
// ID - the id of the digital twin. The id is unique within the service and case sensitive.
// twin - the digital twin instance being added. If provided, the $dtId property is ignored.
// ifNoneMatch - only perform the operation if the entity does not already exist.
func (client Client) Add(ctx context.Context, ID string, twin interface{}, ifNoneMatch string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.Add")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.AddPreparer(ctx, ID, twin, ifNoneMatch)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "Add", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "Add", resp, "Failure sending request")
		return
	}

	result, err = client.AddResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "Add", resp, "Failure responding to request")
	}

	return
}

// AddPreparer prepares the Add request.
func (client Client) AddPreparer(ctx context.Context, ID string, twin interface{}, ifNoneMatch string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id": autorest.Encode("path", ID),
	}

	const APIVersion = "2020-05-31-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/digitaltwins/{id}", pathParameters),
		autorest.WithJSON(twin),
		autorest.WithQueryParameters(queryParameters))
	if len(string(ifNoneMatch)) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-None-Match", autorest.String(ifNoneMatch)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddSender sends the Add request. The method will close the
// http.Response Body if it receives an error.
func (client Client) AddSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddResponder handles the response to the Add request. The method always
// closes the http.Response Body.
func (client Client) AddResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddRelationship adds a relationship between two digital twins.
// Status codes:
// 200 (OK): Success.
// 400 (Bad Request): The request is invalid.
// 404 (Not Found): There is either no digital twin, target digital twin, or relationship with the provided id.
// 409 (Conflict): A relationship with the provided id already exists.
// Parameters:
// ID - the id of the digital twin. The id is unique within the service and case sensitive.
// relationshipID - the id of the relationship. The id is unique within the digital twin and case sensitive.
// relationship - the data for the relationship.
// ifNoneMatch - only perform the operation if the entity does not already exist.
func (client Client) AddRelationship(ctx context.Context, ID string, relationshipID string, relationship *interface{}, ifNoneMatch string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.AddRelationship")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.AddRelationshipPreparer(ctx, ID, relationshipID, relationship, ifNoneMatch)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "AddRelationship", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddRelationshipSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "AddRelationship", resp, "Failure sending request")
		return
	}

	result, err = client.AddRelationshipResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "AddRelationship", resp, "Failure responding to request")
	}

	return
}

// AddRelationshipPreparer prepares the AddRelationship request.
func (client Client) AddRelationshipPreparer(ctx context.Context, ID string, relationshipID string, relationship *interface{}, ifNoneMatch string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":             autorest.Encode("path", ID),
		"relationshipId": autorest.Encode("path", relationshipID),
	}

	const APIVersion = "2020-05-31-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/digitaltwins/{id}/relationships/{relationshipId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	if relationship != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithJSON(relationship))
	}
	if len(string(ifNoneMatch)) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-None-Match", autorest.String(ifNoneMatch)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddRelationshipSender sends the AddRelationship request. The method will close the
// http.Response Body if it receives an error.
func (client Client) AddRelationshipSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddRelationshipResponder handles the response to the AddRelationship request. The method always
// closes the http.Response Body.
func (client Client) AddRelationshipResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete deletes a digital twin. All relationships referencing the digital twin must already be deleted.
// Status codes:
// 200 (OK): Success.
// 400 (Bad Request): The request is invalid.
// 404 (Not Found): There is no digital twin with the provided id.
// Parameters:
// ID - the id of the digital twin. The id is unique within the service and case sensitive.
// ifMatch - only perform the operation if the entity's etag matches one of the etags provided or * is
// provided.
func (client Client) Delete(ctx context.Context, ID string, ifMatch string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.Delete")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeletePreparer(ctx, ID, ifMatch)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "Delete", resp, "Failure responding to request")
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client Client) DeletePreparer(ctx context.Context, ID string, ifMatch string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id": autorest.Encode("path", ID),
	}

	const APIVersion = "2020-05-31-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/digitaltwins/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	if len(ifMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Match", autorest.String(ifMatch)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client Client) DeleteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client Client) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteRelationship deletes a relationship between two digital twins.
// Status codes:
// 200 (OK): Success.
// 404 (Not Found): There is either no digital twin or relationship with the provided id.
// Parameters:
// ID - the id of the digital twin. The id is unique within the service and case sensitive.
// relationshipID - the id of the relationship. The id is unique within the digital twin and case sensitive.
// ifMatch - only perform the operation if the entity's etag matches one of the etags provided or * is
// provided.
func (client Client) DeleteRelationship(ctx context.Context, ID string, relationshipID string, ifMatch string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.DeleteRelationship")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteRelationshipPreparer(ctx, ID, relationshipID, ifMatch)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "DeleteRelationship", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteRelationshipSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "DeleteRelationship", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteRelationshipResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "DeleteRelationship", resp, "Failure responding to request")
	}

	return
}

// DeleteRelationshipPreparer prepares the DeleteRelationship request.
func (client Client) DeleteRelationshipPreparer(ctx context.Context, ID string, relationshipID string, ifMatch string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":             autorest.Encode("path", ID),
		"relationshipId": autorest.Encode("path", relationshipID),
	}

	const APIVersion = "2020-05-31-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/digitaltwins/{id}/relationships/{relationshipId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	if len(ifMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Match", autorest.String(ifMatch)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteRelationshipSender sends the DeleteRelationship request. The method will close the
// http.Response Body if it receives an error.
func (client Client) DeleteRelationshipSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteRelationshipResponder handles the response to the DeleteRelationship request. The method always
// closes the http.Response Body.
func (client Client) DeleteRelationshipResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// GetByID retrieves a digital twin.
// Status codes:
// 200 (OK): Success.
// 404 (Not Found): There is no digital twin with the provided id.
// Parameters:
// ID - the id of the digital twin. The id is unique within the service and case sensitive.
func (client Client) GetByID(ctx context.Context, ID string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.GetByID")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetByIDPreparer(ctx, ID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "GetByID", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetByIDSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "GetByID", resp, "Failure sending request")
		return
	}

	result, err = client.GetByIDResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "GetByID", resp, "Failure responding to request")
	}

	return
}

// GetByIDPreparer prepares the GetByID request.
func (client Client) GetByIDPreparer(ctx context.Context, ID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id": autorest.Encode("path", ID),
	}

	const APIVersion = "2020-05-31-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/digitaltwins/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetByIDSender sends the GetByID request. The method will close the
// http.Response Body if it receives an error.
func (client Client) GetByIDSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetByIDResponder handles the response to the GetByID request. The method always
// closes the http.Response Body.
func (client Client) GetByIDResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetComponent retrieves a component from a digital twin.
// Status codes:
// 200 (OK): Success.
// 404 (Not Found): There is either no digital twin with the provided id or the component path is invalid.
// Parameters:
// ID - the id of the digital twin. The id is unique within the service and case sensitive.
// componentPath - the name of the DTDL component.
func (client Client) GetComponent(ctx context.Context, ID string, componentPath string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.GetComponent")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetComponentPreparer(ctx, ID, componentPath)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "GetComponent", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetComponentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "GetComponent", resp, "Failure sending request")
		return
	}

	result, err = client.GetComponentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "GetComponent", resp, "Failure responding to request")
	}

	return
}

// GetComponentPreparer prepares the GetComponent request.
func (client Client) GetComponentPreparer(ctx context.Context, ID string, componentPath string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"componentPath": autorest.Encode("path", componentPath),
		"id":            autorest.Encode("path", ID),
	}

	const APIVersion = "2020-05-31-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/digitaltwins/{id}/components/{componentPath}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetComponentSender sends the GetComponent request. The method will close the
// http.Response Body if it receives an error.
func (client Client) GetComponentSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetComponentResponder handles the response to the GetComponent request. The method always
// closes the http.Response Body.
func (client Client) GetComponentResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetRelationshipByID retrieves a relationship between two digital twins.
// Status codes:
// 200 (OK): Success.
// 404 (Not Found): There is either no digital twin or relationship with the provided id.
// Parameters:
// ID - the id of the digital twin. The id is unique within the service and case sensitive.
// relationshipID - the id of the relationship. The id is unique within the digital twin and case sensitive.
func (client Client) GetRelationshipByID(ctx context.Context, ID string, relationshipID string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.GetRelationshipByID")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetRelationshipByIDPreparer(ctx, ID, relationshipID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "GetRelationshipByID", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetRelationshipByIDSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "GetRelationshipByID", resp, "Failure sending request")
		return
	}

	result, err = client.GetRelationshipByIDResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "GetRelationshipByID", resp, "Failure responding to request")
	}

	return
}

// GetRelationshipByIDPreparer prepares the GetRelationshipByID request.
func (client Client) GetRelationshipByIDPreparer(ctx context.Context, ID string, relationshipID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":             autorest.Encode("path", ID),
		"relationshipId": autorest.Encode("path", relationshipID),
	}

	const APIVersion = "2020-05-31-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/digitaltwins/{id}/relationships/{relationshipId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetRelationshipByIDSender sends the GetRelationshipByID request. The method will close the
// http.Response Body if it receives an error.
func (client Client) GetRelationshipByIDSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetRelationshipByIDResponder handles the response to the GetRelationshipByID request. The method always
// closes the http.Response Body.
func (client Client) GetRelationshipByIDResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListIncomingRelationships retrieves all incoming relationship for a digital twin.
// Status codes:
// 200 (OK): Success.
// 400 (Bad Request): The request is invalid.
// 404 (Not Found): There is no digital twin with the provided id.
// Parameters:
// ID - the id of the digital twin. The id is unique within the service and case sensitive.
func (client Client) ListIncomingRelationships(ctx context.Context, ID string) (result IncomingRelationshipCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListIncomingRelationships")
		defer func() {
			sc := -1
			if result.irc.Response.Response != nil {
				sc = result.irc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listIncomingRelationshipsNextResults
	req, err := client.ListIncomingRelationshipsPreparer(ctx, ID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "ListIncomingRelationships", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListIncomingRelationshipsSender(req)
	if err != nil {
		result.irc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "ListIncomingRelationships", resp, "Failure sending request")
		return
	}

	result.irc, err = client.ListIncomingRelationshipsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "ListIncomingRelationships", resp, "Failure responding to request")
	}

	return
}

// ListIncomingRelationshipsPreparer prepares the ListIncomingRelationships request.
func (client Client) ListIncomingRelationshipsPreparer(ctx context.Context, ID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id": autorest.Encode("path", ID),
	}

	const APIVersion = "2020-05-31-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/digitaltwins/{id}/incomingrelationships", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListIncomingRelationshipsSender sends the ListIncomingRelationships request. The method will close the
// http.Response Body if it receives an error.
func (client Client) ListIncomingRelationshipsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListIncomingRelationshipsResponder handles the response to the ListIncomingRelationships request. The method always
// closes the http.Response Body.
func (client Client) ListIncomingRelationshipsResponder(resp *http.Response) (result IncomingRelationshipCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listIncomingRelationshipsNextResults retrieves the next set of results, if any.
func (client Client) listIncomingRelationshipsNextResults(ctx context.Context, lastResults IncomingRelationshipCollection) (result IncomingRelationshipCollection, err error) {
	req, err := lastResults.incomingRelationshipCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "digitaltwins.Client", "listIncomingRelationshipsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListIncomingRelationshipsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "digitaltwins.Client", "listIncomingRelationshipsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListIncomingRelationshipsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "listIncomingRelationshipsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListIncomingRelationshipsComplete enumerates all values, automatically crossing page boundaries as required.
func (client Client) ListIncomingRelationshipsComplete(ctx context.Context, ID string) (result IncomingRelationshipCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListIncomingRelationships")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListIncomingRelationships(ctx, ID)
	return
}

// ListRelationships retrieves the relationships from a digital twin.
// Status codes:
// 200 (OK): Success.
// 400 (Bad Request): The request is invalid.
// 404 (Not Found): There is no digital twin with the provided id.
// Parameters:
// ID - the id of the digital twin. The id is unique within the service and case sensitive.
// relationshipName - the name of the relationship.
func (client Client) ListRelationships(ctx context.Context, ID string, relationshipName string) (result RelationshipCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListRelationships")
		defer func() {
			sc := -1
			if result.rc.Response.Response != nil {
				sc = result.rc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listRelationshipsNextResults
	req, err := client.ListRelationshipsPreparer(ctx, ID, relationshipName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "ListRelationships", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListRelationshipsSender(req)
	if err != nil {
		result.rc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "ListRelationships", resp, "Failure sending request")
		return
	}

	result.rc, err = client.ListRelationshipsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "ListRelationships", resp, "Failure responding to request")
	}

	return
}

// ListRelationshipsPreparer prepares the ListRelationships request.
func (client Client) ListRelationshipsPreparer(ctx context.Context, ID string, relationshipName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id": autorest.Encode("path", ID),
	}

	const APIVersion = "2020-05-31-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(relationshipName) > 0 {
		queryParameters["relationshipName"] = autorest.Encode("query", relationshipName)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/digitaltwins/{id}/relationships", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListRelationshipsSender sends the ListRelationships request. The method will close the
// http.Response Body if it receives an error.
func (client Client) ListRelationshipsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListRelationshipsResponder handles the response to the ListRelationships request. The method always
// closes the http.Response Body.
func (client Client) ListRelationshipsResponder(resp *http.Response) (result RelationshipCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listRelationshipsNextResults retrieves the next set of results, if any.
func (client Client) listRelationshipsNextResults(ctx context.Context, lastResults RelationshipCollection) (result RelationshipCollection, err error) {
	req, err := lastResults.relationshipCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "digitaltwins.Client", "listRelationshipsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListRelationshipsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "digitaltwins.Client", "listRelationshipsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListRelationshipsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "listRelationshipsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListRelationshipsComplete enumerates all values, automatically crossing page boundaries as required.
func (client Client) ListRelationshipsComplete(ctx context.Context, ID string, relationshipName string) (result RelationshipCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListRelationships")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListRelationships(ctx, ID, relationshipName)
	return
}

// SendComponentTelemetry sends telemetry on behalf of a component in a digital twin.
// Status codes:
// 200 (OK): Success.
// 400 (Bad Request): The request is invalid.
// 404 (Not Found): There is either no digital twin with the provided id or the component path is invalid.
// Parameters:
// ID - the id of the digital twin. The id is unique within the service and case sensitive.
// componentPath - the name of the DTDL component.
// telemetry - the telemetry measurements to send from the digital twin's component.
// dtID - a unique message identifier (in the scope of the digital twin id) that is commonly used for
// de-duplicating messages.
// dtTimestamp - an RFC 3339 timestamp that identifies the time the telemetry was measured.
func (client Client) SendComponentTelemetry(ctx context.Context, ID string, componentPath string, telemetry interface{}, dtID string, dtTimestamp string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.SendComponentTelemetry")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.SendComponentTelemetryPreparer(ctx, ID, componentPath, telemetry, dtID, dtTimestamp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "SendComponentTelemetry", nil, "Failure preparing request")
		return
	}

	resp, err := client.SendComponentTelemetrySender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "SendComponentTelemetry", resp, "Failure sending request")
		return
	}

	result, err = client.SendComponentTelemetryResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "SendComponentTelemetry", resp, "Failure responding to request")
	}

	return
}

// SendComponentTelemetryPreparer prepares the SendComponentTelemetry request.
func (client Client) SendComponentTelemetryPreparer(ctx context.Context, ID string, componentPath string, telemetry interface{}, dtID string, dtTimestamp string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"componentPath": autorest.Encode("path", componentPath),
		"id":            autorest.Encode("path", ID),
	}

	const APIVersion = "2020-05-31-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/digitaltwins/{id}/components/{componentPath}/telemetry", pathParameters),
		autorest.WithJSON(telemetry),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("dt-id", autorest.String(dtID)))
	if len(dtTimestamp) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("dt-timestamp", autorest.String(dtTimestamp)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SendComponentTelemetrySender sends the SendComponentTelemetry request. The method will close the
// http.Response Body if it receives an error.
func (client Client) SendComponentTelemetrySender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// SendComponentTelemetryResponder handles the response to the SendComponentTelemetry request. The method always
// closes the http.Response Body.
func (client Client) SendComponentTelemetryResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// SendTelemetry sends telemetry on behalf of a digital twin.
// Status codes:
// 200 (OK): Success.
// 400 (Bad Request): The request is invalid.
// 404 (Not Found): There is no digital twin with the provided id.
// Parameters:
// ID - the id of the digital twin. The id is unique within the service and case sensitive.
// telemetry - the telemetry measurements to send from the digital twin.
// dtID - a unique message identifier (in the scope of the digital twin id) that is commonly used for
// de-duplicating messages.
// dtTimestamp - an RFC 3339 timestamp that identifies the time the telemetry was measured.
func (client Client) SendTelemetry(ctx context.Context, ID string, telemetry interface{}, dtID string, dtTimestamp string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.SendTelemetry")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.SendTelemetryPreparer(ctx, ID, telemetry, dtID, dtTimestamp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "SendTelemetry", nil, "Failure preparing request")
		return
	}

	resp, err := client.SendTelemetrySender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "SendTelemetry", resp, "Failure sending request")
		return
	}

	result, err = client.SendTelemetryResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "SendTelemetry", resp, "Failure responding to request")
	}

	return
}

// SendTelemetryPreparer prepares the SendTelemetry request.
func (client Client) SendTelemetryPreparer(ctx context.Context, ID string, telemetry interface{}, dtID string, dtTimestamp string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id": autorest.Encode("path", ID),
	}

	const APIVersion = "2020-05-31-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/digitaltwins/{id}/telemetry", pathParameters),
		autorest.WithJSON(telemetry),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("dt-id", autorest.String(dtID)))
	if len(dtTimestamp) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("dt-timestamp", autorest.String(dtTimestamp)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SendTelemetrySender sends the SendTelemetry request. The method will close the
// http.Response Body if it receives an error.
func (client Client) SendTelemetrySender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// SendTelemetryResponder handles the response to the SendTelemetry request. The method always
// closes the http.Response Body.
func (client Client) SendTelemetryResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Update updates a digital twin.
// Status codes:
// 200 (OK): Success.
// 400 (Bad Request): The request is invalid.
// 404 (Not Found): There is no digital twin with the provided id.
// Parameters:
// ID - the id of the digital twin. The id is unique within the service and case sensitive.
// patchDocument - an update specification described by JSON Patch. Updates to property values and $model
// elements may happen in the same request. Operations are limited to add, replace and remove.
// ifMatch - only perform the operation if the entity's etag matches one of the etags provided or * is
// provided.
func (client Client) Update(ctx context.Context, ID string, patchDocument []interface{}, ifMatch string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.Update")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: patchDocument,
			Constraints: []validation.Constraint{{Target: "patchDocument", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("digitaltwins.Client", "Update", err.Error())
	}

	req, err := client.UpdatePreparer(ctx, ID, patchDocument, ifMatch)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "Update", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "Update", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "Update", resp, "Failure responding to request")
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client Client) UpdatePreparer(ctx context.Context, ID string, patchDocument []interface{}, ifMatch string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id": autorest.Encode("path", ID),
	}

	const APIVersion = "2020-05-31-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json-patch+json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/digitaltwins/{id}", pathParameters),
		autorest.WithJSON(patchDocument),
		autorest.WithQueryParameters(queryParameters))
	if len(ifMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Match", autorest.String(ifMatch)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client Client) UpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client Client) UpdateResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// UpdateComponent updates a component on a digital twin.
// Status codes:
// 200 (OK): Success.
// 400 (Bad Request): The request is invalid.
// 404 (Not Found): There is either no digital twin with the provided id or the component path is invalid.
// Parameters:
// ID - the id of the digital twin. The id is unique within the service and case sensitive.
// componentPath - the name of the DTDL component.
// patchDocument - an update specification described by JSON Patch. Updates to property values and $model
// elements may happen in the same request. Operations are limited to add, replace and remove.
// ifMatch - only perform the operation if the entity's etag matches one of the etags provided or * is
// provided.
func (client Client) UpdateComponent(ctx context.Context, ID string, componentPath string, patchDocument []interface{}, ifMatch string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.UpdateComponent")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateComponentPreparer(ctx, ID, componentPath, patchDocument, ifMatch)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "UpdateComponent", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateComponentSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "UpdateComponent", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateComponentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "UpdateComponent", resp, "Failure responding to request")
	}

	return
}

// UpdateComponentPreparer prepares the UpdateComponent request.
func (client Client) UpdateComponentPreparer(ctx context.Context, ID string, componentPath string, patchDocument []interface{}, ifMatch string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"componentPath": autorest.Encode("path", componentPath),
		"id":            autorest.Encode("path", ID),
	}

	const APIVersion = "2020-05-31-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json-patch+json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/digitaltwins/{id}/components/{componentPath}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	if patchDocument != nil && len(patchDocument) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithJSON(patchDocument))
	}
	if len(ifMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Match", autorest.String(ifMatch)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateComponentSender sends the UpdateComponent request. The method will close the
// http.Response Body if it receives an error.
func (client Client) UpdateComponentSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateComponentResponder handles the response to the UpdateComponent request. The method always
// closes the http.Response Body.
func (client Client) UpdateComponentResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// UpdateRelationship updates the properties on a relationship between two digital twins.
// Status codes:
// 200 (OK): Success.
// 400 (Bad Request): The request is invalid.
// 404 (Not Found): There is either no digital twin or relationship with the provided id.
// Parameters:
// ID - the id of the digital twin. The id is unique within the service and case sensitive.
// relationshipID - the id of the relationship. The id is unique within the digital twin and case sensitive.
// patchDocument - JSON Patch description of the update to the relationship properties.
// ifMatch - only perform the operation if the entity's etag matches one of the etags provided or * is
// provided.
func (client Client) UpdateRelationship(ctx context.Context, ID string, relationshipID string, patchDocument []interface{}, ifMatch string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.UpdateRelationship")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateRelationshipPreparer(ctx, ID, relationshipID, patchDocument, ifMatch)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "UpdateRelationship", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateRelationshipSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "UpdateRelationship", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateRelationshipResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.Client", "UpdateRelationship", resp, "Failure responding to request")
	}

	return
}

// UpdateRelationshipPreparer prepares the UpdateRelationship request.
func (client Client) UpdateRelationshipPreparer(ctx context.Context, ID string, relationshipID string, patchDocument []interface{}, ifMatch string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":             autorest.Encode("path", ID),
		"relationshipId": autorest.Encode("path", relationshipID),
	}

	const APIVersion = "2020-05-31-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json-patch+json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/digitaltwins/{id}/relationships/{relationshipId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	if patchDocument != nil && len(patchDocument) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithJSON(patchDocument))
	}
	if len(ifMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Match", autorest.String(ifMatch)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateRelationshipSender sends the UpdateRelationship request. The method will close the
// http.Response Body if it receives an error.
func (client Client) UpdateRelationshipSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateRelationshipResponder handles the response to the UpdateRelationship request. The method always
// closes the http.Response Body.
func (client Client) UpdateRelationshipResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}
