// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.12.3
// source: google/devtools/cloudbuild/v1/cloudbuild.proto

package cloudbuild

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Possible status of a build or build step.
type Build_Status int32

const (
	// Status of the build is unknown.
	Build_STATUS_UNKNOWN Build_Status = 0
	// Build or step is queued; work has not yet begun.
	Build_QUEUED Build_Status = 1
	// Build or step is being executed.
	Build_WORKING Build_Status = 2
	// Build or step finished successfully.
	Build_SUCCESS Build_Status = 3
	// Build or step failed to complete successfully.
	Build_FAILURE Build_Status = 4
	// Build or step failed due to an internal cause.
	Build_INTERNAL_ERROR Build_Status = 5
	// Build or step took longer than was allowed.
	Build_TIMEOUT Build_Status = 6
	// Build or step was canceled by a user.
	Build_CANCELLED Build_Status = 7
	// Build was enqueued for longer than the value of `queue_ttl`.
	Build_EXPIRED Build_Status = 9
)

// Enum value maps for Build_Status.
var (
	Build_Status_name = map[int32]string{
		0: "STATUS_UNKNOWN",
		1: "QUEUED",
		2: "WORKING",
		3: "SUCCESS",
		4: "FAILURE",
		5: "INTERNAL_ERROR",
		6: "TIMEOUT",
		7: "CANCELLED",
		9: "EXPIRED",
	}
	Build_Status_value = map[string]int32{
		"STATUS_UNKNOWN": 0,
		"QUEUED":         1,
		"WORKING":        2,
		"SUCCESS":        3,
		"FAILURE":        4,
		"INTERNAL_ERROR": 5,
		"TIMEOUT":        6,
		"CANCELLED":      7,
		"EXPIRED":        9,
	}
)

func (x Build_Status) Enum() *Build_Status {
	p := new(Build_Status)
	*p = x
	return p
}

func (x Build_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Build_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_enumTypes[0].Descriptor()
}

func (Build_Status) Type() protoreflect.EnumType {
	return &file_google_devtools_cloudbuild_v1_cloudbuild_proto_enumTypes[0]
}

func (x Build_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Build_Status.Descriptor instead.
func (Build_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{10, 0}
}

// Specifies the hash algorithm, if any.
type Hash_HashType int32

const (
	// No hash requested.
	Hash_NONE Hash_HashType = 0
	// Use a sha256 hash.
	Hash_SHA256 Hash_HashType = 1
	// Use a md5 hash.
	Hash_MD5 Hash_HashType = 2
)

// Enum value maps for Hash_HashType.
var (
	Hash_HashType_name = map[int32]string{
		0: "NONE",
		1: "SHA256",
		2: "MD5",
	}
	Hash_HashType_value = map[string]int32{
		"NONE":   0,
		"SHA256": 1,
		"MD5":    2,
	}
)

func (x Hash_HashType) Enum() *Hash_HashType {
	p := new(Hash_HashType)
	*p = x
	return p
}

func (x Hash_HashType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Hash_HashType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_enumTypes[1].Descriptor()
}

func (Hash_HashType) Type() protoreflect.EnumType {
	return &file_google_devtools_cloudbuild_v1_cloudbuild_proto_enumTypes[1]
}

func (x Hash_HashType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Hash_HashType.Descriptor instead.
func (Hash_HashType) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{16, 0}
}

// Controls behavior of Pull Request comments.
type PullRequestFilter_CommentControl int32

const (
	// Do not require comments on Pull Requests before builds are triggered.
	PullRequestFilter_COMMENTS_DISABLED PullRequestFilter_CommentControl = 0
	// Enforce that repository owners or collaborators must comment on Pull
	// Requests before builds are triggered.
	PullRequestFilter_COMMENTS_ENABLED PullRequestFilter_CommentControl = 1
)

// Enum value maps for PullRequestFilter_CommentControl.
var (
	PullRequestFilter_CommentControl_name = map[int32]string{
		0: "COMMENTS_DISABLED",
		1: "COMMENTS_ENABLED",
	}
	PullRequestFilter_CommentControl_value = map[string]int32{
		"COMMENTS_DISABLED": 0,
		"COMMENTS_ENABLED":  1,
	}
)

func (x PullRequestFilter_CommentControl) Enum() *PullRequestFilter_CommentControl {
	p := new(PullRequestFilter_CommentControl)
	*p = x
	return p
}

func (x PullRequestFilter_CommentControl) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PullRequestFilter_CommentControl) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_enumTypes[2].Descriptor()
}

func (PullRequestFilter_CommentControl) Type() protoreflect.EnumType {
	return &file_google_devtools_cloudbuild_v1_cloudbuild_proto_enumTypes[2]
}

func (x PullRequestFilter_CommentControl) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PullRequestFilter_CommentControl.Descriptor instead.
func (PullRequestFilter_CommentControl) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{25, 0}
}

// Specifies the manner in which the build should be verified, if at all.
type BuildOptions_VerifyOption int32

const (
	// Not a verifiable build. (default)
	BuildOptions_NOT_VERIFIED BuildOptions_VerifyOption = 0
	// Verified build.
	BuildOptions_VERIFIED BuildOptions_VerifyOption = 1
)

// Enum value maps for BuildOptions_VerifyOption.
var (
	BuildOptions_VerifyOption_name = map[int32]string{
		0: "NOT_VERIFIED",
		1: "VERIFIED",
	}
	BuildOptions_VerifyOption_value = map[string]int32{
		"NOT_VERIFIED": 0,
		"VERIFIED":     1,
	}
)

func (x BuildOptions_VerifyOption) Enum() *BuildOptions_VerifyOption {
	p := new(BuildOptions_VerifyOption)
	*p = x
	return p
}

func (x BuildOptions_VerifyOption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BuildOptions_VerifyOption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_enumTypes[3].Descriptor()
}

func (BuildOptions_VerifyOption) Type() protoreflect.EnumType {
	return &file_google_devtools_cloudbuild_v1_cloudbuild_proto_enumTypes[3]
}

func (x BuildOptions_VerifyOption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BuildOptions_VerifyOption.Descriptor instead.
func (BuildOptions_VerifyOption) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{33, 0}
}

// Supported VM sizes.
type BuildOptions_MachineType int32

const (
	// Standard machine type.
	BuildOptions_UNSPECIFIED BuildOptions_MachineType = 0
	// Highcpu machine with 8 CPUs.
	BuildOptions_N1_HIGHCPU_8 BuildOptions_MachineType = 1
	// Highcpu machine with 32 CPUs.
	BuildOptions_N1_HIGHCPU_32 BuildOptions_MachineType = 2
)

// Enum value maps for BuildOptions_MachineType.
var (
	BuildOptions_MachineType_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "N1_HIGHCPU_8",
		2: "N1_HIGHCPU_32",
	}
	BuildOptions_MachineType_value = map[string]int32{
		"UNSPECIFIED":   0,
		"N1_HIGHCPU_8":  1,
		"N1_HIGHCPU_32": 2,
	}
)

func (x BuildOptions_MachineType) Enum() *BuildOptions_MachineType {
	p := new(BuildOptions_MachineType)
	*p = x
	return p
}

func (x BuildOptions_MachineType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BuildOptions_MachineType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_enumTypes[4].Descriptor()
}

func (BuildOptions_MachineType) Type() protoreflect.EnumType {
	return &file_google_devtools_cloudbuild_v1_cloudbuild_proto_enumTypes[4]
}

func (x BuildOptions_MachineType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BuildOptions_MachineType.Descriptor instead.
func (BuildOptions_MachineType) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{33, 1}
}

// Specifies the behavior when there is an error in the substitution checks.
type BuildOptions_SubstitutionOption int32

const (
	// Fails the build if error in substitutions checks, like missing
	// a substitution in the template or in the map.
	BuildOptions_MUST_MATCH BuildOptions_SubstitutionOption = 0
	// Do not fail the build if error in substitutions checks.
	BuildOptions_ALLOW_LOOSE BuildOptions_SubstitutionOption = 1
)

// Enum value maps for BuildOptions_SubstitutionOption.
var (
	BuildOptions_SubstitutionOption_name = map[int32]string{
		0: "MUST_MATCH",
		1: "ALLOW_LOOSE",
	}
	BuildOptions_SubstitutionOption_value = map[string]int32{
		"MUST_MATCH":  0,
		"ALLOW_LOOSE": 1,
	}
)

func (x BuildOptions_SubstitutionOption) Enum() *BuildOptions_SubstitutionOption {
	p := new(BuildOptions_SubstitutionOption)
	*p = x
	return p
}

func (x BuildOptions_SubstitutionOption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BuildOptions_SubstitutionOption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_enumTypes[5].Descriptor()
}

func (BuildOptions_SubstitutionOption) Type() protoreflect.EnumType {
	return &file_google_devtools_cloudbuild_v1_cloudbuild_proto_enumTypes[5]
}

func (x BuildOptions_SubstitutionOption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BuildOptions_SubstitutionOption.Descriptor instead.
func (BuildOptions_SubstitutionOption) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{33, 2}
}

// Specifies the behavior when writing build logs to Google Cloud Storage.
type BuildOptions_LogStreamingOption int32

const (
	// Service may automatically determine build log streaming behavior.
	BuildOptions_STREAM_DEFAULT BuildOptions_LogStreamingOption = 0
	// Build logs should be streamed to Google Cloud Storage.
	BuildOptions_STREAM_ON BuildOptions_LogStreamingOption = 1
	// Build logs should not be streamed to Google Cloud Storage; they will be
	// written when the build is completed.
	BuildOptions_STREAM_OFF BuildOptions_LogStreamingOption = 2
)

// Enum value maps for BuildOptions_LogStreamingOption.
var (
	BuildOptions_LogStreamingOption_name = map[int32]string{
		0: "STREAM_DEFAULT",
		1: "STREAM_ON",
		2: "STREAM_OFF",
	}
	BuildOptions_LogStreamingOption_value = map[string]int32{
		"STREAM_DEFAULT": 0,
		"STREAM_ON":      1,
		"STREAM_OFF":     2,
	}
)

func (x BuildOptions_LogStreamingOption) Enum() *BuildOptions_LogStreamingOption {
	p := new(BuildOptions_LogStreamingOption)
	*p = x
	return p
}

func (x BuildOptions_LogStreamingOption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BuildOptions_LogStreamingOption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_enumTypes[6].Descriptor()
}

func (BuildOptions_LogStreamingOption) Type() protoreflect.EnumType {
	return &file_google_devtools_cloudbuild_v1_cloudbuild_proto_enumTypes[6]
}

func (x BuildOptions_LogStreamingOption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BuildOptions_LogStreamingOption.Descriptor instead.
func (BuildOptions_LogStreamingOption) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{33, 3}
}

// Specifies the logging mode.
type BuildOptions_LoggingMode int32

const (
	// The service determines the logging mode. The default is `LEGACY`. Do not
	// rely on the default logging behavior as it may change in the future.
	BuildOptions_LOGGING_UNSPECIFIED BuildOptions_LoggingMode = 0
	// Stackdriver logging and Cloud Storage logging are enabled.
	BuildOptions_LEGACY BuildOptions_LoggingMode = 1
	// Only Cloud Storage logging is enabled.
	BuildOptions_GCS_ONLY BuildOptions_LoggingMode = 2
)

// Enum value maps for BuildOptions_LoggingMode.
var (
	BuildOptions_LoggingMode_name = map[int32]string{
		0: "LOGGING_UNSPECIFIED",
		1: "LEGACY",
		2: "GCS_ONLY",
	}
	BuildOptions_LoggingMode_value = map[string]int32{
		"LOGGING_UNSPECIFIED": 0,
		"LEGACY":              1,
		"GCS_ONLY":            2,
	}
)

func (x BuildOptions_LoggingMode) Enum() *BuildOptions_LoggingMode {
	p := new(BuildOptions_LoggingMode)
	*p = x
	return p
}

func (x BuildOptions_LoggingMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BuildOptions_LoggingMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_enumTypes[7].Descriptor()
}

func (BuildOptions_LoggingMode) Type() protoreflect.EnumType {
	return &file_google_devtools_cloudbuild_v1_cloudbuild_proto_enumTypes[7]
}

func (x BuildOptions_LoggingMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BuildOptions_LoggingMode.Descriptor instead.
func (BuildOptions_LoggingMode) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{33, 4}
}

// Supported GCP regions to create the `WorkerPool`.
type WorkerPool_Region int32

const (
	// no region
	WorkerPool_REGION_UNSPECIFIED WorkerPool_Region = 0
	// us-central1 region
	WorkerPool_US_CENTRAL1 WorkerPool_Region = 1
	// us-west1 region
	WorkerPool_US_WEST1 WorkerPool_Region = 2
	// us-east1 region
	WorkerPool_US_EAST1 WorkerPool_Region = 3
	// us-east4 region
	WorkerPool_US_EAST4 WorkerPool_Region = 4
)

// Enum value maps for WorkerPool_Region.
var (
	WorkerPool_Region_name = map[int32]string{
		0: "REGION_UNSPECIFIED",
		1: "US_CENTRAL1",
		2: "US_WEST1",
		3: "US_EAST1",
		4: "US_EAST4",
	}
	WorkerPool_Region_value = map[string]int32{
		"REGION_UNSPECIFIED": 0,
		"US_CENTRAL1":        1,
		"US_WEST1":           2,
		"US_EAST1":           3,
		"US_EAST4":           4,
	}
)

func (x WorkerPool_Region) Enum() *WorkerPool_Region {
	p := new(WorkerPool_Region)
	*p = x
	return p
}

func (x WorkerPool_Region) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WorkerPool_Region) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_enumTypes[8].Descriptor()
}

func (WorkerPool_Region) Type() protoreflect.EnumType {
	return &file_google_devtools_cloudbuild_v1_cloudbuild_proto_enumTypes[8]
}

func (x WorkerPool_Region) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WorkerPool_Region.Descriptor instead.
func (WorkerPool_Region) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{34, 0}
}

// `WorkerPool` status
type WorkerPool_Status int32

const (
	// Status of the `WorkerPool` is unknown.
	WorkerPool_STATUS_UNSPECIFIED WorkerPool_Status = 0
	// `WorkerPool` is being created.
	WorkerPool_CREATING WorkerPool_Status = 1
	// `WorkerPool` is running.
	WorkerPool_RUNNING WorkerPool_Status = 2
	// `WorkerPool` is being deleted: cancelling builds and draining workers.
	WorkerPool_DELETING WorkerPool_Status = 3
	// `WorkerPool` is deleted.
	WorkerPool_DELETED WorkerPool_Status = 4
)

// Enum value maps for WorkerPool_Status.
var (
	WorkerPool_Status_name = map[int32]string{
		0: "STATUS_UNSPECIFIED",
		1: "CREATING",
		2: "RUNNING",
		3: "DELETING",
		4: "DELETED",
	}
	WorkerPool_Status_value = map[string]int32{
		"STATUS_UNSPECIFIED": 0,
		"CREATING":           1,
		"RUNNING":            2,
		"DELETING":           3,
		"DELETED":            4,
	}
)

func (x WorkerPool_Status) Enum() *WorkerPool_Status {
	p := new(WorkerPool_Status)
	*p = x
	return p
}

func (x WorkerPool_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WorkerPool_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_enumTypes[9].Descriptor()
}

func (WorkerPool_Status) Type() protoreflect.EnumType {
	return &file_google_devtools_cloudbuild_v1_cloudbuild_proto_enumTypes[9]
}

func (x WorkerPool_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WorkerPool_Status.Descriptor instead.
func (WorkerPool_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{34, 1}
}

// Specifies a build to retry.
type RetryBuildRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. ID of the project.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Build ID of the original build.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *RetryBuildRequest) Reset() {
	*x = RetryBuildRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RetryBuildRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetryBuildRequest) ProtoMessage() {}

func (x *RetryBuildRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetryBuildRequest.ProtoReflect.Descriptor instead.
func (*RetryBuildRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{0}
}

func (x *RetryBuildRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *RetryBuildRequest) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

// Specifies a build trigger to run and the source to use.
type RunBuildTriggerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. ID of the project.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. ID of the trigger.
	TriggerId string `protobuf:"bytes,2,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
	// Required. Source to build against this trigger.
	Source *RepoSource `protobuf:"bytes,3,opt,name=source,proto3" json:"source,omitempty"`
}

func (x *RunBuildTriggerRequest) Reset() {
	*x = RunBuildTriggerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunBuildTriggerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunBuildTriggerRequest) ProtoMessage() {}

func (x *RunBuildTriggerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunBuildTriggerRequest.ProtoReflect.Descriptor instead.
func (*RunBuildTriggerRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{1}
}

func (x *RunBuildTriggerRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *RunBuildTriggerRequest) GetTriggerId() string {
	if x != nil {
		return x.TriggerId
	}
	return ""
}

func (x *RunBuildTriggerRequest) GetSource() *RepoSource {
	if x != nil {
		return x.Source
	}
	return nil
}

// Location of the source in an archive file in Google Cloud Storage.
type StorageSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Google Cloud Storage bucket containing the source (see
	// [Bucket Name
	// Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Google Cloud Storage object containing the source.
	//
	// This object must be a gzipped archive file (`.tar.gz`) containing source to
	// build.
	Object string `protobuf:"bytes,2,opt,name=object,proto3" json:"object,omitempty"`
	// Google Cloud Storage generation for the object. If the generation is
	// omitted, the latest generation will be used.
	Generation int64 `protobuf:"varint,3,opt,name=generation,proto3" json:"generation,omitempty"`
}

func (x *StorageSource) Reset() {
	*x = StorageSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StorageSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StorageSource) ProtoMessage() {}

func (x *StorageSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StorageSource.ProtoReflect.Descriptor instead.
func (*StorageSource) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{2}
}

func (x *StorageSource) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *StorageSource) GetObject() string {
	if x != nil {
		return x.Object
	}
	return ""
}

func (x *StorageSource) GetGeneration() int64 {
	if x != nil {
		return x.Generation
	}
	return 0
}

// Location of the source in a Google Cloud Source Repository.
type RepoSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the project that owns the Cloud Source Repository. If omitted, the
	// project ID requesting the build is assumed.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Name of the Cloud Source Repository.
	RepoName string `protobuf:"bytes,2,opt,name=repo_name,json=repoName,proto3" json:"repo_name,omitempty"`
	// A revision within the Cloud Source Repository must be specified in
	// one of these ways.
	//
	// Types that are assignable to Revision:
	//	*RepoSource_BranchName
	//	*RepoSource_TagName
	//	*RepoSource_CommitSha
	Revision isRepoSource_Revision `protobuf_oneof:"revision"`
	// Directory, relative to the source root, in which to run the build.
	//
	// This must be a relative path. If a step's `dir` is specified and is an
	// absolute path, this value is ignored for that step's execution.
	Dir string `protobuf:"bytes,7,opt,name=dir,proto3" json:"dir,omitempty"`
	// Only trigger a build if the revision regex does NOT match the revision
	// regex.
	InvertRegex bool `protobuf:"varint,8,opt,name=invert_regex,json=invertRegex,proto3" json:"invert_regex,omitempty"`
	// Substitutions to use in a triggered build.
	// Should only be used with RunBuildTrigger
	Substitutions map[string]string `protobuf:"bytes,9,rep,name=substitutions,proto3" json:"substitutions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *RepoSource) Reset() {
	*x = RepoSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RepoSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RepoSource) ProtoMessage() {}

func (x *RepoSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RepoSource.ProtoReflect.Descriptor instead.
func (*RepoSource) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{3}
}

func (x *RepoSource) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *RepoSource) GetRepoName() string {
	if x != nil {
		return x.RepoName
	}
	return ""
}

func (m *RepoSource) GetRevision() isRepoSource_Revision {
	if m != nil {
		return m.Revision
	}
	return nil
}

func (x *RepoSource) GetBranchName() string {
	if x, ok := x.GetRevision().(*RepoSource_BranchName); ok {
		return x.BranchName
	}
	return ""
}

func (x *RepoSource) GetTagName() string {
	if x, ok := x.GetRevision().(*RepoSource_TagName); ok {
		return x.TagName
	}
	return ""
}

func (x *RepoSource) GetCommitSha() string {
	if x, ok := x.GetRevision().(*RepoSource_CommitSha); ok {
		return x.CommitSha
	}
	return ""
}

func (x *RepoSource) GetDir() string {
	if x != nil {
		return x.Dir
	}
	return ""
}

func (x *RepoSource) GetInvertRegex() bool {
	if x != nil {
		return x.InvertRegex
	}
	return false
}

func (x *RepoSource) GetSubstitutions() map[string]string {
	if x != nil {
		return x.Substitutions
	}
	return nil
}

type isRepoSource_Revision interface {
	isRepoSource_Revision()
}

type RepoSource_BranchName struct {
	// Regex matching branches to build.
	//
	// The syntax of the regular expressions accepted is the syntax accepted by
	// RE2 and described at https://github.com/google/re2/wiki/Syntax
	BranchName string `protobuf:"bytes,3,opt,name=branch_name,json=branchName,proto3,oneof"`
}

type RepoSource_TagName struct {
	// Regex matching tags to build.
	//
	// The syntax of the regular expressions accepted is the syntax accepted by
	// RE2 and described at https://github.com/google/re2/wiki/Syntax
	TagName string `protobuf:"bytes,4,opt,name=tag_name,json=tagName,proto3,oneof"`
}

type RepoSource_CommitSha struct {
	// Explicit commit SHA to build.
	CommitSha string `protobuf:"bytes,5,opt,name=commit_sha,json=commitSha,proto3,oneof"`
}

func (*RepoSource_BranchName) isRepoSource_Revision() {}

func (*RepoSource_TagName) isRepoSource_Revision() {}

func (*RepoSource_CommitSha) isRepoSource_Revision() {}

// Location of the source in a supported storage service.
type Source struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Location of source.
	//
	// Types that are assignable to Source:
	//	*Source_StorageSource
	//	*Source_RepoSource
	Source isSource_Source `protobuf_oneof:"source"`
}

func (x *Source) Reset() {
	*x = Source{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Source) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Source) ProtoMessage() {}

func (x *Source) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Source.ProtoReflect.Descriptor instead.
func (*Source) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{4}
}

func (m *Source) GetSource() isSource_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *Source) GetStorageSource() *StorageSource {
	if x, ok := x.GetSource().(*Source_StorageSource); ok {
		return x.StorageSource
	}
	return nil
}

func (x *Source) GetRepoSource() *RepoSource {
	if x, ok := x.GetSource().(*Source_RepoSource); ok {
		return x.RepoSource
	}
	return nil
}

type isSource_Source interface {
	isSource_Source()
}

type Source_StorageSource struct {
	// If provided, get the source from this location in Google Cloud Storage.
	StorageSource *StorageSource `protobuf:"bytes,2,opt,name=storage_source,json=storageSource,proto3,oneof"`
}

type Source_RepoSource struct {
	// If provided, get the source from this location in a Cloud Source
	// Repository.
	RepoSource *RepoSource `protobuf:"bytes,3,opt,name=repo_source,json=repoSource,proto3,oneof"`
}

func (*Source_StorageSource) isSource_Source() {}

func (*Source_RepoSource) isSource_Source() {}

// An image built by the pipeline.
type BuiltImage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name used to push the container image to Google Container Registry, as
	// presented to `docker push`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Docker Registry 2.0 digest.
	Digest string `protobuf:"bytes,3,opt,name=digest,proto3" json:"digest,omitempty"`
	// Output only. Stores timing information for pushing the specified image.
	PushTiming *TimeSpan `protobuf:"bytes,4,opt,name=push_timing,json=pushTiming,proto3" json:"push_timing,omitempty"`
}

func (x *BuiltImage) Reset() {
	*x = BuiltImage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BuiltImage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BuiltImage) ProtoMessage() {}

func (x *BuiltImage) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BuiltImage.ProtoReflect.Descriptor instead.
func (*BuiltImage) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{5}
}

func (x *BuiltImage) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *BuiltImage) GetDigest() string {
	if x != nil {
		return x.Digest
	}
	return ""
}

func (x *BuiltImage) GetPushTiming() *TimeSpan {
	if x != nil {
		return x.PushTiming
	}
	return nil
}

// A step in the build pipeline.
type BuildStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the container image that will run this particular
	// build step.
	//
	// If the image is available in the host's Docker daemon's cache, it
	// will be run directly. If not, the host will attempt to pull the image
	// first, using the builder service account's credentials if necessary.
	//
	// The Docker daemon's cache will already have the latest versions of all of
	// the officially supported build steps
	// ([https://github.com/GoogleCloudPlatform/cloud-builders](https://github.com/GoogleCloudPlatform/cloud-builders)).
	// The Docker daemon will also have cached many of the layers for some popular
	// images, like "ubuntu", "debian", but they will be refreshed at the time you
	// attempt to use them.
	//
	// If you built an image in a previous build step, it will be stored in the
	// host's Docker daemon's cache and is available to use as the name for a
	// later build step.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A list of environment variable definitions to be used when running a step.
	//
	// The elements are of the form "KEY=VALUE" for the environment variable "KEY"
	// being given the value "VALUE".
	Env []string `protobuf:"bytes,2,rep,name=env,proto3" json:"env,omitempty"`
	// A list of arguments that will be presented to the step when it is started.
	//
	// If the image used to run the step's container has an entrypoint, the `args`
	// are used as arguments to that entrypoint. If the image does not define
	// an entrypoint, the first element in args is used as the entrypoint,
	// and the remainder will be used as arguments.
	Args []string `protobuf:"bytes,3,rep,name=args,proto3" json:"args,omitempty"`
	// Working directory to use when running this step's container.
	//
	// If this value is a relative path, it is relative to the build's working
	// directory. If this value is absolute, it may be outside the build's working
	// directory, in which case the contents of the path may not be persisted
	// across build step executions, unless a `volume` for that path is specified.
	//
	// If the build specifies a `RepoSource` with `dir` and a step with a `dir`,
	// which specifies an absolute path, the `RepoSource` `dir` is ignored for
	// the step's execution.
	Dir string `protobuf:"bytes,4,opt,name=dir,proto3" json:"dir,omitempty"`
	// Unique identifier for this build step, used in `wait_for` to
	// reference this build step as a dependency.
	Id string `protobuf:"bytes,5,opt,name=id,proto3" json:"id,omitempty"`
	// The ID(s) of the step(s) that this build step depends on.
	// This build step will not start until all the build steps in `wait_for`
	// have completed successfully. If `wait_for` is empty, this build step will
	// start when all previous build steps in the `Build.Steps` list have
	// completed successfully.
	WaitFor []string `protobuf:"bytes,6,rep,name=wait_for,json=waitFor,proto3" json:"wait_for,omitempty"`
	// Entrypoint to be used instead of the build step image's default entrypoint.
	// If unset, the image's default entrypoint is used.
	Entrypoint string `protobuf:"bytes,7,opt,name=entrypoint,proto3" json:"entrypoint,omitempty"`
	// A list of environment variables which are encrypted using a Cloud Key
	// Management Service crypto key. These values must be specified in the
	// build's `Secret`.
	SecretEnv []string `protobuf:"bytes,8,rep,name=secret_env,json=secretEnv,proto3" json:"secret_env,omitempty"`
	// List of volumes to mount into the build step.
	//
	// Each volume is created as an empty volume prior to execution of the
	// build step. Upon completion of the build, volumes and their contents are
	// discarded.
	//
	// Using a named volume in only one step is not valid as it is indicative
	// of a build request with an incorrect configuration.
	Volumes []*Volume `protobuf:"bytes,9,rep,name=volumes,proto3" json:"volumes,omitempty"`
	// Output only. Stores timing information for executing this build step.
	Timing *TimeSpan `protobuf:"bytes,10,opt,name=timing,proto3" json:"timing,omitempty"`
	// Output only. Stores timing information for pulling this build step's
	// builder image only.
	PullTiming *TimeSpan `protobuf:"bytes,13,opt,name=pull_timing,json=pullTiming,proto3" json:"pull_timing,omitempty"`
	// Time limit for executing this build step. If not defined, the step has no
	// time limit and will be allowed to continue to run until either it completes
	// or the build itself times out.
	Timeout *duration.Duration `protobuf:"bytes,11,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// Output only. Status of the build step. At this time, build step status is
	// only updated on build completion; step status is not updated in real-time
	// as the build progresses.
	Status Build_Status `protobuf:"varint,12,opt,name=status,proto3,enum=google.devtools.cloudbuild.v1.Build_Status" json:"status,omitempty"`
}

func (x *BuildStep) Reset() {
	*x = BuildStep{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BuildStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BuildStep) ProtoMessage() {}

func (x *BuildStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BuildStep.ProtoReflect.Descriptor instead.
func (*BuildStep) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{6}
}

func (x *BuildStep) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *BuildStep) GetEnv() []string {
	if x != nil {
		return x.Env
	}
	return nil
}

func (x *BuildStep) GetArgs() []string {
	if x != nil {
		return x.Args
	}
	return nil
}

func (x *BuildStep) GetDir() string {
	if x != nil {
		return x.Dir
	}
	return ""
}

func (x *BuildStep) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *BuildStep) GetWaitFor() []string {
	if x != nil {
		return x.WaitFor
	}
	return nil
}

func (x *BuildStep) GetEntrypoint() string {
	if x != nil {
		return x.Entrypoint
	}
	return ""
}

func (x *BuildStep) GetSecretEnv() []string {
	if x != nil {
		return x.SecretEnv
	}
	return nil
}

func (x *BuildStep) GetVolumes() []*Volume {
	if x != nil {
		return x.Volumes
	}
	return nil
}

func (x *BuildStep) GetTiming() *TimeSpan {
	if x != nil {
		return x.Timing
	}
	return nil
}

func (x *BuildStep) GetPullTiming() *TimeSpan {
	if x != nil {
		return x.PullTiming
	}
	return nil
}

func (x *BuildStep) GetTimeout() *duration.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

func (x *BuildStep) GetStatus() Build_Status {
	if x != nil {
		return x.Status
	}
	return Build_STATUS_UNKNOWN
}

// Volume describes a Docker container volume which is mounted into build steps
// in order to persist files across build step execution.
type Volume struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the volume to mount.
	//
	// Volume names must be unique per build step and must be valid names for
	// Docker volumes. Each named volume must be used by at least two build steps.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Path at which to mount the volume.
	//
	// Paths must be absolute and cannot conflict with other volume paths on the
	// same build step or with certain reserved volume paths.
	Path string `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
}

func (x *Volume) Reset() {
	*x = Volume{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Volume) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Volume) ProtoMessage() {}

func (x *Volume) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Volume.ProtoReflect.Descriptor instead.
func (*Volume) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{7}
}

func (x *Volume) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Volume) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

// Artifacts created by the build pipeline.
type Results struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Container images that were built as a part of the build.
	Images []*BuiltImage `protobuf:"bytes,2,rep,name=images,proto3" json:"images,omitempty"`
	// List of build step digests, in the order corresponding to build step
	// indices.
	BuildStepImages []string `protobuf:"bytes,3,rep,name=build_step_images,json=buildStepImages,proto3" json:"build_step_images,omitempty"`
	// Path to the artifact manifest. Only populated when artifacts are uploaded.
	ArtifactManifest string `protobuf:"bytes,4,opt,name=artifact_manifest,json=artifactManifest,proto3" json:"artifact_manifest,omitempty"`
	// Number of artifacts uploaded. Only populated when artifacts are uploaded.
	NumArtifacts int64 `protobuf:"varint,5,opt,name=num_artifacts,json=numArtifacts,proto3" json:"num_artifacts,omitempty"`
	// List of build step outputs, produced by builder images, in the order
	// corresponding to build step indices.
	//
	// [Cloud Builders](https://cloud.google.com/cloud-build/docs/cloud-builders)
	// can produce this output by writing to `$BUILDER_OUTPUT/output`.
	// Only the first 4KB of data is stored.
	BuildStepOutputs [][]byte `protobuf:"bytes,6,rep,name=build_step_outputs,json=buildStepOutputs,proto3" json:"build_step_outputs,omitempty"`
	// Time to push all non-container artifacts.
	ArtifactTiming *TimeSpan `protobuf:"bytes,7,opt,name=artifact_timing,json=artifactTiming,proto3" json:"artifact_timing,omitempty"`
}

func (x *Results) Reset() {
	*x = Results{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Results) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Results) ProtoMessage() {}

func (x *Results) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Results.ProtoReflect.Descriptor instead.
func (*Results) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{8}
}

func (x *Results) GetImages() []*BuiltImage {
	if x != nil {
		return x.Images
	}
	return nil
}

func (x *Results) GetBuildStepImages() []string {
	if x != nil {
		return x.BuildStepImages
	}
	return nil
}

func (x *Results) GetArtifactManifest() string {
	if x != nil {
		return x.ArtifactManifest
	}
	return ""
}

func (x *Results) GetNumArtifacts() int64 {
	if x != nil {
		return x.NumArtifacts
	}
	return 0
}

func (x *Results) GetBuildStepOutputs() [][]byte {
	if x != nil {
		return x.BuildStepOutputs
	}
	return nil
}

func (x *Results) GetArtifactTiming() *TimeSpan {
	if x != nil {
		return x.ArtifactTiming
	}
	return nil
}

// An artifact that was uploaded during a build. This
// is a single record in the artifact manifest JSON file.
type ArtifactResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The path of an artifact in a Google Cloud Storage bucket, with the
	// generation number. For example,
	// `gs://mybucket/path/to/output.jar#generation`.
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// The file hash of the artifact.
	FileHash []*FileHashes `protobuf:"bytes,2,rep,name=file_hash,json=fileHash,proto3" json:"file_hash,omitempty"`
}

func (x *ArtifactResult) Reset() {
	*x = ArtifactResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArtifactResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArtifactResult) ProtoMessage() {}

func (x *ArtifactResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArtifactResult.ProtoReflect.Descriptor instead.
func (*ArtifactResult) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{9}
}

func (x *ArtifactResult) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *ArtifactResult) GetFileHash() []*FileHashes {
	if x != nil {
		return x.FileHash
	}
	return nil
}

// A build resource in the Cloud Build API.
//
// At a high level, a `Build` describes where to find source code, how to build
// it (for example, the builder image to run on the source), and where to store
// the built artifacts.
//
// Fields can include the following variables, which will be expanded when the
// build is created:
//
// - $PROJECT_ID: the project ID of the build.
// - $BUILD_ID: the autogenerated ID of the build.
// - $REPO_NAME: the source repository name specified by RepoSource.
// - $BRANCH_NAME: the branch name specified by RepoSource.
// - $TAG_NAME: the tag name specified by RepoSource.
// - $REVISION_ID or $COMMIT_SHA: the commit SHA specified by RepoSource or
//   resolved from the specified branch or tag.
// - $SHORT_SHA: first 7 characters of $REVISION_ID or $COMMIT_SHA.
type Build struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Unique identifier of the build.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Output only. ID of the project.
	ProjectId string `protobuf:"bytes,16,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Output only. Status of the build.
	Status Build_Status `protobuf:"varint,2,opt,name=status,proto3,enum=google.devtools.cloudbuild.v1.Build_Status" json:"status,omitempty"`
	// Output only. Customer-readable message about the current status.
	StatusDetail string `protobuf:"bytes,24,opt,name=status_detail,json=statusDetail,proto3" json:"status_detail,omitempty"`
	// The location of the source files to build.
	Source *Source `protobuf:"bytes,3,opt,name=source,proto3" json:"source,omitempty"`
	// Required. The operations to be performed on the workspace.
	Steps []*BuildStep `protobuf:"bytes,11,rep,name=steps,proto3" json:"steps,omitempty"`
	// Output only. Results of the build.
	Results *Results `protobuf:"bytes,10,opt,name=results,proto3" json:"results,omitempty"`
	// Output only. Time at which the request to create the build was received.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time at which execution of the build was started.
	StartTime *timestamp.Timestamp `protobuf:"bytes,7,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. Time at which execution of the build was finished.
	//
	// The difference between finish_time and start_time is the duration of the
	// build's execution.
	FinishTime *timestamp.Timestamp `protobuf:"bytes,8,opt,name=finish_time,json=finishTime,proto3" json:"finish_time,omitempty"`
	// Amount of time that this build should be allowed to run, to second
	// granularity. If this amount of time elapses, work on the build will cease
	// and the build status will be `TIMEOUT`.
	//
	// Default time is ten minutes.
	Timeout *duration.Duration `protobuf:"bytes,12,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// A list of images to be pushed upon the successful completion of all build
	// steps.
	//
	// The images are pushed using the builder service account's credentials.
	//
	// The digests of the pushed images will be stored in the `Build` resource's
	// results field.
	//
	// If any of the images fail to be pushed, the build status is marked
	// `FAILURE`.
	Images []string `protobuf:"bytes,13,rep,name=images,proto3" json:"images,omitempty"`
	// TTL in queue for this build. If provided and the build is enqueued longer
	// than this value, the build will expire and the build status will be
	// `EXPIRED`.
	//
	// The TTL starts ticking from create_time.
	QueueTtl *duration.Duration `protobuf:"bytes,40,opt,name=queue_ttl,json=queueTtl,proto3" json:"queue_ttl,omitempty"`
	// Artifacts produced by the build that should be uploaded upon
	// successful completion of all build steps.
	Artifacts *Artifacts `protobuf:"bytes,37,opt,name=artifacts,proto3" json:"artifacts,omitempty"`
	// Google Cloud Storage bucket where logs should be written (see
	// [Bucket Name
	// Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
	// Logs file names will be of the format `${logs_bucket}/log-${build_id}.txt`.
	LogsBucket string `protobuf:"bytes,19,opt,name=logs_bucket,json=logsBucket,proto3" json:"logs_bucket,omitempty"`
	// Output only. A permanent fixed identifier for source.
	SourceProvenance *SourceProvenance `protobuf:"bytes,21,opt,name=source_provenance,json=sourceProvenance,proto3" json:"source_provenance,omitempty"`
	// Output only. The ID of the `BuildTrigger` that triggered this build, if it
	// was triggered automatically.
	BuildTriggerId string `protobuf:"bytes,22,opt,name=build_trigger_id,json=buildTriggerId,proto3" json:"build_trigger_id,omitempty"`
	// Special options for this build.
	Options *BuildOptions `protobuf:"bytes,23,opt,name=options,proto3" json:"options,omitempty"`
	// Output only. URL to logs for this build in Google Cloud Console.
	LogUrl string `protobuf:"bytes,25,opt,name=log_url,json=logUrl,proto3" json:"log_url,omitempty"`
	// Substitutions data for `Build` resource.
	Substitutions map[string]string `protobuf:"bytes,29,rep,name=substitutions,proto3" json:"substitutions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Tags for annotation of a `Build`. These are not docker tags.
	Tags []string `protobuf:"bytes,31,rep,name=tags,proto3" json:"tags,omitempty"`
	// Secrets to decrypt using Cloud Key Management Service.
	Secrets []*Secret `protobuf:"bytes,32,rep,name=secrets,proto3" json:"secrets,omitempty"`
	// Output only. Stores timing information for phases of the build. Valid keys
	// are:
	//
	// * BUILD: time to execute all build steps
	// * PUSH: time to push all specified images.
	// * FETCHSOURCE: time to fetch source.
	//
	// If the build does not specify source or images,
	// these keys will not be included.
	Timing map[string]*TimeSpan `protobuf:"bytes,33,rep,name=timing,proto3" json:"timing,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Build) Reset() {
	*x = Build{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Build) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Build) ProtoMessage() {}

func (x *Build) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Build.ProtoReflect.Descriptor instead.
func (*Build) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{10}
}

func (x *Build) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Build) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *Build) GetStatus() Build_Status {
	if x != nil {
		return x.Status
	}
	return Build_STATUS_UNKNOWN
}

func (x *Build) GetStatusDetail() string {
	if x != nil {
		return x.StatusDetail
	}
	return ""
}

func (x *Build) GetSource() *Source {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *Build) GetSteps() []*BuildStep {
	if x != nil {
		return x.Steps
	}
	return nil
}

func (x *Build) GetResults() *Results {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *Build) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Build) GetStartTime() *timestamp.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Build) GetFinishTime() *timestamp.Timestamp {
	if x != nil {
		return x.FinishTime
	}
	return nil
}

func (x *Build) GetTimeout() *duration.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

func (x *Build) GetImages() []string {
	if x != nil {
		return x.Images
	}
	return nil
}

func (x *Build) GetQueueTtl() *duration.Duration {
	if x != nil {
		return x.QueueTtl
	}
	return nil
}

func (x *Build) GetArtifacts() *Artifacts {
	if x != nil {
		return x.Artifacts
	}
	return nil
}

func (x *Build) GetLogsBucket() string {
	if x != nil {
		return x.LogsBucket
	}
	return ""
}

func (x *Build) GetSourceProvenance() *SourceProvenance {
	if x != nil {
		return x.SourceProvenance
	}
	return nil
}

func (x *Build) GetBuildTriggerId() string {
	if x != nil {
		return x.BuildTriggerId
	}
	return ""
}

func (x *Build) GetOptions() *BuildOptions {
	if x != nil {
		return x.Options
	}
	return nil
}

func (x *Build) GetLogUrl() string {
	if x != nil {
		return x.LogUrl
	}
	return ""
}

func (x *Build) GetSubstitutions() map[string]string {
	if x != nil {
		return x.Substitutions
	}
	return nil
}

func (x *Build) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *Build) GetSecrets() []*Secret {
	if x != nil {
		return x.Secrets
	}
	return nil
}

func (x *Build) GetTiming() map[string]*TimeSpan {
	if x != nil {
		return x.Timing
	}
	return nil
}

// Artifacts produced by a build that should be uploaded upon
// successful completion of all build steps.
type Artifacts struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of images to be pushed upon the successful completion of all build
	// steps.
	//
	// The images will be pushed using the builder service account's credentials.
	//
	// The digests of the pushed images will be stored in the Build resource's
	// results field.
	//
	// If any of the images fail to be pushed, the build is marked FAILURE.
	Images []string `protobuf:"bytes,1,rep,name=images,proto3" json:"images,omitempty"`
	// A list of objects to be uploaded to Cloud Storage upon successful
	// completion of all build steps.
	//
	// Files in the workspace matching specified paths globs will be uploaded to
	// the specified Cloud Storage location using the builder service account's
	// credentials.
	//
	// The location and generation of the uploaded objects will be stored in the
	// Build resource's results field.
	//
	// If any objects fail to be pushed, the build is marked FAILURE.
	Objects *Artifacts_ArtifactObjects `protobuf:"bytes,2,opt,name=objects,proto3" json:"objects,omitempty"`
}

func (x *Artifacts) Reset() {
	*x = Artifacts{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Artifacts) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Artifacts) ProtoMessage() {}

func (x *Artifacts) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Artifacts.ProtoReflect.Descriptor instead.
func (*Artifacts) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{11}
}

func (x *Artifacts) GetImages() []string {
	if x != nil {
		return x.Images
	}
	return nil
}

func (x *Artifacts) GetObjects() *Artifacts_ArtifactObjects {
	if x != nil {
		return x.Objects
	}
	return nil
}

// Start and end times for a build execution phase.
type TimeSpan struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Start of time span.
	StartTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// End of time span.
	EndTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *TimeSpan) Reset() {
	*x = TimeSpan{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimeSpan) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimeSpan) ProtoMessage() {}

func (x *TimeSpan) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimeSpan.ProtoReflect.Descriptor instead.
func (*TimeSpan) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{12}
}

func (x *TimeSpan) GetStartTime() *timestamp.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *TimeSpan) GetEndTime() *timestamp.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// Metadata for build operations.
type BuildOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The build that the operation is tracking.
	Build *Build `protobuf:"bytes,1,opt,name=build,proto3" json:"build,omitempty"`
}

func (x *BuildOperationMetadata) Reset() {
	*x = BuildOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BuildOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BuildOperationMetadata) ProtoMessage() {}

func (x *BuildOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BuildOperationMetadata.ProtoReflect.Descriptor instead.
func (*BuildOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{13}
}

func (x *BuildOperationMetadata) GetBuild() *Build {
	if x != nil {
		return x.Build
	}
	return nil
}

// Provenance of the source. Ways to find the original source, or verify that
// some source was used for this build.
type SourceProvenance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A copy of the build's `source.storage_source`, if exists, with any
	// generations resolved.
	ResolvedStorageSource *StorageSource `protobuf:"bytes,3,opt,name=resolved_storage_source,json=resolvedStorageSource,proto3" json:"resolved_storage_source,omitempty"`
	// A copy of the build's `source.repo_source`, if exists, with any
	// revisions resolved.
	ResolvedRepoSource *RepoSource `protobuf:"bytes,6,opt,name=resolved_repo_source,json=resolvedRepoSource,proto3" json:"resolved_repo_source,omitempty"`
	// Output only. Hash(es) of the build source, which can be used to verify that
	// the original source integrity was maintained in the build. Note that
	// `FileHashes` will only be populated if `BuildOptions` has requested a
	// `SourceProvenanceHash`.
	//
	// The keys to this map are file paths used as build source and the values
	// contain the hash values for those files.
	//
	// If the build source came in a single package such as a gzipped tarfile
	// (`.tar.gz`), the `FileHash` will be for the single path to that file.
	FileHashes map[string]*FileHashes `protobuf:"bytes,4,rep,name=file_hashes,json=fileHashes,proto3" json:"file_hashes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *SourceProvenance) Reset() {
	*x = SourceProvenance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SourceProvenance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SourceProvenance) ProtoMessage() {}

func (x *SourceProvenance) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SourceProvenance.ProtoReflect.Descriptor instead.
func (*SourceProvenance) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{14}
}

func (x *SourceProvenance) GetResolvedStorageSource() *StorageSource {
	if x != nil {
		return x.ResolvedStorageSource
	}
	return nil
}

func (x *SourceProvenance) GetResolvedRepoSource() *RepoSource {
	if x != nil {
		return x.ResolvedRepoSource
	}
	return nil
}

func (x *SourceProvenance) GetFileHashes() map[string]*FileHashes {
	if x != nil {
		return x.FileHashes
	}
	return nil
}

// Container message for hashes of byte content of files, used in
// SourceProvenance messages to verify integrity of source input to the build.
type FileHashes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Collection of file hashes.
	FileHash []*Hash `protobuf:"bytes,1,rep,name=file_hash,json=fileHash,proto3" json:"file_hash,omitempty"`
}

func (x *FileHashes) Reset() {
	*x = FileHashes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FileHashes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileHashes) ProtoMessage() {}

func (x *FileHashes) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileHashes.ProtoReflect.Descriptor instead.
func (*FileHashes) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{15}
}

func (x *FileHashes) GetFileHash() []*Hash {
	if x != nil {
		return x.FileHash
	}
	return nil
}

// Container message for hash values.
type Hash struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of hash that was performed.
	Type Hash_HashType `protobuf:"varint,1,opt,name=type,proto3,enum=google.devtools.cloudbuild.v1.Hash_HashType" json:"type,omitempty"`
	// The hash value.
	Value []byte `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Hash) Reset() {
	*x = Hash{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Hash) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Hash) ProtoMessage() {}

func (x *Hash) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Hash.ProtoReflect.Descriptor instead.
func (*Hash) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{16}
}

func (x *Hash) GetType() Hash_HashType {
	if x != nil {
		return x.Type
	}
	return Hash_NONE
}

func (x *Hash) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

// Pairs a set of secret environment variables containing encrypted
// values with the Cloud KMS key to use to decrypt the value.
type Secret struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud KMS key name to use to decrypt these envs.
	KmsKeyName string `protobuf:"bytes,1,opt,name=kms_key_name,json=kmsKeyName,proto3" json:"kms_key_name,omitempty"`
	// Map of environment variable name to its encrypted value.
	//
	// Secret environment variables must be unique across all of a build's
	// secrets, and must be used by at least one build step. Values can be at most
	// 64 KB in size. There can be at most 100 secret values across all of a
	// build's secrets.
	SecretEnv map[string][]byte `protobuf:"bytes,3,rep,name=secret_env,json=secretEnv,proto3" json:"secret_env,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Secret) Reset() {
	*x = Secret{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Secret) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Secret) ProtoMessage() {}

func (x *Secret) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Secret.ProtoReflect.Descriptor instead.
func (*Secret) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{17}
}

func (x *Secret) GetKmsKeyName() string {
	if x != nil {
		return x.KmsKeyName
	}
	return ""
}

func (x *Secret) GetSecretEnv() map[string][]byte {
	if x != nil {
		return x.SecretEnv
	}
	return nil
}

// Request to create a new build.
type CreateBuildRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. ID of the project.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Build resource to create.
	Build *Build `protobuf:"bytes,2,opt,name=build,proto3" json:"build,omitempty"`
}

func (x *CreateBuildRequest) Reset() {
	*x = CreateBuildRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateBuildRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateBuildRequest) ProtoMessage() {}

func (x *CreateBuildRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateBuildRequest.ProtoReflect.Descriptor instead.
func (*CreateBuildRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{18}
}

func (x *CreateBuildRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *CreateBuildRequest) GetBuild() *Build {
	if x != nil {
		return x.Build
	}
	return nil
}

// Request to get a build.
type GetBuildRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. ID of the project.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. ID of the build.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *GetBuildRequest) Reset() {
	*x = GetBuildRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetBuildRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBuildRequest) ProtoMessage() {}

func (x *GetBuildRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBuildRequest.ProtoReflect.Descriptor instead.
func (*GetBuildRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{19}
}

func (x *GetBuildRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *GetBuildRequest) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

// Request to list builds.
type ListBuildsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. ID of the project.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Number of results to return in the list.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Token to provide to skip to a particular spot in the list.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The raw filter text to constrain the results.
	Filter string `protobuf:"bytes,8,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListBuildsRequest) Reset() {
	*x = ListBuildsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBuildsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBuildsRequest) ProtoMessage() {}

func (x *ListBuildsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBuildsRequest.ProtoReflect.Descriptor instead.
func (*ListBuildsRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{20}
}

func (x *ListBuildsRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *ListBuildsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListBuildsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListBuildsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response including listed builds.
type ListBuildsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Builds will be sorted by `create_time`, descending.
	Builds []*Build `protobuf:"bytes,1,rep,name=builds,proto3" json:"builds,omitempty"`
	// Token to receive the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListBuildsResponse) Reset() {
	*x = ListBuildsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBuildsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBuildsResponse) ProtoMessage() {}

func (x *ListBuildsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBuildsResponse.ProtoReflect.Descriptor instead.
func (*ListBuildsResponse) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{21}
}

func (x *ListBuildsResponse) GetBuilds() []*Build {
	if x != nil {
		return x.Builds
	}
	return nil
}

func (x *ListBuildsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request to cancel an ongoing build.
type CancelBuildRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. ID of the project.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. ID of the build.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *CancelBuildRequest) Reset() {
	*x = CancelBuildRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CancelBuildRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelBuildRequest) ProtoMessage() {}

func (x *CancelBuildRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelBuildRequest.ProtoReflect.Descriptor instead.
func (*CancelBuildRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{22}
}

func (x *CancelBuildRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *CancelBuildRequest) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

// Configuration for an automated build in response to source repository
// changes.
type BuildTrigger struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Unique identifier of the trigger.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Human-readable description of this trigger.
	Description string `protobuf:"bytes,10,opt,name=description,proto3" json:"description,omitempty"`
	// User-assigned name of the trigger. Must be unique within the project.
	// Trigger names must meet the following requirements:
	//
	// + They must contain only alphanumeric characters and dashes.
	// + They can be 1-64 characters long.
	// + They must begin and end with an alphanumeric character.
	Name string `protobuf:"bytes,21,opt,name=name,proto3" json:"name,omitempty"`
	// Tags for annotation of a `BuildTrigger`
	Tags []string `protobuf:"bytes,19,rep,name=tags,proto3" json:"tags,omitempty"`
	// Template describing the types of source changes to trigger a build.
	//
	// Branch and tag names in trigger templates are interpreted as regular
	// expressions. Any branch or tag change that matches that regular expression
	// will trigger a build.
	//
	// Mutually exclusive with `github`.
	TriggerTemplate *RepoSource `protobuf:"bytes,7,opt,name=trigger_template,json=triggerTemplate,proto3" json:"trigger_template,omitempty"`
	// GitHubEventsConfig describes the configuration of a trigger that creates
	// a build whenever a GitHub event is received.
	//
	// Mutually exclusive with `trigger_template`.
	Github *GitHubEventsConfig `protobuf:"bytes,13,opt,name=github,proto3" json:"github,omitempty"`
	// Template describing the Build request to make when the trigger is matched.
	//
	// Types that are assignable to BuildTemplate:
	//	*BuildTrigger_Build
	//	*BuildTrigger_Filename
	BuildTemplate isBuildTrigger_BuildTemplate `protobuf_oneof:"build_template"`
	// Output only. Time when the trigger was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// If true, the trigger will never result in a build.
	Disabled bool `protobuf:"varint,9,opt,name=disabled,proto3" json:"disabled,omitempty"`
	// Substitutions for Build resource. The keys must match the following
	// regular expression: `^_[A-Z0-9_]+$`.The keys cannot conflict with the
	// keys in bindings.
	Substitutions map[string]string `protobuf:"bytes,11,rep,name=substitutions,proto3" json:"substitutions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// ignored_files and included_files are file glob matches using
	// https://golang.org/pkg/path/filepath/#Match extended with support for "**".
	//
	// If ignored_files and changed files are both empty, then they are
	// not used to determine whether or not to trigger a build.
	//
	// If ignored_files is not empty, then we ignore any files that match
	// any of the ignored_file globs. If the change has no files that are
	// outside of the ignored_files globs, then we do not trigger a build.
	IgnoredFiles []string `protobuf:"bytes,15,rep,name=ignored_files,json=ignoredFiles,proto3" json:"ignored_files,omitempty"`
	// If any of the files altered in the commit pass the ignored_files
	// filter and included_files is empty, then as far as this filter is
	// concerned, we should trigger the build.
	//
	// If any of the files altered in the commit pass the ignored_files
	// filter and included_files is not empty, then we make sure that at
	// least one of those files matches a included_files glob. If not,
	// then we do not trigger a build.
	IncludedFiles []string `protobuf:"bytes,16,rep,name=included_files,json=includedFiles,proto3" json:"included_files,omitempty"`
}

func (x *BuildTrigger) Reset() {
	*x = BuildTrigger{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BuildTrigger) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BuildTrigger) ProtoMessage() {}

func (x *BuildTrigger) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BuildTrigger.ProtoReflect.Descriptor instead.
func (*BuildTrigger) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{23}
}

func (x *BuildTrigger) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *BuildTrigger) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *BuildTrigger) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *BuildTrigger) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *BuildTrigger) GetTriggerTemplate() *RepoSource {
	if x != nil {
		return x.TriggerTemplate
	}
	return nil
}

func (x *BuildTrigger) GetGithub() *GitHubEventsConfig {
	if x != nil {
		return x.Github
	}
	return nil
}

func (m *BuildTrigger) GetBuildTemplate() isBuildTrigger_BuildTemplate {
	if m != nil {
		return m.BuildTemplate
	}
	return nil
}

func (x *BuildTrigger) GetBuild() *Build {
	if x, ok := x.GetBuildTemplate().(*BuildTrigger_Build); ok {
		return x.Build
	}
	return nil
}

func (x *BuildTrigger) GetFilename() string {
	if x, ok := x.GetBuildTemplate().(*BuildTrigger_Filename); ok {
		return x.Filename
	}
	return ""
}

func (x *BuildTrigger) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *BuildTrigger) GetDisabled() bool {
	if x != nil {
		return x.Disabled
	}
	return false
}

func (x *BuildTrigger) GetSubstitutions() map[string]string {
	if x != nil {
		return x.Substitutions
	}
	return nil
}

func (x *BuildTrigger) GetIgnoredFiles() []string {
	if x != nil {
		return x.IgnoredFiles
	}
	return nil
}

func (x *BuildTrigger) GetIncludedFiles() []string {
	if x != nil {
		return x.IncludedFiles
	}
	return nil
}

type isBuildTrigger_BuildTemplate interface {
	isBuildTrigger_BuildTemplate()
}

type BuildTrigger_Build struct {
	// Contents of the build template.
	Build *Build `protobuf:"bytes,4,opt,name=build,proto3,oneof"`
}

type BuildTrigger_Filename struct {
	// Path, from the source root, to a file whose contents is used for the
	// template.
	Filename string `protobuf:"bytes,8,opt,name=filename,proto3,oneof"`
}

func (*BuildTrigger_Build) isBuildTrigger_BuildTemplate() {}

func (*BuildTrigger_Filename) isBuildTrigger_BuildTemplate() {}

// GitHubEventsConfig describes the configuration of a trigger that creates a
// build whenever a GitHub event is received.
//
// This message is experimental.
type GitHubEventsConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The installationID that emits the GitHub event.
	//
	// Deprecated: Do not use.
	InstallationId int64 `protobuf:"varint,1,opt,name=installation_id,json=installationId,proto3" json:"installation_id,omitempty"`
	// Owner of the repository. For example: The owner for
	// https://github.com/googlecloudplatform/cloud-builders is
	// "googlecloudplatform".
	Owner string `protobuf:"bytes,6,opt,name=owner,proto3" json:"owner,omitempty"`
	// Name of the repository. For example: The name for
	// https://github.com/googlecloudplatform/cloud-builders is "cloud-builders".
	Name string `protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
	// Filter describing the types of events to trigger a build.
	// Currently supported event types: push, pull_request.
	//
	// Types that are assignable to Event:
	//	*GitHubEventsConfig_PullRequest
	//	*GitHubEventsConfig_Push
	Event isGitHubEventsConfig_Event `protobuf_oneof:"event"`
}

func (x *GitHubEventsConfig) Reset() {
	*x = GitHubEventsConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GitHubEventsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GitHubEventsConfig) ProtoMessage() {}

func (x *GitHubEventsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GitHubEventsConfig.ProtoReflect.Descriptor instead.
func (*GitHubEventsConfig) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{24}
}

// Deprecated: Do not use.
func (x *GitHubEventsConfig) GetInstallationId() int64 {
	if x != nil {
		return x.InstallationId
	}
	return 0
}

func (x *GitHubEventsConfig) GetOwner() string {
	if x != nil {
		return x.Owner
	}
	return ""
}

func (x *GitHubEventsConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (m *GitHubEventsConfig) GetEvent() isGitHubEventsConfig_Event {
	if m != nil {
		return m.Event
	}
	return nil
}

func (x *GitHubEventsConfig) GetPullRequest() *PullRequestFilter {
	if x, ok := x.GetEvent().(*GitHubEventsConfig_PullRequest); ok {
		return x.PullRequest
	}
	return nil
}

func (x *GitHubEventsConfig) GetPush() *PushFilter {
	if x, ok := x.GetEvent().(*GitHubEventsConfig_Push); ok {
		return x.Push
	}
	return nil
}

type isGitHubEventsConfig_Event interface {
	isGitHubEventsConfig_Event()
}

type GitHubEventsConfig_PullRequest struct {
	// filter to match changes in pull requests.
	PullRequest *PullRequestFilter `protobuf:"bytes,4,opt,name=pull_request,json=pullRequest,proto3,oneof"`
}

type GitHubEventsConfig_Push struct {
	// filter to match changes in refs like branches, tags.
	Push *PushFilter `protobuf:"bytes,5,opt,name=push,proto3,oneof"`
}

func (*GitHubEventsConfig_PullRequest) isGitHubEventsConfig_Event() {}

func (*GitHubEventsConfig_Push) isGitHubEventsConfig_Event() {}

// PullRequestFilter contains filter properties for matching GitHub Pull
// Requests.
type PullRequestFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Target refs to match.
	// A target ref is the git reference where the pull request will be applied.
	//
	// Types that are assignable to GitRef:
	//	*PullRequestFilter_Branch
	GitRef isPullRequestFilter_GitRef `protobuf_oneof:"git_ref"`
	// Whether to block builds on a "/gcbrun" comment from a repository admin or
	// collaborator.
	CommentControl PullRequestFilter_CommentControl `protobuf:"varint,5,opt,name=comment_control,json=commentControl,proto3,enum=google.devtools.cloudbuild.v1.PullRequestFilter_CommentControl" json:"comment_control,omitempty"`
	// If true, branches that do NOT match the git_ref will trigger a build.
	InvertRegex bool `protobuf:"varint,6,opt,name=invert_regex,json=invertRegex,proto3" json:"invert_regex,omitempty"`
}

func (x *PullRequestFilter) Reset() {
	*x = PullRequestFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PullRequestFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PullRequestFilter) ProtoMessage() {}

func (x *PullRequestFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PullRequestFilter.ProtoReflect.Descriptor instead.
func (*PullRequestFilter) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{25}
}

func (m *PullRequestFilter) GetGitRef() isPullRequestFilter_GitRef {
	if m != nil {
		return m.GitRef
	}
	return nil
}

func (x *PullRequestFilter) GetBranch() string {
	if x, ok := x.GetGitRef().(*PullRequestFilter_Branch); ok {
		return x.Branch
	}
	return ""
}

func (x *PullRequestFilter) GetCommentControl() PullRequestFilter_CommentControl {
	if x != nil {
		return x.CommentControl
	}
	return PullRequestFilter_COMMENTS_DISABLED
}

func (x *PullRequestFilter) GetInvertRegex() bool {
	if x != nil {
		return x.InvertRegex
	}
	return false
}

type isPullRequestFilter_GitRef interface {
	isPullRequestFilter_GitRef()
}

type PullRequestFilter_Branch struct {
	// Regex of branches to match.
	//
	// The syntax of the regular expressions accepted is the syntax accepted by
	// RE2 and described at https://github.com/google/re2/wiki/Syntax
	Branch string `protobuf:"bytes,2,opt,name=branch,proto3,oneof"`
}

func (*PullRequestFilter_Branch) isPullRequestFilter_GitRef() {}

// Push contains filter properties for matching GitHub git pushes.
type PushFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Modified refs to match.
	// A modified refs are the refs modified by a git push operation.
	//
	// Types that are assignable to GitRef:
	//	*PushFilter_Branch
	//	*PushFilter_Tag
	GitRef isPushFilter_GitRef `protobuf_oneof:"git_ref"`
	// When true, only trigger a build if the revision regex does NOT match the
	// git_ref regex.
	InvertRegex bool `protobuf:"varint,4,opt,name=invert_regex,json=invertRegex,proto3" json:"invert_regex,omitempty"`
}

func (x *PushFilter) Reset() {
	*x = PushFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PushFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PushFilter) ProtoMessage() {}

func (x *PushFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PushFilter.ProtoReflect.Descriptor instead.
func (*PushFilter) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{26}
}

func (m *PushFilter) GetGitRef() isPushFilter_GitRef {
	if m != nil {
		return m.GitRef
	}
	return nil
}

func (x *PushFilter) GetBranch() string {
	if x, ok := x.GetGitRef().(*PushFilter_Branch); ok {
		return x.Branch
	}
	return ""
}

func (x *PushFilter) GetTag() string {
	if x, ok := x.GetGitRef().(*PushFilter_Tag); ok {
		return x.Tag
	}
	return ""
}

func (x *PushFilter) GetInvertRegex() bool {
	if x != nil {
		return x.InvertRegex
	}
	return false
}

type isPushFilter_GitRef interface {
	isPushFilter_GitRef()
}

type PushFilter_Branch struct {
	// Regexes matching branches to build.
	//
	// The syntax of the regular expressions accepted is the syntax accepted by
	// RE2 and described at https://github.com/google/re2/wiki/Syntax
	Branch string `protobuf:"bytes,2,opt,name=branch,proto3,oneof"`
}

type PushFilter_Tag struct {
	// Regexes matching tags to build.
	//
	// The syntax of the regular expressions accepted is the syntax accepted by
	// RE2 and described at https://github.com/google/re2/wiki/Syntax
	Tag string `protobuf:"bytes,3,opt,name=tag,proto3,oneof"`
}

func (*PushFilter_Branch) isPushFilter_GitRef() {}

func (*PushFilter_Tag) isPushFilter_GitRef() {}

// Request to create a new `BuildTrigger`.
type CreateBuildTriggerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. ID of the project for which to configure automatic builds.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. `BuildTrigger` to create.
	Trigger *BuildTrigger `protobuf:"bytes,2,opt,name=trigger,proto3" json:"trigger,omitempty"`
}

func (x *CreateBuildTriggerRequest) Reset() {
	*x = CreateBuildTriggerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateBuildTriggerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateBuildTriggerRequest) ProtoMessage() {}

func (x *CreateBuildTriggerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateBuildTriggerRequest.ProtoReflect.Descriptor instead.
func (*CreateBuildTriggerRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{27}
}

func (x *CreateBuildTriggerRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *CreateBuildTriggerRequest) GetTrigger() *BuildTrigger {
	if x != nil {
		return x.Trigger
	}
	return nil
}

// Returns the `BuildTrigger` with the specified ID.
type GetBuildTriggerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. ID of the project that owns the trigger.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. Identifier (`id` or `name`) of the `BuildTrigger` to get.
	TriggerId string `protobuf:"bytes,2,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
}

func (x *GetBuildTriggerRequest) Reset() {
	*x = GetBuildTriggerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetBuildTriggerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBuildTriggerRequest) ProtoMessage() {}

func (x *GetBuildTriggerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBuildTriggerRequest.ProtoReflect.Descriptor instead.
func (*GetBuildTriggerRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{28}
}

func (x *GetBuildTriggerRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *GetBuildTriggerRequest) GetTriggerId() string {
	if x != nil {
		return x.TriggerId
	}
	return ""
}

// Request to list existing `BuildTriggers`.
type ListBuildTriggersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. ID of the project for which to list BuildTriggers.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Number of results to return in the list.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Token to provide to skip to a particular spot in the list.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListBuildTriggersRequest) Reset() {
	*x = ListBuildTriggersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBuildTriggersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBuildTriggersRequest) ProtoMessage() {}

func (x *ListBuildTriggersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBuildTriggersRequest.ProtoReflect.Descriptor instead.
func (*ListBuildTriggersRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{29}
}

func (x *ListBuildTriggersRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *ListBuildTriggersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListBuildTriggersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response containing existing `BuildTriggers`.
type ListBuildTriggersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// `BuildTriggers` for the project, sorted by `create_time` descending.
	Triggers []*BuildTrigger `protobuf:"bytes,1,rep,name=triggers,proto3" json:"triggers,omitempty"`
	// Token to receive the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListBuildTriggersResponse) Reset() {
	*x = ListBuildTriggersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBuildTriggersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBuildTriggersResponse) ProtoMessage() {}

func (x *ListBuildTriggersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBuildTriggersResponse.ProtoReflect.Descriptor instead.
func (*ListBuildTriggersResponse) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{30}
}

func (x *ListBuildTriggersResponse) GetTriggers() []*BuildTrigger {
	if x != nil {
		return x.Triggers
	}
	return nil
}

func (x *ListBuildTriggersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request to delete a `BuildTrigger`.
type DeleteBuildTriggerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. ID of the project that owns the trigger.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. ID of the `BuildTrigger` to delete.
	TriggerId string `protobuf:"bytes,2,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
}

func (x *DeleteBuildTriggerRequest) Reset() {
	*x = DeleteBuildTriggerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteBuildTriggerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteBuildTriggerRequest) ProtoMessage() {}

func (x *DeleteBuildTriggerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteBuildTriggerRequest.ProtoReflect.Descriptor instead.
func (*DeleteBuildTriggerRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{31}
}

func (x *DeleteBuildTriggerRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *DeleteBuildTriggerRequest) GetTriggerId() string {
	if x != nil {
		return x.TriggerId
	}
	return ""
}

// Request to update an existing `BuildTrigger`.
type UpdateBuildTriggerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. ID of the project that owns the trigger.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. ID of the `BuildTrigger` to update.
	TriggerId string `protobuf:"bytes,2,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
	// Required. `BuildTrigger` to update.
	Trigger *BuildTrigger `protobuf:"bytes,3,opt,name=trigger,proto3" json:"trigger,omitempty"`
}

func (x *UpdateBuildTriggerRequest) Reset() {
	*x = UpdateBuildTriggerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateBuildTriggerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateBuildTriggerRequest) ProtoMessage() {}

func (x *UpdateBuildTriggerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateBuildTriggerRequest.ProtoReflect.Descriptor instead.
func (*UpdateBuildTriggerRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{32}
}

func (x *UpdateBuildTriggerRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *UpdateBuildTriggerRequest) GetTriggerId() string {
	if x != nil {
		return x.TriggerId
	}
	return ""
}

func (x *UpdateBuildTriggerRequest) GetTrigger() *BuildTrigger {
	if x != nil {
		return x.Trigger
	}
	return nil
}

// Optional arguments to enable specific features of builds.
type BuildOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Requested hash for SourceProvenance.
	SourceProvenanceHash []Hash_HashType `protobuf:"varint,1,rep,packed,name=source_provenance_hash,json=sourceProvenanceHash,proto3,enum=google.devtools.cloudbuild.v1.Hash_HashType" json:"source_provenance_hash,omitempty"`
	// Requested verifiability options.
	RequestedVerifyOption BuildOptions_VerifyOption `protobuf:"varint,2,opt,name=requested_verify_option,json=requestedVerifyOption,proto3,enum=google.devtools.cloudbuild.v1.BuildOptions_VerifyOption" json:"requested_verify_option,omitempty"`
	// Compute Engine machine type on which to run the build.
	MachineType BuildOptions_MachineType `protobuf:"varint,3,opt,name=machine_type,json=machineType,proto3,enum=google.devtools.cloudbuild.v1.BuildOptions_MachineType" json:"machine_type,omitempty"`
	// Requested disk size for the VM that runs the build. Note that this is *NOT*
	// "disk free"; some of the space will be used by the operating system and
	// build utilities. Also note that this is the minimum disk size that will be
	// allocated for the build -- the build may run with a larger disk than
	// requested. At present, the maximum disk size is 1000GB; builds that request
	// more than the maximum are rejected with an error.
	DiskSizeGb int64 `protobuf:"varint,6,opt,name=disk_size_gb,json=diskSizeGb,proto3" json:"disk_size_gb,omitempty"`
	// Option to specify behavior when there is an error in the substitution
	// checks.
	SubstitutionOption BuildOptions_SubstitutionOption `protobuf:"varint,4,opt,name=substitution_option,json=substitutionOption,proto3,enum=google.devtools.cloudbuild.v1.BuildOptions_SubstitutionOption" json:"substitution_option,omitempty"`
	// Option to define build log streaming behavior to Google Cloud
	// Storage.
	LogStreamingOption BuildOptions_LogStreamingOption `protobuf:"varint,5,opt,name=log_streaming_option,json=logStreamingOption,proto3,enum=google.devtools.cloudbuild.v1.BuildOptions_LogStreamingOption" json:"log_streaming_option,omitempty"`
	// Option to specify a `WorkerPool` for the build.
	// Format: projects/{project}/workerPools/{workerPool}
	//
	// This field is experimental.
	WorkerPool string `protobuf:"bytes,7,opt,name=worker_pool,json=workerPool,proto3" json:"worker_pool,omitempty"`
	// Option to specify the logging mode, which determines where the logs are
	// stored.
	Logging BuildOptions_LoggingMode `protobuf:"varint,11,opt,name=logging,proto3,enum=google.devtools.cloudbuild.v1.BuildOptions_LoggingMode" json:"logging,omitempty"`
	// A list of global environment variable definitions that will exist for all
	// build steps in this build. If a variable is defined in both globally and in
	// a build step, the variable will use the build step value.
	//
	// The elements are of the form "KEY=VALUE" for the environment variable "KEY"
	// being given the value "VALUE".
	Env []string `protobuf:"bytes,12,rep,name=env,proto3" json:"env,omitempty"`
	// A list of global environment variables, which are encrypted using a Cloud
	// Key Management Service crypto key. These values must be specified in the
	// build's `Secret`. These variables will be available to all build steps
	// in this build.
	SecretEnv []string `protobuf:"bytes,13,rep,name=secret_env,json=secretEnv,proto3" json:"secret_env,omitempty"`
	// Global list of volumes to mount for ALL build steps
	//
	// Each volume is created as an empty volume prior to starting the build
	// process. Upon completion of the build, volumes and their contents are
	// discarded. Global volume names and paths cannot conflict with the volumes
	// defined a build step.
	//
	// Using a global volume in a build with only one step is not valid as
	// it is indicative of a build request with an incorrect configuration.
	Volumes []*Volume `protobuf:"bytes,14,rep,name=volumes,proto3" json:"volumes,omitempty"`
}

func (x *BuildOptions) Reset() {
	*x = BuildOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BuildOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BuildOptions) ProtoMessage() {}

func (x *BuildOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BuildOptions.ProtoReflect.Descriptor instead.
func (*BuildOptions) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{33}
}

func (x *BuildOptions) GetSourceProvenanceHash() []Hash_HashType {
	if x != nil {
		return x.SourceProvenanceHash
	}
	return nil
}

func (x *BuildOptions) GetRequestedVerifyOption() BuildOptions_VerifyOption {
	if x != nil {
		return x.RequestedVerifyOption
	}
	return BuildOptions_NOT_VERIFIED
}

func (x *BuildOptions) GetMachineType() BuildOptions_MachineType {
	if x != nil {
		return x.MachineType
	}
	return BuildOptions_UNSPECIFIED
}

func (x *BuildOptions) GetDiskSizeGb() int64 {
	if x != nil {
		return x.DiskSizeGb
	}
	return 0
}

func (x *BuildOptions) GetSubstitutionOption() BuildOptions_SubstitutionOption {
	if x != nil {
		return x.SubstitutionOption
	}
	return BuildOptions_MUST_MATCH
}

func (x *BuildOptions) GetLogStreamingOption() BuildOptions_LogStreamingOption {
	if x != nil {
		return x.LogStreamingOption
	}
	return BuildOptions_STREAM_DEFAULT
}

func (x *BuildOptions) GetWorkerPool() string {
	if x != nil {
		return x.WorkerPool
	}
	return ""
}

func (x *BuildOptions) GetLogging() BuildOptions_LoggingMode {
	if x != nil {
		return x.Logging
	}
	return BuildOptions_LOGGING_UNSPECIFIED
}

func (x *BuildOptions) GetEnv() []string {
	if x != nil {
		return x.Env
	}
	return nil
}

func (x *BuildOptions) GetSecretEnv() []string {
	if x != nil {
		return x.SecretEnv
	}
	return nil
}

func (x *BuildOptions) GetVolumes() []*Volume {
	if x != nil {
		return x.Volumes
	}
	return nil
}

// Configuration for a WorkerPool to run the builds.
//
// Workers are machines that Cloud Build uses to run your builds. By default,
// all workers run in a project owned by Cloud Build. To have full control over
// the workers that execute your builds -- such as enabling them to access
// private resources on your private network -- you can request Cloud Build to
// run the workers in your own project by creating a custom workers pool.
type WorkerPool struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// User-defined name of the `WorkerPool`.
	Name string `protobuf:"bytes,14,opt,name=name,proto3" json:"name,omitempty"`
	// The project ID of the GCP project for which the `WorkerPool` is created.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Output only. The service account used to manage the `WorkerPool`. The
	// service account must have the Compute Instance Admin (Beta) permission at
	// the project level.
	ServiceAccountEmail string `protobuf:"bytes,3,opt,name=service_account_email,json=serviceAccountEmail,proto3" json:"service_account_email,omitempty"`
	// Total number of workers to be created across all requested regions.
	WorkerCount int64 `protobuf:"varint,4,opt,name=worker_count,json=workerCount,proto3" json:"worker_count,omitempty"`
	// Configuration to be used for a creating workers in the `WorkerPool`.
	WorkerConfig *WorkerConfig `protobuf:"bytes,16,opt,name=worker_config,json=workerConfig,proto3" json:"worker_config,omitempty"`
	// List of regions to create the `WorkerPool`. Regions can't be empty.
	// If Cloud Build adds a new GCP region in the future, the existing
	// `WorkerPool` will not be enabled in the new region automatically;
	// you must add the new region to the `regions` field to enable the
	// `WorkerPool` in that region.
	Regions []WorkerPool_Region `protobuf:"varint,9,rep,packed,name=regions,proto3,enum=google.devtools.cloudbuild.v1.WorkerPool_Region" json:"regions,omitempty"`
	// Output only. Time at which the request to create the `WorkerPool` was
	// received.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,11,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time at which the request to update the `WorkerPool` was
	// received.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,17,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. Time at which the request to delete the `WorkerPool` was
	// received.
	DeleteTime *timestamp.Timestamp `protobuf:"bytes,12,opt,name=delete_time,json=deleteTime,proto3" json:"delete_time,omitempty"`
	// Output only. WorkerPool Status.
	Status WorkerPool_Status `protobuf:"varint,13,opt,name=status,proto3,enum=google.devtools.cloudbuild.v1.WorkerPool_Status" json:"status,omitempty"`
}

func (x *WorkerPool) Reset() {
	*x = WorkerPool{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkerPool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkerPool) ProtoMessage() {}

func (x *WorkerPool) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkerPool.ProtoReflect.Descriptor instead.
func (*WorkerPool) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{34}
}

func (x *WorkerPool) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *WorkerPool) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *WorkerPool) GetServiceAccountEmail() string {
	if x != nil {
		return x.ServiceAccountEmail
	}
	return ""
}

func (x *WorkerPool) GetWorkerCount() int64 {
	if x != nil {
		return x.WorkerCount
	}
	return 0
}

func (x *WorkerPool) GetWorkerConfig() *WorkerConfig {
	if x != nil {
		return x.WorkerConfig
	}
	return nil
}

func (x *WorkerPool) GetRegions() []WorkerPool_Region {
	if x != nil {
		return x.Regions
	}
	return nil
}

func (x *WorkerPool) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *WorkerPool) GetUpdateTime() *timestamp.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *WorkerPool) GetDeleteTime() *timestamp.Timestamp {
	if x != nil {
		return x.DeleteTime
	}
	return nil
}

func (x *WorkerPool) GetStatus() WorkerPool_Status {
	if x != nil {
		return x.Status
	}
	return WorkerPool_STATUS_UNSPECIFIED
}

// WorkerConfig defines the configuration to be used for a creating workers in
// the pool.
type WorkerConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Machine Type of the worker, such as n1-standard-1.
	// See https://cloud.google.com/compute/docs/machine-types.
	// If left blank, Cloud Build will use a standard unspecified machine to
	// create the worker pool.
	// `machine_type` is overridden if you specify a different machine type in
	// `build_options`. In this case, the VM specified in the `build_options`
	// will be created on demand at build time. For more information see
	// https://cloud.google.com/cloud-build/docs/speeding-up-builds#using_custom_virtual_machine_sizes
	MachineType string `protobuf:"bytes,1,opt,name=machine_type,json=machineType,proto3" json:"machine_type,omitempty"`
	// Size of the disk attached to the worker, in GB.
	// See https://cloud.google.com/compute/docs/disks/
	// If `0` is specified, Cloud Build will use a standard disk size.
	// `disk_size` is overridden if you specify a different disk size in
	// `build_options`. In this case, a VM with a disk size specified in the
	// `build_options` will be created on demand at build time. For more
	// information see
	// https://cloud.google.com/cloud-build/docs/api/reference/rest/v1/projects.builds#buildoptions
	DiskSizeGb int64 `protobuf:"varint,2,opt,name=disk_size_gb,json=diskSizeGb,proto3" json:"disk_size_gb,omitempty"`
	// The network definition used to create the worker.
	// If this section is left empty, the workers will be created in
	// WorkerPool.project_id on the default network.
	Network *Network `protobuf:"bytes,3,opt,name=network,proto3" json:"network,omitempty"`
	// The tag applied to the worker, and the same tag used by the firewall rule.
	// It is used to identify the Cloud Build workers among other VMs.
	// The default value for tag is `worker`.
	Tag string `protobuf:"bytes,4,opt,name=tag,proto3" json:"tag,omitempty"`
}

func (x *WorkerConfig) Reset() {
	*x = WorkerConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkerConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkerConfig) ProtoMessage() {}

func (x *WorkerConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkerConfig.ProtoReflect.Descriptor instead.
func (*WorkerConfig) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{35}
}

func (x *WorkerConfig) GetMachineType() string {
	if x != nil {
		return x.MachineType
	}
	return ""
}

func (x *WorkerConfig) GetDiskSizeGb() int64 {
	if x != nil {
		return x.DiskSizeGb
	}
	return 0
}

func (x *WorkerConfig) GetNetwork() *Network {
	if x != nil {
		return x.Network
	}
	return nil
}

func (x *WorkerConfig) GetTag() string {
	if x != nil {
		return x.Tag
	}
	return ""
}

// Network describes the GCP network used to create workers in.
type Network struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Project id containing the defined network and subnetwork. For a peered VPC,
	// this will be the same as the project_id in which the workers are created.
	// For a shared VPC, this will be the project sharing the network with the
	// project_id project in which workers will be created. For custom workers
	// with no VPC, this will be the same as project_id.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Network on which the workers are created.
	// "default" network is used if empty.
	Network string `protobuf:"bytes,2,opt,name=network,proto3" json:"network,omitempty"`
	// Subnetwork on which the workers are created.
	// "default" subnetwork is used if empty.
	Subnetwork string `protobuf:"bytes,3,opt,name=subnetwork,proto3" json:"subnetwork,omitempty"`
}

func (x *Network) Reset() {
	*x = Network{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Network) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Network) ProtoMessage() {}

func (x *Network) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Network.ProtoReflect.Descriptor instead.
func (*Network) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{36}
}

func (x *Network) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *Network) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *Network) GetSubnetwork() string {
	if x != nil {
		return x.Subnetwork
	}
	return ""
}

// Request to create a new `WorkerPool`.
type CreateWorkerPoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the parent project.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// `WorkerPool` resource to create.
	WorkerPool *WorkerPool `protobuf:"bytes,2,opt,name=worker_pool,json=workerPool,proto3" json:"worker_pool,omitempty"`
}

func (x *CreateWorkerPoolRequest) Reset() {
	*x = CreateWorkerPoolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateWorkerPoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateWorkerPoolRequest) ProtoMessage() {}

func (x *CreateWorkerPoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateWorkerPoolRequest.ProtoReflect.Descriptor instead.
func (*CreateWorkerPoolRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{37}
}

func (x *CreateWorkerPoolRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateWorkerPoolRequest) GetWorkerPool() *WorkerPool {
	if x != nil {
		return x.WorkerPool
	}
	return nil
}

// Request to get a `WorkerPool` with the specified name.
type GetWorkerPoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The field will contain name of the resource requested, for example:
	// "projects/project-1/workerPools/workerpool-name"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetWorkerPoolRequest) Reset() {
	*x = GetWorkerPoolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetWorkerPoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetWorkerPoolRequest) ProtoMessage() {}

func (x *GetWorkerPoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetWorkerPoolRequest.ProtoReflect.Descriptor instead.
func (*GetWorkerPoolRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{38}
}

func (x *GetWorkerPoolRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to delete a `WorkerPool`.
type DeleteWorkerPoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The field will contain name of the resource requested, for example:
	// "projects/project-1/workerPools/workerpool-name"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteWorkerPoolRequest) Reset() {
	*x = DeleteWorkerPoolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteWorkerPoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteWorkerPoolRequest) ProtoMessage() {}

func (x *DeleteWorkerPoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteWorkerPoolRequest.ProtoReflect.Descriptor instead.
func (*DeleteWorkerPoolRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{39}
}

func (x *DeleteWorkerPoolRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to update a `WorkerPool`.
type UpdateWorkerPoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The field will contain name of the resource requested, for example:
	// "projects/project-1/workerPools/workerpool-name"
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// `WorkerPool` resource to update.
	WorkerPool *WorkerPool `protobuf:"bytes,3,opt,name=worker_pool,json=workerPool,proto3" json:"worker_pool,omitempty"`
}

func (x *UpdateWorkerPoolRequest) Reset() {
	*x = UpdateWorkerPoolRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateWorkerPoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateWorkerPoolRequest) ProtoMessage() {}

func (x *UpdateWorkerPoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateWorkerPoolRequest.ProtoReflect.Descriptor instead.
func (*UpdateWorkerPoolRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{40}
}

func (x *UpdateWorkerPoolRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateWorkerPoolRequest) GetWorkerPool() *WorkerPool {
	if x != nil {
		return x.WorkerPool
	}
	return nil
}

// Request to list `WorkerPools`.
type ListWorkerPoolsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the parent project.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *ListWorkerPoolsRequest) Reset() {
	*x = ListWorkerPoolsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListWorkerPoolsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListWorkerPoolsRequest) ProtoMessage() {}

func (x *ListWorkerPoolsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListWorkerPoolsRequest.ProtoReflect.Descriptor instead.
func (*ListWorkerPoolsRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{41}
}

func (x *ListWorkerPoolsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// Response containing existing `WorkerPools`.
type ListWorkerPoolsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// `WorkerPools` for the project.
	WorkerPools []*WorkerPool `protobuf:"bytes,1,rep,name=worker_pools,json=workerPools,proto3" json:"worker_pools,omitempty"`
}

func (x *ListWorkerPoolsResponse) Reset() {
	*x = ListWorkerPoolsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListWorkerPoolsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListWorkerPoolsResponse) ProtoMessage() {}

func (x *ListWorkerPoolsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListWorkerPoolsResponse.ProtoReflect.Descriptor instead.
func (*ListWorkerPoolsResponse) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{42}
}

func (x *ListWorkerPoolsResponse) GetWorkerPools() []*WorkerPool {
	if x != nil {
		return x.WorkerPools
	}
	return nil
}

// Files in the workspace to upload to Cloud Storage upon successful
// completion of all build steps.
type Artifacts_ArtifactObjects struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud Storage bucket and optional object path, in the form
	// "gs://bucket/path/to/somewhere/". (see [Bucket Name
	// Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
	//
	// Files in the workspace matching any path pattern will be uploaded to
	// Cloud Storage with this location as a prefix.
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// Path globs used to match files in the build's workspace.
	Paths []string `protobuf:"bytes,2,rep,name=paths,proto3" json:"paths,omitempty"`
	// Output only. Stores timing information for pushing all artifact objects.
	Timing *TimeSpan `protobuf:"bytes,3,opt,name=timing,proto3" json:"timing,omitempty"`
}

func (x *Artifacts_ArtifactObjects) Reset() {
	*x = Artifacts_ArtifactObjects{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Artifacts_ArtifactObjects) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Artifacts_ArtifactObjects) ProtoMessage() {}

func (x *Artifacts_ArtifactObjects) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Artifacts_ArtifactObjects.ProtoReflect.Descriptor instead.
func (*Artifacts_ArtifactObjects) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP(), []int{11, 0}
}

func (x *Artifacts_ArtifactObjects) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *Artifacts_ArtifactObjects) GetPaths() []string {
	if x != nil {
		return x.Paths
	}
	return nil
}

func (x *Artifacts_ArtifactObjects) GetTiming() *TimeSpan {
	if x != nil {
		return x.Timing
	}
	return nil
}

var File_google_devtools_cloudbuild_v1_cloudbuild_proto protoreflect.FileDescriptor

var file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDesc = []byte{
	0x0a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x76, 0x31, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d,
	0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x4c, 0x0a, 0x11, 0x52, 0x65,
	0x74, 0x72, 0x79, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x49, 0x64, 0x12, 0x13, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x02, 0x69, 0x64, 0x22, 0xa8, 0x01, 0x0a, 0x16, 0x52, 0x75, 0x6e,
	0x42, 0x75, 0x69, 0x6c, 0x64, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x0a, 0x74, 0x72, 0x69, 0x67, 0x67,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x09, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x49, 0x64, 0x12, 0x46, 0x0a, 0x06, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x22, 0x5f, 0x0a, 0x0d, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x16, 0x0a, 0x06,
	0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x90, 0x03, 0x0a, 0x0a, 0x52, 0x65, 0x70, 0x6f, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x72, 0x65, 0x70, 0x6f, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x72, 0x65, 0x70, 0x6f, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x21, 0x0a, 0x0b, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0a, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x08, 0x74, 0x61, 0x67, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x07, 0x74, 0x61, 0x67, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x1f, 0x0a, 0x0a, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x73, 0x68, 0x61, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x53, 0x68, 0x61,
	0x12, 0x10, 0x0a, 0x03, 0x64, 0x69, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x64,
	0x69, 0x72, 0x12, 0x21, 0x0a, 0x0c, 0x69, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x5f, 0x72, 0x65, 0x67,
	0x65, 0x78, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x69, 0x6e, 0x76, 0x65, 0x72, 0x74,
	0x52, 0x65, 0x67, 0x65, 0x78, 0x12, 0x62, 0x0a, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x74, 0x69, 0x74,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70,
	0x6f, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x74, 0x69, 0x74, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0d, 0x73, 0x75, 0x62, 0x73,
	0x74, 0x69, 0x74, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x40, 0x0a, 0x12, 0x53, 0x75, 0x62,
	0x73, 0x74, 0x69, 0x74, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x0a, 0x0a, 0x08, 0x72,
	0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xb7, 0x01, 0x0a, 0x06, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x55, 0x0a, 0x0e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0d, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x4c, 0x0a, 0x0b, 0x72, 0x65, 0x70,
	0x6f, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x70, 0x6f, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0a, 0x72, 0x65, 0x70,
	0x6f, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x22, 0x87, 0x01, 0x0a, 0x0a, 0x42, 0x75, 0x69, 0x6c, 0x74, 0x49, 0x6d, 0x61, 0x67, 0x65,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x0b,
	0x70, 0x75, 0x73, 0x68, 0x5f, 0x74, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x70, 0x61, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x70, 0x75, 0x73, 0x68, 0x54, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x22, 0x8c, 0x04, 0x0a, 0x09,
	0x42, 0x75, 0x69, 0x6c, 0x64, 0x53, 0x74, 0x65, 0x70, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x10, 0x0a,
	0x03, 0x65, 0x6e, 0x76, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x03, 0x65, 0x6e, 0x76, 0x12,
	0x12, 0x0a, 0x04, 0x61, 0x72, 0x67, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x61,
	0x72, 0x67, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x64, 0x69, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x64, 0x69, 0x72, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x77, 0x61, 0x69, 0x74, 0x5f, 0x66, 0x6f,
	0x72, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x77, 0x61, 0x69, 0x74, 0x46, 0x6f, 0x72,
	0x12, 0x1e, 0x0a, 0x0a, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x65, 0x6e, 0x76, 0x18, 0x08,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x45, 0x6e, 0x76, 0x12,
	0x3f, 0x0a, 0x07, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31,
	0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x07, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73,
	0x12, 0x44, 0x0a, 0x06, 0x74, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x70, 0x61, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06,
	0x74, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x12, 0x48, 0x0a, 0x0b, 0x70, 0x75, 0x6c, 0x6c, 0x5f, 0x74,
	0x69, 0x6d, 0x69, 0x6e, 0x67, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x53, 0x70, 0x61, 0x6e, 0x52, 0x0a, 0x70, 0x75, 0x6c, 0x6c, 0x54, 0x69, 0x6d, 0x69, 0x6e, 0x67,
	0x12, 0x33, 0x0a, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x74, 0x69,
	0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18,
	0x0c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x30, 0x0a, 0x06, 0x56, 0x6f,
	0x6c, 0x75, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x22, 0xca, 0x02, 0x0a,
	0x07, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x41, 0x0a, 0x06, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x74, 0x49, 0x6d,
	0x61, 0x67, 0x65, 0x52, 0x06, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x62,
	0x75, 0x69, 0x6c, 0x64, 0x5f, 0x73, 0x74, 0x65, 0x70, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x53, 0x74, 0x65,
	0x70, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x61, 0x72, 0x74, 0x69, 0x66,
	0x61, 0x63, 0x74, 0x5f, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x10, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x4d, 0x61, 0x6e, 0x69,
	0x66, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x6e, 0x75, 0x6d, 0x5f, 0x61, 0x72, 0x74, 0x69,
	0x66, 0x61, 0x63, 0x74, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c, 0x6e, 0x75, 0x6d,
	0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x5f, 0x73, 0x74, 0x65, 0x70, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x18,
	0x06, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x10, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x53, 0x74, 0x65, 0x70,
	0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x12, 0x50, 0x0a, 0x0f, 0x61, 0x72, 0x74, 0x69, 0x66,
	0x61, 0x63, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x70, 0x61, 0x6e, 0x52, 0x0e, 0x61, 0x72, 0x74, 0x69, 0x66,
	0x61, 0x63, 0x74, 0x54, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x22, 0x74, 0x0a, 0x0e, 0x41, 0x72, 0x74,
	0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x46, 0x0a, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f,
	0x68, 0x61, 0x73, 0x68, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x48,
	0x61, 0x73, 0x68, 0x65, 0x73, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x48, 0x61, 0x73, 0x68, 0x22,
	0xc7, 0x0c, 0x0a, 0x05, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x12, 0x13, 0x0a, 0x02, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x02, 0x69, 0x64, 0x12, 0x22,
	0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x10, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x49, 0x64, 0x12, 0x43, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e,
	0x76, 0x31, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52,
	0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x18, 0x18, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x3d, 0x0a, 0x06,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x3e, 0x0a, 0x05, 0x73,
	0x74, 0x65, 0x70, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64,
	0x53, 0x74, 0x65, 0x70, 0x52, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73, 0x12, 0x45, 0x0a, 0x07, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x66, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x66, 0x69, 0x6e, 0x69,
	0x73, 0x68, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x33, 0x0a, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75,
	0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x69,
	0x6d, 0x61, 0x67, 0x65, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x69, 0x6d, 0x61,
	0x67, 0x65, 0x73, 0x12, 0x36, 0x0a, 0x09, 0x71, 0x75, 0x65, 0x75, 0x65, 0x5f, 0x74, 0x74, 0x6c,
	0x18, 0x28, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x08, 0x71, 0x75, 0x65, 0x75, 0x65, 0x54, 0x74, 0x6c, 0x12, 0x46, 0x0a, 0x09, 0x61,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x18, 0x25, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x52, 0x09, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61,
	0x63, 0x74, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x6f, 0x67, 0x73, 0x5f, 0x62, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x18, 0x13, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6c, 0x6f, 0x67, 0x73, 0x42, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x12, 0x5c, 0x0a, 0x11, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70,
	0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65,
	0x52, 0x10, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e,
	0x63, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x74, 0x72, 0x69, 0x67,
	0x67, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x16, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x49, 0x64, 0x12, 0x45, 0x0a, 0x07,
	0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75,
	0x69, 0x6c, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x1c, 0x0a, 0x07, 0x6c, 0x6f, 0x67, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x19,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x6c, 0x6f, 0x67, 0x55, 0x72,
	0x6c, 0x12, 0x5d, 0x0a, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x74, 0x69, 0x74, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x1d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x53,
	0x75, 0x62, 0x73, 0x74, 0x69, 0x74, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x74, 0x69, 0x74, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x12, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x1f, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04,
	0x74, 0x61, 0x67, 0x73, 0x12, 0x3f, 0x0a, 0x07, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x18,
	0x20, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x07, 0x73, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x73, 0x12, 0x4d, 0x0a, 0x06, 0x74, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x18,
	0x21, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x54, 0x69, 0x6d, 0x69,
	0x6e, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x74, 0x69,
	0x6d, 0x69, 0x6e, 0x67, 0x1a, 0x40, 0x0a, 0x12, 0x53, 0x75, 0x62, 0x73, 0x74, 0x69, 0x74, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x62, 0x0a, 0x0b, 0x54, 0x69, 0x6d, 0x69, 0x6e, 0x67,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x3d, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x70, 0x61, 0x6e, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x8c, 0x01, 0x0a, 0x06, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f,
	0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x51, 0x55, 0x45,
	0x55, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x57, 0x4f, 0x52, 0x4b, 0x49, 0x4e, 0x47,
	0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x55, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x03, 0x12,
	0x0b, 0x0a, 0x07, 0x46, 0x41, 0x49, 0x4c, 0x55, 0x52, 0x45, 0x10, 0x04, 0x12, 0x12, 0x0a, 0x0e,
	0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x05,
	0x12, 0x0b, 0x0a, 0x07, 0x54, 0x49, 0x4d, 0x45, 0x4f, 0x55, 0x54, 0x10, 0x06, 0x12, 0x0d, 0x0a,
	0x09, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x07, 0x12, 0x0b, 0x0a, 0x07,
	0x45, 0x58, 0x50, 0x49, 0x52, 0x45, 0x44, 0x10, 0x09, 0x22, 0xfe, 0x01, 0x0a, 0x09, 0x41, 0x72,
	0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x69, 0x6d, 0x61, 0x67, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x12,
	0x52, 0x0a, 0x07, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x2e, 0x41, 0x72, 0x74, 0x69, 0x66,
	0x61, 0x63, 0x74, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x52, 0x07, 0x6f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x1a, 0x84, 0x01, 0x0a, 0x0f, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x70, 0x61, 0x74, 0x68, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x05, 0x70, 0x61, 0x74, 0x68, 0x73, 0x12, 0x3f, 0x0a, 0x06, 0x74, 0x69, 0x6d,
	0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x70,
	0x61, 0x6e, 0x52, 0x06, 0x74, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x22, 0x7c, 0x0a, 0x08, 0x54, 0x69,
	0x6d, 0x65, 0x53, 0x70, 0x61, 0x6e, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x54, 0x0a, 0x16, 0x42, 0x75, 0x69, 0x6c,
	0x64, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x3a, 0x0a, 0x05, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76,
	0x31, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x52, 0x05, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x22, 0xa6,
	0x03, 0x0a, 0x10, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61,
	0x6e, 0x63, 0x65, 0x12, 0x64, 0x0a, 0x17, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x5f,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65,
	0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x52, 0x15, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x53, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x5b, 0x0a, 0x14, 0x72, 0x65, 0x73,
	0x6f, 0x6c, 0x76, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62,
	0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x52, 0x12, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x52, 0x65, 0x70, 0x6f,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x65, 0x0a, 0x0b, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x68,
	0x61, 0x73, 0x68, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x50, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x46, 0x69, 0x6c,
	0x65, 0x48, 0x61, 0x73, 0x68, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x66, 0x69, 0x6c, 0x65, 0x48, 0x61, 0x73, 0x68, 0x65, 0x73, 0x1a, 0x68, 0x0a,
	0x0f, 0x46, 0x69, 0x6c, 0x65, 0x48, 0x61, 0x73, 0x68, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x3f, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76,
	0x31, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x48, 0x61, 0x73, 0x68, 0x65, 0x73, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x4e, 0x0a, 0x0a, 0x46, 0x69, 0x6c, 0x65, 0x48,
	0x61, 0x73, 0x68, 0x65, 0x73, 0x12, 0x40, 0x0a, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x68, 0x61,
	0x73, 0x68, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x61, 0x73, 0x68, 0x52, 0x08, 0x66,
	0x69, 0x6c, 0x65, 0x48, 0x61, 0x73, 0x68, 0x22, 0x89, 0x01, 0x0a, 0x04, 0x48, 0x61, 0x73, 0x68,
	0x12, 0x40, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x48,
	0x61, 0x73, 0x68, 0x2e, 0x48, 0x61, 0x73, 0x68, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x29, 0x0a, 0x08, 0x48, 0x61, 0x73, 0x68,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x00, 0x12, 0x0a,
	0x0a, 0x06, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x4d, 0x44,
	0x35, 0x10, 0x02, 0x22, 0xbd, 0x01, 0x0a, 0x06, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x20,
	0x0a, 0x0c, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x53, 0x0a, 0x0a, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x65, 0x6e, 0x76, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65,
	0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x2e, 0x53, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x45, 0x6e, 0x76, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x09, 0x73, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x45, 0x6e, 0x76, 0x1a, 0x3c, 0x0a, 0x0e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x45,
	0x6e, 0x76, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0x79, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x42, 0x75, 0x69,
	0x6c, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x3f, 0x0a,
	0x05, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x69,
	0x6c, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x22, 0x4a,
	0x0a, 0x0f, 0x47, 0x65, 0x74, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x13, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x02, 0x69, 0x64, 0x22, 0x8b, 0x01, 0x0a, 0x11, 0x4c,
	0x69, 0x73, 0x74, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x7a, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74,
	0x42, 0x75, 0x69, 0x6c, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3c,
	0x0a, 0x06, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x42,
	0x75, 0x69, 0x6c, 0x64, 0x52, 0x06, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x4d, 0x0a, 0x12, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x42, 0x75,
	0x69, 0x6c, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x13,
	0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x02, 0x69, 0x64, 0x22, 0xce, 0x05, 0x0a, 0x0c, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x54, 0x72, 0x69,
	0x67, 0x67, 0x65, 0x72, 0x12, 0x13, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x02, 0x69, 0x64, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x15, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x12, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x13, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x74,
	0x61, 0x67, 0x73, 0x12, 0x54, 0x0a, 0x10, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x5f, 0x74,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x70, 0x6f, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x0f, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65,
	0x72, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x49, 0x0a, 0x06, 0x67, 0x69, 0x74,
	0x68, 0x75, 0x62, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x69, 0x74, 0x48, 0x75, 0x62,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x67, 0x69,
	0x74, 0x68, 0x75, 0x62, 0x12, 0x3c, 0x0a, 0x05, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x48, 0x00, 0x52, 0x05, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x12, 0x1c, 0x0a, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x64,
	0x0a, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x74, 0x69, 0x74, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x54, 0x72, 0x69, 0x67, 0x67,
	0x65, 0x72, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x74, 0x69, 0x74, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x74, 0x69, 0x74, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x64, 0x5f,
	0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x69, 0x67, 0x6e,
	0x6f, 0x72, 0x65, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x69, 0x6e, 0x63,
	0x6c, 0x75, 0x64, 0x65, 0x64, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x10, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0d, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x73,
	0x1a, 0x40, 0x0a, 0x12, 0x53, 0x75, 0x62, 0x73, 0x74, 0x69, 0x74, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x42, 0x10, 0x0a, 0x0e, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x74, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x22, 0x8c, 0x02, 0x0a, 0x12, 0x47, 0x69, 0x74, 0x48, 0x75, 0x62, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2b, 0x0a, 0x0f, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x6f, 0x77, 0x6e, 0x65,
	0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x55, 0x0a, 0x0c, 0x70, 0x75, 0x6c, 0x6c, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x6c, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0b, 0x70, 0x75,
	0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x70, 0x75, 0x73,
	0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62,
	0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x73, 0x68, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x48, 0x00, 0x52, 0x04, 0x70, 0x75, 0x73, 0x68, 0x42, 0x07, 0x0a, 0x05, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x22, 0x84, 0x02, 0x0a, 0x11, 0x50, 0x75, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x18, 0x0a, 0x06, 0x62, 0x72, 0x61,
	0x6e, 0x63, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x06, 0x62, 0x72, 0x61,
	0x6e, 0x63, 0x68, 0x12, 0x68, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x6c,
	0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x43,
	0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x52, 0x0e, 0x63,
	0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x12, 0x21, 0x0a,
	0x0c, 0x69, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x5f, 0x72, 0x65, 0x67, 0x65, 0x78, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0b, 0x69, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x52, 0x65, 0x67, 0x65, 0x78,
	0x22, 0x3d, 0x0a, 0x0e, 0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x12, 0x15, 0x0a, 0x11, 0x43, 0x4f, 0x4d, 0x4d, 0x45, 0x4e, 0x54, 0x53, 0x5f, 0x44,
	0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x4f, 0x4d,
	0x4d, 0x45, 0x4e, 0x54, 0x53, 0x5f, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x42,
	0x09, 0x0a, 0x07, 0x67, 0x69, 0x74, 0x5f, 0x72, 0x65, 0x66, 0x22, 0x68, 0x0a, 0x0a, 0x50, 0x75,
	0x73, 0x68, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x18, 0x0a, 0x06, 0x62, 0x72, 0x61, 0x6e,
	0x63, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x06, 0x62, 0x72, 0x61, 0x6e,
	0x63, 0x68, 0x12, 0x12, 0x0a, 0x03, 0x74, 0x61, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x03, 0x74, 0x61, 0x67, 0x12, 0x21, 0x0a, 0x0c, 0x69, 0x6e, 0x76, 0x65, 0x72, 0x74,
	0x5f, 0x72, 0x65, 0x67, 0x65, 0x78, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x69, 0x6e,
	0x76, 0x65, 0x72, 0x74, 0x52, 0x65, 0x67, 0x65, 0x78, 0x42, 0x09, 0x0a, 0x07, 0x67, 0x69, 0x74,
	0x5f, 0x72, 0x65, 0x66, 0x22, 0x8b, 0x01, 0x0a, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x42,
	0x75, 0x69, 0x6c, 0x64, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x4a, 0x0a, 0x07, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62,
	0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x54, 0x72, 0x69,
	0x67, 0x67, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x74, 0x72, 0x69, 0x67, 0x67,
	0x65, 0x72, 0x22, 0x60, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x54, 0x72,
	0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x22, 0x0a, 0x0a,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64,
	0x12, 0x22, 0x0a, 0x0a, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x74, 0x72, 0x69, 0x67, 0x67,
	0x65, 0x72, 0x49, 0x64, 0x22, 0x7a, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x75, 0x69, 0x6c,
	0x64, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0x8c, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x54, 0x72,
	0x69, 0x67, 0x67, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x47,
	0x0a, 0x08, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31,
	0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x08, 0x74,
	0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0x63, 0x0a, 0x19, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x54, 0x72,
	0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x22, 0x0a, 0x0a,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64,
	0x12, 0x22, 0x0a, 0x0a, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x74, 0x72, 0x69, 0x67, 0x67,
	0x65, 0x72, 0x49, 0x64, 0x22, 0xaf, 0x01, 0x0a, 0x19, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42,
	0x75, 0x69, 0x6c, 0x64, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x0a, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x09, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x49, 0x64, 0x12, 0x4a, 0x0a, 0x07, 0x74, 0x72,
	0x69, 0x67, 0x67, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x69, 0x6c,
	0x64, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x74,
	0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x22, 0xe2, 0x08, 0x0a, 0x0c, 0x42, 0x75, 0x69, 0x6c, 0x64,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x62, 0x0a, 0x16, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x68, 0x61, 0x73,
	0x68, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62,
	0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x61, 0x73, 0x68, 0x2e, 0x48, 0x61, 0x73,
	0x68, 0x54, 0x79, 0x70, 0x65, 0x52, 0x14, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x72, 0x6f,
	0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x48, 0x61, 0x73, 0x68, 0x12, 0x70, 0x0a, 0x17, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x5f,
	0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x69,
	0x6c, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x15, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65,
	0x64, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5a, 0x0a,
	0x0c, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x6d, 0x61,
	0x63, 0x68, 0x69, 0x6e, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x0a, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x12, 0x6f, 0x0a, 0x13, 0x73,
	0x75, 0x62, 0x73, 0x74, 0x69, 0x74, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x74, 0x69, 0x74, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x73, 0x75, 0x62, 0x73, 0x74, 0x69,
	0x74, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x70, 0x0a, 0x14,
	0x6c, 0x6f, 0x67, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x5f, 0x6f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x4c, 0x6f, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x6c, 0x6f, 0x67, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f,
	0x0a, 0x0b, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x12,
	0x51, 0x0a, 0x07, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31,
	0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x4c, 0x6f,
	0x67, 0x67, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x07, 0x6c, 0x6f, 0x67, 0x67, 0x69,
	0x6e, 0x67, 0x12, 0x10, 0x0a, 0x03, 0x65, 0x6e, 0x76, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x03, 0x65, 0x6e, 0x76, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x65,
	0x6e, 0x76, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x45, 0x6e, 0x76, 0x12, 0x3f, 0x0a, 0x07, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x18, 0x0e,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65,
	0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x07, 0x76, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x73, 0x22, 0x2e, 0x0a, 0x0c, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x10, 0x0a, 0x0c, 0x4e, 0x4f, 0x54, 0x5f, 0x56, 0x45, 0x52, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x56, 0x45, 0x52, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x01, 0x22, 0x43, 0x0a, 0x0b, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x4e, 0x31, 0x5f, 0x48, 0x49, 0x47, 0x48, 0x43,
	0x50, 0x55, 0x5f, 0x38, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x4e, 0x31, 0x5f, 0x48, 0x49, 0x47,
	0x48, 0x43, 0x50, 0x55, 0x5f, 0x33, 0x32, 0x10, 0x02, 0x22, 0x35, 0x0a, 0x12, 0x53, 0x75, 0x62,
	0x73, 0x74, 0x69, 0x74, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x0e, 0x0a, 0x0a, 0x4d, 0x55, 0x53, 0x54, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x10, 0x00, 0x12,
	0x0f, 0x0a, 0x0b, 0x41, 0x4c, 0x4c, 0x4f, 0x57, 0x5f, 0x4c, 0x4f, 0x4f, 0x53, 0x45, 0x10, 0x01,
	0x22, 0x47, 0x0a, 0x12, 0x4c, 0x6f, 0x67, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4d,
	0x5f, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x54,
	0x52, 0x45, 0x41, 0x4d, 0x5f, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x53, 0x54, 0x52,
	0x45, 0x41, 0x4d, 0x5f, 0x4f, 0x46, 0x46, 0x10, 0x02, 0x22, 0x40, 0x0a, 0x0b, 0x4c, 0x6f, 0x67,
	0x67, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x17, 0x0a, 0x13, 0x4c, 0x4f, 0x47, 0x47,
	0x49, 0x4e, 0x47, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0a, 0x0a, 0x06, 0x4c, 0x45, 0x47, 0x41, 0x43, 0x59, 0x10, 0x01, 0x12, 0x0c, 0x0a,
	0x08, 0x47, 0x43, 0x53, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x02, 0x22, 0xea, 0x05, 0x0a, 0x0a,
	0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x32, 0x0a,
	0x15, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x45, 0x6d, 0x61, 0x69,
	0x6c, 0x12, 0x21, 0x0a, 0x0c, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x50, 0x0a, 0x0d, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b,
	0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4a, 0x0a, 0x07, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62,
	0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f,
	0x6f, 0x6c, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x72, 0x65, 0x67, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x11,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b,
	0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x48, 0x0a, 0x06, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72,
	0x50, 0x6f, 0x6f, 0x6c, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x22, 0x5b, 0x0a, 0x06, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a,
	0x12, 0x52, 0x45, 0x47, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x53, 0x5f, 0x43, 0x45, 0x4e, 0x54,
	0x52, 0x41, 0x4c, 0x31, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x53, 0x5f, 0x57, 0x45, 0x53,
	0x54, 0x31, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x53, 0x5f, 0x45, 0x41, 0x53, 0x54, 0x31,
	0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x53, 0x5f, 0x45, 0x41, 0x53, 0x54, 0x34, 0x10, 0x04,
	0x22, 0x56, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x54,
	0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01,
	0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0c, 0x0a,
	0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07, 0x44,
	0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x04, 0x22, 0xa7, 0x01, 0x0a, 0x0c, 0x57, 0x6f, 0x72,
	0x6b, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x61, 0x63,
	0x68, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a, 0x0c,
	0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x0a, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x12, 0x40,
	0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x12, 0x10, 0x0a, 0x03, 0x74, 0x61, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x74,
	0x61, 0x67, 0x22, 0x62, 0x0a, 0x07, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x1d, 0x0a,
	0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x18, 0x0a, 0x07,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x75, 0x62, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x22, 0x7d, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4a, 0x0a, 0x0b, 0x77, 0x6f, 0x72,
	0x6b, 0x65, 0x72, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x57,
	0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x0a, 0x77, 0x6f, 0x72, 0x6b, 0x65,
	0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x22, 0x2a, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x57, 0x6f, 0x72, 0x6b,
	0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x2d, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x65,
	0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x79, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72,
	0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x4a, 0x0a, 0x0b, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65,
	0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x52,
	0x0a, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x22, 0x30, 0x0a, 0x16, 0x4c,
	0x69, 0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0x67, 0x0a,
	0x17, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4c, 0x0a, 0x0c, 0x77, 0x6f, 0x72, 0x6b,
	0x65, 0x72, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x57,
	0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x0b, 0x77, 0x6f, 0x72, 0x6b, 0x65,
	0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x32, 0xa1, 0x16, 0x0a, 0x0a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x42, 0x75, 0x69, 0x6c, 0x64, 0x12, 0xc5, 0x01, 0x0a, 0x0b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x42, 0x75, 0x69, 0x6c, 0x64, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x42, 0x75, 0x69, 0x6c,
	0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x29, 0x22,
	0x20, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x73, 0x3a, 0x05, 0x62, 0x75, 0x69, 0x6c, 0x64, 0xda, 0x41, 0x10, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x62, 0x75, 0x69, 0x6c, 0x64, 0xca, 0x41, 0x1f, 0x0a, 0x05,
	0x42, 0x75, 0x69, 0x6c, 0x64, 0x12, 0x16, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x9f, 0x01,
	0x0a, 0x08, 0x47, 0x65, 0x74, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x42, 0x75,
	0x69, 0x6c, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64,
	0x22, 0x3d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x27, 0x12, 0x25, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x69, 0x64, 0x7d, 0x2f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x73, 0x2f, 0x7b, 0x69, 0x64, 0x7d, 0xda,
	0x41, 0x0d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x69, 0x64, 0x12,
	0xaf, 0x01, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x73, 0x12, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x3c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x22, 0x12, 0x20, 0x2f, 0x76, 0x31,
	0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x73, 0xda, 0x41, 0x11,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0xaf, 0x01, 0x0a, 0x0b, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x42, 0x75, 0x69, 0x6c,
	0x64, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65,
	0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x22, 0x47, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x31, 0x22, 0x2c, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x73, 0x2f, 0x7b, 0x69, 0x64, 0x7d, 0x3a, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c,
	0x3a, 0x01, 0x2a, 0xda, 0x41, 0x0d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64,
	0x2c, 0x69, 0x64, 0x12, 0xc7, 0x01, 0x0a, 0x0a, 0x52, 0x65, 0x74, 0x72, 0x79, 0x42, 0x75, 0x69,
	0x6c, 0x64, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x79, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x68, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x22, 0x2b, 0x2f, 0x76, 0x31,
	0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x73, 0x2f, 0x7b, 0x69,
	0x64, 0x7d, 0x3a, 0x72, 0x65, 0x74, 0x72, 0x79, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x0d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x69, 0x64, 0xca, 0x41, 0x1f, 0x0a, 0x05,
	0x42, 0x75, 0x69, 0x6c, 0x64, 0x12, 0x16, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xc5, 0x01,
	0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x54, 0x72, 0x69,
	0x67, 0x67, 0x65, 0x72, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65,
	0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x42, 0x75, 0x69, 0x6c, 0x64,
	0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x42,
	0x75, 0x69, 0x6c, 0x64, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x22, 0x48, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x2d, 0x22, 0x22, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x74,
	0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x73, 0x3a, 0x07, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72,
	0xda, 0x41, 0x12, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x74, 0x72,
	0x69, 0x67, 0x67, 0x65, 0x72, 0x12, 0xc6, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x42, 0x75, 0x69,
	0x6c, 0x64, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x42, 0x75, 0x69,
	0x6c, 0x64, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31,
	0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x22, 0x4f, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d,
	0x2f, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x74, 0x72, 0x69, 0x67, 0x67,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x7d, 0xda, 0x41, 0x15, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x69, 0x64, 0x2c, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x12, 0xbf,
	0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x54, 0x72, 0x69, 0x67,
	0x67, 0x65, 0x72, 0x73, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65,
	0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x54, 0x72,
	0x69, 0x67, 0x67, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x37, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x24, 0x12,
	0x22, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x74, 0x72, 0x69, 0x67, 0x67,
	0x65, 0x72, 0x73, 0xda, 0x41, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64,
	0x12, 0xb7, 0x01, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x75, 0x69, 0x6c, 0x64,
	0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62,
	0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x75,
	0x69, 0x6c, 0x64, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x4f, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x31, 0x2a, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x74, 0x72, 0x69,
	0x67, 0x67, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x5f, 0x69,
	0x64, 0x7d, 0xda, 0x41, 0x15, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c,
	0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x12, 0xdd, 0x01, 0x0a, 0x12, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65,
	0x72, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76,
	0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x54, 0x72, 0x69,
	0x67, 0x67, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x69, 0x6c,
	0x64, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x22, 0x60, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a,
	0x32, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x74, 0x72, 0x69, 0x67,
	0x67, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x7d, 0x3a, 0x07, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0xda, 0x41, 0x1d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x5f,
	0x69, 0x64, 0x2c, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x12, 0xee, 0x01, 0x0a, 0x0f, 0x52,
	0x75, 0x6e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x12, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x75, 0x6e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x84, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x22, 0x33, 0x2f,
	0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72,
	0x73, 0x2f, 0x7b, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x7d, 0x3a, 0x72,
	0x75, 0x6e, 0x3a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0xda, 0x41, 0x1c, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x5f,
	0x69, 0x64, 0x2c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0xca, 0x41, 0x1f, 0x0a, 0x05, 0x42, 0x75,
	0x69, 0x6c, 0x64, 0x12, 0x16, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x77, 0x0a, 0x10, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x12,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62,
	0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f,
	0x6f, 0x6c, 0x22, 0x00, 0x12, 0x71, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x65,
	0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50,
	0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x65,
	0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x22, 0x00, 0x12, 0x64, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x00, 0x12, 0x77, 0x0a,
	0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f,
	0x6c, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76,
	0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f,
	0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72,
	0x50, 0x6f, 0x6f, 0x6c, 0x22, 0x00, 0x12, 0x82, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x57,
	0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x57,
	0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x1a, 0x4d, 0xca, 0x41, 0x19,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70,
	0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x86, 0x01, 0x0a, 0x18, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62,
	0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x31, 0x50, 0x01, 0x5a, 0x47, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62,
	0x75, 0x69, 0x6c, 0x64, 0x2f, 0x76, 0x31, 0x3b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0xa2, 0x02, 0x03, 0x47, 0x43, 0x42, 0xea, 0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x3a,
	0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescOnce sync.Once
	file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescData = file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDesc
)

func file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescGZIP() []byte {
	file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescOnce.Do(func() {
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescData)
	})
	return file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDescData
}

var file_google_devtools_cloudbuild_v1_cloudbuild_proto_enumTypes = make([]protoimpl.EnumInfo, 10)
var file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes = make([]protoimpl.MessageInfo, 50)
var file_google_devtools_cloudbuild_v1_cloudbuild_proto_goTypes = []interface{}{
	(Build_Status)(0),                     // 0: google.devtools.cloudbuild.v1.Build.Status
	(Hash_HashType)(0),                    // 1: google.devtools.cloudbuild.v1.Hash.HashType
	(PullRequestFilter_CommentControl)(0), // 2: google.devtools.cloudbuild.v1.PullRequestFilter.CommentControl
	(BuildOptions_VerifyOption)(0),        // 3: google.devtools.cloudbuild.v1.BuildOptions.VerifyOption
	(BuildOptions_MachineType)(0),         // 4: google.devtools.cloudbuild.v1.BuildOptions.MachineType
	(BuildOptions_SubstitutionOption)(0),  // 5: google.devtools.cloudbuild.v1.BuildOptions.SubstitutionOption
	(BuildOptions_LogStreamingOption)(0),  // 6: google.devtools.cloudbuild.v1.BuildOptions.LogStreamingOption
	(BuildOptions_LoggingMode)(0),         // 7: google.devtools.cloudbuild.v1.BuildOptions.LoggingMode
	(WorkerPool_Region)(0),                // 8: google.devtools.cloudbuild.v1.WorkerPool.Region
	(WorkerPool_Status)(0),                // 9: google.devtools.cloudbuild.v1.WorkerPool.Status
	(*RetryBuildRequest)(nil),             // 10: google.devtools.cloudbuild.v1.RetryBuildRequest
	(*RunBuildTriggerRequest)(nil),        // 11: google.devtools.cloudbuild.v1.RunBuildTriggerRequest
	(*StorageSource)(nil),                 // 12: google.devtools.cloudbuild.v1.StorageSource
	(*RepoSource)(nil),                    // 13: google.devtools.cloudbuild.v1.RepoSource
	(*Source)(nil),                        // 14: google.devtools.cloudbuild.v1.Source
	(*BuiltImage)(nil),                    // 15: google.devtools.cloudbuild.v1.BuiltImage
	(*BuildStep)(nil),                     // 16: google.devtools.cloudbuild.v1.BuildStep
	(*Volume)(nil),                        // 17: google.devtools.cloudbuild.v1.Volume
	(*Results)(nil),                       // 18: google.devtools.cloudbuild.v1.Results
	(*ArtifactResult)(nil),                // 19: google.devtools.cloudbuild.v1.ArtifactResult
	(*Build)(nil),                         // 20: google.devtools.cloudbuild.v1.Build
	(*Artifacts)(nil),                     // 21: google.devtools.cloudbuild.v1.Artifacts
	(*TimeSpan)(nil),                      // 22: google.devtools.cloudbuild.v1.TimeSpan
	(*BuildOperationMetadata)(nil),        // 23: google.devtools.cloudbuild.v1.BuildOperationMetadata
	(*SourceProvenance)(nil),              // 24: google.devtools.cloudbuild.v1.SourceProvenance
	(*FileHashes)(nil),                    // 25: google.devtools.cloudbuild.v1.FileHashes
	(*Hash)(nil),                          // 26: google.devtools.cloudbuild.v1.Hash
	(*Secret)(nil),                        // 27: google.devtools.cloudbuild.v1.Secret
	(*CreateBuildRequest)(nil),            // 28: google.devtools.cloudbuild.v1.CreateBuildRequest
	(*GetBuildRequest)(nil),               // 29: google.devtools.cloudbuild.v1.GetBuildRequest
	(*ListBuildsRequest)(nil),             // 30: google.devtools.cloudbuild.v1.ListBuildsRequest
	(*ListBuildsResponse)(nil),            // 31: google.devtools.cloudbuild.v1.ListBuildsResponse
	(*CancelBuildRequest)(nil),            // 32: google.devtools.cloudbuild.v1.CancelBuildRequest
	(*BuildTrigger)(nil),                  // 33: google.devtools.cloudbuild.v1.BuildTrigger
	(*GitHubEventsConfig)(nil),            // 34: google.devtools.cloudbuild.v1.GitHubEventsConfig
	(*PullRequestFilter)(nil),             // 35: google.devtools.cloudbuild.v1.PullRequestFilter
	(*PushFilter)(nil),                    // 36: google.devtools.cloudbuild.v1.PushFilter
	(*CreateBuildTriggerRequest)(nil),     // 37: google.devtools.cloudbuild.v1.CreateBuildTriggerRequest
	(*GetBuildTriggerRequest)(nil),        // 38: google.devtools.cloudbuild.v1.GetBuildTriggerRequest
	(*ListBuildTriggersRequest)(nil),      // 39: google.devtools.cloudbuild.v1.ListBuildTriggersRequest
	(*ListBuildTriggersResponse)(nil),     // 40: google.devtools.cloudbuild.v1.ListBuildTriggersResponse
	(*DeleteBuildTriggerRequest)(nil),     // 41: google.devtools.cloudbuild.v1.DeleteBuildTriggerRequest
	(*UpdateBuildTriggerRequest)(nil),     // 42: google.devtools.cloudbuild.v1.UpdateBuildTriggerRequest
	(*BuildOptions)(nil),                  // 43: google.devtools.cloudbuild.v1.BuildOptions
	(*WorkerPool)(nil),                    // 44: google.devtools.cloudbuild.v1.WorkerPool
	(*WorkerConfig)(nil),                  // 45: google.devtools.cloudbuild.v1.WorkerConfig
	(*Network)(nil),                       // 46: google.devtools.cloudbuild.v1.Network
	(*CreateWorkerPoolRequest)(nil),       // 47: google.devtools.cloudbuild.v1.CreateWorkerPoolRequest
	(*GetWorkerPoolRequest)(nil),          // 48: google.devtools.cloudbuild.v1.GetWorkerPoolRequest
	(*DeleteWorkerPoolRequest)(nil),       // 49: google.devtools.cloudbuild.v1.DeleteWorkerPoolRequest
	(*UpdateWorkerPoolRequest)(nil),       // 50: google.devtools.cloudbuild.v1.UpdateWorkerPoolRequest
	(*ListWorkerPoolsRequest)(nil),        // 51: google.devtools.cloudbuild.v1.ListWorkerPoolsRequest
	(*ListWorkerPoolsResponse)(nil),       // 52: google.devtools.cloudbuild.v1.ListWorkerPoolsResponse
	nil,                                   // 53: google.devtools.cloudbuild.v1.RepoSource.SubstitutionsEntry
	nil,                                   // 54: google.devtools.cloudbuild.v1.Build.SubstitutionsEntry
	nil,                                   // 55: google.devtools.cloudbuild.v1.Build.TimingEntry
	(*Artifacts_ArtifactObjects)(nil),     // 56: google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects
	nil,                                   // 57: google.devtools.cloudbuild.v1.SourceProvenance.FileHashesEntry
	nil,                                   // 58: google.devtools.cloudbuild.v1.Secret.SecretEnvEntry
	nil,                                   // 59: google.devtools.cloudbuild.v1.BuildTrigger.SubstitutionsEntry
	(*duration.Duration)(nil),             // 60: google.protobuf.Duration
	(*timestamp.Timestamp)(nil),           // 61: google.protobuf.Timestamp
	(*longrunning.Operation)(nil),         // 62: google.longrunning.Operation
	(*empty.Empty)(nil),                   // 63: google.protobuf.Empty
}
var file_google_devtools_cloudbuild_v1_cloudbuild_proto_depIdxs = []int32{
	13, // 0: google.devtools.cloudbuild.v1.RunBuildTriggerRequest.source:type_name -> google.devtools.cloudbuild.v1.RepoSource
	53, // 1: google.devtools.cloudbuild.v1.RepoSource.substitutions:type_name -> google.devtools.cloudbuild.v1.RepoSource.SubstitutionsEntry
	12, // 2: google.devtools.cloudbuild.v1.Source.storage_source:type_name -> google.devtools.cloudbuild.v1.StorageSource
	13, // 3: google.devtools.cloudbuild.v1.Source.repo_source:type_name -> google.devtools.cloudbuild.v1.RepoSource
	22, // 4: google.devtools.cloudbuild.v1.BuiltImage.push_timing:type_name -> google.devtools.cloudbuild.v1.TimeSpan
	17, // 5: google.devtools.cloudbuild.v1.BuildStep.volumes:type_name -> google.devtools.cloudbuild.v1.Volume
	22, // 6: google.devtools.cloudbuild.v1.BuildStep.timing:type_name -> google.devtools.cloudbuild.v1.TimeSpan
	22, // 7: google.devtools.cloudbuild.v1.BuildStep.pull_timing:type_name -> google.devtools.cloudbuild.v1.TimeSpan
	60, // 8: google.devtools.cloudbuild.v1.BuildStep.timeout:type_name -> google.protobuf.Duration
	0,  // 9: google.devtools.cloudbuild.v1.BuildStep.status:type_name -> google.devtools.cloudbuild.v1.Build.Status
	15, // 10: google.devtools.cloudbuild.v1.Results.images:type_name -> google.devtools.cloudbuild.v1.BuiltImage
	22, // 11: google.devtools.cloudbuild.v1.Results.artifact_timing:type_name -> google.devtools.cloudbuild.v1.TimeSpan
	25, // 12: google.devtools.cloudbuild.v1.ArtifactResult.file_hash:type_name -> google.devtools.cloudbuild.v1.FileHashes
	0,  // 13: google.devtools.cloudbuild.v1.Build.status:type_name -> google.devtools.cloudbuild.v1.Build.Status
	14, // 14: google.devtools.cloudbuild.v1.Build.source:type_name -> google.devtools.cloudbuild.v1.Source
	16, // 15: google.devtools.cloudbuild.v1.Build.steps:type_name -> google.devtools.cloudbuild.v1.BuildStep
	18, // 16: google.devtools.cloudbuild.v1.Build.results:type_name -> google.devtools.cloudbuild.v1.Results
	61, // 17: google.devtools.cloudbuild.v1.Build.create_time:type_name -> google.protobuf.Timestamp
	61, // 18: google.devtools.cloudbuild.v1.Build.start_time:type_name -> google.protobuf.Timestamp
	61, // 19: google.devtools.cloudbuild.v1.Build.finish_time:type_name -> google.protobuf.Timestamp
	60, // 20: google.devtools.cloudbuild.v1.Build.timeout:type_name -> google.protobuf.Duration
	60, // 21: google.devtools.cloudbuild.v1.Build.queue_ttl:type_name -> google.protobuf.Duration
	21, // 22: google.devtools.cloudbuild.v1.Build.artifacts:type_name -> google.devtools.cloudbuild.v1.Artifacts
	24, // 23: google.devtools.cloudbuild.v1.Build.source_provenance:type_name -> google.devtools.cloudbuild.v1.SourceProvenance
	43, // 24: google.devtools.cloudbuild.v1.Build.options:type_name -> google.devtools.cloudbuild.v1.BuildOptions
	54, // 25: google.devtools.cloudbuild.v1.Build.substitutions:type_name -> google.devtools.cloudbuild.v1.Build.SubstitutionsEntry
	27, // 26: google.devtools.cloudbuild.v1.Build.secrets:type_name -> google.devtools.cloudbuild.v1.Secret
	55, // 27: google.devtools.cloudbuild.v1.Build.timing:type_name -> google.devtools.cloudbuild.v1.Build.TimingEntry
	56, // 28: google.devtools.cloudbuild.v1.Artifacts.objects:type_name -> google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects
	61, // 29: google.devtools.cloudbuild.v1.TimeSpan.start_time:type_name -> google.protobuf.Timestamp
	61, // 30: google.devtools.cloudbuild.v1.TimeSpan.end_time:type_name -> google.protobuf.Timestamp
	20, // 31: google.devtools.cloudbuild.v1.BuildOperationMetadata.build:type_name -> google.devtools.cloudbuild.v1.Build
	12, // 32: google.devtools.cloudbuild.v1.SourceProvenance.resolved_storage_source:type_name -> google.devtools.cloudbuild.v1.StorageSource
	13, // 33: google.devtools.cloudbuild.v1.SourceProvenance.resolved_repo_source:type_name -> google.devtools.cloudbuild.v1.RepoSource
	57, // 34: google.devtools.cloudbuild.v1.SourceProvenance.file_hashes:type_name -> google.devtools.cloudbuild.v1.SourceProvenance.FileHashesEntry
	26, // 35: google.devtools.cloudbuild.v1.FileHashes.file_hash:type_name -> google.devtools.cloudbuild.v1.Hash
	1,  // 36: google.devtools.cloudbuild.v1.Hash.type:type_name -> google.devtools.cloudbuild.v1.Hash.HashType
	58, // 37: google.devtools.cloudbuild.v1.Secret.secret_env:type_name -> google.devtools.cloudbuild.v1.Secret.SecretEnvEntry
	20, // 38: google.devtools.cloudbuild.v1.CreateBuildRequest.build:type_name -> google.devtools.cloudbuild.v1.Build
	20, // 39: google.devtools.cloudbuild.v1.ListBuildsResponse.builds:type_name -> google.devtools.cloudbuild.v1.Build
	13, // 40: google.devtools.cloudbuild.v1.BuildTrigger.trigger_template:type_name -> google.devtools.cloudbuild.v1.RepoSource
	34, // 41: google.devtools.cloudbuild.v1.BuildTrigger.github:type_name -> google.devtools.cloudbuild.v1.GitHubEventsConfig
	20, // 42: google.devtools.cloudbuild.v1.BuildTrigger.build:type_name -> google.devtools.cloudbuild.v1.Build
	61, // 43: google.devtools.cloudbuild.v1.BuildTrigger.create_time:type_name -> google.protobuf.Timestamp
	59, // 44: google.devtools.cloudbuild.v1.BuildTrigger.substitutions:type_name -> google.devtools.cloudbuild.v1.BuildTrigger.SubstitutionsEntry
	35, // 45: google.devtools.cloudbuild.v1.GitHubEventsConfig.pull_request:type_name -> google.devtools.cloudbuild.v1.PullRequestFilter
	36, // 46: google.devtools.cloudbuild.v1.GitHubEventsConfig.push:type_name -> google.devtools.cloudbuild.v1.PushFilter
	2,  // 47: google.devtools.cloudbuild.v1.PullRequestFilter.comment_control:type_name -> google.devtools.cloudbuild.v1.PullRequestFilter.CommentControl
	33, // 48: google.devtools.cloudbuild.v1.CreateBuildTriggerRequest.trigger:type_name -> google.devtools.cloudbuild.v1.BuildTrigger
	33, // 49: google.devtools.cloudbuild.v1.ListBuildTriggersResponse.triggers:type_name -> google.devtools.cloudbuild.v1.BuildTrigger
	33, // 50: google.devtools.cloudbuild.v1.UpdateBuildTriggerRequest.trigger:type_name -> google.devtools.cloudbuild.v1.BuildTrigger
	1,  // 51: google.devtools.cloudbuild.v1.BuildOptions.source_provenance_hash:type_name -> google.devtools.cloudbuild.v1.Hash.HashType
	3,  // 52: google.devtools.cloudbuild.v1.BuildOptions.requested_verify_option:type_name -> google.devtools.cloudbuild.v1.BuildOptions.VerifyOption
	4,  // 53: google.devtools.cloudbuild.v1.BuildOptions.machine_type:type_name -> google.devtools.cloudbuild.v1.BuildOptions.MachineType
	5,  // 54: google.devtools.cloudbuild.v1.BuildOptions.substitution_option:type_name -> google.devtools.cloudbuild.v1.BuildOptions.SubstitutionOption
	6,  // 55: google.devtools.cloudbuild.v1.BuildOptions.log_streaming_option:type_name -> google.devtools.cloudbuild.v1.BuildOptions.LogStreamingOption
	7,  // 56: google.devtools.cloudbuild.v1.BuildOptions.logging:type_name -> google.devtools.cloudbuild.v1.BuildOptions.LoggingMode
	17, // 57: google.devtools.cloudbuild.v1.BuildOptions.volumes:type_name -> google.devtools.cloudbuild.v1.Volume
	45, // 58: google.devtools.cloudbuild.v1.WorkerPool.worker_config:type_name -> google.devtools.cloudbuild.v1.WorkerConfig
	8,  // 59: google.devtools.cloudbuild.v1.WorkerPool.regions:type_name -> google.devtools.cloudbuild.v1.WorkerPool.Region
	61, // 60: google.devtools.cloudbuild.v1.WorkerPool.create_time:type_name -> google.protobuf.Timestamp
	61, // 61: google.devtools.cloudbuild.v1.WorkerPool.update_time:type_name -> google.protobuf.Timestamp
	61, // 62: google.devtools.cloudbuild.v1.WorkerPool.delete_time:type_name -> google.protobuf.Timestamp
	9,  // 63: google.devtools.cloudbuild.v1.WorkerPool.status:type_name -> google.devtools.cloudbuild.v1.WorkerPool.Status
	46, // 64: google.devtools.cloudbuild.v1.WorkerConfig.network:type_name -> google.devtools.cloudbuild.v1.Network
	44, // 65: google.devtools.cloudbuild.v1.CreateWorkerPoolRequest.worker_pool:type_name -> google.devtools.cloudbuild.v1.WorkerPool
	44, // 66: google.devtools.cloudbuild.v1.UpdateWorkerPoolRequest.worker_pool:type_name -> google.devtools.cloudbuild.v1.WorkerPool
	44, // 67: google.devtools.cloudbuild.v1.ListWorkerPoolsResponse.worker_pools:type_name -> google.devtools.cloudbuild.v1.WorkerPool
	22, // 68: google.devtools.cloudbuild.v1.Build.TimingEntry.value:type_name -> google.devtools.cloudbuild.v1.TimeSpan
	22, // 69: google.devtools.cloudbuild.v1.Artifacts.ArtifactObjects.timing:type_name -> google.devtools.cloudbuild.v1.TimeSpan
	25, // 70: google.devtools.cloudbuild.v1.SourceProvenance.FileHashesEntry.value:type_name -> google.devtools.cloudbuild.v1.FileHashes
	28, // 71: google.devtools.cloudbuild.v1.CloudBuild.CreateBuild:input_type -> google.devtools.cloudbuild.v1.CreateBuildRequest
	29, // 72: google.devtools.cloudbuild.v1.CloudBuild.GetBuild:input_type -> google.devtools.cloudbuild.v1.GetBuildRequest
	30, // 73: google.devtools.cloudbuild.v1.CloudBuild.ListBuilds:input_type -> google.devtools.cloudbuild.v1.ListBuildsRequest
	32, // 74: google.devtools.cloudbuild.v1.CloudBuild.CancelBuild:input_type -> google.devtools.cloudbuild.v1.CancelBuildRequest
	10, // 75: google.devtools.cloudbuild.v1.CloudBuild.RetryBuild:input_type -> google.devtools.cloudbuild.v1.RetryBuildRequest
	37, // 76: google.devtools.cloudbuild.v1.CloudBuild.CreateBuildTrigger:input_type -> google.devtools.cloudbuild.v1.CreateBuildTriggerRequest
	38, // 77: google.devtools.cloudbuild.v1.CloudBuild.GetBuildTrigger:input_type -> google.devtools.cloudbuild.v1.GetBuildTriggerRequest
	39, // 78: google.devtools.cloudbuild.v1.CloudBuild.ListBuildTriggers:input_type -> google.devtools.cloudbuild.v1.ListBuildTriggersRequest
	41, // 79: google.devtools.cloudbuild.v1.CloudBuild.DeleteBuildTrigger:input_type -> google.devtools.cloudbuild.v1.DeleteBuildTriggerRequest
	42, // 80: google.devtools.cloudbuild.v1.CloudBuild.UpdateBuildTrigger:input_type -> google.devtools.cloudbuild.v1.UpdateBuildTriggerRequest
	11, // 81: google.devtools.cloudbuild.v1.CloudBuild.RunBuildTrigger:input_type -> google.devtools.cloudbuild.v1.RunBuildTriggerRequest
	47, // 82: google.devtools.cloudbuild.v1.CloudBuild.CreateWorkerPool:input_type -> google.devtools.cloudbuild.v1.CreateWorkerPoolRequest
	48, // 83: google.devtools.cloudbuild.v1.CloudBuild.GetWorkerPool:input_type -> google.devtools.cloudbuild.v1.GetWorkerPoolRequest
	49, // 84: google.devtools.cloudbuild.v1.CloudBuild.DeleteWorkerPool:input_type -> google.devtools.cloudbuild.v1.DeleteWorkerPoolRequest
	50, // 85: google.devtools.cloudbuild.v1.CloudBuild.UpdateWorkerPool:input_type -> google.devtools.cloudbuild.v1.UpdateWorkerPoolRequest
	51, // 86: google.devtools.cloudbuild.v1.CloudBuild.ListWorkerPools:input_type -> google.devtools.cloudbuild.v1.ListWorkerPoolsRequest
	62, // 87: google.devtools.cloudbuild.v1.CloudBuild.CreateBuild:output_type -> google.longrunning.Operation
	20, // 88: google.devtools.cloudbuild.v1.CloudBuild.GetBuild:output_type -> google.devtools.cloudbuild.v1.Build
	31, // 89: google.devtools.cloudbuild.v1.CloudBuild.ListBuilds:output_type -> google.devtools.cloudbuild.v1.ListBuildsResponse
	20, // 90: google.devtools.cloudbuild.v1.CloudBuild.CancelBuild:output_type -> google.devtools.cloudbuild.v1.Build
	62, // 91: google.devtools.cloudbuild.v1.CloudBuild.RetryBuild:output_type -> google.longrunning.Operation
	33, // 92: google.devtools.cloudbuild.v1.CloudBuild.CreateBuildTrigger:output_type -> google.devtools.cloudbuild.v1.BuildTrigger
	33, // 93: google.devtools.cloudbuild.v1.CloudBuild.GetBuildTrigger:output_type -> google.devtools.cloudbuild.v1.BuildTrigger
	40, // 94: google.devtools.cloudbuild.v1.CloudBuild.ListBuildTriggers:output_type -> google.devtools.cloudbuild.v1.ListBuildTriggersResponse
	63, // 95: google.devtools.cloudbuild.v1.CloudBuild.DeleteBuildTrigger:output_type -> google.protobuf.Empty
	33, // 96: google.devtools.cloudbuild.v1.CloudBuild.UpdateBuildTrigger:output_type -> google.devtools.cloudbuild.v1.BuildTrigger
	62, // 97: google.devtools.cloudbuild.v1.CloudBuild.RunBuildTrigger:output_type -> google.longrunning.Operation
	44, // 98: google.devtools.cloudbuild.v1.CloudBuild.CreateWorkerPool:output_type -> google.devtools.cloudbuild.v1.WorkerPool
	44, // 99: google.devtools.cloudbuild.v1.CloudBuild.GetWorkerPool:output_type -> google.devtools.cloudbuild.v1.WorkerPool
	63, // 100: google.devtools.cloudbuild.v1.CloudBuild.DeleteWorkerPool:output_type -> google.protobuf.Empty
	44, // 101: google.devtools.cloudbuild.v1.CloudBuild.UpdateWorkerPool:output_type -> google.devtools.cloudbuild.v1.WorkerPool
	52, // 102: google.devtools.cloudbuild.v1.CloudBuild.ListWorkerPools:output_type -> google.devtools.cloudbuild.v1.ListWorkerPoolsResponse
	87, // [87:103] is the sub-list for method output_type
	71, // [71:87] is the sub-list for method input_type
	71, // [71:71] is the sub-list for extension type_name
	71, // [71:71] is the sub-list for extension extendee
	0,  // [0:71] is the sub-list for field type_name
}

func init() { file_google_devtools_cloudbuild_v1_cloudbuild_proto_init() }
func file_google_devtools_cloudbuild_v1_cloudbuild_proto_init() {
	if File_google_devtools_cloudbuild_v1_cloudbuild_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RetryBuildRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunBuildTriggerRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StorageSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RepoSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Source); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BuiltImage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BuildStep); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Volume); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Results); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArtifactResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Build); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Artifacts); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimeSpan); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BuildOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SourceProvenance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FileHashes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Hash); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Secret); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateBuildRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetBuildRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBuildsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBuildsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CancelBuildRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BuildTrigger); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GitHubEventsConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PullRequestFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PushFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateBuildTriggerRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetBuildTriggerRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBuildTriggersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBuildTriggersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteBuildTriggerRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateBuildTriggerRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BuildOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkerPool); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkerConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Network); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateWorkerPoolRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetWorkerPoolRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteWorkerPoolRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateWorkerPoolRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListWorkerPoolsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListWorkerPoolsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Artifacts_ArtifactObjects); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*RepoSource_BranchName)(nil),
		(*RepoSource_TagName)(nil),
		(*RepoSource_CommitSha)(nil),
	}
	file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*Source_StorageSource)(nil),
		(*Source_RepoSource)(nil),
	}
	file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[23].OneofWrappers = []interface{}{
		(*BuildTrigger_Build)(nil),
		(*BuildTrigger_Filename)(nil),
	}
	file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[24].OneofWrappers = []interface{}{
		(*GitHubEventsConfig_PullRequest)(nil),
		(*GitHubEventsConfig_Push)(nil),
	}
	file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[25].OneofWrappers = []interface{}{
		(*PullRequestFilter_Branch)(nil),
	}
	file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes[26].OneofWrappers = []interface{}{
		(*PushFilter_Branch)(nil),
		(*PushFilter_Tag)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDesc,
			NumEnums:      10,
			NumMessages:   50,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_devtools_cloudbuild_v1_cloudbuild_proto_goTypes,
		DependencyIndexes: file_google_devtools_cloudbuild_v1_cloudbuild_proto_depIdxs,
		EnumInfos:         file_google_devtools_cloudbuild_v1_cloudbuild_proto_enumTypes,
		MessageInfos:      file_google_devtools_cloudbuild_v1_cloudbuild_proto_msgTypes,
	}.Build()
	File_google_devtools_cloudbuild_v1_cloudbuild_proto = out.File
	file_google_devtools_cloudbuild_v1_cloudbuild_proto_rawDesc = nil
	file_google_devtools_cloudbuild_v1_cloudbuild_proto_goTypes = nil
	file_google_devtools_cloudbuild_v1_cloudbuild_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CloudBuildClient is the client API for CloudBuild service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CloudBuildClient interface {
	// Starts a build with the specified configuration.
	//
	// This method returns a long-running `Operation`, which includes the build
	// ID. Pass the build ID to `GetBuild` to determine the build status (such as
	// `SUCCESS` or `FAILURE`).
	CreateBuild(ctx context.Context, in *CreateBuildRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Returns information about a previously requested build.
	//
	// The `Build` that is returned includes its status (such as `SUCCESS`,
	// `FAILURE`, or `WORKING`), and timing information.
	GetBuild(ctx context.Context, in *GetBuildRequest, opts ...grpc.CallOption) (*Build, error)
	// Lists previously requested builds.
	//
	// Previously requested builds may still be in-progress, or may have finished
	// successfully or unsuccessfully.
	ListBuilds(ctx context.Context, in *ListBuildsRequest, opts ...grpc.CallOption) (*ListBuildsResponse, error)
	// Cancels a build in progress.
	CancelBuild(ctx context.Context, in *CancelBuildRequest, opts ...grpc.CallOption) (*Build, error)
	// Creates a new build based on the specified build.
	//
	// This method creates a new build using the original build request, which may
	// or may not result in an identical build.
	//
	// For triggered builds:
	//
	// * Triggered builds resolve to a precise revision; therefore a retry of a
	// triggered build will result in a build that uses the same revision.
	//
	// For non-triggered builds that specify `RepoSource`:
	//
	// * If the original build built from the tip of a branch, the retried build
	// will build from the tip of that branch, which may not be the same revision
	// as the original build.
	// * If the original build specified a commit sha or revision ID, the retried
	// build will use the identical source.
	//
	// For builds that specify `StorageSource`:
	//
	// * If the original build pulled source from Google Cloud Storage without
	// specifying the generation of the object, the new build will use the current
	// object, which may be different from the original build source.
	// * If the original build pulled source from Cloud Storage and specified the
	// generation of the object, the new build will attempt to use the same
	// object, which may or may not be available depending on the bucket's
	// lifecycle management settings.
	RetryBuild(ctx context.Context, in *RetryBuildRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Creates a new `BuildTrigger`.
	//
	// This API is experimental.
	CreateBuildTrigger(ctx context.Context, in *CreateBuildTriggerRequest, opts ...grpc.CallOption) (*BuildTrigger, error)
	// Returns information about a `BuildTrigger`.
	//
	// This API is experimental.
	GetBuildTrigger(ctx context.Context, in *GetBuildTriggerRequest, opts ...grpc.CallOption) (*BuildTrigger, error)
	// Lists existing `BuildTrigger`s.
	//
	// This API is experimental.
	ListBuildTriggers(ctx context.Context, in *ListBuildTriggersRequest, opts ...grpc.CallOption) (*ListBuildTriggersResponse, error)
	// Deletes a `BuildTrigger` by its project ID and trigger ID.
	//
	// This API is experimental.
	DeleteBuildTrigger(ctx context.Context, in *DeleteBuildTriggerRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Updates a `BuildTrigger` by its project ID and trigger ID.
	//
	// This API is experimental.
	UpdateBuildTrigger(ctx context.Context, in *UpdateBuildTriggerRequest, opts ...grpc.CallOption) (*BuildTrigger, error)
	// Runs a `BuildTrigger` at a particular source revision.
	RunBuildTrigger(ctx context.Context, in *RunBuildTriggerRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Creates a `WorkerPool` to run the builds, and returns the new worker pool.
	//
	// This API is experimental.
	CreateWorkerPool(ctx context.Context, in *CreateWorkerPoolRequest, opts ...grpc.CallOption) (*WorkerPool, error)
	// Returns information about a `WorkerPool`.
	//
	// This API is experimental.
	GetWorkerPool(ctx context.Context, in *GetWorkerPoolRequest, opts ...grpc.CallOption) (*WorkerPool, error)
	// Deletes a `WorkerPool` by its project ID and WorkerPool name.
	//
	// This API is experimental.
	DeleteWorkerPool(ctx context.Context, in *DeleteWorkerPoolRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Update a `WorkerPool`.
	//
	// This API is experimental.
	UpdateWorkerPool(ctx context.Context, in *UpdateWorkerPoolRequest, opts ...grpc.CallOption) (*WorkerPool, error)
	// List project's `WorkerPools`.
	//
	// This API is experimental.
	ListWorkerPools(ctx context.Context, in *ListWorkerPoolsRequest, opts ...grpc.CallOption) (*ListWorkerPoolsResponse, error)
}

type cloudBuildClient struct {
	cc grpc.ClientConnInterface
}

func NewCloudBuildClient(cc grpc.ClientConnInterface) CloudBuildClient {
	return &cloudBuildClient{cc}
}

func (c *cloudBuildClient) CreateBuild(ctx context.Context, in *CreateBuildRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/CreateBuild", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) GetBuild(ctx context.Context, in *GetBuildRequest, opts ...grpc.CallOption) (*Build, error) {
	out := new(Build)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/GetBuild", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) ListBuilds(ctx context.Context, in *ListBuildsRequest, opts ...grpc.CallOption) (*ListBuildsResponse, error) {
	out := new(ListBuildsResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/ListBuilds", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) CancelBuild(ctx context.Context, in *CancelBuildRequest, opts ...grpc.CallOption) (*Build, error) {
	out := new(Build)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/CancelBuild", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) RetryBuild(ctx context.Context, in *RetryBuildRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/RetryBuild", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) CreateBuildTrigger(ctx context.Context, in *CreateBuildTriggerRequest, opts ...grpc.CallOption) (*BuildTrigger, error) {
	out := new(BuildTrigger)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/CreateBuildTrigger", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) GetBuildTrigger(ctx context.Context, in *GetBuildTriggerRequest, opts ...grpc.CallOption) (*BuildTrigger, error) {
	out := new(BuildTrigger)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/GetBuildTrigger", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) ListBuildTriggers(ctx context.Context, in *ListBuildTriggersRequest, opts ...grpc.CallOption) (*ListBuildTriggersResponse, error) {
	out := new(ListBuildTriggersResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/ListBuildTriggers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) DeleteBuildTrigger(ctx context.Context, in *DeleteBuildTriggerRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/DeleteBuildTrigger", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) UpdateBuildTrigger(ctx context.Context, in *UpdateBuildTriggerRequest, opts ...grpc.CallOption) (*BuildTrigger, error) {
	out := new(BuildTrigger)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/UpdateBuildTrigger", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) RunBuildTrigger(ctx context.Context, in *RunBuildTriggerRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/RunBuildTrigger", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) CreateWorkerPool(ctx context.Context, in *CreateWorkerPoolRequest, opts ...grpc.CallOption) (*WorkerPool, error) {
	out := new(WorkerPool)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/CreateWorkerPool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) GetWorkerPool(ctx context.Context, in *GetWorkerPoolRequest, opts ...grpc.CallOption) (*WorkerPool, error) {
	out := new(WorkerPool)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/GetWorkerPool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) DeleteWorkerPool(ctx context.Context, in *DeleteWorkerPoolRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/DeleteWorkerPool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) UpdateWorkerPool(ctx context.Context, in *UpdateWorkerPoolRequest, opts ...grpc.CallOption) (*WorkerPool, error) {
	out := new(WorkerPool)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/UpdateWorkerPool", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) ListWorkerPools(ctx context.Context, in *ListWorkerPoolsRequest, opts ...grpc.CallOption) (*ListWorkerPoolsResponse, error) {
	out := new(ListWorkerPoolsResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/ListWorkerPools", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudBuildServer is the server API for CloudBuild service.
type CloudBuildServer interface {
	// Starts a build with the specified configuration.
	//
	// This method returns a long-running `Operation`, which includes the build
	// ID. Pass the build ID to `GetBuild` to determine the build status (such as
	// `SUCCESS` or `FAILURE`).
	CreateBuild(context.Context, *CreateBuildRequest) (*longrunning.Operation, error)
	// Returns information about a previously requested build.
	//
	// The `Build` that is returned includes its status (such as `SUCCESS`,
	// `FAILURE`, or `WORKING`), and timing information.
	GetBuild(context.Context, *GetBuildRequest) (*Build, error)
	// Lists previously requested builds.
	//
	// Previously requested builds may still be in-progress, or may have finished
	// successfully or unsuccessfully.
	ListBuilds(context.Context, *ListBuildsRequest) (*ListBuildsResponse, error)
	// Cancels a build in progress.
	CancelBuild(context.Context, *CancelBuildRequest) (*Build, error)
	// Creates a new build based on the specified build.
	//
	// This method creates a new build using the original build request, which may
	// or may not result in an identical build.
	//
	// For triggered builds:
	//
	// * Triggered builds resolve to a precise revision; therefore a retry of a
	// triggered build will result in a build that uses the same revision.
	//
	// For non-triggered builds that specify `RepoSource`:
	//
	// * If the original build built from the tip of a branch, the retried build
	// will build from the tip of that branch, which may not be the same revision
	// as the original build.
	// * If the original build specified a commit sha or revision ID, the retried
	// build will use the identical source.
	//
	// For builds that specify `StorageSource`:
	//
	// * If the original build pulled source from Google Cloud Storage without
	// specifying the generation of the object, the new build will use the current
	// object, which may be different from the original build source.
	// * If the original build pulled source from Cloud Storage and specified the
	// generation of the object, the new build will attempt to use the same
	// object, which may or may not be available depending on the bucket's
	// lifecycle management settings.
	RetryBuild(context.Context, *RetryBuildRequest) (*longrunning.Operation, error)
	// Creates a new `BuildTrigger`.
	//
	// This API is experimental.
	CreateBuildTrigger(context.Context, *CreateBuildTriggerRequest) (*BuildTrigger, error)
	// Returns information about a `BuildTrigger`.
	//
	// This API is experimental.
	GetBuildTrigger(context.Context, *GetBuildTriggerRequest) (*BuildTrigger, error)
	// Lists existing `BuildTrigger`s.
	//
	// This API is experimental.
	ListBuildTriggers(context.Context, *ListBuildTriggersRequest) (*ListBuildTriggersResponse, error)
	// Deletes a `BuildTrigger` by its project ID and trigger ID.
	//
	// This API is experimental.
	DeleteBuildTrigger(context.Context, *DeleteBuildTriggerRequest) (*empty.Empty, error)
	// Updates a `BuildTrigger` by its project ID and trigger ID.
	//
	// This API is experimental.
	UpdateBuildTrigger(context.Context, *UpdateBuildTriggerRequest) (*BuildTrigger, error)
	// Runs a `BuildTrigger` at a particular source revision.
	RunBuildTrigger(context.Context, *RunBuildTriggerRequest) (*longrunning.Operation, error)
	// Creates a `WorkerPool` to run the builds, and returns the new worker pool.
	//
	// This API is experimental.
	CreateWorkerPool(context.Context, *CreateWorkerPoolRequest) (*WorkerPool, error)
	// Returns information about a `WorkerPool`.
	//
	// This API is experimental.
	GetWorkerPool(context.Context, *GetWorkerPoolRequest) (*WorkerPool, error)
	// Deletes a `WorkerPool` by its project ID and WorkerPool name.
	//
	// This API is experimental.
	DeleteWorkerPool(context.Context, *DeleteWorkerPoolRequest) (*empty.Empty, error)
	// Update a `WorkerPool`.
	//
	// This API is experimental.
	UpdateWorkerPool(context.Context, *UpdateWorkerPoolRequest) (*WorkerPool, error)
	// List project's `WorkerPools`.
	//
	// This API is experimental.
	ListWorkerPools(context.Context, *ListWorkerPoolsRequest) (*ListWorkerPoolsResponse, error)
}

// UnimplementedCloudBuildServer can be embedded to have forward compatible implementations.
type UnimplementedCloudBuildServer struct {
}

func (*UnimplementedCloudBuildServer) CreateBuild(context.Context, *CreateBuildRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateBuild not implemented")
}
func (*UnimplementedCloudBuildServer) GetBuild(context.Context, *GetBuildRequest) (*Build, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBuild not implemented")
}
func (*UnimplementedCloudBuildServer) ListBuilds(context.Context, *ListBuildsRequest) (*ListBuildsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBuilds not implemented")
}
func (*UnimplementedCloudBuildServer) CancelBuild(context.Context, *CancelBuildRequest) (*Build, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelBuild not implemented")
}
func (*UnimplementedCloudBuildServer) RetryBuild(context.Context, *RetryBuildRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RetryBuild not implemented")
}
func (*UnimplementedCloudBuildServer) CreateBuildTrigger(context.Context, *CreateBuildTriggerRequest) (*BuildTrigger, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateBuildTrigger not implemented")
}
func (*UnimplementedCloudBuildServer) GetBuildTrigger(context.Context, *GetBuildTriggerRequest) (*BuildTrigger, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBuildTrigger not implemented")
}
func (*UnimplementedCloudBuildServer) ListBuildTriggers(context.Context, *ListBuildTriggersRequest) (*ListBuildTriggersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBuildTriggers not implemented")
}
func (*UnimplementedCloudBuildServer) DeleteBuildTrigger(context.Context, *DeleteBuildTriggerRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteBuildTrigger not implemented")
}
func (*UnimplementedCloudBuildServer) UpdateBuildTrigger(context.Context, *UpdateBuildTriggerRequest) (*BuildTrigger, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateBuildTrigger not implemented")
}
func (*UnimplementedCloudBuildServer) RunBuildTrigger(context.Context, *RunBuildTriggerRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunBuildTrigger not implemented")
}
func (*UnimplementedCloudBuildServer) CreateWorkerPool(context.Context, *CreateWorkerPoolRequest) (*WorkerPool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateWorkerPool not implemented")
}
func (*UnimplementedCloudBuildServer) GetWorkerPool(context.Context, *GetWorkerPoolRequest) (*WorkerPool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetWorkerPool not implemented")
}
func (*UnimplementedCloudBuildServer) DeleteWorkerPool(context.Context, *DeleteWorkerPoolRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteWorkerPool not implemented")
}
func (*UnimplementedCloudBuildServer) UpdateWorkerPool(context.Context, *UpdateWorkerPoolRequest) (*WorkerPool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateWorkerPool not implemented")
}
func (*UnimplementedCloudBuildServer) ListWorkerPools(context.Context, *ListWorkerPoolsRequest) (*ListWorkerPoolsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListWorkerPools not implemented")
}

func RegisterCloudBuildServer(s *grpc.Server, srv CloudBuildServer) {
	s.RegisterService(&_CloudBuild_serviceDesc, srv)
}

func _CloudBuild_CreateBuild_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBuildRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).CreateBuild(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/CreateBuild",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).CreateBuild(ctx, req.(*CreateBuildRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_GetBuild_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBuildRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).GetBuild(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/GetBuild",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).GetBuild(ctx, req.(*GetBuildRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_ListBuilds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBuildsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).ListBuilds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/ListBuilds",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).ListBuilds(ctx, req.(*ListBuildsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_CancelBuild_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelBuildRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).CancelBuild(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/CancelBuild",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).CancelBuild(ctx, req.(*CancelBuildRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_RetryBuild_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RetryBuildRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).RetryBuild(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/RetryBuild",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).RetryBuild(ctx, req.(*RetryBuildRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_CreateBuildTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBuildTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).CreateBuildTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/CreateBuildTrigger",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).CreateBuildTrigger(ctx, req.(*CreateBuildTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_GetBuildTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBuildTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).GetBuildTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/GetBuildTrigger",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).GetBuildTrigger(ctx, req.(*GetBuildTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_ListBuildTriggers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBuildTriggersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).ListBuildTriggers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/ListBuildTriggers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).ListBuildTriggers(ctx, req.(*ListBuildTriggersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_DeleteBuildTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBuildTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).DeleteBuildTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/DeleteBuildTrigger",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).DeleteBuildTrigger(ctx, req.(*DeleteBuildTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_UpdateBuildTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBuildTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).UpdateBuildTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/UpdateBuildTrigger",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).UpdateBuildTrigger(ctx, req.(*UpdateBuildTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_RunBuildTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunBuildTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).RunBuildTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/RunBuildTrigger",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).RunBuildTrigger(ctx, req.(*RunBuildTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_CreateWorkerPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateWorkerPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).CreateWorkerPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/CreateWorkerPool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).CreateWorkerPool(ctx, req.(*CreateWorkerPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_GetWorkerPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWorkerPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).GetWorkerPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/GetWorkerPool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).GetWorkerPool(ctx, req.(*GetWorkerPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_DeleteWorkerPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteWorkerPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).DeleteWorkerPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/DeleteWorkerPool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).DeleteWorkerPool(ctx, req.(*DeleteWorkerPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_UpdateWorkerPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateWorkerPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).UpdateWorkerPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/UpdateWorkerPool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).UpdateWorkerPool(ctx, req.(*UpdateWorkerPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_ListWorkerPools_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListWorkerPoolsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).ListWorkerPools(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/ListWorkerPools",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).ListWorkerPools(ctx, req.(*ListWorkerPoolsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CloudBuild_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.cloudbuild.v1.CloudBuild",
	HandlerType: (*CloudBuildServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateBuild",
			Handler:    _CloudBuild_CreateBuild_Handler,
		},
		{
			MethodName: "GetBuild",
			Handler:    _CloudBuild_GetBuild_Handler,
		},
		{
			MethodName: "ListBuilds",
			Handler:    _CloudBuild_ListBuilds_Handler,
		},
		{
			MethodName: "CancelBuild",
			Handler:    _CloudBuild_CancelBuild_Handler,
		},
		{
			MethodName: "RetryBuild",
			Handler:    _CloudBuild_RetryBuild_Handler,
		},
		{
			MethodName: "CreateBuildTrigger",
			Handler:    _CloudBuild_CreateBuildTrigger_Handler,
		},
		{
			MethodName: "GetBuildTrigger",
			Handler:    _CloudBuild_GetBuildTrigger_Handler,
		},
		{
			MethodName: "ListBuildTriggers",
			Handler:    _CloudBuild_ListBuildTriggers_Handler,
		},
		{
			MethodName: "DeleteBuildTrigger",
			Handler:    _CloudBuild_DeleteBuildTrigger_Handler,
		},
		{
			MethodName: "UpdateBuildTrigger",
			Handler:    _CloudBuild_UpdateBuildTrigger_Handler,
		},
		{
			MethodName: "RunBuildTrigger",
			Handler:    _CloudBuild_RunBuildTrigger_Handler,
		},
		{
			MethodName: "CreateWorkerPool",
			Handler:    _CloudBuild_CreateWorkerPool_Handler,
		},
		{
			MethodName: "GetWorkerPool",
			Handler:    _CloudBuild_GetWorkerPool_Handler,
		},
		{
			MethodName: "DeleteWorkerPool",
			Handler:    _CloudBuild_DeleteWorkerPool_Handler,
		},
		{
			MethodName: "UpdateWorkerPool",
			Handler:    _CloudBuild_UpdateWorkerPool_Handler,
		},
		{
			MethodName: "ListWorkerPools",
			Handler:    _CloudBuild_ListWorkerPools_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/cloudbuild/v1/cloudbuild.proto",
}
