// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListMonitoringSchedulesInput struct {
	_ struct{} `type:"structure"`

	// A filter that returns only monitoring schedules created after a specified
	// time.
	CreationTimeAfter *time.Time `type:"timestamp"`

	// A filter that returns only monitoring schedules created before a specified
	// time.
	CreationTimeBefore *time.Time `type:"timestamp"`

	// Name of a specific endpoint to fetch schedules for.
	EndpointName *string `type:"string"`

	// A filter that returns only monitoring schedules modified after a specified
	// time.
	LastModifiedTimeAfter *time.Time `type:"timestamp"`

	// A filter that returns only monitoring schedules modified before a specified
	// time.
	LastModifiedTimeBefore *time.Time `type:"timestamp"`

	// The maximum number of jobs to return in the response. The default value is
	// 10.
	MaxResults *int64 `min:"1" type:"integer"`

	// Filter for monitoring schedules whose name contains a specified string.
	NameContains *string `type:"string"`

	// The token returned if the response is truncated. To retrieve the next set
	// of job executions, use it in the next request.
	NextToken *string `type:"string"`

	// Whether to sort results by Status, CreationTime, ScheduledTime field. The
	// default is CreationTime.
	SortBy MonitoringScheduleSortKey `type:"string" enum:"true"`

	// Whether to sort the results in Ascending or Descending order. The default
	// is Descending.
	SortOrder SortOrder `type:"string" enum:"true"`

	// A filter that returns only monitoring schedules modified before a specified
	// time.
	StatusEquals ScheduleStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s ListMonitoringSchedulesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMonitoringSchedulesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListMonitoringSchedulesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListMonitoringSchedulesOutput struct {
	_ struct{} `type:"structure"`

	// A JSON array in which each element is a summary for a monitoring schedule.
	//
	// MonitoringScheduleSummaries is a required field
	MonitoringScheduleSummaries []MonitoringScheduleSummary `type:"list" required:"true"`

	// If the response is truncated, Amazon SageMaker returns this token. To retrieve
	// the next set of jobs, use it in the subsequent reques
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListMonitoringSchedulesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListMonitoringSchedules = "ListMonitoringSchedules"

// ListMonitoringSchedulesRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Returns list of all monitoring schedules.
//
//    // Example sending a request using ListMonitoringSchedulesRequest.
//    req := client.ListMonitoringSchedulesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListMonitoringSchedules
func (c *Client) ListMonitoringSchedulesRequest(input *ListMonitoringSchedulesInput) ListMonitoringSchedulesRequest {
	op := &aws.Operation{
		Name:       opListMonitoringSchedules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMonitoringSchedulesInput{}
	}

	req := c.newRequest(op, input, &ListMonitoringSchedulesOutput{})
	return ListMonitoringSchedulesRequest{Request: req, Input: input, Copy: c.ListMonitoringSchedulesRequest}
}

// ListMonitoringSchedulesRequest is the request type for the
// ListMonitoringSchedules API operation.
type ListMonitoringSchedulesRequest struct {
	*aws.Request
	Input *ListMonitoringSchedulesInput
	Copy  func(*ListMonitoringSchedulesInput) ListMonitoringSchedulesRequest
}

// Send marshals and sends the ListMonitoringSchedules API request.
func (r ListMonitoringSchedulesRequest) Send(ctx context.Context) (*ListMonitoringSchedulesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListMonitoringSchedulesResponse{
		ListMonitoringSchedulesOutput: r.Request.Data.(*ListMonitoringSchedulesOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListMonitoringSchedulesRequestPaginator returns a paginator for ListMonitoringSchedules.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListMonitoringSchedulesRequest(input)
//   p := sagemaker.NewListMonitoringSchedulesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListMonitoringSchedulesPaginator(req ListMonitoringSchedulesRequest) ListMonitoringSchedulesPaginator {
	return ListMonitoringSchedulesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListMonitoringSchedulesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListMonitoringSchedulesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListMonitoringSchedulesPaginator struct {
	aws.Pager
}

func (p *ListMonitoringSchedulesPaginator) CurrentPage() *ListMonitoringSchedulesOutput {
	return p.Pager.CurrentPage().(*ListMonitoringSchedulesOutput)
}

// ListMonitoringSchedulesResponse is the response type for the
// ListMonitoringSchedules API operation.
type ListMonitoringSchedulesResponse struct {
	*ListMonitoringSchedulesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListMonitoringSchedules request.
func (r *ListMonitoringSchedulesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
