// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ioteventsdata

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opBatchPutMessage = "BatchPutMessage"

// BatchPutMessageRequest generates a "aws/request.Request" representing the
// client's request for the BatchPutMessage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchPutMessage for more information on using the BatchPutMessage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchPutMessageRequest method.
//    req, resp := client.BatchPutMessageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchPutMessage
func (c *IoTEventsData) BatchPutMessageRequest(input *BatchPutMessageInput) (req *request.Request, output *BatchPutMessageOutput) {
	op := &request.Operation{
		Name:       opBatchPutMessage,
		HTTPMethod: "POST",
		HTTPPath:   "/inputs/messages",
	}

	if input == nil {
		input = &BatchPutMessageInput{}
	}

	output = &BatchPutMessageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchPutMessage API operation for AWS IoT Events Data.
//
// Sends a set of messages to the AWS IoT Events system. Each message payload
// is transformed into the input you specify ("inputName") and ingested into
// any detectors that monitor that input. If multiple messages are sent, the
// order in which the messages are processed isn't guaranteed. To guarantee
// ordering, you must send messages one at a time and wait for a successful
// response.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Events Data's
// API operation BatchPutMessage for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request was invalid.
//
//   * InternalFailureException
//   An internal failure occured.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ThrottlingException
//   The request could not be completed due to throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchPutMessage
func (c *IoTEventsData) BatchPutMessage(input *BatchPutMessageInput) (*BatchPutMessageOutput, error) {
	req, out := c.BatchPutMessageRequest(input)
	return out, req.Send()
}

// BatchPutMessageWithContext is the same as BatchPutMessage with the addition of
// the ability to pass a context and additional request options.
//
// See BatchPutMessage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTEventsData) BatchPutMessageWithContext(ctx aws.Context, input *BatchPutMessageInput, opts ...request.Option) (*BatchPutMessageOutput, error) {
	req, out := c.BatchPutMessageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchUpdateDetector = "BatchUpdateDetector"

// BatchUpdateDetectorRequest generates a "aws/request.Request" representing the
// client's request for the BatchUpdateDetector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchUpdateDetector for more information on using the BatchUpdateDetector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchUpdateDetectorRequest method.
//    req, resp := client.BatchUpdateDetectorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchUpdateDetector
func (c *IoTEventsData) BatchUpdateDetectorRequest(input *BatchUpdateDetectorInput) (req *request.Request, output *BatchUpdateDetectorOutput) {
	op := &request.Operation{
		Name:       opBatchUpdateDetector,
		HTTPMethod: "POST",
		HTTPPath:   "/detectors",
	}

	if input == nil {
		input = &BatchUpdateDetectorInput{}
	}

	output = &BatchUpdateDetectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchUpdateDetector API operation for AWS IoT Events Data.
//
// Updates the state, variable values, and timer settings of one or more detectors
// (instances) of a specified detector model.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Events Data's
// API operation BatchUpdateDetector for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request was invalid.
//
//   * InternalFailureException
//   An internal failure occured.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ThrottlingException
//   The request could not be completed due to throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/BatchUpdateDetector
func (c *IoTEventsData) BatchUpdateDetector(input *BatchUpdateDetectorInput) (*BatchUpdateDetectorOutput, error) {
	req, out := c.BatchUpdateDetectorRequest(input)
	return out, req.Send()
}

// BatchUpdateDetectorWithContext is the same as BatchUpdateDetector with the addition of
// the ability to pass a context and additional request options.
//
// See BatchUpdateDetector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTEventsData) BatchUpdateDetectorWithContext(ctx aws.Context, input *BatchUpdateDetectorInput, opts ...request.Option) (*BatchUpdateDetectorOutput, error) {
	req, out := c.BatchUpdateDetectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDetector = "DescribeDetector"

// DescribeDetectorRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDetector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDetector for more information on using the DescribeDetector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDetectorRequest method.
//    req, resp := client.DescribeDetectorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/DescribeDetector
func (c *IoTEventsData) DescribeDetectorRequest(input *DescribeDetectorInput) (req *request.Request, output *DescribeDetectorOutput) {
	op := &request.Operation{
		Name:       opDescribeDetector,
		HTTPMethod: "GET",
		HTTPPath:   "/detectors/{detectorModelName}/keyValues/",
	}

	if input == nil {
		input = &DescribeDetectorInput{}
	}

	output = &DescribeDetectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDetector API operation for AWS IoT Events Data.
//
// Returns information about the specified detector (instance).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Events Data's
// API operation DescribeDetector for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request was invalid.
//
//   * ResourceNotFoundException
//   The resource was not found.
//
//   * ThrottlingException
//   The request could not be completed due to throttling.
//
//   * InternalFailureException
//   An internal failure occured.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/DescribeDetector
func (c *IoTEventsData) DescribeDetector(input *DescribeDetectorInput) (*DescribeDetectorOutput, error) {
	req, out := c.DescribeDetectorRequest(input)
	return out, req.Send()
}

// DescribeDetectorWithContext is the same as DescribeDetector with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDetector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTEventsData) DescribeDetectorWithContext(ctx aws.Context, input *DescribeDetectorInput, opts ...request.Option) (*DescribeDetectorOutput, error) {
	req, out := c.DescribeDetectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDetectors = "ListDetectors"

// ListDetectorsRequest generates a "aws/request.Request" representing the
// client's request for the ListDetectors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDetectors for more information on using the ListDetectors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDetectorsRequest method.
//    req, resp := client.ListDetectorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/ListDetectors
func (c *IoTEventsData) ListDetectorsRequest(input *ListDetectorsInput) (req *request.Request, output *ListDetectorsOutput) {
	op := &request.Operation{
		Name:       opListDetectors,
		HTTPMethod: "GET",
		HTTPPath:   "/detectors/{detectorModelName}",
	}

	if input == nil {
		input = &ListDetectorsInput{}
	}

	output = &ListDetectorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDetectors API operation for AWS IoT Events Data.
//
// Lists detectors (the instances of a detector model).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Events Data's
// API operation ListDetectors for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request was invalid.
//
//   * ResourceNotFoundException
//   The resource was not found.
//
//   * ThrottlingException
//   The request could not be completed due to throttling.
//
//   * InternalFailureException
//   An internal failure occured.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotevents-data-2018-10-23/ListDetectors
func (c *IoTEventsData) ListDetectors(input *ListDetectorsInput) (*ListDetectorsOutput, error) {
	req, out := c.ListDetectorsRequest(input)
	return out, req.Send()
}

// ListDetectorsWithContext is the same as ListDetectors with the addition of
// the ability to pass a context and additional request options.
//
// See ListDetectors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTEventsData) ListDetectorsWithContext(ctx aws.Context, input *ListDetectorsInput, opts ...request.Option) (*ListDetectorsOutput, error) {
	req, out := c.ListDetectorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Contains information about the errors encountered.
type BatchPutMessageErrorEntry struct {
	_ struct{} `type:"structure"`

	// The code associated with the error.
	ErrorCode *string `locationName:"errorCode" type:"string" enum:"ErrorCode"`

	// More information about the error.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// The ID of the message that caused the error. (See the value corresponding
	// to the "messageId" key in the "message" object.)
	MessageId *string `locationName:"messageId" min:"1" type:"string"`
}

// String returns the string representation
func (s BatchPutMessageErrorEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchPutMessageErrorEntry) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *BatchPutMessageErrorEntry) SetErrorCode(v string) *BatchPutMessageErrorEntry {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BatchPutMessageErrorEntry) SetErrorMessage(v string) *BatchPutMessageErrorEntry {
	s.ErrorMessage = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *BatchPutMessageErrorEntry) SetMessageId(v string) *BatchPutMessageErrorEntry {
	s.MessageId = &v
	return s
}

type BatchPutMessageInput struct {
	_ struct{} `type:"structure"`

	// The list of messages to send. Each message has the following format: '{ "messageId":
	// "string", "inputName": "string", "payload": "string"}'
	//
	// Messages is a required field
	Messages []*Message `locationName:"messages" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchPutMessageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchPutMessageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchPutMessageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchPutMessageInput"}
	if s.Messages == nil {
		invalidParams.Add(request.NewErrParamRequired("Messages"))
	}
	if s.Messages != nil && len(s.Messages) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Messages", 1))
	}
	if s.Messages != nil {
		for i, v := range s.Messages {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Messages", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMessages sets the Messages field's value.
func (s *BatchPutMessageInput) SetMessages(v []*Message) *BatchPutMessageInput {
	s.Messages = v
	return s
}

type BatchPutMessageOutput struct {
	_ struct{} `type:"structure"`

	// A list of any errors encountered when sending the messages.
	BatchPutMessageErrorEntries []*BatchPutMessageErrorEntry `type:"list"`
}

// String returns the string representation
func (s BatchPutMessageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchPutMessageOutput) GoString() string {
	return s.String()
}

// SetBatchPutMessageErrorEntries sets the BatchPutMessageErrorEntries field's value.
func (s *BatchPutMessageOutput) SetBatchPutMessageErrorEntries(v []*BatchPutMessageErrorEntry) *BatchPutMessageOutput {
	s.BatchPutMessageErrorEntries = v
	return s
}

// Information about the error that occured when attempting to update a detector.
type BatchUpdateDetectorErrorEntry struct {
	_ struct{} `type:"structure"`

	// The code of the error.
	ErrorCode *string `locationName:"errorCode" type:"string" enum:"ErrorCode"`

	// A message describing the error.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// The "messageId" of the update request that caused the error. (The value of
	// the "messageId" in the update request "Detector" object.)
	MessageId *string `locationName:"messageId" min:"1" type:"string"`
}

// String returns the string representation
func (s BatchUpdateDetectorErrorEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchUpdateDetectorErrorEntry) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *BatchUpdateDetectorErrorEntry) SetErrorCode(v string) *BatchUpdateDetectorErrorEntry {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BatchUpdateDetectorErrorEntry) SetErrorMessage(v string) *BatchUpdateDetectorErrorEntry {
	s.ErrorMessage = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *BatchUpdateDetectorErrorEntry) SetMessageId(v string) *BatchUpdateDetectorErrorEntry {
	s.MessageId = &v
	return s
}

type BatchUpdateDetectorInput struct {
	_ struct{} `type:"structure"`

	// The list of detectors (instances) to update, along with the values to update.
	//
	// Detectors is a required field
	Detectors []*UpdateDetectorRequest `locationName:"detectors" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchUpdateDetectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchUpdateDetectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchUpdateDetectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchUpdateDetectorInput"}
	if s.Detectors == nil {
		invalidParams.Add(request.NewErrParamRequired("Detectors"))
	}
	if s.Detectors != nil && len(s.Detectors) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Detectors", 1))
	}
	if s.Detectors != nil {
		for i, v := range s.Detectors {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Detectors", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectors sets the Detectors field's value.
func (s *BatchUpdateDetectorInput) SetDetectors(v []*UpdateDetectorRequest) *BatchUpdateDetectorInput {
	s.Detectors = v
	return s
}

type BatchUpdateDetectorOutput struct {
	_ struct{} `type:"structure"`

	// A list of those detector updates that resulted in errors. (If an error is
	// listed here, the specific update did not occur.)
	BatchUpdateDetectorErrorEntries []*BatchUpdateDetectorErrorEntry `locationName:"batchUpdateDetectorErrorEntries" type:"list"`
}

// String returns the string representation
func (s BatchUpdateDetectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchUpdateDetectorOutput) GoString() string {
	return s.String()
}

// SetBatchUpdateDetectorErrorEntries sets the BatchUpdateDetectorErrorEntries field's value.
func (s *BatchUpdateDetectorOutput) SetBatchUpdateDetectorErrorEntries(v []*BatchUpdateDetectorErrorEntry) *BatchUpdateDetectorOutput {
	s.BatchUpdateDetectorErrorEntries = v
	return s
}

type DescribeDetectorInput struct {
	_ struct{} `type:"structure"`

	// The name of the detector model whose detectors (instances) you want information
	// about.
	//
	// DetectorModelName is a required field
	DetectorModelName *string `location:"uri" locationName:"detectorModelName" min:"1" type:"string" required:"true"`

	// A filter used to limit results to detectors (instances) created because of
	// the given key ID.
	KeyValue *string `location:"querystring" locationName:"keyValue" min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeDetectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDetectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDetectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDetectorInput"}
	if s.DetectorModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorModelName"))
	}
	if s.DetectorModelName != nil && len(*s.DetectorModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorModelName", 1))
	}
	if s.KeyValue != nil && len(*s.KeyValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorModelName sets the DetectorModelName field's value.
func (s *DescribeDetectorInput) SetDetectorModelName(v string) *DescribeDetectorInput {
	s.DetectorModelName = &v
	return s
}

// SetKeyValue sets the KeyValue field's value.
func (s *DescribeDetectorInput) SetKeyValue(v string) *DescribeDetectorInput {
	s.KeyValue = &v
	return s
}

type DescribeDetectorOutput struct {
	_ struct{} `type:"structure"`

	// Information about the detector (instance).
	Detector *Detector `locationName:"detector" type:"structure"`
}

// String returns the string representation
func (s DescribeDetectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDetectorOutput) GoString() string {
	return s.String()
}

// SetDetector sets the Detector field's value.
func (s *DescribeDetectorOutput) SetDetector(v *Detector) *DescribeDetectorOutput {
	s.Detector = v
	return s
}

// Information about the detector (instance).
type Detector struct {
	_ struct{} `type:"structure"`

	// The time the detector (instance) was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The name of the detector model that created this detector (instance).
	DetectorModelName *string `locationName:"detectorModelName" min:"1" type:"string"`

	// The version of the detector model that created this detector (instance).
	DetectorModelVersion *string `locationName:"detectorModelVersion" min:"1" type:"string"`

	// The value of the key (identifying the device or system) that caused the creation
	// of this detector (instance).
	KeyValue *string `locationName:"keyValue" min:"1" type:"string"`

	// The time the detector (instance) was last updated.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp"`

	// The current state of the detector (instance).
	State *DetectorState `locationName:"state" type:"structure"`
}

// String returns the string representation
func (s Detector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Detector) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *Detector) SetCreationTime(v time.Time) *Detector {
	s.CreationTime = &v
	return s
}

// SetDetectorModelName sets the DetectorModelName field's value.
func (s *Detector) SetDetectorModelName(v string) *Detector {
	s.DetectorModelName = &v
	return s
}

// SetDetectorModelVersion sets the DetectorModelVersion field's value.
func (s *Detector) SetDetectorModelVersion(v string) *Detector {
	s.DetectorModelVersion = &v
	return s
}

// SetKeyValue sets the KeyValue field's value.
func (s *Detector) SetKeyValue(v string) *Detector {
	s.KeyValue = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *Detector) SetLastUpdateTime(v time.Time) *Detector {
	s.LastUpdateTime = &v
	return s
}

// SetState sets the State field's value.
func (s *Detector) SetState(v *DetectorState) *Detector {
	s.State = v
	return s
}

// Information about the current state of the detector instance.
type DetectorState struct {
	_ struct{} `type:"structure"`

	// The name of the state.
	//
	// StateName is a required field
	StateName *string `locationName:"stateName" min:"1" type:"string" required:"true"`

	// The current state of the detector's timers.
	//
	// Timers is a required field
	Timers []*Timer `locationName:"timers" type:"list" required:"true"`

	// The current values of the detector's variables.
	//
	// Variables is a required field
	Variables []*Variable `locationName:"variables" type:"list" required:"true"`
}

// String returns the string representation
func (s DetectorState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectorState) GoString() string {
	return s.String()
}

// SetStateName sets the StateName field's value.
func (s *DetectorState) SetStateName(v string) *DetectorState {
	s.StateName = &v
	return s
}

// SetTimers sets the Timers field's value.
func (s *DetectorState) SetTimers(v []*Timer) *DetectorState {
	s.Timers = v
	return s
}

// SetVariables sets the Variables field's value.
func (s *DetectorState) SetVariables(v []*Variable) *DetectorState {
	s.Variables = v
	return s
}

// The new state, variable values, and timer settings of the detector (instance).
type DetectorStateDefinition struct {
	_ struct{} `type:"structure"`

	// The name of the new state of the detector (instance).
	//
	// StateName is a required field
	StateName *string `locationName:"stateName" min:"1" type:"string" required:"true"`

	// The new values of the detector's timers. Any timer whose value isn't specified
	// is cleared, and its timeout event won't occur.
	//
	// Timers is a required field
	Timers []*TimerDefinition `locationName:"timers" type:"list" required:"true"`

	// The new values of the detector's variables. Any variable whose value isn't
	// specified is cleared.
	//
	// Variables is a required field
	Variables []*VariableDefinition `locationName:"variables" type:"list" required:"true"`
}

// String returns the string representation
func (s DetectorStateDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectorStateDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectorStateDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectorStateDefinition"}
	if s.StateName == nil {
		invalidParams.Add(request.NewErrParamRequired("StateName"))
	}
	if s.StateName != nil && len(*s.StateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StateName", 1))
	}
	if s.Timers == nil {
		invalidParams.Add(request.NewErrParamRequired("Timers"))
	}
	if s.Variables == nil {
		invalidParams.Add(request.NewErrParamRequired("Variables"))
	}
	if s.Timers != nil {
		for i, v := range s.Timers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Timers", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Variables != nil {
		for i, v := range s.Variables {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Variables", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStateName sets the StateName field's value.
func (s *DetectorStateDefinition) SetStateName(v string) *DetectorStateDefinition {
	s.StateName = &v
	return s
}

// SetTimers sets the Timers field's value.
func (s *DetectorStateDefinition) SetTimers(v []*TimerDefinition) *DetectorStateDefinition {
	s.Timers = v
	return s
}

// SetVariables sets the Variables field's value.
func (s *DetectorStateDefinition) SetVariables(v []*VariableDefinition) *DetectorStateDefinition {
	s.Variables = v
	return s
}

// Information about the detector state.
type DetectorStateSummary struct {
	_ struct{} `type:"structure"`

	// The name of the state.
	StateName *string `locationName:"stateName" min:"1" type:"string"`
}

// String returns the string representation
func (s DetectorStateSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectorStateSummary) GoString() string {
	return s.String()
}

// SetStateName sets the StateName field's value.
func (s *DetectorStateSummary) SetStateName(v string) *DetectorStateSummary {
	s.StateName = &v
	return s
}

// Information about the detector (instance).
type DetectorSummary struct {
	_ struct{} `type:"structure"`

	// The time the detector (instance) was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The name of the detector model that created this detector (instance).
	DetectorModelName *string `locationName:"detectorModelName" min:"1" type:"string"`

	// The version of the detector model that created this detector (instance).
	DetectorModelVersion *string `locationName:"detectorModelVersion" min:"1" type:"string"`

	// The value of the key (identifying the device or system) that caused the creation
	// of this detector (instance).
	KeyValue *string `locationName:"keyValue" min:"1" type:"string"`

	// The time the detector (instance) was last updated.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp"`

	// The current state of the detector (instance).
	State *DetectorStateSummary `locationName:"state" type:"structure"`
}

// String returns the string representation
func (s DetectorSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectorSummary) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DetectorSummary) SetCreationTime(v time.Time) *DetectorSummary {
	s.CreationTime = &v
	return s
}

// SetDetectorModelName sets the DetectorModelName field's value.
func (s *DetectorSummary) SetDetectorModelName(v string) *DetectorSummary {
	s.DetectorModelName = &v
	return s
}

// SetDetectorModelVersion sets the DetectorModelVersion field's value.
func (s *DetectorSummary) SetDetectorModelVersion(v string) *DetectorSummary {
	s.DetectorModelVersion = &v
	return s
}

// SetKeyValue sets the KeyValue field's value.
func (s *DetectorSummary) SetKeyValue(v string) *DetectorSummary {
	s.KeyValue = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *DetectorSummary) SetLastUpdateTime(v time.Time) *DetectorSummary {
	s.LastUpdateTime = &v
	return s
}

// SetState sets the State field's value.
func (s *DetectorSummary) SetState(v *DetectorStateSummary) *DetectorSummary {
	s.State = v
	return s
}

// An internal failure occured.
type InternalFailureException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message for the exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InternalFailureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalFailureException) GoString() string {
	return s.String()
}

func newErrorInternalFailureException(v protocol.ResponseMetadata) error {
	return &InternalFailureException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalFailureException) Code() string {
	return "InternalFailureException"
}

// Message returns the exception's message.
func (s *InternalFailureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalFailureException) OrigErr() error {
	return nil
}

func (s *InternalFailureException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalFailureException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalFailureException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was invalid.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message for the exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListDetectorsInput struct {
	_ struct{} `type:"structure"`

	// The name of the detector model whose detectors (instances) are listed.
	//
	// DetectorModelName is a required field
	DetectorModelName *string `location:"uri" locationName:"detectorModelName" min:"1" type:"string" required:"true"`

	// The maximum number of results to return at one time.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// A filter that limits results to those detectors (instances) in the given
	// state.
	StateName *string `location:"querystring" locationName:"stateName" min:"1" type:"string"`
}

// String returns the string representation
func (s ListDetectorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDetectorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDetectorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDetectorsInput"}
	if s.DetectorModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorModelName"))
	}
	if s.DetectorModelName != nil && len(*s.DetectorModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorModelName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.StateName != nil && len(*s.StateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorModelName sets the DetectorModelName field's value.
func (s *ListDetectorsInput) SetDetectorModelName(v string) *ListDetectorsInput {
	s.DetectorModelName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDetectorsInput) SetMaxResults(v int64) *ListDetectorsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDetectorsInput) SetNextToken(v string) *ListDetectorsInput {
	s.NextToken = &v
	return s
}

// SetStateName sets the StateName field's value.
func (s *ListDetectorsInput) SetStateName(v string) *ListDetectorsInput {
	s.StateName = &v
	return s
}

type ListDetectorsOutput struct {
	_ struct{} `type:"structure"`

	// A list of summary information about the detectors (instances).
	DetectorSummaries []*DetectorSummary `locationName:"detectorSummaries" type:"list"`

	// A token to retrieve the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDetectorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDetectorsOutput) GoString() string {
	return s.String()
}

// SetDetectorSummaries sets the DetectorSummaries field's value.
func (s *ListDetectorsOutput) SetDetectorSummaries(v []*DetectorSummary) *ListDetectorsOutput {
	s.DetectorSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDetectorsOutput) SetNextToken(v string) *ListDetectorsOutput {
	s.NextToken = &v
	return s
}

// Information about a message.
type Message struct {
	_ struct{} `type:"structure"`

	// The name of the input into which the message payload is transformed.
	//
	// InputName is a required field
	InputName *string `locationName:"inputName" min:"1" type:"string" required:"true"`

	// The ID to assign to the message. Within each batch sent, each "messageId"
	// must be unique.
	//
	// MessageId is a required field
	MessageId *string `locationName:"messageId" min:"1" type:"string" required:"true"`

	// The payload of the message. This can be a JSON string or a Base-64-encoded
	// string representing binary data (in which case you must decode it).
	//
	// Payload is automatically base64 encoded/decoded by the SDK.
	//
	// Payload is a required field
	Payload []byte `locationName:"payload" type:"blob" required:"true"`
}

// String returns the string representation
func (s Message) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Message) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Message) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Message"}
	if s.InputName == nil {
		invalidParams.Add(request.NewErrParamRequired("InputName"))
	}
	if s.InputName != nil && len(*s.InputName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputName", 1))
	}
	if s.MessageId == nil {
		invalidParams.Add(request.NewErrParamRequired("MessageId"))
	}
	if s.MessageId != nil && len(*s.MessageId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MessageId", 1))
	}
	if s.Payload == nil {
		invalidParams.Add(request.NewErrParamRequired("Payload"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputName sets the InputName field's value.
func (s *Message) SetInputName(v string) *Message {
	s.InputName = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *Message) SetMessageId(v string) *Message {
	s.MessageId = &v
	return s
}

// SetPayload sets the Payload field's value.
func (s *Message) SetPayload(v []byte) *Message {
	s.Payload = v
	return s
}

// The resource was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message for the exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The service is currently unavailable.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message for the exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request could not be completed due to throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message for the exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The current state of a timer.
type Timer struct {
	_ struct{} `type:"structure"`

	// The name of the timer.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The number of seconds which have elapsed on the timer.
	//
	// Timestamp is a required field
	Timestamp *time.Time `locationName:"timestamp" type:"timestamp" required:"true"`
}

// String returns the string representation
func (s Timer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Timer) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *Timer) SetName(v string) *Timer {
	s.Name = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *Timer) SetTimestamp(v time.Time) *Timer {
	s.Timestamp = &v
	return s
}

// The new setting of a timer.
type TimerDefinition struct {
	_ struct{} `type:"structure"`

	// The name of the timer.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The new setting of the timer (the number of seconds before the timer elapses).
	//
	// Seconds is a required field
	Seconds *int64 `locationName:"seconds" type:"integer" required:"true"`
}

// String returns the string representation
func (s TimerDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TimerDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TimerDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TimerDefinition"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Seconds == nil {
		invalidParams.Add(request.NewErrParamRequired("Seconds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *TimerDefinition) SetName(v string) *TimerDefinition {
	s.Name = &v
	return s
}

// SetSeconds sets the Seconds field's value.
func (s *TimerDefinition) SetSeconds(v int64) *TimerDefinition {
	s.Seconds = &v
	return s
}

// Information used to update the detector (instance).
type UpdateDetectorRequest struct {
	_ struct{} `type:"structure"`

	// The name of the detector model that created the detectors (instances).
	//
	// DetectorModelName is a required field
	DetectorModelName *string `locationName:"detectorModelName" min:"1" type:"string" required:"true"`

	// The value of the input key attribute (identifying the device or system) that
	// caused the creation of this detector (instance).
	KeyValue *string `locationName:"keyValue" min:"1" type:"string"`

	// The ID to assign to the detector update "message". Each "messageId" must
	// be unique within each batch sent.
	//
	// MessageId is a required field
	MessageId *string `locationName:"messageId" min:"1" type:"string" required:"true"`

	// The new state, variable values, and timer settings of the detector (instance).
	//
	// State is a required field
	State *DetectorStateDefinition `locationName:"state" type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateDetectorRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDetectorRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDetectorRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDetectorRequest"}
	if s.DetectorModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorModelName"))
	}
	if s.DetectorModelName != nil && len(*s.DetectorModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorModelName", 1))
	}
	if s.KeyValue != nil && len(*s.KeyValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyValue", 1))
	}
	if s.MessageId == nil {
		invalidParams.Add(request.NewErrParamRequired("MessageId"))
	}
	if s.MessageId != nil && len(*s.MessageId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MessageId", 1))
	}
	if s.State == nil {
		invalidParams.Add(request.NewErrParamRequired("State"))
	}
	if s.State != nil {
		if err := s.State.Validate(); err != nil {
			invalidParams.AddNested("State", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorModelName sets the DetectorModelName field's value.
func (s *UpdateDetectorRequest) SetDetectorModelName(v string) *UpdateDetectorRequest {
	s.DetectorModelName = &v
	return s
}

// SetKeyValue sets the KeyValue field's value.
func (s *UpdateDetectorRequest) SetKeyValue(v string) *UpdateDetectorRequest {
	s.KeyValue = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *UpdateDetectorRequest) SetMessageId(v string) *UpdateDetectorRequest {
	s.MessageId = &v
	return s
}

// SetState sets the State field's value.
func (s *UpdateDetectorRequest) SetState(v *DetectorStateDefinition) *UpdateDetectorRequest {
	s.State = v
	return s
}

// The current state of the variable.
type Variable struct {
	_ struct{} `type:"structure"`

	// The name of the variable.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The current value of the variable.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Variable) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Variable) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *Variable) SetName(v string) *Variable {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Variable) SetValue(v string) *Variable {
	s.Value = &v
	return s
}

// The new value of the variable.
type VariableDefinition struct {
	_ struct{} `type:"structure"`

	// The name of the variable.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The new value of the variable.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s VariableDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VariableDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VariableDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VariableDefinition"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *VariableDefinition) SetName(v string) *VariableDefinition {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *VariableDefinition) SetValue(v string) *VariableDefinition {
	s.Value = &v
	return s
}

const (
	// ErrorCodeResourceNotFoundException is a ErrorCode enum value
	ErrorCodeResourceNotFoundException = "ResourceNotFoundException"

	// ErrorCodeInvalidRequestException is a ErrorCode enum value
	ErrorCodeInvalidRequestException = "InvalidRequestException"

	// ErrorCodeInternalFailureException is a ErrorCode enum value
	ErrorCodeInternalFailureException = "InternalFailureException"

	// ErrorCodeServiceUnavailableException is a ErrorCode enum value
	ErrorCodeServiceUnavailableException = "ServiceUnavailableException"

	// ErrorCodeThrottlingException is a ErrorCode enum value
	ErrorCodeThrottlingException = "ThrottlingException"
)
