// Copyright (c) 2017 Uber Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package mocks

import cassandra "github.com/jaegertracing/jaeger/pkg/cassandra"
import mock "github.com/stretchr/testify/mock"

// Session is an autogenerated mock type for the Session type
type Session struct {
	mock.Mock
}

// Close provides a mock function with given fields:
func (_m *Session) Close() {
	_m.Called()
}

// Query provides a mock function with given fields: stmt, values
func (_m *Session) Query(stmt string, values ...interface{}) cassandra.Query {
	ret := _m.Called(stmt, values)

	var r0 cassandra.Query
	if rf, ok := ret.Get(0).(func(string, ...interface{}) cassandra.Query); ok {
		r0 = rf(stmt, values...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(cassandra.Query)
		}
	}

	return r0
}

var _ cassandra.Session = (*Session)(nil)
