// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/iot/v1/device_manager.proto

package iot

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	v1 "google.golang.org/genproto/googleapis/iam/v1"
	_ "google.golang.org/genproto/googleapis/rpc/status"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request for `CreateDeviceRegistry`.
type CreateDeviceRegistryRequest struct {
	// Required. The project and cloud region where this device registry must be created.
	// For example, `projects/example-project/locations/us-central1`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The device registry. The field `name` must be empty. The server will
	// generate that field from the device registry `id` provided and the
	// `parent` field.
	DeviceRegistry       *DeviceRegistry `protobuf:"bytes,2,opt,name=device_registry,json=deviceRegistry,proto3" json:"device_registry,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *CreateDeviceRegistryRequest) Reset()         { *m = CreateDeviceRegistryRequest{} }
func (m *CreateDeviceRegistryRequest) String() string { return proto.CompactTextString(m) }
func (*CreateDeviceRegistryRequest) ProtoMessage()    {}
func (*CreateDeviceRegistryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9243c344ef472aff, []int{0}
}

func (m *CreateDeviceRegistryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateDeviceRegistryRequest.Unmarshal(m, b)
}
func (m *CreateDeviceRegistryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateDeviceRegistryRequest.Marshal(b, m, deterministic)
}
func (m *CreateDeviceRegistryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateDeviceRegistryRequest.Merge(m, src)
}
func (m *CreateDeviceRegistryRequest) XXX_Size() int {
	return xxx_messageInfo_CreateDeviceRegistryRequest.Size(m)
}
func (m *CreateDeviceRegistryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateDeviceRegistryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateDeviceRegistryRequest proto.InternalMessageInfo

func (m *CreateDeviceRegistryRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateDeviceRegistryRequest) GetDeviceRegistry() *DeviceRegistry {
	if m != nil {
		return m.DeviceRegistry
	}
	return nil
}

// Request for `GetDeviceRegistry`.
type GetDeviceRegistryRequest struct {
	// Required. The name of the device registry. For example,
	// `projects/example-project/locations/us-central1/registries/my-registry`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetDeviceRegistryRequest) Reset()         { *m = GetDeviceRegistryRequest{} }
func (m *GetDeviceRegistryRequest) String() string { return proto.CompactTextString(m) }
func (*GetDeviceRegistryRequest) ProtoMessage()    {}
func (*GetDeviceRegistryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9243c344ef472aff, []int{1}
}

func (m *GetDeviceRegistryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetDeviceRegistryRequest.Unmarshal(m, b)
}
func (m *GetDeviceRegistryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetDeviceRegistryRequest.Marshal(b, m, deterministic)
}
func (m *GetDeviceRegistryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDeviceRegistryRequest.Merge(m, src)
}
func (m *GetDeviceRegistryRequest) XXX_Size() int {
	return xxx_messageInfo_GetDeviceRegistryRequest.Size(m)
}
func (m *GetDeviceRegistryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDeviceRegistryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDeviceRegistryRequest proto.InternalMessageInfo

func (m *GetDeviceRegistryRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request for `DeleteDeviceRegistry`.
type DeleteDeviceRegistryRequest struct {
	// Required. The name of the device registry. For example,
	// `projects/example-project/locations/us-central1/registries/my-registry`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteDeviceRegistryRequest) Reset()         { *m = DeleteDeviceRegistryRequest{} }
func (m *DeleteDeviceRegistryRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteDeviceRegistryRequest) ProtoMessage()    {}
func (*DeleteDeviceRegistryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9243c344ef472aff, []int{2}
}

func (m *DeleteDeviceRegistryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteDeviceRegistryRequest.Unmarshal(m, b)
}
func (m *DeleteDeviceRegistryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteDeviceRegistryRequest.Marshal(b, m, deterministic)
}
func (m *DeleteDeviceRegistryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteDeviceRegistryRequest.Merge(m, src)
}
func (m *DeleteDeviceRegistryRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteDeviceRegistryRequest.Size(m)
}
func (m *DeleteDeviceRegistryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteDeviceRegistryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteDeviceRegistryRequest proto.InternalMessageInfo

func (m *DeleteDeviceRegistryRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request for `UpdateDeviceRegistry`.
type UpdateDeviceRegistryRequest struct {
	// Required. The new values for the device registry. The `id` field must be empty, and
	// the `name` field must indicate the path of the resource. For example,
	// `projects/example-project/locations/us-central1/registries/my-registry`.
	DeviceRegistry *DeviceRegistry `protobuf:"bytes,1,opt,name=device_registry,json=deviceRegistry,proto3" json:"device_registry,omitempty"`
	// Required. Only updates the `device_registry` fields indicated by this mask.
	// The field mask must not be empty, and it must not contain fields that
	// are immutable or only set by the server.
	// Mutable top-level fields: `event_notification_config`, `http_config`,
	// `mqtt_config`, and `state_notification_config`.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateDeviceRegistryRequest) Reset()         { *m = UpdateDeviceRegistryRequest{} }
func (m *UpdateDeviceRegistryRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateDeviceRegistryRequest) ProtoMessage()    {}
func (*UpdateDeviceRegistryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9243c344ef472aff, []int{3}
}

func (m *UpdateDeviceRegistryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateDeviceRegistryRequest.Unmarshal(m, b)
}
func (m *UpdateDeviceRegistryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateDeviceRegistryRequest.Marshal(b, m, deterministic)
}
func (m *UpdateDeviceRegistryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateDeviceRegistryRequest.Merge(m, src)
}
func (m *UpdateDeviceRegistryRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateDeviceRegistryRequest.Size(m)
}
func (m *UpdateDeviceRegistryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateDeviceRegistryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateDeviceRegistryRequest proto.InternalMessageInfo

func (m *UpdateDeviceRegistryRequest) GetDeviceRegistry() *DeviceRegistry {
	if m != nil {
		return m.DeviceRegistry
	}
	return nil
}

func (m *UpdateDeviceRegistryRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request for `ListDeviceRegistries`.
type ListDeviceRegistriesRequest struct {
	// Required. The project and cloud region path. For example,
	// `projects/example-project/locations/us-central1`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of registries to return in the response. If this value
	// is zero, the service will select a default size. A call may return fewer
	// objects than requested. A non-empty `next_page_token` in the response
	// indicates that more data is available.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last `ListDeviceRegistriesResponse`; indicates
	// that this is a continuation of a prior `ListDeviceRegistries` call and
	// the system should return the next page of data.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDeviceRegistriesRequest) Reset()         { *m = ListDeviceRegistriesRequest{} }
func (m *ListDeviceRegistriesRequest) String() string { return proto.CompactTextString(m) }
func (*ListDeviceRegistriesRequest) ProtoMessage()    {}
func (*ListDeviceRegistriesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9243c344ef472aff, []int{4}
}

func (m *ListDeviceRegistriesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDeviceRegistriesRequest.Unmarshal(m, b)
}
func (m *ListDeviceRegistriesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDeviceRegistriesRequest.Marshal(b, m, deterministic)
}
func (m *ListDeviceRegistriesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDeviceRegistriesRequest.Merge(m, src)
}
func (m *ListDeviceRegistriesRequest) XXX_Size() int {
	return xxx_messageInfo_ListDeviceRegistriesRequest.Size(m)
}
func (m *ListDeviceRegistriesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDeviceRegistriesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListDeviceRegistriesRequest proto.InternalMessageInfo

func (m *ListDeviceRegistriesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListDeviceRegistriesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListDeviceRegistriesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for `ListDeviceRegistries`.
type ListDeviceRegistriesResponse struct {
	// The registries that matched the query.
	DeviceRegistries []*DeviceRegistry `protobuf:"bytes,1,rep,name=device_registries,json=deviceRegistries,proto3" json:"device_registries,omitempty"`
	// If not empty, indicates that there may be more registries that match the
	// request; this value should be passed in a new
	// `ListDeviceRegistriesRequest`.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDeviceRegistriesResponse) Reset()         { *m = ListDeviceRegistriesResponse{} }
func (m *ListDeviceRegistriesResponse) String() string { return proto.CompactTextString(m) }
func (*ListDeviceRegistriesResponse) ProtoMessage()    {}
func (*ListDeviceRegistriesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9243c344ef472aff, []int{5}
}

func (m *ListDeviceRegistriesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDeviceRegistriesResponse.Unmarshal(m, b)
}
func (m *ListDeviceRegistriesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDeviceRegistriesResponse.Marshal(b, m, deterministic)
}
func (m *ListDeviceRegistriesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDeviceRegistriesResponse.Merge(m, src)
}
func (m *ListDeviceRegistriesResponse) XXX_Size() int {
	return xxx_messageInfo_ListDeviceRegistriesResponse.Size(m)
}
func (m *ListDeviceRegistriesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDeviceRegistriesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListDeviceRegistriesResponse proto.InternalMessageInfo

func (m *ListDeviceRegistriesResponse) GetDeviceRegistries() []*DeviceRegistry {
	if m != nil {
		return m.DeviceRegistries
	}
	return nil
}

func (m *ListDeviceRegistriesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request for `CreateDevice`.
type CreateDeviceRequest struct {
	// Required. The name of the device registry where this device should be created.
	// For example,
	// `projects/example-project/locations/us-central1/registries/my-registry`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The device registration details. The field `name` must be empty. The server
	// generates `name` from the device registry `id` and the
	// `parent` field.
	Device               *Device  `protobuf:"bytes,2,opt,name=device,proto3" json:"device,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateDeviceRequest) Reset()         { *m = CreateDeviceRequest{} }
func (m *CreateDeviceRequest) String() string { return proto.CompactTextString(m) }
func (*CreateDeviceRequest) ProtoMessage()    {}
func (*CreateDeviceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9243c344ef472aff, []int{6}
}

func (m *CreateDeviceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateDeviceRequest.Unmarshal(m, b)
}
func (m *CreateDeviceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateDeviceRequest.Marshal(b, m, deterministic)
}
func (m *CreateDeviceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateDeviceRequest.Merge(m, src)
}
func (m *CreateDeviceRequest) XXX_Size() int {
	return xxx_messageInfo_CreateDeviceRequest.Size(m)
}
func (m *CreateDeviceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateDeviceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateDeviceRequest proto.InternalMessageInfo

func (m *CreateDeviceRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateDeviceRequest) GetDevice() *Device {
	if m != nil {
		return m.Device
	}
	return nil
}

// Request for `GetDevice`.
type GetDeviceRequest struct {
	// Required. The name of the device. For example,
	// `projects/p0/locations/us-central1/registries/registry0/devices/device0` or
	// `projects/p0/locations/us-central1/registries/registry0/devices/{num_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The fields of the `Device` resource to be returned in the response. If the
	// field mask is unset or empty, all fields are returned.
	FieldMask            *field_mask.FieldMask `protobuf:"bytes,2,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *GetDeviceRequest) Reset()         { *m = GetDeviceRequest{} }
func (m *GetDeviceRequest) String() string { return proto.CompactTextString(m) }
func (*GetDeviceRequest) ProtoMessage()    {}
func (*GetDeviceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9243c344ef472aff, []int{7}
}

func (m *GetDeviceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetDeviceRequest.Unmarshal(m, b)
}
func (m *GetDeviceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetDeviceRequest.Marshal(b, m, deterministic)
}
func (m *GetDeviceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDeviceRequest.Merge(m, src)
}
func (m *GetDeviceRequest) XXX_Size() int {
	return xxx_messageInfo_GetDeviceRequest.Size(m)
}
func (m *GetDeviceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDeviceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDeviceRequest proto.InternalMessageInfo

func (m *GetDeviceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetDeviceRequest) GetFieldMask() *field_mask.FieldMask {
	if m != nil {
		return m.FieldMask
	}
	return nil
}

// Request for `UpdateDevice`.
type UpdateDeviceRequest struct {
	// Required. The new values for the device. The `id` and `num_id` fields must
	// be empty, and the field `name` must specify the name path. For example,
	// `projects/p0/locations/us-central1/registries/registry0/devices/device0`or
	// `projects/p0/locations/us-central1/registries/registry0/devices/{num_id}`.
	Device *Device `protobuf:"bytes,2,opt,name=device,proto3" json:"device,omitempty"`
	// Required. Only updates the `device` fields indicated by this mask.
	// The field mask must not be empty, and it must not contain fields that
	// are immutable or only set by the server.
	// Mutable top-level fields: `credentials`, `blocked`, and `metadata`
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateDeviceRequest) Reset()         { *m = UpdateDeviceRequest{} }
func (m *UpdateDeviceRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateDeviceRequest) ProtoMessage()    {}
func (*UpdateDeviceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9243c344ef472aff, []int{8}
}

func (m *UpdateDeviceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateDeviceRequest.Unmarshal(m, b)
}
func (m *UpdateDeviceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateDeviceRequest.Marshal(b, m, deterministic)
}
func (m *UpdateDeviceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateDeviceRequest.Merge(m, src)
}
func (m *UpdateDeviceRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateDeviceRequest.Size(m)
}
func (m *UpdateDeviceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateDeviceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateDeviceRequest proto.InternalMessageInfo

func (m *UpdateDeviceRequest) GetDevice() *Device {
	if m != nil {
		return m.Device
	}
	return nil
}

func (m *UpdateDeviceRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request for `DeleteDevice`.
type DeleteDeviceRequest struct {
	// Required. The name of the device. For example,
	// `projects/p0/locations/us-central1/registries/registry0/devices/device0` or
	// `projects/p0/locations/us-central1/registries/registry0/devices/{num_id}`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteDeviceRequest) Reset()         { *m = DeleteDeviceRequest{} }
func (m *DeleteDeviceRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteDeviceRequest) ProtoMessage()    {}
func (*DeleteDeviceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9243c344ef472aff, []int{9}
}

func (m *DeleteDeviceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteDeviceRequest.Unmarshal(m, b)
}
func (m *DeleteDeviceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteDeviceRequest.Marshal(b, m, deterministic)
}
func (m *DeleteDeviceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteDeviceRequest.Merge(m, src)
}
func (m *DeleteDeviceRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteDeviceRequest.Size(m)
}
func (m *DeleteDeviceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteDeviceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteDeviceRequest proto.InternalMessageInfo

func (m *DeleteDeviceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request for `ListDevices`.
type ListDevicesRequest struct {
	// Required. The device registry path. Required. For example,
	// `projects/my-project/locations/us-central1/registries/my-registry`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// A list of device numeric IDs. If empty, this field is ignored. Maximum
	// IDs: 10,000.
	DeviceNumIds []uint64 `protobuf:"varint,2,rep,packed,name=device_num_ids,json=deviceNumIds,proto3" json:"device_num_ids,omitempty"`
	// A list of device string IDs. For example, `['device0', 'device12']`.
	// If empty, this field is ignored. Maximum IDs: 10,000
	DeviceIds []string `protobuf:"bytes,3,rep,name=device_ids,json=deviceIds,proto3" json:"device_ids,omitempty"`
	// The fields of the `Device` resource to be returned in the response. The
	// fields `id` and `num_id` are always returned, along with any
	// other fields specified.
	FieldMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
	// Options related to gateways.
	GatewayListOptions *GatewayListOptions `protobuf:"bytes,6,opt,name=gateway_list_options,json=gatewayListOptions,proto3" json:"gateway_list_options,omitempty"`
	// The maximum number of devices to return in the response. If this value
	// is zero, the service will select a default size. A call may return fewer
	// objects than requested. A non-empty `next_page_token` in the response
	// indicates that more data is available.
	PageSize int32 `protobuf:"varint,100,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last `ListDevicesResponse`; indicates
	// that this is a continuation of a prior `ListDevices` call and
	// the system should return the next page of data.
	PageToken            string   `protobuf:"bytes,101,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDevicesRequest) Reset()         { *m = ListDevicesRequest{} }
func (m *ListDevicesRequest) String() string { return proto.CompactTextString(m) }
func (*ListDevicesRequest) ProtoMessage()    {}
func (*ListDevicesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9243c344ef472aff, []int{10}
}

func (m *ListDevicesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDevicesRequest.Unmarshal(m, b)
}
func (m *ListDevicesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDevicesRequest.Marshal(b, m, deterministic)
}
func (m *ListDevicesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDevicesRequest.Merge(m, src)
}
func (m *ListDevicesRequest) XXX_Size() int {
	return xxx_messageInfo_ListDevicesRequest.Size(m)
}
func (m *ListDevicesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDevicesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListDevicesRequest proto.InternalMessageInfo

func (m *ListDevicesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListDevicesRequest) GetDeviceNumIds() []uint64 {
	if m != nil {
		return m.DeviceNumIds
	}
	return nil
}

func (m *ListDevicesRequest) GetDeviceIds() []string {
	if m != nil {
		return m.DeviceIds
	}
	return nil
}

func (m *ListDevicesRequest) GetFieldMask() *field_mask.FieldMask {
	if m != nil {
		return m.FieldMask
	}
	return nil
}

func (m *ListDevicesRequest) GetGatewayListOptions() *GatewayListOptions {
	if m != nil {
		return m.GatewayListOptions
	}
	return nil
}

func (m *ListDevicesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListDevicesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Options for limiting the list based on gateway type and associations.
type GatewayListOptions struct {
	// If not set, all devices and gateways are returned. If set, the list is
	// filtered based on gateway type and associations.
	//
	// Types that are valid to be assigned to Filter:
	//	*GatewayListOptions_GatewayType
	//	*GatewayListOptions_AssociationsGatewayId
	//	*GatewayListOptions_AssociationsDeviceId
	Filter               isGatewayListOptions_Filter `protobuf_oneof:"filter"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *GatewayListOptions) Reset()         { *m = GatewayListOptions{} }
func (m *GatewayListOptions) String() string { return proto.CompactTextString(m) }
func (*GatewayListOptions) ProtoMessage()    {}
func (*GatewayListOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_9243c344ef472aff, []int{11}
}

func (m *GatewayListOptions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GatewayListOptions.Unmarshal(m, b)
}
func (m *GatewayListOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GatewayListOptions.Marshal(b, m, deterministic)
}
func (m *GatewayListOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GatewayListOptions.Merge(m, src)
}
func (m *GatewayListOptions) XXX_Size() int {
	return xxx_messageInfo_GatewayListOptions.Size(m)
}
func (m *GatewayListOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_GatewayListOptions.DiscardUnknown(m)
}

var xxx_messageInfo_GatewayListOptions proto.InternalMessageInfo

type isGatewayListOptions_Filter interface {
	isGatewayListOptions_Filter()
}

type GatewayListOptions_GatewayType struct {
	GatewayType GatewayType `protobuf:"varint,1,opt,name=gateway_type,json=gatewayType,proto3,enum=google.cloud.iot.v1.GatewayType,oneof"`
}

type GatewayListOptions_AssociationsGatewayId struct {
	AssociationsGatewayId string `protobuf:"bytes,2,opt,name=associations_gateway_id,json=associationsGatewayId,proto3,oneof"`
}

type GatewayListOptions_AssociationsDeviceId struct {
	AssociationsDeviceId string `protobuf:"bytes,3,opt,name=associations_device_id,json=associationsDeviceId,proto3,oneof"`
}

func (*GatewayListOptions_GatewayType) isGatewayListOptions_Filter() {}

func (*GatewayListOptions_AssociationsGatewayId) isGatewayListOptions_Filter() {}

func (*GatewayListOptions_AssociationsDeviceId) isGatewayListOptions_Filter() {}

func (m *GatewayListOptions) GetFilter() isGatewayListOptions_Filter {
	if m != nil {
		return m.Filter
	}
	return nil
}

func (m *GatewayListOptions) GetGatewayType() GatewayType {
	if x, ok := m.GetFilter().(*GatewayListOptions_GatewayType); ok {
		return x.GatewayType
	}
	return GatewayType_GATEWAY_TYPE_UNSPECIFIED
}

func (m *GatewayListOptions) GetAssociationsGatewayId() string {
	if x, ok := m.GetFilter().(*GatewayListOptions_AssociationsGatewayId); ok {
		return x.AssociationsGatewayId
	}
	return ""
}

func (m *GatewayListOptions) GetAssociationsDeviceId() string {
	if x, ok := m.GetFilter().(*GatewayListOptions_AssociationsDeviceId); ok {
		return x.AssociationsDeviceId
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*GatewayListOptions) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*GatewayListOptions_GatewayType)(nil),
		(*GatewayListOptions_AssociationsGatewayId)(nil),
		(*GatewayListOptions_AssociationsDeviceId)(nil),
	}
}

// Response for `ListDevices`.
type ListDevicesResponse struct {
	// The devices that match the request.
	Devices []*Device `protobuf:"bytes,1,rep,name=devices,proto3" json:"devices,omitempty"`
	// If not empty, indicates that there may be more devices that match the
	// request; this value should be passed in a new `ListDevicesRequest`.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDevicesResponse) Reset()         { *m = ListDevicesResponse{} }
func (m *ListDevicesResponse) String() string { return proto.CompactTextString(m) }
func (*ListDevicesResponse) ProtoMessage()    {}
func (*ListDevicesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9243c344ef472aff, []int{12}
}

func (m *ListDevicesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDevicesResponse.Unmarshal(m, b)
}
func (m *ListDevicesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDevicesResponse.Marshal(b, m, deterministic)
}
func (m *ListDevicesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDevicesResponse.Merge(m, src)
}
func (m *ListDevicesResponse) XXX_Size() int {
	return xxx_messageInfo_ListDevicesResponse.Size(m)
}
func (m *ListDevicesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDevicesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListDevicesResponse proto.InternalMessageInfo

func (m *ListDevicesResponse) GetDevices() []*Device {
	if m != nil {
		return m.Devices
	}
	return nil
}

func (m *ListDevicesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request for `ModifyCloudToDeviceConfig`.
type ModifyCloudToDeviceConfigRequest struct {
	// Required. The name of the device. For example,
	// `projects/p0/locations/us-central1/registries/registry0/devices/device0` or
	// `projects/p0/locations/us-central1/registries/registry0/devices/{num_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The version number to update. If this value is zero, it will not check the
	// version number of the server and will always update the current version;
	// otherwise, this update will fail if the version number found on the server
	// does not match this version number. This is used to support multiple
	// simultaneous updates without losing data.
	VersionToUpdate int64 `protobuf:"varint,2,opt,name=version_to_update,json=versionToUpdate,proto3" json:"version_to_update,omitempty"`
	// Required. The configuration data for the device.
	BinaryData           []byte   `protobuf:"bytes,3,opt,name=binary_data,json=binaryData,proto3" json:"binary_data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ModifyCloudToDeviceConfigRequest) Reset()         { *m = ModifyCloudToDeviceConfigRequest{} }
func (m *ModifyCloudToDeviceConfigRequest) String() string { return proto.CompactTextString(m) }
func (*ModifyCloudToDeviceConfigRequest) ProtoMessage()    {}
func (*ModifyCloudToDeviceConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9243c344ef472aff, []int{13}
}

func (m *ModifyCloudToDeviceConfigRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ModifyCloudToDeviceConfigRequest.Unmarshal(m, b)
}
func (m *ModifyCloudToDeviceConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ModifyCloudToDeviceConfigRequest.Marshal(b, m, deterministic)
}
func (m *ModifyCloudToDeviceConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ModifyCloudToDeviceConfigRequest.Merge(m, src)
}
func (m *ModifyCloudToDeviceConfigRequest) XXX_Size() int {
	return xxx_messageInfo_ModifyCloudToDeviceConfigRequest.Size(m)
}
func (m *ModifyCloudToDeviceConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ModifyCloudToDeviceConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ModifyCloudToDeviceConfigRequest proto.InternalMessageInfo

func (m *ModifyCloudToDeviceConfigRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ModifyCloudToDeviceConfigRequest) GetVersionToUpdate() int64 {
	if m != nil {
		return m.VersionToUpdate
	}
	return 0
}

func (m *ModifyCloudToDeviceConfigRequest) GetBinaryData() []byte {
	if m != nil {
		return m.BinaryData
	}
	return nil
}

// Request for `ListDeviceConfigVersions`.
type ListDeviceConfigVersionsRequest struct {
	// Required. The name of the device. For example,
	// `projects/p0/locations/us-central1/registries/registry0/devices/device0` or
	// `projects/p0/locations/us-central1/registries/registry0/devices/{num_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The number of versions to list. Versions are listed in decreasing order of
	// the version number. The maximum number of versions retained is 10. If this
	// value is zero, it will return all the versions available.
	NumVersions          int32    `protobuf:"varint,2,opt,name=num_versions,json=numVersions,proto3" json:"num_versions,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDeviceConfigVersionsRequest) Reset()         { *m = ListDeviceConfigVersionsRequest{} }
func (m *ListDeviceConfigVersionsRequest) String() string { return proto.CompactTextString(m) }
func (*ListDeviceConfigVersionsRequest) ProtoMessage()    {}
func (*ListDeviceConfigVersionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9243c344ef472aff, []int{14}
}

func (m *ListDeviceConfigVersionsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDeviceConfigVersionsRequest.Unmarshal(m, b)
}
func (m *ListDeviceConfigVersionsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDeviceConfigVersionsRequest.Marshal(b, m, deterministic)
}
func (m *ListDeviceConfigVersionsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDeviceConfigVersionsRequest.Merge(m, src)
}
func (m *ListDeviceConfigVersionsRequest) XXX_Size() int {
	return xxx_messageInfo_ListDeviceConfigVersionsRequest.Size(m)
}
func (m *ListDeviceConfigVersionsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDeviceConfigVersionsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListDeviceConfigVersionsRequest proto.InternalMessageInfo

func (m *ListDeviceConfigVersionsRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ListDeviceConfigVersionsRequest) GetNumVersions() int32 {
	if m != nil {
		return m.NumVersions
	}
	return 0
}

// Response for `ListDeviceConfigVersions`.
type ListDeviceConfigVersionsResponse struct {
	// The device configuration for the last few versions. Versions are listed
	// in decreasing order, starting from the most recent one.
	DeviceConfigs        []*DeviceConfig `protobuf:"bytes,1,rep,name=device_configs,json=deviceConfigs,proto3" json:"device_configs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ListDeviceConfigVersionsResponse) Reset()         { *m = ListDeviceConfigVersionsResponse{} }
func (m *ListDeviceConfigVersionsResponse) String() string { return proto.CompactTextString(m) }
func (*ListDeviceConfigVersionsResponse) ProtoMessage()    {}
func (*ListDeviceConfigVersionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9243c344ef472aff, []int{15}
}

func (m *ListDeviceConfigVersionsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDeviceConfigVersionsResponse.Unmarshal(m, b)
}
func (m *ListDeviceConfigVersionsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDeviceConfigVersionsResponse.Marshal(b, m, deterministic)
}
func (m *ListDeviceConfigVersionsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDeviceConfigVersionsResponse.Merge(m, src)
}
func (m *ListDeviceConfigVersionsResponse) XXX_Size() int {
	return xxx_messageInfo_ListDeviceConfigVersionsResponse.Size(m)
}
func (m *ListDeviceConfigVersionsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDeviceConfigVersionsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListDeviceConfigVersionsResponse proto.InternalMessageInfo

func (m *ListDeviceConfigVersionsResponse) GetDeviceConfigs() []*DeviceConfig {
	if m != nil {
		return m.DeviceConfigs
	}
	return nil
}

// Request for `ListDeviceStates`.
type ListDeviceStatesRequest struct {
	// Required. The name of the device. For example,
	// `projects/p0/locations/us-central1/registries/registry0/devices/device0` or
	// `projects/p0/locations/us-central1/registries/registry0/devices/{num_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The number of states to list. States are listed in descending order of
	// update time. The maximum number of states retained is 10. If this
	// value is zero, it will return all the states available.
	NumStates            int32    `protobuf:"varint,2,opt,name=num_states,json=numStates,proto3" json:"num_states,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDeviceStatesRequest) Reset()         { *m = ListDeviceStatesRequest{} }
func (m *ListDeviceStatesRequest) String() string { return proto.CompactTextString(m) }
func (*ListDeviceStatesRequest) ProtoMessage()    {}
func (*ListDeviceStatesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9243c344ef472aff, []int{16}
}

func (m *ListDeviceStatesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDeviceStatesRequest.Unmarshal(m, b)
}
func (m *ListDeviceStatesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDeviceStatesRequest.Marshal(b, m, deterministic)
}
func (m *ListDeviceStatesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDeviceStatesRequest.Merge(m, src)
}
func (m *ListDeviceStatesRequest) XXX_Size() int {
	return xxx_messageInfo_ListDeviceStatesRequest.Size(m)
}
func (m *ListDeviceStatesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDeviceStatesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListDeviceStatesRequest proto.InternalMessageInfo

func (m *ListDeviceStatesRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ListDeviceStatesRequest) GetNumStates() int32 {
	if m != nil {
		return m.NumStates
	}
	return 0
}

// Response for `ListDeviceStates`.
type ListDeviceStatesResponse struct {
	// The last few device states. States are listed in descending order of server
	// update time, starting from the most recent one.
	DeviceStates         []*DeviceState `protobuf:"bytes,1,rep,name=device_states,json=deviceStates,proto3" json:"device_states,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *ListDeviceStatesResponse) Reset()         { *m = ListDeviceStatesResponse{} }
func (m *ListDeviceStatesResponse) String() string { return proto.CompactTextString(m) }
func (*ListDeviceStatesResponse) ProtoMessage()    {}
func (*ListDeviceStatesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9243c344ef472aff, []int{17}
}

func (m *ListDeviceStatesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDeviceStatesResponse.Unmarshal(m, b)
}
func (m *ListDeviceStatesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDeviceStatesResponse.Marshal(b, m, deterministic)
}
func (m *ListDeviceStatesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDeviceStatesResponse.Merge(m, src)
}
func (m *ListDeviceStatesResponse) XXX_Size() int {
	return xxx_messageInfo_ListDeviceStatesResponse.Size(m)
}
func (m *ListDeviceStatesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDeviceStatesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListDeviceStatesResponse proto.InternalMessageInfo

func (m *ListDeviceStatesResponse) GetDeviceStates() []*DeviceState {
	if m != nil {
		return m.DeviceStates
	}
	return nil
}

// Request for `SendCommandToDevice`.
type SendCommandToDeviceRequest struct {
	// Required. The name of the device. For example,
	// `projects/p0/locations/us-central1/registries/registry0/devices/device0` or
	// `projects/p0/locations/us-central1/registries/registry0/devices/{num_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The command data to send to the device.
	BinaryData []byte `protobuf:"bytes,2,opt,name=binary_data,json=binaryData,proto3" json:"binary_data,omitempty"`
	// Optional subfolder for the command. If empty, the command will be delivered
	// to the /devices/{device-id}/commands topic, otherwise it will be delivered
	// to the /devices/{device-id}/commands/{subfolder} topic. Multi-level
	// subfolders are allowed. This field must not have more than 256 characters,
	// and must not contain any MQTT wildcards ("+" or "#") or null characters.
	Subfolder            string   `protobuf:"bytes,3,opt,name=subfolder,proto3" json:"subfolder,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SendCommandToDeviceRequest) Reset()         { *m = SendCommandToDeviceRequest{} }
func (m *SendCommandToDeviceRequest) String() string { return proto.CompactTextString(m) }
func (*SendCommandToDeviceRequest) ProtoMessage()    {}
func (*SendCommandToDeviceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9243c344ef472aff, []int{18}
}

func (m *SendCommandToDeviceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SendCommandToDeviceRequest.Unmarshal(m, b)
}
func (m *SendCommandToDeviceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SendCommandToDeviceRequest.Marshal(b, m, deterministic)
}
func (m *SendCommandToDeviceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SendCommandToDeviceRequest.Merge(m, src)
}
func (m *SendCommandToDeviceRequest) XXX_Size() int {
	return xxx_messageInfo_SendCommandToDeviceRequest.Size(m)
}
func (m *SendCommandToDeviceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SendCommandToDeviceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SendCommandToDeviceRequest proto.InternalMessageInfo

func (m *SendCommandToDeviceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SendCommandToDeviceRequest) GetBinaryData() []byte {
	if m != nil {
		return m.BinaryData
	}
	return nil
}

func (m *SendCommandToDeviceRequest) GetSubfolder() string {
	if m != nil {
		return m.Subfolder
	}
	return ""
}

// Response for `SendCommandToDevice`.
type SendCommandToDeviceResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SendCommandToDeviceResponse) Reset()         { *m = SendCommandToDeviceResponse{} }
func (m *SendCommandToDeviceResponse) String() string { return proto.CompactTextString(m) }
func (*SendCommandToDeviceResponse) ProtoMessage()    {}
func (*SendCommandToDeviceResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9243c344ef472aff, []int{19}
}

func (m *SendCommandToDeviceResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SendCommandToDeviceResponse.Unmarshal(m, b)
}
func (m *SendCommandToDeviceResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SendCommandToDeviceResponse.Marshal(b, m, deterministic)
}
func (m *SendCommandToDeviceResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SendCommandToDeviceResponse.Merge(m, src)
}
func (m *SendCommandToDeviceResponse) XXX_Size() int {
	return xxx_messageInfo_SendCommandToDeviceResponse.Size(m)
}
func (m *SendCommandToDeviceResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SendCommandToDeviceResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SendCommandToDeviceResponse proto.InternalMessageInfo

// Request for `BindDeviceToGateway`.
type BindDeviceToGatewayRequest struct {
	// Required. The name of the registry. For example,
	// `projects/example-project/locations/us-central1/registries/my-registry`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The value of `gateway_id` can be either the device numeric ID or the
	// user-defined device identifier.
	GatewayId string `protobuf:"bytes,2,opt,name=gateway_id,json=gatewayId,proto3" json:"gateway_id,omitempty"`
	// Required. The device to associate with the specified gateway. The value of
	// `device_id` can be either the device numeric ID or the user-defined device
	// identifier.
	DeviceId             string   `protobuf:"bytes,3,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BindDeviceToGatewayRequest) Reset()         { *m = BindDeviceToGatewayRequest{} }
func (m *BindDeviceToGatewayRequest) String() string { return proto.CompactTextString(m) }
func (*BindDeviceToGatewayRequest) ProtoMessage()    {}
func (*BindDeviceToGatewayRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9243c344ef472aff, []int{20}
}

func (m *BindDeviceToGatewayRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BindDeviceToGatewayRequest.Unmarshal(m, b)
}
func (m *BindDeviceToGatewayRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BindDeviceToGatewayRequest.Marshal(b, m, deterministic)
}
func (m *BindDeviceToGatewayRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BindDeviceToGatewayRequest.Merge(m, src)
}
func (m *BindDeviceToGatewayRequest) XXX_Size() int {
	return xxx_messageInfo_BindDeviceToGatewayRequest.Size(m)
}
func (m *BindDeviceToGatewayRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BindDeviceToGatewayRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BindDeviceToGatewayRequest proto.InternalMessageInfo

func (m *BindDeviceToGatewayRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *BindDeviceToGatewayRequest) GetGatewayId() string {
	if m != nil {
		return m.GatewayId
	}
	return ""
}

func (m *BindDeviceToGatewayRequest) GetDeviceId() string {
	if m != nil {
		return m.DeviceId
	}
	return ""
}

// Response for `BindDeviceToGateway`.
type BindDeviceToGatewayResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BindDeviceToGatewayResponse) Reset()         { *m = BindDeviceToGatewayResponse{} }
func (m *BindDeviceToGatewayResponse) String() string { return proto.CompactTextString(m) }
func (*BindDeviceToGatewayResponse) ProtoMessage()    {}
func (*BindDeviceToGatewayResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9243c344ef472aff, []int{21}
}

func (m *BindDeviceToGatewayResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BindDeviceToGatewayResponse.Unmarshal(m, b)
}
func (m *BindDeviceToGatewayResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BindDeviceToGatewayResponse.Marshal(b, m, deterministic)
}
func (m *BindDeviceToGatewayResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BindDeviceToGatewayResponse.Merge(m, src)
}
func (m *BindDeviceToGatewayResponse) XXX_Size() int {
	return xxx_messageInfo_BindDeviceToGatewayResponse.Size(m)
}
func (m *BindDeviceToGatewayResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BindDeviceToGatewayResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BindDeviceToGatewayResponse proto.InternalMessageInfo

// Request for `UnbindDeviceFromGateway`.
type UnbindDeviceFromGatewayRequest struct {
	// Required. The name of the registry. For example,
	// `projects/example-project/locations/us-central1/registries/my-registry`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The value of `gateway_id` can be either the device numeric ID or the
	// user-defined device identifier.
	GatewayId string `protobuf:"bytes,2,opt,name=gateway_id,json=gatewayId,proto3" json:"gateway_id,omitempty"`
	// Required. The device to disassociate from the specified gateway. The value of
	// `device_id` can be either the device numeric ID or the user-defined device
	// identifier.
	DeviceId             string   `protobuf:"bytes,3,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UnbindDeviceFromGatewayRequest) Reset()         { *m = UnbindDeviceFromGatewayRequest{} }
func (m *UnbindDeviceFromGatewayRequest) String() string { return proto.CompactTextString(m) }
func (*UnbindDeviceFromGatewayRequest) ProtoMessage()    {}
func (*UnbindDeviceFromGatewayRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9243c344ef472aff, []int{22}
}

func (m *UnbindDeviceFromGatewayRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UnbindDeviceFromGatewayRequest.Unmarshal(m, b)
}
func (m *UnbindDeviceFromGatewayRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UnbindDeviceFromGatewayRequest.Marshal(b, m, deterministic)
}
func (m *UnbindDeviceFromGatewayRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UnbindDeviceFromGatewayRequest.Merge(m, src)
}
func (m *UnbindDeviceFromGatewayRequest) XXX_Size() int {
	return xxx_messageInfo_UnbindDeviceFromGatewayRequest.Size(m)
}
func (m *UnbindDeviceFromGatewayRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UnbindDeviceFromGatewayRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UnbindDeviceFromGatewayRequest proto.InternalMessageInfo

func (m *UnbindDeviceFromGatewayRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *UnbindDeviceFromGatewayRequest) GetGatewayId() string {
	if m != nil {
		return m.GatewayId
	}
	return ""
}

func (m *UnbindDeviceFromGatewayRequest) GetDeviceId() string {
	if m != nil {
		return m.DeviceId
	}
	return ""
}

// Response for `UnbindDeviceFromGateway`.
type UnbindDeviceFromGatewayResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UnbindDeviceFromGatewayResponse) Reset()         { *m = UnbindDeviceFromGatewayResponse{} }
func (m *UnbindDeviceFromGatewayResponse) String() string { return proto.CompactTextString(m) }
func (*UnbindDeviceFromGatewayResponse) ProtoMessage()    {}
func (*UnbindDeviceFromGatewayResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_9243c344ef472aff, []int{23}
}

func (m *UnbindDeviceFromGatewayResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UnbindDeviceFromGatewayResponse.Unmarshal(m, b)
}
func (m *UnbindDeviceFromGatewayResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UnbindDeviceFromGatewayResponse.Marshal(b, m, deterministic)
}
func (m *UnbindDeviceFromGatewayResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UnbindDeviceFromGatewayResponse.Merge(m, src)
}
func (m *UnbindDeviceFromGatewayResponse) XXX_Size() int {
	return xxx_messageInfo_UnbindDeviceFromGatewayResponse.Size(m)
}
func (m *UnbindDeviceFromGatewayResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_UnbindDeviceFromGatewayResponse.DiscardUnknown(m)
}

var xxx_messageInfo_UnbindDeviceFromGatewayResponse proto.InternalMessageInfo

func init() {
	proto.RegisterType((*CreateDeviceRegistryRequest)(nil), "google.cloud.iot.v1.CreateDeviceRegistryRequest")
	proto.RegisterType((*GetDeviceRegistryRequest)(nil), "google.cloud.iot.v1.GetDeviceRegistryRequest")
	proto.RegisterType((*DeleteDeviceRegistryRequest)(nil), "google.cloud.iot.v1.DeleteDeviceRegistryRequest")
	proto.RegisterType((*UpdateDeviceRegistryRequest)(nil), "google.cloud.iot.v1.UpdateDeviceRegistryRequest")
	proto.RegisterType((*ListDeviceRegistriesRequest)(nil), "google.cloud.iot.v1.ListDeviceRegistriesRequest")
	proto.RegisterType((*ListDeviceRegistriesResponse)(nil), "google.cloud.iot.v1.ListDeviceRegistriesResponse")
	proto.RegisterType((*CreateDeviceRequest)(nil), "google.cloud.iot.v1.CreateDeviceRequest")
	proto.RegisterType((*GetDeviceRequest)(nil), "google.cloud.iot.v1.GetDeviceRequest")
	proto.RegisterType((*UpdateDeviceRequest)(nil), "google.cloud.iot.v1.UpdateDeviceRequest")
	proto.RegisterType((*DeleteDeviceRequest)(nil), "google.cloud.iot.v1.DeleteDeviceRequest")
	proto.RegisterType((*ListDevicesRequest)(nil), "google.cloud.iot.v1.ListDevicesRequest")
	proto.RegisterType((*GatewayListOptions)(nil), "google.cloud.iot.v1.GatewayListOptions")
	proto.RegisterType((*ListDevicesResponse)(nil), "google.cloud.iot.v1.ListDevicesResponse")
	proto.RegisterType((*ModifyCloudToDeviceConfigRequest)(nil), "google.cloud.iot.v1.ModifyCloudToDeviceConfigRequest")
	proto.RegisterType((*ListDeviceConfigVersionsRequest)(nil), "google.cloud.iot.v1.ListDeviceConfigVersionsRequest")
	proto.RegisterType((*ListDeviceConfigVersionsResponse)(nil), "google.cloud.iot.v1.ListDeviceConfigVersionsResponse")
	proto.RegisterType((*ListDeviceStatesRequest)(nil), "google.cloud.iot.v1.ListDeviceStatesRequest")
	proto.RegisterType((*ListDeviceStatesResponse)(nil), "google.cloud.iot.v1.ListDeviceStatesResponse")
	proto.RegisterType((*SendCommandToDeviceRequest)(nil), "google.cloud.iot.v1.SendCommandToDeviceRequest")
	proto.RegisterType((*SendCommandToDeviceResponse)(nil), "google.cloud.iot.v1.SendCommandToDeviceResponse")
	proto.RegisterType((*BindDeviceToGatewayRequest)(nil), "google.cloud.iot.v1.BindDeviceToGatewayRequest")
	proto.RegisterType((*BindDeviceToGatewayResponse)(nil), "google.cloud.iot.v1.BindDeviceToGatewayResponse")
	proto.RegisterType((*UnbindDeviceFromGatewayRequest)(nil), "google.cloud.iot.v1.UnbindDeviceFromGatewayRequest")
	proto.RegisterType((*UnbindDeviceFromGatewayResponse)(nil), "google.cloud.iot.v1.UnbindDeviceFromGatewayResponse")
}

func init() {
	proto.RegisterFile("google/cloud/iot/v1/device_manager.proto", fileDescriptor_9243c344ef472aff)
}

var fileDescriptor_9243c344ef472aff = []byte{
	// 2060 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x5a, 0xcd, 0x6f, 0x1b, 0xc7,
	0x15, 0xf7, 0x50, 0xae, 0x6a, 0x3d, 0xd1, 0xb1, 0x3d, 0x52, 0x2c, 0x85, 0xf4, 0x07, 0xbd, 0x4e,
	0x1d, 0x45, 0x90, 0xb9, 0xb6, 0x12, 0x07, 0xae, 0x8a, 0xd4, 0x5d, 0x49, 0xb6, 0xe4, 0xc2, 0x4a,
	0xe5, 0x95, 0x9c, 0xb6, 0x2a, 0x50, 0x66, 0x45, 0x8e, 0xe8, 0x8d, 0xb9, 0x3b, 0xdb, 0xdd, 0xa1,
	0x5c, 0xa5, 0x30, 0x5a, 0xf4, 0x56, 0xa0, 0x29, 0x10, 0xe4, 0xd0, 0x16, 0x4d, 0x90, 0x53, 0x02,
	0xf4, 0xbb, 0x68, 0xd1, 0x43, 0x80, 0xe6, 0xd2, 0x63, 0x7a, 0x28, 0xda, 0x1c, 0x0a, 0xf0, 0xd0,
	0xe6, 0xe0, 0x7f, 0xa0, 0xe8, 0xc5, 0xe8, 0xa9, 0xd8, 0x99, 0x59, 0x72, 0x77, 0xb9, 0x4b, 0x2e,
	0x29, 0x1e, 0x7a, 0xb3, 0x66, 0xde, 0xbc, 0xf7, 0x7b, 0xbf, 0xf7, 0xb1, 0xf3, 0x86, 0x86, 0xb9,
	0x3a, 0xa5, 0xf5, 0x06, 0x51, 0xab, 0x0d, 0xda, 0xac, 0xa9, 0x26, 0x65, 0xea, 0xfe, 0x55, 0xb5,
	0x46, 0xf6, 0xcd, 0x2a, 0xa9, 0x58, 0x86, 0x6d, 0xd4, 0x89, 0x5b, 0x76, 0x5c, 0xca, 0x28, 0x9e,
	0x12, 0x92, 0x65, 0x2e, 0x59, 0x36, 0x29, 0x2b, 0xef, 0x5f, 0x2d, 0x9c, 0x91, 0xc7, 0x0d, 0xc7,
	0x54, 0x0d, 0xdb, 0xa6, 0xcc, 0x60, 0x26, 0xb5, 0x3d, 0x71, 0xa4, 0x30, 0x13, 0xda, 0xad, 0x36,
	0x4c, 0x62, 0x33, 0xb9, 0x71, 0x3e, 0xb4, 0xb1, 0x67, 0x92, 0x46, 0xad, 0xb2, 0x4b, 0xee, 0x1b,
	0xfb, 0x26, 0x95, 0xc6, 0x0a, 0xcf, 0x84, 0x04, 0x5c, 0xe2, 0xd1, 0xa6, 0x5b, 0x25, 0x72, 0xeb,
	0x62, 0x12, 0xe2, 0x40, 0x26, 0xb0, 0x7c, 0x4e, 0x0a, 0x99, 0x86, 0xe5, 0x6f, 0x9b, 0x86, 0x55,
	0x71, 0x68, 0xc3, 0xac, 0x1e, 0xc8, 0xfd, 0x42, 0x74, 0x3f, 0xb2, 0x57, 0x94, 0x7b, 0xfc, 0xaf,
	0xdd, 0xe6, 0x9e, 0x4a, 0x2c, 0x87, 0x05, 0x9b, 0xa5, 0xf8, 0xa6, 0x80, 0x6f, 0x19, 0xde, 0x83,
	0x98, 0xd3, 0xae, 0x53, 0x55, 0x3d, 0x66, 0xb0, 0xa6, 0xc4, 0xa4, 0xfc, 0x01, 0x41, 0x71, 0xc5,
	0x25, 0x06, 0x23, 0xab, 0x9c, 0x5f, 0x9d, 0xd4, 0x4d, 0x8f, 0xb9, 0x07, 0x3a, 0xf9, 0x56, 0x93,
	0x78, 0x0c, 0x6b, 0x30, 0xee, 0x18, 0x2e, 0xb1, 0xd9, 0x2c, 0x2a, 0xa1, 0xb9, 0x89, 0xe5, 0xe7,
	0x3f, 0xd5, 0x72, 0xff, 0xd5, 0x2e, 0xc2, 0x85, 0x06, 0xad, 0x4a, 0x5a, 0x85, 0x6a, 0xc3, 0x31,
	0xbd, 0x72, 0x95, 0x5a, 0xea, 0x1d, 0xb9, 0xa1, 0xcb, 0x83, 0xf8, 0x2e, 0x9c, 0x90, 0xb1, 0x73,
	0xa5, 0xf2, 0xd9, 0x5c, 0x09, 0xcd, 0x4d, 0x2e, 0x5e, 0x2c, 0x27, 0x44, 0xaf, 0x1c, 0xc5, 0xb1,
	0x3c, 0xf6, 0xa9, 0x96, 0xd3, 0x9f, 0xaa, 0x45, 0x16, 0x95, 0x6f, 0xc2, 0xec, 0x1a, 0x61, 0xc9,
	0x88, 0x97, 0xe1, 0xa8, 0x6d, 0x58, 0x44, 0xe2, 0x2d, 0x73, 0xbc, 0x73, 0x70, 0x89, 0xdb, 0xf0,
	0x4d, 0xc4, 0xe0, 0xc6, 0x94, 0xf0, 0xb3, 0x8a, 0x01, 0xc5, 0x55, 0xd2, 0x20, 0x69, 0xa4, 0x8c,
	0xc2, 0xc4, 0xef, 0x11, 0x14, 0xef, 0x39, 0xb5, 0x54, 0xe2, 0x13, 0x58, 0x43, 0x87, 0x63, 0x0d,
	0x7f, 0x09, 0x26, 0x9b, 0xdc, 0x22, 0xcf, 0x0c, 0x19, 0x84, 0x42, 0xa0, 0x2e, 0x48, 0x9e, 0xf2,
	0x2d, 0x3f, 0x79, 0x36, 0x0c, 0xef, 0x81, 0xd0, 0x02, 0xe2, 0x8c, 0xbf, 0xa0, 0xbc, 0x83, 0xa0,
	0x78, 0xc7, 0xf4, 0xa2, 0xcc, 0x9b, 0xc4, 0x1b, 0x61, 0xb6, 0x14, 0x61, 0xc2, 0x31, 0xea, 0xa4,
	0xe2, 0x99, 0x6f, 0x10, 0x0e, 0xf1, 0x33, 0xfa, 0x31, 0x7f, 0x61, 0xcb, 0x7c, 0x83, 0xe0, 0xb3,
	0x00, 0x7c, 0x93, 0xd1, 0x07, 0xc4, 0x9e, 0x1d, 0xf3, 0x6d, 0xe8, 0x5c, 0x7c, 0xdb, 0x5f, 0x50,
	0x7e, 0x82, 0xe0, 0x4c, 0x32, 0x3c, 0xcf, 0xa1, 0xb6, 0x47, 0xf0, 0x26, 0x9c, 0x8a, 0x92, 0x6a,
	0x12, 0x6f, 0x16, 0x95, 0xc6, 0x32, 0xd2, 0xaa, 0x9f, 0xac, 0xc5, 0x34, 0xe3, 0x4b, 0x70, 0xc2,
	0x26, 0xdf, 0x66, 0x95, 0x10, 0xac, 0x1c, 0x87, 0x75, 0xdc, 0x5f, 0xde, 0x6c, 0x43, 0xfb, 0x31,
	0x82, 0xa9, 0x68, 0x9d, 0x09, 0xc6, 0x6e, 0xc5, 0x18, 0x1b, 0x34, 0x99, 0x02, 0xda, 0xae, 0xc3,
	0xb8, 0xc0, 0x26, 0xc3, 0x5a, 0xec, 0xe1, 0x8e, 0x88, 0xab, 0x94, 0x57, 0x7e, 0x80, 0xe0, 0x64,
	0xa8, 0x98, 0x04, 0xac, 0xa5, 0x48, 0x86, 0x5f, 0xe2, 0xa0, 0x4a, 0x70, 0xae, 0x0f, 0x28, 0x7e,
	0x06, 0x7f, 0x1e, 0xa0, 0xd3, 0x7f, 0xfa, 0x67, 0x99, 0x3e, 0xb1, 0x17, 0xfc, 0x53, 0x79, 0x0b,
	0xc1, 0x54, 0xb4, 0x28, 0x04, 0x9c, 0xa1, 0xbd, 0x8b, 0xe7, 0xfc, 0xd8, 0xe0, 0x39, 0x7f, 0x17,
	0xa6, 0xa2, 0xbd, 0xe0, 0xd0, 0x0c, 0x29, 0xff, 0xc9, 0x01, 0xee, 0xe4, 0xa9, 0x37, 0xea, 0x5c,
	0x78, 0x16, 0x64, 0xe5, 0x57, 0xec, 0xa6, 0x55, 0x31, 0x6b, 0xde, 0x6c, 0xae, 0x34, 0x36, 0x77,
	0x54, 0xcf, 0x8b, 0xd5, 0x57, 0x9a, 0xd6, 0xed, 0x9a, 0xe7, 0xd7, 0x92, 0x94, 0xf2, 0x25, 0xc6,
	0x4a, 0x63, 0x7e, 0x2d, 0x89, 0x15, 0x7f, 0x3b, 0x1a, 0xc5, 0xa3, 0x03, 0x44, 0x11, 0x7f, 0x1d,
	0xa6, 0xeb, 0x06, 0x23, 0x0f, 0x8d, 0x83, 0x4a, 0xc3, 0xf4, 0x58, 0x85, 0x3a, 0xbc, 0xf4, 0x67,
	0xc7, 0xb9, 0x92, 0xe7, 0x12, 0x63, 0xb7, 0x26, 0x0e, 0xf8, 0xac, 0x7c, 0x45, 0x88, 0xeb, 0xb8,
	0xde, 0xb5, 0x16, 0xed, 0x0e, 0xb5, 0x9e, 0xdd, 0x81, 0xc4, 0xbb, 0xc3, 0x3f, 0x10, 0xe0, 0x6e,
	0x33, 0xf8, 0x26, 0xe4, 0x03, 0xb4, 0xec, 0xc0, 0x11, 0x01, 0x7d, 0x6a, 0xb1, 0xd4, 0x0b, 0xe5,
	0xf6, 0x81, 0x43, 0xd6, 0x8f, 0xe8, 0x93, 0xf5, 0xce, 0x9f, 0xf8, 0x3a, 0xcc, 0x18, 0x9e, 0x47,
	0xab, 0xa6, 0xe8, 0x73, 0x95, 0x40, 0xa7, 0x59, 0x13, 0x0d, 0x61, 0xfd, 0x88, 0xfe, 0x74, 0x58,
	0x40, 0xaa, 0xba, 0x5d, 0xc3, 0x2f, 0xc1, 0xe9, 0xc8, 0xc9, 0x76, 0x54, 0x44, 0x83, 0x5b, 0x3f,
	0xa2, 0x4f, 0x87, 0xf7, 0x57, 0x65, 0x88, 0x96, 0x8f, 0xc1, 0xf8, 0x9e, 0xd9, 0x60, 0xc4, 0x55,
	0x18, 0x4c, 0x45, 0xd2, 0x49, 0x76, 0xbb, 0x6b, 0xf0, 0x59, 0xa1, 0x2b, 0xe8, 0x71, 0xbd, 0xca,
	0x46, 0x0f, 0x64, 0x33, 0xb7, 0xb4, 0xdf, 0x21, 0x28, 0x6d, 0xd0, 0x9a, 0xb9, 0x77, 0xb0, 0xe2,
	0xab, 0xdb, 0xa6, 0x42, 0xd1, 0x0a, 0xb5, 0xf7, 0xcc, 0xfa, 0x28, 0x1a, 0xc9, 0x3c, 0x9c, 0xda,
	0x27, 0xae, 0x67, 0x52, 0xbb, 0xc2, 0x68, 0x45, 0x94, 0x24, 0x87, 0x32, 0xa6, 0x9f, 0x90, 0x1b,
	0xdb, 0x54, 0xb4, 0x0b, 0xfc, 0x2c, 0x4c, 0xee, 0x9a, 0xb6, 0xe1, 0x1e, 0x54, 0x6a, 0x06, 0x33,
	0x38, 0x73, 0x79, 0x59, 0xcb, 0x62, 0x7d, 0xd5, 0x60, 0x86, 0xf2, 0x3d, 0x04, 0xe7, 0x3b, 0x4c,
	0x09, 0xa4, 0xaf, 0x0a, 0x4d, 0xde, 0x28, 0x10, 0x5f, 0x80, 0xbc, 0x5f, 0x72, 0x12, 0x9c, 0x27,
	0xbf, 0x5f, 0x93, 0x76, 0xd3, 0x0a, 0xac, 0x28, 0x0d, 0x28, 0xa5, 0x23, 0x90, 0x81, 0x5b, 0x6f,
	0x17, 0x70, 0x95, 0x0b, 0x04, 0xf1, 0xbb, 0xd0, 0x23, 0x7e, 0x92, 0xf6, 0xe3, 0xb5, 0xd0, 0x5f,
	0x9e, 0xc2, 0x60, 0xa6, 0x63, 0x6d, 0x8b, 0x19, 0x8c, 0x8c, 0xc4, 0xcf, 0xb3, 0x00, 0xbe, 0x9f,
	0x1e, 0x57, 0x28, 0xbd, 0x9c, 0xb0, 0x9b, 0x96, 0xb0, 0xa0, 0x18, 0x30, 0xdb, 0x6d, 0x55, 0xfa,
	0x76, 0x13, 0x24, 0xc4, 0xe0, 0xb4, 0x70, 0xad, 0xd4, 0xc3, 0x35, 0xae, 0x21, 0xe8, 0x5e, 0xd2,
	0xc4, 0x3b, 0x08, 0x0a, 0x5b, 0xc4, 0xae, 0xad, 0x50, 0xcb, 0x32, 0xec, 0x76, 0xf2, 0x8d, 0xc2,
	0xb9, 0x58, 0x2a, 0xe5, 0x12, 0x53, 0x09, 0x9f, 0x81, 0x09, 0xaf, 0xb9, 0xbb, 0x47, 0x1b, 0x35,
	0xe2, 0x06, 0x37, 0x91, 0xf6, 0x82, 0x72, 0x16, 0x8a, 0x89, 0xe8, 0x04, 0x09, 0xca, 0x2f, 0x10,
	0x14, 0x96, 0x4d, 0xbb, 0x26, 0x96, 0xb7, 0xa9, 0x6c, 0x06, 0xa3, 0xfe, 0x10, 0x28, 0x00, 0xf1,
	0x36, 0x24, 0x1c, 0x99, 0xa8, 0xb7, 0xbb, 0x4f, 0x09, 0x26, 0x62, 0x0d, 0x47, 0x88, 0x1c, 0x0b,
	0x3e, 0x05, 0xbe, 0x2f, 0x89, 0x58, 0xa5, 0x2f, 0xbf, 0x41, 0x70, 0xee, 0x9e, 0xbd, 0xdb, 0x96,
	0xb8, 0xe5, 0x52, 0xeb, 0xff, 0xda, 0x9f, 0x0b, 0x70, 0x3e, 0x15, 0xaf, 0xf0, 0x69, 0xf1, 0x83,
	0x4b, 0x70, 0x5c, 0xec, 0x6e, 0x88, 0x71, 0x13, 0xff, 0x15, 0xc1, 0x74, 0xd2, 0x9c, 0x84, 0xaf,
	0x24, 0x26, 0x6e, 0x8f, 0x91, 0xaa, 0x90, 0xe5, 0xa6, 0xa9, 0xbc, 0xd6, 0xd2, 0x4e, 0x0b, 0xaf,
	0x17, 0x62, 0x63, 0xc0, 0xf7, 0x3f, 0x79, 0xfc, 0x76, 0x4e, 0x53, 0xca, 0xfe, 0x88, 0xf8, 0x1d,
	0x21, 0xf2, 0xb2, 0xe3, 0xd2, 0xd7, 0x49, 0x95, 0x79, 0xea, 0xbc, 0xda, 0xbe, 0x69, 0xab, 0xf3,
	0x8f, 0xd4, 0xce, 0x2d, 0x77, 0x29, 0x3e, 0x4d, 0xe0, 0x0f, 0x10, 0x9c, 0xea, 0x1a, 0xa2, 0xf0,
	0xe5, 0xe4, 0xef, 0x5e, 0xca, 0xb0, 0x95, 0xcd, 0x97, 0x97, 0x5b, 0x1a, 0xaf, 0x2c, 0x8e, 0xfc,
	0x0a, 0x16, 0xc8, 0xfd, 0x85, 0x14, 0xdc, 0x21, 0xd8, 0xea, 0xfc, 0x23, 0xfc, 0x18, 0xc1, 0x74,
	0xd2, 0xa4, 0x94, 0x42, 0x7d, 0x8f, 0xa1, 0x2a, 0x1b, 0xdc, 0x66, 0x4b, 0x2b, 0xc6, 0xc8, 0x5a,
	0x08, 0xdd, 0x21, 0xb9, 0x17, 0x77, 0x17, 0xbf, 0xc8, 0xbd, 0x88, 0xc9, 0x95, 0x33, 0x7b, 0xd5,
	0x1d, 0x8f, 0xf7, 0x10, 0x4c, 0x27, 0x0d, 0x9d, 0x29, 0x6e, 0xf6, 0x98, 0x4f, 0x0b, 0xa7, 0xbb,
	0xee, 0x69, 0x37, 0x2d, 0x87, 0xc5, 0x03, 0x31, 0x3f, 0x68, 0x20, 0xfe, 0x84, 0x60, 0x3a, 0x69,
	0xbc, 0x4a, 0x41, 0xd8, 0x63, 0x50, 0x2c, 0x5c, 0x1d, 0xe0, 0x84, 0xec, 0x33, 0x37, 0x5a, 0x9a,
	0xec, 0x03, 0x91, 0x3c, 0xca, 0x5c, 0x01, 0xf8, 0xb7, 0x08, 0xf2, 0xe1, 0xba, 0xc4, 0x73, 0x19,
	0x4a, 0x57, 0xc0, 0xed, 0x75, 0x71, 0x52, 0xbe, 0xd6, 0xd2, 0x8e, 0x47, 0x4a, 0x95, 0xe3, 0x5b,
	0x56, 0xae, 0xf7, 0xc7, 0x17, 0x25, 0x58, 0x3e, 0x71, 0x79, 0x4b, 0xc1, 0xf0, 0xf2, 0x4f, 0x04,
	0x13, 0xed, 0xd2, 0xc3, 0x9f, 0xeb, 0x57, 0x9a, 0x19, 0xb0, 0xfe, 0x10, 0x85, 0x53, 0xe0, 0xbb,
	0xf8, 0xfa, 0x40, 0x29, 0x10, 0x00, 0x54, 0xe7, 0x1f, 0xed, 0xac, 0x60, 0x6d, 0xb0, 0xb3, 0x75,
	0x97, 0x36, 0x9d, 0xa8, 0x12, 0xfc, 0x56, 0x0e, 0xf2, 0xe1, 0x7a, 0x4d, 0x09, 0x49, 0xc2, 0x48,
	0xd8, 0xdb, 0xcd, 0x0f, 0x51, 0x4b, 0xc3, 0xc2, 0x4e, 0x57, 0xe9, 0xbe, 0x8b, 0x16, 0x6f, 0x84,
	0x6a, 0xb7, 0x3c, 0x84, 0xf3, 0x41, 0x80, 0x76, 0xf4, 0xc5, 0xf5, 0xa1, 0x54, 0x25, 0x70, 0xd1,
	0x0e, 0xfa, 0x4f, 0x11, 0xe4, 0xc3, 0xc5, 0x9d, 0xc2, 0x49, 0xc2, 0x4c, 0x9a, 0x5a, 0xf7, 0x6b,
	0xe1, 0xa0, 0x2f, 0xcd, 0x0f, 0x1d, 0x74, 0xfc, 0x6f, 0x04, 0x93, 0xa1, 0x49, 0x03, 0x3f, 0xd7,
	0xa7, 0x8c, 0xdb, 0xf5, 0x3e, 0xd7, 0x5f, 0x50, 0x96, 0xf9, 0x8f, 0x50, 0xb4, 0xce, 0x83, 0x1c,
	0x1d, 0xa2, 0x8e, 0xda, 0x39, 0x9a, 0xfd, 0x6c, 0x3b, 0x32, 0x6d, 0x25, 0xf8, 0x2f, 0x39, 0x78,
	0x26, 0x75, 0xcc, 0xc1, 0xd7, 0x12, 0x1d, 0xeb, 0x37, 0x16, 0x15, 0xfa, 0xdf, 0xe4, 0x95, 0x4f,
	0x50, 0x4b, 0x3b, 0xe9, 0x07, 0x69, 0x21, 0x74, 0x1b, 0xe5, 0x94, 0x7c, 0x88, 0x14, 0x7d, 0xd8,
	0x10, 0x2e, 0x59, 0x69, 0xd0, 0x96, 0xd0, 0xfc, 0xce, 0x6b, 0xca, 0x37, 0x0e, 0x5d, 0xd4, 0x3d,
	0x2d, 0xe0, 0x3f, 0xe6, 0xc2, 0xb3, 0x41, 0x74, 0xfe, 0xc1, 0x2f, 0xf6, 0xc9, 0x92, 0xc4, 0x81,
	0xad, 0x70, 0x6d, 0xc0, 0x53, 0x32, 0xd1, 0x7e, 0x19, 0x69, 0x85, 0xef, 0x22, 0xbc, 0x36, 0x2c,
	0xa7, 0x6a, 0x35, 0x62, 0x61, 0x47, 0xc7, 0x9b, 0x87, 0x66, 0x31, 0xa6, 0x13, 0xbf, 0x99, 0x83,
	0x93, 0xf1, 0x99, 0x0a, 0x2f, 0xf4, 0xf1, 0x3c, 0x32, 0xf0, 0x15, 0x2e, 0x67, 0x94, 0x96, 0xfc,
	0xfc, 0x2c, 0xc2, 0xcf, 0x9b, 0x08, 0xdf, 0x18, 0x9a, 0x1f, 0x31, 0xe9, 0xed, 0x7c, 0x19, 0xaf,
	0x1f, 0x9e, 0x17, 0xa1, 0x0b, 0x3f, 0x41, 0x90, 0xdf, 0x22, 0xec, 0xb6, 0x61, 0x6d, 0xf2, 0x9f,
	0x49, 0xb0, 0x12, 0x78, 0x67, 0x1a, 0x96, 0xef, 0x57, 0x78, 0x33, 0x60, 0xe0, 0xe9, 0x98, 0x8c,
	0xd8, 0x55, 0x7e, 0x85, 0x5a, 0xda, 0x89, 0xe0, 0xc7, 0x9a, 0x05, 0xf1, 0xb3, 0x0b, 0x77, 0xfa,
	0x6d, 0xa4, 0x08, 0xa7, 0x83, 0xcd, 0x6c, 0x57, 0x3b, 0x2f, 0x64, 0xda, 0xaf, 0xaa, 0x0d, 0x65,
	0x7d, 0x60, 0x2d, 0x9d, 0x46, 0x14, 0x57, 0xe7, 0x37, 0xe1, 0xfc, 0x5a, 0x2f, 0xd7, 0xd7, 0xb2,
	0xbb, 0xfe, 0x3e, 0x6a, 0x69, 0xc7, 0x02, 0x5c, 0x87, 0xf1, 0xb9, 0x3e, 0x5a, 0x9f, 0x63, 0xea,
	0xf0, 0xcf, 0x73, 0x80, 0xb7, 0x89, 0xc7, 0x17, 0x89, 0x6b, 0x99, 0x9e, 0xa8, 0x8a, 0xb9, 0x98,
	0x57, 0xdd, 0x22, 0x81, 0xff, 0xcf, 0x67, 0x90, 0x94, 0x89, 0xff, 0x11, 0x6a, 0x69, 0xd3, 0x9d,
	0x74, 0xe8, 0x48, 0x70, 0x7e, 0xde, 0x43, 0xca, 0xcd, 0x21, 0xf8, 0x61, 0x5d, 0xf6, 0x7c, 0x96,
	0xb6, 0x94, 0x57, 0x0e, 0xc3, 0x52, 0xa2, 0x52, 0xfc, 0xaf, 0x1c, 0x4c, 0x25, 0x3c, 0x3e, 0x60,
	0x35, 0xb1, 0xfe, 0xd3, 0x1f, 0x51, 0x0a, 0x57, 0xb2, 0x1f, 0x90, 0xd4, 0x3d, 0x4e, 0xfa, 0x66,
	0xb5, 0xb4, 0x42, 0x7c, 0x69, 0xa1, 0xfd, 0x52, 0xc2, 0x39, 0xfd, 0x35, 0x52, 0xee, 0x0c, 0xfd,
	0x41, 0xf3, 0xba, 0xf1, 0xf8, 0xd4, 0xee, 0x28, 0xf7, 0x0e, 0xff, 0x29, 0x4b, 0xd6, 0x8d, 0x3f,
	0xca, 0xc1, 0x54, 0xc2, 0x93, 0x48, 0x0a, 0xc3, 0xe9, 0x0f, 0x3d, 0x29, 0x0c, 0xf7, 0x7a, 0x6d,
	0xf9, 0x33, 0x6a, 0x69, 0x45, 0x39, 0x6d, 0x74, 0xde, 0x42, 0x16, 0xda, 0x4f, 0x1e, 0xf2, 0x63,
	0xa6, 0xac, 0x0e, 0x7a, 0x69, 0x5a, 0xda, 0xed, 0xb6, 0xea, 0xf3, 0xa8, 0x2b, 0x1b, 0x43, 0xdf,
	0xa1, 0x52, 0x74, 0xe2, 0xbf, 0xe5, 0x60, 0x26, 0xe5, 0x09, 0x06, 0xbf, 0x90, 0x3c, 0x01, 0xf4,
	0x7c, 0x60, 0x2a, 0xbc, 0x38, 0xd8, 0x21, 0xc9, 0xe5, 0xc7, 0x59, 0xb8, 0x7c, 0x1f, 0xc9, 0x4e,
	0x36, 0x08, 0x97, 0xcd, 0x64, 0xcb, 0x3e, 0x9f, 0xaf, 0x2a, 0x77, 0x87, 0xe7, 0x33, 0x5d, 0x6f,
	0x81, 0x7d, 0xac, 0xcd, 0xa4, 0x3c, 0xa7, 0xfd, 0x5d, 0xfb, 0xea, 0x7d, 0xc6, 0x1c, 0x6f, 0x49,
	0x55, 0x1f, 0x3e, 0x7c, 0x18, 0x7f, 0x6b, 0x33, 0x9a, 0xec, 0xbe, 0xf8, 0x7f, 0x0b, 0x97, 0x9d,
	0x86, 0xc1, 0xf6, 0xa8, 0x6b, 0x2d, 0x64, 0x12, 0x37, 0x29, 0x5b, 0x7e, 0x1d, 0x66, 0xaa, 0xd4,
	0x4a, 0x62, 0x7f, 0x19, 0x47, 0x1e, 0xd0, 0x36, 0xfd, 0x89, 0x64, 0x13, 0xed, 0xbc, 0x24, 0x45,
	0xeb, 0xb4, 0x61, 0xd8, 0xf5, 0x32, 0x75, 0xeb, 0x6a, 0x9d, 0xd8, 0x7c, 0x5e, 0x51, 0x3b, 0x96,
	0x22, 0xff, 0x8f, 0xe2, 0x0b, 0x26, 0x65, 0x4f, 0x10, 0xda, 0x1d, 0xe7, 0x52, 0x2f, 0xfc, 0x2f,
	0x00, 0x00, 0xff, 0xff, 0xf4, 0x8c, 0x0d, 0xd2, 0x1e, 0x22, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// DeviceManagerClient is the client API for DeviceManager service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DeviceManagerClient interface {
	// Creates a device registry that contains devices.
	CreateDeviceRegistry(ctx context.Context, in *CreateDeviceRegistryRequest, opts ...grpc.CallOption) (*DeviceRegistry, error)
	// Gets a device registry configuration.
	GetDeviceRegistry(ctx context.Context, in *GetDeviceRegistryRequest, opts ...grpc.CallOption) (*DeviceRegistry, error)
	// Updates a device registry configuration.
	UpdateDeviceRegistry(ctx context.Context, in *UpdateDeviceRegistryRequest, opts ...grpc.CallOption) (*DeviceRegistry, error)
	// Deletes a device registry configuration.
	DeleteDeviceRegistry(ctx context.Context, in *DeleteDeviceRegistryRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Lists device registries.
	ListDeviceRegistries(ctx context.Context, in *ListDeviceRegistriesRequest, opts ...grpc.CallOption) (*ListDeviceRegistriesResponse, error)
	// Creates a device in a device registry.
	CreateDevice(ctx context.Context, in *CreateDeviceRequest, opts ...grpc.CallOption) (*Device, error)
	// Gets details about a device.
	GetDevice(ctx context.Context, in *GetDeviceRequest, opts ...grpc.CallOption) (*Device, error)
	// Updates a device.
	UpdateDevice(ctx context.Context, in *UpdateDeviceRequest, opts ...grpc.CallOption) (*Device, error)
	// Deletes a device.
	DeleteDevice(ctx context.Context, in *DeleteDeviceRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// List devices in a device registry.
	ListDevices(ctx context.Context, in *ListDevicesRequest, opts ...grpc.CallOption) (*ListDevicesResponse, error)
	// Modifies the configuration for the device, which is eventually sent from
	// the Cloud IoT Core servers. Returns the modified configuration version and
	// its metadata.
	ModifyCloudToDeviceConfig(ctx context.Context, in *ModifyCloudToDeviceConfigRequest, opts ...grpc.CallOption) (*DeviceConfig, error)
	// Lists the last few versions of the device configuration in descending
	// order (i.e.: newest first).
	ListDeviceConfigVersions(ctx context.Context, in *ListDeviceConfigVersionsRequest, opts ...grpc.CallOption) (*ListDeviceConfigVersionsResponse, error)
	// Lists the last few versions of the device state in descending order (i.e.:
	// newest first).
	ListDeviceStates(ctx context.Context, in *ListDeviceStatesRequest, opts ...grpc.CallOption) (*ListDeviceStatesResponse, error)
	// Sets the access control policy on the specified resource. Replaces any
	// existing policy.
	SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Gets the access control policy for a resource.
	// Returns an empty policy if the resource exists and does not have a policy
	// set.
	GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Returns permissions that a caller has on the specified resource.
	// If the resource does not exist, this will return an empty set of
	// permissions, not a NOT_FOUND error.
	TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error)
	// Sends a command to the specified device. In order for a device to be able
	// to receive commands, it must:
	// 1) be connected to Cloud IoT Core using the MQTT protocol, and
	// 2) be subscribed to the group of MQTT topics specified by
	//    /devices/{device-id}/commands/#. This subscription will receive commands
	//    at the top-level topic /devices/{device-id}/commands as well as commands
	//    for subfolders, like /devices/{device-id}/commands/subfolder.
	//    Note that subscribing to specific subfolders is not supported.
	// If the command could not be delivered to the device, this method will
	// return an error; in particular, if the device is not subscribed, this
	// method will return FAILED_PRECONDITION. Otherwise, this method will
	// return OK. If the subscription is QoS 1, at least once delivery will be
	// guaranteed; for QoS 0, no acknowledgment will be expected from the device.
	SendCommandToDevice(ctx context.Context, in *SendCommandToDeviceRequest, opts ...grpc.CallOption) (*SendCommandToDeviceResponse, error)
	// Associates the device with the gateway.
	BindDeviceToGateway(ctx context.Context, in *BindDeviceToGatewayRequest, opts ...grpc.CallOption) (*BindDeviceToGatewayResponse, error)
	// Deletes the association between the device and the gateway.
	UnbindDeviceFromGateway(ctx context.Context, in *UnbindDeviceFromGatewayRequest, opts ...grpc.CallOption) (*UnbindDeviceFromGatewayResponse, error)
}

type deviceManagerClient struct {
	cc *grpc.ClientConn
}

func NewDeviceManagerClient(cc *grpc.ClientConn) DeviceManagerClient {
	return &deviceManagerClient{cc}
}

func (c *deviceManagerClient) CreateDeviceRegistry(ctx context.Context, in *CreateDeviceRegistryRequest, opts ...grpc.CallOption) (*DeviceRegistry, error) {
	out := new(DeviceRegistry)
	err := c.cc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/CreateDeviceRegistry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) GetDeviceRegistry(ctx context.Context, in *GetDeviceRegistryRequest, opts ...grpc.CallOption) (*DeviceRegistry, error) {
	out := new(DeviceRegistry)
	err := c.cc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/GetDeviceRegistry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) UpdateDeviceRegistry(ctx context.Context, in *UpdateDeviceRegistryRequest, opts ...grpc.CallOption) (*DeviceRegistry, error) {
	out := new(DeviceRegistry)
	err := c.cc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/UpdateDeviceRegistry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) DeleteDeviceRegistry(ctx context.Context, in *DeleteDeviceRegistryRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/DeleteDeviceRegistry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) ListDeviceRegistries(ctx context.Context, in *ListDeviceRegistriesRequest, opts ...grpc.CallOption) (*ListDeviceRegistriesResponse, error) {
	out := new(ListDeviceRegistriesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/ListDeviceRegistries", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) CreateDevice(ctx context.Context, in *CreateDeviceRequest, opts ...grpc.CallOption) (*Device, error) {
	out := new(Device)
	err := c.cc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/CreateDevice", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) GetDevice(ctx context.Context, in *GetDeviceRequest, opts ...grpc.CallOption) (*Device, error) {
	out := new(Device)
	err := c.cc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/GetDevice", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) UpdateDevice(ctx context.Context, in *UpdateDeviceRequest, opts ...grpc.CallOption) (*Device, error) {
	out := new(Device)
	err := c.cc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/UpdateDevice", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) DeleteDevice(ctx context.Context, in *DeleteDeviceRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/DeleteDevice", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) ListDevices(ctx context.Context, in *ListDevicesRequest, opts ...grpc.CallOption) (*ListDevicesResponse, error) {
	out := new(ListDevicesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/ListDevices", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) ModifyCloudToDeviceConfig(ctx context.Context, in *ModifyCloudToDeviceConfigRequest, opts ...grpc.CallOption) (*DeviceConfig, error) {
	out := new(DeviceConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/ModifyCloudToDeviceConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) ListDeviceConfigVersions(ctx context.Context, in *ListDeviceConfigVersionsRequest, opts ...grpc.CallOption) (*ListDeviceConfigVersionsResponse, error) {
	out := new(ListDeviceConfigVersionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/ListDeviceConfigVersions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) ListDeviceStates(ctx context.Context, in *ListDeviceStatesRequest, opts ...grpc.CallOption) (*ListDeviceStatesResponse, error) {
	out := new(ListDeviceStatesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/ListDeviceStates", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error) {
	out := new(v1.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) SendCommandToDevice(ctx context.Context, in *SendCommandToDeviceRequest, opts ...grpc.CallOption) (*SendCommandToDeviceResponse, error) {
	out := new(SendCommandToDeviceResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/SendCommandToDevice", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) BindDeviceToGateway(ctx context.Context, in *BindDeviceToGatewayRequest, opts ...grpc.CallOption) (*BindDeviceToGatewayResponse, error) {
	out := new(BindDeviceToGatewayResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/BindDeviceToGateway", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceManagerClient) UnbindDeviceFromGateway(ctx context.Context, in *UnbindDeviceFromGatewayRequest, opts ...grpc.CallOption) (*UnbindDeviceFromGatewayResponse, error) {
	out := new(UnbindDeviceFromGatewayResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.iot.v1.DeviceManager/UnbindDeviceFromGateway", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DeviceManagerServer is the server API for DeviceManager service.
type DeviceManagerServer interface {
	// Creates a device registry that contains devices.
	CreateDeviceRegistry(context.Context, *CreateDeviceRegistryRequest) (*DeviceRegistry, error)
	// Gets a device registry configuration.
	GetDeviceRegistry(context.Context, *GetDeviceRegistryRequest) (*DeviceRegistry, error)
	// Updates a device registry configuration.
	UpdateDeviceRegistry(context.Context, *UpdateDeviceRegistryRequest) (*DeviceRegistry, error)
	// Deletes a device registry configuration.
	DeleteDeviceRegistry(context.Context, *DeleteDeviceRegistryRequest) (*empty.Empty, error)
	// Lists device registries.
	ListDeviceRegistries(context.Context, *ListDeviceRegistriesRequest) (*ListDeviceRegistriesResponse, error)
	// Creates a device in a device registry.
	CreateDevice(context.Context, *CreateDeviceRequest) (*Device, error)
	// Gets details about a device.
	GetDevice(context.Context, *GetDeviceRequest) (*Device, error)
	// Updates a device.
	UpdateDevice(context.Context, *UpdateDeviceRequest) (*Device, error)
	// Deletes a device.
	DeleteDevice(context.Context, *DeleteDeviceRequest) (*empty.Empty, error)
	// List devices in a device registry.
	ListDevices(context.Context, *ListDevicesRequest) (*ListDevicesResponse, error)
	// Modifies the configuration for the device, which is eventually sent from
	// the Cloud IoT Core servers. Returns the modified configuration version and
	// its metadata.
	ModifyCloudToDeviceConfig(context.Context, *ModifyCloudToDeviceConfigRequest) (*DeviceConfig, error)
	// Lists the last few versions of the device configuration in descending
	// order (i.e.: newest first).
	ListDeviceConfigVersions(context.Context, *ListDeviceConfigVersionsRequest) (*ListDeviceConfigVersionsResponse, error)
	// Lists the last few versions of the device state in descending order (i.e.:
	// newest first).
	ListDeviceStates(context.Context, *ListDeviceStatesRequest) (*ListDeviceStatesResponse, error)
	// Sets the access control policy on the specified resource. Replaces any
	// existing policy.
	SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error)
	// Gets the access control policy for a resource.
	// Returns an empty policy if the resource exists and does not have a policy
	// set.
	GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error)
	// Returns permissions that a caller has on the specified resource.
	// If the resource does not exist, this will return an empty set of
	// permissions, not a NOT_FOUND error.
	TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error)
	// Sends a command to the specified device. In order for a device to be able
	// to receive commands, it must:
	// 1) be connected to Cloud IoT Core using the MQTT protocol, and
	// 2) be subscribed to the group of MQTT topics specified by
	//    /devices/{device-id}/commands/#. This subscription will receive commands
	//    at the top-level topic /devices/{device-id}/commands as well as commands
	//    for subfolders, like /devices/{device-id}/commands/subfolder.
	//    Note that subscribing to specific subfolders is not supported.
	// If the command could not be delivered to the device, this method will
	// return an error; in particular, if the device is not subscribed, this
	// method will return FAILED_PRECONDITION. Otherwise, this method will
	// return OK. If the subscription is QoS 1, at least once delivery will be
	// guaranteed; for QoS 0, no acknowledgment will be expected from the device.
	SendCommandToDevice(context.Context, *SendCommandToDeviceRequest) (*SendCommandToDeviceResponse, error)
	// Associates the device with the gateway.
	BindDeviceToGateway(context.Context, *BindDeviceToGatewayRequest) (*BindDeviceToGatewayResponse, error)
	// Deletes the association between the device and the gateway.
	UnbindDeviceFromGateway(context.Context, *UnbindDeviceFromGatewayRequest) (*UnbindDeviceFromGatewayResponse, error)
}

// UnimplementedDeviceManagerServer can be embedded to have forward compatible implementations.
type UnimplementedDeviceManagerServer struct {
}

func (*UnimplementedDeviceManagerServer) CreateDeviceRegistry(ctx context.Context, req *CreateDeviceRegistryRequest) (*DeviceRegistry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDeviceRegistry not implemented")
}
func (*UnimplementedDeviceManagerServer) GetDeviceRegistry(ctx context.Context, req *GetDeviceRegistryRequest) (*DeviceRegistry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDeviceRegistry not implemented")
}
func (*UnimplementedDeviceManagerServer) UpdateDeviceRegistry(ctx context.Context, req *UpdateDeviceRegistryRequest) (*DeviceRegistry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDeviceRegistry not implemented")
}
func (*UnimplementedDeviceManagerServer) DeleteDeviceRegistry(ctx context.Context, req *DeleteDeviceRegistryRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDeviceRegistry not implemented")
}
func (*UnimplementedDeviceManagerServer) ListDeviceRegistries(ctx context.Context, req *ListDeviceRegistriesRequest) (*ListDeviceRegistriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDeviceRegistries not implemented")
}
func (*UnimplementedDeviceManagerServer) CreateDevice(ctx context.Context, req *CreateDeviceRequest) (*Device, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDevice not implemented")
}
func (*UnimplementedDeviceManagerServer) GetDevice(ctx context.Context, req *GetDeviceRequest) (*Device, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDevice not implemented")
}
func (*UnimplementedDeviceManagerServer) UpdateDevice(ctx context.Context, req *UpdateDeviceRequest) (*Device, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDevice not implemented")
}
func (*UnimplementedDeviceManagerServer) DeleteDevice(ctx context.Context, req *DeleteDeviceRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDevice not implemented")
}
func (*UnimplementedDeviceManagerServer) ListDevices(ctx context.Context, req *ListDevicesRequest) (*ListDevicesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDevices not implemented")
}
func (*UnimplementedDeviceManagerServer) ModifyCloudToDeviceConfig(ctx context.Context, req *ModifyCloudToDeviceConfigRequest) (*DeviceConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ModifyCloudToDeviceConfig not implemented")
}
func (*UnimplementedDeviceManagerServer) ListDeviceConfigVersions(ctx context.Context, req *ListDeviceConfigVersionsRequest) (*ListDeviceConfigVersionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDeviceConfigVersions not implemented")
}
func (*UnimplementedDeviceManagerServer) ListDeviceStates(ctx context.Context, req *ListDeviceStatesRequest) (*ListDeviceStatesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDeviceStates not implemented")
}
func (*UnimplementedDeviceManagerServer) SetIamPolicy(ctx context.Context, req *v1.SetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (*UnimplementedDeviceManagerServer) GetIamPolicy(ctx context.Context, req *v1.GetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (*UnimplementedDeviceManagerServer) TestIamPermissions(ctx context.Context, req *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}
func (*UnimplementedDeviceManagerServer) SendCommandToDevice(ctx context.Context, req *SendCommandToDeviceRequest) (*SendCommandToDeviceResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SendCommandToDevice not implemented")
}
func (*UnimplementedDeviceManagerServer) BindDeviceToGateway(ctx context.Context, req *BindDeviceToGatewayRequest) (*BindDeviceToGatewayResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BindDeviceToGateway not implemented")
}
func (*UnimplementedDeviceManagerServer) UnbindDeviceFromGateway(ctx context.Context, req *UnbindDeviceFromGatewayRequest) (*UnbindDeviceFromGatewayResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UnbindDeviceFromGateway not implemented")
}

func RegisterDeviceManagerServer(s *grpc.Server, srv DeviceManagerServer) {
	s.RegisterService(&_DeviceManager_serviceDesc, srv)
}

func _DeviceManager_CreateDeviceRegistry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDeviceRegistryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).CreateDeviceRegistry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/CreateDeviceRegistry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).CreateDeviceRegistry(ctx, req.(*CreateDeviceRegistryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_GetDeviceRegistry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDeviceRegistryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).GetDeviceRegistry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/GetDeviceRegistry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).GetDeviceRegistry(ctx, req.(*GetDeviceRegistryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_UpdateDeviceRegistry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDeviceRegistryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).UpdateDeviceRegistry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/UpdateDeviceRegistry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).UpdateDeviceRegistry(ctx, req.(*UpdateDeviceRegistryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_DeleteDeviceRegistry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDeviceRegistryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).DeleteDeviceRegistry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/DeleteDeviceRegistry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).DeleteDeviceRegistry(ctx, req.(*DeleteDeviceRegistryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_ListDeviceRegistries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDeviceRegistriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).ListDeviceRegistries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/ListDeviceRegistries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).ListDeviceRegistries(ctx, req.(*ListDeviceRegistriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_CreateDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDeviceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).CreateDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/CreateDevice",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).CreateDevice(ctx, req.(*CreateDeviceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_GetDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDeviceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).GetDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/GetDevice",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).GetDevice(ctx, req.(*GetDeviceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_UpdateDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDeviceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).UpdateDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/UpdateDevice",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).UpdateDevice(ctx, req.(*UpdateDeviceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_DeleteDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDeviceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).DeleteDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/DeleteDevice",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).DeleteDevice(ctx, req.(*DeleteDeviceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_ListDevices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDevicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).ListDevices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/ListDevices",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).ListDevices(ctx, req.(*ListDevicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_ModifyCloudToDeviceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ModifyCloudToDeviceConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).ModifyCloudToDeviceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/ModifyCloudToDeviceConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).ModifyCloudToDeviceConfig(ctx, req.(*ModifyCloudToDeviceConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_ListDeviceConfigVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDeviceConfigVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).ListDeviceConfigVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/ListDeviceConfigVersions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).ListDeviceConfigVersions(ctx, req.(*ListDeviceConfigVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_ListDeviceStates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDeviceStatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).ListDeviceStates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/ListDeviceStates",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).ListDeviceStates(ctx, req.(*ListDeviceStatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).SetIamPolicy(ctx, req.(*v1.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).GetIamPolicy(ctx, req.(*v1.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).TestIamPermissions(ctx, req.(*v1.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_SendCommandToDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SendCommandToDeviceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).SendCommandToDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/SendCommandToDevice",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).SendCommandToDevice(ctx, req.(*SendCommandToDeviceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_BindDeviceToGateway_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BindDeviceToGatewayRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).BindDeviceToGateway(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/BindDeviceToGateway",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).BindDeviceToGateway(ctx, req.(*BindDeviceToGatewayRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceManager_UnbindDeviceFromGateway_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UnbindDeviceFromGatewayRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceManagerServer).UnbindDeviceFromGateway(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.iot.v1.DeviceManager/UnbindDeviceFromGateway",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceManagerServer).UnbindDeviceFromGateway(ctx, req.(*UnbindDeviceFromGatewayRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DeviceManager_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.iot.v1.DeviceManager",
	HandlerType: (*DeviceManagerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateDeviceRegistry",
			Handler:    _DeviceManager_CreateDeviceRegistry_Handler,
		},
		{
			MethodName: "GetDeviceRegistry",
			Handler:    _DeviceManager_GetDeviceRegistry_Handler,
		},
		{
			MethodName: "UpdateDeviceRegistry",
			Handler:    _DeviceManager_UpdateDeviceRegistry_Handler,
		},
		{
			MethodName: "DeleteDeviceRegistry",
			Handler:    _DeviceManager_DeleteDeviceRegistry_Handler,
		},
		{
			MethodName: "ListDeviceRegistries",
			Handler:    _DeviceManager_ListDeviceRegistries_Handler,
		},
		{
			MethodName: "CreateDevice",
			Handler:    _DeviceManager_CreateDevice_Handler,
		},
		{
			MethodName: "GetDevice",
			Handler:    _DeviceManager_GetDevice_Handler,
		},
		{
			MethodName: "UpdateDevice",
			Handler:    _DeviceManager_UpdateDevice_Handler,
		},
		{
			MethodName: "DeleteDevice",
			Handler:    _DeviceManager_DeleteDevice_Handler,
		},
		{
			MethodName: "ListDevices",
			Handler:    _DeviceManager_ListDevices_Handler,
		},
		{
			MethodName: "ModifyCloudToDeviceConfig",
			Handler:    _DeviceManager_ModifyCloudToDeviceConfig_Handler,
		},
		{
			MethodName: "ListDeviceConfigVersions",
			Handler:    _DeviceManager_ListDeviceConfigVersions_Handler,
		},
		{
			MethodName: "ListDeviceStates",
			Handler:    _DeviceManager_ListDeviceStates_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _DeviceManager_SetIamPolicy_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _DeviceManager_GetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _DeviceManager_TestIamPermissions_Handler,
		},
		{
			MethodName: "SendCommandToDevice",
			Handler:    _DeviceManager_SendCommandToDevice_Handler,
		},
		{
			MethodName: "BindDeviceToGateway",
			Handler:    _DeviceManager_BindDeviceToGateway_Handler,
		},
		{
			MethodName: "UnbindDeviceFromGateway",
			Handler:    _DeviceManager_UnbindDeviceFromGateway_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/iot/v1/device_manager.proto",
}
