# Bugsnag error reporter for Go
[![Latest Version](http://img.shields.io/github/release/bugsnag/bugsnag-go.svg?style=flat-square)](https://github.com/bugsnag/bugsnag-go/releases)
[![Build Status](https://travis-ci.com/bugsnag/bugsnag-go.svg)](https://travis-ci.com/bugsnag/bugsnag-go)
[![Go Documentation](http://img.shields.io/badge/godoc-documentation-blue.svg?style=flat-square)](http://godoc.org/github.com/bugsnag/bugsnag-go)

Automatically detect crashes and report errors in your Go apps. Get alerts about errors and panics in real-time, including detailed error reports with diagnostic information. Understand and resolve issues as fast as possible.

Learn more about Bugsnag's [Go error monitoring and error reporting](https://www.bugsnag.com/platforms/go-lang-error-reporting/) solution.

## Features

* Automatically report unhandled errors and panics
* Report handled errors
* Attach user information to determine how many people are affected by a crash
* Send customized diagnostic data

## Getting Started

1. [Create a Bugsnag account](https://bugsnag.com)
2. Complete the instructions in the integration guide for your framework:
    * [Martini](https://docs.bugsnag.com/platforms/go/martini)
    * [Negroni](https://docs.bugsnag.com/platforms/go/negroni)
    * [net/http](https://docs.bugsnag.com/platforms/go/net-http)
    * [Revel](https://docs.bugsnag.com/platforms/go/revel)
    * [Other Go apps](https://docs.bugsnag.com/platforms/go/other)
3. Relax!

## Support

* Read the configuration reference:
    * [Martini](https://docs.bugsnag.com/platforms/go/martini/configuration-options/)
    * [Negroni](https://docs.bugsnag.com/platforms/go/negroni/configuration-options/)
    * [net/http](https://docs.bugsnag.com/platforms/go/net-http/configuration-options/)
    * [Revel](https://docs.bugsnag.com/platforms/go/revel/configuration-options/)
    * [Other Go apps](https://docs.bugsnag.com/platforms/go/other/configuration-options/)
* [Search open and closed issues](https://github.com/bugsnag/bugsnag-go/issues?utf8=✓&q=is%3Aissue) for similar problems
* [Report a bug or request a feature](https://github.com/bugsnag/bugsnag-go/issues/new)

## Contributing

All contributors are welcome! For information on how to build, test and release `bugsnag-go`, see our [contributing guide](CONTRIBUTING.md).


## License

The Bugsnag exception reporter for Go is free software released under the MIT License. See [LICENSE.txt](LICENSE.txt) for details.
