// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/iot/v1/resources.proto

package iot

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Indicates whether an MQTT connection is enabled or disabled. See the field
// description for details.
type MqttState int32

const (
	// No MQTT state specified. If not specified, MQTT will be enabled by default.
	MqttState_MQTT_STATE_UNSPECIFIED MqttState = 0
	// Enables a MQTT connection.
	MqttState_MQTT_ENABLED MqttState = 1
	// Disables a MQTT connection.
	MqttState_MQTT_DISABLED MqttState = 2
)

var MqttState_name = map[int32]string{
	0: "MQTT_STATE_UNSPECIFIED",
	1: "MQTT_ENABLED",
	2: "MQTT_DISABLED",
}

var MqttState_value = map[string]int32{
	"MQTT_STATE_UNSPECIFIED": 0,
	"MQTT_ENABLED":           1,
	"MQTT_DISABLED":          2,
}

func (x MqttState) String() string {
	return proto.EnumName(MqttState_name, int32(x))
}

func (MqttState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b8dc5e858286fc66, []int{0}
}

// Indicates whether DeviceService (HTTP) is enabled or disabled for the
// registry. See the field description for details.
type HttpState int32

const (
	// No HTTP state specified. If not specified, DeviceService will be
	// enabled by default.
	HttpState_HTTP_STATE_UNSPECIFIED HttpState = 0
	// Enables DeviceService (HTTP) service for the registry.
	HttpState_HTTP_ENABLED HttpState = 1
	// Disables DeviceService (HTTP) service for the registry.
	HttpState_HTTP_DISABLED HttpState = 2
)

var HttpState_name = map[int32]string{
	0: "HTTP_STATE_UNSPECIFIED",
	1: "HTTP_ENABLED",
	2: "HTTP_DISABLED",
}

var HttpState_value = map[string]int32{
	"HTTP_STATE_UNSPECIFIED": 0,
	"HTTP_ENABLED":           1,
	"HTTP_DISABLED":          2,
}

func (x HttpState) String() string {
	return proto.EnumName(HttpState_name, int32(x))
}

func (HttpState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b8dc5e858286fc66, []int{1}
}

// **Beta Feature**
//
// The logging verbosity for device activity. Specifies which events should be
// written to logs. For example, if the LogLevel is ERROR, only events that
// terminate in errors will be logged. LogLevel is inclusive; enabling INFO
// logging will also enable ERROR logging.
type LogLevel int32

const (
	// No logging specified. If not specified, logging will be disabled.
	LogLevel_LOG_LEVEL_UNSPECIFIED LogLevel = 0
	// Disables logging.
	LogLevel_NONE LogLevel = 10
	// Error events will be logged.
	LogLevel_ERROR LogLevel = 20
	// Informational events will be logged, such as connections and
	// disconnections.
	LogLevel_INFO LogLevel = 30
	// All events will be logged.
	LogLevel_DEBUG LogLevel = 40
)

var LogLevel_name = map[int32]string{
	0:  "LOG_LEVEL_UNSPECIFIED",
	10: "NONE",
	20: "ERROR",
	30: "INFO",
	40: "DEBUG",
}

var LogLevel_value = map[string]int32{
	"LOG_LEVEL_UNSPECIFIED": 0,
	"NONE":                  10,
	"ERROR":                 20,
	"INFO":                  30,
	"DEBUG":                 40,
}

func (x LogLevel) String() string {
	return proto.EnumName(LogLevel_name, int32(x))
}

func (LogLevel) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b8dc5e858286fc66, []int{2}
}

// Gateway type.
type GatewayType int32

const (
	// If unspecified, the device is considered a non-gateway device.
	GatewayType_GATEWAY_TYPE_UNSPECIFIED GatewayType = 0
	// The device is a gateway.
	GatewayType_GATEWAY GatewayType = 1
	// The device is not a gateway.
	GatewayType_NON_GATEWAY GatewayType = 2
)

var GatewayType_name = map[int32]string{
	0: "GATEWAY_TYPE_UNSPECIFIED",
	1: "GATEWAY",
	2: "NON_GATEWAY",
}

var GatewayType_value = map[string]int32{
	"GATEWAY_TYPE_UNSPECIFIED": 0,
	"GATEWAY":                  1,
	"NON_GATEWAY":              2,
}

func (x GatewayType) String() string {
	return proto.EnumName(GatewayType_name, int32(x))
}

func (GatewayType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b8dc5e858286fc66, []int{3}
}

// The gateway authorization/authentication method. This setting determines how
// Cloud IoT Core authorizes/authenticate devices to access the gateway.
type GatewayAuthMethod int32

const (
	// No authentication/authorization method specified. No devices are allowed to
	// access the gateway.
	GatewayAuthMethod_GATEWAY_AUTH_METHOD_UNSPECIFIED GatewayAuthMethod = 0
	// The device is authenticated through the gateway association only. Device
	// credentials are ignored even if provided.
	GatewayAuthMethod_ASSOCIATION_ONLY GatewayAuthMethod = 1
	// The device is authenticated through its own credentials. Gateway
	// association is not checked.
	GatewayAuthMethod_DEVICE_AUTH_TOKEN_ONLY GatewayAuthMethod = 2
	// The device is authenticated through both device credentials and gateway
	// association. The device must be bound to the gateway and must provide its
	// own credentials.
	GatewayAuthMethod_ASSOCIATION_AND_DEVICE_AUTH_TOKEN GatewayAuthMethod = 3
)

var GatewayAuthMethod_name = map[int32]string{
	0: "GATEWAY_AUTH_METHOD_UNSPECIFIED",
	1: "ASSOCIATION_ONLY",
	2: "DEVICE_AUTH_TOKEN_ONLY",
	3: "ASSOCIATION_AND_DEVICE_AUTH_TOKEN",
}

var GatewayAuthMethod_value = map[string]int32{
	"GATEWAY_AUTH_METHOD_UNSPECIFIED":   0,
	"ASSOCIATION_ONLY":                  1,
	"DEVICE_AUTH_TOKEN_ONLY":            2,
	"ASSOCIATION_AND_DEVICE_AUTH_TOKEN": 3,
}

func (x GatewayAuthMethod) String() string {
	return proto.EnumName(GatewayAuthMethod_name, int32(x))
}

func (GatewayAuthMethod) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b8dc5e858286fc66, []int{4}
}

// The supported formats for the public key.
type PublicKeyCertificateFormat int32

const (
	// The format has not been specified. This is an invalid default value and
	// must not be used.
	PublicKeyCertificateFormat_UNSPECIFIED_PUBLIC_KEY_CERTIFICATE_FORMAT PublicKeyCertificateFormat = 0
	// An X.509v3 certificate ([RFC5280](https://www.ietf.org/rfc/rfc5280.txt)),
	// encoded in base64, and wrapped by `-----BEGIN CERTIFICATE-----` and
	// `-----END CERTIFICATE-----`.
	PublicKeyCertificateFormat_X509_CERTIFICATE_PEM PublicKeyCertificateFormat = 1
)

var PublicKeyCertificateFormat_name = map[int32]string{
	0: "UNSPECIFIED_PUBLIC_KEY_CERTIFICATE_FORMAT",
	1: "X509_CERTIFICATE_PEM",
}

var PublicKeyCertificateFormat_value = map[string]int32{
	"UNSPECIFIED_PUBLIC_KEY_CERTIFICATE_FORMAT": 0,
	"X509_CERTIFICATE_PEM":                      1,
}

func (x PublicKeyCertificateFormat) String() string {
	return proto.EnumName(PublicKeyCertificateFormat_name, int32(x))
}

func (PublicKeyCertificateFormat) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b8dc5e858286fc66, []int{5}
}

// The supported formats for the public key.
type PublicKeyFormat int32

const (
	// The format has not been specified. This is an invalid default value and
	// must not be used.
	PublicKeyFormat_UNSPECIFIED_PUBLIC_KEY_FORMAT PublicKeyFormat = 0
	// An RSA public key encoded in base64, and wrapped by
	// `-----BEGIN PUBLIC KEY-----` and `-----END PUBLIC KEY-----`. This can be
	// used to verify `RS256` signatures in JWT tokens ([RFC7518](
	// https://www.ietf.org/rfc/rfc7518.txt)).
	PublicKeyFormat_RSA_PEM PublicKeyFormat = 3
	// As RSA_PEM, but wrapped in an X.509v3 certificate ([RFC5280](
	// https://www.ietf.org/rfc/rfc5280.txt)), encoded in base64, and wrapped by
	// `-----BEGIN CERTIFICATE-----` and `-----END CERTIFICATE-----`.
	PublicKeyFormat_RSA_X509_PEM PublicKeyFormat = 1
	// Public key for the ECDSA algorithm using P-256 and SHA-256, encoded in
	// base64, and wrapped by `-----BEGIN PUBLIC KEY-----` and `-----END
	// PUBLIC KEY-----`. This can be used to verify JWT tokens with the `ES256`
	// algorithm ([RFC7518](https://www.ietf.org/rfc/rfc7518.txt)). This curve is
	// defined in [OpenSSL](https://www.openssl.org/) as the `prime256v1` curve.
	PublicKeyFormat_ES256_PEM PublicKeyFormat = 2
	// As ES256_PEM, but wrapped in an X.509v3 certificate ([RFC5280](
	// https://www.ietf.org/rfc/rfc5280.txt)), encoded in base64, and wrapped by
	// `-----BEGIN CERTIFICATE-----` and `-----END CERTIFICATE-----`.
	PublicKeyFormat_ES256_X509_PEM PublicKeyFormat = 4
)

var PublicKeyFormat_name = map[int32]string{
	0: "UNSPECIFIED_PUBLIC_KEY_FORMAT",
	3: "RSA_PEM",
	1: "RSA_X509_PEM",
	2: "ES256_PEM",
	4: "ES256_X509_PEM",
}

var PublicKeyFormat_value = map[string]int32{
	"UNSPECIFIED_PUBLIC_KEY_FORMAT": 0,
	"RSA_PEM":                       3,
	"RSA_X509_PEM":                  1,
	"ES256_PEM":                     2,
	"ES256_X509_PEM":                4,
}

func (x PublicKeyFormat) String() string {
	return proto.EnumName(PublicKeyFormat_name, int32(x))
}

func (PublicKeyFormat) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b8dc5e858286fc66, []int{6}
}

// The device resource.
type Device struct {
	// The user-defined device identifier. The device ID must be unique
	// within a device registry.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The resource path name. For example,
	// `projects/p1/locations/us-central1/registries/registry0/devices/dev0` or
	// `projects/p1/locations/us-central1/registries/registry0/devices/{num_id}`.
	// When `name` is populated as a response from the service, it always ends
	// in the device numeric ID.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// [Output only] A server-defined unique numeric ID for the device. This is a
	// more compact way to identify devices, and it is globally unique.
	NumId uint64 `protobuf:"varint,3,opt,name=num_id,json=numId,proto3" json:"num_id,omitempty"`
	// The credentials used to authenticate this device. To allow credential
	// rotation without interruption, multiple device credentials can be bound to
	// this device. No more than 3 credentials can be bound to a single device at
	// a time. When new credentials are added to a device, they are verified
	// against the registry credentials. For details, see the description of the
	// `DeviceRegistry.credentials` field.
	Credentials []*DeviceCredential `protobuf:"bytes,12,rep,name=credentials,proto3" json:"credentials,omitempty"`
	// [Output only] The last time an MQTT `PINGREQ` was received. This field
	// applies only to devices connecting through MQTT. MQTT clients usually only
	// send `PINGREQ` messages if the connection is idle, and no other messages
	// have been sent. Timestamps are periodically collected and written to
	// storage; they may be stale by a few minutes.
	LastHeartbeatTime *timestamp.Timestamp `protobuf:"bytes,7,opt,name=last_heartbeat_time,json=lastHeartbeatTime,proto3" json:"last_heartbeat_time,omitempty"`
	// [Output only] The last time a telemetry event was received. Timestamps are
	// periodically collected and written to storage; they may be stale by a few
	// minutes.
	LastEventTime *timestamp.Timestamp `protobuf:"bytes,8,opt,name=last_event_time,json=lastEventTime,proto3" json:"last_event_time,omitempty"`
	// [Output only] The last time a state event was received. Timestamps are
	// periodically collected and written to storage; they may be stale by a few
	// minutes.
	LastStateTime *timestamp.Timestamp `protobuf:"bytes,20,opt,name=last_state_time,json=lastStateTime,proto3" json:"last_state_time,omitempty"`
	// [Output only] The last time a cloud-to-device config version acknowledgment
	// was received from the device. This field is only for configurations
	// sent through MQTT.
	LastConfigAckTime *timestamp.Timestamp `protobuf:"bytes,14,opt,name=last_config_ack_time,json=lastConfigAckTime,proto3" json:"last_config_ack_time,omitempty"`
	// [Output only] The last time a cloud-to-device config version was sent to
	// the device.
	LastConfigSendTime *timestamp.Timestamp `protobuf:"bytes,18,opt,name=last_config_send_time,json=lastConfigSendTime,proto3" json:"last_config_send_time,omitempty"`
	// If a device is blocked, connections or requests from this device will fail.
	// Can be used to temporarily prevent the device from connecting if, for
	// example, the sensor is generating bad data and needs maintenance.
	Blocked bool `protobuf:"varint,19,opt,name=blocked,proto3" json:"blocked,omitempty"`
	// [Output only] The time the most recent error occurred, such as a failure to
	// publish to Cloud Pub/Sub. This field is the timestamp of
	// 'last_error_status'.
	LastErrorTime *timestamp.Timestamp `protobuf:"bytes,10,opt,name=last_error_time,json=lastErrorTime,proto3" json:"last_error_time,omitempty"`
	// [Output only] The error message of the most recent error, such as a failure
	// to publish to Cloud Pub/Sub. 'last_error_time' is the timestamp of this
	// field. If no errors have occurred, this field has an empty message
	// and the status code 0 == OK. Otherwise, this field is expected to have a
	// status code other than OK.
	LastErrorStatus *status.Status `protobuf:"bytes,11,opt,name=last_error_status,json=lastErrorStatus,proto3" json:"last_error_status,omitempty"`
	// The most recent device configuration, which is eventually sent from
	// Cloud IoT Core to the device. If not present on creation, the
	// configuration will be initialized with an empty payload and version value
	// of `1`. To update this field after creation, use the
	// `DeviceManager.ModifyCloudToDeviceConfig` method.
	Config *DeviceConfig `protobuf:"bytes,13,opt,name=config,proto3" json:"config,omitempty"`
	// [Output only] The state most recently received from the device. If no state
	// has been reported, this field is not present.
	State *DeviceState `protobuf:"bytes,16,opt,name=state,proto3" json:"state,omitempty"`
	// **Beta Feature**
	//
	// The logging verbosity for device activity. If unspecified,
	// DeviceRegistry.log_level will be used.
	LogLevel LogLevel `protobuf:"varint,21,opt,name=log_level,json=logLevel,proto3,enum=google.cloud.iot.v1.LogLevel" json:"log_level,omitempty"`
	// The metadata key-value pairs assigned to the device. This metadata is not
	// interpreted or indexed by Cloud IoT Core. It can be used to add contextual
	// information for the device.
	//
	// Keys must conform to the regular expression [a-zA-Z][a-zA-Z0-9-_.+~%]+ and
	// be less than 128 bytes in length.
	//
	// Values are free-form strings. Each value must be less than or equal to 32
	// KB in size.
	//
	// The total size of all keys and values must be less than 256 KB, and the
	// maximum number of key-value pairs is 500.
	Metadata map[string]string `protobuf:"bytes,17,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Gateway-related configuration and state.
	GatewayConfig        *GatewayConfig `protobuf:"bytes,24,opt,name=gateway_config,json=gatewayConfig,proto3" json:"gateway_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Device) Reset()         { *m = Device{} }
func (m *Device) String() string { return proto.CompactTextString(m) }
func (*Device) ProtoMessage()    {}
func (*Device) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8dc5e858286fc66, []int{0}
}

func (m *Device) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Device.Unmarshal(m, b)
}
func (m *Device) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Device.Marshal(b, m, deterministic)
}
func (m *Device) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Device.Merge(m, src)
}
func (m *Device) XXX_Size() int {
	return xxx_messageInfo_Device.Size(m)
}
func (m *Device) XXX_DiscardUnknown() {
	xxx_messageInfo_Device.DiscardUnknown(m)
}

var xxx_messageInfo_Device proto.InternalMessageInfo

func (m *Device) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Device) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Device) GetNumId() uint64 {
	if m != nil {
		return m.NumId
	}
	return 0
}

func (m *Device) GetCredentials() []*DeviceCredential {
	if m != nil {
		return m.Credentials
	}
	return nil
}

func (m *Device) GetLastHeartbeatTime() *timestamp.Timestamp {
	if m != nil {
		return m.LastHeartbeatTime
	}
	return nil
}

func (m *Device) GetLastEventTime() *timestamp.Timestamp {
	if m != nil {
		return m.LastEventTime
	}
	return nil
}

func (m *Device) GetLastStateTime() *timestamp.Timestamp {
	if m != nil {
		return m.LastStateTime
	}
	return nil
}

func (m *Device) GetLastConfigAckTime() *timestamp.Timestamp {
	if m != nil {
		return m.LastConfigAckTime
	}
	return nil
}

func (m *Device) GetLastConfigSendTime() *timestamp.Timestamp {
	if m != nil {
		return m.LastConfigSendTime
	}
	return nil
}

func (m *Device) GetBlocked() bool {
	if m != nil {
		return m.Blocked
	}
	return false
}

func (m *Device) GetLastErrorTime() *timestamp.Timestamp {
	if m != nil {
		return m.LastErrorTime
	}
	return nil
}

func (m *Device) GetLastErrorStatus() *status.Status {
	if m != nil {
		return m.LastErrorStatus
	}
	return nil
}

func (m *Device) GetConfig() *DeviceConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *Device) GetState() *DeviceState {
	if m != nil {
		return m.State
	}
	return nil
}

func (m *Device) GetLogLevel() LogLevel {
	if m != nil {
		return m.LogLevel
	}
	return LogLevel_LOG_LEVEL_UNSPECIFIED
}

func (m *Device) GetMetadata() map[string]string {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Device) GetGatewayConfig() *GatewayConfig {
	if m != nil {
		return m.GatewayConfig
	}
	return nil
}

// Gateway-related configuration and state.
type GatewayConfig struct {
	// Indicates whether the device is a gateway.
	GatewayType GatewayType `protobuf:"varint,1,opt,name=gateway_type,json=gatewayType,proto3,enum=google.cloud.iot.v1.GatewayType" json:"gateway_type,omitempty"`
	// Indicates how to authorize and/or authenticate devices to access the
	// gateway.
	GatewayAuthMethod GatewayAuthMethod `protobuf:"varint,2,opt,name=gateway_auth_method,json=gatewayAuthMethod,proto3,enum=google.cloud.iot.v1.GatewayAuthMethod" json:"gateway_auth_method,omitempty"`
	// [Output only] The ID of the gateway the device accessed most recently.
	LastAccessedGatewayId string `protobuf:"bytes,3,opt,name=last_accessed_gateway_id,json=lastAccessedGatewayId,proto3" json:"last_accessed_gateway_id,omitempty"`
	// [Output only] The most recent time at which the device accessed the gateway
	// specified in `last_accessed_gateway`.
	LastAccessedGatewayTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=last_accessed_gateway_time,json=lastAccessedGatewayTime,proto3" json:"last_accessed_gateway_time,omitempty"`
	XXX_NoUnkeyedLiteral    struct{}             `json:"-"`
	XXX_unrecognized        []byte               `json:"-"`
	XXX_sizecache           int32                `json:"-"`
}

func (m *GatewayConfig) Reset()         { *m = GatewayConfig{} }
func (m *GatewayConfig) String() string { return proto.CompactTextString(m) }
func (*GatewayConfig) ProtoMessage()    {}
func (*GatewayConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8dc5e858286fc66, []int{1}
}

func (m *GatewayConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GatewayConfig.Unmarshal(m, b)
}
func (m *GatewayConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GatewayConfig.Marshal(b, m, deterministic)
}
func (m *GatewayConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GatewayConfig.Merge(m, src)
}
func (m *GatewayConfig) XXX_Size() int {
	return xxx_messageInfo_GatewayConfig.Size(m)
}
func (m *GatewayConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_GatewayConfig.DiscardUnknown(m)
}

var xxx_messageInfo_GatewayConfig proto.InternalMessageInfo

func (m *GatewayConfig) GetGatewayType() GatewayType {
	if m != nil {
		return m.GatewayType
	}
	return GatewayType_GATEWAY_TYPE_UNSPECIFIED
}

func (m *GatewayConfig) GetGatewayAuthMethod() GatewayAuthMethod {
	if m != nil {
		return m.GatewayAuthMethod
	}
	return GatewayAuthMethod_GATEWAY_AUTH_METHOD_UNSPECIFIED
}

func (m *GatewayConfig) GetLastAccessedGatewayId() string {
	if m != nil {
		return m.LastAccessedGatewayId
	}
	return ""
}

func (m *GatewayConfig) GetLastAccessedGatewayTime() *timestamp.Timestamp {
	if m != nil {
		return m.LastAccessedGatewayTime
	}
	return nil
}

// A container for a group of devices.
type DeviceRegistry struct {
	// The identifier of this device registry. For example, `myRegistry`.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The resource path name. For example,
	// `projects/example-project/locations/us-central1/registries/my-registry`.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The configuration for notification of telemetry events received from the
	// device. All telemetry events that were successfully published by the
	// device and acknowledged by Cloud IoT Core are guaranteed to be
	// delivered to Cloud Pub/Sub. If multiple configurations match a message,
	// only the first matching configuration is used. If you try to publish a
	// device telemetry event using MQTT without specifying a Cloud Pub/Sub topic
	// for the device's registry, the connection closes automatically. If you try
	// to do so using an HTTP connection, an error is returned. Up to 10
	// configurations may be provided.
	EventNotificationConfigs []*EventNotificationConfig `protobuf:"bytes,10,rep,name=event_notification_configs,json=eventNotificationConfigs,proto3" json:"event_notification_configs,omitempty"`
	// The configuration for notification of new states received from the device.
	// State updates are guaranteed to be stored in the state history, but
	// notifications to Cloud Pub/Sub are not guaranteed. For example, if
	// permissions are misconfigured or the specified topic doesn't exist, no
	// notification will be published but the state will still be stored in Cloud
	// IoT Core.
	StateNotificationConfig *StateNotificationConfig `protobuf:"bytes,7,opt,name=state_notification_config,json=stateNotificationConfig,proto3" json:"state_notification_config,omitempty"`
	// The MQTT configuration for this device registry.
	MqttConfig *MqttConfig `protobuf:"bytes,4,opt,name=mqtt_config,json=mqttConfig,proto3" json:"mqtt_config,omitempty"`
	// The DeviceService (HTTP) configuration for this device registry.
	HttpConfig *HttpConfig `protobuf:"bytes,9,opt,name=http_config,json=httpConfig,proto3" json:"http_config,omitempty"`
	// **Beta Feature**
	//
	// The default logging verbosity for activity from devices in this registry.
	// The verbosity level can be overridden by Device.log_level.
	LogLevel LogLevel `protobuf:"varint,11,opt,name=log_level,json=logLevel,proto3,enum=google.cloud.iot.v1.LogLevel" json:"log_level,omitempty"`
	// The credentials used to verify the device credentials. No more than 10
	// credentials can be bound to a single registry at a time. The verification
	// process occurs at the time of device creation or update. If this field is
	// empty, no verification is performed. Otherwise, the credentials of a newly
	// created device or added credentials of an updated device should be signed
	// with one of these registry credentials.
	//
	// Note, however, that existing devices will never be affected by
	// modifications to this list of credentials: after a device has been
	// successfully created in a registry, it should be able to connect even if
	// its registry credentials are revoked, deleted, or modified.
	Credentials          []*RegistryCredential `protobuf:"bytes,8,rep,name=credentials,proto3" json:"credentials,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *DeviceRegistry) Reset()         { *m = DeviceRegistry{} }
func (m *DeviceRegistry) String() string { return proto.CompactTextString(m) }
func (*DeviceRegistry) ProtoMessage()    {}
func (*DeviceRegistry) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8dc5e858286fc66, []int{2}
}

func (m *DeviceRegistry) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeviceRegistry.Unmarshal(m, b)
}
func (m *DeviceRegistry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeviceRegistry.Marshal(b, m, deterministic)
}
func (m *DeviceRegistry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeviceRegistry.Merge(m, src)
}
func (m *DeviceRegistry) XXX_Size() int {
	return xxx_messageInfo_DeviceRegistry.Size(m)
}
func (m *DeviceRegistry) XXX_DiscardUnknown() {
	xxx_messageInfo_DeviceRegistry.DiscardUnknown(m)
}

var xxx_messageInfo_DeviceRegistry proto.InternalMessageInfo

func (m *DeviceRegistry) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *DeviceRegistry) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DeviceRegistry) GetEventNotificationConfigs() []*EventNotificationConfig {
	if m != nil {
		return m.EventNotificationConfigs
	}
	return nil
}

func (m *DeviceRegistry) GetStateNotificationConfig() *StateNotificationConfig {
	if m != nil {
		return m.StateNotificationConfig
	}
	return nil
}

func (m *DeviceRegistry) GetMqttConfig() *MqttConfig {
	if m != nil {
		return m.MqttConfig
	}
	return nil
}

func (m *DeviceRegistry) GetHttpConfig() *HttpConfig {
	if m != nil {
		return m.HttpConfig
	}
	return nil
}

func (m *DeviceRegistry) GetLogLevel() LogLevel {
	if m != nil {
		return m.LogLevel
	}
	return LogLevel_LOG_LEVEL_UNSPECIFIED
}

func (m *DeviceRegistry) GetCredentials() []*RegistryCredential {
	if m != nil {
		return m.Credentials
	}
	return nil
}

// The configuration of MQTT for a device registry.
type MqttConfig struct {
	// If enabled, allows connections using the MQTT protocol. Otherwise, MQTT
	// connections to this registry will fail.
	MqttEnabledState     MqttState `protobuf:"varint,1,opt,name=mqtt_enabled_state,json=mqttEnabledState,proto3,enum=google.cloud.iot.v1.MqttState" json:"mqtt_enabled_state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *MqttConfig) Reset()         { *m = MqttConfig{} }
func (m *MqttConfig) String() string { return proto.CompactTextString(m) }
func (*MqttConfig) ProtoMessage()    {}
func (*MqttConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8dc5e858286fc66, []int{3}
}

func (m *MqttConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MqttConfig.Unmarshal(m, b)
}
func (m *MqttConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MqttConfig.Marshal(b, m, deterministic)
}
func (m *MqttConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MqttConfig.Merge(m, src)
}
func (m *MqttConfig) XXX_Size() int {
	return xxx_messageInfo_MqttConfig.Size(m)
}
func (m *MqttConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_MqttConfig.DiscardUnknown(m)
}

var xxx_messageInfo_MqttConfig proto.InternalMessageInfo

func (m *MqttConfig) GetMqttEnabledState() MqttState {
	if m != nil {
		return m.MqttEnabledState
	}
	return MqttState_MQTT_STATE_UNSPECIFIED
}

// The configuration of the HTTP bridge for a device registry.
type HttpConfig struct {
	// If enabled, allows devices to use DeviceService via the HTTP protocol.
	// Otherwise, any requests to DeviceService will fail for this registry.
	HttpEnabledState     HttpState `protobuf:"varint,1,opt,name=http_enabled_state,json=httpEnabledState,proto3,enum=google.cloud.iot.v1.HttpState" json:"http_enabled_state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *HttpConfig) Reset()         { *m = HttpConfig{} }
func (m *HttpConfig) String() string { return proto.CompactTextString(m) }
func (*HttpConfig) ProtoMessage()    {}
func (*HttpConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8dc5e858286fc66, []int{4}
}

func (m *HttpConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HttpConfig.Unmarshal(m, b)
}
func (m *HttpConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HttpConfig.Marshal(b, m, deterministic)
}
func (m *HttpConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HttpConfig.Merge(m, src)
}
func (m *HttpConfig) XXX_Size() int {
	return xxx_messageInfo_HttpConfig.Size(m)
}
func (m *HttpConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_HttpConfig.DiscardUnknown(m)
}

var xxx_messageInfo_HttpConfig proto.InternalMessageInfo

func (m *HttpConfig) GetHttpEnabledState() HttpState {
	if m != nil {
		return m.HttpEnabledState
	}
	return HttpState_HTTP_STATE_UNSPECIFIED
}

// The configuration for forwarding telemetry events.
type EventNotificationConfig struct {
	// If the subfolder name matches this string exactly, this configuration will
	// be used. The string must not include the leading '/' character. If empty,
	// all strings are matched. This field is used only for telemetry events;
	// subfolders are not supported for state changes.
	SubfolderMatches string `protobuf:"bytes,2,opt,name=subfolder_matches,json=subfolderMatches,proto3" json:"subfolder_matches,omitempty"`
	// A Cloud Pub/Sub topic name. For example,
	// `projects/myProject/topics/deviceEvents`.
	PubsubTopicName      string   `protobuf:"bytes,1,opt,name=pubsub_topic_name,json=pubsubTopicName,proto3" json:"pubsub_topic_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EventNotificationConfig) Reset()         { *m = EventNotificationConfig{} }
func (m *EventNotificationConfig) String() string { return proto.CompactTextString(m) }
func (*EventNotificationConfig) ProtoMessage()    {}
func (*EventNotificationConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8dc5e858286fc66, []int{5}
}

func (m *EventNotificationConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventNotificationConfig.Unmarshal(m, b)
}
func (m *EventNotificationConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventNotificationConfig.Marshal(b, m, deterministic)
}
func (m *EventNotificationConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventNotificationConfig.Merge(m, src)
}
func (m *EventNotificationConfig) XXX_Size() int {
	return xxx_messageInfo_EventNotificationConfig.Size(m)
}
func (m *EventNotificationConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_EventNotificationConfig.DiscardUnknown(m)
}

var xxx_messageInfo_EventNotificationConfig proto.InternalMessageInfo

func (m *EventNotificationConfig) GetSubfolderMatches() string {
	if m != nil {
		return m.SubfolderMatches
	}
	return ""
}

func (m *EventNotificationConfig) GetPubsubTopicName() string {
	if m != nil {
		return m.PubsubTopicName
	}
	return ""
}

// The configuration for notification of new states received from the device.
type StateNotificationConfig struct {
	// A Cloud Pub/Sub topic name. For example,
	// `projects/myProject/topics/deviceEvents`.
	PubsubTopicName      string   `protobuf:"bytes,1,opt,name=pubsub_topic_name,json=pubsubTopicName,proto3" json:"pubsub_topic_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateNotificationConfig) Reset()         { *m = StateNotificationConfig{} }
func (m *StateNotificationConfig) String() string { return proto.CompactTextString(m) }
func (*StateNotificationConfig) ProtoMessage()    {}
func (*StateNotificationConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8dc5e858286fc66, []int{6}
}

func (m *StateNotificationConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateNotificationConfig.Unmarshal(m, b)
}
func (m *StateNotificationConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateNotificationConfig.Marshal(b, m, deterministic)
}
func (m *StateNotificationConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateNotificationConfig.Merge(m, src)
}
func (m *StateNotificationConfig) XXX_Size() int {
	return xxx_messageInfo_StateNotificationConfig.Size(m)
}
func (m *StateNotificationConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_StateNotificationConfig.DiscardUnknown(m)
}

var xxx_messageInfo_StateNotificationConfig proto.InternalMessageInfo

func (m *StateNotificationConfig) GetPubsubTopicName() string {
	if m != nil {
		return m.PubsubTopicName
	}
	return ""
}

// A server-stored registry credential used to validate device credentials.
type RegistryCredential struct {
	// The credential data. Reserved for expansion in the future.
	//
	// Types that are valid to be assigned to Credential:
	//	*RegistryCredential_PublicKeyCertificate
	Credential           isRegistryCredential_Credential `protobuf_oneof:"credential"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *RegistryCredential) Reset()         { *m = RegistryCredential{} }
func (m *RegistryCredential) String() string { return proto.CompactTextString(m) }
func (*RegistryCredential) ProtoMessage()    {}
func (*RegistryCredential) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8dc5e858286fc66, []int{7}
}

func (m *RegistryCredential) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RegistryCredential.Unmarshal(m, b)
}
func (m *RegistryCredential) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RegistryCredential.Marshal(b, m, deterministic)
}
func (m *RegistryCredential) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RegistryCredential.Merge(m, src)
}
func (m *RegistryCredential) XXX_Size() int {
	return xxx_messageInfo_RegistryCredential.Size(m)
}
func (m *RegistryCredential) XXX_DiscardUnknown() {
	xxx_messageInfo_RegistryCredential.DiscardUnknown(m)
}

var xxx_messageInfo_RegistryCredential proto.InternalMessageInfo

type isRegistryCredential_Credential interface {
	isRegistryCredential_Credential()
}

type RegistryCredential_PublicKeyCertificate struct {
	PublicKeyCertificate *PublicKeyCertificate `protobuf:"bytes,1,opt,name=public_key_certificate,json=publicKeyCertificate,proto3,oneof"`
}

func (*RegistryCredential_PublicKeyCertificate) isRegistryCredential_Credential() {}

func (m *RegistryCredential) GetCredential() isRegistryCredential_Credential {
	if m != nil {
		return m.Credential
	}
	return nil
}

func (m *RegistryCredential) GetPublicKeyCertificate() *PublicKeyCertificate {
	if x, ok := m.GetCredential().(*RegistryCredential_PublicKeyCertificate); ok {
		return x.PublicKeyCertificate
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*RegistryCredential) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*RegistryCredential_PublicKeyCertificate)(nil),
	}
}

// Details of an X.509 certificate. For informational purposes only.
type X509CertificateDetails struct {
	// The entity that signed the certificate.
	Issuer string `protobuf:"bytes,1,opt,name=issuer,proto3" json:"issuer,omitempty"`
	// The entity the certificate and public key belong to.
	Subject string `protobuf:"bytes,2,opt,name=subject,proto3" json:"subject,omitempty"`
	// The time the certificate becomes valid.
	StartTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time the certificate becomes invalid.
	ExpiryTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=expiry_time,json=expiryTime,proto3" json:"expiry_time,omitempty"`
	// The algorithm used to sign the certificate.
	SignatureAlgorithm string `protobuf:"bytes,5,opt,name=signature_algorithm,json=signatureAlgorithm,proto3" json:"signature_algorithm,omitempty"`
	// The type of public key in the certificate.
	PublicKeyType        string   `protobuf:"bytes,6,opt,name=public_key_type,json=publicKeyType,proto3" json:"public_key_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *X509CertificateDetails) Reset()         { *m = X509CertificateDetails{} }
func (m *X509CertificateDetails) String() string { return proto.CompactTextString(m) }
func (*X509CertificateDetails) ProtoMessage()    {}
func (*X509CertificateDetails) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8dc5e858286fc66, []int{8}
}

func (m *X509CertificateDetails) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_X509CertificateDetails.Unmarshal(m, b)
}
func (m *X509CertificateDetails) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_X509CertificateDetails.Marshal(b, m, deterministic)
}
func (m *X509CertificateDetails) XXX_Merge(src proto.Message) {
	xxx_messageInfo_X509CertificateDetails.Merge(m, src)
}
func (m *X509CertificateDetails) XXX_Size() int {
	return xxx_messageInfo_X509CertificateDetails.Size(m)
}
func (m *X509CertificateDetails) XXX_DiscardUnknown() {
	xxx_messageInfo_X509CertificateDetails.DiscardUnknown(m)
}

var xxx_messageInfo_X509CertificateDetails proto.InternalMessageInfo

func (m *X509CertificateDetails) GetIssuer() string {
	if m != nil {
		return m.Issuer
	}
	return ""
}

func (m *X509CertificateDetails) GetSubject() string {
	if m != nil {
		return m.Subject
	}
	return ""
}

func (m *X509CertificateDetails) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *X509CertificateDetails) GetExpiryTime() *timestamp.Timestamp {
	if m != nil {
		return m.ExpiryTime
	}
	return nil
}

func (m *X509CertificateDetails) GetSignatureAlgorithm() string {
	if m != nil {
		return m.SignatureAlgorithm
	}
	return ""
}

func (m *X509CertificateDetails) GetPublicKeyType() string {
	if m != nil {
		return m.PublicKeyType
	}
	return ""
}

// A public key certificate format and data.
type PublicKeyCertificate struct {
	// The certificate format.
	Format PublicKeyCertificateFormat `protobuf:"varint,1,opt,name=format,proto3,enum=google.cloud.iot.v1.PublicKeyCertificateFormat" json:"format,omitempty"`
	// The certificate data.
	Certificate string `protobuf:"bytes,2,opt,name=certificate,proto3" json:"certificate,omitempty"`
	// [Output only] The certificate details. Used only for X.509 certificates.
	X509Details          *X509CertificateDetails `protobuf:"bytes,3,opt,name=x509_details,json=x509Details,proto3" json:"x509_details,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *PublicKeyCertificate) Reset()         { *m = PublicKeyCertificate{} }
func (m *PublicKeyCertificate) String() string { return proto.CompactTextString(m) }
func (*PublicKeyCertificate) ProtoMessage()    {}
func (*PublicKeyCertificate) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8dc5e858286fc66, []int{9}
}

func (m *PublicKeyCertificate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PublicKeyCertificate.Unmarshal(m, b)
}
func (m *PublicKeyCertificate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PublicKeyCertificate.Marshal(b, m, deterministic)
}
func (m *PublicKeyCertificate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PublicKeyCertificate.Merge(m, src)
}
func (m *PublicKeyCertificate) XXX_Size() int {
	return xxx_messageInfo_PublicKeyCertificate.Size(m)
}
func (m *PublicKeyCertificate) XXX_DiscardUnknown() {
	xxx_messageInfo_PublicKeyCertificate.DiscardUnknown(m)
}

var xxx_messageInfo_PublicKeyCertificate proto.InternalMessageInfo

func (m *PublicKeyCertificate) GetFormat() PublicKeyCertificateFormat {
	if m != nil {
		return m.Format
	}
	return PublicKeyCertificateFormat_UNSPECIFIED_PUBLIC_KEY_CERTIFICATE_FORMAT
}

func (m *PublicKeyCertificate) GetCertificate() string {
	if m != nil {
		return m.Certificate
	}
	return ""
}

func (m *PublicKeyCertificate) GetX509Details() *X509CertificateDetails {
	if m != nil {
		return m.X509Details
	}
	return nil
}

// A server-stored device credential used for authentication.
type DeviceCredential struct {
	// The credential data. Reserved for expansion in the future.
	//
	// Types that are valid to be assigned to Credential:
	//	*DeviceCredential_PublicKey
	Credential isDeviceCredential_Credential `protobuf_oneof:"credential"`
	// [Optional] The time at which this credential becomes invalid. This
	// credential will be ignored for new client authentication requests after
	// this timestamp; however, it will not be automatically deleted.
	ExpirationTime       *timestamp.Timestamp `protobuf:"bytes,6,opt,name=expiration_time,json=expirationTime,proto3" json:"expiration_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *DeviceCredential) Reset()         { *m = DeviceCredential{} }
func (m *DeviceCredential) String() string { return proto.CompactTextString(m) }
func (*DeviceCredential) ProtoMessage()    {}
func (*DeviceCredential) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8dc5e858286fc66, []int{10}
}

func (m *DeviceCredential) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeviceCredential.Unmarshal(m, b)
}
func (m *DeviceCredential) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeviceCredential.Marshal(b, m, deterministic)
}
func (m *DeviceCredential) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeviceCredential.Merge(m, src)
}
func (m *DeviceCredential) XXX_Size() int {
	return xxx_messageInfo_DeviceCredential.Size(m)
}
func (m *DeviceCredential) XXX_DiscardUnknown() {
	xxx_messageInfo_DeviceCredential.DiscardUnknown(m)
}

var xxx_messageInfo_DeviceCredential proto.InternalMessageInfo

type isDeviceCredential_Credential interface {
	isDeviceCredential_Credential()
}

type DeviceCredential_PublicKey struct {
	PublicKey *PublicKeyCredential `protobuf:"bytes,2,opt,name=public_key,json=publicKey,proto3,oneof"`
}

func (*DeviceCredential_PublicKey) isDeviceCredential_Credential() {}

func (m *DeviceCredential) GetCredential() isDeviceCredential_Credential {
	if m != nil {
		return m.Credential
	}
	return nil
}

func (m *DeviceCredential) GetPublicKey() *PublicKeyCredential {
	if x, ok := m.GetCredential().(*DeviceCredential_PublicKey); ok {
		return x.PublicKey
	}
	return nil
}

func (m *DeviceCredential) GetExpirationTime() *timestamp.Timestamp {
	if m != nil {
		return m.ExpirationTime
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*DeviceCredential) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*DeviceCredential_PublicKey)(nil),
	}
}

// A public key format and data.
type PublicKeyCredential struct {
	// The format of the key.
	Format PublicKeyFormat `protobuf:"varint,1,opt,name=format,proto3,enum=google.cloud.iot.v1.PublicKeyFormat" json:"format,omitempty"`
	// The key data.
	Key                  string   `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PublicKeyCredential) Reset()         { *m = PublicKeyCredential{} }
func (m *PublicKeyCredential) String() string { return proto.CompactTextString(m) }
func (*PublicKeyCredential) ProtoMessage()    {}
func (*PublicKeyCredential) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8dc5e858286fc66, []int{11}
}

func (m *PublicKeyCredential) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PublicKeyCredential.Unmarshal(m, b)
}
func (m *PublicKeyCredential) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PublicKeyCredential.Marshal(b, m, deterministic)
}
func (m *PublicKeyCredential) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PublicKeyCredential.Merge(m, src)
}
func (m *PublicKeyCredential) XXX_Size() int {
	return xxx_messageInfo_PublicKeyCredential.Size(m)
}
func (m *PublicKeyCredential) XXX_DiscardUnknown() {
	xxx_messageInfo_PublicKeyCredential.DiscardUnknown(m)
}

var xxx_messageInfo_PublicKeyCredential proto.InternalMessageInfo

func (m *PublicKeyCredential) GetFormat() PublicKeyFormat {
	if m != nil {
		return m.Format
	}
	return PublicKeyFormat_UNSPECIFIED_PUBLIC_KEY_FORMAT
}

func (m *PublicKeyCredential) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

// The device configuration. Eventually delivered to devices.
type DeviceConfig struct {
	// [Output only] The version of this update. The version number is assigned by
	// the server, and is always greater than 0 after device creation. The
	// version must be 0 on the `CreateDevice` request if a `config` is
	// specified; the response of `CreateDevice` will always have a value of 1.
	Version int64 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// [Output only] The time at which this configuration version was updated in
	// Cloud IoT Core. This timestamp is set by the server.
	CloudUpdateTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=cloud_update_time,json=cloudUpdateTime,proto3" json:"cloud_update_time,omitempty"`
	// [Output only] The time at which Cloud IoT Core received the
	// acknowledgment from the device, indicating that the device has received
	// this configuration version. If this field is not present, the device has
	// not yet acknowledged that it received this version. Note that when
	// the config was sent to the device, many config versions may have been
	// available in Cloud IoT Core while the device was disconnected, and on
	// connection, only the latest version is sent to the device. Some
	// versions may never be sent to the device, and therefore are never
	// acknowledged. This timestamp is set by Cloud IoT Core.
	DeviceAckTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=device_ack_time,json=deviceAckTime,proto3" json:"device_ack_time,omitempty"`
	// The device configuration data.
	BinaryData           []byte   `protobuf:"bytes,4,opt,name=binary_data,json=binaryData,proto3" json:"binary_data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeviceConfig) Reset()         { *m = DeviceConfig{} }
func (m *DeviceConfig) String() string { return proto.CompactTextString(m) }
func (*DeviceConfig) ProtoMessage()    {}
func (*DeviceConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8dc5e858286fc66, []int{12}
}

func (m *DeviceConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeviceConfig.Unmarshal(m, b)
}
func (m *DeviceConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeviceConfig.Marshal(b, m, deterministic)
}
func (m *DeviceConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeviceConfig.Merge(m, src)
}
func (m *DeviceConfig) XXX_Size() int {
	return xxx_messageInfo_DeviceConfig.Size(m)
}
func (m *DeviceConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_DeviceConfig.DiscardUnknown(m)
}

var xxx_messageInfo_DeviceConfig proto.InternalMessageInfo

func (m *DeviceConfig) GetVersion() int64 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *DeviceConfig) GetCloudUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CloudUpdateTime
	}
	return nil
}

func (m *DeviceConfig) GetDeviceAckTime() *timestamp.Timestamp {
	if m != nil {
		return m.DeviceAckTime
	}
	return nil
}

func (m *DeviceConfig) GetBinaryData() []byte {
	if m != nil {
		return m.BinaryData
	}
	return nil
}

// The device state, as reported by the device.
type DeviceState struct {
	// [Output only] The time at which this state version was updated in Cloud
	// IoT Core.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The device state data.
	BinaryData           []byte   `protobuf:"bytes,2,opt,name=binary_data,json=binaryData,proto3" json:"binary_data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeviceState) Reset()         { *m = DeviceState{} }
func (m *DeviceState) String() string { return proto.CompactTextString(m) }
func (*DeviceState) ProtoMessage()    {}
func (*DeviceState) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8dc5e858286fc66, []int{13}
}

func (m *DeviceState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeviceState.Unmarshal(m, b)
}
func (m *DeviceState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeviceState.Marshal(b, m, deterministic)
}
func (m *DeviceState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeviceState.Merge(m, src)
}
func (m *DeviceState) XXX_Size() int {
	return xxx_messageInfo_DeviceState.Size(m)
}
func (m *DeviceState) XXX_DiscardUnknown() {
	xxx_messageInfo_DeviceState.DiscardUnknown(m)
}

var xxx_messageInfo_DeviceState proto.InternalMessageInfo

func (m *DeviceState) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *DeviceState) GetBinaryData() []byte {
	if m != nil {
		return m.BinaryData
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.iot.v1.MqttState", MqttState_name, MqttState_value)
	proto.RegisterEnum("google.cloud.iot.v1.HttpState", HttpState_name, HttpState_value)
	proto.RegisterEnum("google.cloud.iot.v1.LogLevel", LogLevel_name, LogLevel_value)
	proto.RegisterEnum("google.cloud.iot.v1.GatewayType", GatewayType_name, GatewayType_value)
	proto.RegisterEnum("google.cloud.iot.v1.GatewayAuthMethod", GatewayAuthMethod_name, GatewayAuthMethod_value)
	proto.RegisterEnum("google.cloud.iot.v1.PublicKeyCertificateFormat", PublicKeyCertificateFormat_name, PublicKeyCertificateFormat_value)
	proto.RegisterEnum("google.cloud.iot.v1.PublicKeyFormat", PublicKeyFormat_name, PublicKeyFormat_value)
	proto.RegisterType((*Device)(nil), "google.cloud.iot.v1.Device")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.iot.v1.Device.MetadataEntry")
	proto.RegisterType((*GatewayConfig)(nil), "google.cloud.iot.v1.GatewayConfig")
	proto.RegisterType((*DeviceRegistry)(nil), "google.cloud.iot.v1.DeviceRegistry")
	proto.RegisterType((*MqttConfig)(nil), "google.cloud.iot.v1.MqttConfig")
	proto.RegisterType((*HttpConfig)(nil), "google.cloud.iot.v1.HttpConfig")
	proto.RegisterType((*EventNotificationConfig)(nil), "google.cloud.iot.v1.EventNotificationConfig")
	proto.RegisterType((*StateNotificationConfig)(nil), "google.cloud.iot.v1.StateNotificationConfig")
	proto.RegisterType((*RegistryCredential)(nil), "google.cloud.iot.v1.RegistryCredential")
	proto.RegisterType((*X509CertificateDetails)(nil), "google.cloud.iot.v1.X509CertificateDetails")
	proto.RegisterType((*PublicKeyCertificate)(nil), "google.cloud.iot.v1.PublicKeyCertificate")
	proto.RegisterType((*DeviceCredential)(nil), "google.cloud.iot.v1.DeviceCredential")
	proto.RegisterType((*PublicKeyCredential)(nil), "google.cloud.iot.v1.PublicKeyCredential")
	proto.RegisterType((*DeviceConfig)(nil), "google.cloud.iot.v1.DeviceConfig")
	proto.RegisterType((*DeviceState)(nil), "google.cloud.iot.v1.DeviceState")
}

func init() {
	proto.RegisterFile("google/cloud/iot/v1/resources.proto", fileDescriptor_b8dc5e858286fc66)
}

var fileDescriptor_b8dc5e858286fc66 = []byte{
	// 1751 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x58, 0xcb, 0x72, 0xdb, 0xc8,
	0x15, 0x35, 0xa8, 0x87, 0xc5, 0x4b, 0x89, 0x22, 0x5b, 0xb2, 0x04, 0xb3, 0x32, 0xb6, 0xcc, 0xc9,
	0x38, 0x1a, 0x4d, 0x42, 0xcc, 0x28, 0x65, 0x27, 0xb6, 0x93, 0x54, 0x28, 0x12, 0x92, 0x18, 0xf3,
	0xa1, 0x80, 0x94, 0x27, 0x9e, 0x0d, 0x0a, 0x04, 0x5a, 0x24, 0x2c, 0x10, 0xc0, 0x00, 0x0d, 0x65,
	0x58, 0x2e, 0x2f, 0xb2, 0xc8, 0x32, 0x8b, 0xac, 0xf3, 0x13, 0xf9, 0x82, 0xfc, 0x43, 0x16, 0xf9,
	0x89, 0xf9, 0x82, 0x2c, 0x53, 0xfd, 0x00, 0xf8, 0x30, 0x28, 0xca, 0x95, 0x5d, 0xf7, 0xbd, 0xf7,
	0x9c, 0x8b, 0xbe, 0xaf, 0x6e, 0x12, 0x3e, 0x1f, 0x78, 0xde, 0xc0, 0xc1, 0x8a, 0xe9, 0x78, 0x91,
	0xa5, 0xd8, 0x1e, 0x51, 0x6e, 0xbe, 0x51, 0x02, 0x1c, 0x7a, 0x51, 0x60, 0xe2, 0xb0, 0xe2, 0x07,
	0x1e, 0xf1, 0xd0, 0x0e, 0x37, 0xaa, 0x30, 0xa3, 0x8a, 0xed, 0x91, 0xca, 0xcd, 0x37, 0xa5, 0x87,
	0x02, 0x69, 0xf8, 0x76, 0x02, 0xe0, 0xf6, 0xa5, 0xc7, 0x42, 0xc5, 0x76, 0xfd, 0xe8, 0x4a, 0x21,
	0xf6, 0x08, 0x87, 0xc4, 0x18, 0xf9, 0xc2, 0x60, 0x5f, 0x18, 0x04, 0xbe, 0xa9, 0x84, 0xc4, 0x20,
	0x91, 0xf0, 0x54, 0xfe, 0x5b, 0x16, 0xd6, 0xeb, 0xf8, 0xc6, 0x36, 0x31, 0xca, 0x43, 0xc6, 0xb6,
	0x64, 0xe9, 0x40, 0x3a, 0xcc, 0x6a, 0x19, 0xdb, 0x42, 0x08, 0x56, 0x5d, 0x63, 0x84, 0xe5, 0x0c,
	0x93, 0xb0, 0x35, 0x7a, 0x00, 0xeb, 0x6e, 0x34, 0xd2, 0x6d, 0x4b, 0x5e, 0x39, 0x90, 0x0e, 0x57,
	0xb5, 0x35, 0x37, 0x1a, 0x35, 0x2c, 0x74, 0x06, 0x39, 0x33, 0xc0, 0x16, 0x76, 0x89, 0x6d, 0x38,
	0xa1, 0xbc, 0x79, 0xb0, 0x72, 0x98, 0x3b, 0xfe, 0xa2, 0x92, 0x72, 0x8a, 0x0a, 0x77, 0x56, 0x4b,
	0xac, 0xb5, 0x69, 0x24, 0xfa, 0x03, 0xec, 0x38, 0x46, 0x48, 0xf4, 0x21, 0x36, 0x02, 0xd2, 0xc7,
	0x06, 0xd1, 0xe9, 0x49, 0xe4, 0xfb, 0x07, 0xd2, 0x61, 0xee, 0xb8, 0x14, 0x13, 0xc6, 0xc7, 0xac,
	0xf4, 0xe2, 0x63, 0x6a, 0x45, 0x0a, 0x3b, 0x8f, 0x51, 0x54, 0x8e, 0x4e, 0x60, 0x9b, 0x71, 0xe1,
	0x1b, 0xec, 0x0a, 0x9e, 0x8d, 0xa5, 0x3c, 0x5b, 0x14, 0xa2, 0x52, 0xc4, 0x0c, 0x07, 0x8d, 0x19,
	0xe6, 0x1c, 0xbb, 0x77, 0xe3, 0xe8, 0x52, 0x04, 0xe3, 0x78, 0x0d, 0xbb, 0x8c, 0xc3, 0xf4, 0xdc,
	0x2b, 0x7b, 0xa0, 0x1b, 0xe6, 0x35, 0x27, 0xca, 0xdf, 0xed, 0x50, 0x35, 0x06, 0xab, 0x9a, 0xd7,
	0x8c, 0xac, 0x05, 0x0f, 0xa6, 0xc9, 0x42, 0xec, 0x5a, 0x9c, 0x0d, 0x2d, 0x65, 0x43, 0x13, 0xb6,
	0x2e, 0x76, 0x2d, 0x46, 0x27, 0xc3, 0xfd, 0xbe, 0xe3, 0x99, 0xd7, 0xd8, 0x92, 0x77, 0x0e, 0xa4,
	0xc3, 0x0d, 0x2d, 0xde, 0x4e, 0xa2, 0x17, 0x04, 0x5e, 0xc0, 0x5d, 0xc0, 0x1d, 0xa3, 0x47, 0x11,
	0x8c, 0xfd, 0x77, 0x50, 0x9c, 0xe2, 0xe0, 0x75, 0x27, 0xe7, 0x18, 0x0b, 0x8a, 0x59, 0x02, 0xdf,
	0xac, 0x74, 0x99, 0x46, 0xdb, 0x4e, 0xd0, 0x5c, 0x80, 0x5e, 0xc0, 0x3a, 0x3f, 0xa7, 0xbc, 0xc5,
	0x40, 0x4f, 0x6e, 0xab, 0x28, 0x66, 0xa8, 0x09, 0x00, 0x7a, 0x0e, 0x6b, 0x2c, 0x67, 0x72, 0x81,
	0x21, 0x0f, 0x6e, 0x41, 0xb2, 0x4c, 0x69, 0xdc, 0x1c, 0xbd, 0x84, 0xac, 0xe3, 0x0d, 0x74, 0x07,
	0xdf, 0x60, 0x47, 0x7e, 0x70, 0x20, 0x1d, 0xe6, 0x8f, 0x3f, 0x4b, 0xc5, 0x36, 0xbd, 0x41, 0x93,
	0x1a, 0x69, 0x1b, 0x8e, 0x58, 0x21, 0x15, 0x36, 0x46, 0x98, 0x18, 0x96, 0x41, 0x0c, 0xb9, 0xc8,
	0x5a, 0xe0, 0xcb, 0x5b, 0xdc, 0x56, 0x5a, 0xc2, 0x56, 0x75, 0x49, 0x30, 0xd6, 0x12, 0x28, 0x6a,
	0x40, 0x7e, 0x60, 0x10, 0xfc, 0x67, 0x63, 0x2c, 0xb2, 0x2c, 0xcb, 0xec, 0x0c, 0xe5, 0x54, 0xb2,
	0x33, 0x6e, 0x2a, 0x8e, 0xbf, 0x35, 0x98, 0xde, 0x96, 0x5e, 0xc1, 0xd6, 0x8c, 0x17, 0x54, 0x80,
	0x95, 0x6b, 0x3c, 0x16, 0x4d, 0x4e, 0x97, 0x68, 0x17, 0xd6, 0x6e, 0x0c, 0x27, 0x8a, 0xdb, 0x9c,
	0x6f, 0x5e, 0x66, 0x7e, 0x2d, 0xbd, 0x0c, 0x7f, 0xac, 0xfa, 0xf0, 0x88, 0x39, 0xa3, 0xbe, 0xb8,
	0x73, 0xc3, 0xb7, 0xc3, 0x8a, 0xe9, 0x8d, 0x14, 0x31, 0x34, 0xda, 0x7e, 0xe0, 0xbd, 0xc3, 0x26,
	0x09, 0x95, 0xf7, 0x62, 0xf5, 0x41, 0x71, 0x3c, 0xd3, 0x20, 0xb6, 0xe7, 0x86, 0xca, 0xfb, 0x78,
	0xf9, 0x41, 0x09, 0xf0, 0xc0, 0x0e, 0x49, 0x60, 0xe3, 0x50, 0x79, 0x2f, 0xd6, 0xe3, 0x0f, 0x8a,
	0xc5, 0x58, 0x42, 0xe5, 0x3d, 0x5f, 0x7c, 0x28, 0xff, 0x2b, 0x03, 0x5b, 0x33, 0x47, 0x42, 0x35,
	0xd8, 0x8c, 0xc3, 0x41, 0xc6, 0x3e, 0x66, 0xdf, 0x9e, 0x5f, 0x90, 0x50, 0x81, 0xec, 0x8d, 0x7d,
	0xac, 0xe5, 0x06, 0x93, 0x0d, 0x7a, 0x03, 0x3b, 0x31, 0x89, 0x11, 0x91, 0xa1, 0x3e, 0xc2, 0x64,
	0xe8, 0x59, 0xec, 0xcc, 0xf9, 0xe3, 0xa7, 0xb7, 0x71, 0x55, 0x23, 0x32, 0x6c, 0x31, 0x6b, 0xad,
	0x38, 0x98, 0x17, 0xa1, 0x5f, 0x81, 0xcc, 0x2a, 0xdc, 0x30, 0x4d, 0x1c, 0x86, 0xd8, 0xd2, 0x63,
	0x2f, 0x62, 0x42, 0x66, 0x35, 0xd6, 0xae, 0x55, 0xa1, 0x16, 0x9c, 0x0d, 0x0b, 0x7d, 0x0b, 0xa5,
	0x74, 0x20, 0xeb, 0xb4, 0xd5, 0xa5, 0x9d, 0xb6, 0x9f, 0x42, 0x4b, 0xb5, 0xe5, 0xbf, 0xac, 0x41,
	0x9e, 0xe7, 0x46, 0x13, 0x51, 0xbe, 0xd3, 0x60, 0x7f, 0x07, 0x25, 0x3e, 0x27, 0x5d, 0x8f, 0xd8,
	0x57, 0x36, 0xcf, 0x9a, 0xa8, 0xbf, 0x50, 0x06, 0x56, 0xcd, 0x3f, 0x4f, 0x8d, 0x13, 0x1b, 0x96,
	0xed, 0x29, 0x94, 0x28, 0x45, 0x19, 0xa7, 0x2b, 0x42, 0x34, 0x84, 0x87, 0x7c, 0x9e, 0xa6, 0xf8,
	0x12, 0xa3, 0x3e, 0xdd, 0x15, 0xeb, 0xd4, 0x14, 0x57, 0xfb, 0x61, 0xba, 0x02, 0xfd, 0x1e, 0x72,
	0xa3, 0xef, 0x49, 0x3c, 0x2d, 0x45, 0x58, 0x1f, 0xa7, 0x72, 0xb7, 0xbe, 0x27, 0x62, 0x38, 0x6a,
	0x30, 0x4a, 0xd6, 0x94, 0x61, 0x48, 0x88, 0x1f, 0x33, 0x64, 0x6f, 0x61, 0x38, 0x27, 0xc4, 0x8f,
	0x19, 0x86, 0xc9, 0x7a, 0x76, 0xa2, 0xe4, 0x3e, 0x6d, 0xa2, 0x34, 0x66, 0xef, 0xd5, 0x0d, 0x96,
	0x86, 0x9f, 0xa5, 0xa2, 0xe3, 0x6c, 0x2f, 0xb8, 0x59, 0x5f, 0xbe, 0xfb, 0xb1, 0x3a, 0x80, 0xa7,
	0xb7, 0x77, 0x73, 0x52, 0x31, 0xbf, 0xfd, 0xbf, 0xba, 0xba, 0xfc, 0x1d, 0xc0, 0x24, 0x9c, 0xa8,
	0x09, 0x88, 0x25, 0x01, 0xbb, 0x46, 0xdf, 0xc1, 0x16, 0xbf, 0x4b, 0x45, 0x1b, 0x3f, 0x5a, 0x98,
	0x0b, 0x3e, 0x95, 0x0b, 0x14, 0xa9, 0x72, 0x20, 0x93, 0x50, 0xee, 0x49, 0xa0, 0x29, 0x37, 0x4b,
	0xcf, 0xdd, 0xb9, 0x29, 0x58, 0x70, 0x53, 0xe4, 0x0c, 0x77, 0x00, 0xfb, 0x0b, 0xaa, 0x19, 0x7d,
	0x05, 0xc5, 0x30, 0xea, 0x5f, 0x79, 0x8e, 0x85, 0x03, 0x7d, 0x64, 0x10, 0x73, 0x88, 0x43, 0xd1,
	0x40, 0x85, 0x44, 0xd1, 0xe2, 0x72, 0x74, 0x04, 0x45, 0x3f, 0xea, 0x87, 0x51, 0x5f, 0x27, 0x9e,
	0x6f, 0x9b, 0x3a, 0xeb, 0x36, 0xde, 0x7f, 0xdb, 0x5c, 0xd1, 0xa3, 0xf2, 0xb6, 0x31, 0xc2, 0x65,
	0x15, 0xf6, 0x17, 0x94, 0xf5, 0x27, 0xd1, 0xfc, 0x55, 0x02, 0xf4, 0x71, 0x09, 0x20, 0x03, 0xf6,
	0xfc, 0xa8, 0xef, 0xd8, 0xa6, 0x7e, 0x8d, 0xc7, 0xba, 0x89, 0x03, 0xe1, 0x84, 0xf3, 0x2c, 0xba,
	0xa0, 0x2e, 0x18, 0xe4, 0x35, 0x1e, 0xd7, 0x26, 0x80, 0xf3, 0x7b, 0xda, 0xae, 0x9f, 0x22, 0x3f,
	0xd9, 0x04, 0x98, 0xd4, 0x59, 0xf9, 0x1f, 0x19, 0xd8, 0xfb, 0xd3, 0xb3, 0xaf, 0x5f, 0x4c, 0x59,
	0xd4, 0x31, 0x31, 0x6c, 0x27, 0x44, 0x7b, 0xb0, 0x6e, 0x87, 0x61, 0x84, 0x03, 0x71, 0x06, 0xb1,
	0xa3, 0x6f, 0x90, 0x30, 0xea, 0xd3, 0x22, 0x13, 0x01, 0x8d, 0xb7, 0xe8, 0x05, 0x40, 0x48, 0x8c,
	0x40, 0x3c, 0xde, 0x56, 0x96, 0x0e, 0xc5, 0x2c, 0xb3, 0x66, 0x4f, 0x8f, 0x57, 0x90, 0xc3, 0x3f,
	0xf8, 0x76, 0x70, 0xe7, 0x81, 0x0a, 0xdc, 0x9c, 0x81, 0x15, 0xd8, 0x09, 0xed, 0x81, 0x6b, 0x90,
	0x28, 0xc0, 0xba, 0xe1, 0x0c, 0xbc, 0xc0, 0x26, 0xc3, 0x91, 0xbc, 0xc6, 0xbe, 0x0e, 0x25, 0xaa,
	0x6a, 0xac, 0x41, 0x4f, 0x61, 0x7b, 0x2a, 0xcc, 0xec, 0x9a, 0x5a, 0x67, 0xc6, 0x5b, 0x49, 0xc8,
	0xe8, 0x35, 0x54, 0xfe, 0xb7, 0x04, 0xbb, 0x69, 0xc1, 0x45, 0x67, 0xb0, 0x7e, 0xe5, 0x05, 0x23,
	0x83, 0x88, 0xda, 0x55, 0xee, 0x9c, 0x97, 0x53, 0x06, 0xd3, 0x04, 0x1c, 0x1d, 0x40, 0x6e, 0x3a,
	0xcb, 0x3c, 0xa0, 0xd3, 0x22, 0xd4, 0x86, 0xcd, 0x1f, 0x9e, 0x7d, 0xfd, 0x42, 0xb7, 0x78, 0x5a,
	0x44, 0x58, 0xbf, 0x4a, 0x75, 0x98, 0x9e, 0x49, 0x2d, 0x47, 0x09, 0xc4, 0xa6, 0xfc, 0x4f, 0x09,
	0x0a, 0xf3, 0x8f, 0x7a, 0xd4, 0x00, 0x98, 0x04, 0x84, 0x7d, 0x45, 0xee, 0xf8, 0x70, 0xc9, 0x99,
	0x12, 0xf4, 0xf9, 0x3d, 0x2d, 0x9b, 0xc4, 0x0d, 0xd5, 0x60, 0x9b, 0xa5, 0x86, 0xdf, 0x12, 0x2c,
	0x9b, 0xeb, 0x4b, 0xb3, 0x99, 0x9f, 0x40, 0xa8, 0x70, 0xae, 0x48, 0x31, 0xec, 0xa4, 0xb8, 0x45,
	0xbf, 0x99, 0x4b, 0xc2, 0x4f, 0x6f, 0xff, 0xe0, 0xb9, 0xc8, 0x8b, 0xa7, 0x55, 0x26, 0x79, 0x5a,
	0x95, 0xff, 0x23, 0xc1, 0xe6, 0xf4, 0xe3, 0x94, 0x56, 0xfa, 0x0d, 0x0e, 0x42, 0xdb, 0x73, 0x99,
	0x87, 0x15, 0x2d, 0xde, 0xa2, 0x53, 0x28, 0x32, 0x27, 0x7a, 0xe4, 0x5b, 0xc9, 0x2f, 0x8d, 0xcc,
	0xd2, 0x63, 0x6e, 0x33, 0xd0, 0x25, 0xc3, 0xc4, 0xbf, 0x57, 0xf8, 0x4b, 0x6a, 0xf2, 0x33, 0x63,
	0x79, 0xdb, 0x6c, 0x71, 0x48, 0xfc, 0x13, 0xe3, 0x31, 0xe4, 0xfa, 0xb6, 0x6b, 0x04, 0x63, 0x9d,
	0xbd, 0x64, 0x69, 0xeb, 0x6c, 0x6a, 0xc0, 0x45, 0x75, 0x83, 0x18, 0xe5, 0x6b, 0xc8, 0x4d, 0xbd,
	0x9c, 0x69, 0xab, 0x4d, 0x7f, 0xb5, 0xb4, 0xbc, 0xd5, 0xa2, 0xc9, 0x07, 0xcf, 0x39, 0xcb, 0xcc,
	0x3b, 0x3b, 0x6a, 0x42, 0x36, 0xb9, 0x0e, 0x50, 0x09, 0xf6, 0x5a, 0x7f, 0xec, 0xf5, 0xf4, 0x6e,
	0xaf, 0xda, 0x53, 0xf5, 0xcb, 0x76, 0xf7, 0x42, 0xad, 0x35, 0x4e, 0x1b, 0x6a, 0xbd, 0x70, 0x0f,
	0x15, 0x60, 0x93, 0xe9, 0xd4, 0x76, 0xf5, 0xa4, 0xa9, 0xd6, 0x0b, 0x12, 0x2a, 0xc2, 0x16, 0x93,
	0xd4, 0x1b, 0x5d, 0x2e, 0xca, 0x50, 0xb6, 0xe4, 0x02, 0xa0, 0x6c, 0xe7, 0xbd, 0xde, 0xc5, 0x22,
	0x36, 0xa6, 0x9b, 0x61, 0x63, 0x92, 0x29, 0xb6, 0x0e, 0x6c, 0xc4, 0x97, 0x36, 0x7a, 0x08, 0x0f,
	0x9a, 0x9d, 0x33, 0xbd, 0xa9, 0xbe, 0x51, 0x9b, 0x73, 0x5c, 0x1b, 0xb0, 0xda, 0xee, 0xb4, 0xd5,
	0x02, 0xa0, 0x2c, 0xac, 0xa9, 0x9a, 0xd6, 0xd1, 0x0a, 0xbb, 0x54, 0xd8, 0x68, 0x9f, 0x76, 0x0a,
	0x8f, 0xa8, 0xb0, 0xae, 0x9e, 0x5c, 0x9e, 0x15, 0x0e, 0x8f, 0x1a, 0x90, 0x9b, 0x7a, 0xc2, 0xa2,
	0x9f, 0x80, 0x7c, 0x56, 0xed, 0xa9, 0xdf, 0x56, 0xdf, 0xea, 0xbd, 0xb7, 0x17, 0xf3, 0x9f, 0x98,
	0x83, 0xfb, 0x42, 0x5b, 0x90, 0xd0, 0x36, 0xe4, 0xda, 0x9d, 0xb6, 0x1e, 0x0b, 0x32, 0x47, 0x7f,
	0x97, 0xa0, 0xf8, 0xd1, 0x13, 0x16, 0x7d, 0x0e, 0x8f, 0x63, 0xc6, 0xea, 0x65, 0xef, 0x5c, 0x6f,
	0xa9, 0xbd, 0xf3, 0x4e, 0x7d, 0x8e, 0x78, 0x17, 0x0a, 0xd5, 0x6e, 0xb7, 0x53, 0x6b, 0x54, 0x7b,
	0x8d, 0x4e, 0x5b, 0xef, 0xb4, 0x9b, 0xd4, 0x43, 0x09, 0xf6, 0xea, 0xea, 0x9b, 0x46, 0x4d, 0xe5,
	0xc8, 0x5e, 0xe7, 0xb5, 0x2a, 0x74, 0x19, 0xf4, 0x05, 0x3c, 0x99, 0x46, 0x54, 0xdb, 0x75, 0xfd,
	0x23, 0xdb, 0xc2, 0xca, 0x11, 0x86, 0xd2, 0xe2, 0x11, 0x86, 0x7e, 0x01, 0x5f, 0x4e, 0x7d, 0x87,
	0x7e, 0x71, 0x79, 0xd2, 0x6c, 0xd4, 0xf4, 0xd7, 0xea, 0x5b, 0xbd, 0xa6, 0x6a, 0xbd, 0xc6, 0x69,
	0xa3, 0x46, 0xd3, 0x74, 0xda, 0xd1, 0x5a, 0xd5, 0x5e, 0xe1, 0x1e, 0x92, 0x61, 0x97, 0x8e, 0xa7,
	0x19, 0xe5, 0x85, 0xda, 0x2a, 0x48, 0x47, 0x37, 0xb0, 0x3d, 0xd7, 0xa4, 0xe8, 0x09, 0x7c, 0xb6,
	0x80, 0x3b, 0xe1, 0xcb, 0xc1, 0x7d, 0xad, 0x5b, 0x65, 0x14, 0x2b, 0x34, 0xfd, 0x74, 0xc3, 0x1c,
	0x30, 0x52, 0xb4, 0x05, 0x59, 0xb5, 0x7b, 0xfc, 0xec, 0x39, 0xdb, 0x66, 0x10, 0x82, 0x3c, 0xdf,
	0x26, 0x26, 0xab, 0x27, 0x57, 0xb0, 0x6f, 0x7a, 0xa3, 0xb4, 0xa1, 0x71, 0x92, 0xd7, 0xe2, 0x7f,
	0x78, 0x2e, 0x68, 0x3f, 0x5c, 0x48, 0xdf, 0x3d, 0x17, 0x66, 0x03, 0xcf, 0x31, 0xdc, 0x41, 0xc5,
	0x0b, 0x06, 0xca, 0x00, 0xbb, 0xac, 0x5b, 0x94, 0xc9, 0xe3, 0x6c, 0xe6, 0x6f, 0xa2, 0x57, 0xb6,
	0x47, 0xfe, 0x2b, 0x49, 0xfd, 0x75, 0x66, 0xf5, 0xcb, 0xff, 0x05, 0x00, 0x00, 0xff, 0xff, 0x9d,
	0x58, 0x29, 0x24, 0x4b, 0x12, 0x00, 0x00,
}
