// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAddTagsToResource = "AddTagsToResource"

// AddTagsToResourceRequest generates a "aws/request.Request" representing the
// client's request for the AddTagsToResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddTagsToResource for more information on using the AddTagsToResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddTagsToResourceRequest method.
//    req, resp := client.AddTagsToResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/AddTagsToResource
func (c *SSM) AddTagsToResourceRequest(input *AddTagsToResourceInput) (req *request.Request, output *AddTagsToResourceOutput) {
	op := &request.Operation{
		Name:       opAddTagsToResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsToResourceInput{}
	}

	output = &AddTagsToResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddTagsToResource API operation for Amazon Simple Systems Manager (SSM).
//
// Adds or overwrites one or more tags for the specified resource. Tags are
// metadata that you can assign to your documents, managed instances, Maintenance
// Windows, Parameter Store parameters, and patch baselines. Tags enable you
// to categorize your resources in different ways, for example, by purpose,
// owner, or environment. Each tag consists of a key and an optional value,
// both of which you define. For example, you could define a set of tags for
// your account's managed instances that helps you track each instance's owner
// and stack level. For example: Key=Owner and Value=DbAdmin, SysAdmin, or Dev.
// Or Key=Stack and Value=Production, Pre-Production, or Test.
//
// Each resource can have a maximum of 50 tags.
//
// We recommend that you devise a set of tag keys that meets your needs for
// each resource type. Using a consistent set of tag keys makes it easier for
// you to manage your resources. You can search and filter the resources based
// on the tags you add. Tags don't have any semantic meaning to Amazon EC2 and
// are interpreted strictly as a string of characters.
//
// For more information about tags, see Tagging Your Amazon EC2 Resources (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html)
// in the Amazon EC2 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation AddTagsToResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidResourceType "InvalidResourceType"
//   The resource type is not valid. For example, if you are attempting to tag
//   an instance, the instance must be a registered, managed instance.
//
//   * ErrCodeInvalidResourceId "InvalidResourceId"
//   The resource ID is not valid. Verify that you entered the correct ID and
//   try again.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeTooManyTagsError "TooManyTagsError"
//   The Targets parameter includes too many tags. Remove one or more tags and
//   try the command again.
//
//   * ErrCodeTooManyUpdates "TooManyUpdates"
//   There are concurrent updates for a resource that supports one update at a
//   time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/AddTagsToResource
func (c *SSM) AddTagsToResource(input *AddTagsToResourceInput) (*AddTagsToResourceOutput, error) {
	req, out := c.AddTagsToResourceRequest(input)
	return out, req.Send()
}

// AddTagsToResourceWithContext is the same as AddTagsToResource with the addition of
// the ability to pass a context and additional request options.
//
// See AddTagsToResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) AddTagsToResourceWithContext(ctx aws.Context, input *AddTagsToResourceInput, opts ...request.Option) (*AddTagsToResourceOutput, error) {
	req, out := c.AddTagsToResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelCommand = "CancelCommand"

// CancelCommandRequest generates a "aws/request.Request" representing the
// client's request for the CancelCommand operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelCommand for more information on using the CancelCommand
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelCommandRequest method.
//    req, resp := client.CancelCommandRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CancelCommand
func (c *SSM) CancelCommandRequest(input *CancelCommandInput) (req *request.Request, output *CancelCommandOutput) {
	op := &request.Operation{
		Name:       opCancelCommand,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelCommandInput{}
	}

	output = &CancelCommandOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelCommand API operation for Amazon Simple Systems Manager (SSM).
//
// Attempts to cancel the command specified by the Command ID. There is no guarantee
// that the command will be terminated and the underlying process stopped.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation CancelCommand for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidCommandId "InvalidCommandId"
//
//   * ErrCodeInvalidInstanceId "InvalidInstanceId"
//   The following problems can cause this exception:
//
//   You do not have permission to access the instance.
//
//   SSM Agent is not running. On managed instances and Linux instances, verify
//   that the SSM Agent is running. On EC2 Windows instances, verify that the
//   EC2Config service is running.
//
//   SSM Agent or EC2Config service is not registered to the SSM endpoint. Try
//   reinstalling SSM Agent or EC2Config service.
//
//   The instance is not in valid state. Valid states are: Running, Pending, Stopped,
//   Stopping. Invalid states are: Shutting-down and Terminated.
//
//   * ErrCodeDuplicateInstanceId "DuplicateInstanceId"
//   You cannot specify an instance ID in more than one association.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CancelCommand
func (c *SSM) CancelCommand(input *CancelCommandInput) (*CancelCommandOutput, error) {
	req, out := c.CancelCommandRequest(input)
	return out, req.Send()
}

// CancelCommandWithContext is the same as CancelCommand with the addition of
// the ability to pass a context and additional request options.
//
// See CancelCommand for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) CancelCommandWithContext(ctx aws.Context, input *CancelCommandInput, opts ...request.Option) (*CancelCommandOutput, error) {
	req, out := c.CancelCommandRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelMaintenanceWindowExecution = "CancelMaintenanceWindowExecution"

// CancelMaintenanceWindowExecutionRequest generates a "aws/request.Request" representing the
// client's request for the CancelMaintenanceWindowExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelMaintenanceWindowExecution for more information on using the CancelMaintenanceWindowExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelMaintenanceWindowExecutionRequest method.
//    req, resp := client.CancelMaintenanceWindowExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CancelMaintenanceWindowExecution
func (c *SSM) CancelMaintenanceWindowExecutionRequest(input *CancelMaintenanceWindowExecutionInput) (req *request.Request, output *CancelMaintenanceWindowExecutionOutput) {
	op := &request.Operation{
		Name:       opCancelMaintenanceWindowExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelMaintenanceWindowExecutionInput{}
	}

	output = &CancelMaintenanceWindowExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelMaintenanceWindowExecution API operation for Amazon Simple Systems Manager (SSM).
//
// Stops a Maintenance Window execution that is already in progress and cancels
// any tasks in the window that have not already starting running. (Tasks already
// in progress will continue to completion.)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation CancelMaintenanceWindowExecution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeDoesNotExistException "DoesNotExistException"
//   Error returned when the ID specified for a resource, such as a Maintenance
//   Window or Patch baseline, doesn't exist.
//
//   For information about resource limits in Systems Manager, see AWS Systems
//   Manager Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_ssm).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CancelMaintenanceWindowExecution
func (c *SSM) CancelMaintenanceWindowExecution(input *CancelMaintenanceWindowExecutionInput) (*CancelMaintenanceWindowExecutionOutput, error) {
	req, out := c.CancelMaintenanceWindowExecutionRequest(input)
	return out, req.Send()
}

// CancelMaintenanceWindowExecutionWithContext is the same as CancelMaintenanceWindowExecution with the addition of
// the ability to pass a context and additional request options.
//
// See CancelMaintenanceWindowExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) CancelMaintenanceWindowExecutionWithContext(ctx aws.Context, input *CancelMaintenanceWindowExecutionInput, opts ...request.Option) (*CancelMaintenanceWindowExecutionOutput, error) {
	req, out := c.CancelMaintenanceWindowExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateActivation = "CreateActivation"

// CreateActivationRequest generates a "aws/request.Request" representing the
// client's request for the CreateActivation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateActivation for more information on using the CreateActivation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateActivationRequest method.
//    req, resp := client.CreateActivationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateActivation
func (c *SSM) CreateActivationRequest(input *CreateActivationInput) (req *request.Request, output *CreateActivationOutput) {
	op := &request.Operation{
		Name:       opCreateActivation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateActivationInput{}
	}

	output = &CreateActivationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateActivation API operation for Amazon Simple Systems Manager (SSM).
//
// Registers your on-premises server or virtual machine with Amazon EC2 so that
// you can manage these resources using Run Command. An on-premises server or
// virtual machine that has been registered with EC2 is called a managed instance.
// For more information about activations, see Setting Up Systems Manager in
// Hybrid Environments (http://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-managedinstances.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation CreateActivation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateActivation
func (c *SSM) CreateActivation(input *CreateActivationInput) (*CreateActivationOutput, error) {
	req, out := c.CreateActivationRequest(input)
	return out, req.Send()
}

// CreateActivationWithContext is the same as CreateActivation with the addition of
// the ability to pass a context and additional request options.
//
// See CreateActivation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) CreateActivationWithContext(ctx aws.Context, input *CreateActivationInput, opts ...request.Option) (*CreateActivationOutput, error) {
	req, out := c.CreateActivationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAssociation = "CreateAssociation"

// CreateAssociationRequest generates a "aws/request.Request" representing the
// client's request for the CreateAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAssociation for more information on using the CreateAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAssociationRequest method.
//    req, resp := client.CreateAssociationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateAssociation
func (c *SSM) CreateAssociationRequest(input *CreateAssociationInput) (req *request.Request, output *CreateAssociationOutput) {
	op := &request.Operation{
		Name:       opCreateAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAssociationInput{}
	}

	output = &CreateAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAssociation API operation for Amazon Simple Systems Manager (SSM).
//
// Associates the specified Systems Manager document with the specified instances
// or targets.
//
// When you associate a document with one or more instances using instance IDs
// or tags, SSM Agent running on the instance processes the document and configures
// the instance as specified.
//
// If you associate a document with an instance that already has an associated
// document, the system returns the AssociationAlreadyExists exception.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation CreateAssociation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAssociationAlreadyExists "AssociationAlreadyExists"
//   The specified association already exists.
//
//   * ErrCodeAssociationLimitExceeded "AssociationLimitExceeded"
//   You can have at most 2,000 active associations.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidDocument "InvalidDocument"
//   The specified document does not exist.
//
//   * ErrCodeInvalidDocumentVersion "InvalidDocumentVersion"
//   The document version is not valid or does not exist.
//
//   * ErrCodeInvalidInstanceId "InvalidInstanceId"
//   The following problems can cause this exception:
//
//   You do not have permission to access the instance.
//
//   SSM Agent is not running. On managed instances and Linux instances, verify
//   that the SSM Agent is running. On EC2 Windows instances, verify that the
//   EC2Config service is running.
//
//   SSM Agent or EC2Config service is not registered to the SSM endpoint. Try
//   reinstalling SSM Agent or EC2Config service.
//
//   The instance is not in valid state. Valid states are: Running, Pending, Stopped,
//   Stopping. Invalid states are: Shutting-down and Terminated.
//
//   * ErrCodeUnsupportedPlatformType "UnsupportedPlatformType"
//   The document does not support the platform type of the given instance ID(s).
//   For example, you sent an document for a Windows instance to a Linux instance.
//
//   * ErrCodeInvalidOutputLocation "InvalidOutputLocation"
//   The output location is not valid or does not exist.
//
//   * ErrCodeInvalidParameters "InvalidParameters"
//   You must specify values for all required parameters in the Systems Manager
//   document. You can only supply values to parameters defined in the Systems
//   Manager document.
//
//   * ErrCodeInvalidTarget "InvalidTarget"
//   The target is not valid or does not exist. It might not be configured for
//   EC2 Systems Manager or you might not have permission to perform the operation.
//
//   * ErrCodeInvalidSchedule "InvalidSchedule"
//   The schedule is invalid. Verify your cron or rate expression and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateAssociation
func (c *SSM) CreateAssociation(input *CreateAssociationInput) (*CreateAssociationOutput, error) {
	req, out := c.CreateAssociationRequest(input)
	return out, req.Send()
}

// CreateAssociationWithContext is the same as CreateAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) CreateAssociationWithContext(ctx aws.Context, input *CreateAssociationInput, opts ...request.Option) (*CreateAssociationOutput, error) {
	req, out := c.CreateAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAssociationBatch = "CreateAssociationBatch"

// CreateAssociationBatchRequest generates a "aws/request.Request" representing the
// client's request for the CreateAssociationBatch operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAssociationBatch for more information on using the CreateAssociationBatch
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAssociationBatchRequest method.
//    req, resp := client.CreateAssociationBatchRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateAssociationBatch
func (c *SSM) CreateAssociationBatchRequest(input *CreateAssociationBatchInput) (req *request.Request, output *CreateAssociationBatchOutput) {
	op := &request.Operation{
		Name:       opCreateAssociationBatch,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAssociationBatchInput{}
	}

	output = &CreateAssociationBatchOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAssociationBatch API operation for Amazon Simple Systems Manager (SSM).
//
// Associates the specified Systems Manager document with the specified instances
// or targets.
//
// When you associate a document with one or more instances using instance IDs
// or tags, SSM Agent running on the instance processes the document and configures
// the instance as specified.
//
// If you associate a document with an instance that already has an associated
// document, the system returns the AssociationAlreadyExists exception.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation CreateAssociationBatch for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidDocument "InvalidDocument"
//   The specified document does not exist.
//
//   * ErrCodeInvalidDocumentVersion "InvalidDocumentVersion"
//   The document version is not valid or does not exist.
//
//   * ErrCodeInvalidInstanceId "InvalidInstanceId"
//   The following problems can cause this exception:
//
//   You do not have permission to access the instance.
//
//   SSM Agent is not running. On managed instances and Linux instances, verify
//   that the SSM Agent is running. On EC2 Windows instances, verify that the
//   EC2Config service is running.
//
//   SSM Agent or EC2Config service is not registered to the SSM endpoint. Try
//   reinstalling SSM Agent or EC2Config service.
//
//   The instance is not in valid state. Valid states are: Running, Pending, Stopped,
//   Stopping. Invalid states are: Shutting-down and Terminated.
//
//   * ErrCodeInvalidParameters "InvalidParameters"
//   You must specify values for all required parameters in the Systems Manager
//   document. You can only supply values to parameters defined in the Systems
//   Manager document.
//
//   * ErrCodeDuplicateInstanceId "DuplicateInstanceId"
//   You cannot specify an instance ID in more than one association.
//
//   * ErrCodeAssociationLimitExceeded "AssociationLimitExceeded"
//   You can have at most 2,000 active associations.
//
//   * ErrCodeUnsupportedPlatformType "UnsupportedPlatformType"
//   The document does not support the platform type of the given instance ID(s).
//   For example, you sent an document for a Windows instance to a Linux instance.
//
//   * ErrCodeInvalidOutputLocation "InvalidOutputLocation"
//   The output location is not valid or does not exist.
//
//   * ErrCodeInvalidTarget "InvalidTarget"
//   The target is not valid or does not exist. It might not be configured for
//   EC2 Systems Manager or you might not have permission to perform the operation.
//
//   * ErrCodeInvalidSchedule "InvalidSchedule"
//   The schedule is invalid. Verify your cron or rate expression and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateAssociationBatch
func (c *SSM) CreateAssociationBatch(input *CreateAssociationBatchInput) (*CreateAssociationBatchOutput, error) {
	req, out := c.CreateAssociationBatchRequest(input)
	return out, req.Send()
}

// CreateAssociationBatchWithContext is the same as CreateAssociationBatch with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAssociationBatch for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) CreateAssociationBatchWithContext(ctx aws.Context, input *CreateAssociationBatchInput, opts ...request.Option) (*CreateAssociationBatchOutput, error) {
	req, out := c.CreateAssociationBatchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDocument = "CreateDocument"

// CreateDocumentRequest generates a "aws/request.Request" representing the
// client's request for the CreateDocument operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDocument for more information on using the CreateDocument
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDocumentRequest method.
//    req, resp := client.CreateDocumentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateDocument
func (c *SSM) CreateDocumentRequest(input *CreateDocumentInput) (req *request.Request, output *CreateDocumentOutput) {
	op := &request.Operation{
		Name:       opCreateDocument,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDocumentInput{}
	}

	output = &CreateDocumentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDocument API operation for Amazon Simple Systems Manager (SSM).
//
// Creates a Systems Manager document.
//
// After you create a document, you can use CreateAssociation to associate it
// with one or more running instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation CreateDocument for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDocumentAlreadyExists "DocumentAlreadyExists"
//   The specified document already exists.
//
//   * ErrCodeMaxDocumentSizeExceeded "MaxDocumentSizeExceeded"
//   The size limit of a document is 64 KB.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidDocumentContent "InvalidDocumentContent"
//   The content for the document is not valid.
//
//   * ErrCodeDocumentLimitExceeded "DocumentLimitExceeded"
//   You can have at most 200 active Systems Manager documents.
//
//   * ErrCodeInvalidDocumentSchemaVersion "InvalidDocumentSchemaVersion"
//   The version of the document schema is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateDocument
func (c *SSM) CreateDocument(input *CreateDocumentInput) (*CreateDocumentOutput, error) {
	req, out := c.CreateDocumentRequest(input)
	return out, req.Send()
}

// CreateDocumentWithContext is the same as CreateDocument with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDocument for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) CreateDocumentWithContext(ctx aws.Context, input *CreateDocumentInput, opts ...request.Option) (*CreateDocumentOutput, error) {
	req, out := c.CreateDocumentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMaintenanceWindow = "CreateMaintenanceWindow"

// CreateMaintenanceWindowRequest generates a "aws/request.Request" representing the
// client's request for the CreateMaintenanceWindow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMaintenanceWindow for more information on using the CreateMaintenanceWindow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateMaintenanceWindowRequest method.
//    req, resp := client.CreateMaintenanceWindowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateMaintenanceWindow
func (c *SSM) CreateMaintenanceWindowRequest(input *CreateMaintenanceWindowInput) (req *request.Request, output *CreateMaintenanceWindowOutput) {
	op := &request.Operation{
		Name:       opCreateMaintenanceWindow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateMaintenanceWindowInput{}
	}

	output = &CreateMaintenanceWindowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMaintenanceWindow API operation for Amazon Simple Systems Manager (SSM).
//
// Creates a new Maintenance Window.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation CreateMaintenanceWindow for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeIdempotentParameterMismatch "IdempotentParameterMismatch"
//   Error returned when an idempotent operation is retried and the parameters
//   don't match the original call to the API with the same idempotency token.
//
//   * ErrCodeResourceLimitExceededException "ResourceLimitExceededException"
//   Error returned when the caller has exceeded the default resource limits.
//   For example, too many Maintenance Windows or Patch baselines have been created.
//
//   For information about resource limits in Systems Manager, see AWS Systems
//   Manager Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_ssm).
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateMaintenanceWindow
func (c *SSM) CreateMaintenanceWindow(input *CreateMaintenanceWindowInput) (*CreateMaintenanceWindowOutput, error) {
	req, out := c.CreateMaintenanceWindowRequest(input)
	return out, req.Send()
}

// CreateMaintenanceWindowWithContext is the same as CreateMaintenanceWindow with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMaintenanceWindow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) CreateMaintenanceWindowWithContext(ctx aws.Context, input *CreateMaintenanceWindowInput, opts ...request.Option) (*CreateMaintenanceWindowOutput, error) {
	req, out := c.CreateMaintenanceWindowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePatchBaseline = "CreatePatchBaseline"

// CreatePatchBaselineRequest generates a "aws/request.Request" representing the
// client's request for the CreatePatchBaseline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePatchBaseline for more information on using the CreatePatchBaseline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePatchBaselineRequest method.
//    req, resp := client.CreatePatchBaselineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreatePatchBaseline
func (c *SSM) CreatePatchBaselineRequest(input *CreatePatchBaselineInput) (req *request.Request, output *CreatePatchBaselineOutput) {
	op := &request.Operation{
		Name:       opCreatePatchBaseline,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePatchBaselineInput{}
	}

	output = &CreatePatchBaselineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePatchBaseline API operation for Amazon Simple Systems Manager (SSM).
//
// Creates a patch baseline.
//
// For information about valid key and value pairs in PatchFilters for each
// supported operating system type, see PatchFilter (http://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation CreatePatchBaseline for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeIdempotentParameterMismatch "IdempotentParameterMismatch"
//   Error returned when an idempotent operation is retried and the parameters
//   don't match the original call to the API with the same idempotency token.
//
//   * ErrCodeResourceLimitExceededException "ResourceLimitExceededException"
//   Error returned when the caller has exceeded the default resource limits.
//   For example, too many Maintenance Windows or Patch baselines have been created.
//
//   For information about resource limits in Systems Manager, see AWS Systems
//   Manager Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_ssm).
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreatePatchBaseline
func (c *SSM) CreatePatchBaseline(input *CreatePatchBaselineInput) (*CreatePatchBaselineOutput, error) {
	req, out := c.CreatePatchBaselineRequest(input)
	return out, req.Send()
}

// CreatePatchBaselineWithContext is the same as CreatePatchBaseline with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePatchBaseline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) CreatePatchBaselineWithContext(ctx aws.Context, input *CreatePatchBaselineInput, opts ...request.Option) (*CreatePatchBaselineOutput, error) {
	req, out := c.CreatePatchBaselineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateResourceDataSync = "CreateResourceDataSync"

// CreateResourceDataSyncRequest generates a "aws/request.Request" representing the
// client's request for the CreateResourceDataSync operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateResourceDataSync for more information on using the CreateResourceDataSync
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateResourceDataSyncRequest method.
//    req, resp := client.CreateResourceDataSyncRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateResourceDataSync
func (c *SSM) CreateResourceDataSyncRequest(input *CreateResourceDataSyncInput) (req *request.Request, output *CreateResourceDataSyncOutput) {
	op := &request.Operation{
		Name:       opCreateResourceDataSync,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateResourceDataSyncInput{}
	}

	output = &CreateResourceDataSyncOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateResourceDataSync API operation for Amazon Simple Systems Manager (SSM).
//
// Creates a resource data sync configuration to a single bucket in Amazon S3.
// This is an asynchronous operation that returns immediately. After a successful
// initial sync is completed, the system continuously syncs data to the Amazon
// S3 bucket. To check the status of the sync, use the ListResourceDataSync.
//
// By default, data is not encrypted in Amazon S3. We strongly recommend that
// you enable encryption in Amazon S3 to ensure secure data storage. We also
// recommend that you secure access to the Amazon S3 bucket by creating a restrictive
// bucket policy. To view an example of a restrictive Amazon S3 bucket policy
// for Resource Data Sync, see Create a Resource Data Sync for Inventory (http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-datasync-create.html)
// in the AWS Systems Manager User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation CreateResourceDataSync for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeResourceDataSyncCountExceededException "ResourceDataSyncCountExceededException"
//   You have exceeded the allowed maximum sync configurations.
//
//   * ErrCodeResourceDataSyncAlreadyExistsException "ResourceDataSyncAlreadyExistsException"
//   A sync configuration with the same name already exists.
//
//   * ErrCodeResourceDataSyncInvalidConfigurationException "ResourceDataSyncInvalidConfigurationException"
//   The specified sync configuration is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateResourceDataSync
func (c *SSM) CreateResourceDataSync(input *CreateResourceDataSyncInput) (*CreateResourceDataSyncOutput, error) {
	req, out := c.CreateResourceDataSyncRequest(input)
	return out, req.Send()
}

// CreateResourceDataSyncWithContext is the same as CreateResourceDataSync with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResourceDataSync for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) CreateResourceDataSyncWithContext(ctx aws.Context, input *CreateResourceDataSyncInput, opts ...request.Option) (*CreateResourceDataSyncOutput, error) {
	req, out := c.CreateResourceDataSyncRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteActivation = "DeleteActivation"

// DeleteActivationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteActivation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteActivation for more information on using the DeleteActivation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteActivationRequest method.
//    req, resp := client.DeleteActivationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteActivation
func (c *SSM) DeleteActivationRequest(input *DeleteActivationInput) (req *request.Request, output *DeleteActivationOutput) {
	op := &request.Operation{
		Name:       opDeleteActivation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteActivationInput{}
	}

	output = &DeleteActivationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteActivation API operation for Amazon Simple Systems Manager (SSM).
//
// Deletes an activation. You are not required to delete an activation. If you
// delete an activation, you can no longer use it to register additional managed
// instances. Deleting an activation does not de-register managed instances.
// You must manually de-register managed instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DeleteActivation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidActivationId "InvalidActivationId"
//   The activation ID is not valid. Verify the you entered the correct ActivationId
//   or ActivationCode and try again.
//
//   * ErrCodeInvalidActivation "InvalidActivation"
//   The activation is not valid. The activation might have been deleted, or the
//   ActivationId and the ActivationCode do not match.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeTooManyUpdates "TooManyUpdates"
//   There are concurrent updates for a resource that supports one update at a
//   time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteActivation
func (c *SSM) DeleteActivation(input *DeleteActivationInput) (*DeleteActivationOutput, error) {
	req, out := c.DeleteActivationRequest(input)
	return out, req.Send()
}

// DeleteActivationWithContext is the same as DeleteActivation with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteActivation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DeleteActivationWithContext(ctx aws.Context, input *DeleteActivationInput, opts ...request.Option) (*DeleteActivationOutput, error) {
	req, out := c.DeleteActivationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAssociation = "DeleteAssociation"

// DeleteAssociationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAssociation for more information on using the DeleteAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAssociationRequest method.
//    req, resp := client.DeleteAssociationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteAssociation
func (c *SSM) DeleteAssociationRequest(input *DeleteAssociationInput) (req *request.Request, output *DeleteAssociationOutput) {
	op := &request.Operation{
		Name:       opDeleteAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAssociationInput{}
	}

	output = &DeleteAssociationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAssociation API operation for Amazon Simple Systems Manager (SSM).
//
// Disassociates the specified Systems Manager document from the specified instance.
//
// When you disassociate a document from an instance, it does not change the
// configuration of the instance. To change the configuration state of an instance
// after you disassociate a document, you must create a new document with the
// desired configuration and associate it with the instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DeleteAssociation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAssociationDoesNotExist "AssociationDoesNotExist"
//   The specified association does not exist.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidDocument "InvalidDocument"
//   The specified document does not exist.
//
//   * ErrCodeInvalidInstanceId "InvalidInstanceId"
//   The following problems can cause this exception:
//
//   You do not have permission to access the instance.
//
//   SSM Agent is not running. On managed instances and Linux instances, verify
//   that the SSM Agent is running. On EC2 Windows instances, verify that the
//   EC2Config service is running.
//
//   SSM Agent or EC2Config service is not registered to the SSM endpoint. Try
//   reinstalling SSM Agent or EC2Config service.
//
//   The instance is not in valid state. Valid states are: Running, Pending, Stopped,
//   Stopping. Invalid states are: Shutting-down and Terminated.
//
//   * ErrCodeTooManyUpdates "TooManyUpdates"
//   There are concurrent updates for a resource that supports one update at a
//   time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteAssociation
func (c *SSM) DeleteAssociation(input *DeleteAssociationInput) (*DeleteAssociationOutput, error) {
	req, out := c.DeleteAssociationRequest(input)
	return out, req.Send()
}

// DeleteAssociationWithContext is the same as DeleteAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DeleteAssociationWithContext(ctx aws.Context, input *DeleteAssociationInput, opts ...request.Option) (*DeleteAssociationOutput, error) {
	req, out := c.DeleteAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDocument = "DeleteDocument"

// DeleteDocumentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDocument operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDocument for more information on using the DeleteDocument
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDocumentRequest method.
//    req, resp := client.DeleteDocumentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteDocument
func (c *SSM) DeleteDocumentRequest(input *DeleteDocumentInput) (req *request.Request, output *DeleteDocumentOutput) {
	op := &request.Operation{
		Name:       opDeleteDocument,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDocumentInput{}
	}

	output = &DeleteDocumentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDocument API operation for Amazon Simple Systems Manager (SSM).
//
// Deletes the Systems Manager document and all instance associations to the
// document.
//
// Before you delete the document, we recommend that you use DeleteAssociation
// to disassociate all instances that are associated with the document.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DeleteDocument for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidDocument "InvalidDocument"
//   The specified document does not exist.
//
//   * ErrCodeInvalidDocumentOperation "InvalidDocumentOperation"
//   You attempted to delete a document while it is still shared. You must stop
//   sharing the document before you can delete it.
//
//   * ErrCodeAssociatedInstances "AssociatedInstances"
//   You must disassociate a document from all instances before you can delete
//   it.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteDocument
func (c *SSM) DeleteDocument(input *DeleteDocumentInput) (*DeleteDocumentOutput, error) {
	req, out := c.DeleteDocumentRequest(input)
	return out, req.Send()
}

// DeleteDocumentWithContext is the same as DeleteDocument with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDocument for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DeleteDocumentWithContext(ctx aws.Context, input *DeleteDocumentInput, opts ...request.Option) (*DeleteDocumentOutput, error) {
	req, out := c.DeleteDocumentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInventory = "DeleteInventory"

// DeleteInventoryRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInventory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInventory for more information on using the DeleteInventory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteInventoryRequest method.
//    req, resp := client.DeleteInventoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteInventory
func (c *SSM) DeleteInventoryRequest(input *DeleteInventoryInput) (req *request.Request, output *DeleteInventoryOutput) {
	op := &request.Operation{
		Name:       opDeleteInventory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteInventoryInput{}
	}

	output = &DeleteInventoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteInventory API operation for Amazon Simple Systems Manager (SSM).
//
// Delete a custom inventory type, or the data associated with a custom Inventory
// type. Deleting a custom inventory type is also referred to as deleting a
// custom inventory schema.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DeleteInventory for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidTypeNameException "InvalidTypeNameException"
//   The parameter type name is not valid.
//
//   * ErrCodeInvalidOptionException "InvalidOptionException"
//   The delete inventory option specified is not valid. Verify the option and
//   try again.
//
//   * ErrCodeInvalidDeleteInventoryParametersException "InvalidDeleteInventoryParametersException"
//   One or more of the parameters specified for the delete operation is not valid.
//   Verify all parameters and try again.
//
//   * ErrCodeInvalidInventoryRequestException "InvalidInventoryRequestException"
//   The request is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteInventory
func (c *SSM) DeleteInventory(input *DeleteInventoryInput) (*DeleteInventoryOutput, error) {
	req, out := c.DeleteInventoryRequest(input)
	return out, req.Send()
}

// DeleteInventoryWithContext is the same as DeleteInventory with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInventory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DeleteInventoryWithContext(ctx aws.Context, input *DeleteInventoryInput, opts ...request.Option) (*DeleteInventoryOutput, error) {
	req, out := c.DeleteInventoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMaintenanceWindow = "DeleteMaintenanceWindow"

// DeleteMaintenanceWindowRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMaintenanceWindow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMaintenanceWindow for more information on using the DeleteMaintenanceWindow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteMaintenanceWindowRequest method.
//    req, resp := client.DeleteMaintenanceWindowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteMaintenanceWindow
func (c *SSM) DeleteMaintenanceWindowRequest(input *DeleteMaintenanceWindowInput) (req *request.Request, output *DeleteMaintenanceWindowOutput) {
	op := &request.Operation{
		Name:       opDeleteMaintenanceWindow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteMaintenanceWindowInput{}
	}

	output = &DeleteMaintenanceWindowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteMaintenanceWindow API operation for Amazon Simple Systems Manager (SSM).
//
// Deletes a Maintenance Window.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DeleteMaintenanceWindow for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteMaintenanceWindow
func (c *SSM) DeleteMaintenanceWindow(input *DeleteMaintenanceWindowInput) (*DeleteMaintenanceWindowOutput, error) {
	req, out := c.DeleteMaintenanceWindowRequest(input)
	return out, req.Send()
}

// DeleteMaintenanceWindowWithContext is the same as DeleteMaintenanceWindow with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMaintenanceWindow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DeleteMaintenanceWindowWithContext(ctx aws.Context, input *DeleteMaintenanceWindowInput, opts ...request.Option) (*DeleteMaintenanceWindowOutput, error) {
	req, out := c.DeleteMaintenanceWindowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteParameter = "DeleteParameter"

// DeleteParameterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteParameter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteParameter for more information on using the DeleteParameter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteParameterRequest method.
//    req, resp := client.DeleteParameterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteParameter
func (c *SSM) DeleteParameterRequest(input *DeleteParameterInput) (req *request.Request, output *DeleteParameterOutput) {
	op := &request.Operation{
		Name:       opDeleteParameter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteParameterInput{}
	}

	output = &DeleteParameterOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteParameter API operation for Amazon Simple Systems Manager (SSM).
//
// Delete a parameter from the system.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DeleteParameter for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeParameterNotFound "ParameterNotFound"
//   The parameter could not be found. Verify the name and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteParameter
func (c *SSM) DeleteParameter(input *DeleteParameterInput) (*DeleteParameterOutput, error) {
	req, out := c.DeleteParameterRequest(input)
	return out, req.Send()
}

// DeleteParameterWithContext is the same as DeleteParameter with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteParameter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DeleteParameterWithContext(ctx aws.Context, input *DeleteParameterInput, opts ...request.Option) (*DeleteParameterOutput, error) {
	req, out := c.DeleteParameterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteParameters = "DeleteParameters"

// DeleteParametersRequest generates a "aws/request.Request" representing the
// client's request for the DeleteParameters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteParameters for more information on using the DeleteParameters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteParametersRequest method.
//    req, resp := client.DeleteParametersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteParameters
func (c *SSM) DeleteParametersRequest(input *DeleteParametersInput) (req *request.Request, output *DeleteParametersOutput) {
	op := &request.Operation{
		Name:       opDeleteParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteParametersInput{}
	}

	output = &DeleteParametersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteParameters API operation for Amazon Simple Systems Manager (SSM).
//
// Delete a list of parameters. This API is used to delete parameters by using
// the Amazon EC2 console.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DeleteParameters for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteParameters
func (c *SSM) DeleteParameters(input *DeleteParametersInput) (*DeleteParametersOutput, error) {
	req, out := c.DeleteParametersRequest(input)
	return out, req.Send()
}

// DeleteParametersWithContext is the same as DeleteParameters with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteParameters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DeleteParametersWithContext(ctx aws.Context, input *DeleteParametersInput, opts ...request.Option) (*DeleteParametersOutput, error) {
	req, out := c.DeleteParametersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePatchBaseline = "DeletePatchBaseline"

// DeletePatchBaselineRequest generates a "aws/request.Request" representing the
// client's request for the DeletePatchBaseline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePatchBaseline for more information on using the DeletePatchBaseline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePatchBaselineRequest method.
//    req, resp := client.DeletePatchBaselineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeletePatchBaseline
func (c *SSM) DeletePatchBaselineRequest(input *DeletePatchBaselineInput) (req *request.Request, output *DeletePatchBaselineOutput) {
	op := &request.Operation{
		Name:       opDeletePatchBaseline,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePatchBaselineInput{}
	}

	output = &DeletePatchBaselineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeletePatchBaseline API operation for Amazon Simple Systems Manager (SSM).
//
// Deletes a patch baseline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DeletePatchBaseline for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   Error returned if an attempt is made to delete a patch baseline that is registered
//   for a patch group.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeletePatchBaseline
func (c *SSM) DeletePatchBaseline(input *DeletePatchBaselineInput) (*DeletePatchBaselineOutput, error) {
	req, out := c.DeletePatchBaselineRequest(input)
	return out, req.Send()
}

// DeletePatchBaselineWithContext is the same as DeletePatchBaseline with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePatchBaseline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DeletePatchBaselineWithContext(ctx aws.Context, input *DeletePatchBaselineInput, opts ...request.Option) (*DeletePatchBaselineOutput, error) {
	req, out := c.DeletePatchBaselineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResourceDataSync = "DeleteResourceDataSync"

// DeleteResourceDataSyncRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResourceDataSync operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResourceDataSync for more information on using the DeleteResourceDataSync
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteResourceDataSyncRequest method.
//    req, resp := client.DeleteResourceDataSyncRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteResourceDataSync
func (c *SSM) DeleteResourceDataSyncRequest(input *DeleteResourceDataSyncInput) (req *request.Request, output *DeleteResourceDataSyncOutput) {
	op := &request.Operation{
		Name:       opDeleteResourceDataSync,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteResourceDataSyncInput{}
	}

	output = &DeleteResourceDataSyncOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteResourceDataSync API operation for Amazon Simple Systems Manager (SSM).
//
// Deletes a Resource Data Sync configuration. After the configuration is deleted,
// changes to inventory data on managed instances are no longer synced with
// the target Amazon S3 bucket. Deleting a sync configuration does not delete
// data in the target Amazon S3 bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DeleteResourceDataSync for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeResourceDataSyncNotFoundException "ResourceDataSyncNotFoundException"
//   The specified sync name was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteResourceDataSync
func (c *SSM) DeleteResourceDataSync(input *DeleteResourceDataSyncInput) (*DeleteResourceDataSyncOutput, error) {
	req, out := c.DeleteResourceDataSyncRequest(input)
	return out, req.Send()
}

// DeleteResourceDataSyncWithContext is the same as DeleteResourceDataSync with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResourceDataSync for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DeleteResourceDataSyncWithContext(ctx aws.Context, input *DeleteResourceDataSyncInput, opts ...request.Option) (*DeleteResourceDataSyncOutput, error) {
	req, out := c.DeleteResourceDataSyncRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterManagedInstance = "DeregisterManagedInstance"

// DeregisterManagedInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterManagedInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterManagedInstance for more information on using the DeregisterManagedInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeregisterManagedInstanceRequest method.
//    req, resp := client.DeregisterManagedInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterManagedInstance
func (c *SSM) DeregisterManagedInstanceRequest(input *DeregisterManagedInstanceInput) (req *request.Request, output *DeregisterManagedInstanceOutput) {
	op := &request.Operation{
		Name:       opDeregisterManagedInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterManagedInstanceInput{}
	}

	output = &DeregisterManagedInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeregisterManagedInstance API operation for Amazon Simple Systems Manager (SSM).
//
// Removes the server or virtual machine from the list of registered servers.
// You can reregister the instance again at any time. If you don't plan to use
// Run Command on the server, we suggest uninstalling SSM Agent first.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DeregisterManagedInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInstanceId "InvalidInstanceId"
//   The following problems can cause this exception:
//
//   You do not have permission to access the instance.
//
//   SSM Agent is not running. On managed instances and Linux instances, verify
//   that the SSM Agent is running. On EC2 Windows instances, verify that the
//   EC2Config service is running.
//
//   SSM Agent or EC2Config service is not registered to the SSM endpoint. Try
//   reinstalling SSM Agent or EC2Config service.
//
//   The instance is not in valid state. Valid states are: Running, Pending, Stopped,
//   Stopping. Invalid states are: Shutting-down and Terminated.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterManagedInstance
func (c *SSM) DeregisterManagedInstance(input *DeregisterManagedInstanceInput) (*DeregisterManagedInstanceOutput, error) {
	req, out := c.DeregisterManagedInstanceRequest(input)
	return out, req.Send()
}

// DeregisterManagedInstanceWithContext is the same as DeregisterManagedInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterManagedInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DeregisterManagedInstanceWithContext(ctx aws.Context, input *DeregisterManagedInstanceInput, opts ...request.Option) (*DeregisterManagedInstanceOutput, error) {
	req, out := c.DeregisterManagedInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterPatchBaselineForPatchGroup = "DeregisterPatchBaselineForPatchGroup"

// DeregisterPatchBaselineForPatchGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterPatchBaselineForPatchGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterPatchBaselineForPatchGroup for more information on using the DeregisterPatchBaselineForPatchGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeregisterPatchBaselineForPatchGroupRequest method.
//    req, resp := client.DeregisterPatchBaselineForPatchGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterPatchBaselineForPatchGroup
func (c *SSM) DeregisterPatchBaselineForPatchGroupRequest(input *DeregisterPatchBaselineForPatchGroupInput) (req *request.Request, output *DeregisterPatchBaselineForPatchGroupOutput) {
	op := &request.Operation{
		Name:       opDeregisterPatchBaselineForPatchGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterPatchBaselineForPatchGroupInput{}
	}

	output = &DeregisterPatchBaselineForPatchGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeregisterPatchBaselineForPatchGroup API operation for Amazon Simple Systems Manager (SSM).
//
// Removes a patch group from a patch baseline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DeregisterPatchBaselineForPatchGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidResourceId "InvalidResourceId"
//   The resource ID is not valid. Verify that you entered the correct ID and
//   try again.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterPatchBaselineForPatchGroup
func (c *SSM) DeregisterPatchBaselineForPatchGroup(input *DeregisterPatchBaselineForPatchGroupInput) (*DeregisterPatchBaselineForPatchGroupOutput, error) {
	req, out := c.DeregisterPatchBaselineForPatchGroupRequest(input)
	return out, req.Send()
}

// DeregisterPatchBaselineForPatchGroupWithContext is the same as DeregisterPatchBaselineForPatchGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterPatchBaselineForPatchGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DeregisterPatchBaselineForPatchGroupWithContext(ctx aws.Context, input *DeregisterPatchBaselineForPatchGroupInput, opts ...request.Option) (*DeregisterPatchBaselineForPatchGroupOutput, error) {
	req, out := c.DeregisterPatchBaselineForPatchGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterTargetFromMaintenanceWindow = "DeregisterTargetFromMaintenanceWindow"

// DeregisterTargetFromMaintenanceWindowRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterTargetFromMaintenanceWindow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterTargetFromMaintenanceWindow for more information on using the DeregisterTargetFromMaintenanceWindow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeregisterTargetFromMaintenanceWindowRequest method.
//    req, resp := client.DeregisterTargetFromMaintenanceWindowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterTargetFromMaintenanceWindow
func (c *SSM) DeregisterTargetFromMaintenanceWindowRequest(input *DeregisterTargetFromMaintenanceWindowInput) (req *request.Request, output *DeregisterTargetFromMaintenanceWindowOutput) {
	op := &request.Operation{
		Name:       opDeregisterTargetFromMaintenanceWindow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterTargetFromMaintenanceWindowInput{}
	}

	output = &DeregisterTargetFromMaintenanceWindowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeregisterTargetFromMaintenanceWindow API operation for Amazon Simple Systems Manager (SSM).
//
// Removes a target from a Maintenance Window.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DeregisterTargetFromMaintenanceWindow for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDoesNotExistException "DoesNotExistException"
//   Error returned when the ID specified for a resource, such as a Maintenance
//   Window or Patch baseline, doesn't exist.
//
//   For information about resource limits in Systems Manager, see AWS Systems
//   Manager Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_ssm).
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeTargetInUseException "TargetInUseException"
//   You specified the Safe option for the DeregisterTargetFromMaintenanceWindow
//   operation, but the target is still referenced in a task.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterTargetFromMaintenanceWindow
func (c *SSM) DeregisterTargetFromMaintenanceWindow(input *DeregisterTargetFromMaintenanceWindowInput) (*DeregisterTargetFromMaintenanceWindowOutput, error) {
	req, out := c.DeregisterTargetFromMaintenanceWindowRequest(input)
	return out, req.Send()
}

// DeregisterTargetFromMaintenanceWindowWithContext is the same as DeregisterTargetFromMaintenanceWindow with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterTargetFromMaintenanceWindow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DeregisterTargetFromMaintenanceWindowWithContext(ctx aws.Context, input *DeregisterTargetFromMaintenanceWindowInput, opts ...request.Option) (*DeregisterTargetFromMaintenanceWindowOutput, error) {
	req, out := c.DeregisterTargetFromMaintenanceWindowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterTaskFromMaintenanceWindow = "DeregisterTaskFromMaintenanceWindow"

// DeregisterTaskFromMaintenanceWindowRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterTaskFromMaintenanceWindow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterTaskFromMaintenanceWindow for more information on using the DeregisterTaskFromMaintenanceWindow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeregisterTaskFromMaintenanceWindowRequest method.
//    req, resp := client.DeregisterTaskFromMaintenanceWindowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterTaskFromMaintenanceWindow
func (c *SSM) DeregisterTaskFromMaintenanceWindowRequest(input *DeregisterTaskFromMaintenanceWindowInput) (req *request.Request, output *DeregisterTaskFromMaintenanceWindowOutput) {
	op := &request.Operation{
		Name:       opDeregisterTaskFromMaintenanceWindow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterTaskFromMaintenanceWindowInput{}
	}

	output = &DeregisterTaskFromMaintenanceWindowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeregisterTaskFromMaintenanceWindow API operation for Amazon Simple Systems Manager (SSM).
//
// Removes a task from a Maintenance Window.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DeregisterTaskFromMaintenanceWindow for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDoesNotExistException "DoesNotExistException"
//   Error returned when the ID specified for a resource, such as a Maintenance
//   Window or Patch baseline, doesn't exist.
//
//   For information about resource limits in Systems Manager, see AWS Systems
//   Manager Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_ssm).
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterTaskFromMaintenanceWindow
func (c *SSM) DeregisterTaskFromMaintenanceWindow(input *DeregisterTaskFromMaintenanceWindowInput) (*DeregisterTaskFromMaintenanceWindowOutput, error) {
	req, out := c.DeregisterTaskFromMaintenanceWindowRequest(input)
	return out, req.Send()
}

// DeregisterTaskFromMaintenanceWindowWithContext is the same as DeregisterTaskFromMaintenanceWindow with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterTaskFromMaintenanceWindow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DeregisterTaskFromMaintenanceWindowWithContext(ctx aws.Context, input *DeregisterTaskFromMaintenanceWindowInput, opts ...request.Option) (*DeregisterTaskFromMaintenanceWindowOutput, error) {
	req, out := c.DeregisterTaskFromMaintenanceWindowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeActivations = "DescribeActivations"

// DescribeActivationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeActivations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeActivations for more information on using the DescribeActivations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeActivationsRequest method.
//    req, resp := client.DescribeActivationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeActivations
func (c *SSM) DescribeActivationsRequest(input *DescribeActivationsInput) (req *request.Request, output *DescribeActivationsOutput) {
	op := &request.Operation{
		Name:       opDescribeActivations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeActivationsInput{}
	}

	output = &DescribeActivationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeActivations API operation for Amazon Simple Systems Manager (SSM).
//
// Details about the activation, including: the date and time the activation
// was created, the expiration date, the IAM role assigned to the instances
// in the activation, and the number of instances activated by this registration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DescribeActivations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidFilter "InvalidFilter"
//   The filter name is not valid. Verify the you entered the correct name and
//   try again.
//
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The specified token is not valid.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeActivations
func (c *SSM) DescribeActivations(input *DescribeActivationsInput) (*DescribeActivationsOutput, error) {
	req, out := c.DescribeActivationsRequest(input)
	return out, req.Send()
}

// DescribeActivationsWithContext is the same as DescribeActivations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeActivations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeActivationsWithContext(ctx aws.Context, input *DescribeActivationsInput, opts ...request.Option) (*DescribeActivationsOutput, error) {
	req, out := c.DescribeActivationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeActivationsPages iterates over the pages of a DescribeActivations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeActivations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeActivations operation.
//    pageNum := 0
//    err := client.DescribeActivationsPages(params,
//        func(page *DescribeActivationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SSM) DescribeActivationsPages(input *DescribeActivationsInput, fn func(*DescribeActivationsOutput, bool) bool) error {
	return c.DescribeActivationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeActivationsPagesWithContext same as DescribeActivationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeActivationsPagesWithContext(ctx aws.Context, input *DescribeActivationsInput, fn func(*DescribeActivationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeActivationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeActivationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeActivationsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeAssociation = "DescribeAssociation"

// DescribeAssociationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAssociation for more information on using the DescribeAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAssociationRequest method.
//    req, resp := client.DescribeAssociationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociation
func (c *SSM) DescribeAssociationRequest(input *DescribeAssociationInput) (req *request.Request, output *DescribeAssociationOutput) {
	op := &request.Operation{
		Name:       opDescribeAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAssociationInput{}
	}

	output = &DescribeAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAssociation API operation for Amazon Simple Systems Manager (SSM).
//
// Describes the association for the specified target or instance. If you created
// the association by using the Targets parameter, then you must retrieve the
// association by using the association ID. If you created the association by
// specifying an instance ID and a Systems Manager document, then you retrieve
// the association by specifying the document name and the instance ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DescribeAssociation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAssociationDoesNotExist "AssociationDoesNotExist"
//   The specified association does not exist.
//
//   * ErrCodeInvalidAssociationVersion "InvalidAssociationVersion"
//   The version you specified is not valid. Use ListAssociationVersions to view
//   all versions of an association according to the association ID. Or, use the
//   $LATEST parameter to view the latest version of the association.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidDocument "InvalidDocument"
//   The specified document does not exist.
//
//   * ErrCodeInvalidInstanceId "InvalidInstanceId"
//   The following problems can cause this exception:
//
//   You do not have permission to access the instance.
//
//   SSM Agent is not running. On managed instances and Linux instances, verify
//   that the SSM Agent is running. On EC2 Windows instances, verify that the
//   EC2Config service is running.
//
//   SSM Agent or EC2Config service is not registered to the SSM endpoint. Try
//   reinstalling SSM Agent or EC2Config service.
//
//   The instance is not in valid state. Valid states are: Running, Pending, Stopped,
//   Stopping. Invalid states are: Shutting-down and Terminated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociation
func (c *SSM) DescribeAssociation(input *DescribeAssociationInput) (*DescribeAssociationOutput, error) {
	req, out := c.DescribeAssociationRequest(input)
	return out, req.Send()
}

// DescribeAssociationWithContext is the same as DescribeAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeAssociationWithContext(ctx aws.Context, input *DescribeAssociationInput, opts ...request.Option) (*DescribeAssociationOutput, error) {
	req, out := c.DescribeAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAssociationExecutionTargets = "DescribeAssociationExecutionTargets"

// DescribeAssociationExecutionTargetsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAssociationExecutionTargets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAssociationExecutionTargets for more information on using the DescribeAssociationExecutionTargets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAssociationExecutionTargetsRequest method.
//    req, resp := client.DescribeAssociationExecutionTargetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociationExecutionTargets
func (c *SSM) DescribeAssociationExecutionTargetsRequest(input *DescribeAssociationExecutionTargetsInput) (req *request.Request, output *DescribeAssociationExecutionTargetsOutput) {
	op := &request.Operation{
		Name:       opDescribeAssociationExecutionTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAssociationExecutionTargetsInput{}
	}

	output = &DescribeAssociationExecutionTargetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAssociationExecutionTargets API operation for Amazon Simple Systems Manager (SSM).
//
// Use this API action to view information about a specific execution of a specific
// association.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DescribeAssociationExecutionTargets for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeAssociationDoesNotExist "AssociationDoesNotExist"
//   The specified association does not exist.
//
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The specified token is not valid.
//
//   * ErrCodeAssociationExecutionDoesNotExist "AssociationExecutionDoesNotExist"
//   The specified execution ID does not exist. Verify the ID number and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociationExecutionTargets
func (c *SSM) DescribeAssociationExecutionTargets(input *DescribeAssociationExecutionTargetsInput) (*DescribeAssociationExecutionTargetsOutput, error) {
	req, out := c.DescribeAssociationExecutionTargetsRequest(input)
	return out, req.Send()
}

// DescribeAssociationExecutionTargetsWithContext is the same as DescribeAssociationExecutionTargets with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAssociationExecutionTargets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeAssociationExecutionTargetsWithContext(ctx aws.Context, input *DescribeAssociationExecutionTargetsInput, opts ...request.Option) (*DescribeAssociationExecutionTargetsOutput, error) {
	req, out := c.DescribeAssociationExecutionTargetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAssociationExecutions = "DescribeAssociationExecutions"

// DescribeAssociationExecutionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAssociationExecutions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAssociationExecutions for more information on using the DescribeAssociationExecutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAssociationExecutionsRequest method.
//    req, resp := client.DescribeAssociationExecutionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociationExecutions
func (c *SSM) DescribeAssociationExecutionsRequest(input *DescribeAssociationExecutionsInput) (req *request.Request, output *DescribeAssociationExecutionsOutput) {
	op := &request.Operation{
		Name:       opDescribeAssociationExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAssociationExecutionsInput{}
	}

	output = &DescribeAssociationExecutionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAssociationExecutions API operation for Amazon Simple Systems Manager (SSM).
//
// Use this API action to view all executions for a specific association ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DescribeAssociationExecutions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeAssociationDoesNotExist "AssociationDoesNotExist"
//   The specified association does not exist.
//
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The specified token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociationExecutions
func (c *SSM) DescribeAssociationExecutions(input *DescribeAssociationExecutionsInput) (*DescribeAssociationExecutionsOutput, error) {
	req, out := c.DescribeAssociationExecutionsRequest(input)
	return out, req.Send()
}

// DescribeAssociationExecutionsWithContext is the same as DescribeAssociationExecutions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAssociationExecutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeAssociationExecutionsWithContext(ctx aws.Context, input *DescribeAssociationExecutionsInput, opts ...request.Option) (*DescribeAssociationExecutionsOutput, error) {
	req, out := c.DescribeAssociationExecutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAutomationExecutions = "DescribeAutomationExecutions"

// DescribeAutomationExecutionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAutomationExecutions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAutomationExecutions for more information on using the DescribeAutomationExecutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAutomationExecutionsRequest method.
//    req, resp := client.DescribeAutomationExecutionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationExecutions
func (c *SSM) DescribeAutomationExecutionsRequest(input *DescribeAutomationExecutionsInput) (req *request.Request, output *DescribeAutomationExecutionsOutput) {
	op := &request.Operation{
		Name:       opDescribeAutomationExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAutomationExecutionsInput{}
	}

	output = &DescribeAutomationExecutionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAutomationExecutions API operation for Amazon Simple Systems Manager (SSM).
//
// Provides details about all active and terminated Automation executions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DescribeAutomationExecutions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidFilterKey "InvalidFilterKey"
//   The specified key is not valid.
//
//   * ErrCodeInvalidFilterValue "InvalidFilterValue"
//   The filter value is not valid. Verify the value and try again.
//
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The specified token is not valid.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationExecutions
func (c *SSM) DescribeAutomationExecutions(input *DescribeAutomationExecutionsInput) (*DescribeAutomationExecutionsOutput, error) {
	req, out := c.DescribeAutomationExecutionsRequest(input)
	return out, req.Send()
}

// DescribeAutomationExecutionsWithContext is the same as DescribeAutomationExecutions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAutomationExecutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeAutomationExecutionsWithContext(ctx aws.Context, input *DescribeAutomationExecutionsInput, opts ...request.Option) (*DescribeAutomationExecutionsOutput, error) {
	req, out := c.DescribeAutomationExecutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAutomationStepExecutions = "DescribeAutomationStepExecutions"

// DescribeAutomationStepExecutionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAutomationStepExecutions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAutomationStepExecutions for more information on using the DescribeAutomationStepExecutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAutomationStepExecutionsRequest method.
//    req, resp := client.DescribeAutomationStepExecutionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationStepExecutions
func (c *SSM) DescribeAutomationStepExecutionsRequest(input *DescribeAutomationStepExecutionsInput) (req *request.Request, output *DescribeAutomationStepExecutionsOutput) {
	op := &request.Operation{
		Name:       opDescribeAutomationStepExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAutomationStepExecutionsInput{}
	}

	output = &DescribeAutomationStepExecutionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAutomationStepExecutions API operation for Amazon Simple Systems Manager (SSM).
//
// Information about all active and terminated step executions in an Automation
// workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DescribeAutomationStepExecutions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAutomationExecutionNotFoundException "AutomationExecutionNotFoundException"
//   There is no automation execution information for the requested automation
//   execution ID.
//
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The specified token is not valid.
//
//   * ErrCodeInvalidFilterKey "InvalidFilterKey"
//   The specified key is not valid.
//
//   * ErrCodeInvalidFilterValue "InvalidFilterValue"
//   The filter value is not valid. Verify the value and try again.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationStepExecutions
func (c *SSM) DescribeAutomationStepExecutions(input *DescribeAutomationStepExecutionsInput) (*DescribeAutomationStepExecutionsOutput, error) {
	req, out := c.DescribeAutomationStepExecutionsRequest(input)
	return out, req.Send()
}

// DescribeAutomationStepExecutionsWithContext is the same as DescribeAutomationStepExecutions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAutomationStepExecutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeAutomationStepExecutionsWithContext(ctx aws.Context, input *DescribeAutomationStepExecutionsInput, opts ...request.Option) (*DescribeAutomationStepExecutionsOutput, error) {
	req, out := c.DescribeAutomationStepExecutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAvailablePatches = "DescribeAvailablePatches"

// DescribeAvailablePatchesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAvailablePatches operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAvailablePatches for more information on using the DescribeAvailablePatches
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAvailablePatchesRequest method.
//    req, resp := client.DescribeAvailablePatchesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAvailablePatches
func (c *SSM) DescribeAvailablePatchesRequest(input *DescribeAvailablePatchesInput) (req *request.Request, output *DescribeAvailablePatchesOutput) {
	op := &request.Operation{
		Name:       opDescribeAvailablePatches,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAvailablePatchesInput{}
	}

	output = &DescribeAvailablePatchesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAvailablePatches API operation for Amazon Simple Systems Manager (SSM).
//
// Lists all patches that could possibly be included in a patch baseline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DescribeAvailablePatches for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAvailablePatches
func (c *SSM) DescribeAvailablePatches(input *DescribeAvailablePatchesInput) (*DescribeAvailablePatchesOutput, error) {
	req, out := c.DescribeAvailablePatchesRequest(input)
	return out, req.Send()
}

// DescribeAvailablePatchesWithContext is the same as DescribeAvailablePatches with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAvailablePatches for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeAvailablePatchesWithContext(ctx aws.Context, input *DescribeAvailablePatchesInput, opts ...request.Option) (*DescribeAvailablePatchesOutput, error) {
	req, out := c.DescribeAvailablePatchesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDocument = "DescribeDocument"

// DescribeDocumentRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDocument operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDocument for more information on using the DescribeDocument
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDocumentRequest method.
//    req, resp := client.DescribeDocumentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeDocument
func (c *SSM) DescribeDocumentRequest(input *DescribeDocumentInput) (req *request.Request, output *DescribeDocumentOutput) {
	op := &request.Operation{
		Name:       opDescribeDocument,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDocumentInput{}
	}

	output = &DescribeDocumentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDocument API operation for Amazon Simple Systems Manager (SSM).
//
// Describes the specified Systems Manager document.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DescribeDocument for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidDocument "InvalidDocument"
//   The specified document does not exist.
//
//   * ErrCodeInvalidDocumentVersion "InvalidDocumentVersion"
//   The document version is not valid or does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeDocument
func (c *SSM) DescribeDocument(input *DescribeDocumentInput) (*DescribeDocumentOutput, error) {
	req, out := c.DescribeDocumentRequest(input)
	return out, req.Send()
}

// DescribeDocumentWithContext is the same as DescribeDocument with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDocument for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeDocumentWithContext(ctx aws.Context, input *DescribeDocumentInput, opts ...request.Option) (*DescribeDocumentOutput, error) {
	req, out := c.DescribeDocumentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDocumentPermission = "DescribeDocumentPermission"

// DescribeDocumentPermissionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDocumentPermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDocumentPermission for more information on using the DescribeDocumentPermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDocumentPermissionRequest method.
//    req, resp := client.DescribeDocumentPermissionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeDocumentPermission
func (c *SSM) DescribeDocumentPermissionRequest(input *DescribeDocumentPermissionInput) (req *request.Request, output *DescribeDocumentPermissionOutput) {
	op := &request.Operation{
		Name:       opDescribeDocumentPermission,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDocumentPermissionInput{}
	}

	output = &DescribeDocumentPermissionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDocumentPermission API operation for Amazon Simple Systems Manager (SSM).
//
// Describes the permissions for a Systems Manager document. If you created
// the document, you are the owner. If a document is shared, it can either be
// shared privately (by specifying a user's AWS account ID) or publicly (All).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DescribeDocumentPermission for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidDocument "InvalidDocument"
//   The specified document does not exist.
//
//   * ErrCodeInvalidPermissionType "InvalidPermissionType"
//   The permission type is not supported. Share is the only supported permission
//   type.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeDocumentPermission
func (c *SSM) DescribeDocumentPermission(input *DescribeDocumentPermissionInput) (*DescribeDocumentPermissionOutput, error) {
	req, out := c.DescribeDocumentPermissionRequest(input)
	return out, req.Send()
}

// DescribeDocumentPermissionWithContext is the same as DescribeDocumentPermission with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDocumentPermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeDocumentPermissionWithContext(ctx aws.Context, input *DescribeDocumentPermissionInput, opts ...request.Option) (*DescribeDocumentPermissionOutput, error) {
	req, out := c.DescribeDocumentPermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEffectiveInstanceAssociations = "DescribeEffectiveInstanceAssociations"

// DescribeEffectiveInstanceAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEffectiveInstanceAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEffectiveInstanceAssociations for more information on using the DescribeEffectiveInstanceAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEffectiveInstanceAssociationsRequest method.
//    req, resp := client.DescribeEffectiveInstanceAssociationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeEffectiveInstanceAssociations
func (c *SSM) DescribeEffectiveInstanceAssociationsRequest(input *DescribeEffectiveInstanceAssociationsInput) (req *request.Request, output *DescribeEffectiveInstanceAssociationsOutput) {
	op := &request.Operation{
		Name:       opDescribeEffectiveInstanceAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEffectiveInstanceAssociationsInput{}
	}

	output = &DescribeEffectiveInstanceAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEffectiveInstanceAssociations API operation for Amazon Simple Systems Manager (SSM).
//
// All associations for the instance(s).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DescribeEffectiveInstanceAssociations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidInstanceId "InvalidInstanceId"
//   The following problems can cause this exception:
//
//   You do not have permission to access the instance.
//
//   SSM Agent is not running. On managed instances and Linux instances, verify
//   that the SSM Agent is running. On EC2 Windows instances, verify that the
//   EC2Config service is running.
//
//   SSM Agent or EC2Config service is not registered to the SSM endpoint. Try
//   reinstalling SSM Agent or EC2Config service.
//
//   The instance is not in valid state. Valid states are: Running, Pending, Stopped,
//   Stopping. Invalid states are: Shutting-down and Terminated.
//
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The specified token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeEffectiveInstanceAssociations
func (c *SSM) DescribeEffectiveInstanceAssociations(input *DescribeEffectiveInstanceAssociationsInput) (*DescribeEffectiveInstanceAssociationsOutput, error) {
	req, out := c.DescribeEffectiveInstanceAssociationsRequest(input)
	return out, req.Send()
}

// DescribeEffectiveInstanceAssociationsWithContext is the same as DescribeEffectiveInstanceAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEffectiveInstanceAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeEffectiveInstanceAssociationsWithContext(ctx aws.Context, input *DescribeEffectiveInstanceAssociationsInput, opts ...request.Option) (*DescribeEffectiveInstanceAssociationsOutput, error) {
	req, out := c.DescribeEffectiveInstanceAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEffectivePatchesForPatchBaseline = "DescribeEffectivePatchesForPatchBaseline"

// DescribeEffectivePatchesForPatchBaselineRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEffectivePatchesForPatchBaseline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEffectivePatchesForPatchBaseline for more information on using the DescribeEffectivePatchesForPatchBaseline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEffectivePatchesForPatchBaselineRequest method.
//    req, resp := client.DescribeEffectivePatchesForPatchBaselineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeEffectivePatchesForPatchBaseline
func (c *SSM) DescribeEffectivePatchesForPatchBaselineRequest(input *DescribeEffectivePatchesForPatchBaselineInput) (req *request.Request, output *DescribeEffectivePatchesForPatchBaselineOutput) {
	op := &request.Operation{
		Name:       opDescribeEffectivePatchesForPatchBaseline,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEffectivePatchesForPatchBaselineInput{}
	}

	output = &DescribeEffectivePatchesForPatchBaselineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEffectivePatchesForPatchBaseline API operation for Amazon Simple Systems Manager (SSM).
//
// Retrieves the current effective patches (the patch and the approval state)
// for the specified patch baseline. Note that this API applies only to Windows
// patch baselines.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DescribeEffectivePatchesForPatchBaseline for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidResourceId "InvalidResourceId"
//   The resource ID is not valid. Verify that you entered the correct ID and
//   try again.
//
//   * ErrCodeDoesNotExistException "DoesNotExistException"
//   Error returned when the ID specified for a resource, such as a Maintenance
//   Window or Patch baseline, doesn't exist.
//
//   For information about resource limits in Systems Manager, see AWS Systems
//   Manager Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_ssm).
//
//   * ErrCodeUnsupportedOperatingSystem "UnsupportedOperatingSystem"
//   The operating systems you specified is not supported, or the operation is
//   not supported for the operating system. Valid operating systems include:
//   Windows, AmazonLinux, RedhatEnterpriseLinux, and Ubuntu.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeEffectivePatchesForPatchBaseline
func (c *SSM) DescribeEffectivePatchesForPatchBaseline(input *DescribeEffectivePatchesForPatchBaselineInput) (*DescribeEffectivePatchesForPatchBaselineOutput, error) {
	req, out := c.DescribeEffectivePatchesForPatchBaselineRequest(input)
	return out, req.Send()
}

// DescribeEffectivePatchesForPatchBaselineWithContext is the same as DescribeEffectivePatchesForPatchBaseline with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEffectivePatchesForPatchBaseline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeEffectivePatchesForPatchBaselineWithContext(ctx aws.Context, input *DescribeEffectivePatchesForPatchBaselineInput, opts ...request.Option) (*DescribeEffectivePatchesForPatchBaselineOutput, error) {
	req, out := c.DescribeEffectivePatchesForPatchBaselineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInstanceAssociationsStatus = "DescribeInstanceAssociationsStatus"

// DescribeInstanceAssociationsStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstanceAssociationsStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInstanceAssociationsStatus for more information on using the DescribeInstanceAssociationsStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeInstanceAssociationsStatusRequest method.
//    req, resp := client.DescribeInstanceAssociationsStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceAssociationsStatus
func (c *SSM) DescribeInstanceAssociationsStatusRequest(input *DescribeInstanceAssociationsStatusInput) (req *request.Request, output *DescribeInstanceAssociationsStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeInstanceAssociationsStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInstanceAssociationsStatusInput{}
	}

	output = &DescribeInstanceAssociationsStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstanceAssociationsStatus API operation for Amazon Simple Systems Manager (SSM).
//
// The status of the associations for the instance(s).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DescribeInstanceAssociationsStatus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidInstanceId "InvalidInstanceId"
//   The following problems can cause this exception:
//
//   You do not have permission to access the instance.
//
//   SSM Agent is not running. On managed instances and Linux instances, verify
//   that the SSM Agent is running. On EC2 Windows instances, verify that the
//   EC2Config service is running.
//
//   SSM Agent or EC2Config service is not registered to the SSM endpoint. Try
//   reinstalling SSM Agent or EC2Config service.
//
//   The instance is not in valid state. Valid states are: Running, Pending, Stopped,
//   Stopping. Invalid states are: Shutting-down and Terminated.
//
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The specified token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceAssociationsStatus
func (c *SSM) DescribeInstanceAssociationsStatus(input *DescribeInstanceAssociationsStatusInput) (*DescribeInstanceAssociationsStatusOutput, error) {
	req, out := c.DescribeInstanceAssociationsStatusRequest(input)
	return out, req.Send()
}

// DescribeInstanceAssociationsStatusWithContext is the same as DescribeInstanceAssociationsStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstanceAssociationsStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeInstanceAssociationsStatusWithContext(ctx aws.Context, input *DescribeInstanceAssociationsStatusInput, opts ...request.Option) (*DescribeInstanceAssociationsStatusOutput, error) {
	req, out := c.DescribeInstanceAssociationsStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInstanceInformation = "DescribeInstanceInformation"

// DescribeInstanceInformationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstanceInformation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInstanceInformation for more information on using the DescribeInstanceInformation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeInstanceInformationRequest method.
//    req, resp := client.DescribeInstanceInformationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceInformation
func (c *SSM) DescribeInstanceInformationRequest(input *DescribeInstanceInformationInput) (req *request.Request, output *DescribeInstanceInformationOutput) {
	op := &request.Operation{
		Name:       opDescribeInstanceInformation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeInstanceInformationInput{}
	}

	output = &DescribeInstanceInformationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstanceInformation API operation for Amazon Simple Systems Manager (SSM).
//
// Describes one or more of your instances. You can use this to get information
// about instances like the operating system platform, the SSM Agent version
// (Linux), status etc. If you specify one or more instance IDs, it returns
// information for those instances. If you do not specify instance IDs, it returns
// information for all your instances. If you specify an instance ID that is
// not valid or an instance that you do not own, you receive an error.
//
// The IamRole field for this API action is the Amazon Identity and Access Management
// (IAM) role assigned to on-premises instances. This call does not return the
// IAM role for Amazon EC2 instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DescribeInstanceInformation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidInstanceId "InvalidInstanceId"
//   The following problems can cause this exception:
//
//   You do not have permission to access the instance.
//
//   SSM Agent is not running. On managed instances and Linux instances, verify
//   that the SSM Agent is running. On EC2 Windows instances, verify that the
//   EC2Config service is running.
//
//   SSM Agent or EC2Config service is not registered to the SSM endpoint. Try
//   reinstalling SSM Agent or EC2Config service.
//
//   The instance is not in valid state. Valid states are: Running, Pending, Stopped,
//   Stopping. Invalid states are: Shutting-down and Terminated.
//
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The specified token is not valid.
//
//   * ErrCodeInvalidInstanceInformationFilterValue "InvalidInstanceInformationFilterValue"
//   The specified filter value is not valid.
//
//   * ErrCodeInvalidFilterKey "InvalidFilterKey"
//   The specified key is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceInformation
func (c *SSM) DescribeInstanceInformation(input *DescribeInstanceInformationInput) (*DescribeInstanceInformationOutput, error) {
	req, out := c.DescribeInstanceInformationRequest(input)
	return out, req.Send()
}

// DescribeInstanceInformationWithContext is the same as DescribeInstanceInformation with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstanceInformation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeInstanceInformationWithContext(ctx aws.Context, input *DescribeInstanceInformationInput, opts ...request.Option) (*DescribeInstanceInformationOutput, error) {
	req, out := c.DescribeInstanceInformationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeInstanceInformationPages iterates over the pages of a DescribeInstanceInformation operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeInstanceInformation method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeInstanceInformation operation.
//    pageNum := 0
//    err := client.DescribeInstanceInformationPages(params,
//        func(page *DescribeInstanceInformationOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SSM) DescribeInstanceInformationPages(input *DescribeInstanceInformationInput, fn func(*DescribeInstanceInformationOutput, bool) bool) error {
	return c.DescribeInstanceInformationPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeInstanceInformationPagesWithContext same as DescribeInstanceInformationPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeInstanceInformationPagesWithContext(ctx aws.Context, input *DescribeInstanceInformationInput, fn func(*DescribeInstanceInformationOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeInstanceInformationInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeInstanceInformationRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeInstanceInformationOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeInstancePatchStates = "DescribeInstancePatchStates"

// DescribeInstancePatchStatesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstancePatchStates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInstancePatchStates for more information on using the DescribeInstancePatchStates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeInstancePatchStatesRequest method.
//    req, resp := client.DescribeInstancePatchStatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatchStates
func (c *SSM) DescribeInstancePatchStatesRequest(input *DescribeInstancePatchStatesInput) (req *request.Request, output *DescribeInstancePatchStatesOutput) {
	op := &request.Operation{
		Name:       opDescribeInstancePatchStates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInstancePatchStatesInput{}
	}

	output = &DescribeInstancePatchStatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstancePatchStates API operation for Amazon Simple Systems Manager (SSM).
//
// Retrieves the high-level patch state of one or more instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DescribeInstancePatchStates for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The specified token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatchStates
func (c *SSM) DescribeInstancePatchStates(input *DescribeInstancePatchStatesInput) (*DescribeInstancePatchStatesOutput, error) {
	req, out := c.DescribeInstancePatchStatesRequest(input)
	return out, req.Send()
}

// DescribeInstancePatchStatesWithContext is the same as DescribeInstancePatchStates with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstancePatchStates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeInstancePatchStatesWithContext(ctx aws.Context, input *DescribeInstancePatchStatesInput, opts ...request.Option) (*DescribeInstancePatchStatesOutput, error) {
	req, out := c.DescribeInstancePatchStatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInstancePatchStatesForPatchGroup = "DescribeInstancePatchStatesForPatchGroup"

// DescribeInstancePatchStatesForPatchGroupRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstancePatchStatesForPatchGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInstancePatchStatesForPatchGroup for more information on using the DescribeInstancePatchStatesForPatchGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeInstancePatchStatesForPatchGroupRequest method.
//    req, resp := client.DescribeInstancePatchStatesForPatchGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatchStatesForPatchGroup
func (c *SSM) DescribeInstancePatchStatesForPatchGroupRequest(input *DescribeInstancePatchStatesForPatchGroupInput) (req *request.Request, output *DescribeInstancePatchStatesForPatchGroupOutput) {
	op := &request.Operation{
		Name:       opDescribeInstancePatchStatesForPatchGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInstancePatchStatesForPatchGroupInput{}
	}

	output = &DescribeInstancePatchStatesForPatchGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstancePatchStatesForPatchGroup API operation for Amazon Simple Systems Manager (SSM).
//
// Retrieves the high-level patch state for the instances in the specified patch
// group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DescribeInstancePatchStatesForPatchGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidFilter "InvalidFilter"
//   The filter name is not valid. Verify the you entered the correct name and
//   try again.
//
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The specified token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatchStatesForPatchGroup
func (c *SSM) DescribeInstancePatchStatesForPatchGroup(input *DescribeInstancePatchStatesForPatchGroupInput) (*DescribeInstancePatchStatesForPatchGroupOutput, error) {
	req, out := c.DescribeInstancePatchStatesForPatchGroupRequest(input)
	return out, req.Send()
}

// DescribeInstancePatchStatesForPatchGroupWithContext is the same as DescribeInstancePatchStatesForPatchGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstancePatchStatesForPatchGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeInstancePatchStatesForPatchGroupWithContext(ctx aws.Context, input *DescribeInstancePatchStatesForPatchGroupInput, opts ...request.Option) (*DescribeInstancePatchStatesForPatchGroupOutput, error) {
	req, out := c.DescribeInstancePatchStatesForPatchGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInstancePatches = "DescribeInstancePatches"

// DescribeInstancePatchesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstancePatches operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInstancePatches for more information on using the DescribeInstancePatches
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeInstancePatchesRequest method.
//    req, resp := client.DescribeInstancePatchesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatches
func (c *SSM) DescribeInstancePatchesRequest(input *DescribeInstancePatchesInput) (req *request.Request, output *DescribeInstancePatchesOutput) {
	op := &request.Operation{
		Name:       opDescribeInstancePatches,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInstancePatchesInput{}
	}

	output = &DescribeInstancePatchesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstancePatches API operation for Amazon Simple Systems Manager (SSM).
//
// Retrieves information about the patches on the specified instance and their
// state relative to the patch baseline being used for the instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DescribeInstancePatches for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidInstanceId "InvalidInstanceId"
//   The following problems can cause this exception:
//
//   You do not have permission to access the instance.
//
//   SSM Agent is not running. On managed instances and Linux instances, verify
//   that the SSM Agent is running. On EC2 Windows instances, verify that the
//   EC2Config service is running.
//
//   SSM Agent or EC2Config service is not registered to the SSM endpoint. Try
//   reinstalling SSM Agent or EC2Config service.
//
//   The instance is not in valid state. Valid states are: Running, Pending, Stopped,
//   Stopping. Invalid states are: Shutting-down and Terminated.
//
//   * ErrCodeInvalidFilter "InvalidFilter"
//   The filter name is not valid. Verify the you entered the correct name and
//   try again.
//
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The specified token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatches
func (c *SSM) DescribeInstancePatches(input *DescribeInstancePatchesInput) (*DescribeInstancePatchesOutput, error) {
	req, out := c.DescribeInstancePatchesRequest(input)
	return out, req.Send()
}

// DescribeInstancePatchesWithContext is the same as DescribeInstancePatches with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstancePatches for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeInstancePatchesWithContext(ctx aws.Context, input *DescribeInstancePatchesInput, opts ...request.Option) (*DescribeInstancePatchesOutput, error) {
	req, out := c.DescribeInstancePatchesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInventoryDeletions = "DescribeInventoryDeletions"

// DescribeInventoryDeletionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInventoryDeletions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInventoryDeletions for more information on using the DescribeInventoryDeletions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeInventoryDeletionsRequest method.
//    req, resp := client.DescribeInventoryDeletionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInventoryDeletions
func (c *SSM) DescribeInventoryDeletionsRequest(input *DescribeInventoryDeletionsInput) (req *request.Request, output *DescribeInventoryDeletionsOutput) {
	op := &request.Operation{
		Name:       opDescribeInventoryDeletions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInventoryDeletionsInput{}
	}

	output = &DescribeInventoryDeletionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInventoryDeletions API operation for Amazon Simple Systems Manager (SSM).
//
// Describes a specific delete inventory operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DescribeInventoryDeletions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidDeletionIdException "InvalidDeletionIdException"
//   The ID specified for the delete operation does not exist or is not valide.
//   Verify the ID and try again.
//
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The specified token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInventoryDeletions
func (c *SSM) DescribeInventoryDeletions(input *DescribeInventoryDeletionsInput) (*DescribeInventoryDeletionsOutput, error) {
	req, out := c.DescribeInventoryDeletionsRequest(input)
	return out, req.Send()
}

// DescribeInventoryDeletionsWithContext is the same as DescribeInventoryDeletions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInventoryDeletions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeInventoryDeletionsWithContext(ctx aws.Context, input *DescribeInventoryDeletionsInput, opts ...request.Option) (*DescribeInventoryDeletionsOutput, error) {
	req, out := c.DescribeInventoryDeletionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeMaintenanceWindowExecutionTaskInvocations = "DescribeMaintenanceWindowExecutionTaskInvocations"

// DescribeMaintenanceWindowExecutionTaskInvocationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMaintenanceWindowExecutionTaskInvocations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMaintenanceWindowExecutionTaskInvocations for more information on using the DescribeMaintenanceWindowExecutionTaskInvocations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeMaintenanceWindowExecutionTaskInvocationsRequest method.
//    req, resp := client.DescribeMaintenanceWindowExecutionTaskInvocationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTaskInvocations
func (c *SSM) DescribeMaintenanceWindowExecutionTaskInvocationsRequest(input *DescribeMaintenanceWindowExecutionTaskInvocationsInput) (req *request.Request, output *DescribeMaintenanceWindowExecutionTaskInvocationsOutput) {
	op := &request.Operation{
		Name:       opDescribeMaintenanceWindowExecutionTaskInvocations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeMaintenanceWindowExecutionTaskInvocationsInput{}
	}

	output = &DescribeMaintenanceWindowExecutionTaskInvocationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMaintenanceWindowExecutionTaskInvocations API operation for Amazon Simple Systems Manager (SSM).
//
// Retrieves the individual task executions (one per target) for a particular
// task executed as part of a Maintenance Window execution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DescribeMaintenanceWindowExecutionTaskInvocations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDoesNotExistException "DoesNotExistException"
//   Error returned when the ID specified for a resource, such as a Maintenance
//   Window or Patch baseline, doesn't exist.
//
//   For information about resource limits in Systems Manager, see AWS Systems
//   Manager Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_ssm).
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTaskInvocations
func (c *SSM) DescribeMaintenanceWindowExecutionTaskInvocations(input *DescribeMaintenanceWindowExecutionTaskInvocationsInput) (*DescribeMaintenanceWindowExecutionTaskInvocationsOutput, error) {
	req, out := c.DescribeMaintenanceWindowExecutionTaskInvocationsRequest(input)
	return out, req.Send()
}

// DescribeMaintenanceWindowExecutionTaskInvocationsWithContext is the same as DescribeMaintenanceWindowExecutionTaskInvocations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMaintenanceWindowExecutionTaskInvocations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeMaintenanceWindowExecutionTaskInvocationsWithContext(ctx aws.Context, input *DescribeMaintenanceWindowExecutionTaskInvocationsInput, opts ...request.Option) (*DescribeMaintenanceWindowExecutionTaskInvocationsOutput, error) {
	req, out := c.DescribeMaintenanceWindowExecutionTaskInvocationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeMaintenanceWindowExecutionTasks = "DescribeMaintenanceWindowExecutionTasks"

// DescribeMaintenanceWindowExecutionTasksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMaintenanceWindowExecutionTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMaintenanceWindowExecutionTasks for more information on using the DescribeMaintenanceWindowExecutionTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeMaintenanceWindowExecutionTasksRequest method.
//    req, resp := client.DescribeMaintenanceWindowExecutionTasksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTasks
func (c *SSM) DescribeMaintenanceWindowExecutionTasksRequest(input *DescribeMaintenanceWindowExecutionTasksInput) (req *request.Request, output *DescribeMaintenanceWindowExecutionTasksOutput) {
	op := &request.Operation{
		Name:       opDescribeMaintenanceWindowExecutionTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeMaintenanceWindowExecutionTasksInput{}
	}

	output = &DescribeMaintenanceWindowExecutionTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMaintenanceWindowExecutionTasks API operation for Amazon Simple Systems Manager (SSM).
//
// For a given Maintenance Window execution, lists the tasks that were executed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DescribeMaintenanceWindowExecutionTasks for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDoesNotExistException "DoesNotExistException"
//   Error returned when the ID specified for a resource, such as a Maintenance
//   Window or Patch baseline, doesn't exist.
//
//   For information about resource limits in Systems Manager, see AWS Systems
//   Manager Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_ssm).
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTasks
func (c *SSM) DescribeMaintenanceWindowExecutionTasks(input *DescribeMaintenanceWindowExecutionTasksInput) (*DescribeMaintenanceWindowExecutionTasksOutput, error) {
	req, out := c.DescribeMaintenanceWindowExecutionTasksRequest(input)
	return out, req.Send()
}

// DescribeMaintenanceWindowExecutionTasksWithContext is the same as DescribeMaintenanceWindowExecutionTasks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMaintenanceWindowExecutionTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeMaintenanceWindowExecutionTasksWithContext(ctx aws.Context, input *DescribeMaintenanceWindowExecutionTasksInput, opts ...request.Option) (*DescribeMaintenanceWindowExecutionTasksOutput, error) {
	req, out := c.DescribeMaintenanceWindowExecutionTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeMaintenanceWindowExecutions = "DescribeMaintenanceWindowExecutions"

// DescribeMaintenanceWindowExecutionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMaintenanceWindowExecutions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMaintenanceWindowExecutions for more information on using the DescribeMaintenanceWindowExecutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeMaintenanceWindowExecutionsRequest method.
//    req, resp := client.DescribeMaintenanceWindowExecutionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutions
func (c *SSM) DescribeMaintenanceWindowExecutionsRequest(input *DescribeMaintenanceWindowExecutionsInput) (req *request.Request, output *DescribeMaintenanceWindowExecutionsOutput) {
	op := &request.Operation{
		Name:       opDescribeMaintenanceWindowExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeMaintenanceWindowExecutionsInput{}
	}

	output = &DescribeMaintenanceWindowExecutionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMaintenanceWindowExecutions API operation for Amazon Simple Systems Manager (SSM).
//
// Lists the executions of a Maintenance Window. This includes information about
// when the Maintenance Window was scheduled to be active, and information about
// tasks registered and run with the Maintenance Window.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DescribeMaintenanceWindowExecutions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutions
func (c *SSM) DescribeMaintenanceWindowExecutions(input *DescribeMaintenanceWindowExecutionsInput) (*DescribeMaintenanceWindowExecutionsOutput, error) {
	req, out := c.DescribeMaintenanceWindowExecutionsRequest(input)
	return out, req.Send()
}

// DescribeMaintenanceWindowExecutionsWithContext is the same as DescribeMaintenanceWindowExecutions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMaintenanceWindowExecutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeMaintenanceWindowExecutionsWithContext(ctx aws.Context, input *DescribeMaintenanceWindowExecutionsInput, opts ...request.Option) (*DescribeMaintenanceWindowExecutionsOutput, error) {
	req, out := c.DescribeMaintenanceWindowExecutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeMaintenanceWindowSchedule = "DescribeMaintenanceWindowSchedule"

// DescribeMaintenanceWindowScheduleRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMaintenanceWindowSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMaintenanceWindowSchedule for more information on using the DescribeMaintenanceWindowSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeMaintenanceWindowScheduleRequest method.
//    req, resp := client.DescribeMaintenanceWindowScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowSchedule
func (c *SSM) DescribeMaintenanceWindowScheduleRequest(input *DescribeMaintenanceWindowScheduleInput) (req *request.Request, output *DescribeMaintenanceWindowScheduleOutput) {
	op := &request.Operation{
		Name:       opDescribeMaintenanceWindowSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeMaintenanceWindowScheduleInput{}
	}

	output = &DescribeMaintenanceWindowScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMaintenanceWindowSchedule API operation for Amazon Simple Systems Manager (SSM).
//
// Retrieves information about upcoming executions of a Maintenance Window.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DescribeMaintenanceWindowSchedule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeDoesNotExistException "DoesNotExistException"
//   Error returned when the ID specified for a resource, such as a Maintenance
//   Window or Patch baseline, doesn't exist.
//
//   For information about resource limits in Systems Manager, see AWS Systems
//   Manager Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_ssm).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowSchedule
func (c *SSM) DescribeMaintenanceWindowSchedule(input *DescribeMaintenanceWindowScheduleInput) (*DescribeMaintenanceWindowScheduleOutput, error) {
	req, out := c.DescribeMaintenanceWindowScheduleRequest(input)
	return out, req.Send()
}

// DescribeMaintenanceWindowScheduleWithContext is the same as DescribeMaintenanceWindowSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMaintenanceWindowSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeMaintenanceWindowScheduleWithContext(ctx aws.Context, input *DescribeMaintenanceWindowScheduleInput, opts ...request.Option) (*DescribeMaintenanceWindowScheduleOutput, error) {
	req, out := c.DescribeMaintenanceWindowScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeMaintenanceWindowTargets = "DescribeMaintenanceWindowTargets"

// DescribeMaintenanceWindowTargetsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMaintenanceWindowTargets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMaintenanceWindowTargets for more information on using the DescribeMaintenanceWindowTargets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeMaintenanceWindowTargetsRequest method.
//    req, resp := client.DescribeMaintenanceWindowTargetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTargets
func (c *SSM) DescribeMaintenanceWindowTargetsRequest(input *DescribeMaintenanceWindowTargetsInput) (req *request.Request, output *DescribeMaintenanceWindowTargetsOutput) {
	op := &request.Operation{
		Name:       opDescribeMaintenanceWindowTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeMaintenanceWindowTargetsInput{}
	}

	output = &DescribeMaintenanceWindowTargetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMaintenanceWindowTargets API operation for Amazon Simple Systems Manager (SSM).
//
// Lists the targets registered with the Maintenance Window.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DescribeMaintenanceWindowTargets for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDoesNotExistException "DoesNotExistException"
//   Error returned when the ID specified for a resource, such as a Maintenance
//   Window or Patch baseline, doesn't exist.
//
//   For information about resource limits in Systems Manager, see AWS Systems
//   Manager Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_ssm).
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTargets
func (c *SSM) DescribeMaintenanceWindowTargets(input *DescribeMaintenanceWindowTargetsInput) (*DescribeMaintenanceWindowTargetsOutput, error) {
	req, out := c.DescribeMaintenanceWindowTargetsRequest(input)
	return out, req.Send()
}

// DescribeMaintenanceWindowTargetsWithContext is the same as DescribeMaintenanceWindowTargets with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMaintenanceWindowTargets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeMaintenanceWindowTargetsWithContext(ctx aws.Context, input *DescribeMaintenanceWindowTargetsInput, opts ...request.Option) (*DescribeMaintenanceWindowTargetsOutput, error) {
	req, out := c.DescribeMaintenanceWindowTargetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeMaintenanceWindowTasks = "DescribeMaintenanceWindowTasks"

// DescribeMaintenanceWindowTasksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMaintenanceWindowTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMaintenanceWindowTasks for more information on using the DescribeMaintenanceWindowTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeMaintenanceWindowTasksRequest method.
//    req, resp := client.DescribeMaintenanceWindowTasksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTasks
func (c *SSM) DescribeMaintenanceWindowTasksRequest(input *DescribeMaintenanceWindowTasksInput) (req *request.Request, output *DescribeMaintenanceWindowTasksOutput) {
	op := &request.Operation{
		Name:       opDescribeMaintenanceWindowTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeMaintenanceWindowTasksInput{}
	}

	output = &DescribeMaintenanceWindowTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMaintenanceWindowTasks API operation for Amazon Simple Systems Manager (SSM).
//
// Lists the tasks in a Maintenance Window.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DescribeMaintenanceWindowTasks for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDoesNotExistException "DoesNotExistException"
//   Error returned when the ID specified for a resource, such as a Maintenance
//   Window or Patch baseline, doesn't exist.
//
//   For information about resource limits in Systems Manager, see AWS Systems
//   Manager Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_ssm).
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTasks
func (c *SSM) DescribeMaintenanceWindowTasks(input *DescribeMaintenanceWindowTasksInput) (*DescribeMaintenanceWindowTasksOutput, error) {
	req, out := c.DescribeMaintenanceWindowTasksRequest(input)
	return out, req.Send()
}

// DescribeMaintenanceWindowTasksWithContext is the same as DescribeMaintenanceWindowTasks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMaintenanceWindowTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeMaintenanceWindowTasksWithContext(ctx aws.Context, input *DescribeMaintenanceWindowTasksInput, opts ...request.Option) (*DescribeMaintenanceWindowTasksOutput, error) {
	req, out := c.DescribeMaintenanceWindowTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeMaintenanceWindows = "DescribeMaintenanceWindows"

// DescribeMaintenanceWindowsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMaintenanceWindows operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMaintenanceWindows for more information on using the DescribeMaintenanceWindows
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeMaintenanceWindowsRequest method.
//    req, resp := client.DescribeMaintenanceWindowsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindows
func (c *SSM) DescribeMaintenanceWindowsRequest(input *DescribeMaintenanceWindowsInput) (req *request.Request, output *DescribeMaintenanceWindowsOutput) {
	op := &request.Operation{
		Name:       opDescribeMaintenanceWindows,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeMaintenanceWindowsInput{}
	}

	output = &DescribeMaintenanceWindowsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMaintenanceWindows API operation for Amazon Simple Systems Manager (SSM).
//
// Retrieves the Maintenance Windows in an AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DescribeMaintenanceWindows for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindows
func (c *SSM) DescribeMaintenanceWindows(input *DescribeMaintenanceWindowsInput) (*DescribeMaintenanceWindowsOutput, error) {
	req, out := c.DescribeMaintenanceWindowsRequest(input)
	return out, req.Send()
}

// DescribeMaintenanceWindowsWithContext is the same as DescribeMaintenanceWindows with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMaintenanceWindows for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeMaintenanceWindowsWithContext(ctx aws.Context, input *DescribeMaintenanceWindowsInput, opts ...request.Option) (*DescribeMaintenanceWindowsOutput, error) {
	req, out := c.DescribeMaintenanceWindowsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeMaintenanceWindowsForTarget = "DescribeMaintenanceWindowsForTarget"

// DescribeMaintenanceWindowsForTargetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMaintenanceWindowsForTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMaintenanceWindowsForTarget for more information on using the DescribeMaintenanceWindowsForTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeMaintenanceWindowsForTargetRequest method.
//    req, resp := client.DescribeMaintenanceWindowsForTargetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowsForTarget
func (c *SSM) DescribeMaintenanceWindowsForTargetRequest(input *DescribeMaintenanceWindowsForTargetInput) (req *request.Request, output *DescribeMaintenanceWindowsForTargetOutput) {
	op := &request.Operation{
		Name:       opDescribeMaintenanceWindowsForTarget,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeMaintenanceWindowsForTargetInput{}
	}

	output = &DescribeMaintenanceWindowsForTargetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMaintenanceWindowsForTarget API operation for Amazon Simple Systems Manager (SSM).
//
// Retrieves information about the Maintenance Windows targets or tasks that
// an instance is associated with.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DescribeMaintenanceWindowsForTarget for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowsForTarget
func (c *SSM) DescribeMaintenanceWindowsForTarget(input *DescribeMaintenanceWindowsForTargetInput) (*DescribeMaintenanceWindowsForTargetOutput, error) {
	req, out := c.DescribeMaintenanceWindowsForTargetRequest(input)
	return out, req.Send()
}

// DescribeMaintenanceWindowsForTargetWithContext is the same as DescribeMaintenanceWindowsForTarget with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMaintenanceWindowsForTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeMaintenanceWindowsForTargetWithContext(ctx aws.Context, input *DescribeMaintenanceWindowsForTargetInput, opts ...request.Option) (*DescribeMaintenanceWindowsForTargetOutput, error) {
	req, out := c.DescribeMaintenanceWindowsForTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeParameters = "DescribeParameters"

// DescribeParametersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeParameters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeParameters for more information on using the DescribeParameters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeParametersRequest method.
//    req, resp := client.DescribeParametersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeParameters
func (c *SSM) DescribeParametersRequest(input *DescribeParametersInput) (req *request.Request, output *DescribeParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeParametersInput{}
	}

	output = &DescribeParametersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeParameters API operation for Amazon Simple Systems Manager (SSM).
//
// Get information about a parameter.
//
// Request results are returned on a best-effort basis. If you specify MaxResults
// in the request, the response includes information up to the limit specified.
// The number of items returned, however, can be between zero and the value
// of MaxResults. If the service reaches an internal limit while processing
// the results, it stops the operation and returns the matching values up to
// that point and a NextToken. You can specify the NextToken in a subsequent
// call to get the next set of results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DescribeParameters for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidFilterKey "InvalidFilterKey"
//   The specified key is not valid.
//
//   * ErrCodeInvalidFilterOption "InvalidFilterOption"
//   The specified filter option is not valid. Valid options are Equals and BeginsWith.
//   For Path filter, valid options are Recursive and OneLevel.
//
//   * ErrCodeInvalidFilterValue "InvalidFilterValue"
//   The filter value is not valid. Verify the value and try again.
//
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The specified token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeParameters
func (c *SSM) DescribeParameters(input *DescribeParametersInput) (*DescribeParametersOutput, error) {
	req, out := c.DescribeParametersRequest(input)
	return out, req.Send()
}

// DescribeParametersWithContext is the same as DescribeParameters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeParameters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeParametersWithContext(ctx aws.Context, input *DescribeParametersInput, opts ...request.Option) (*DescribeParametersOutput, error) {
	req, out := c.DescribeParametersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeParametersPages iterates over the pages of a DescribeParameters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeParameters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeParameters operation.
//    pageNum := 0
//    err := client.DescribeParametersPages(params,
//        func(page *DescribeParametersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SSM) DescribeParametersPages(input *DescribeParametersInput, fn func(*DescribeParametersOutput, bool) bool) error {
	return c.DescribeParametersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeParametersPagesWithContext same as DescribeParametersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeParametersPagesWithContext(ctx aws.Context, input *DescribeParametersInput, fn func(*DescribeParametersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeParametersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeParametersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeParametersOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribePatchBaselines = "DescribePatchBaselines"

// DescribePatchBaselinesRequest generates a "aws/request.Request" representing the
// client's request for the DescribePatchBaselines operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePatchBaselines for more information on using the DescribePatchBaselines
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePatchBaselinesRequest method.
//    req, resp := client.DescribePatchBaselinesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchBaselines
func (c *SSM) DescribePatchBaselinesRequest(input *DescribePatchBaselinesInput) (req *request.Request, output *DescribePatchBaselinesOutput) {
	op := &request.Operation{
		Name:       opDescribePatchBaselines,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePatchBaselinesInput{}
	}

	output = &DescribePatchBaselinesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePatchBaselines API operation for Amazon Simple Systems Manager (SSM).
//
// Lists the patch baselines in your AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DescribePatchBaselines for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchBaselines
func (c *SSM) DescribePatchBaselines(input *DescribePatchBaselinesInput) (*DescribePatchBaselinesOutput, error) {
	req, out := c.DescribePatchBaselinesRequest(input)
	return out, req.Send()
}

// DescribePatchBaselinesWithContext is the same as DescribePatchBaselines with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePatchBaselines for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribePatchBaselinesWithContext(ctx aws.Context, input *DescribePatchBaselinesInput, opts ...request.Option) (*DescribePatchBaselinesOutput, error) {
	req, out := c.DescribePatchBaselinesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePatchGroupState = "DescribePatchGroupState"

// DescribePatchGroupStateRequest generates a "aws/request.Request" representing the
// client's request for the DescribePatchGroupState operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePatchGroupState for more information on using the DescribePatchGroupState
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePatchGroupStateRequest method.
//    req, resp := client.DescribePatchGroupStateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchGroupState
func (c *SSM) DescribePatchGroupStateRequest(input *DescribePatchGroupStateInput) (req *request.Request, output *DescribePatchGroupStateOutput) {
	op := &request.Operation{
		Name:       opDescribePatchGroupState,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePatchGroupStateInput{}
	}

	output = &DescribePatchGroupStateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePatchGroupState API operation for Amazon Simple Systems Manager (SSM).
//
// Returns high-level aggregated patch compliance state for a patch group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DescribePatchGroupState for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The specified token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchGroupState
func (c *SSM) DescribePatchGroupState(input *DescribePatchGroupStateInput) (*DescribePatchGroupStateOutput, error) {
	req, out := c.DescribePatchGroupStateRequest(input)
	return out, req.Send()
}

// DescribePatchGroupStateWithContext is the same as DescribePatchGroupState with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePatchGroupState for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribePatchGroupStateWithContext(ctx aws.Context, input *DescribePatchGroupStateInput, opts ...request.Option) (*DescribePatchGroupStateOutput, error) {
	req, out := c.DescribePatchGroupStateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePatchGroups = "DescribePatchGroups"

// DescribePatchGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribePatchGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePatchGroups for more information on using the DescribePatchGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePatchGroupsRequest method.
//    req, resp := client.DescribePatchGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchGroups
func (c *SSM) DescribePatchGroupsRequest(input *DescribePatchGroupsInput) (req *request.Request, output *DescribePatchGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribePatchGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePatchGroupsInput{}
	}

	output = &DescribePatchGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePatchGroups API operation for Amazon Simple Systems Manager (SSM).
//
// Lists all patch groups that have been registered with patch baselines.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DescribePatchGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchGroups
func (c *SSM) DescribePatchGroups(input *DescribePatchGroupsInput) (*DescribePatchGroupsOutput, error) {
	req, out := c.DescribePatchGroupsRequest(input)
	return out, req.Send()
}

// DescribePatchGroupsWithContext is the same as DescribePatchGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePatchGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribePatchGroupsWithContext(ctx aws.Context, input *DescribePatchGroupsInput, opts ...request.Option) (*DescribePatchGroupsOutput, error) {
	req, out := c.DescribePatchGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSessions = "DescribeSessions"

// DescribeSessionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSessions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSessions for more information on using the DescribeSessions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSessionsRequest method.
//    req, resp := client.DescribeSessionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeSessions
func (c *SSM) DescribeSessionsRequest(input *DescribeSessionsInput) (req *request.Request, output *DescribeSessionsOutput) {
	op := &request.Operation{
		Name:       opDescribeSessions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSessionsInput{}
	}

	output = &DescribeSessionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSessions API operation for Amazon Simple Systems Manager (SSM).
//
// Retrieves a list of all active sessions (both connected and disconnected)
// or terminated sessions from the past 30 days.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation DescribeSessions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidFilterKey "InvalidFilterKey"
//   The specified key is not valid.
//
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The specified token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeSessions
func (c *SSM) DescribeSessions(input *DescribeSessionsInput) (*DescribeSessionsOutput, error) {
	req, out := c.DescribeSessionsRequest(input)
	return out, req.Send()
}

// DescribeSessionsWithContext is the same as DescribeSessions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSessions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) DescribeSessionsWithContext(ctx aws.Context, input *DescribeSessionsInput, opts ...request.Option) (*DescribeSessionsOutput, error) {
	req, out := c.DescribeSessionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAutomationExecution = "GetAutomationExecution"

// GetAutomationExecutionRequest generates a "aws/request.Request" representing the
// client's request for the GetAutomationExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAutomationExecution for more information on using the GetAutomationExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAutomationExecutionRequest method.
//    req, resp := client.GetAutomationExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetAutomationExecution
func (c *SSM) GetAutomationExecutionRequest(input *GetAutomationExecutionInput) (req *request.Request, output *GetAutomationExecutionOutput) {
	op := &request.Operation{
		Name:       opGetAutomationExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAutomationExecutionInput{}
	}

	output = &GetAutomationExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAutomationExecution API operation for Amazon Simple Systems Manager (SSM).
//
// Get detailed information about a particular Automation execution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation GetAutomationExecution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAutomationExecutionNotFoundException "AutomationExecutionNotFoundException"
//   There is no automation execution information for the requested automation
//   execution ID.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetAutomationExecution
func (c *SSM) GetAutomationExecution(input *GetAutomationExecutionInput) (*GetAutomationExecutionOutput, error) {
	req, out := c.GetAutomationExecutionRequest(input)
	return out, req.Send()
}

// GetAutomationExecutionWithContext is the same as GetAutomationExecution with the addition of
// the ability to pass a context and additional request options.
//
// See GetAutomationExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetAutomationExecutionWithContext(ctx aws.Context, input *GetAutomationExecutionInput, opts ...request.Option) (*GetAutomationExecutionOutput, error) {
	req, out := c.GetAutomationExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCommandInvocation = "GetCommandInvocation"

// GetCommandInvocationRequest generates a "aws/request.Request" representing the
// client's request for the GetCommandInvocation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCommandInvocation for more information on using the GetCommandInvocation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCommandInvocationRequest method.
//    req, resp := client.GetCommandInvocationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetCommandInvocation
func (c *SSM) GetCommandInvocationRequest(input *GetCommandInvocationInput) (req *request.Request, output *GetCommandInvocationOutput) {
	op := &request.Operation{
		Name:       opGetCommandInvocation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCommandInvocationInput{}
	}

	output = &GetCommandInvocationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCommandInvocation API operation for Amazon Simple Systems Manager (SSM).
//
// Returns detailed information about command execution for an invocation or
// plugin.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation GetCommandInvocation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidCommandId "InvalidCommandId"
//
//   * ErrCodeInvalidInstanceId "InvalidInstanceId"
//   The following problems can cause this exception:
//
//   You do not have permission to access the instance.
//
//   SSM Agent is not running. On managed instances and Linux instances, verify
//   that the SSM Agent is running. On EC2 Windows instances, verify that the
//   EC2Config service is running.
//
//   SSM Agent or EC2Config service is not registered to the SSM endpoint. Try
//   reinstalling SSM Agent or EC2Config service.
//
//   The instance is not in valid state. Valid states are: Running, Pending, Stopped,
//   Stopping. Invalid states are: Shutting-down and Terminated.
//
//   * ErrCodeInvalidPluginName "InvalidPluginName"
//   The plugin name is not valid.
//
//   * ErrCodeInvocationDoesNotExist "InvocationDoesNotExist"
//   The command ID and instance ID you specified did not match any invocations.
//   Verify the command ID adn the instance ID and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetCommandInvocation
func (c *SSM) GetCommandInvocation(input *GetCommandInvocationInput) (*GetCommandInvocationOutput, error) {
	req, out := c.GetCommandInvocationRequest(input)
	return out, req.Send()
}

// GetCommandInvocationWithContext is the same as GetCommandInvocation with the addition of
// the ability to pass a context and additional request options.
//
// See GetCommandInvocation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetCommandInvocationWithContext(ctx aws.Context, input *GetCommandInvocationInput, opts ...request.Option) (*GetCommandInvocationOutput, error) {
	req, out := c.GetCommandInvocationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetConnectionStatus = "GetConnectionStatus"

// GetConnectionStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetConnectionStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConnectionStatus for more information on using the GetConnectionStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetConnectionStatusRequest method.
//    req, resp := client.GetConnectionStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetConnectionStatus
func (c *SSM) GetConnectionStatusRequest(input *GetConnectionStatusInput) (req *request.Request, output *GetConnectionStatusOutput) {
	op := &request.Operation{
		Name:       opGetConnectionStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetConnectionStatusInput{}
	}

	output = &GetConnectionStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConnectionStatus API operation for Amazon Simple Systems Manager (SSM).
//
// Retrieves the Session Manager connection status for an instance to determine
// whether it is connected and ready to receive Session Manager connections.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation GetConnectionStatus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetConnectionStatus
func (c *SSM) GetConnectionStatus(input *GetConnectionStatusInput) (*GetConnectionStatusOutput, error) {
	req, out := c.GetConnectionStatusRequest(input)
	return out, req.Send()
}

// GetConnectionStatusWithContext is the same as GetConnectionStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetConnectionStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetConnectionStatusWithContext(ctx aws.Context, input *GetConnectionStatusInput, opts ...request.Option) (*GetConnectionStatusOutput, error) {
	req, out := c.GetConnectionStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDefaultPatchBaseline = "GetDefaultPatchBaseline"

// GetDefaultPatchBaselineRequest generates a "aws/request.Request" representing the
// client's request for the GetDefaultPatchBaseline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDefaultPatchBaseline for more information on using the GetDefaultPatchBaseline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDefaultPatchBaselineRequest method.
//    req, resp := client.GetDefaultPatchBaselineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDefaultPatchBaseline
func (c *SSM) GetDefaultPatchBaselineRequest(input *GetDefaultPatchBaselineInput) (req *request.Request, output *GetDefaultPatchBaselineOutput) {
	op := &request.Operation{
		Name:       opGetDefaultPatchBaseline,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDefaultPatchBaselineInput{}
	}

	output = &GetDefaultPatchBaselineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDefaultPatchBaseline API operation for Amazon Simple Systems Manager (SSM).
//
// Retrieves the default patch baseline. Note that Systems Manager supports
// creating multiple default patch baselines. For example, you can create a
// default patch baseline for each operating system.
//
// If you do not specify an operating system value, the default patch baseline
// for Windows is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation GetDefaultPatchBaseline for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDefaultPatchBaseline
func (c *SSM) GetDefaultPatchBaseline(input *GetDefaultPatchBaselineInput) (*GetDefaultPatchBaselineOutput, error) {
	req, out := c.GetDefaultPatchBaselineRequest(input)
	return out, req.Send()
}

// GetDefaultPatchBaselineWithContext is the same as GetDefaultPatchBaseline with the addition of
// the ability to pass a context and additional request options.
//
// See GetDefaultPatchBaseline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetDefaultPatchBaselineWithContext(ctx aws.Context, input *GetDefaultPatchBaselineInput, opts ...request.Option) (*GetDefaultPatchBaselineOutput, error) {
	req, out := c.GetDefaultPatchBaselineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDeployablePatchSnapshotForInstance = "GetDeployablePatchSnapshotForInstance"

// GetDeployablePatchSnapshotForInstanceRequest generates a "aws/request.Request" representing the
// client's request for the GetDeployablePatchSnapshotForInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDeployablePatchSnapshotForInstance for more information on using the GetDeployablePatchSnapshotForInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDeployablePatchSnapshotForInstanceRequest method.
//    req, resp := client.GetDeployablePatchSnapshotForInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDeployablePatchSnapshotForInstance
func (c *SSM) GetDeployablePatchSnapshotForInstanceRequest(input *GetDeployablePatchSnapshotForInstanceInput) (req *request.Request, output *GetDeployablePatchSnapshotForInstanceOutput) {
	op := &request.Operation{
		Name:       opGetDeployablePatchSnapshotForInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDeployablePatchSnapshotForInstanceInput{}
	}

	output = &GetDeployablePatchSnapshotForInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDeployablePatchSnapshotForInstance API operation for Amazon Simple Systems Manager (SSM).
//
// Retrieves the current snapshot for the patch baseline the instance uses.
// This API is primarily used by the AWS-RunPatchBaseline Systems Manager document.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation GetDeployablePatchSnapshotForInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeUnsupportedOperatingSystem "UnsupportedOperatingSystem"
//   The operating systems you specified is not supported, or the operation is
//   not supported for the operating system. Valid operating systems include:
//   Windows, AmazonLinux, RedhatEnterpriseLinux, and Ubuntu.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDeployablePatchSnapshotForInstance
func (c *SSM) GetDeployablePatchSnapshotForInstance(input *GetDeployablePatchSnapshotForInstanceInput) (*GetDeployablePatchSnapshotForInstanceOutput, error) {
	req, out := c.GetDeployablePatchSnapshotForInstanceRequest(input)
	return out, req.Send()
}

// GetDeployablePatchSnapshotForInstanceWithContext is the same as GetDeployablePatchSnapshotForInstance with the addition of
// the ability to pass a context and additional request options.
//
// See GetDeployablePatchSnapshotForInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetDeployablePatchSnapshotForInstanceWithContext(ctx aws.Context, input *GetDeployablePatchSnapshotForInstanceInput, opts ...request.Option) (*GetDeployablePatchSnapshotForInstanceOutput, error) {
	req, out := c.GetDeployablePatchSnapshotForInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDocument = "GetDocument"

// GetDocumentRequest generates a "aws/request.Request" representing the
// client's request for the GetDocument operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDocument for more information on using the GetDocument
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDocumentRequest method.
//    req, resp := client.GetDocumentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDocument
func (c *SSM) GetDocumentRequest(input *GetDocumentInput) (req *request.Request, output *GetDocumentOutput) {
	op := &request.Operation{
		Name:       opGetDocument,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDocumentInput{}
	}

	output = &GetDocumentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDocument API operation for Amazon Simple Systems Manager (SSM).
//
// Gets the contents of the specified Systems Manager document.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation GetDocument for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidDocument "InvalidDocument"
//   The specified document does not exist.
//
//   * ErrCodeInvalidDocumentVersion "InvalidDocumentVersion"
//   The document version is not valid or does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDocument
func (c *SSM) GetDocument(input *GetDocumentInput) (*GetDocumentOutput, error) {
	req, out := c.GetDocumentRequest(input)
	return out, req.Send()
}

// GetDocumentWithContext is the same as GetDocument with the addition of
// the ability to pass a context and additional request options.
//
// See GetDocument for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetDocumentWithContext(ctx aws.Context, input *GetDocumentInput, opts ...request.Option) (*GetDocumentOutput, error) {
	req, out := c.GetDocumentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInventory = "GetInventory"

// GetInventoryRequest generates a "aws/request.Request" representing the
// client's request for the GetInventory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInventory for more information on using the GetInventory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInventoryRequest method.
//    req, resp := client.GetInventoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventory
func (c *SSM) GetInventoryRequest(input *GetInventoryInput) (req *request.Request, output *GetInventoryOutput) {
	op := &request.Operation{
		Name:       opGetInventory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInventoryInput{}
	}

	output = &GetInventoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInventory API operation for Amazon Simple Systems Manager (SSM).
//
// Query inventory information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation GetInventory for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidFilter "InvalidFilter"
//   The filter name is not valid. Verify the you entered the correct name and
//   try again.
//
//   * ErrCodeInvalidInventoryGroupException "InvalidInventoryGroupException"
//   The specified inventory group is not valid.
//
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The specified token is not valid.
//
//   * ErrCodeInvalidTypeNameException "InvalidTypeNameException"
//   The parameter type name is not valid.
//
//   * ErrCodeInvalidAggregatorException "InvalidAggregatorException"
//   The specified aggregator is not valid for inventory groups. Verify that the
//   aggregator uses a valid inventory type such as AWS:Application or AWS:InstanceInformation.
//
//   * ErrCodeInvalidResultAttributeException "InvalidResultAttributeException"
//   The specified inventory item result attribute is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventory
func (c *SSM) GetInventory(input *GetInventoryInput) (*GetInventoryOutput, error) {
	req, out := c.GetInventoryRequest(input)
	return out, req.Send()
}

// GetInventoryWithContext is the same as GetInventory with the addition of
// the ability to pass a context and additional request options.
//
// See GetInventory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetInventoryWithContext(ctx aws.Context, input *GetInventoryInput, opts ...request.Option) (*GetInventoryOutput, error) {
	req, out := c.GetInventoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInventorySchema = "GetInventorySchema"

// GetInventorySchemaRequest generates a "aws/request.Request" representing the
// client's request for the GetInventorySchema operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInventorySchema for more information on using the GetInventorySchema
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInventorySchemaRequest method.
//    req, resp := client.GetInventorySchemaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventorySchema
func (c *SSM) GetInventorySchemaRequest(input *GetInventorySchemaInput) (req *request.Request, output *GetInventorySchemaOutput) {
	op := &request.Operation{
		Name:       opGetInventorySchema,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInventorySchemaInput{}
	}

	output = &GetInventorySchemaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInventorySchema API operation for Amazon Simple Systems Manager (SSM).
//
// Return a list of inventory type names for the account, or return a list of
// attribute names for a specific Inventory item type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation GetInventorySchema for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidTypeNameException "InvalidTypeNameException"
//   The parameter type name is not valid.
//
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The specified token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventorySchema
func (c *SSM) GetInventorySchema(input *GetInventorySchemaInput) (*GetInventorySchemaOutput, error) {
	req, out := c.GetInventorySchemaRequest(input)
	return out, req.Send()
}

// GetInventorySchemaWithContext is the same as GetInventorySchema with the addition of
// the ability to pass a context and additional request options.
//
// See GetInventorySchema for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetInventorySchemaWithContext(ctx aws.Context, input *GetInventorySchemaInput, opts ...request.Option) (*GetInventorySchemaOutput, error) {
	req, out := c.GetInventorySchemaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMaintenanceWindow = "GetMaintenanceWindow"

// GetMaintenanceWindowRequest generates a "aws/request.Request" representing the
// client's request for the GetMaintenanceWindow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMaintenanceWindow for more information on using the GetMaintenanceWindow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMaintenanceWindowRequest method.
//    req, resp := client.GetMaintenanceWindowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindow
func (c *SSM) GetMaintenanceWindowRequest(input *GetMaintenanceWindowInput) (req *request.Request, output *GetMaintenanceWindowOutput) {
	op := &request.Operation{
		Name:       opGetMaintenanceWindow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMaintenanceWindowInput{}
	}

	output = &GetMaintenanceWindowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMaintenanceWindow API operation for Amazon Simple Systems Manager (SSM).
//
// Retrieves a Maintenance Window.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation GetMaintenanceWindow for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDoesNotExistException "DoesNotExistException"
//   Error returned when the ID specified for a resource, such as a Maintenance
//   Window or Patch baseline, doesn't exist.
//
//   For information about resource limits in Systems Manager, see AWS Systems
//   Manager Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_ssm).
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindow
func (c *SSM) GetMaintenanceWindow(input *GetMaintenanceWindowInput) (*GetMaintenanceWindowOutput, error) {
	req, out := c.GetMaintenanceWindowRequest(input)
	return out, req.Send()
}

// GetMaintenanceWindowWithContext is the same as GetMaintenanceWindow with the addition of
// the ability to pass a context and additional request options.
//
// See GetMaintenanceWindow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetMaintenanceWindowWithContext(ctx aws.Context, input *GetMaintenanceWindowInput, opts ...request.Option) (*GetMaintenanceWindowOutput, error) {
	req, out := c.GetMaintenanceWindowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMaintenanceWindowExecution = "GetMaintenanceWindowExecution"

// GetMaintenanceWindowExecutionRequest generates a "aws/request.Request" representing the
// client's request for the GetMaintenanceWindowExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMaintenanceWindowExecution for more information on using the GetMaintenanceWindowExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMaintenanceWindowExecutionRequest method.
//    req, resp := client.GetMaintenanceWindowExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecution
func (c *SSM) GetMaintenanceWindowExecutionRequest(input *GetMaintenanceWindowExecutionInput) (req *request.Request, output *GetMaintenanceWindowExecutionOutput) {
	op := &request.Operation{
		Name:       opGetMaintenanceWindowExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMaintenanceWindowExecutionInput{}
	}

	output = &GetMaintenanceWindowExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMaintenanceWindowExecution API operation for Amazon Simple Systems Manager (SSM).
//
// Retrieves details about a specific task executed as part of a Maintenance
// Window execution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation GetMaintenanceWindowExecution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDoesNotExistException "DoesNotExistException"
//   Error returned when the ID specified for a resource, such as a Maintenance
//   Window or Patch baseline, doesn't exist.
//
//   For information about resource limits in Systems Manager, see AWS Systems
//   Manager Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_ssm).
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecution
func (c *SSM) GetMaintenanceWindowExecution(input *GetMaintenanceWindowExecutionInput) (*GetMaintenanceWindowExecutionOutput, error) {
	req, out := c.GetMaintenanceWindowExecutionRequest(input)
	return out, req.Send()
}

// GetMaintenanceWindowExecutionWithContext is the same as GetMaintenanceWindowExecution with the addition of
// the ability to pass a context and additional request options.
//
// See GetMaintenanceWindowExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetMaintenanceWindowExecutionWithContext(ctx aws.Context, input *GetMaintenanceWindowExecutionInput, opts ...request.Option) (*GetMaintenanceWindowExecutionOutput, error) {
	req, out := c.GetMaintenanceWindowExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMaintenanceWindowExecutionTask = "GetMaintenanceWindowExecutionTask"

// GetMaintenanceWindowExecutionTaskRequest generates a "aws/request.Request" representing the
// client's request for the GetMaintenanceWindowExecutionTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMaintenanceWindowExecutionTask for more information on using the GetMaintenanceWindowExecutionTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMaintenanceWindowExecutionTaskRequest method.
//    req, resp := client.GetMaintenanceWindowExecutionTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecutionTask
func (c *SSM) GetMaintenanceWindowExecutionTaskRequest(input *GetMaintenanceWindowExecutionTaskInput) (req *request.Request, output *GetMaintenanceWindowExecutionTaskOutput) {
	op := &request.Operation{
		Name:       opGetMaintenanceWindowExecutionTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMaintenanceWindowExecutionTaskInput{}
	}

	output = &GetMaintenanceWindowExecutionTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMaintenanceWindowExecutionTask API operation for Amazon Simple Systems Manager (SSM).
//
// Retrieves the details about a specific task executed as part of a Maintenance
// Window execution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation GetMaintenanceWindowExecutionTask for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDoesNotExistException "DoesNotExistException"
//   Error returned when the ID specified for a resource, such as a Maintenance
//   Window or Patch baseline, doesn't exist.
//
//   For information about resource limits in Systems Manager, see AWS Systems
//   Manager Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_ssm).
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecutionTask
func (c *SSM) GetMaintenanceWindowExecutionTask(input *GetMaintenanceWindowExecutionTaskInput) (*GetMaintenanceWindowExecutionTaskOutput, error) {
	req, out := c.GetMaintenanceWindowExecutionTaskRequest(input)
	return out, req.Send()
}

// GetMaintenanceWindowExecutionTaskWithContext is the same as GetMaintenanceWindowExecutionTask with the addition of
// the ability to pass a context and additional request options.
//
// See GetMaintenanceWindowExecutionTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetMaintenanceWindowExecutionTaskWithContext(ctx aws.Context, input *GetMaintenanceWindowExecutionTaskInput, opts ...request.Option) (*GetMaintenanceWindowExecutionTaskOutput, error) {
	req, out := c.GetMaintenanceWindowExecutionTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMaintenanceWindowExecutionTaskInvocation = "GetMaintenanceWindowExecutionTaskInvocation"

// GetMaintenanceWindowExecutionTaskInvocationRequest generates a "aws/request.Request" representing the
// client's request for the GetMaintenanceWindowExecutionTaskInvocation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMaintenanceWindowExecutionTaskInvocation for more information on using the GetMaintenanceWindowExecutionTaskInvocation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMaintenanceWindowExecutionTaskInvocationRequest method.
//    req, resp := client.GetMaintenanceWindowExecutionTaskInvocationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecutionTaskInvocation
func (c *SSM) GetMaintenanceWindowExecutionTaskInvocationRequest(input *GetMaintenanceWindowExecutionTaskInvocationInput) (req *request.Request, output *GetMaintenanceWindowExecutionTaskInvocationOutput) {
	op := &request.Operation{
		Name:       opGetMaintenanceWindowExecutionTaskInvocation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMaintenanceWindowExecutionTaskInvocationInput{}
	}

	output = &GetMaintenanceWindowExecutionTaskInvocationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMaintenanceWindowExecutionTaskInvocation API operation for Amazon Simple Systems Manager (SSM).
//
// Retrieves a task invocation. A task invocation is a specific task executing
// on a specific target. Maintenance Windows report status for all invocations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation GetMaintenanceWindowExecutionTaskInvocation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDoesNotExistException "DoesNotExistException"
//   Error returned when the ID specified for a resource, such as a Maintenance
//   Window or Patch baseline, doesn't exist.
//
//   For information about resource limits in Systems Manager, see AWS Systems
//   Manager Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_ssm).
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecutionTaskInvocation
func (c *SSM) GetMaintenanceWindowExecutionTaskInvocation(input *GetMaintenanceWindowExecutionTaskInvocationInput) (*GetMaintenanceWindowExecutionTaskInvocationOutput, error) {
	req, out := c.GetMaintenanceWindowExecutionTaskInvocationRequest(input)
	return out, req.Send()
}

// GetMaintenanceWindowExecutionTaskInvocationWithContext is the same as GetMaintenanceWindowExecutionTaskInvocation with the addition of
// the ability to pass a context and additional request options.
//
// See GetMaintenanceWindowExecutionTaskInvocation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetMaintenanceWindowExecutionTaskInvocationWithContext(ctx aws.Context, input *GetMaintenanceWindowExecutionTaskInvocationInput, opts ...request.Option) (*GetMaintenanceWindowExecutionTaskInvocationOutput, error) {
	req, out := c.GetMaintenanceWindowExecutionTaskInvocationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMaintenanceWindowTask = "GetMaintenanceWindowTask"

// GetMaintenanceWindowTaskRequest generates a "aws/request.Request" representing the
// client's request for the GetMaintenanceWindowTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMaintenanceWindowTask for more information on using the GetMaintenanceWindowTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMaintenanceWindowTaskRequest method.
//    req, resp := client.GetMaintenanceWindowTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowTask
func (c *SSM) GetMaintenanceWindowTaskRequest(input *GetMaintenanceWindowTaskInput) (req *request.Request, output *GetMaintenanceWindowTaskOutput) {
	op := &request.Operation{
		Name:       opGetMaintenanceWindowTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMaintenanceWindowTaskInput{}
	}

	output = &GetMaintenanceWindowTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMaintenanceWindowTask API operation for Amazon Simple Systems Manager (SSM).
//
// Lists the tasks in a Maintenance Window.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation GetMaintenanceWindowTask for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDoesNotExistException "DoesNotExistException"
//   Error returned when the ID specified for a resource, such as a Maintenance
//   Window or Patch baseline, doesn't exist.
//
//   For information about resource limits in Systems Manager, see AWS Systems
//   Manager Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_ssm).
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowTask
func (c *SSM) GetMaintenanceWindowTask(input *GetMaintenanceWindowTaskInput) (*GetMaintenanceWindowTaskOutput, error) {
	req, out := c.GetMaintenanceWindowTaskRequest(input)
	return out, req.Send()
}

// GetMaintenanceWindowTaskWithContext is the same as GetMaintenanceWindowTask with the addition of
// the ability to pass a context and additional request options.
//
// See GetMaintenanceWindowTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetMaintenanceWindowTaskWithContext(ctx aws.Context, input *GetMaintenanceWindowTaskInput, opts ...request.Option) (*GetMaintenanceWindowTaskOutput, error) {
	req, out := c.GetMaintenanceWindowTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetParameter = "GetParameter"

// GetParameterRequest generates a "aws/request.Request" representing the
// client's request for the GetParameter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetParameter for more information on using the GetParameter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetParameterRequest method.
//    req, resp := client.GetParameterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameter
func (c *SSM) GetParameterRequest(input *GetParameterInput) (req *request.Request, output *GetParameterOutput) {
	op := &request.Operation{
		Name:       opGetParameter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetParameterInput{}
	}

	output = &GetParameterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetParameter API operation for Amazon Simple Systems Manager (SSM).
//
// Get information about a parameter by using the parameter name. Don't confuse
// this API action with the GetParameters API action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation GetParameter for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidKeyId "InvalidKeyId"
//   The query key ID is not valid.
//
//   * ErrCodeParameterNotFound "ParameterNotFound"
//   The parameter could not be found. Verify the name and try again.
//
//   * ErrCodeParameterVersionNotFound "ParameterVersionNotFound"
//   The specified parameter version was not found. Verify the parameter name
//   and version, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameter
func (c *SSM) GetParameter(input *GetParameterInput) (*GetParameterOutput, error) {
	req, out := c.GetParameterRequest(input)
	return out, req.Send()
}

// GetParameterWithContext is the same as GetParameter with the addition of
// the ability to pass a context and additional request options.
//
// See GetParameter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetParameterWithContext(ctx aws.Context, input *GetParameterInput, opts ...request.Option) (*GetParameterOutput, error) {
	req, out := c.GetParameterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetParameterHistory = "GetParameterHistory"

// GetParameterHistoryRequest generates a "aws/request.Request" representing the
// client's request for the GetParameterHistory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetParameterHistory for more information on using the GetParameterHistory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetParameterHistoryRequest method.
//    req, resp := client.GetParameterHistoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameterHistory
func (c *SSM) GetParameterHistoryRequest(input *GetParameterHistoryInput) (req *request.Request, output *GetParameterHistoryOutput) {
	op := &request.Operation{
		Name:       opGetParameterHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetParameterHistoryInput{}
	}

	output = &GetParameterHistoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetParameterHistory API operation for Amazon Simple Systems Manager (SSM).
//
// Query a list of all parameters used by the AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation GetParameterHistory for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeParameterNotFound "ParameterNotFound"
//   The parameter could not be found. Verify the name and try again.
//
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The specified token is not valid.
//
//   * ErrCodeInvalidKeyId "InvalidKeyId"
//   The query key ID is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameterHistory
func (c *SSM) GetParameterHistory(input *GetParameterHistoryInput) (*GetParameterHistoryOutput, error) {
	req, out := c.GetParameterHistoryRequest(input)
	return out, req.Send()
}

// GetParameterHistoryWithContext is the same as GetParameterHistory with the addition of
// the ability to pass a context and additional request options.
//
// See GetParameterHistory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetParameterHistoryWithContext(ctx aws.Context, input *GetParameterHistoryInput, opts ...request.Option) (*GetParameterHistoryOutput, error) {
	req, out := c.GetParameterHistoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetParameterHistoryPages iterates over the pages of a GetParameterHistory operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetParameterHistory method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetParameterHistory operation.
//    pageNum := 0
//    err := client.GetParameterHistoryPages(params,
//        func(page *GetParameterHistoryOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SSM) GetParameterHistoryPages(input *GetParameterHistoryInput, fn func(*GetParameterHistoryOutput, bool) bool) error {
	return c.GetParameterHistoryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetParameterHistoryPagesWithContext same as GetParameterHistoryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetParameterHistoryPagesWithContext(ctx aws.Context, input *GetParameterHistoryInput, fn func(*GetParameterHistoryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetParameterHistoryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetParameterHistoryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetParameterHistoryOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opGetParameters = "GetParameters"

// GetParametersRequest generates a "aws/request.Request" representing the
// client's request for the GetParameters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetParameters for more information on using the GetParameters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetParametersRequest method.
//    req, resp := client.GetParametersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameters
func (c *SSM) GetParametersRequest(input *GetParametersInput) (req *request.Request, output *GetParametersOutput) {
	op := &request.Operation{
		Name:       opGetParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetParametersInput{}
	}

	output = &GetParametersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetParameters API operation for Amazon Simple Systems Manager (SSM).
//
// Get details of a parameter. Don't confuse this API action with the GetParameter
// API action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation GetParameters for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidKeyId "InvalidKeyId"
//   The query key ID is not valid.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameters
func (c *SSM) GetParameters(input *GetParametersInput) (*GetParametersOutput, error) {
	req, out := c.GetParametersRequest(input)
	return out, req.Send()
}

// GetParametersWithContext is the same as GetParameters with the addition of
// the ability to pass a context and additional request options.
//
// See GetParameters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetParametersWithContext(ctx aws.Context, input *GetParametersInput, opts ...request.Option) (*GetParametersOutput, error) {
	req, out := c.GetParametersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetParametersByPath = "GetParametersByPath"

// GetParametersByPathRequest generates a "aws/request.Request" representing the
// client's request for the GetParametersByPath operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetParametersByPath for more information on using the GetParametersByPath
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetParametersByPathRequest method.
//    req, resp := client.GetParametersByPathRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParametersByPath
func (c *SSM) GetParametersByPathRequest(input *GetParametersByPathInput) (req *request.Request, output *GetParametersByPathOutput) {
	op := &request.Operation{
		Name:       opGetParametersByPath,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetParametersByPathInput{}
	}

	output = &GetParametersByPathOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetParametersByPath API operation for Amazon Simple Systems Manager (SSM).
//
// Retrieve parameters in a specific hierarchy. For more information, see Working
// with Systems Manager Parameters (http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-working.html)
// in the AWS Systems Manager User Guide.
//
// Request results are returned on a best-effort basis. If you specify MaxResults
// in the request, the response includes information up to the limit specified.
// The number of items returned, however, can be between zero and the value
// of MaxResults. If the service reaches an internal limit while processing
// the results, it stops the operation and returns the matching values up to
// that point and a NextToken. You can specify the NextToken in a subsequent
// call to get the next set of results.
//
// This API action doesn't support filtering by tags.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation GetParametersByPath for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidFilterKey "InvalidFilterKey"
//   The specified key is not valid.
//
//   * ErrCodeInvalidFilterOption "InvalidFilterOption"
//   The specified filter option is not valid. Valid options are Equals and BeginsWith.
//   For Path filter, valid options are Recursive and OneLevel.
//
//   * ErrCodeInvalidFilterValue "InvalidFilterValue"
//   The filter value is not valid. Verify the value and try again.
//
//   * ErrCodeInvalidKeyId "InvalidKeyId"
//   The query key ID is not valid.
//
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The specified token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParametersByPath
func (c *SSM) GetParametersByPath(input *GetParametersByPathInput) (*GetParametersByPathOutput, error) {
	req, out := c.GetParametersByPathRequest(input)
	return out, req.Send()
}

// GetParametersByPathWithContext is the same as GetParametersByPath with the addition of
// the ability to pass a context and additional request options.
//
// See GetParametersByPath for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetParametersByPathWithContext(ctx aws.Context, input *GetParametersByPathInput, opts ...request.Option) (*GetParametersByPathOutput, error) {
	req, out := c.GetParametersByPathRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetParametersByPathPages iterates over the pages of a GetParametersByPath operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetParametersByPath method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetParametersByPath operation.
//    pageNum := 0
//    err := client.GetParametersByPathPages(params,
//        func(page *GetParametersByPathOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SSM) GetParametersByPathPages(input *GetParametersByPathInput, fn func(*GetParametersByPathOutput, bool) bool) error {
	return c.GetParametersByPathPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetParametersByPathPagesWithContext same as GetParametersByPathPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetParametersByPathPagesWithContext(ctx aws.Context, input *GetParametersByPathInput, fn func(*GetParametersByPathOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetParametersByPathInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetParametersByPathRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetParametersByPathOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opGetPatchBaseline = "GetPatchBaseline"

// GetPatchBaselineRequest generates a "aws/request.Request" representing the
// client's request for the GetPatchBaseline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPatchBaseline for more information on using the GetPatchBaseline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPatchBaselineRequest method.
//    req, resp := client.GetPatchBaselineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetPatchBaseline
func (c *SSM) GetPatchBaselineRequest(input *GetPatchBaselineInput) (req *request.Request, output *GetPatchBaselineOutput) {
	op := &request.Operation{
		Name:       opGetPatchBaseline,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPatchBaselineInput{}
	}

	output = &GetPatchBaselineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPatchBaseline API operation for Amazon Simple Systems Manager (SSM).
//
// Retrieves information about a patch baseline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation GetPatchBaseline for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDoesNotExistException "DoesNotExistException"
//   Error returned when the ID specified for a resource, such as a Maintenance
//   Window or Patch baseline, doesn't exist.
//
//   For information about resource limits in Systems Manager, see AWS Systems
//   Manager Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_ssm).
//
//   * ErrCodeInvalidResourceId "InvalidResourceId"
//   The resource ID is not valid. Verify that you entered the correct ID and
//   try again.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetPatchBaseline
func (c *SSM) GetPatchBaseline(input *GetPatchBaselineInput) (*GetPatchBaselineOutput, error) {
	req, out := c.GetPatchBaselineRequest(input)
	return out, req.Send()
}

// GetPatchBaselineWithContext is the same as GetPatchBaseline with the addition of
// the ability to pass a context and additional request options.
//
// See GetPatchBaseline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetPatchBaselineWithContext(ctx aws.Context, input *GetPatchBaselineInput, opts ...request.Option) (*GetPatchBaselineOutput, error) {
	req, out := c.GetPatchBaselineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPatchBaselineForPatchGroup = "GetPatchBaselineForPatchGroup"

// GetPatchBaselineForPatchGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetPatchBaselineForPatchGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPatchBaselineForPatchGroup for more information on using the GetPatchBaselineForPatchGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPatchBaselineForPatchGroupRequest method.
//    req, resp := client.GetPatchBaselineForPatchGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetPatchBaselineForPatchGroup
func (c *SSM) GetPatchBaselineForPatchGroupRequest(input *GetPatchBaselineForPatchGroupInput) (req *request.Request, output *GetPatchBaselineForPatchGroupOutput) {
	op := &request.Operation{
		Name:       opGetPatchBaselineForPatchGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPatchBaselineForPatchGroupInput{}
	}

	output = &GetPatchBaselineForPatchGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPatchBaselineForPatchGroup API operation for Amazon Simple Systems Manager (SSM).
//
// Retrieves the patch baseline that should be used for the specified patch
// group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation GetPatchBaselineForPatchGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetPatchBaselineForPatchGroup
func (c *SSM) GetPatchBaselineForPatchGroup(input *GetPatchBaselineForPatchGroupInput) (*GetPatchBaselineForPatchGroupOutput, error) {
	req, out := c.GetPatchBaselineForPatchGroupRequest(input)
	return out, req.Send()
}

// GetPatchBaselineForPatchGroupWithContext is the same as GetPatchBaselineForPatchGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetPatchBaselineForPatchGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) GetPatchBaselineForPatchGroupWithContext(ctx aws.Context, input *GetPatchBaselineForPatchGroupInput, opts ...request.Option) (*GetPatchBaselineForPatchGroupOutput, error) {
	req, out := c.GetPatchBaselineForPatchGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opLabelParameterVersion = "LabelParameterVersion"

// LabelParameterVersionRequest generates a "aws/request.Request" representing the
// client's request for the LabelParameterVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See LabelParameterVersion for more information on using the LabelParameterVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the LabelParameterVersionRequest method.
//    req, resp := client.LabelParameterVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/LabelParameterVersion
func (c *SSM) LabelParameterVersionRequest(input *LabelParameterVersionInput) (req *request.Request, output *LabelParameterVersionOutput) {
	op := &request.Operation{
		Name:       opLabelParameterVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &LabelParameterVersionInput{}
	}

	output = &LabelParameterVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// LabelParameterVersion API operation for Amazon Simple Systems Manager (SSM).
//
// A parameter label is a user-defined alias to help you manage different versions
// of a parameter. When you modify a parameter, Systems Manager automatically
// saves a new version and increments the version number by one. A label can
// help you remember the purpose of a parameter when there are multiple versions.
//
// Parameter labels have the following requirements and restrictions.
//
//    * A version of a parameter can have a maximum of 10 labels.
//
//    * You can't attach the same label to different versions of the same parameter.
//    For example, if version 1 has the label Production, then you can't attach
//    Production to version 2.
//
//    * You can move a label from one version of a parameter to another.
//
//    * You can't create a label when you create a new parameter. You must attach
//    a label to a specific version of a parameter.
//
//    * You can't delete a parameter label. If you no longer want to use a parameter
//    label, then you must move it to a different version of a parameter.
//
//    * A label can have a maximum of 100 characters.
//
//    * Labels can contain letters (case sensitive), numbers, periods (.), hyphens
//    (-), or underscores (_).
//
//    * Labels can't begin with a number, "aws," or "ssm" (not case sensitive).
//    If a label fails to meet these requirements, then the label is not associated
//    with a parameter and the system displays it in the list of InvalidLabels.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation LabelParameterVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeTooManyUpdates "TooManyUpdates"
//   There are concurrent updates for a resource that supports one update at a
//   time.
//
//   * ErrCodeParameterNotFound "ParameterNotFound"
//   The parameter could not be found. Verify the name and try again.
//
//   * ErrCodeParameterVersionNotFound "ParameterVersionNotFound"
//   The specified parameter version was not found. Verify the parameter name
//   and version, and try again.
//
//   * ErrCodeParameterVersionLabelLimitExceeded "ParameterVersionLabelLimitExceeded"
//   A parameter version can have a maximum of ten labels.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/LabelParameterVersion
func (c *SSM) LabelParameterVersion(input *LabelParameterVersionInput) (*LabelParameterVersionOutput, error) {
	req, out := c.LabelParameterVersionRequest(input)
	return out, req.Send()
}

// LabelParameterVersionWithContext is the same as LabelParameterVersion with the addition of
// the ability to pass a context and additional request options.
//
// See LabelParameterVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) LabelParameterVersionWithContext(ctx aws.Context, input *LabelParameterVersionInput, opts ...request.Option) (*LabelParameterVersionOutput, error) {
	req, out := c.LabelParameterVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAssociationVersions = "ListAssociationVersions"

// ListAssociationVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListAssociationVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAssociationVersions for more information on using the ListAssociationVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAssociationVersionsRequest method.
//    req, resp := client.ListAssociationVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociationVersions
func (c *SSM) ListAssociationVersionsRequest(input *ListAssociationVersionsInput) (req *request.Request, output *ListAssociationVersionsOutput) {
	op := &request.Operation{
		Name:       opListAssociationVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAssociationVersionsInput{}
	}

	output = &ListAssociationVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAssociationVersions API operation for Amazon Simple Systems Manager (SSM).
//
// Retrieves all versions of an association for a specific association ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation ListAssociationVersions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The specified token is not valid.
//
//   * ErrCodeAssociationDoesNotExist "AssociationDoesNotExist"
//   The specified association does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociationVersions
func (c *SSM) ListAssociationVersions(input *ListAssociationVersionsInput) (*ListAssociationVersionsOutput, error) {
	req, out := c.ListAssociationVersionsRequest(input)
	return out, req.Send()
}

// ListAssociationVersionsWithContext is the same as ListAssociationVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListAssociationVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListAssociationVersionsWithContext(ctx aws.Context, input *ListAssociationVersionsInput, opts ...request.Option) (*ListAssociationVersionsOutput, error) {
	req, out := c.ListAssociationVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAssociations = "ListAssociations"

// ListAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the ListAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAssociations for more information on using the ListAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAssociationsRequest method.
//    req, resp := client.ListAssociationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociations
func (c *SSM) ListAssociationsRequest(input *ListAssociationsInput) (req *request.Request, output *ListAssociationsOutput) {
	op := &request.Operation{
		Name:       opListAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssociationsInput{}
	}

	output = &ListAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAssociations API operation for Amazon Simple Systems Manager (SSM).
//
// Lists the associations for the specified Systems Manager document or instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation ListAssociations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The specified token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociations
func (c *SSM) ListAssociations(input *ListAssociationsInput) (*ListAssociationsOutput, error) {
	req, out := c.ListAssociationsRequest(input)
	return out, req.Send()
}

// ListAssociationsWithContext is the same as ListAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See ListAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListAssociationsWithContext(ctx aws.Context, input *ListAssociationsInput, opts ...request.Option) (*ListAssociationsOutput, error) {
	req, out := c.ListAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAssociationsPages iterates over the pages of a ListAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAssociations operation.
//    pageNum := 0
//    err := client.ListAssociationsPages(params,
//        func(page *ListAssociationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SSM) ListAssociationsPages(input *ListAssociationsInput, fn func(*ListAssociationsOutput, bool) bool) error {
	return c.ListAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAssociationsPagesWithContext same as ListAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListAssociationsPagesWithContext(ctx aws.Context, input *ListAssociationsInput, fn func(*ListAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListAssociationsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListCommandInvocations = "ListCommandInvocations"

// ListCommandInvocationsRequest generates a "aws/request.Request" representing the
// client's request for the ListCommandInvocations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCommandInvocations for more information on using the ListCommandInvocations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCommandInvocationsRequest method.
//    req, resp := client.ListCommandInvocationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommandInvocations
func (c *SSM) ListCommandInvocationsRequest(input *ListCommandInvocationsInput) (req *request.Request, output *ListCommandInvocationsOutput) {
	op := &request.Operation{
		Name:       opListCommandInvocations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCommandInvocationsInput{}
	}

	output = &ListCommandInvocationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCommandInvocations API operation for Amazon Simple Systems Manager (SSM).
//
// An invocation is copy of a command sent to a specific instance. A command
// can apply to one or more instances. A command invocation applies to one instance.
// For example, if a user executes SendCommand against three instances, then
// a command invocation is created for each requested instance ID. ListCommandInvocations
// provide status about command execution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation ListCommandInvocations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidCommandId "InvalidCommandId"
//
//   * ErrCodeInvalidInstanceId "InvalidInstanceId"
//   The following problems can cause this exception:
//
//   You do not have permission to access the instance.
//
//   SSM Agent is not running. On managed instances and Linux instances, verify
//   that the SSM Agent is running. On EC2 Windows instances, verify that the
//   EC2Config service is running.
//
//   SSM Agent or EC2Config service is not registered to the SSM endpoint. Try
//   reinstalling SSM Agent or EC2Config service.
//
//   The instance is not in valid state. Valid states are: Running, Pending, Stopped,
//   Stopping. Invalid states are: Shutting-down and Terminated.
//
//   * ErrCodeInvalidFilterKey "InvalidFilterKey"
//   The specified key is not valid.
//
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The specified token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommandInvocations
func (c *SSM) ListCommandInvocations(input *ListCommandInvocationsInput) (*ListCommandInvocationsOutput, error) {
	req, out := c.ListCommandInvocationsRequest(input)
	return out, req.Send()
}

// ListCommandInvocationsWithContext is the same as ListCommandInvocations with the addition of
// the ability to pass a context and additional request options.
//
// See ListCommandInvocations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListCommandInvocationsWithContext(ctx aws.Context, input *ListCommandInvocationsInput, opts ...request.Option) (*ListCommandInvocationsOutput, error) {
	req, out := c.ListCommandInvocationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCommandInvocationsPages iterates over the pages of a ListCommandInvocations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCommandInvocations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListCommandInvocations operation.
//    pageNum := 0
//    err := client.ListCommandInvocationsPages(params,
//        func(page *ListCommandInvocationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SSM) ListCommandInvocationsPages(input *ListCommandInvocationsInput, fn func(*ListCommandInvocationsOutput, bool) bool) error {
	return c.ListCommandInvocationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCommandInvocationsPagesWithContext same as ListCommandInvocationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListCommandInvocationsPagesWithContext(ctx aws.Context, input *ListCommandInvocationsInput, fn func(*ListCommandInvocationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCommandInvocationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCommandInvocationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListCommandInvocationsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListCommands = "ListCommands"

// ListCommandsRequest generates a "aws/request.Request" representing the
// client's request for the ListCommands operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCommands for more information on using the ListCommands
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCommandsRequest method.
//    req, resp := client.ListCommandsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommands
func (c *SSM) ListCommandsRequest(input *ListCommandsInput) (req *request.Request, output *ListCommandsOutput) {
	op := &request.Operation{
		Name:       opListCommands,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCommandsInput{}
	}

	output = &ListCommandsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCommands API operation for Amazon Simple Systems Manager (SSM).
//
// Lists the commands requested by users of the AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation ListCommands for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidCommandId "InvalidCommandId"
//
//   * ErrCodeInvalidInstanceId "InvalidInstanceId"
//   The following problems can cause this exception:
//
//   You do not have permission to access the instance.
//
//   SSM Agent is not running. On managed instances and Linux instances, verify
//   that the SSM Agent is running. On EC2 Windows instances, verify that the
//   EC2Config service is running.
//
//   SSM Agent or EC2Config service is not registered to the SSM endpoint. Try
//   reinstalling SSM Agent or EC2Config service.
//
//   The instance is not in valid state. Valid states are: Running, Pending, Stopped,
//   Stopping. Invalid states are: Shutting-down and Terminated.
//
//   * ErrCodeInvalidFilterKey "InvalidFilterKey"
//   The specified key is not valid.
//
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The specified token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommands
func (c *SSM) ListCommands(input *ListCommandsInput) (*ListCommandsOutput, error) {
	req, out := c.ListCommandsRequest(input)
	return out, req.Send()
}

// ListCommandsWithContext is the same as ListCommands with the addition of
// the ability to pass a context and additional request options.
//
// See ListCommands for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListCommandsWithContext(ctx aws.Context, input *ListCommandsInput, opts ...request.Option) (*ListCommandsOutput, error) {
	req, out := c.ListCommandsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCommandsPages iterates over the pages of a ListCommands operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCommands method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListCommands operation.
//    pageNum := 0
//    err := client.ListCommandsPages(params,
//        func(page *ListCommandsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SSM) ListCommandsPages(input *ListCommandsInput, fn func(*ListCommandsOutput, bool) bool) error {
	return c.ListCommandsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCommandsPagesWithContext same as ListCommandsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListCommandsPagesWithContext(ctx aws.Context, input *ListCommandsInput, fn func(*ListCommandsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCommandsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCommandsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListCommandsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListComplianceItems = "ListComplianceItems"

// ListComplianceItemsRequest generates a "aws/request.Request" representing the
// client's request for the ListComplianceItems operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListComplianceItems for more information on using the ListComplianceItems
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListComplianceItemsRequest method.
//    req, resp := client.ListComplianceItemsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceItems
func (c *SSM) ListComplianceItemsRequest(input *ListComplianceItemsInput) (req *request.Request, output *ListComplianceItemsOutput) {
	op := &request.Operation{
		Name:       opListComplianceItems,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListComplianceItemsInput{}
	}

	output = &ListComplianceItemsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListComplianceItems API operation for Amazon Simple Systems Manager (SSM).
//
// For a specified resource ID, this API action returns a list of compliance
// statuses for different resource types. Currently, you can only specify one
// resource ID per call. List results depend on the criteria specified in the
// filter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation ListComplianceItems for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidResourceType "InvalidResourceType"
//   The resource type is not valid. For example, if you are attempting to tag
//   an instance, the instance must be a registered, managed instance.
//
//   * ErrCodeInvalidResourceId "InvalidResourceId"
//   The resource ID is not valid. Verify that you entered the correct ID and
//   try again.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidFilter "InvalidFilter"
//   The filter name is not valid. Verify the you entered the correct name and
//   try again.
//
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The specified token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceItems
func (c *SSM) ListComplianceItems(input *ListComplianceItemsInput) (*ListComplianceItemsOutput, error) {
	req, out := c.ListComplianceItemsRequest(input)
	return out, req.Send()
}

// ListComplianceItemsWithContext is the same as ListComplianceItems with the addition of
// the ability to pass a context and additional request options.
//
// See ListComplianceItems for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListComplianceItemsWithContext(ctx aws.Context, input *ListComplianceItemsInput, opts ...request.Option) (*ListComplianceItemsOutput, error) {
	req, out := c.ListComplianceItemsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListComplianceSummaries = "ListComplianceSummaries"

// ListComplianceSummariesRequest generates a "aws/request.Request" representing the
// client's request for the ListComplianceSummaries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListComplianceSummaries for more information on using the ListComplianceSummaries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListComplianceSummariesRequest method.
//    req, resp := client.ListComplianceSummariesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceSummaries
func (c *SSM) ListComplianceSummariesRequest(input *ListComplianceSummariesInput) (req *request.Request, output *ListComplianceSummariesOutput) {
	op := &request.Operation{
		Name:       opListComplianceSummaries,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListComplianceSummariesInput{}
	}

	output = &ListComplianceSummariesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListComplianceSummaries API operation for Amazon Simple Systems Manager (SSM).
//
// Returns a summary count of compliant and non-compliant resources for a compliance
// type. For example, this call can return State Manager associations, patches,
// or custom compliance types according to the filter criteria that you specify.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation ListComplianceSummaries for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidFilter "InvalidFilter"
//   The filter name is not valid. Verify the you entered the correct name and
//   try again.
//
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The specified token is not valid.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceSummaries
func (c *SSM) ListComplianceSummaries(input *ListComplianceSummariesInput) (*ListComplianceSummariesOutput, error) {
	req, out := c.ListComplianceSummariesRequest(input)
	return out, req.Send()
}

// ListComplianceSummariesWithContext is the same as ListComplianceSummaries with the addition of
// the ability to pass a context and additional request options.
//
// See ListComplianceSummaries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListComplianceSummariesWithContext(ctx aws.Context, input *ListComplianceSummariesInput, opts ...request.Option) (*ListComplianceSummariesOutput, error) {
	req, out := c.ListComplianceSummariesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDocumentVersions = "ListDocumentVersions"

// ListDocumentVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListDocumentVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDocumentVersions for more information on using the ListDocumentVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDocumentVersionsRequest method.
//    req, resp := client.ListDocumentVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocumentVersions
func (c *SSM) ListDocumentVersionsRequest(input *ListDocumentVersionsInput) (req *request.Request, output *ListDocumentVersionsOutput) {
	op := &request.Operation{
		Name:       opListDocumentVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListDocumentVersionsInput{}
	}

	output = &ListDocumentVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDocumentVersions API operation for Amazon Simple Systems Manager (SSM).
//
// List all versions for a document.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation ListDocumentVersions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The specified token is not valid.
//
//   * ErrCodeInvalidDocument "InvalidDocument"
//   The specified document does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocumentVersions
func (c *SSM) ListDocumentVersions(input *ListDocumentVersionsInput) (*ListDocumentVersionsOutput, error) {
	req, out := c.ListDocumentVersionsRequest(input)
	return out, req.Send()
}

// ListDocumentVersionsWithContext is the same as ListDocumentVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListDocumentVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListDocumentVersionsWithContext(ctx aws.Context, input *ListDocumentVersionsInput, opts ...request.Option) (*ListDocumentVersionsOutput, error) {
	req, out := c.ListDocumentVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDocuments = "ListDocuments"

// ListDocumentsRequest generates a "aws/request.Request" representing the
// client's request for the ListDocuments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDocuments for more information on using the ListDocuments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDocumentsRequest method.
//    req, resp := client.ListDocumentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocuments
func (c *SSM) ListDocumentsRequest(input *ListDocumentsInput) (req *request.Request, output *ListDocumentsOutput) {
	op := &request.Operation{
		Name:       opListDocuments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDocumentsInput{}
	}

	output = &ListDocumentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDocuments API operation for Amazon Simple Systems Manager (SSM).
//
// Describes one or more of your Systems Manager documents.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation ListDocuments for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The specified token is not valid.
//
//   * ErrCodeInvalidFilterKey "InvalidFilterKey"
//   The specified key is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocuments
func (c *SSM) ListDocuments(input *ListDocumentsInput) (*ListDocumentsOutput, error) {
	req, out := c.ListDocumentsRequest(input)
	return out, req.Send()
}

// ListDocumentsWithContext is the same as ListDocuments with the addition of
// the ability to pass a context and additional request options.
//
// See ListDocuments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListDocumentsWithContext(ctx aws.Context, input *ListDocumentsInput, opts ...request.Option) (*ListDocumentsOutput, error) {
	req, out := c.ListDocumentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDocumentsPages iterates over the pages of a ListDocuments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDocuments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDocuments operation.
//    pageNum := 0
//    err := client.ListDocumentsPages(params,
//        func(page *ListDocumentsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SSM) ListDocumentsPages(input *ListDocumentsInput, fn func(*ListDocumentsOutput, bool) bool) error {
	return c.ListDocumentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDocumentsPagesWithContext same as ListDocumentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListDocumentsPagesWithContext(ctx aws.Context, input *ListDocumentsInput, fn func(*ListDocumentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDocumentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDocumentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListDocumentsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListInventoryEntries = "ListInventoryEntries"

// ListInventoryEntriesRequest generates a "aws/request.Request" representing the
// client's request for the ListInventoryEntries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInventoryEntries for more information on using the ListInventoryEntries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListInventoryEntriesRequest method.
//    req, resp := client.ListInventoryEntriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListInventoryEntries
func (c *SSM) ListInventoryEntriesRequest(input *ListInventoryEntriesInput) (req *request.Request, output *ListInventoryEntriesOutput) {
	op := &request.Operation{
		Name:       opListInventoryEntries,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListInventoryEntriesInput{}
	}

	output = &ListInventoryEntriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInventoryEntries API operation for Amazon Simple Systems Manager (SSM).
//
// A list of inventory items returned by the request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation ListInventoryEntries for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidInstanceId "InvalidInstanceId"
//   The following problems can cause this exception:
//
//   You do not have permission to access the instance.
//
//   SSM Agent is not running. On managed instances and Linux instances, verify
//   that the SSM Agent is running. On EC2 Windows instances, verify that the
//   EC2Config service is running.
//
//   SSM Agent or EC2Config service is not registered to the SSM endpoint. Try
//   reinstalling SSM Agent or EC2Config service.
//
//   The instance is not in valid state. Valid states are: Running, Pending, Stopped,
//   Stopping. Invalid states are: Shutting-down and Terminated.
//
//   * ErrCodeInvalidTypeNameException "InvalidTypeNameException"
//   The parameter type name is not valid.
//
//   * ErrCodeInvalidFilter "InvalidFilter"
//   The filter name is not valid. Verify the you entered the correct name and
//   try again.
//
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The specified token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListInventoryEntries
func (c *SSM) ListInventoryEntries(input *ListInventoryEntriesInput) (*ListInventoryEntriesOutput, error) {
	req, out := c.ListInventoryEntriesRequest(input)
	return out, req.Send()
}

// ListInventoryEntriesWithContext is the same as ListInventoryEntries with the addition of
// the ability to pass a context and additional request options.
//
// See ListInventoryEntries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListInventoryEntriesWithContext(ctx aws.Context, input *ListInventoryEntriesInput, opts ...request.Option) (*ListInventoryEntriesOutput, error) {
	req, out := c.ListInventoryEntriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListResourceComplianceSummaries = "ListResourceComplianceSummaries"

// ListResourceComplianceSummariesRequest generates a "aws/request.Request" representing the
// client's request for the ListResourceComplianceSummaries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResourceComplianceSummaries for more information on using the ListResourceComplianceSummaries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListResourceComplianceSummariesRequest method.
//    req, resp := client.ListResourceComplianceSummariesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListResourceComplianceSummaries
func (c *SSM) ListResourceComplianceSummariesRequest(input *ListResourceComplianceSummariesInput) (req *request.Request, output *ListResourceComplianceSummariesOutput) {
	op := &request.Operation{
		Name:       opListResourceComplianceSummaries,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListResourceComplianceSummariesInput{}
	}

	output = &ListResourceComplianceSummariesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResourceComplianceSummaries API operation for Amazon Simple Systems Manager (SSM).
//
// Returns a resource-level summary count. The summary includes information
// about compliant and non-compliant statuses and detailed compliance-item severity
// counts, according to the filter criteria you specify.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation ListResourceComplianceSummaries for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidFilter "InvalidFilter"
//   The filter name is not valid. Verify the you entered the correct name and
//   try again.
//
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The specified token is not valid.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListResourceComplianceSummaries
func (c *SSM) ListResourceComplianceSummaries(input *ListResourceComplianceSummariesInput) (*ListResourceComplianceSummariesOutput, error) {
	req, out := c.ListResourceComplianceSummariesRequest(input)
	return out, req.Send()
}

// ListResourceComplianceSummariesWithContext is the same as ListResourceComplianceSummaries with the addition of
// the ability to pass a context and additional request options.
//
// See ListResourceComplianceSummaries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListResourceComplianceSummariesWithContext(ctx aws.Context, input *ListResourceComplianceSummariesInput, opts ...request.Option) (*ListResourceComplianceSummariesOutput, error) {
	req, out := c.ListResourceComplianceSummariesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListResourceDataSync = "ListResourceDataSync"

// ListResourceDataSyncRequest generates a "aws/request.Request" representing the
// client's request for the ListResourceDataSync operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResourceDataSync for more information on using the ListResourceDataSync
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListResourceDataSyncRequest method.
//    req, resp := client.ListResourceDataSyncRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListResourceDataSync
func (c *SSM) ListResourceDataSyncRequest(input *ListResourceDataSyncInput) (req *request.Request, output *ListResourceDataSyncOutput) {
	op := &request.Operation{
		Name:       opListResourceDataSync,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListResourceDataSyncInput{}
	}

	output = &ListResourceDataSyncOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResourceDataSync API operation for Amazon Simple Systems Manager (SSM).
//
// Lists your resource data sync configurations. Includes information about
// the last time a sync attempted to start, the last sync status, and the last
// time a sync successfully completed.
//
// The number of sync configurations might be too large to return using a single
// call to ListResourceDataSync. You can limit the number of sync configurations
// returned by using the MaxResults parameter. To determine whether there are
// more sync configurations to list, check the value of NextToken in the output.
// If there are more sync configurations to list, you can request them by specifying
// the NextToken returned in the call to the parameter of a subsequent call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation ListResourceDataSync for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The specified token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListResourceDataSync
func (c *SSM) ListResourceDataSync(input *ListResourceDataSyncInput) (*ListResourceDataSyncOutput, error) {
	req, out := c.ListResourceDataSyncRequest(input)
	return out, req.Send()
}

// ListResourceDataSyncWithContext is the same as ListResourceDataSync with the addition of
// the ability to pass a context and additional request options.
//
// See ListResourceDataSync for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListResourceDataSyncWithContext(ctx aws.Context, input *ListResourceDataSyncInput, opts ...request.Option) (*ListResourceDataSyncOutput, error) {
	req, out := c.ListResourceDataSyncRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListTagsForResource
func (c *SSM) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Simple Systems Manager (SSM).
//
// Returns a list of the tags assigned to the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidResourceType "InvalidResourceType"
//   The resource type is not valid. For example, if you are attempting to tag
//   an instance, the instance must be a registered, managed instance.
//
//   * ErrCodeInvalidResourceId "InvalidResourceId"
//   The resource ID is not valid. Verify that you entered the correct ID and
//   try again.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListTagsForResource
func (c *SSM) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyDocumentPermission = "ModifyDocumentPermission"

// ModifyDocumentPermissionRequest generates a "aws/request.Request" representing the
// client's request for the ModifyDocumentPermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyDocumentPermission for more information on using the ModifyDocumentPermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyDocumentPermissionRequest method.
//    req, resp := client.ModifyDocumentPermissionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ModifyDocumentPermission
func (c *SSM) ModifyDocumentPermissionRequest(input *ModifyDocumentPermissionInput) (req *request.Request, output *ModifyDocumentPermissionOutput) {
	op := &request.Operation{
		Name:       opModifyDocumentPermission,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyDocumentPermissionInput{}
	}

	output = &ModifyDocumentPermissionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ModifyDocumentPermission API operation for Amazon Simple Systems Manager (SSM).
//
// Shares a Systems Manager document publicly or privately. If you share a document
// privately, you must specify the AWS user account IDs for those people who
// can use the document. If you share a document publicly, you must specify
// All as the account ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation ModifyDocumentPermission for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidDocument "InvalidDocument"
//   The specified document does not exist.
//
//   * ErrCodeInvalidPermissionType "InvalidPermissionType"
//   The permission type is not supported. Share is the only supported permission
//   type.
//
//   * ErrCodeDocumentPermissionLimit "DocumentPermissionLimit"
//   The document cannot be shared with more AWS user accounts. You can share
//   a document with a maximum of 20 accounts. You can publicly share up to five
//   documents. If you need to increase this limit, contact AWS Support.
//
//   * ErrCodeDocumentLimitExceeded "DocumentLimitExceeded"
//   You can have at most 200 active Systems Manager documents.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ModifyDocumentPermission
func (c *SSM) ModifyDocumentPermission(input *ModifyDocumentPermissionInput) (*ModifyDocumentPermissionOutput, error) {
	req, out := c.ModifyDocumentPermissionRequest(input)
	return out, req.Send()
}

// ModifyDocumentPermissionWithContext is the same as ModifyDocumentPermission with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyDocumentPermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ModifyDocumentPermissionWithContext(ctx aws.Context, input *ModifyDocumentPermissionInput, opts ...request.Option) (*ModifyDocumentPermissionOutput, error) {
	req, out := c.ModifyDocumentPermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutComplianceItems = "PutComplianceItems"

// PutComplianceItemsRequest generates a "aws/request.Request" representing the
// client's request for the PutComplianceItems operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutComplianceItems for more information on using the PutComplianceItems
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutComplianceItemsRequest method.
//    req, resp := client.PutComplianceItemsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/PutComplianceItems
func (c *SSM) PutComplianceItemsRequest(input *PutComplianceItemsInput) (req *request.Request, output *PutComplianceItemsOutput) {
	op := &request.Operation{
		Name:       opPutComplianceItems,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutComplianceItemsInput{}
	}

	output = &PutComplianceItemsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutComplianceItems API operation for Amazon Simple Systems Manager (SSM).
//
// Registers a compliance type and other compliance details on a designated
// resource. This action lets you register custom compliance details with a
// resource. This call overwrites existing compliance information on the resource,
// so you must provide a full list of compliance items each time that you send
// the request.
//
// ComplianceType can be one of the following:
//
//    * ExecutionId: The execution ID when the patch, association, or custom
//    compliance item was applied.
//
//    * ExecutionType: Specify patch, association, or Custom:string.
//
//    * ExecutionTime. The time the patch, association, or custom compliance
//    item was applied to the instance.
//
//    * Id: The patch, association, or custom compliance ID.
//
//    * Title: A title.
//
//    * Status: The status of the compliance item. For example, approved for
//    patches, or Failed for associations.
//
//    * Severity: A patch severity. For example, critical.
//
//    * DocumentName: A SSM document name. For example, AWS-RunPatchBaseline.
//
//    * DocumentVersion: An SSM document version number. For example, 4.
//
//    * Classification: A patch classification. For example, security updates.
//
//    * PatchBaselineId: A patch baseline ID.
//
//    * PatchSeverity: A patch severity. For example, Critical.
//
//    * PatchState: A patch state. For example, InstancesWithFailedPatches.
//
//    * PatchGroup: The name of a patch group.
//
//    * InstalledTime: The time the association, patch, or custom compliance
//    item was applied to the resource. Specify the time by using the following
//    format: yyyy-MM-dd'T'HH:mm:ss'Z'
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation PutComplianceItems for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidItemContentException "InvalidItemContentException"
//   One or more content items is not valid.
//
//   * ErrCodeTotalSizeLimitExceededException "TotalSizeLimitExceededException"
//   The size of inventory data has exceeded the total size limit for the resource.
//
//   * ErrCodeItemSizeLimitExceededException "ItemSizeLimitExceededException"
//   The inventory item size has exceeded the size limit.
//
//   * ErrCodeComplianceTypeCountLimitExceededException "ComplianceTypeCountLimitExceededException"
//   You specified too many custom compliance types. You can specify a maximum
//   of 10 different types.
//
//   * ErrCodeInvalidResourceType "InvalidResourceType"
//   The resource type is not valid. For example, if you are attempting to tag
//   an instance, the instance must be a registered, managed instance.
//
//   * ErrCodeInvalidResourceId "InvalidResourceId"
//   The resource ID is not valid. Verify that you entered the correct ID and
//   try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/PutComplianceItems
func (c *SSM) PutComplianceItems(input *PutComplianceItemsInput) (*PutComplianceItemsOutput, error) {
	req, out := c.PutComplianceItemsRequest(input)
	return out, req.Send()
}

// PutComplianceItemsWithContext is the same as PutComplianceItems with the addition of
// the ability to pass a context and additional request options.
//
// See PutComplianceItems for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) PutComplianceItemsWithContext(ctx aws.Context, input *PutComplianceItemsInput, opts ...request.Option) (*PutComplianceItemsOutput, error) {
	req, out := c.PutComplianceItemsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutInventory = "PutInventory"

// PutInventoryRequest generates a "aws/request.Request" representing the
// client's request for the PutInventory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutInventory for more information on using the PutInventory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutInventoryRequest method.
//    req, resp := client.PutInventoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/PutInventory
func (c *SSM) PutInventoryRequest(input *PutInventoryInput) (req *request.Request, output *PutInventoryOutput) {
	op := &request.Operation{
		Name:       opPutInventory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutInventoryInput{}
	}

	output = &PutInventoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutInventory API operation for Amazon Simple Systems Manager (SSM).
//
// Bulk update custom inventory items on one more instance. The request adds
// an inventory item, if it doesn't already exist, or updates an inventory item,
// if it does exist.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation PutInventory for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidInstanceId "InvalidInstanceId"
//   The following problems can cause this exception:
//
//   You do not have permission to access the instance.
//
//   SSM Agent is not running. On managed instances and Linux instances, verify
//   that the SSM Agent is running. On EC2 Windows instances, verify that the
//   EC2Config service is running.
//
//   SSM Agent or EC2Config service is not registered to the SSM endpoint. Try
//   reinstalling SSM Agent or EC2Config service.
//
//   The instance is not in valid state. Valid states are: Running, Pending, Stopped,
//   Stopping. Invalid states are: Shutting-down and Terminated.
//
//   * ErrCodeInvalidTypeNameException "InvalidTypeNameException"
//   The parameter type name is not valid.
//
//   * ErrCodeInvalidItemContentException "InvalidItemContentException"
//   One or more content items is not valid.
//
//   * ErrCodeTotalSizeLimitExceededException "TotalSizeLimitExceededException"
//   The size of inventory data has exceeded the total size limit for the resource.
//
//   * ErrCodeItemSizeLimitExceededException "ItemSizeLimitExceededException"
//   The inventory item size has exceeded the size limit.
//
//   * ErrCodeItemContentMismatchException "ItemContentMismatchException"
//   The inventory item has invalid content.
//
//   * ErrCodeCustomSchemaCountLimitExceededException "CustomSchemaCountLimitExceededException"
//   You have exceeded the limit for custom schemas. Delete one or more custom
//   schemas and try again.
//
//   * ErrCodeUnsupportedInventorySchemaVersionException "UnsupportedInventorySchemaVersionException"
//   Inventory item type schema version has to match supported versions in the
//   service. Check output of GetInventorySchema to see the available schema version
//   for each type.
//
//   * ErrCodeUnsupportedInventoryItemContextException "UnsupportedInventoryItemContextException"
//   The Context attribute that you specified for the InventoryItem is not allowed
//   for this inventory type. You can only use the Context attribute with inventory
//   types like AWS:ComplianceItem.
//
//   * ErrCodeInvalidInventoryItemContextException "InvalidInventoryItemContextException"
//   You specified invalid keys or values in the Context attribute for InventoryItem.
//   Verify the keys and values, and try again.
//
//   * ErrCodeSubTypeCountLimitExceededException "SubTypeCountLimitExceededException"
//   The sub-type count exceeded the limit for the inventory type.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/PutInventory
func (c *SSM) PutInventory(input *PutInventoryInput) (*PutInventoryOutput, error) {
	req, out := c.PutInventoryRequest(input)
	return out, req.Send()
}

// PutInventoryWithContext is the same as PutInventory with the addition of
// the ability to pass a context and additional request options.
//
// See PutInventory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) PutInventoryWithContext(ctx aws.Context, input *PutInventoryInput, opts ...request.Option) (*PutInventoryOutput, error) {
	req, out := c.PutInventoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutParameter = "PutParameter"

// PutParameterRequest generates a "aws/request.Request" representing the
// client's request for the PutParameter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutParameter for more information on using the PutParameter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutParameterRequest method.
//    req, resp := client.PutParameterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/PutParameter
func (c *SSM) PutParameterRequest(input *PutParameterInput) (req *request.Request, output *PutParameterOutput) {
	op := &request.Operation{
		Name:       opPutParameter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutParameterInput{}
	}

	output = &PutParameterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutParameter API operation for Amazon Simple Systems Manager (SSM).
//
// Add a parameter to the system.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation PutParameter for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidKeyId "InvalidKeyId"
//   The query key ID is not valid.
//
//   * ErrCodeParameterLimitExceeded "ParameterLimitExceeded"
//   You have exceeded the number of parameters for this AWS account. Delete one
//   or more parameters and try again.
//
//   * ErrCodeTooManyUpdates "TooManyUpdates"
//   There are concurrent updates for a resource that supports one update at a
//   time.
//
//   * ErrCodeParameterAlreadyExists "ParameterAlreadyExists"
//   The parameter already exists. You can't create duplicate parameters.
//
//   * ErrCodeHierarchyLevelLimitExceededException "HierarchyLevelLimitExceededException"
//   A hierarchy can have a maximum of 15 levels. For more information, see Requirements
//   and Constraints for Parameter Names (http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-parameter-name-constraints.html)
//   in the AWS Systems Manager User Guide.
//
//   * ErrCodeHierarchyTypeMismatchException "HierarchyTypeMismatchException"
//   Parameter Store does not support changing a parameter type in a hierarchy.
//   For example, you can't change a parameter from a String type to a SecureString
//   type. You must create a new, unique parameter.
//
//   * ErrCodeInvalidAllowedPatternException "InvalidAllowedPatternException"
//   The request does not meet the regular expression requirement.
//
//   * ErrCodeParameterMaxVersionLimitExceeded "ParameterMaxVersionLimitExceeded"
//   The parameter exceeded the maximum number of allowed versions.
//
//   * ErrCodeParameterPatternMismatchException "ParameterPatternMismatchException"
//   The parameter name is not valid.
//
//   * ErrCodeUnsupportedParameterType "UnsupportedParameterType"
//   The parameter type is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/PutParameter
func (c *SSM) PutParameter(input *PutParameterInput) (*PutParameterOutput, error) {
	req, out := c.PutParameterRequest(input)
	return out, req.Send()
}

// PutParameterWithContext is the same as PutParameter with the addition of
// the ability to pass a context and additional request options.
//
// See PutParameter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) PutParameterWithContext(ctx aws.Context, input *PutParameterInput, opts ...request.Option) (*PutParameterOutput, error) {
	req, out := c.PutParameterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterDefaultPatchBaseline = "RegisterDefaultPatchBaseline"

// RegisterDefaultPatchBaselineRequest generates a "aws/request.Request" representing the
// client's request for the RegisterDefaultPatchBaseline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterDefaultPatchBaseline for more information on using the RegisterDefaultPatchBaseline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterDefaultPatchBaselineRequest method.
//    req, resp := client.RegisterDefaultPatchBaselineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterDefaultPatchBaseline
func (c *SSM) RegisterDefaultPatchBaselineRequest(input *RegisterDefaultPatchBaselineInput) (req *request.Request, output *RegisterDefaultPatchBaselineOutput) {
	op := &request.Operation{
		Name:       opRegisterDefaultPatchBaseline,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterDefaultPatchBaselineInput{}
	}

	output = &RegisterDefaultPatchBaselineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterDefaultPatchBaseline API operation for Amazon Simple Systems Manager (SSM).
//
// Defines the default patch baseline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation RegisterDefaultPatchBaseline for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidResourceId "InvalidResourceId"
//   The resource ID is not valid. Verify that you entered the correct ID and
//   try again.
//
//   * ErrCodeDoesNotExistException "DoesNotExistException"
//   Error returned when the ID specified for a resource, such as a Maintenance
//   Window or Patch baseline, doesn't exist.
//
//   For information about resource limits in Systems Manager, see AWS Systems
//   Manager Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_ssm).
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterDefaultPatchBaseline
func (c *SSM) RegisterDefaultPatchBaseline(input *RegisterDefaultPatchBaselineInput) (*RegisterDefaultPatchBaselineOutput, error) {
	req, out := c.RegisterDefaultPatchBaselineRequest(input)
	return out, req.Send()
}

// RegisterDefaultPatchBaselineWithContext is the same as RegisterDefaultPatchBaseline with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterDefaultPatchBaseline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) RegisterDefaultPatchBaselineWithContext(ctx aws.Context, input *RegisterDefaultPatchBaselineInput, opts ...request.Option) (*RegisterDefaultPatchBaselineOutput, error) {
	req, out := c.RegisterDefaultPatchBaselineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterPatchBaselineForPatchGroup = "RegisterPatchBaselineForPatchGroup"

// RegisterPatchBaselineForPatchGroupRequest generates a "aws/request.Request" representing the
// client's request for the RegisterPatchBaselineForPatchGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterPatchBaselineForPatchGroup for more information on using the RegisterPatchBaselineForPatchGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterPatchBaselineForPatchGroupRequest method.
//    req, resp := client.RegisterPatchBaselineForPatchGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterPatchBaselineForPatchGroup
func (c *SSM) RegisterPatchBaselineForPatchGroupRequest(input *RegisterPatchBaselineForPatchGroupInput) (req *request.Request, output *RegisterPatchBaselineForPatchGroupOutput) {
	op := &request.Operation{
		Name:       opRegisterPatchBaselineForPatchGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterPatchBaselineForPatchGroupInput{}
	}

	output = &RegisterPatchBaselineForPatchGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterPatchBaselineForPatchGroup API operation for Amazon Simple Systems Manager (SSM).
//
// Registers a patch baseline for a patch group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation RegisterPatchBaselineForPatchGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAlreadyExistsException "AlreadyExistsException"
//   Error returned if an attempt is made to register a patch group with a patch
//   baseline that is already registered with a different patch baseline.
//
//   * ErrCodeDoesNotExistException "DoesNotExistException"
//   Error returned when the ID specified for a resource, such as a Maintenance
//   Window or Patch baseline, doesn't exist.
//
//   For information about resource limits in Systems Manager, see AWS Systems
//   Manager Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_ssm).
//
//   * ErrCodeInvalidResourceId "InvalidResourceId"
//   The resource ID is not valid. Verify that you entered the correct ID and
//   try again.
//
//   * ErrCodeResourceLimitExceededException "ResourceLimitExceededException"
//   Error returned when the caller has exceeded the default resource limits.
//   For example, too many Maintenance Windows or Patch baselines have been created.
//
//   For information about resource limits in Systems Manager, see AWS Systems
//   Manager Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_ssm).
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterPatchBaselineForPatchGroup
func (c *SSM) RegisterPatchBaselineForPatchGroup(input *RegisterPatchBaselineForPatchGroupInput) (*RegisterPatchBaselineForPatchGroupOutput, error) {
	req, out := c.RegisterPatchBaselineForPatchGroupRequest(input)
	return out, req.Send()
}

// RegisterPatchBaselineForPatchGroupWithContext is the same as RegisterPatchBaselineForPatchGroup with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterPatchBaselineForPatchGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) RegisterPatchBaselineForPatchGroupWithContext(ctx aws.Context, input *RegisterPatchBaselineForPatchGroupInput, opts ...request.Option) (*RegisterPatchBaselineForPatchGroupOutput, error) {
	req, out := c.RegisterPatchBaselineForPatchGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterTargetWithMaintenanceWindow = "RegisterTargetWithMaintenanceWindow"

// RegisterTargetWithMaintenanceWindowRequest generates a "aws/request.Request" representing the
// client's request for the RegisterTargetWithMaintenanceWindow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterTargetWithMaintenanceWindow for more information on using the RegisterTargetWithMaintenanceWindow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterTargetWithMaintenanceWindowRequest method.
//    req, resp := client.RegisterTargetWithMaintenanceWindowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterTargetWithMaintenanceWindow
func (c *SSM) RegisterTargetWithMaintenanceWindowRequest(input *RegisterTargetWithMaintenanceWindowInput) (req *request.Request, output *RegisterTargetWithMaintenanceWindowOutput) {
	op := &request.Operation{
		Name:       opRegisterTargetWithMaintenanceWindow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterTargetWithMaintenanceWindowInput{}
	}

	output = &RegisterTargetWithMaintenanceWindowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterTargetWithMaintenanceWindow API operation for Amazon Simple Systems Manager (SSM).
//
// Registers a target with a Maintenance Window.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation RegisterTargetWithMaintenanceWindow for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeIdempotentParameterMismatch "IdempotentParameterMismatch"
//   Error returned when an idempotent operation is retried and the parameters
//   don't match the original call to the API with the same idempotency token.
//
//   * ErrCodeDoesNotExistException "DoesNotExistException"
//   Error returned when the ID specified for a resource, such as a Maintenance
//   Window or Patch baseline, doesn't exist.
//
//   For information about resource limits in Systems Manager, see AWS Systems
//   Manager Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_ssm).
//
//   * ErrCodeResourceLimitExceededException "ResourceLimitExceededException"
//   Error returned when the caller has exceeded the default resource limits.
//   For example, too many Maintenance Windows or Patch baselines have been created.
//
//   For information about resource limits in Systems Manager, see AWS Systems
//   Manager Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_ssm).
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterTargetWithMaintenanceWindow
func (c *SSM) RegisterTargetWithMaintenanceWindow(input *RegisterTargetWithMaintenanceWindowInput) (*RegisterTargetWithMaintenanceWindowOutput, error) {
	req, out := c.RegisterTargetWithMaintenanceWindowRequest(input)
	return out, req.Send()
}

// RegisterTargetWithMaintenanceWindowWithContext is the same as RegisterTargetWithMaintenanceWindow with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterTargetWithMaintenanceWindow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) RegisterTargetWithMaintenanceWindowWithContext(ctx aws.Context, input *RegisterTargetWithMaintenanceWindowInput, opts ...request.Option) (*RegisterTargetWithMaintenanceWindowOutput, error) {
	req, out := c.RegisterTargetWithMaintenanceWindowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterTaskWithMaintenanceWindow = "RegisterTaskWithMaintenanceWindow"

// RegisterTaskWithMaintenanceWindowRequest generates a "aws/request.Request" representing the
// client's request for the RegisterTaskWithMaintenanceWindow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterTaskWithMaintenanceWindow for more information on using the RegisterTaskWithMaintenanceWindow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterTaskWithMaintenanceWindowRequest method.
//    req, resp := client.RegisterTaskWithMaintenanceWindowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterTaskWithMaintenanceWindow
func (c *SSM) RegisterTaskWithMaintenanceWindowRequest(input *RegisterTaskWithMaintenanceWindowInput) (req *request.Request, output *RegisterTaskWithMaintenanceWindowOutput) {
	op := &request.Operation{
		Name:       opRegisterTaskWithMaintenanceWindow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterTaskWithMaintenanceWindowInput{}
	}

	output = &RegisterTaskWithMaintenanceWindowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterTaskWithMaintenanceWindow API operation for Amazon Simple Systems Manager (SSM).
//
// Adds a new task to a Maintenance Window.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation RegisterTaskWithMaintenanceWindow for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeIdempotentParameterMismatch "IdempotentParameterMismatch"
//   Error returned when an idempotent operation is retried and the parameters
//   don't match the original call to the API with the same idempotency token.
//
//   * ErrCodeDoesNotExistException "DoesNotExistException"
//   Error returned when the ID specified for a resource, such as a Maintenance
//   Window or Patch baseline, doesn't exist.
//
//   For information about resource limits in Systems Manager, see AWS Systems
//   Manager Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_ssm).
//
//   * ErrCodeResourceLimitExceededException "ResourceLimitExceededException"
//   Error returned when the caller has exceeded the default resource limits.
//   For example, too many Maintenance Windows or Patch baselines have been created.
//
//   For information about resource limits in Systems Manager, see AWS Systems
//   Manager Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_ssm).
//
//   * ErrCodeFeatureNotAvailableException "FeatureNotAvailableException"
//   You attempted to register a LAMBDA or STEP_FUNCTION task in a region where
//   the corresponding service is not available.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterTaskWithMaintenanceWindow
func (c *SSM) RegisterTaskWithMaintenanceWindow(input *RegisterTaskWithMaintenanceWindowInput) (*RegisterTaskWithMaintenanceWindowOutput, error) {
	req, out := c.RegisterTaskWithMaintenanceWindowRequest(input)
	return out, req.Send()
}

// RegisterTaskWithMaintenanceWindowWithContext is the same as RegisterTaskWithMaintenanceWindow with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterTaskWithMaintenanceWindow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) RegisterTaskWithMaintenanceWindowWithContext(ctx aws.Context, input *RegisterTaskWithMaintenanceWindowInput, opts ...request.Option) (*RegisterTaskWithMaintenanceWindowOutput, error) {
	req, out := c.RegisterTaskWithMaintenanceWindowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveTagsFromResource = "RemoveTagsFromResource"

// RemoveTagsFromResourceRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTagsFromResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveTagsFromResource for more information on using the RemoveTagsFromResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveTagsFromResourceRequest method.
//    req, resp := client.RemoveTagsFromResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RemoveTagsFromResource
func (c *SSM) RemoveTagsFromResourceRequest(input *RemoveTagsFromResourceInput) (req *request.Request, output *RemoveTagsFromResourceOutput) {
	op := &request.Operation{
		Name:       opRemoveTagsFromResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsFromResourceInput{}
	}

	output = &RemoveTagsFromResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveTagsFromResource API operation for Amazon Simple Systems Manager (SSM).
//
// Removes all tags from the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation RemoveTagsFromResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidResourceType "InvalidResourceType"
//   The resource type is not valid. For example, if you are attempting to tag
//   an instance, the instance must be a registered, managed instance.
//
//   * ErrCodeInvalidResourceId "InvalidResourceId"
//   The resource ID is not valid. Verify that you entered the correct ID and
//   try again.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeTooManyUpdates "TooManyUpdates"
//   There are concurrent updates for a resource that supports one update at a
//   time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RemoveTagsFromResource
func (c *SSM) RemoveTagsFromResource(input *RemoveTagsFromResourceInput) (*RemoveTagsFromResourceOutput, error) {
	req, out := c.RemoveTagsFromResourceRequest(input)
	return out, req.Send()
}

// RemoveTagsFromResourceWithContext is the same as RemoveTagsFromResource with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveTagsFromResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) RemoveTagsFromResourceWithContext(ctx aws.Context, input *RemoveTagsFromResourceInput, opts ...request.Option) (*RemoveTagsFromResourceOutput, error) {
	req, out := c.RemoveTagsFromResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResumeSession = "ResumeSession"

// ResumeSessionRequest generates a "aws/request.Request" representing the
// client's request for the ResumeSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResumeSession for more information on using the ResumeSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ResumeSessionRequest method.
//    req, resp := client.ResumeSessionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ResumeSession
func (c *SSM) ResumeSessionRequest(input *ResumeSessionInput) (req *request.Request, output *ResumeSessionOutput) {
	op := &request.Operation{
		Name:       opResumeSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResumeSessionInput{}
	}

	output = &ResumeSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ResumeSession API operation for Amazon Simple Systems Manager (SSM).
//
// Reconnects a session to an instance after it has been disconnected. Connections
// can be resumed for disconnected sessions, but not terminated sessions.
//
// This command is primarily for use by client machines to automatically reconnect
// during intermittent network issues. It is not intended for any other use.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation ResumeSession for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDoesNotExistException "DoesNotExistException"
//   Error returned when the ID specified for a resource, such as a Maintenance
//   Window or Patch baseline, doesn't exist.
//
//   For information about resource limits in Systems Manager, see AWS Systems
//   Manager Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_ssm).
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ResumeSession
func (c *SSM) ResumeSession(input *ResumeSessionInput) (*ResumeSessionOutput, error) {
	req, out := c.ResumeSessionRequest(input)
	return out, req.Send()
}

// ResumeSessionWithContext is the same as ResumeSession with the addition of
// the ability to pass a context and additional request options.
//
// See ResumeSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) ResumeSessionWithContext(ctx aws.Context, input *ResumeSessionInput, opts ...request.Option) (*ResumeSessionOutput, error) {
	req, out := c.ResumeSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendAutomationSignal = "SendAutomationSignal"

// SendAutomationSignalRequest generates a "aws/request.Request" representing the
// client's request for the SendAutomationSignal operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendAutomationSignal for more information on using the SendAutomationSignal
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SendAutomationSignalRequest method.
//    req, resp := client.SendAutomationSignalRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/SendAutomationSignal
func (c *SSM) SendAutomationSignalRequest(input *SendAutomationSignalInput) (req *request.Request, output *SendAutomationSignalOutput) {
	op := &request.Operation{
		Name:       opSendAutomationSignal,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendAutomationSignalInput{}
	}

	output = &SendAutomationSignalOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SendAutomationSignal API operation for Amazon Simple Systems Manager (SSM).
//
// Sends a signal to an Automation execution to change the current behavior
// or status of the execution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation SendAutomationSignal for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAutomationExecutionNotFoundException "AutomationExecutionNotFoundException"
//   There is no automation execution information for the requested automation
//   execution ID.
//
//   * ErrCodeAutomationStepNotFoundException "AutomationStepNotFoundException"
//   The specified step name and execution ID don't exist. Verify the information
//   and try again.
//
//   * ErrCodeInvalidAutomationSignalException "InvalidAutomationSignalException"
//   The signal is not valid for the current Automation execution.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/SendAutomationSignal
func (c *SSM) SendAutomationSignal(input *SendAutomationSignalInput) (*SendAutomationSignalOutput, error) {
	req, out := c.SendAutomationSignalRequest(input)
	return out, req.Send()
}

// SendAutomationSignalWithContext is the same as SendAutomationSignal with the addition of
// the ability to pass a context and additional request options.
//
// See SendAutomationSignal for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) SendAutomationSignalWithContext(ctx aws.Context, input *SendAutomationSignalInput, opts ...request.Option) (*SendAutomationSignalOutput, error) {
	req, out := c.SendAutomationSignalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendCommand = "SendCommand"

// SendCommandRequest generates a "aws/request.Request" representing the
// client's request for the SendCommand operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendCommand for more information on using the SendCommand
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SendCommandRequest method.
//    req, resp := client.SendCommandRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/SendCommand
func (c *SSM) SendCommandRequest(input *SendCommandInput) (req *request.Request, output *SendCommandOutput) {
	op := &request.Operation{
		Name:       opSendCommand,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendCommandInput{}
	}

	output = &SendCommandOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendCommand API operation for Amazon Simple Systems Manager (SSM).
//
// Executes commands on one or more managed instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation SendCommand for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDuplicateInstanceId "DuplicateInstanceId"
//   You cannot specify an instance ID in more than one association.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidInstanceId "InvalidInstanceId"
//   The following problems can cause this exception:
//
//   You do not have permission to access the instance.
//
//   SSM Agent is not running. On managed instances and Linux instances, verify
//   that the SSM Agent is running. On EC2 Windows instances, verify that the
//   EC2Config service is running.
//
//   SSM Agent or EC2Config service is not registered to the SSM endpoint. Try
//   reinstalling SSM Agent or EC2Config service.
//
//   The instance is not in valid state. Valid states are: Running, Pending, Stopped,
//   Stopping. Invalid states are: Shutting-down and Terminated.
//
//   * ErrCodeInvalidDocument "InvalidDocument"
//   The specified document does not exist.
//
//   * ErrCodeInvalidDocumentVersion "InvalidDocumentVersion"
//   The document version is not valid or does not exist.
//
//   * ErrCodeInvalidOutputFolder "InvalidOutputFolder"
//   The S3 bucket does not exist.
//
//   * ErrCodeInvalidParameters "InvalidParameters"
//   You must specify values for all required parameters in the Systems Manager
//   document. You can only supply values to parameters defined in the Systems
//   Manager document.
//
//   * ErrCodeUnsupportedPlatformType "UnsupportedPlatformType"
//   The document does not support the platform type of the given instance ID(s).
//   For example, you sent an document for a Windows instance to a Linux instance.
//
//   * ErrCodeMaxDocumentSizeExceeded "MaxDocumentSizeExceeded"
//   The size limit of a document is 64 KB.
//
//   * ErrCodeInvalidRole "InvalidRole"
//   The role name can't contain invalid characters. Also verify that you specified
//   an IAM role for notifications that includes the required trust policy. For
//   information about configuring the IAM role for Run Command notifications,
//   see Configuring Amazon SNS Notifications for Run Command (http://docs.aws.amazon.com/systems-manager/latest/userguide/rc-sns-notifications.html)
//   in the AWS Systems Manager User Guide.
//
//   * ErrCodeInvalidNotificationConfig "InvalidNotificationConfig"
//   One or more configuration items is not valid. Verify that a valid Amazon
//   Resource Name (ARN) was provided for an Amazon SNS topic.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/SendCommand
func (c *SSM) SendCommand(input *SendCommandInput) (*SendCommandOutput, error) {
	req, out := c.SendCommandRequest(input)
	return out, req.Send()
}

// SendCommandWithContext is the same as SendCommand with the addition of
// the ability to pass a context and additional request options.
//
// See SendCommand for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) SendCommandWithContext(ctx aws.Context, input *SendCommandInput, opts ...request.Option) (*SendCommandOutput, error) {
	req, out := c.SendCommandRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartAssociationsOnce = "StartAssociationsOnce"

// StartAssociationsOnceRequest generates a "aws/request.Request" representing the
// client's request for the StartAssociationsOnce operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartAssociationsOnce for more information on using the StartAssociationsOnce
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartAssociationsOnceRequest method.
//    req, resp := client.StartAssociationsOnceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StartAssociationsOnce
func (c *SSM) StartAssociationsOnceRequest(input *StartAssociationsOnceInput) (req *request.Request, output *StartAssociationsOnceOutput) {
	op := &request.Operation{
		Name:       opStartAssociationsOnce,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartAssociationsOnceInput{}
	}

	output = &StartAssociationsOnceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartAssociationsOnce API operation for Amazon Simple Systems Manager (SSM).
//
// Use this API action to execute an association immediately and only one time.
// This action can be helpful when troubleshooting associations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation StartAssociationsOnce for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidAssociation "InvalidAssociation"
//   The association is not valid or does not exist.
//
//   * ErrCodeAssociationDoesNotExist "AssociationDoesNotExist"
//   The specified association does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StartAssociationsOnce
func (c *SSM) StartAssociationsOnce(input *StartAssociationsOnceInput) (*StartAssociationsOnceOutput, error) {
	req, out := c.StartAssociationsOnceRequest(input)
	return out, req.Send()
}

// StartAssociationsOnceWithContext is the same as StartAssociationsOnce with the addition of
// the ability to pass a context and additional request options.
//
// See StartAssociationsOnce for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) StartAssociationsOnceWithContext(ctx aws.Context, input *StartAssociationsOnceInput, opts ...request.Option) (*StartAssociationsOnceOutput, error) {
	req, out := c.StartAssociationsOnceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartAutomationExecution = "StartAutomationExecution"

// StartAutomationExecutionRequest generates a "aws/request.Request" representing the
// client's request for the StartAutomationExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartAutomationExecution for more information on using the StartAutomationExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartAutomationExecutionRequest method.
//    req, resp := client.StartAutomationExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StartAutomationExecution
func (c *SSM) StartAutomationExecutionRequest(input *StartAutomationExecutionInput) (req *request.Request, output *StartAutomationExecutionOutput) {
	op := &request.Operation{
		Name:       opStartAutomationExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartAutomationExecutionInput{}
	}

	output = &StartAutomationExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartAutomationExecution API operation for Amazon Simple Systems Manager (SSM).
//
// Initiates execution of an Automation document.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation StartAutomationExecution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAutomationDefinitionNotFoundException "AutomationDefinitionNotFoundException"
//   An Automation document with the specified name could not be found.
//
//   * ErrCodeInvalidAutomationExecutionParametersException "InvalidAutomationExecutionParametersException"
//   The supplied parameters for invoking the specified Automation document are
//   incorrect. For example, they may not match the set of parameters permitted
//   for the specified Automation document.
//
//   * ErrCodeAutomationExecutionLimitExceededException "AutomationExecutionLimitExceededException"
//   The number of simultaneously running Automation executions exceeded the allowable
//   limit.
//
//   * ErrCodeAutomationDefinitionVersionNotFoundException "AutomationDefinitionVersionNotFoundException"
//   An Automation document with the specified name and version could not be found.
//
//   * ErrCodeIdempotentParameterMismatch "IdempotentParameterMismatch"
//   Error returned when an idempotent operation is retried and the parameters
//   don't match the original call to the API with the same idempotency token.
//
//   * ErrCodeInvalidTarget "InvalidTarget"
//   The target is not valid or does not exist. It might not be configured for
//   EC2 Systems Manager or you might not have permission to perform the operation.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StartAutomationExecution
func (c *SSM) StartAutomationExecution(input *StartAutomationExecutionInput) (*StartAutomationExecutionOutput, error) {
	req, out := c.StartAutomationExecutionRequest(input)
	return out, req.Send()
}

// StartAutomationExecutionWithContext is the same as StartAutomationExecution with the addition of
// the ability to pass a context and additional request options.
//
// See StartAutomationExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) StartAutomationExecutionWithContext(ctx aws.Context, input *StartAutomationExecutionInput, opts ...request.Option) (*StartAutomationExecutionOutput, error) {
	req, out := c.StartAutomationExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartSession = "StartSession"

// StartSessionRequest generates a "aws/request.Request" representing the
// client's request for the StartSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartSession for more information on using the StartSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartSessionRequest method.
//    req, resp := client.StartSessionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StartSession
func (c *SSM) StartSessionRequest(input *StartSessionInput) (req *request.Request, output *StartSessionOutput) {
	op := &request.Operation{
		Name:       opStartSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartSessionInput{}
	}

	output = &StartSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartSession API operation for Amazon Simple Systems Manager (SSM).
//
// Initiates a connection to a target (for example, an instance) for a Session
// Manager session. Returns a URL and token that can be used to open a WebSocket
// connection for sending input and receiving outputs.
//
// AWS CLI usage: start-session is an interactive command that requires the
// Session Manager plugin to be installed on the client machine making the call.
// For information, see  Install the Session Manager Plugin for the AWS CLI
// (http://docs.aws.amazon.com/systems-manager/latest/userguide/session-manager-working-with-install-plugin.html)
// in the AWS Systems Manager User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation StartSession for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDocument "InvalidDocument"
//   The specified document does not exist.
//
//   * ErrCodeTargetNotConnected "TargetNotConnected"
//   The specified target instance for the session is not fully configured for
//   use with Session Manager. For more information, see Getting Started with
//   Session Manager (http://docs.aws.amazon.com/systems-manager/latest/userguide/session-manager-getting-started.html)
//   in the AWS Systems Manager User Guide.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StartSession
func (c *SSM) StartSession(input *StartSessionInput) (*StartSessionOutput, error) {
	req, out := c.StartSessionRequest(input)
	return out, req.Send()
}

// StartSessionWithContext is the same as StartSession with the addition of
// the ability to pass a context and additional request options.
//
// See StartSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) StartSessionWithContext(ctx aws.Context, input *StartSessionInput, opts ...request.Option) (*StartSessionOutput, error) {
	req, out := c.StartSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopAutomationExecution = "StopAutomationExecution"

// StopAutomationExecutionRequest generates a "aws/request.Request" representing the
// client's request for the StopAutomationExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopAutomationExecution for more information on using the StopAutomationExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopAutomationExecutionRequest method.
//    req, resp := client.StopAutomationExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StopAutomationExecution
func (c *SSM) StopAutomationExecutionRequest(input *StopAutomationExecutionInput) (req *request.Request, output *StopAutomationExecutionOutput) {
	op := &request.Operation{
		Name:       opStopAutomationExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopAutomationExecutionInput{}
	}

	output = &StopAutomationExecutionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopAutomationExecution API operation for Amazon Simple Systems Manager (SSM).
//
// Stop an Automation that is currently executing.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation StopAutomationExecution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAutomationExecutionNotFoundException "AutomationExecutionNotFoundException"
//   There is no automation execution information for the requested automation
//   execution ID.
//
//   * ErrCodeInvalidAutomationStatusUpdateException "InvalidAutomationStatusUpdateException"
//   The specified update status operation is not valid.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StopAutomationExecution
func (c *SSM) StopAutomationExecution(input *StopAutomationExecutionInput) (*StopAutomationExecutionOutput, error) {
	req, out := c.StopAutomationExecutionRequest(input)
	return out, req.Send()
}

// StopAutomationExecutionWithContext is the same as StopAutomationExecution with the addition of
// the ability to pass a context and additional request options.
//
// See StopAutomationExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) StopAutomationExecutionWithContext(ctx aws.Context, input *StopAutomationExecutionInput, opts ...request.Option) (*StopAutomationExecutionOutput, error) {
	req, out := c.StopAutomationExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTerminateSession = "TerminateSession"

// TerminateSessionRequest generates a "aws/request.Request" representing the
// client's request for the TerminateSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TerminateSession for more information on using the TerminateSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TerminateSessionRequest method.
//    req, resp := client.TerminateSessionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/TerminateSession
func (c *SSM) TerminateSessionRequest(input *TerminateSessionInput) (req *request.Request, output *TerminateSessionOutput) {
	op := &request.Operation{
		Name:       opTerminateSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TerminateSessionInput{}
	}

	output = &TerminateSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TerminateSession API operation for Amazon Simple Systems Manager (SSM).
//
// Permanently ends a session and closes the data connection between the Session
// Manager client and SSM Agent on the instance. A terminated session cannot
// be resumed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation TerminateSession for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDoesNotExistException "DoesNotExistException"
//   Error returned when the ID specified for a resource, such as a Maintenance
//   Window or Patch baseline, doesn't exist.
//
//   For information about resource limits in Systems Manager, see AWS Systems
//   Manager Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_ssm).
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/TerminateSession
func (c *SSM) TerminateSession(input *TerminateSessionInput) (*TerminateSessionOutput, error) {
	req, out := c.TerminateSessionRequest(input)
	return out, req.Send()
}

// TerminateSessionWithContext is the same as TerminateSession with the addition of
// the ability to pass a context and additional request options.
//
// See TerminateSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) TerminateSessionWithContext(ctx aws.Context, input *TerminateSessionInput, opts ...request.Option) (*TerminateSessionOutput, error) {
	req, out := c.TerminateSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAssociation = "UpdateAssociation"

// UpdateAssociationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAssociation for more information on using the UpdateAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAssociationRequest method.
//    req, resp := client.UpdateAssociationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateAssociation
func (c *SSM) UpdateAssociationRequest(input *UpdateAssociationInput) (req *request.Request, output *UpdateAssociationOutput) {
	op := &request.Operation{
		Name:       opUpdateAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAssociationInput{}
	}

	output = &UpdateAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAssociation API operation for Amazon Simple Systems Manager (SSM).
//
// Updates an association. You can update the association name and version,
// the document version, schedule, parameters, and Amazon S3 output.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation UpdateAssociation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidSchedule "InvalidSchedule"
//   The schedule is invalid. Verify your cron or rate expression and try again.
//
//   * ErrCodeInvalidParameters "InvalidParameters"
//   You must specify values for all required parameters in the Systems Manager
//   document. You can only supply values to parameters defined in the Systems
//   Manager document.
//
//   * ErrCodeInvalidOutputLocation "InvalidOutputLocation"
//   The output location is not valid or does not exist.
//
//   * ErrCodeInvalidDocumentVersion "InvalidDocumentVersion"
//   The document version is not valid or does not exist.
//
//   * ErrCodeAssociationDoesNotExist "AssociationDoesNotExist"
//   The specified association does not exist.
//
//   * ErrCodeInvalidUpdate "InvalidUpdate"
//   The update is not valid.
//
//   * ErrCodeTooManyUpdates "TooManyUpdates"
//   There are concurrent updates for a resource that supports one update at a
//   time.
//
//   * ErrCodeInvalidDocument "InvalidDocument"
//   The specified document does not exist.
//
//   * ErrCodeInvalidTarget "InvalidTarget"
//   The target is not valid or does not exist. It might not be configured for
//   EC2 Systems Manager or you might not have permission to perform the operation.
//
//   * ErrCodeInvalidAssociationVersion "InvalidAssociationVersion"
//   The version you specified is not valid. Use ListAssociationVersions to view
//   all versions of an association according to the association ID. Or, use the
//   $LATEST parameter to view the latest version of the association.
//
//   * ErrCodeAssociationVersionLimitExceeded "AssociationVersionLimitExceeded"
//   You have reached the maximum number versions allowed for an association.
//   Each association has a limit of 1,000 versions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateAssociation
func (c *SSM) UpdateAssociation(input *UpdateAssociationInput) (*UpdateAssociationOutput, error) {
	req, out := c.UpdateAssociationRequest(input)
	return out, req.Send()
}

// UpdateAssociationWithContext is the same as UpdateAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) UpdateAssociationWithContext(ctx aws.Context, input *UpdateAssociationInput, opts ...request.Option) (*UpdateAssociationOutput, error) {
	req, out := c.UpdateAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAssociationStatus = "UpdateAssociationStatus"

// UpdateAssociationStatusRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAssociationStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAssociationStatus for more information on using the UpdateAssociationStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAssociationStatusRequest method.
//    req, resp := client.UpdateAssociationStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateAssociationStatus
func (c *SSM) UpdateAssociationStatusRequest(input *UpdateAssociationStatusInput) (req *request.Request, output *UpdateAssociationStatusOutput) {
	op := &request.Operation{
		Name:       opUpdateAssociationStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAssociationStatusInput{}
	}

	output = &UpdateAssociationStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAssociationStatus API operation for Amazon Simple Systems Manager (SSM).
//
// Updates the status of the Systems Manager document associated with the specified
// instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation UpdateAssociationStatus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidInstanceId "InvalidInstanceId"
//   The following problems can cause this exception:
//
//   You do not have permission to access the instance.
//
//   SSM Agent is not running. On managed instances and Linux instances, verify
//   that the SSM Agent is running. On EC2 Windows instances, verify that the
//   EC2Config service is running.
//
//   SSM Agent or EC2Config service is not registered to the SSM endpoint. Try
//   reinstalling SSM Agent or EC2Config service.
//
//   The instance is not in valid state. Valid states are: Running, Pending, Stopped,
//   Stopping. Invalid states are: Shutting-down and Terminated.
//
//   * ErrCodeInvalidDocument "InvalidDocument"
//   The specified document does not exist.
//
//   * ErrCodeAssociationDoesNotExist "AssociationDoesNotExist"
//   The specified association does not exist.
//
//   * ErrCodeStatusUnchanged "StatusUnchanged"
//   The updated status is the same as the current status.
//
//   * ErrCodeTooManyUpdates "TooManyUpdates"
//   There are concurrent updates for a resource that supports one update at a
//   time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateAssociationStatus
func (c *SSM) UpdateAssociationStatus(input *UpdateAssociationStatusInput) (*UpdateAssociationStatusOutput, error) {
	req, out := c.UpdateAssociationStatusRequest(input)
	return out, req.Send()
}

// UpdateAssociationStatusWithContext is the same as UpdateAssociationStatus with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAssociationStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) UpdateAssociationStatusWithContext(ctx aws.Context, input *UpdateAssociationStatusInput, opts ...request.Option) (*UpdateAssociationStatusOutput, error) {
	req, out := c.UpdateAssociationStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDocument = "UpdateDocument"

// UpdateDocumentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDocument operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDocument for more information on using the UpdateDocument
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDocumentRequest method.
//    req, resp := client.UpdateDocumentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateDocument
func (c *SSM) UpdateDocumentRequest(input *UpdateDocumentInput) (req *request.Request, output *UpdateDocumentOutput) {
	op := &request.Operation{
		Name:       opUpdateDocument,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDocumentInput{}
	}

	output = &UpdateDocumentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDocument API operation for Amazon Simple Systems Manager (SSM).
//
// The document you want to update.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation UpdateDocument for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeMaxDocumentSizeExceeded "MaxDocumentSizeExceeded"
//   The size limit of a document is 64 KB.
//
//   * ErrCodeDocumentVersionLimitExceeded "DocumentVersionLimitExceeded"
//   The document has too many versions. Delete one or more document versions
//   and try again.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeDuplicateDocumentContent "DuplicateDocumentContent"
//   The content of the association document matches another document. Change
//   the content of the document and try again.
//
//   * ErrCodeDuplicateDocumentVersionName "DuplicateDocumentVersionName"
//   The version name has already been used in this document. Specify a different
//   version name, and then try again.
//
//   * ErrCodeInvalidDocumentContent "InvalidDocumentContent"
//   The content for the document is not valid.
//
//   * ErrCodeInvalidDocumentVersion "InvalidDocumentVersion"
//   The document version is not valid or does not exist.
//
//   * ErrCodeInvalidDocumentSchemaVersion "InvalidDocumentSchemaVersion"
//   The version of the document schema is not supported.
//
//   * ErrCodeInvalidDocument "InvalidDocument"
//   The specified document does not exist.
//
//   * ErrCodeInvalidDocumentOperation "InvalidDocumentOperation"
//   You attempted to delete a document while it is still shared. You must stop
//   sharing the document before you can delete it.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateDocument
func (c *SSM) UpdateDocument(input *UpdateDocumentInput) (*UpdateDocumentOutput, error) {
	req, out := c.UpdateDocumentRequest(input)
	return out, req.Send()
}

// UpdateDocumentWithContext is the same as UpdateDocument with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDocument for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) UpdateDocumentWithContext(ctx aws.Context, input *UpdateDocumentInput, opts ...request.Option) (*UpdateDocumentOutput, error) {
	req, out := c.UpdateDocumentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDocumentDefaultVersion = "UpdateDocumentDefaultVersion"

// UpdateDocumentDefaultVersionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDocumentDefaultVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDocumentDefaultVersion for more information on using the UpdateDocumentDefaultVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDocumentDefaultVersionRequest method.
//    req, resp := client.UpdateDocumentDefaultVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateDocumentDefaultVersion
func (c *SSM) UpdateDocumentDefaultVersionRequest(input *UpdateDocumentDefaultVersionInput) (req *request.Request, output *UpdateDocumentDefaultVersionOutput) {
	op := &request.Operation{
		Name:       opUpdateDocumentDefaultVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDocumentDefaultVersionInput{}
	}

	output = &UpdateDocumentDefaultVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDocumentDefaultVersion API operation for Amazon Simple Systems Manager (SSM).
//
// Set the default version of a document.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation UpdateDocumentDefaultVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeInvalidDocument "InvalidDocument"
//   The specified document does not exist.
//
//   * ErrCodeInvalidDocumentVersion "InvalidDocumentVersion"
//   The document version is not valid or does not exist.
//
//   * ErrCodeInvalidDocumentSchemaVersion "InvalidDocumentSchemaVersion"
//   The version of the document schema is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateDocumentDefaultVersion
func (c *SSM) UpdateDocumentDefaultVersion(input *UpdateDocumentDefaultVersionInput) (*UpdateDocumentDefaultVersionOutput, error) {
	req, out := c.UpdateDocumentDefaultVersionRequest(input)
	return out, req.Send()
}

// UpdateDocumentDefaultVersionWithContext is the same as UpdateDocumentDefaultVersion with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDocumentDefaultVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) UpdateDocumentDefaultVersionWithContext(ctx aws.Context, input *UpdateDocumentDefaultVersionInput, opts ...request.Option) (*UpdateDocumentDefaultVersionOutput, error) {
	req, out := c.UpdateDocumentDefaultVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMaintenanceWindow = "UpdateMaintenanceWindow"

// UpdateMaintenanceWindowRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMaintenanceWindow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMaintenanceWindow for more information on using the UpdateMaintenanceWindow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateMaintenanceWindowRequest method.
//    req, resp := client.UpdateMaintenanceWindowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateMaintenanceWindow
func (c *SSM) UpdateMaintenanceWindowRequest(input *UpdateMaintenanceWindowInput) (req *request.Request, output *UpdateMaintenanceWindowOutput) {
	op := &request.Operation{
		Name:       opUpdateMaintenanceWindow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateMaintenanceWindowInput{}
	}

	output = &UpdateMaintenanceWindowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateMaintenanceWindow API operation for Amazon Simple Systems Manager (SSM).
//
// Updates an existing Maintenance Window. Only specified parameters are modified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation UpdateMaintenanceWindow for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDoesNotExistException "DoesNotExistException"
//   Error returned when the ID specified for a resource, such as a Maintenance
//   Window or Patch baseline, doesn't exist.
//
//   For information about resource limits in Systems Manager, see AWS Systems
//   Manager Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_ssm).
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateMaintenanceWindow
func (c *SSM) UpdateMaintenanceWindow(input *UpdateMaintenanceWindowInput) (*UpdateMaintenanceWindowOutput, error) {
	req, out := c.UpdateMaintenanceWindowRequest(input)
	return out, req.Send()
}

// UpdateMaintenanceWindowWithContext is the same as UpdateMaintenanceWindow with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMaintenanceWindow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) UpdateMaintenanceWindowWithContext(ctx aws.Context, input *UpdateMaintenanceWindowInput, opts ...request.Option) (*UpdateMaintenanceWindowOutput, error) {
	req, out := c.UpdateMaintenanceWindowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMaintenanceWindowTarget = "UpdateMaintenanceWindowTarget"

// UpdateMaintenanceWindowTargetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMaintenanceWindowTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMaintenanceWindowTarget for more information on using the UpdateMaintenanceWindowTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateMaintenanceWindowTargetRequest method.
//    req, resp := client.UpdateMaintenanceWindowTargetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateMaintenanceWindowTarget
func (c *SSM) UpdateMaintenanceWindowTargetRequest(input *UpdateMaintenanceWindowTargetInput) (req *request.Request, output *UpdateMaintenanceWindowTargetOutput) {
	op := &request.Operation{
		Name:       opUpdateMaintenanceWindowTarget,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateMaintenanceWindowTargetInput{}
	}

	output = &UpdateMaintenanceWindowTargetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateMaintenanceWindowTarget API operation for Amazon Simple Systems Manager (SSM).
//
// Modifies the target of an existing Maintenance Window. You can't change the
// target type, but you can change the following:
//
// The target from being an ID target to a Tag target, or a Tag target to an
// ID target.
//
// IDs for an ID target.
//
// Tags for a Tag target.
//
// Owner.
//
// Name.
//
// Description.
//
// If a parameter is null, then the corresponding field is not modified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation UpdateMaintenanceWindowTarget for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDoesNotExistException "DoesNotExistException"
//   Error returned when the ID specified for a resource, such as a Maintenance
//   Window or Patch baseline, doesn't exist.
//
//   For information about resource limits in Systems Manager, see AWS Systems
//   Manager Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_ssm).
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateMaintenanceWindowTarget
func (c *SSM) UpdateMaintenanceWindowTarget(input *UpdateMaintenanceWindowTargetInput) (*UpdateMaintenanceWindowTargetOutput, error) {
	req, out := c.UpdateMaintenanceWindowTargetRequest(input)
	return out, req.Send()
}

// UpdateMaintenanceWindowTargetWithContext is the same as UpdateMaintenanceWindowTarget with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMaintenanceWindowTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) UpdateMaintenanceWindowTargetWithContext(ctx aws.Context, input *UpdateMaintenanceWindowTargetInput, opts ...request.Option) (*UpdateMaintenanceWindowTargetOutput, error) {
	req, out := c.UpdateMaintenanceWindowTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMaintenanceWindowTask = "UpdateMaintenanceWindowTask"

// UpdateMaintenanceWindowTaskRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMaintenanceWindowTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMaintenanceWindowTask for more information on using the UpdateMaintenanceWindowTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateMaintenanceWindowTaskRequest method.
//    req, resp := client.UpdateMaintenanceWindowTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateMaintenanceWindowTask
func (c *SSM) UpdateMaintenanceWindowTaskRequest(input *UpdateMaintenanceWindowTaskInput) (req *request.Request, output *UpdateMaintenanceWindowTaskOutput) {
	op := &request.Operation{
		Name:       opUpdateMaintenanceWindowTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateMaintenanceWindowTaskInput{}
	}

	output = &UpdateMaintenanceWindowTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateMaintenanceWindowTask API operation for Amazon Simple Systems Manager (SSM).
//
// Modifies a task assigned to a Maintenance Window. You can't change the task
// type, but you can change the following values:
//
//    * TaskARN. For example, you can change a RUN_COMMAND task from AWS-RunPowerShellScript
//    to AWS-RunShellScript.
//
//    * ServiceRoleArn
//
//    * TaskInvocationParameters
//
//    * Priority
//
//    * MaxConcurrency
//
//    * MaxErrors
//
// If a parameter is null, then the corresponding field is not modified. Also,
// if you set Replace to true, then all fields required by the RegisterTaskWithMaintenanceWindow
// action are required for this request. Optional fields that aren't specified
// are set to null.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation UpdateMaintenanceWindowTask for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDoesNotExistException "DoesNotExistException"
//   Error returned when the ID specified for a resource, such as a Maintenance
//   Window or Patch baseline, doesn't exist.
//
//   For information about resource limits in Systems Manager, see AWS Systems
//   Manager Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_ssm).
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateMaintenanceWindowTask
func (c *SSM) UpdateMaintenanceWindowTask(input *UpdateMaintenanceWindowTaskInput) (*UpdateMaintenanceWindowTaskOutput, error) {
	req, out := c.UpdateMaintenanceWindowTaskRequest(input)
	return out, req.Send()
}

// UpdateMaintenanceWindowTaskWithContext is the same as UpdateMaintenanceWindowTask with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMaintenanceWindowTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) UpdateMaintenanceWindowTaskWithContext(ctx aws.Context, input *UpdateMaintenanceWindowTaskInput, opts ...request.Option) (*UpdateMaintenanceWindowTaskOutput, error) {
	req, out := c.UpdateMaintenanceWindowTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateManagedInstanceRole = "UpdateManagedInstanceRole"

// UpdateManagedInstanceRoleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateManagedInstanceRole operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateManagedInstanceRole for more information on using the UpdateManagedInstanceRole
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateManagedInstanceRoleRequest method.
//    req, resp := client.UpdateManagedInstanceRoleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateManagedInstanceRole
func (c *SSM) UpdateManagedInstanceRoleRequest(input *UpdateManagedInstanceRoleInput) (req *request.Request, output *UpdateManagedInstanceRoleOutput) {
	op := &request.Operation{
		Name:       opUpdateManagedInstanceRole,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateManagedInstanceRoleInput{}
	}

	output = &UpdateManagedInstanceRoleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateManagedInstanceRole API operation for Amazon Simple Systems Manager (SSM).
//
// Assigns or changes an Amazon Identity and Access Management (IAM) role to
// the managed instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation UpdateManagedInstanceRole for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInstanceId "InvalidInstanceId"
//   The following problems can cause this exception:
//
//   You do not have permission to access the instance.
//
//   SSM Agent is not running. On managed instances and Linux instances, verify
//   that the SSM Agent is running. On EC2 Windows instances, verify that the
//   EC2Config service is running.
//
//   SSM Agent or EC2Config service is not registered to the SSM endpoint. Try
//   reinstalling SSM Agent or EC2Config service.
//
//   The instance is not in valid state. Valid states are: Running, Pending, Stopped,
//   Stopping. Invalid states are: Shutting-down and Terminated.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateManagedInstanceRole
func (c *SSM) UpdateManagedInstanceRole(input *UpdateManagedInstanceRoleInput) (*UpdateManagedInstanceRoleOutput, error) {
	req, out := c.UpdateManagedInstanceRoleRequest(input)
	return out, req.Send()
}

// UpdateManagedInstanceRoleWithContext is the same as UpdateManagedInstanceRole with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateManagedInstanceRole for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) UpdateManagedInstanceRoleWithContext(ctx aws.Context, input *UpdateManagedInstanceRoleInput, opts ...request.Option) (*UpdateManagedInstanceRoleOutput, error) {
	req, out := c.UpdateManagedInstanceRoleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePatchBaseline = "UpdatePatchBaseline"

// UpdatePatchBaselineRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePatchBaseline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePatchBaseline for more information on using the UpdatePatchBaseline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdatePatchBaselineRequest method.
//    req, resp := client.UpdatePatchBaselineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdatePatchBaseline
func (c *SSM) UpdatePatchBaselineRequest(input *UpdatePatchBaselineInput) (req *request.Request, output *UpdatePatchBaselineOutput) {
	op := &request.Operation{
		Name:       opUpdatePatchBaseline,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdatePatchBaselineInput{}
	}

	output = &UpdatePatchBaselineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePatchBaseline API operation for Amazon Simple Systems Manager (SSM).
//
// Modifies an existing patch baseline. Fields not specified in the request
// are left unchanged.
//
// For information about valid key and value pairs in PatchFilters for each
// supported operating system type, see PatchFilter (http://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Systems Manager (SSM)'s
// API operation UpdatePatchBaseline for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDoesNotExistException "DoesNotExistException"
//   Error returned when the ID specified for a resource, such as a Maintenance
//   Window or Patch baseline, doesn't exist.
//
//   For information about resource limits in Systems Manager, see AWS Systems
//   Manager Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_ssm).
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdatePatchBaseline
func (c *SSM) UpdatePatchBaseline(input *UpdatePatchBaselineInput) (*UpdatePatchBaselineOutput, error) {
	req, out := c.UpdatePatchBaselineRequest(input)
	return out, req.Send()
}

// UpdatePatchBaselineWithContext is the same as UpdatePatchBaseline with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePatchBaseline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSM) UpdatePatchBaselineWithContext(ctx aws.Context, input *UpdatePatchBaselineInput, opts ...request.Option) (*UpdatePatchBaselineOutput, error) {
	req, out := c.UpdatePatchBaselineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// An activation registers one or more on-premises servers or virtual machines
// (VMs) with AWS so that you can configure those servers or VMs using Run Command.
// A server or VM that has been registered with AWS is called a managed instance.
type Activation struct {
	_ struct{} `type:"structure"`

	// The ID created by Systems Manager when you submitted the activation.
	ActivationId *string `type:"string"`

	// The date the activation was created.
	CreatedDate *time.Time `type:"timestamp"`

	// A name for the managed instance when it is created.
	DefaultInstanceName *string `type:"string"`

	// A user defined description of the activation.
	Description *string `type:"string"`

	// The date when this activation can no longer be used to register managed instances.
	ExpirationDate *time.Time `type:"timestamp"`

	// Whether or not the activation is expired.
	Expired *bool `type:"boolean"`

	// The Amazon Identity and Access Management (IAM) role to assign to the managed
	// instance.
	IamRole *string `type:"string"`

	// The maximum number of managed instances that can be registered using this
	// activation.
	RegistrationLimit *int64 `min:"1" type:"integer"`

	// The number of managed instances already registered with this activation.
	RegistrationsCount *int64 `min:"1" type:"integer"`

	// Tags assigned to the activation.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s Activation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Activation) GoString() string {
	return s.String()
}

// SetActivationId sets the ActivationId field's value.
func (s *Activation) SetActivationId(v string) *Activation {
	s.ActivationId = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *Activation) SetCreatedDate(v time.Time) *Activation {
	s.CreatedDate = &v
	return s
}

// SetDefaultInstanceName sets the DefaultInstanceName field's value.
func (s *Activation) SetDefaultInstanceName(v string) *Activation {
	s.DefaultInstanceName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Activation) SetDescription(v string) *Activation {
	s.Description = &v
	return s
}

// SetExpirationDate sets the ExpirationDate field's value.
func (s *Activation) SetExpirationDate(v time.Time) *Activation {
	s.ExpirationDate = &v
	return s
}

// SetExpired sets the Expired field's value.
func (s *Activation) SetExpired(v bool) *Activation {
	s.Expired = &v
	return s
}

// SetIamRole sets the IamRole field's value.
func (s *Activation) SetIamRole(v string) *Activation {
	s.IamRole = &v
	return s
}

// SetRegistrationLimit sets the RegistrationLimit field's value.
func (s *Activation) SetRegistrationLimit(v int64) *Activation {
	s.RegistrationLimit = &v
	return s
}

// SetRegistrationsCount sets the RegistrationsCount field's value.
func (s *Activation) SetRegistrationsCount(v int64) *Activation {
	s.RegistrationsCount = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Activation) SetTags(v []*Tag) *Activation {
	s.Tags = v
	return s
}

type AddTagsToResourceInput struct {
	_ struct{} `type:"structure"`

	// The resource ID you want to tag.
	//
	// Use the ID of the resource. Here are some examples:
	//
	// ManagedInstance: mi-012345abcde
	//
	// MaintenanceWindow: mw-012345abcde
	//
	// PatchBaseline: pb-012345abcde
	//
	// For the Document and Parameter values, use the name of the resource.
	//
	// The ManagedInstance type for this API action is only for on-premises managed
	// instances. You must specify the the name of the managed instance in the following
	// format: mi-ID_number. For example, mi-1a2b3c4d5e6f.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// Specifies the type of resource you are tagging.
	//
	// The ManagedInstance type for this API action is for on-premises managed instances.
	// You must specify the the name of the managed instance in the following format:
	// mi-ID_number. For example, mi-1a2b3c4d5e6f.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true" enum:"ResourceTypeForTagging"`

	// One or more tags. The value parameter is required, but if you don't want
	// the tag to have a value, specify the parameter with no value, and we set
	// the value to an empty string.
	//
	// Do not enter personally identifiable information in this field.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s AddTagsToResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsToResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsToResourceInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *AddTagsToResourceInput) SetResourceId(v string) *AddTagsToResourceInput {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *AddTagsToResourceInput) SetResourceType(v string) *AddTagsToResourceInput {
	s.ResourceType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AddTagsToResourceInput) SetTags(v []*Tag) *AddTagsToResourceInput {
	s.Tags = v
	return s
}

type AddTagsToResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddTagsToResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToResourceOutput) GoString() string {
	return s.String()
}

// Describes an association of a Systems Manager document and an instance.
type Association struct {
	_ struct{} `type:"structure"`

	// The ID created by the system when you create an association. An association
	// is a binding between a document and a set of targets with a schedule.
	AssociationId *string `type:"string"`

	// The association name.
	AssociationName *string `type:"string"`

	// The association version.
	AssociationVersion *string `type:"string"`

	// The version of the document used in the association.
	DocumentVersion *string `type:"string"`

	// The ID of the instance.
	InstanceId *string `type:"string"`

	// The date on which the association was last run.
	LastExecutionDate *time.Time `type:"timestamp"`

	// The name of the Systems Manager document.
	Name *string `type:"string"`

	// Information about the association.
	Overview *AssociationOverview `type:"structure"`

	// A cron expression that specifies a schedule when the association runs.
	ScheduleExpression *string `min:"1" type:"string"`

	// The instances targeted by the request to create an association.
	Targets []*Target `type:"list"`
}

// String returns the string representation
func (s Association) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Association) GoString() string {
	return s.String()
}

// SetAssociationId sets the AssociationId field's value.
func (s *Association) SetAssociationId(v string) *Association {
	s.AssociationId = &v
	return s
}

// SetAssociationName sets the AssociationName field's value.
func (s *Association) SetAssociationName(v string) *Association {
	s.AssociationName = &v
	return s
}

// SetAssociationVersion sets the AssociationVersion field's value.
func (s *Association) SetAssociationVersion(v string) *Association {
	s.AssociationVersion = &v
	return s
}

// SetDocumentVersion sets the DocumentVersion field's value.
func (s *Association) SetDocumentVersion(v string) *Association {
	s.DocumentVersion = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *Association) SetInstanceId(v string) *Association {
	s.InstanceId = &v
	return s
}

// SetLastExecutionDate sets the LastExecutionDate field's value.
func (s *Association) SetLastExecutionDate(v time.Time) *Association {
	s.LastExecutionDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *Association) SetName(v string) *Association {
	s.Name = &v
	return s
}

// SetOverview sets the Overview field's value.
func (s *Association) SetOverview(v *AssociationOverview) *Association {
	s.Overview = v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *Association) SetScheduleExpression(v string) *Association {
	s.ScheduleExpression = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *Association) SetTargets(v []*Target) *Association {
	s.Targets = v
	return s
}

// Describes the parameters for a document.
type AssociationDescription struct {
	_ struct{} `type:"structure"`

	// The association ID.
	AssociationId *string `type:"string"`

	// The association name.
	AssociationName *string `type:"string"`

	// The association version.
	AssociationVersion *string `type:"string"`

	// Specify the target for the association. This target is required for associations
	// that use an Automation document and target resources by using rate controls.
	AutomationTargetParameterName *string `min:"1" type:"string"`

	// The severity level that is assigned to the association.
	ComplianceSeverity *string `type:"string" enum:"AssociationComplianceSeverity"`

	// The date when the association was made.
	Date *time.Time `type:"timestamp"`

	// The document version.
	DocumentVersion *string `type:"string"`

	// The ID of the instance.
	InstanceId *string `type:"string"`

	// The date on which the association was last run.
	LastExecutionDate *time.Time `type:"timestamp"`

	// The last date on which the association was successfully run.
	LastSuccessfulExecutionDate *time.Time `type:"timestamp"`

	// The date when the association was last updated.
	LastUpdateAssociationDate *time.Time `type:"timestamp"`

	// The maximum number of targets allowed to run the association at the same
	// time. You can specify a number, for example 10, or a percentage of the target
	// set, for example 10%. The default value is 100%, which means all targets
	// run the association at the same time.
	//
	// If a new instance starts and attempts to execute an association while Systems
	// Manager is executing MaxConcurrency associations, the association is allowed
	// to run. During the next association interval, the new instance will process
	// its association within the limit specified for MaxConcurrency.
	MaxConcurrency *string `min:"1" type:"string"`

	// The number of errors that are allowed before the system stops sending requests
	// to run the association on additional targets. You can specify either an absolute
	// number of errors, for example 10, or a percentage of the target set, for
	// example 10%. If you specify 3, for example, the system stops sending requests
	// when the fourth error is received. If you specify 0, then the system stops
	// sending requests after the first error is returned. If you run an association
	// on 50 instances and set MaxError to 10%, then the system stops sending the
	// request when the sixth error is received.
	//
	// Executions that are already running an association when MaxErrors is reached
	// are allowed to complete, but some of these executions may fail as well. If
	// you need to ensure that there won't be more than max-errors failed executions,
	// set MaxConcurrency to 1 so that executions proceed one at a time.
	MaxErrors *string `min:"1" type:"string"`

	// The name of the Systems Manager document.
	Name *string `type:"string"`

	// An Amazon S3 bucket where you want to store the output details of the request.
	OutputLocation *InstanceAssociationOutputLocation `type:"structure"`

	// Information about the association.
	Overview *AssociationOverview `type:"structure"`

	// A description of the parameters for a document.
	Parameters map[string][]*string `type:"map"`

	// A cron expression that specifies a schedule when the association runs.
	ScheduleExpression *string `min:"1" type:"string"`

	// The association status.
	Status *AssociationStatus `type:"structure"`

	// The instances targeted by the request.
	Targets []*Target `type:"list"`
}

// String returns the string representation
func (s AssociationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociationDescription) GoString() string {
	return s.String()
}

// SetAssociationId sets the AssociationId field's value.
func (s *AssociationDescription) SetAssociationId(v string) *AssociationDescription {
	s.AssociationId = &v
	return s
}

// SetAssociationName sets the AssociationName field's value.
func (s *AssociationDescription) SetAssociationName(v string) *AssociationDescription {
	s.AssociationName = &v
	return s
}

// SetAssociationVersion sets the AssociationVersion field's value.
func (s *AssociationDescription) SetAssociationVersion(v string) *AssociationDescription {
	s.AssociationVersion = &v
	return s
}

// SetAutomationTargetParameterName sets the AutomationTargetParameterName field's value.
func (s *AssociationDescription) SetAutomationTargetParameterName(v string) *AssociationDescription {
	s.AutomationTargetParameterName = &v
	return s
}

// SetComplianceSeverity sets the ComplianceSeverity field's value.
func (s *AssociationDescription) SetComplianceSeverity(v string) *AssociationDescription {
	s.ComplianceSeverity = &v
	return s
}

// SetDate sets the Date field's value.
func (s *AssociationDescription) SetDate(v time.Time) *AssociationDescription {
	s.Date = &v
	return s
}

// SetDocumentVersion sets the DocumentVersion field's value.
func (s *AssociationDescription) SetDocumentVersion(v string) *AssociationDescription {
	s.DocumentVersion = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *AssociationDescription) SetInstanceId(v string) *AssociationDescription {
	s.InstanceId = &v
	return s
}

// SetLastExecutionDate sets the LastExecutionDate field's value.
func (s *AssociationDescription) SetLastExecutionDate(v time.Time) *AssociationDescription {
	s.LastExecutionDate = &v
	return s
}

// SetLastSuccessfulExecutionDate sets the LastSuccessfulExecutionDate field's value.
func (s *AssociationDescription) SetLastSuccessfulExecutionDate(v time.Time) *AssociationDescription {
	s.LastSuccessfulExecutionDate = &v
	return s
}

// SetLastUpdateAssociationDate sets the LastUpdateAssociationDate field's value.
func (s *AssociationDescription) SetLastUpdateAssociationDate(v time.Time) *AssociationDescription {
	s.LastUpdateAssociationDate = &v
	return s
}

// SetMaxConcurrency sets the MaxConcurrency field's value.
func (s *AssociationDescription) SetMaxConcurrency(v string) *AssociationDescription {
	s.MaxConcurrency = &v
	return s
}

// SetMaxErrors sets the MaxErrors field's value.
func (s *AssociationDescription) SetMaxErrors(v string) *AssociationDescription {
	s.MaxErrors = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssociationDescription) SetName(v string) *AssociationDescription {
	s.Name = &v
	return s
}

// SetOutputLocation sets the OutputLocation field's value.
func (s *AssociationDescription) SetOutputLocation(v *InstanceAssociationOutputLocation) *AssociationDescription {
	s.OutputLocation = v
	return s
}

// SetOverview sets the Overview field's value.
func (s *AssociationDescription) SetOverview(v *AssociationOverview) *AssociationDescription {
	s.Overview = v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *AssociationDescription) SetParameters(v map[string][]*string) *AssociationDescription {
	s.Parameters = v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *AssociationDescription) SetScheduleExpression(v string) *AssociationDescription {
	s.ScheduleExpression = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AssociationDescription) SetStatus(v *AssociationStatus) *AssociationDescription {
	s.Status = v
	return s
}

// SetTargets sets the Targets field's value.
func (s *AssociationDescription) SetTargets(v []*Target) *AssociationDescription {
	s.Targets = v
	return s
}

// Includes information about the specified association.
type AssociationExecution struct {
	_ struct{} `type:"structure"`

	// The association ID.
	AssociationId *string `type:"string"`

	// The association version.
	AssociationVersion *string `type:"string"`

	// The time the execution started.
	CreatedTime *time.Time `type:"timestamp"`

	// Detailed status information about the execution.
	DetailedStatus *string `type:"string"`

	// The execution ID for the association. If the association does not run at
	// intervals or according to a schedule, then the ExecutionID is the same as
	// the AssociationID.
	ExecutionId *string `type:"string"`

	// The date of the last execution.
	LastExecutionDate *time.Time `type:"timestamp"`

	// An aggregate status of the resources in the execution based on the status
	// type.
	ResourceCountByStatus *string `type:"string"`

	// The status of the association execution.
	Status *string `type:"string"`
}

// String returns the string representation
func (s AssociationExecution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociationExecution) GoString() string {
	return s.String()
}

// SetAssociationId sets the AssociationId field's value.
func (s *AssociationExecution) SetAssociationId(v string) *AssociationExecution {
	s.AssociationId = &v
	return s
}

// SetAssociationVersion sets the AssociationVersion field's value.
func (s *AssociationExecution) SetAssociationVersion(v string) *AssociationExecution {
	s.AssociationVersion = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *AssociationExecution) SetCreatedTime(v time.Time) *AssociationExecution {
	s.CreatedTime = &v
	return s
}

// SetDetailedStatus sets the DetailedStatus field's value.
func (s *AssociationExecution) SetDetailedStatus(v string) *AssociationExecution {
	s.DetailedStatus = &v
	return s
}

// SetExecutionId sets the ExecutionId field's value.
func (s *AssociationExecution) SetExecutionId(v string) *AssociationExecution {
	s.ExecutionId = &v
	return s
}

// SetLastExecutionDate sets the LastExecutionDate field's value.
func (s *AssociationExecution) SetLastExecutionDate(v time.Time) *AssociationExecution {
	s.LastExecutionDate = &v
	return s
}

// SetResourceCountByStatus sets the ResourceCountByStatus field's value.
func (s *AssociationExecution) SetResourceCountByStatus(v string) *AssociationExecution {
	s.ResourceCountByStatus = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AssociationExecution) SetStatus(v string) *AssociationExecution {
	s.Status = &v
	return s
}

// Filters used in the request.
type AssociationExecutionFilter struct {
	_ struct{} `type:"structure"`

	// The key value used in the request.
	//
	// Key is a required field
	Key *string `type:"string" required:"true" enum:"AssociationExecutionFilterKey"`

	// The filter type specified in the request.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"AssociationFilterOperatorType"`

	// The value specified for the key.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociationExecutionFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociationExecutionFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociationExecutionFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociationExecutionFilter"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *AssociationExecutionFilter) SetKey(v string) *AssociationExecutionFilter {
	s.Key = &v
	return s
}

// SetType sets the Type field's value.
func (s *AssociationExecutionFilter) SetType(v string) *AssociationExecutionFilter {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AssociationExecutionFilter) SetValue(v string) *AssociationExecutionFilter {
	s.Value = &v
	return s
}

// Includes information about the specified association execution.
type AssociationExecutionTarget struct {
	_ struct{} `type:"structure"`

	// The association ID.
	AssociationId *string `type:"string"`

	// The association version.
	AssociationVersion *string `type:"string"`

	// Detailed information about the execution status.
	DetailedStatus *string `type:"string"`

	// The execution ID. If the association does not run at intervals or according
	// to a schedule, then the ExecutionID is the same as the AssociationID.
	ExecutionId *string `type:"string"`

	// The date of the last execution.
	LastExecutionDate *time.Time `type:"timestamp"`

	// The location where the association details are saved.
	OutputSource *OutputSource `type:"structure"`

	// The resource ID, for example, the instance ID where the association ran.
	ResourceId *string `min:"1" type:"string"`

	// The resource type, for example, instance.
	ResourceType *string `min:"1" type:"string"`

	// The association execution status.
	Status *string `type:"string"`
}

// String returns the string representation
func (s AssociationExecutionTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociationExecutionTarget) GoString() string {
	return s.String()
}

// SetAssociationId sets the AssociationId field's value.
func (s *AssociationExecutionTarget) SetAssociationId(v string) *AssociationExecutionTarget {
	s.AssociationId = &v
	return s
}

// SetAssociationVersion sets the AssociationVersion field's value.
func (s *AssociationExecutionTarget) SetAssociationVersion(v string) *AssociationExecutionTarget {
	s.AssociationVersion = &v
	return s
}

// SetDetailedStatus sets the DetailedStatus field's value.
func (s *AssociationExecutionTarget) SetDetailedStatus(v string) *AssociationExecutionTarget {
	s.DetailedStatus = &v
	return s
}

// SetExecutionId sets the ExecutionId field's value.
func (s *AssociationExecutionTarget) SetExecutionId(v string) *AssociationExecutionTarget {
	s.ExecutionId = &v
	return s
}

// SetLastExecutionDate sets the LastExecutionDate field's value.
func (s *AssociationExecutionTarget) SetLastExecutionDate(v time.Time) *AssociationExecutionTarget {
	s.LastExecutionDate = &v
	return s
}

// SetOutputSource sets the OutputSource field's value.
func (s *AssociationExecutionTarget) SetOutputSource(v *OutputSource) *AssociationExecutionTarget {
	s.OutputSource = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *AssociationExecutionTarget) SetResourceId(v string) *AssociationExecutionTarget {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *AssociationExecutionTarget) SetResourceType(v string) *AssociationExecutionTarget {
	s.ResourceType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AssociationExecutionTarget) SetStatus(v string) *AssociationExecutionTarget {
	s.Status = &v
	return s
}

// Filters for the association execution.
type AssociationExecutionTargetsFilter struct {
	_ struct{} `type:"structure"`

	// The key value used in the request.
	//
	// Key is a required field
	Key *string `type:"string" required:"true" enum:"AssociationExecutionTargetsFilterKey"`

	// The value specified for the key.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociationExecutionTargetsFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociationExecutionTargetsFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociationExecutionTargetsFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociationExecutionTargetsFilter"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *AssociationExecutionTargetsFilter) SetKey(v string) *AssociationExecutionTargetsFilter {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AssociationExecutionTargetsFilter) SetValue(v string) *AssociationExecutionTargetsFilter {
	s.Value = &v
	return s
}

// Describes a filter.
type AssociationFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	//
	// Key is a required field
	Key *string `locationName:"key" type:"string" required:"true" enum:"AssociationFilterKey"`

	// The filter value.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociationFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociationFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociationFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociationFilter"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *AssociationFilter) SetKey(v string) *AssociationFilter {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AssociationFilter) SetValue(v string) *AssociationFilter {
	s.Value = &v
	return s
}

// Information about the association.
type AssociationOverview struct {
	_ struct{} `type:"structure"`

	// Returns the number of targets for the association status. For example, if
	// you created an association with two instances, and one of them was successful,
	// this would return the count of instances by status.
	AssociationStatusAggregatedCount map[string]*int64 `type:"map"`

	// A detailed status of the association.
	DetailedStatus *string `type:"string"`

	// The status of the association. Status can be: Pending, Success, or Failed.
	Status *string `type:"string"`
}

// String returns the string representation
func (s AssociationOverview) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociationOverview) GoString() string {
	return s.String()
}

// SetAssociationStatusAggregatedCount sets the AssociationStatusAggregatedCount field's value.
func (s *AssociationOverview) SetAssociationStatusAggregatedCount(v map[string]*int64) *AssociationOverview {
	s.AssociationStatusAggregatedCount = v
	return s
}

// SetDetailedStatus sets the DetailedStatus field's value.
func (s *AssociationOverview) SetDetailedStatus(v string) *AssociationOverview {
	s.DetailedStatus = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AssociationOverview) SetStatus(v string) *AssociationOverview {
	s.Status = &v
	return s
}

// Describes an association status.
type AssociationStatus struct {
	_ struct{} `type:"structure"`

	// A user-defined string.
	AdditionalInfo *string `type:"string"`

	// The date when the status changed.
	//
	// Date is a required field
	Date *time.Time `type:"timestamp" required:"true"`

	// The reason for the status.
	//
	// Message is a required field
	Message *string `min:"1" type:"string" required:"true"`

	// The status.
	//
	// Name is a required field
	Name *string `type:"string" required:"true" enum:"AssociationStatusName"`
}

// String returns the string representation
func (s AssociationStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociationStatus) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociationStatus) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociationStatus"}
	if s.Date == nil {
		invalidParams.Add(request.NewErrParamRequired("Date"))
	}
	if s.Message == nil {
		invalidParams.Add(request.NewErrParamRequired("Message"))
	}
	if s.Message != nil && len(*s.Message) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Message", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalInfo sets the AdditionalInfo field's value.
func (s *AssociationStatus) SetAdditionalInfo(v string) *AssociationStatus {
	s.AdditionalInfo = &v
	return s
}

// SetDate sets the Date field's value.
func (s *AssociationStatus) SetDate(v time.Time) *AssociationStatus {
	s.Date = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *AssociationStatus) SetMessage(v string) *AssociationStatus {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssociationStatus) SetName(v string) *AssociationStatus {
	s.Name = &v
	return s
}

// Information about the association version.
type AssociationVersionInfo struct {
	_ struct{} `type:"structure"`

	// The ID created by the system when the association was created.
	AssociationId *string `type:"string"`

	// The name specified for the association version when the association version
	// was created.
	AssociationName *string `type:"string"`

	// The association version.
	AssociationVersion *string `type:"string"`

	// The severity level that is assigned to the association.
	ComplianceSeverity *string `type:"string" enum:"AssociationComplianceSeverity"`

	// The date the association version was created.
	CreatedDate *time.Time `type:"timestamp"`

	// The version of a Systems Manager document used when the association version
	// was created.
	DocumentVersion *string `type:"string"`

	// The maximum number of targets allowed to run the association at the same
	// time. You can specify a number, for example 10, or a percentage of the target
	// set, for example 10%. The default value is 100%, which means all targets
	// run the association at the same time.
	//
	// If a new instance starts and attempts to execute an association while Systems
	// Manager is executing MaxConcurrency associations, the association is allowed
	// to run. During the next association interval, the new instance will process
	// its association within the limit specified for MaxConcurrency.
	MaxConcurrency *string `min:"1" type:"string"`

	// The number of errors that are allowed before the system stops sending requests
	// to run the association on additional targets. You can specify either an absolute
	// number of errors, for example 10, or a percentage of the target set, for
	// example 10%. If you specify 3, for example, the system stops sending requests
	// when the fourth error is received. If you specify 0, then the system stops
	// sending requests after the first error is returned. If you run an association
	// on 50 instances and set MaxError to 10%, then the system stops sending the
	// request when the sixth error is received.
	//
	// Executions that are already running an association when MaxErrors is reached
	// are allowed to complete, but some of these executions may fail as well. If
	// you need to ensure that there won't be more than max-errors failed executions,
	// set MaxConcurrency to 1 so that executions proceed one at a time.
	MaxErrors *string `min:"1" type:"string"`

	// The name specified when the association was created.
	Name *string `type:"string"`

	// The location in Amazon S3 specified for the association when the association
	// version was created.
	OutputLocation *InstanceAssociationOutputLocation `type:"structure"`

	// Parameters specified when the association version was created.
	Parameters map[string][]*string `type:"map"`

	// The cron or rate schedule specified for the association when the association
	// version was created.
	ScheduleExpression *string `min:"1" type:"string"`

	// The targets specified for the association when the association version was
	// created.
	Targets []*Target `type:"list"`
}

// String returns the string representation
func (s AssociationVersionInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociationVersionInfo) GoString() string {
	return s.String()
}

// SetAssociationId sets the AssociationId field's value.
func (s *AssociationVersionInfo) SetAssociationId(v string) *AssociationVersionInfo {
	s.AssociationId = &v
	return s
}

// SetAssociationName sets the AssociationName field's value.
func (s *AssociationVersionInfo) SetAssociationName(v string) *AssociationVersionInfo {
	s.AssociationName = &v
	return s
}

// SetAssociationVersion sets the AssociationVersion field's value.
func (s *AssociationVersionInfo) SetAssociationVersion(v string) *AssociationVersionInfo {
	s.AssociationVersion = &v
	return s
}

// SetComplianceSeverity sets the ComplianceSeverity field's value.
func (s *AssociationVersionInfo) SetComplianceSeverity(v string) *AssociationVersionInfo {
	s.ComplianceSeverity = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *AssociationVersionInfo) SetCreatedDate(v time.Time) *AssociationVersionInfo {
	s.CreatedDate = &v
	return s
}

// SetDocumentVersion sets the DocumentVersion field's value.
func (s *AssociationVersionInfo) SetDocumentVersion(v string) *AssociationVersionInfo {
	s.DocumentVersion = &v
	return s
}

// SetMaxConcurrency sets the MaxConcurrency field's value.
func (s *AssociationVersionInfo) SetMaxConcurrency(v string) *AssociationVersionInfo {
	s.MaxConcurrency = &v
	return s
}

// SetMaxErrors sets the MaxErrors field's value.
func (s *AssociationVersionInfo) SetMaxErrors(v string) *AssociationVersionInfo {
	s.MaxErrors = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssociationVersionInfo) SetName(v string) *AssociationVersionInfo {
	s.Name = &v
	return s
}

// SetOutputLocation sets the OutputLocation field's value.
func (s *AssociationVersionInfo) SetOutputLocation(v *InstanceAssociationOutputLocation) *AssociationVersionInfo {
	s.OutputLocation = v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *AssociationVersionInfo) SetParameters(v map[string][]*string) *AssociationVersionInfo {
	s.Parameters = v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *AssociationVersionInfo) SetScheduleExpression(v string) *AssociationVersionInfo {
	s.ScheduleExpression = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *AssociationVersionInfo) SetTargets(v []*Target) *AssociationVersionInfo {
	s.Targets = v
	return s
}

// A structure that includes attributes that describe a document attachment.
type AttachmentContent struct {
	_ struct{} `type:"structure"`

	// The cryptographic hash value of the document content.
	Hash *string `type:"string"`

	// The hash algorithm used to calculate the hash value.
	HashType *string `type:"string" enum:"AttachmentHashType"`

	// The name of an attachment.
	Name *string `type:"string"`

	// The size of an attachment in bytes.
	Size *int64 `type:"long"`

	// The URL location of the attachment content.
	Url *string `type:"string"`
}

// String returns the string representation
func (s AttachmentContent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachmentContent) GoString() string {
	return s.String()
}

// SetHash sets the Hash field's value.
func (s *AttachmentContent) SetHash(v string) *AttachmentContent {
	s.Hash = &v
	return s
}

// SetHashType sets the HashType field's value.
func (s *AttachmentContent) SetHashType(v string) *AttachmentContent {
	s.HashType = &v
	return s
}

// SetName sets the Name field's value.
func (s *AttachmentContent) SetName(v string) *AttachmentContent {
	s.Name = &v
	return s
}

// SetSize sets the Size field's value.
func (s *AttachmentContent) SetSize(v int64) *AttachmentContent {
	s.Size = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *AttachmentContent) SetUrl(v string) *AttachmentContent {
	s.Url = &v
	return s
}

// An attribute of an attachment, such as the attachment name.
type AttachmentInformation struct {
	_ struct{} `type:"structure"`

	// The name of the attachment.
	Name *string `type:"string"`
}

// String returns the string representation
func (s AttachmentInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachmentInformation) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AttachmentInformation) SetName(v string) *AttachmentInformation {
	s.Name = &v
	return s
}

// A key and value pair that identifies the location of an attachment to a document.
type AttachmentsSource struct {
	_ struct{} `type:"structure"`

	// The key of a key and value pair that identifies the location of an attachment
	// to a document.
	Key *string `type:"string" enum:"AttachmentsSourceKey"`

	// The URL of the location of a document attachment, such as the URL of an Amazon
	// S3 bucket.
	Values []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s AttachmentsSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachmentsSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachmentsSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachmentsSource"}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *AttachmentsSource) SetKey(v string) *AttachmentsSource {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *AttachmentsSource) SetValues(v []*string) *AttachmentsSource {
	s.Values = v
	return s
}

// Detailed information about the current state of an individual Automation
// execution.
type AutomationExecution struct {
	_ struct{} `type:"structure"`

	// The execution ID.
	AutomationExecutionId *string `min:"36" type:"string"`

	// The execution status of the Automation.
	AutomationExecutionStatus *string `type:"string" enum:"AutomationExecutionStatus"`

	// The action of the currently executing step.
	CurrentAction *string `type:"string"`

	// The name of the currently executing step.
	CurrentStepName *string `type:"string"`

	// The name of the Automation document used during the execution.
	DocumentName *string `type:"string"`

	// The version of the document to use during execution.
	DocumentVersion *string `type:"string"`

	// The Amazon Resource Name (ARN) of the user who executed the automation.
	ExecutedBy *string `type:"string"`

	// The time the execution finished.
	ExecutionEndTime *time.Time `type:"timestamp"`

	// The time the execution started.
	ExecutionStartTime *time.Time `type:"timestamp"`

	// A message describing why an execution has failed, if the status is set to
	// Failed.
	FailureMessage *string `type:"string"`

	// The MaxConcurrency value specified by the user when the execution started.
	MaxConcurrency *string `min:"1" type:"string"`

	// The MaxErrors value specified by the user when the execution started.
	MaxErrors *string `min:"1" type:"string"`

	// The automation execution mode.
	Mode *string `type:"string" enum:"ExecutionMode"`

	// The list of execution outputs as defined in the automation document.
	Outputs map[string][]*string `min:"1" type:"map"`

	// The key-value map of execution parameters, which were supplied when calling
	// StartAutomationExecution.
	Parameters map[string][]*string `min:"1" type:"map"`

	// The AutomationExecutionId of the parent automation.
	ParentAutomationExecutionId *string `min:"36" type:"string"`

	// An aggregate of step execution statuses displayed in the AWS Console for
	// a multi-Region and multi-account Automation execution.
	ProgressCounters *ProgressCounters `type:"structure"`

	// A list of resolved targets in the rate control execution.
	ResolvedTargets *ResolvedTargets `type:"structure"`

	// A list of details about the current state of all steps that comprise an execution.
	// An Automation document contains a list of steps that are executed in order.
	StepExecutions []*StepExecution `type:"list"`

	// A boolean value that indicates if the response contains the full list of
	// the Automation step executions. If true, use the DescribeAutomationStepExecutions
	// API action to get the full list of step executions.
	StepExecutionsTruncated *bool `type:"boolean"`

	// The target of the execution.
	Target *string `type:"string"`

	// The combination of AWS Regions and/or AWS accounts where you want to execute
	// the Automation.
	TargetLocations []*TargetLocation `min:"1" type:"list"`

	// The specified key-value mapping of document parameters to target resources.
	TargetMaps []map[string][]*string `type:"list"`

	// The parameter name.
	TargetParameterName *string `min:"1" type:"string"`

	// The specified targets.
	Targets []*Target `type:"list"`
}

// String returns the string representation
func (s AutomationExecution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutomationExecution) GoString() string {
	return s.String()
}

// SetAutomationExecutionId sets the AutomationExecutionId field's value.
func (s *AutomationExecution) SetAutomationExecutionId(v string) *AutomationExecution {
	s.AutomationExecutionId = &v
	return s
}

// SetAutomationExecutionStatus sets the AutomationExecutionStatus field's value.
func (s *AutomationExecution) SetAutomationExecutionStatus(v string) *AutomationExecution {
	s.AutomationExecutionStatus = &v
	return s
}

// SetCurrentAction sets the CurrentAction field's value.
func (s *AutomationExecution) SetCurrentAction(v string) *AutomationExecution {
	s.CurrentAction = &v
	return s
}

// SetCurrentStepName sets the CurrentStepName field's value.
func (s *AutomationExecution) SetCurrentStepName(v string) *AutomationExecution {
	s.CurrentStepName = &v
	return s
}

// SetDocumentName sets the DocumentName field's value.
func (s *AutomationExecution) SetDocumentName(v string) *AutomationExecution {
	s.DocumentName = &v
	return s
}

// SetDocumentVersion sets the DocumentVersion field's value.
func (s *AutomationExecution) SetDocumentVersion(v string) *AutomationExecution {
	s.DocumentVersion = &v
	return s
}

// SetExecutedBy sets the ExecutedBy field's value.
func (s *AutomationExecution) SetExecutedBy(v string) *AutomationExecution {
	s.ExecutedBy = &v
	return s
}

// SetExecutionEndTime sets the ExecutionEndTime field's value.
func (s *AutomationExecution) SetExecutionEndTime(v time.Time) *AutomationExecution {
	s.ExecutionEndTime = &v
	return s
}

// SetExecutionStartTime sets the ExecutionStartTime field's value.
func (s *AutomationExecution) SetExecutionStartTime(v time.Time) *AutomationExecution {
	s.ExecutionStartTime = &v
	return s
}

// SetFailureMessage sets the FailureMessage field's value.
func (s *AutomationExecution) SetFailureMessage(v string) *AutomationExecution {
	s.FailureMessage = &v
	return s
}

// SetMaxConcurrency sets the MaxConcurrency field's value.
func (s *AutomationExecution) SetMaxConcurrency(v string) *AutomationExecution {
	s.MaxConcurrency = &v
	return s
}

// SetMaxErrors sets the MaxErrors field's value.
func (s *AutomationExecution) SetMaxErrors(v string) *AutomationExecution {
	s.MaxErrors = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *AutomationExecution) SetMode(v string) *AutomationExecution {
	s.Mode = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *AutomationExecution) SetOutputs(v map[string][]*string) *AutomationExecution {
	s.Outputs = v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *AutomationExecution) SetParameters(v map[string][]*string) *AutomationExecution {
	s.Parameters = v
	return s
}

// SetParentAutomationExecutionId sets the ParentAutomationExecutionId field's value.
func (s *AutomationExecution) SetParentAutomationExecutionId(v string) *AutomationExecution {
	s.ParentAutomationExecutionId = &v
	return s
}

// SetProgressCounters sets the ProgressCounters field's value.
func (s *AutomationExecution) SetProgressCounters(v *ProgressCounters) *AutomationExecution {
	s.ProgressCounters = v
	return s
}

// SetResolvedTargets sets the ResolvedTargets field's value.
func (s *AutomationExecution) SetResolvedTargets(v *ResolvedTargets) *AutomationExecution {
	s.ResolvedTargets = v
	return s
}

// SetStepExecutions sets the StepExecutions field's value.
func (s *AutomationExecution) SetStepExecutions(v []*StepExecution) *AutomationExecution {
	s.StepExecutions = v
	return s
}

// SetStepExecutionsTruncated sets the StepExecutionsTruncated field's value.
func (s *AutomationExecution) SetStepExecutionsTruncated(v bool) *AutomationExecution {
	s.StepExecutionsTruncated = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *AutomationExecution) SetTarget(v string) *AutomationExecution {
	s.Target = &v
	return s
}

// SetTargetLocations sets the TargetLocations field's value.
func (s *AutomationExecution) SetTargetLocations(v []*TargetLocation) *AutomationExecution {
	s.TargetLocations = v
	return s
}

// SetTargetMaps sets the TargetMaps field's value.
func (s *AutomationExecution) SetTargetMaps(v []map[string][]*string) *AutomationExecution {
	s.TargetMaps = v
	return s
}

// SetTargetParameterName sets the TargetParameterName field's value.
func (s *AutomationExecution) SetTargetParameterName(v string) *AutomationExecution {
	s.TargetParameterName = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *AutomationExecution) SetTargets(v []*Target) *AutomationExecution {
	s.Targets = v
	return s
}

// A filter used to match specific automation executions. This is used to limit
// the scope of Automation execution information returned.
type AutomationExecutionFilter struct {
	_ struct{} `type:"structure"`

	// One or more keys to limit the results. Valid filter keys include the following:
	// DocumentNamePrefix, ExecutionStatus, ExecutionId, ParentExecutionId, CurrentAction,
	// StartTimeBefore, StartTimeAfter.
	//
	// Key is a required field
	Key *string `type:"string" required:"true" enum:"AutomationExecutionFilterKey"`

	// The values used to limit the execution information associated with the filter's
	// key.
	//
	// Values is a required field
	Values []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s AutomationExecutionFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutomationExecutionFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutomationExecutionFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutomationExecutionFilter"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *AutomationExecutionFilter) SetKey(v string) *AutomationExecutionFilter {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *AutomationExecutionFilter) SetValues(v []*string) *AutomationExecutionFilter {
	s.Values = v
	return s
}

// Details about a specific Automation execution.
type AutomationExecutionMetadata struct {
	_ struct{} `type:"structure"`

	// The execution ID.
	AutomationExecutionId *string `min:"36" type:"string"`

	// The status of the execution. Valid values include: Running, Succeeded, Failed,
	// Timed out, or Cancelled.
	AutomationExecutionStatus *string `type:"string" enum:"AutomationExecutionStatus"`

	// Use this filter with DescribeAutomationExecutions. Specify either Local or
	// CrossAccount. CrossAccount is an Automation that executes in multiple AWS
	// Regions and accounts. For more information, see Concurrently Executing Automations
	// in Multiple AWS Regions and Accounts (http://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-automation-multiple-accounts-and-regions.html)
	// in the AWS Systems Manager User Guide.
	AutomationType *string `type:"string" enum:"AutomationType"`

	// The action of the currently executing step.
	CurrentAction *string `type:"string"`

	// The name of the currently executing step.
	CurrentStepName *string `type:"string"`

	// The name of the Automation document used during execution.
	DocumentName *string `type:"string"`

	// The document version used during the execution.
	DocumentVersion *string `type:"string"`

	// The IAM role ARN of the user who executed the Automation.
	ExecutedBy *string `type:"string"`

	// The time the execution finished. This is not populated if the execution is
	// still in progress.
	ExecutionEndTime *time.Time `type:"timestamp"`

	// The time the execution started.>
	ExecutionStartTime *time.Time `type:"timestamp"`

	// The list of execution outputs as defined in the Automation document.
	FailureMessage *string `type:"string"`

	// An Amazon S3 bucket where execution information is stored.
	LogFile *string `type:"string"`

	// The MaxConcurrency value specified by the user when starting the Automation.
	MaxConcurrency *string `min:"1" type:"string"`

	// The MaxErrors value specified by the user when starting the Automation.
	MaxErrors *string `min:"1" type:"string"`

	// The Automation execution mode.
	Mode *string `type:"string" enum:"ExecutionMode"`

	// The list of execution outputs as defined in the Automation document.
	Outputs map[string][]*string `min:"1" type:"map"`

	// The ExecutionId of the parent Automation.
	ParentAutomationExecutionId *string `min:"36" type:"string"`

	// A list of targets that resolved during the execution.
	ResolvedTargets *ResolvedTargets `type:"structure"`

	// The list of execution outputs as defined in the Automation document.
	Target *string `type:"string"`

	// The specified key-value mapping of document parameters to target resources.
	TargetMaps []map[string][]*string `type:"list"`

	// The list of execution outputs as defined in the Automation document.
	TargetParameterName *string `min:"1" type:"string"`

	// The targets defined by the user when starting the Automation.
	Targets []*Target `type:"list"`
}

// String returns the string representation
func (s AutomationExecutionMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutomationExecutionMetadata) GoString() string {
	return s.String()
}

// SetAutomationExecutionId sets the AutomationExecutionId field's value.
func (s *AutomationExecutionMetadata) SetAutomationExecutionId(v string) *AutomationExecutionMetadata {
	s.AutomationExecutionId = &v
	return s
}

// SetAutomationExecutionStatus sets the AutomationExecutionStatus field's value.
func (s *AutomationExecutionMetadata) SetAutomationExecutionStatus(v string) *AutomationExecutionMetadata {
	s.AutomationExecutionStatus = &v
	return s
}

// SetAutomationType sets the AutomationType field's value.
func (s *AutomationExecutionMetadata) SetAutomationType(v string) *AutomationExecutionMetadata {
	s.AutomationType = &v
	return s
}

// SetCurrentAction sets the CurrentAction field's value.
func (s *AutomationExecutionMetadata) SetCurrentAction(v string) *AutomationExecutionMetadata {
	s.CurrentAction = &v
	return s
}

// SetCurrentStepName sets the CurrentStepName field's value.
func (s *AutomationExecutionMetadata) SetCurrentStepName(v string) *AutomationExecutionMetadata {
	s.CurrentStepName = &v
	return s
}

// SetDocumentName sets the DocumentName field's value.
func (s *AutomationExecutionMetadata) SetDocumentName(v string) *AutomationExecutionMetadata {
	s.DocumentName = &v
	return s
}

// SetDocumentVersion sets the DocumentVersion field's value.
func (s *AutomationExecutionMetadata) SetDocumentVersion(v string) *AutomationExecutionMetadata {
	s.DocumentVersion = &v
	return s
}

// SetExecutedBy sets the ExecutedBy field's value.
func (s *AutomationExecutionMetadata) SetExecutedBy(v string) *AutomationExecutionMetadata {
	s.ExecutedBy = &v
	return s
}

// SetExecutionEndTime sets the ExecutionEndTime field's value.
func (s *AutomationExecutionMetadata) SetExecutionEndTime(v time.Time) *AutomationExecutionMetadata {
	s.ExecutionEndTime = &v
	return s
}

// SetExecutionStartTime sets the ExecutionStartTime field's value.
func (s *AutomationExecutionMetadata) SetExecutionStartTime(v time.Time) *AutomationExecutionMetadata {
	s.ExecutionStartTime = &v
	return s
}

// SetFailureMessage sets the FailureMessage field's value.
func (s *AutomationExecutionMetadata) SetFailureMessage(v string) *AutomationExecutionMetadata {
	s.FailureMessage = &v
	return s
}

// SetLogFile sets the LogFile field's value.
func (s *AutomationExecutionMetadata) SetLogFile(v string) *AutomationExecutionMetadata {
	s.LogFile = &v
	return s
}

// SetMaxConcurrency sets the MaxConcurrency field's value.
func (s *AutomationExecutionMetadata) SetMaxConcurrency(v string) *AutomationExecutionMetadata {
	s.MaxConcurrency = &v
	return s
}

// SetMaxErrors sets the MaxErrors field's value.
func (s *AutomationExecutionMetadata) SetMaxErrors(v string) *AutomationExecutionMetadata {
	s.MaxErrors = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *AutomationExecutionMetadata) SetMode(v string) *AutomationExecutionMetadata {
	s.Mode = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *AutomationExecutionMetadata) SetOutputs(v map[string][]*string) *AutomationExecutionMetadata {
	s.Outputs = v
	return s
}

// SetParentAutomationExecutionId sets the ParentAutomationExecutionId field's value.
func (s *AutomationExecutionMetadata) SetParentAutomationExecutionId(v string) *AutomationExecutionMetadata {
	s.ParentAutomationExecutionId = &v
	return s
}

// SetResolvedTargets sets the ResolvedTargets field's value.
func (s *AutomationExecutionMetadata) SetResolvedTargets(v *ResolvedTargets) *AutomationExecutionMetadata {
	s.ResolvedTargets = v
	return s
}

// SetTarget sets the Target field's value.
func (s *AutomationExecutionMetadata) SetTarget(v string) *AutomationExecutionMetadata {
	s.Target = &v
	return s
}

// SetTargetMaps sets the TargetMaps field's value.
func (s *AutomationExecutionMetadata) SetTargetMaps(v []map[string][]*string) *AutomationExecutionMetadata {
	s.TargetMaps = v
	return s
}

// SetTargetParameterName sets the TargetParameterName field's value.
func (s *AutomationExecutionMetadata) SetTargetParameterName(v string) *AutomationExecutionMetadata {
	s.TargetParameterName = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *AutomationExecutionMetadata) SetTargets(v []*Target) *AutomationExecutionMetadata {
	s.Targets = v
	return s
}

type CancelCommandInput struct {
	_ struct{} `type:"structure"`

	// The ID of the command you want to cancel.
	//
	// CommandId is a required field
	CommandId *string `min:"36" type:"string" required:"true"`

	// (Optional) A list of instance IDs on which you want to cancel the command.
	// If not provided, the command is canceled on every instance on which it was
	// requested.
	InstanceIds []*string `type:"list"`
}

// String returns the string representation
func (s CancelCommandInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelCommandInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelCommandInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelCommandInput"}
	if s.CommandId == nil {
		invalidParams.Add(request.NewErrParamRequired("CommandId"))
	}
	if s.CommandId != nil && len(*s.CommandId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CommandId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCommandId sets the CommandId field's value.
func (s *CancelCommandInput) SetCommandId(v string) *CancelCommandInput {
	s.CommandId = &v
	return s
}

// SetInstanceIds sets the InstanceIds field's value.
func (s *CancelCommandInput) SetInstanceIds(v []*string) *CancelCommandInput {
	s.InstanceIds = v
	return s
}

// Whether or not the command was successfully canceled. There is no guarantee
// that a request can be canceled.
type CancelCommandOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelCommandOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelCommandOutput) GoString() string {
	return s.String()
}

type CancelMaintenanceWindowExecutionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Maintenance Window execution to stop.
	//
	// WindowExecutionId is a required field
	WindowExecutionId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelMaintenanceWindowExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelMaintenanceWindowExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelMaintenanceWindowExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelMaintenanceWindowExecutionInput"}
	if s.WindowExecutionId == nil {
		invalidParams.Add(request.NewErrParamRequired("WindowExecutionId"))
	}
	if s.WindowExecutionId != nil && len(*s.WindowExecutionId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("WindowExecutionId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWindowExecutionId sets the WindowExecutionId field's value.
func (s *CancelMaintenanceWindowExecutionInput) SetWindowExecutionId(v string) *CancelMaintenanceWindowExecutionInput {
	s.WindowExecutionId = &v
	return s
}

type CancelMaintenanceWindowExecutionOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the Maintenance Window execution that has been stopped.
	WindowExecutionId *string `min:"36" type:"string"`
}

// String returns the string representation
func (s CancelMaintenanceWindowExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelMaintenanceWindowExecutionOutput) GoString() string {
	return s.String()
}

// SetWindowExecutionId sets the WindowExecutionId field's value.
func (s *CancelMaintenanceWindowExecutionOutput) SetWindowExecutionId(v string) *CancelMaintenanceWindowExecutionOutput {
	s.WindowExecutionId = &v
	return s
}

// Configuration options for sending command output to CloudWatch Logs.
type CloudWatchOutputConfig struct {
	_ struct{} `type:"structure"`

	// The name of the CloudWatch log group where you want to send command output.
	// If you don't specify a group name, Systems Manager automatically creates
	// a log group for you. The log group uses the following naming format: aws/ssm/SystemsManagerDocumentName.
	CloudWatchLogGroupName *string `min:"1" type:"string"`

	// Enables Systems Manager to send command output to CloudWatch Logs.
	CloudWatchOutputEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s CloudWatchOutputConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudWatchOutputConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchOutputConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudWatchOutputConfig"}
	if s.CloudWatchLogGroupName != nil && len(*s.CloudWatchLogGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CloudWatchLogGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLogGroupName sets the CloudWatchLogGroupName field's value.
func (s *CloudWatchOutputConfig) SetCloudWatchLogGroupName(v string) *CloudWatchOutputConfig {
	s.CloudWatchLogGroupName = &v
	return s
}

// SetCloudWatchOutputEnabled sets the CloudWatchOutputEnabled field's value.
func (s *CloudWatchOutputConfig) SetCloudWatchOutputEnabled(v bool) *CloudWatchOutputConfig {
	s.CloudWatchOutputEnabled = &v
	return s
}

// Describes a command request.
type Command struct {
	_ struct{} `type:"structure"`

	// CloudWatch Logs information where you want Systems Manager to send the command
	// output.
	CloudWatchOutputConfig *CloudWatchOutputConfig `type:"structure"`

	// A unique identifier for this command.
	CommandId *string `min:"36" type:"string"`

	// User-specified information about the command, such as a brief description
	// of what the command should do.
	Comment *string `type:"string"`

	// The number of targets for which the command invocation reached a terminal
	// state. Terminal states include the following: Success, Failed, Execution
	// Timed Out, Delivery Timed Out, Canceled, Terminated, or Undeliverable.
	CompletedCount *int64 `type:"integer"`

	// The number of targets for which the status is Delivery Timed Out.
	DeliveryTimedOutCount *int64 `type:"integer"`

	// The name of the document requested for execution.
	DocumentName *string `type:"string"`

	// The SSM document version.
	DocumentVersion *string `type:"string"`

	// The number of targets for which the status is Failed or Execution Timed Out.
	ErrorCount *int64 `type:"integer"`

	// If this time is reached and the command has not already started executing,
	// it will not run. Calculated based on the ExpiresAfter user input provided
	// as part of the SendCommand API.
	ExpiresAfter *time.Time `type:"timestamp"`

	// The instance IDs against which this command was requested.
	InstanceIds []*string `type:"list"`

	// The maximum number of instances that are allowed to execute the command at
	// the same time. You can specify a number of instances, such as 10, or a percentage
	// of instances, such as 10%. The default value is 50. For more information
	// about how to use MaxConcurrency, see Executing Commands Using Systems Manager
	// Run Command (http://docs.aws.amazon.com/systems-manager/latest/userguide/run-command.html)
	// in the AWS Systems Manager User Guide.
	MaxConcurrency *string `min:"1" type:"string"`

	// The maximum number of errors allowed before the system stops sending the
	// command to additional targets. You can specify a number of errors, such as
	// 10, or a percentage or errors, such as 10%. The default value is 0. For more
	// information about how to use MaxErrors, see Executing Commands Using Systems
	// Manager Run Command (http://docs.aws.amazon.com/systems-manager/latest/userguide/run-command.html)
	// in the AWS Systems Manager User Guide.
	MaxErrors *string `min:"1" type:"string"`

	// Configurations for sending notifications about command status changes.
	NotificationConfig *NotificationConfig `type:"structure"`

	// The S3 bucket where the responses to the command executions should be stored.
	// This was requested when issuing the command.
	OutputS3BucketName *string `min:"3" type:"string"`

	// The S3 directory path inside the bucket where the responses to the command
	// executions should be stored. This was requested when issuing the command.
	OutputS3KeyPrefix *string `type:"string"`

	// (Deprecated) You can no longer specify this parameter. The system ignores
	// it. Instead, Systems Manager automatically determines the Amazon S3 bucket
	// region.
	OutputS3Region *string `min:"3" type:"string"`

	// The parameter values to be inserted in the document when executing the command.
	Parameters map[string][]*string `type:"map"`

	// The date and time the command was requested.
	RequestedDateTime *time.Time `type:"timestamp"`

	// The IAM service role that Run Command uses to act on your behalf when sending
	// notifications about command status changes.
	ServiceRole *string `type:"string"`

	// The status of the command.
	Status *string `type:"string" enum:"CommandStatus"`

	// A detailed status of the command execution. StatusDetails includes more information
	// than Status because it includes states resulting from error and concurrency
	// control parameters. StatusDetails can show different results than Status.
	// For more information about these statuses, see Understanding Command Statuses
	// (http://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html)
	// in the AWS Systems Manager User Guide. StatusDetails can be one of the following
	// values:
	//
	//    * Pending: The command has not been sent to any instances.
	//
	//    * In Progress: The command has been sent to at least one instance but
	//    has not reached a final state on all instances.
	//
	//    * Success: The command successfully executed on all invocations. This
	//    is a terminal state.
	//
	//    * Delivery Timed Out: The value of MaxErrors or more command invocations
	//    shows a status of Delivery Timed Out. This is a terminal state.
	//
	//    * Execution Timed Out: The value of MaxErrors or more command invocations
	//    shows a status of Execution Timed Out. This is a terminal state.
	//
	//    * Failed: The value of MaxErrors or more command invocations shows a status
	//    of Failed. This is a terminal state.
	//
	//    * Incomplete: The command was attempted on all instances and one or more
	//    invocations does not have a value of Success but not enough invocations
	//    failed for the status to be Failed. This is a terminal state.
	//
	//    * Canceled: The command was terminated before it was completed. This is
	//    a terminal state.
	//
	//    * Rate Exceeded: The number of instances targeted by the command exceeded
	//    the account limit for pending invocations. The system has canceled the
	//    command before executing it on any instance. This is a terminal state.
	StatusDetails *string `type:"string"`

	// The number of targets for the command.
	TargetCount *int64 `type:"integer"`

	// An array of search criteria that targets instances using a Key,Value combination
	// that you specify. Targets is required if you don't provide one or more instance
	// IDs in the call.
	Targets []*Target `type:"list"`
}

// String returns the string representation
func (s Command) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Command) GoString() string {
	return s.String()
}

// SetCloudWatchOutputConfig sets the CloudWatchOutputConfig field's value.
func (s *Command) SetCloudWatchOutputConfig(v *CloudWatchOutputConfig) *Command {
	s.CloudWatchOutputConfig = v
	return s
}

// SetCommandId sets the CommandId field's value.
func (s *Command) SetCommandId(v string) *Command {
	s.CommandId = &v
	return s
}

// SetComment sets the Comment field's value.
func (s *Command) SetComment(v string) *Command {
	s.Comment = &v
	return s
}

// SetCompletedCount sets the CompletedCount field's value.
func (s *Command) SetCompletedCount(v int64) *Command {
	s.CompletedCount = &v
	return s
}

// SetDeliveryTimedOutCount sets the DeliveryTimedOutCount field's value.
func (s *Command) SetDeliveryTimedOutCount(v int64) *Command {
	s.DeliveryTimedOutCount = &v
	return s
}

// SetDocumentName sets the DocumentName field's value.
func (s *Command) SetDocumentName(v string) *Command {
	s.DocumentName = &v
	return s
}

// SetDocumentVersion sets the DocumentVersion field's value.
func (s *Command) SetDocumentVersion(v string) *Command {
	s.DocumentVersion = &v
	return s
}

// SetErrorCount sets the ErrorCount field's value.
func (s *Command) SetErrorCount(v int64) *Command {
	s.ErrorCount = &v
	return s
}

// SetExpiresAfter sets the ExpiresAfter field's value.
func (s *Command) SetExpiresAfter(v time.Time) *Command {
	s.ExpiresAfter = &v
	return s
}

// SetInstanceIds sets the InstanceIds field's value.
func (s *Command) SetInstanceIds(v []*string) *Command {
	s.InstanceIds = v
	return s
}

// SetMaxConcurrency sets the MaxConcurrency field's value.
func (s *Command) SetMaxConcurrency(v string) *Command {
	s.MaxConcurrency = &v
	return s
}

// SetMaxErrors sets the MaxErrors field's value.
func (s *Command) SetMaxErrors(v string) *Command {
	s.MaxErrors = &v
	return s
}

// SetNotificationConfig sets the NotificationConfig field's value.
func (s *Command) SetNotificationConfig(v *NotificationConfig) *Command {
	s.NotificationConfig = v
	return s
}

// SetOutputS3BucketName sets the OutputS3BucketName field's value.
func (s *Command) SetOutputS3BucketName(v string) *Command {
	s.OutputS3BucketName = &v
	return s
}

// SetOutputS3KeyPrefix sets the OutputS3KeyPrefix field's value.
func (s *Command) SetOutputS3KeyPrefix(v string) *Command {
	s.OutputS3KeyPrefix = &v
	return s
}

// SetOutputS3Region sets the OutputS3Region field's value.
func (s *Command) SetOutputS3Region(v string) *Command {
	s.OutputS3Region = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *Command) SetParameters(v map[string][]*string) *Command {
	s.Parameters = v
	return s
}

// SetRequestedDateTime sets the RequestedDateTime field's value.
func (s *Command) SetRequestedDateTime(v time.Time) *Command {
	s.RequestedDateTime = &v
	return s
}

// SetServiceRole sets the ServiceRole field's value.
func (s *Command) SetServiceRole(v string) *Command {
	s.ServiceRole = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Command) SetStatus(v string) *Command {
	s.Status = &v
	return s
}

// SetStatusDetails sets the StatusDetails field's value.
func (s *Command) SetStatusDetails(v string) *Command {
	s.StatusDetails = &v
	return s
}

// SetTargetCount sets the TargetCount field's value.
func (s *Command) SetTargetCount(v int64) *Command {
	s.TargetCount = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *Command) SetTargets(v []*Target) *Command {
	s.Targets = v
	return s
}

// Describes a command filter.
type CommandFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	//
	// Key is a required field
	Key *string `locationName:"key" type:"string" required:"true" enum:"CommandFilterKey"`

	// The filter value. Valid values for each filter key are as follows:
	//
	//    * InvokedAfter: Specify a timestamp to limit your results. For example,
	//    specify 2018-07-07T00:00:00Z to see a list of command executions occurring
	//    July 7, 2018, and later.
	//
	//    * InvokedBefore: Specify a timestamp to limit your results. For example,
	//    specify 2018-07-07T00:00:00Z to see a list of command executions from
	//    before July 7, 2018.
	//
	//    * Status: Specify a valid command status to see a list of all command
	//    executions with that status. Status values you can specify include:
	//
	// Pending
	//
	// InProgress
	//
	// Success
	//
	// Cancelled
	//
	// Failed
	//
	// TimedOut
	//
	// Cancelling
	//
	//    * DocumentName: Specify name of the SSM document for which you want to
	//    see command execution results. For example, specify AWS-RunPatchBaseline
	//    to see command executions that used this SSM document to perform security
	//    patching operations on instances.
	//
	//    * ExecutionStage: Specify one of the following values:
	//
	// Executing: Returns a list of command executions that are currently still
	//    running.
	//
	// Complete: Returns a list of command executions that have already completed.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CommandFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CommandFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CommandFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CommandFilter"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *CommandFilter) SetKey(v string) *CommandFilter {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *CommandFilter) SetValue(v string) *CommandFilter {
	s.Value = &v
	return s
}

// An invocation is copy of a command sent to a specific instance. A command
// can apply to one or more instances. A command invocation applies to one instance.
// For example, if a user executes SendCommand against three instances, then
// a command invocation is created for each requested instance ID. A command
// invocation returns status and detail information about a command you executed.
type CommandInvocation struct {
	_ struct{} `type:"structure"`

	// CloudWatch Logs information where you want Systems Manager to send the command
	// output.
	CloudWatchOutputConfig *CloudWatchOutputConfig `type:"structure"`

	// The command against which this invocation was requested.
	CommandId *string `min:"36" type:"string"`

	CommandPlugins []*CommandPlugin `type:"list"`

	// User-specified information about the command, such as a brief description
	// of what the command should do.
	Comment *string `type:"string"`

	// The document name that was requested for execution.
	DocumentName *string `type:"string"`

	// The SSM document version.
	DocumentVersion *string `type:"string"`

	// The instance ID in which this invocation was requested.
	InstanceId *string `type:"string"`

	// The name of the invocation target. For Amazon EC2 instances this is the value
	// for the aws:Name tag. For on-premises instances, this is the name of the
	// instance.
	InstanceName *string `type:"string"`

	// Configurations for sending notifications about command status changes on
	// a per instance basis.
	NotificationConfig *NotificationConfig `type:"structure"`

	// The time and date the request was sent to this instance.
	RequestedDateTime *time.Time `type:"timestamp"`

	// The IAM service role that Run Command uses to act on your behalf when sending
	// notifications about command status changes on a per instance basis.
	ServiceRole *string `type:"string"`

	// The URL to the plugin's StdErr file in Amazon S3, if the Amazon S3 bucket
	// was defined for the parent command. For an invocation, StandardErrorUrl is
	// populated if there is just one plugin defined for the command, and the Amazon
	// S3 bucket was defined for the command.
	StandardErrorUrl *string `type:"string"`

	// The URL to the plugin's StdOut file in Amazon S3, if the Amazon S3 bucket
	// was defined for the parent command. For an invocation, StandardOutputUrl
	// is populated if there is just one plugin defined for the command, and the
	// Amazon S3 bucket was defined for the command.
	StandardOutputUrl *string `type:"string"`

	// Whether or not the invocation succeeded, failed, or is pending.
	Status *string `type:"string" enum:"CommandInvocationStatus"`

	// A detailed status of the command execution for each invocation (each instance
	// targeted by the command). StatusDetails includes more information than Status
	// because it includes states resulting from error and concurrency control parameters.
	// StatusDetails can show different results than Status. For more information
	// about these statuses, see Understanding Command Statuses (http://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html)
	// in the AWS Systems Manager User Guide. StatusDetails can be one of the following
	// values:
	//
	//    * Pending: The command has not been sent to the instance.
	//
	//    * In Progress: The command has been sent to the instance but has not reached
	//    a terminal state.
	//
	//    * Success: The execution of the command or plugin was successfully completed.
	//    This is a terminal state.
	//
	//    * Delivery Timed Out: The command was not delivered to the instance before
	//    the delivery timeout expired. Delivery timeouts do not count against the
	//    parent command's MaxErrors limit, but they do contribute to whether the
	//    parent command status is Success or Incomplete. This is a terminal state.
	//
	//    * Execution Timed Out: Command execution started on the instance, but
	//    the execution was not complete before the execution timeout expired. Execution
	//    timeouts count against the MaxErrors limit of the parent command. This
	//    is a terminal state.
	//
	//    * Failed: The command was not successful on the instance. For a plugin,
	//    this indicates that the result code was not zero. For a command invocation,
	//    this indicates that the result code for one or more plugins was not zero.
	//    Invocation failures count against the MaxErrors limit of the parent command.
	//    This is a terminal state.
	//
	//    * Canceled: The command was terminated before it was completed. This is
	//    a terminal state.
	//
	//    * Undeliverable: The command can't be delivered to the instance. The instance
	//    might not exist or might not be responding. Undeliverable invocations
	//    don't count against the parent command's MaxErrors limit and don't contribute
	//    to whether the parent command status is Success or Incomplete. This is
	//    a terminal state.
	//
	//    * Terminated: The parent command exceeded its MaxErrors limit and subsequent
	//    command invocations were canceled by the system. This is a terminal state.
	StatusDetails *string `type:"string"`

	// Gets the trace output sent by the agent.
	TraceOutput *string `type:"string"`
}

// String returns the string representation
func (s CommandInvocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CommandInvocation) GoString() string {
	return s.String()
}

// SetCloudWatchOutputConfig sets the CloudWatchOutputConfig field's value.
func (s *CommandInvocation) SetCloudWatchOutputConfig(v *CloudWatchOutputConfig) *CommandInvocation {
	s.CloudWatchOutputConfig = v
	return s
}

// SetCommandId sets the CommandId field's value.
func (s *CommandInvocation) SetCommandId(v string) *CommandInvocation {
	s.CommandId = &v
	return s
}

// SetCommandPlugins sets the CommandPlugins field's value.
func (s *CommandInvocation) SetCommandPlugins(v []*CommandPlugin) *CommandInvocation {
	s.CommandPlugins = v
	return s
}

// SetComment sets the Comment field's value.
func (s *CommandInvocation) SetComment(v string) *CommandInvocation {
	s.Comment = &v
	return s
}

// SetDocumentName sets the DocumentName field's value.
func (s *CommandInvocation) SetDocumentName(v string) *CommandInvocation {
	s.DocumentName = &v
	return s
}

// SetDocumentVersion sets the DocumentVersion field's value.
func (s *CommandInvocation) SetDocumentVersion(v string) *CommandInvocation {
	s.DocumentVersion = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *CommandInvocation) SetInstanceId(v string) *CommandInvocation {
	s.InstanceId = &v
	return s
}

// SetInstanceName sets the InstanceName field's value.
func (s *CommandInvocation) SetInstanceName(v string) *CommandInvocation {
	s.InstanceName = &v
	return s
}

// SetNotificationConfig sets the NotificationConfig field's value.
func (s *CommandInvocation) SetNotificationConfig(v *NotificationConfig) *CommandInvocation {
	s.NotificationConfig = v
	return s
}

// SetRequestedDateTime sets the RequestedDateTime field's value.
func (s *CommandInvocation) SetRequestedDateTime(v time.Time) *CommandInvocation {
	s.RequestedDateTime = &v
	return s
}

// SetServiceRole sets the ServiceRole field's value.
func (s *CommandInvocation) SetServiceRole(v string) *CommandInvocation {
	s.ServiceRole = &v
	return s
}

// SetStandardErrorUrl sets the StandardErrorUrl field's value.
func (s *CommandInvocation) SetStandardErrorUrl(v string) *CommandInvocation {
	s.StandardErrorUrl = &v
	return s
}

// SetStandardOutputUrl sets the StandardOutputUrl field's value.
func (s *CommandInvocation) SetStandardOutputUrl(v string) *CommandInvocation {
	s.StandardOutputUrl = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CommandInvocation) SetStatus(v string) *CommandInvocation {
	s.Status = &v
	return s
}

// SetStatusDetails sets the StatusDetails field's value.
func (s *CommandInvocation) SetStatusDetails(v string) *CommandInvocation {
	s.StatusDetails = &v
	return s
}

// SetTraceOutput sets the TraceOutput field's value.
func (s *CommandInvocation) SetTraceOutput(v string) *CommandInvocation {
	s.TraceOutput = &v
	return s
}

// Describes plugin details.
type CommandPlugin struct {
	_ struct{} `type:"structure"`

	// The name of the plugin. Must be one of the following: aws:updateAgent, aws:domainjoin,
	// aws:applications, aws:runPowerShellScript, aws:psmodule, aws:cloudWatch,
	// aws:runShellScript, or aws:updateSSMAgent.
	Name *string `min:"4" type:"string"`

	// Output of the plugin execution.
	Output *string `type:"string"`

	// The S3 bucket where the responses to the command executions should be stored.
	// This was requested when issuing the command. For example, in the following
	// response:
	//
	// test_folder/ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix/i-1234567876543/awsrunShellScript
	//
	// test_folder is the name of the Amazon S3 bucket;
	//
	// ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix is the name of the S3 prefix;
	//
	// i-1234567876543 is the instance ID;
	//
	// awsrunShellScript is the name of the plugin.
	OutputS3BucketName *string `min:"3" type:"string"`

	// The S3 directory path inside the bucket where the responses to the command
	// executions should be stored. This was requested when issuing the command.
	// For example, in the following response:
	//
	// test_folder/ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix/i-1234567876543/awsrunShellScript
	//
	// test_folder is the name of the Amazon S3 bucket;
	//
	// ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix is the name of the S3 prefix;
	//
	// i-1234567876543 is the instance ID;
	//
	// awsrunShellScript is the name of the plugin.
	OutputS3KeyPrefix *string `type:"string"`

	// (Deprecated) You can no longer specify this parameter. The system ignores
	// it. Instead, Systems Manager automatically determines the Amazon S3 bucket
	// region.
	OutputS3Region *string `min:"3" type:"string"`

	// A numeric response code generated after executing the plugin.
	ResponseCode *int64 `type:"integer"`

	// The time the plugin stopped executing. Could stop prematurely if, for example,
	// a cancel command was sent.
	ResponseFinishDateTime *time.Time `type:"timestamp"`

	// The time the plugin started executing.
	ResponseStartDateTime *time.Time `type:"timestamp"`

	// The URL for the complete text written by the plugin to stderr. If execution
	// is not yet complete, then this string is empty.
	StandardErrorUrl *string `type:"string"`

	// The URL for the complete text written by the plugin to stdout in Amazon S3.
	// If the Amazon S3 bucket for the command was not specified, then this string
	// is empty.
	StandardOutputUrl *string `type:"string"`

	// The status of this plugin. You can execute a document with multiple plugins.
	Status *string `type:"string" enum:"CommandPluginStatus"`

	// A detailed status of the plugin execution. StatusDetails includes more information
	// than Status because it includes states resulting from error and concurrency
	// control parameters. StatusDetails can show different results than Status.
	// For more information about these statuses, see Understanding Command Statuses
	// (http://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html)
	// in the AWS Systems Manager User Guide. StatusDetails can be one of the following
	// values:
	//
	//    * Pending: The command has not been sent to the instance.
	//
	//    * In Progress: The command has been sent to the instance but has not reached
	//    a terminal state.
	//
	//    * Success: The execution of the command or plugin was successfully completed.
	//    This is a terminal state.
	//
	//    * Delivery Timed Out: The command was not delivered to the instance before
	//    the delivery timeout expired. Delivery timeouts do not count against the
	//    parent command's MaxErrors limit, but they do contribute to whether the
	//    parent command status is Success or Incomplete. This is a terminal state.
	//
	//    * Execution Timed Out: Command execution started on the instance, but
	//    the execution was not complete before the execution timeout expired. Execution
	//    timeouts count against the MaxErrors limit of the parent command. This
	//    is a terminal state.
	//
	//    * Failed: The command was not successful on the instance. For a plugin,
	//    this indicates that the result code was not zero. For a command invocation,
	//    this indicates that the result code for one or more plugins was not zero.
	//    Invocation failures count against the MaxErrors limit of the parent command.
	//    This is a terminal state.
	//
	//    * Canceled: The command was terminated before it was completed. This is
	//    a terminal state.
	//
	//    * Undeliverable: The command can't be delivered to the instance. The instance
	//    might not exist, or it might not be responding. Undeliverable invocations
	//    don't count against the parent command's MaxErrors limit, and they don't
	//    contribute to whether the parent command status is Success or Incomplete.
	//    This is a terminal state.
	//
	//    * Terminated: The parent command exceeded its MaxErrors limit and subsequent
	//    command invocations were canceled by the system. This is a terminal state.
	StatusDetails *string `type:"string"`
}

// String returns the string representation
func (s CommandPlugin) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CommandPlugin) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *CommandPlugin) SetName(v string) *CommandPlugin {
	s.Name = &v
	return s
}

// SetOutput sets the Output field's value.
func (s *CommandPlugin) SetOutput(v string) *CommandPlugin {
	s.Output = &v
	return s
}

// SetOutputS3BucketName sets the OutputS3BucketName field's value.
func (s *CommandPlugin) SetOutputS3BucketName(v string) *CommandPlugin {
	s.OutputS3BucketName = &v
	return s
}

// SetOutputS3KeyPrefix sets the OutputS3KeyPrefix field's value.
func (s *CommandPlugin) SetOutputS3KeyPrefix(v string) *CommandPlugin {
	s.OutputS3KeyPrefix = &v
	return s
}

// SetOutputS3Region sets the OutputS3Region field's value.
func (s *CommandPlugin) SetOutputS3Region(v string) *CommandPlugin {
	s.OutputS3Region = &v
	return s
}

// SetResponseCode sets the ResponseCode field's value.
func (s *CommandPlugin) SetResponseCode(v int64) *CommandPlugin {
	s.ResponseCode = &v
	return s
}

// SetResponseFinishDateTime sets the ResponseFinishDateTime field's value.
func (s *CommandPlugin) SetResponseFinishDateTime(v time.Time) *CommandPlugin {
	s.ResponseFinishDateTime = &v
	return s
}

// SetResponseStartDateTime sets the ResponseStartDateTime field's value.
func (s *CommandPlugin) SetResponseStartDateTime(v time.Time) *CommandPlugin {
	s.ResponseStartDateTime = &v
	return s
}

// SetStandardErrorUrl sets the StandardErrorUrl field's value.
func (s *CommandPlugin) SetStandardErrorUrl(v string) *CommandPlugin {
	s.StandardErrorUrl = &v
	return s
}

// SetStandardOutputUrl sets the StandardOutputUrl field's value.
func (s *CommandPlugin) SetStandardOutputUrl(v string) *CommandPlugin {
	s.StandardOutputUrl = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CommandPlugin) SetStatus(v string) *CommandPlugin {
	s.Status = &v
	return s
}

// SetStatusDetails sets the StatusDetails field's value.
func (s *CommandPlugin) SetStatusDetails(v string) *CommandPlugin {
	s.StatusDetails = &v
	return s
}

// A summary of the call execution that includes an execution ID, the type of
// execution (for example, Command), and the date/time of the execution using
// a datetime object that is saved in the following format: yyyy-MM-dd'T'HH:mm:ss'Z'.
type ComplianceExecutionSummary struct {
	_ struct{} `type:"structure"`

	// An ID created by the system when PutComplianceItems was called. For example,
	// CommandID is a valid execution ID. You can use this ID in subsequent calls.
	ExecutionId *string `type:"string"`

	// The time the execution ran as a datetime object that is saved in the following
	// format: yyyy-MM-dd'T'HH:mm:ss'Z'.
	//
	// ExecutionTime is a required field
	ExecutionTime *time.Time `type:"timestamp" required:"true"`

	// The type of execution. For example, Command is a valid execution type.
	ExecutionType *string `type:"string"`
}

// String returns the string representation
func (s ComplianceExecutionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ComplianceExecutionSummary) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComplianceExecutionSummary) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComplianceExecutionSummary"}
	if s.ExecutionTime == nil {
		invalidParams.Add(request.NewErrParamRequired("ExecutionTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExecutionId sets the ExecutionId field's value.
func (s *ComplianceExecutionSummary) SetExecutionId(v string) *ComplianceExecutionSummary {
	s.ExecutionId = &v
	return s
}

// SetExecutionTime sets the ExecutionTime field's value.
func (s *ComplianceExecutionSummary) SetExecutionTime(v time.Time) *ComplianceExecutionSummary {
	s.ExecutionTime = &v
	return s
}

// SetExecutionType sets the ExecutionType field's value.
func (s *ComplianceExecutionSummary) SetExecutionType(v string) *ComplianceExecutionSummary {
	s.ExecutionType = &v
	return s
}

// Information about the compliance as defined by the resource type. For example,
// for a patch resource type, Items includes information about the PatchSeverity,
// Classification, etc.
type ComplianceItem struct {
	_ struct{} `type:"structure"`

	// The compliance type. For example, Association (for a State Manager association),
	// Patch, or Custom:string are all valid compliance types.
	ComplianceType *string `min:"1" type:"string"`

	// A "Key": "Value" tag combination for the compliance item.
	Details map[string]*string `type:"map"`

	// A summary for the compliance item. The summary includes an execution ID,
	// the execution type (for example, command), and the execution time.
	ExecutionSummary *ComplianceExecutionSummary `type:"structure"`

	// An ID for the compliance item. For example, if the compliance item is a Windows
	// patch, the ID could be the number of the KB article; for example: KB4010320.
	Id *string `min:"1" type:"string"`

	// An ID for the resource. For a managed instance, this is the instance ID.
	ResourceId *string `min:"1" type:"string"`

	// The type of resource. ManagedInstance is currently the only supported resource
	// type.
	ResourceType *string `min:"1" type:"string"`

	// The severity of the compliance status. Severity can be one of the following:
	// Critical, High, Medium, Low, Informational, Unspecified.
	Severity *string `type:"string" enum:"ComplianceSeverity"`

	// The status of the compliance item. An item is either COMPLIANT or NON_COMPLIANT.
	Status *string `type:"string" enum:"ComplianceStatus"`

	// A title for the compliance item. For example, if the compliance item is a
	// Windows patch, the title could be the title of the KB article for the patch;
	// for example: Security Update for Active Directory Federation Services.
	Title *string `type:"string"`
}

// String returns the string representation
func (s ComplianceItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ComplianceItem) GoString() string {
	return s.String()
}

// SetComplianceType sets the ComplianceType field's value.
func (s *ComplianceItem) SetComplianceType(v string) *ComplianceItem {
	s.ComplianceType = &v
	return s
}

// SetDetails sets the Details field's value.
func (s *ComplianceItem) SetDetails(v map[string]*string) *ComplianceItem {
	s.Details = v
	return s
}

// SetExecutionSummary sets the ExecutionSummary field's value.
func (s *ComplianceItem) SetExecutionSummary(v *ComplianceExecutionSummary) *ComplianceItem {
	s.ExecutionSummary = v
	return s
}

// SetId sets the Id field's value.
func (s *ComplianceItem) SetId(v string) *ComplianceItem {
	s.Id = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ComplianceItem) SetResourceId(v string) *ComplianceItem {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ComplianceItem) SetResourceType(v string) *ComplianceItem {
	s.ResourceType = &v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *ComplianceItem) SetSeverity(v string) *ComplianceItem {
	s.Severity = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ComplianceItem) SetStatus(v string) *ComplianceItem {
	s.Status = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *ComplianceItem) SetTitle(v string) *ComplianceItem {
	s.Title = &v
	return s
}

// Information about a compliance item.
type ComplianceItemEntry struct {
	_ struct{} `type:"structure"`

	// A "Key": "Value" tag combination for the compliance item.
	Details map[string]*string `type:"map"`

	// The compliance item ID. For example, if the compliance item is a Windows
	// patch, the ID could be the number of the KB article.
	Id *string `min:"1" type:"string"`

	// The severity of the compliance status. Severity can be one of the following:
	// Critical, High, Medium, Low, Informational, Unspecified.
	//
	// Severity is a required field
	Severity *string `type:"string" required:"true" enum:"ComplianceSeverity"`

	// The status of the compliance item. An item is either COMPLIANT or NON_COMPLIANT.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"ComplianceStatus"`

	// The title of the compliance item. For example, if the compliance item is
	// a Windows patch, the title could be the title of the KB article for the patch;
	// for example: Security Update for Active Directory Federation Services.
	Title *string `type:"string"`
}

// String returns the string representation
func (s ComplianceItemEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ComplianceItemEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComplianceItemEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComplianceItemEntry"}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Severity == nil {
		invalidParams.Add(request.NewErrParamRequired("Severity"))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetails sets the Details field's value.
func (s *ComplianceItemEntry) SetDetails(v map[string]*string) *ComplianceItemEntry {
	s.Details = v
	return s
}

// SetId sets the Id field's value.
func (s *ComplianceItemEntry) SetId(v string) *ComplianceItemEntry {
	s.Id = &v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *ComplianceItemEntry) SetSeverity(v string) *ComplianceItemEntry {
	s.Severity = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ComplianceItemEntry) SetStatus(v string) *ComplianceItemEntry {
	s.Status = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *ComplianceItemEntry) SetTitle(v string) *ComplianceItemEntry {
	s.Title = &v
	return s
}

// One or more filters. Use a filter to return a more specific list of results.
type ComplianceStringFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	Key *string `min:"1" type:"string"`

	// The type of comparison that should be performed for the value: Equal, NotEqual,
	// BeginWith, LessThan, or GreaterThan.
	Type *string `type:"string" enum:"ComplianceQueryOperatorType"`

	// The value for which to search.
	Values []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s ComplianceStringFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ComplianceStringFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComplianceStringFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComplianceStringFilter"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *ComplianceStringFilter) SetKey(v string) *ComplianceStringFilter {
	s.Key = &v
	return s
}

// SetType sets the Type field's value.
func (s *ComplianceStringFilter) SetType(v string) *ComplianceStringFilter {
	s.Type = &v
	return s
}

// SetValues sets the Values field's value.
func (s *ComplianceStringFilter) SetValues(v []*string) *ComplianceStringFilter {
	s.Values = v
	return s
}

// A summary of compliance information by compliance type.
type ComplianceSummaryItem struct {
	_ struct{} `type:"structure"`

	// The type of compliance item. For example, the compliance type can be Association,
	// Patch, or Custom:string.
	ComplianceType *string `min:"1" type:"string"`

	// A list of COMPLIANT items for the specified compliance type.
	CompliantSummary *CompliantSummary `type:"structure"`

	// A list of NON_COMPLIANT items for the specified compliance type.
	NonCompliantSummary *NonCompliantSummary `type:"structure"`
}

// String returns the string representation
func (s ComplianceSummaryItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ComplianceSummaryItem) GoString() string {
	return s.String()
}

// SetComplianceType sets the ComplianceType field's value.
func (s *ComplianceSummaryItem) SetComplianceType(v string) *ComplianceSummaryItem {
	s.ComplianceType = &v
	return s
}

// SetCompliantSummary sets the CompliantSummary field's value.
func (s *ComplianceSummaryItem) SetCompliantSummary(v *CompliantSummary) *ComplianceSummaryItem {
	s.CompliantSummary = v
	return s
}

// SetNonCompliantSummary sets the NonCompliantSummary field's value.
func (s *ComplianceSummaryItem) SetNonCompliantSummary(v *NonCompliantSummary) *ComplianceSummaryItem {
	s.NonCompliantSummary = v
	return s
}

// A summary of resources that are compliant. The summary is organized according
// to the resource count for each compliance type.
type CompliantSummary struct {
	_ struct{} `type:"structure"`

	// The total number of resources that are compliant.
	CompliantCount *int64 `type:"integer"`

	// A summary of the compliance severity by compliance type.
	SeveritySummary *SeveritySummary `type:"structure"`
}

// String returns the string representation
func (s CompliantSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompliantSummary) GoString() string {
	return s.String()
}

// SetCompliantCount sets the CompliantCount field's value.
func (s *CompliantSummary) SetCompliantCount(v int64) *CompliantSummary {
	s.CompliantCount = &v
	return s
}

// SetSeveritySummary sets the SeveritySummary field's value.
func (s *CompliantSummary) SetSeveritySummary(v *SeveritySummary) *CompliantSummary {
	s.SeveritySummary = v
	return s
}

type CreateActivationInput struct {
	_ struct{} `type:"structure"`

	// The name of the registered, managed instance as it will appear in the Amazon
	// EC2 console or when you use the AWS command line tools to list EC2 resources.
	//
	// Do not enter personally identifiable information in this field.
	DefaultInstanceName *string `type:"string"`

	// A user-defined description of the resource that you want to register with
	// Amazon EC2.
	//
	// Do not enter personally identifiable information in this field.
	Description *string `type:"string"`

	// The date by which this activation request should expire. The default value
	// is 24 hours.
	ExpirationDate *time.Time `type:"timestamp"`

	// The Amazon Identity and Access Management (IAM) role that you want to assign
	// to the managed instance.
	//
	// IamRole is a required field
	IamRole *string `type:"string" required:"true"`

	// Specify the maximum number of managed instances you want to register. The
	// default value is 1 instance.
	RegistrationLimit *int64 `min:"1" type:"integer"`

	// Optional metadata that you assign to a resource. Tags enable you to categorize
	// a resource in different ways, such as by purpose, owner, or environment.
	// For example, you might want to tag an activation to identify which servers
	// or virtual machines (VMs) in your on-premises environment you intend to activate.
	// In this case, you could specify the following key name/value pairs:
	//
	//    * Key=OS,Value=Windows
	//
	//    * Key=Environment,Value=Production
	//
	// When you install SSM Agent on your on-premises servers and VMs, you specify
	// an activation ID and code. When you specify the activation ID and code, tags
	// assigned to the activation are automatically applied to the on-premises servers
	// or VMs.
	//
	// You can't add tags to or delete tags from an existing activation. You can
	// tag your on-premises servers and VMs after they connect to Systems Manager
	// for the first time and are assigned a managed instance ID. This means they
	// are listed in the AWS Systems Manager console with an ID that is prefixed
	// with "mi-". For information about how to add tags to your managed instances,
	// see AddTagsToResource. For information about how to remove tags from your
	// managed instances, see RemoveTagsFromResource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateActivationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateActivationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateActivationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateActivationInput"}
	if s.IamRole == nil {
		invalidParams.Add(request.NewErrParamRequired("IamRole"))
	}
	if s.RegistrationLimit != nil && *s.RegistrationLimit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("RegistrationLimit", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultInstanceName sets the DefaultInstanceName field's value.
func (s *CreateActivationInput) SetDefaultInstanceName(v string) *CreateActivationInput {
	s.DefaultInstanceName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateActivationInput) SetDescription(v string) *CreateActivationInput {
	s.Description = &v
	return s
}

// SetExpirationDate sets the ExpirationDate field's value.
func (s *CreateActivationInput) SetExpirationDate(v time.Time) *CreateActivationInput {
	s.ExpirationDate = &v
	return s
}

// SetIamRole sets the IamRole field's value.
func (s *CreateActivationInput) SetIamRole(v string) *CreateActivationInput {
	s.IamRole = &v
	return s
}

// SetRegistrationLimit sets the RegistrationLimit field's value.
func (s *CreateActivationInput) SetRegistrationLimit(v int64) *CreateActivationInput {
	s.RegistrationLimit = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateActivationInput) SetTags(v []*Tag) *CreateActivationInput {
	s.Tags = v
	return s
}

type CreateActivationOutput struct {
	_ struct{} `type:"structure"`

	// The code the system generates when it processes the activation. The activation
	// code functions like a password to validate the activation ID.
	ActivationCode *string `min:"20" type:"string"`

	// The ID number generated by the system when it processed the activation. The
	// activation ID functions like a user name.
	ActivationId *string `type:"string"`
}

// String returns the string representation
func (s CreateActivationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateActivationOutput) GoString() string {
	return s.String()
}

// SetActivationCode sets the ActivationCode field's value.
func (s *CreateActivationOutput) SetActivationCode(v string) *CreateActivationOutput {
	s.ActivationCode = &v
	return s
}

// SetActivationId sets the ActivationId field's value.
func (s *CreateActivationOutput) SetActivationId(v string) *CreateActivationOutput {
	s.ActivationId = &v
	return s
}

type CreateAssociationBatchInput struct {
	_ struct{} `type:"structure"`

	// One or more associations.
	//
	// Entries is a required field
	Entries []*CreateAssociationBatchRequestEntry `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s CreateAssociationBatchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAssociationBatchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAssociationBatchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAssociationBatchInput"}
	if s.Entries == nil {
		invalidParams.Add(request.NewErrParamRequired("Entries"))
	}
	if s.Entries != nil && len(s.Entries) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Entries", 1))
	}
	if s.Entries != nil {
		for i, v := range s.Entries {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Entries", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntries sets the Entries field's value.
func (s *CreateAssociationBatchInput) SetEntries(v []*CreateAssociationBatchRequestEntry) *CreateAssociationBatchInput {
	s.Entries = v
	return s
}

type CreateAssociationBatchOutput struct {
	_ struct{} `type:"structure"`

	// Information about the associations that failed.
	Failed []*FailedCreateAssociation `type:"list"`

	// Information about the associations that succeeded.
	Successful []*AssociationDescription `type:"list"`
}

// String returns the string representation
func (s CreateAssociationBatchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAssociationBatchOutput) GoString() string {
	return s.String()
}

// SetFailed sets the Failed field's value.
func (s *CreateAssociationBatchOutput) SetFailed(v []*FailedCreateAssociation) *CreateAssociationBatchOutput {
	s.Failed = v
	return s
}

// SetSuccessful sets the Successful field's value.
func (s *CreateAssociationBatchOutput) SetSuccessful(v []*AssociationDescription) *CreateAssociationBatchOutput {
	s.Successful = v
	return s
}

// Describes the association of a Systems Manager SSM document and an instance.
type CreateAssociationBatchRequestEntry struct {
	_ struct{} `type:"structure"`

	// Specify a descriptive name for the association.
	AssociationName *string `type:"string"`

	// Specify the target for the association. This target is required for associations
	// that use an Automation document and target resources by using rate controls.
	AutomationTargetParameterName *string `min:"1" type:"string"`

	// The severity level to assign to the association.
	ComplianceSeverity *string `type:"string" enum:"AssociationComplianceSeverity"`

	// The document version.
	DocumentVersion *string `type:"string"`

	// The ID of the instance.
	InstanceId *string `type:"string"`

	// The maximum number of targets allowed to run the association at the same
	// time. You can specify a number, for example 10, or a percentage of the target
	// set, for example 10%. The default value is 100%, which means all targets
	// run the association at the same time.
	//
	// If a new instance starts and attempts to execute an association while Systems
	// Manager is executing MaxConcurrency associations, the association is allowed
	// to run. During the next association interval, the new instance will process
	// its association within the limit specified for MaxConcurrency.
	MaxConcurrency *string `min:"1" type:"string"`

	// The number of errors that are allowed before the system stops sending requests
	// to run the association on additional targets. You can specify either an absolute
	// number of errors, for example 10, or a percentage of the target set, for
	// example 10%. If you specify 3, for example, the system stops sending requests
	// when the fourth error is received. If you specify 0, then the system stops
	// sending requests after the first error is returned. If you run an association
	// on 50 instances and set MaxError to 10%, then the system stops sending the
	// request when the sixth error is received.
	//
	// Executions that are already running an association when MaxErrors is reached
	// are allowed to complete, but some of these executions may fail as well. If
	// you need to ensure that there won't be more than max-errors failed executions,
	// set MaxConcurrency to 1 so that executions proceed one at a time.
	MaxErrors *string `min:"1" type:"string"`

	// The name of the configuration document.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// An Amazon S3 bucket where you want to store the results of this request.
	OutputLocation *InstanceAssociationOutputLocation `type:"structure"`

	// A description of the parameters for a document.
	Parameters map[string][]*string `type:"map"`

	// A cron expression that specifies a schedule when the association runs.
	ScheduleExpression *string `min:"1" type:"string"`

	// The instances targeted by the request.
	Targets []*Target `type:"list"`
}

// String returns the string representation
func (s CreateAssociationBatchRequestEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAssociationBatchRequestEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAssociationBatchRequestEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAssociationBatchRequestEntry"}
	if s.AutomationTargetParameterName != nil && len(*s.AutomationTargetParameterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutomationTargetParameterName", 1))
	}
	if s.MaxConcurrency != nil && len(*s.MaxConcurrency) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MaxConcurrency", 1))
	}
	if s.MaxErrors != nil && len(*s.MaxErrors) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MaxErrors", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.ScheduleExpression != nil && len(*s.ScheduleExpression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScheduleExpression", 1))
	}
	if s.OutputLocation != nil {
		if err := s.OutputLocation.Validate(); err != nil {
			invalidParams.AddNested("OutputLocation", err.(request.ErrInvalidParams))
		}
	}
	if s.Targets != nil {
		for i, v := range s.Targets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Targets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssociationName sets the AssociationName field's value.
func (s *CreateAssociationBatchRequestEntry) SetAssociationName(v string) *CreateAssociationBatchRequestEntry {
	s.AssociationName = &v
	return s
}

// SetAutomationTargetParameterName sets the AutomationTargetParameterName field's value.
func (s *CreateAssociationBatchRequestEntry) SetAutomationTargetParameterName(v string) *CreateAssociationBatchRequestEntry {
	s.AutomationTargetParameterName = &v
	return s
}

// SetComplianceSeverity sets the ComplianceSeverity field's value.
func (s *CreateAssociationBatchRequestEntry) SetComplianceSeverity(v string) *CreateAssociationBatchRequestEntry {
	s.ComplianceSeverity = &v
	return s
}

// SetDocumentVersion sets the DocumentVersion field's value.
func (s *CreateAssociationBatchRequestEntry) SetDocumentVersion(v string) *CreateAssociationBatchRequestEntry {
	s.DocumentVersion = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateAssociationBatchRequestEntry) SetInstanceId(v string) *CreateAssociationBatchRequestEntry {
	s.InstanceId = &v
	return s
}

// SetMaxConcurrency sets the MaxConcurrency field's value.
func (s *CreateAssociationBatchRequestEntry) SetMaxConcurrency(v string) *CreateAssociationBatchRequestEntry {
	s.MaxConcurrency = &v
	return s
}

// SetMaxErrors sets the MaxErrors field's value.
func (s *CreateAssociationBatchRequestEntry) SetMaxErrors(v string) *CreateAssociationBatchRequestEntry {
	s.MaxErrors = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAssociationBatchRequestEntry) SetName(v string) *CreateAssociationBatchRequestEntry {
	s.Name = &v
	return s
}

// SetOutputLocation sets the OutputLocation field's value.
func (s *CreateAssociationBatchRequestEntry) SetOutputLocation(v *InstanceAssociationOutputLocation) *CreateAssociationBatchRequestEntry {
	s.OutputLocation = v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *CreateAssociationBatchRequestEntry) SetParameters(v map[string][]*string) *CreateAssociationBatchRequestEntry {
	s.Parameters = v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *CreateAssociationBatchRequestEntry) SetScheduleExpression(v string) *CreateAssociationBatchRequestEntry {
	s.ScheduleExpression = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *CreateAssociationBatchRequestEntry) SetTargets(v []*Target) *CreateAssociationBatchRequestEntry {
	s.Targets = v
	return s
}

type CreateAssociationInput struct {
	_ struct{} `type:"structure"`

	// Specify a descriptive name for the association.
	AssociationName *string `type:"string"`

	// Specify the target for the association. This target is required for associations
	// that use an Automation document and target resources by using rate controls.
	AutomationTargetParameterName *string `min:"1" type:"string"`

	// The severity level to assign to the association.
	ComplianceSeverity *string `type:"string" enum:"AssociationComplianceSeverity"`

	// The document version you want to associate with the target(s). Can be a specific
	// version or the default version.
	DocumentVersion *string `type:"string"`

	// The instance ID.
	InstanceId *string `type:"string"`

	// The maximum number of targets allowed to run the association at the same
	// time. You can specify a number, for example 10, or a percentage of the target
	// set, for example 10%. The default value is 100%, which means all targets
	// run the association at the same time.
	//
	// If a new instance starts and attempts to execute an association while Systems
	// Manager is executing MaxConcurrency associations, the association is allowed
	// to run. During the next association interval, the new instance will process
	// its association within the limit specified for MaxConcurrency.
	MaxConcurrency *string `min:"1" type:"string"`

	// The number of errors that are allowed before the system stops sending requests
	// to run the association on additional targets. You can specify either an absolute
	// number of errors, for example 10, or a percentage of the target set, for
	// example 10%. If you specify 3, for example, the system stops sending requests
	// when the fourth error is received. If you specify 0, then the system stops
	// sending requests after the first error is returned. If you run an association
	// on 50 instances and set MaxError to 10%, then the system stops sending the
	// request when the sixth error is received.
	//
	// Executions that are already running an association when MaxErrors is reached
	// are allowed to complete, but some of these executions may fail as well. If
	// you need to ensure that there won't be more than max-errors failed executions,
	// set MaxConcurrency to 1 so that executions proceed one at a time.
	MaxErrors *string `min:"1" type:"string"`

	// The name of the Systems Manager document.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// An Amazon S3 bucket where you want to store the output details of the request.
	OutputLocation *InstanceAssociationOutputLocation `type:"structure"`

	// The parameters for the documents runtime configuration.
	Parameters map[string][]*string `type:"map"`

	// A cron expression when the association will be applied to the target(s).
	ScheduleExpression *string `min:"1" type:"string"`

	// The targets (either instances or tags) for the association.
	Targets []*Target `type:"list"`
}

// String returns the string representation
func (s CreateAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAssociationInput"}
	if s.AutomationTargetParameterName != nil && len(*s.AutomationTargetParameterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutomationTargetParameterName", 1))
	}
	if s.MaxConcurrency != nil && len(*s.MaxConcurrency) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MaxConcurrency", 1))
	}
	if s.MaxErrors != nil && len(*s.MaxErrors) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MaxErrors", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.ScheduleExpression != nil && len(*s.ScheduleExpression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScheduleExpression", 1))
	}
	if s.OutputLocation != nil {
		if err := s.OutputLocation.Validate(); err != nil {
			invalidParams.AddNested("OutputLocation", err.(request.ErrInvalidParams))
		}
	}
	if s.Targets != nil {
		for i, v := range s.Targets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Targets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssociationName sets the AssociationName field's value.
func (s *CreateAssociationInput) SetAssociationName(v string) *CreateAssociationInput {
	s.AssociationName = &v
	return s
}

// SetAutomationTargetParameterName sets the AutomationTargetParameterName field's value.
func (s *CreateAssociationInput) SetAutomationTargetParameterName(v string) *CreateAssociationInput {
	s.AutomationTargetParameterName = &v
	return s
}

// SetComplianceSeverity sets the ComplianceSeverity field's value.
func (s *CreateAssociationInput) SetComplianceSeverity(v string) *CreateAssociationInput {
	s.ComplianceSeverity = &v
	return s
}

// SetDocumentVersion sets the DocumentVersion field's value.
func (s *CreateAssociationInput) SetDocumentVersion(v string) *CreateAssociationInput {
	s.DocumentVersion = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateAssociationInput) SetInstanceId(v string) *CreateAssociationInput {
	s.InstanceId = &v
	return s
}

// SetMaxConcurrency sets the MaxConcurrency field's value.
func (s *CreateAssociationInput) SetMaxConcurrency(v string) *CreateAssociationInput {
	s.MaxConcurrency = &v
	return s
}

// SetMaxErrors sets the MaxErrors field's value.
func (s *CreateAssociationInput) SetMaxErrors(v string) *CreateAssociationInput {
	s.MaxErrors = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAssociationInput) SetName(v string) *CreateAssociationInput {
	s.Name = &v
	return s
}

// SetOutputLocation sets the OutputLocation field's value.
func (s *CreateAssociationInput) SetOutputLocation(v *InstanceAssociationOutputLocation) *CreateAssociationInput {
	s.OutputLocation = v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *CreateAssociationInput) SetParameters(v map[string][]*string) *CreateAssociationInput {
	s.Parameters = v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *CreateAssociationInput) SetScheduleExpression(v string) *CreateAssociationInput {
	s.ScheduleExpression = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *CreateAssociationInput) SetTargets(v []*Target) *CreateAssociationInput {
	s.Targets = v
	return s
}

type CreateAssociationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the association.
	AssociationDescription *AssociationDescription `type:"structure"`
}

// String returns the string representation
func (s CreateAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAssociationOutput) GoString() string {
	return s.String()
}

// SetAssociationDescription sets the AssociationDescription field's value.
func (s *CreateAssociationOutput) SetAssociationDescription(v *AssociationDescription) *CreateAssociationOutput {
	s.AssociationDescription = v
	return s
}

type CreateDocumentInput struct {
	_ struct{} `type:"structure"`

	// A list of key and value pairs that describe attachments to a version of a
	// document.
	Attachments []*AttachmentsSource `type:"list"`

	// A valid JSON or YAML string.
	//
	// Content is a required field
	Content *string `min:"1" type:"string" required:"true"`

	// Specify the document format for the request. The document format can be either
	// JSON or YAML. JSON is the default format.
	DocumentFormat *string `type:"string" enum:"DocumentFormat"`

	// The type of document to create. Valid document types include: Command, Policy,
	// Automation, Session, and Package.
	DocumentType *string `type:"string" enum:"DocumentType"`

	// A name for the Systems Manager document.
	//
	// Do not use the following to begin the names of documents you create. They
	// are reserved by AWS for use as document prefixes:
	//
	// aws
	//
	// amazon
	//
	// amzn
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// Optional metadata that you assign to a resource. Tags enable you to categorize
	// a resource in different ways, such as by purpose, owner, or environment.
	// For example, you might want to tag an SSM document to identify the types
	// of targets or the environment where it will run. In this case, you could
	// specify the following key name/value pairs:
	//
	//    * Key=OS,Value=Windows
	//
	//    * Key=Environment,Value=Production
	//
	// To add tags to an existing SSM document, use the AddTagsToResource action.
	Tags []*Tag `type:"list"`

	// Specify a target type to define the kinds of resources the document can run
	// on. For example, to run a document on EC2 instances, specify the following
	// value: /AWS::EC2::Instance. If you specify a value of '/' the document can
	// run on all types of resources. If you don't specify a value, the document
	// can't run on any resources. For a list of valid resource types, see AWS Resource
	// Types Reference (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the AWS CloudFormation User Guide.
	TargetType *string `type:"string"`

	// An optional field specifying the version of the artifact you are creating
	// with the document. For example, "Release 12, Update 6". This value is unique
	// across all versions of a document, and cannot be changed.
	VersionName *string `type:"string"`
}

// String returns the string representation
func (s CreateDocumentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDocumentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDocumentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDocumentInput"}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.Content != nil && len(*s.Content) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Content", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Attachments != nil {
		for i, v := range s.Attachments {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attachments", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttachments sets the Attachments field's value.
func (s *CreateDocumentInput) SetAttachments(v []*AttachmentsSource) *CreateDocumentInput {
	s.Attachments = v
	return s
}

// SetContent sets the Content field's value.
func (s *CreateDocumentInput) SetContent(v string) *CreateDocumentInput {
	s.Content = &v
	return s
}

// SetDocumentFormat sets the DocumentFormat field's value.
func (s *CreateDocumentInput) SetDocumentFormat(v string) *CreateDocumentInput {
	s.DocumentFormat = &v
	return s
}

// SetDocumentType sets the DocumentType field's value.
func (s *CreateDocumentInput) SetDocumentType(v string) *CreateDocumentInput {
	s.DocumentType = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDocumentInput) SetName(v string) *CreateDocumentInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDocumentInput) SetTags(v []*Tag) *CreateDocumentInput {
	s.Tags = v
	return s
}

// SetTargetType sets the TargetType field's value.
func (s *CreateDocumentInput) SetTargetType(v string) *CreateDocumentInput {
	s.TargetType = &v
	return s
}

// SetVersionName sets the VersionName field's value.
func (s *CreateDocumentInput) SetVersionName(v string) *CreateDocumentInput {
	s.VersionName = &v
	return s
}

type CreateDocumentOutput struct {
	_ struct{} `type:"structure"`

	// Information about the Systems Manager document.
	DocumentDescription *DocumentDescription `type:"structure"`
}

// String returns the string representation
func (s CreateDocumentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDocumentOutput) GoString() string {
	return s.String()
}

// SetDocumentDescription sets the DocumentDescription field's value.
func (s *CreateDocumentOutput) SetDocumentDescription(v *DocumentDescription) *CreateDocumentOutput {
	s.DocumentDescription = v
	return s
}

type CreateMaintenanceWindowInput struct {
	_ struct{} `type:"structure"`

	// Enables a Maintenance Window task to execute on managed instances, even if
	// you have not registered those instances as targets. If enabled, then you
	// must specify the unregistered instances (by instance ID) when you register
	// a task with the Maintenance Window
	//
	// If you don't enable this option, then you must specify previously-registered
	// targets when you register a task with the Maintenance Window.
	//
	// AllowUnassociatedTargets is a required field
	AllowUnassociatedTargets *bool `type:"boolean" required:"true"`

	// User-provided idempotency token.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The number of hours before the end of the Maintenance Window that Systems
	// Manager stops scheduling new tasks for execution.
	//
	// Cutoff is a required field
	Cutoff *int64 `type:"integer" required:"true"`

	// An optional description for the Maintenance Window. We recommend specifying
	// a description to help you organize your Maintenance Windows.
	Description *string `min:"1" type:"string" sensitive:"true"`

	// The duration of the Maintenance Window in hours.
	//
	// Duration is a required field
	Duration *int64 `min:"1" type:"integer" required:"true"`

	// The date and time, in ISO-8601 Extended format, for when you want the Maintenance
	// Window to become inactive. EndDate allows you to set a date and time in the
	// future when the Maintenance Window will no longer run.
	EndDate *string `type:"string"`

	// The name of the Maintenance Window.
	//
	// Name is a required field
	Name *string `min:"3" type:"string" required:"true"`

	// The schedule of the Maintenance Window in the form of a cron or rate expression.
	//
	// Schedule is a required field
	Schedule *string `min:"1" type:"string" required:"true"`

	// The time zone that the scheduled Maintenance Window executions are based
	// on, in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles",
	// "etc/UTC", or "Asia/Seoul". For more information, see the Time Zone Database
	// (https://www.iana.org/time-zones) on the IANA website.
	ScheduleTimezone *string `type:"string"`

	// The date and time, in ISO-8601 Extended format, for when you want the Maintenance
	// Window to become active. StartDate allows you to delay activation of the
	// Maintenance Window until the specified future date.
	StartDate *string `type:"string"`

	// Optional metadata that you assign to a resource. Tags enable you to categorize
	// a resource in different ways, such as by purpose, owner, or environment.
	// For example, you might want to tag a Maintenance Window to identify the type
	// of tasks it will run, the types of targets, and the environment it will run
	// in. In this case, you could specify the following key name/value pairs:
	//
	//    * Key=TaskType,Value=AgentUpdate
	//
	//    * Key=OS,Value=Windows
	//
	//    * Key=Environment,Value=Production
	//
	// To add tags to an existing Maintenance Window, use the AddTagsToResource
	// action.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateMaintenanceWindowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMaintenanceWindowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMaintenanceWindowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMaintenanceWindowInput"}
	if s.AllowUnassociatedTargets == nil {
		invalidParams.Add(request.NewErrParamRequired("AllowUnassociatedTargets"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Cutoff == nil {
		invalidParams.Add(request.NewErrParamRequired("Cutoff"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Duration == nil {
		invalidParams.Add(request.NewErrParamRequired("Duration"))
	}
	if s.Duration != nil && *s.Duration < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Duration", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.Schedule == nil {
		invalidParams.Add(request.NewErrParamRequired("Schedule"))
	}
	if s.Schedule != nil && len(*s.Schedule) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Schedule", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowUnassociatedTargets sets the AllowUnassociatedTargets field's value.
func (s *CreateMaintenanceWindowInput) SetAllowUnassociatedTargets(v bool) *CreateMaintenanceWindowInput {
	s.AllowUnassociatedTargets = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateMaintenanceWindowInput) SetClientToken(v string) *CreateMaintenanceWindowInput {
	s.ClientToken = &v
	return s
}

// SetCutoff sets the Cutoff field's value.
func (s *CreateMaintenanceWindowInput) SetCutoff(v int64) *CreateMaintenanceWindowInput {
	s.Cutoff = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateMaintenanceWindowInput) SetDescription(v string) *CreateMaintenanceWindowInput {
	s.Description = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *CreateMaintenanceWindowInput) SetDuration(v int64) *CreateMaintenanceWindowInput {
	s.Duration = &v
	return s
}

// SetEndDate sets the EndDate field's value.
func (s *CreateMaintenanceWindowInput) SetEndDate(v string) *CreateMaintenanceWindowInput {
	s.EndDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateMaintenanceWindowInput) SetName(v string) *CreateMaintenanceWindowInput {
	s.Name = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *CreateMaintenanceWindowInput) SetSchedule(v string) *CreateMaintenanceWindowInput {
	s.Schedule = &v
	return s
}

// SetScheduleTimezone sets the ScheduleTimezone field's value.
func (s *CreateMaintenanceWindowInput) SetScheduleTimezone(v string) *CreateMaintenanceWindowInput {
	s.ScheduleTimezone = &v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *CreateMaintenanceWindowInput) SetStartDate(v string) *CreateMaintenanceWindowInput {
	s.StartDate = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateMaintenanceWindowInput) SetTags(v []*Tag) *CreateMaintenanceWindowInput {
	s.Tags = v
	return s
}

type CreateMaintenanceWindowOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the created Maintenance Window.
	WindowId *string `min:"20" type:"string"`
}

// String returns the string representation
func (s CreateMaintenanceWindowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMaintenanceWindowOutput) GoString() string {
	return s.String()
}

// SetWindowId sets the WindowId field's value.
func (s *CreateMaintenanceWindowOutput) SetWindowId(v string) *CreateMaintenanceWindowOutput {
	s.WindowId = &v
	return s
}

type CreatePatchBaselineInput struct {
	_ struct{} `type:"structure"`

	// A set of rules used to include patches in the baseline.
	ApprovalRules *PatchRuleGroup `type:"structure"`

	// A list of explicitly approved patches for the baseline.
	//
	// For information about accepted formats for lists of approved patches and
	// rejected patches, see Package Name Formats for Approved and Rejected Patch
	// Lists (http://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html)
	// in the AWS Systems Manager User Guide.
	ApprovedPatches []*string `type:"list"`

	// Defines the compliance level for approved patches. This means that if an
	// approved patch is reported as missing, this is the severity of the compliance
	// violation. The default value is UNSPECIFIED.
	ApprovedPatchesComplianceLevel *string `type:"string" enum:"PatchComplianceLevel"`

	// Indicates whether the list of approved patches includes non-security updates
	// that should be applied to the instances. The default value is 'false'. Applies
	// to Linux instances only.
	ApprovedPatchesEnableNonSecurity *bool `type:"boolean"`

	// User-provided idempotency token.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// A description of the patch baseline.
	Description *string `min:"1" type:"string"`

	// A set of global filters used to exclude patches from the baseline.
	GlobalFilters *PatchFilterGroup `type:"structure"`

	// The name of the patch baseline.
	//
	// Name is a required field
	Name *string `min:"3" type:"string" required:"true"`

	// Defines the operating system the patch baseline applies to. The Default value
	// is WINDOWS.
	OperatingSystem *string `type:"string" enum:"OperatingSystem"`

	// A list of explicitly rejected patches for the baseline.
	//
	// For information about accepted formats for lists of approved patches and
	// rejected patches, see Package Name Formats for Approved and Rejected Patch
	// Lists (http://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html)
	// in the AWS Systems Manager User Guide.
	RejectedPatches []*string `type:"list"`

	// The action for Patch Manager to take on patches included in the RejectedPackages
	// list.
	//
	//    * ALLOW_AS_DEPENDENCY: A package in the Rejected patches list is installed
	//    only if it is a dependency of another package. It is considered compliant
	//    with the patch baseline, and its status is reported as InstalledOther.
	//    This is the default action if no option is specified.
	//
	//    * BLOCK: Packages in the RejectedPatches list, and packages that include
	//    them as dependencies, are not installed under any circumstances. If a
	//    package was installed before it was added to the Rejected patches list,
	//    it is considered non-compliant with the patch baseline, and its status
	//    is reported as InstalledRejected.
	RejectedPatchesAction *string `type:"string" enum:"PatchAction"`

	// Information about the patches to use to update the instances, including target
	// operating systems and source repositories. Applies to Linux instances only.
	Sources []*PatchSource `type:"list"`

	// Optional metadata that you assign to a resource. Tags enable you to categorize
	// a resource in different ways, such as by purpose, owner, or environment.
	// For example, you might want to tag a patch baseline to identify the severity
	// level of patches it specifies and the operating system family it applies
	// to. In this case, you could specify the following key name/value pairs:
	//
	//    * Key=PatchSeverity,Value=Critical
	//
	//    * Key=OS,Value=Windows
	//
	// To add tags to an existing patch baseline, use the AddTagsToResource action.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreatePatchBaselineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePatchBaselineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePatchBaselineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePatchBaselineInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.ApprovalRules != nil {
		if err := s.ApprovalRules.Validate(); err != nil {
			invalidParams.AddNested("ApprovalRules", err.(request.ErrInvalidParams))
		}
	}
	if s.GlobalFilters != nil {
		if err := s.GlobalFilters.Validate(); err != nil {
			invalidParams.AddNested("GlobalFilters", err.(request.ErrInvalidParams))
		}
	}
	if s.Sources != nil {
		for i, v := range s.Sources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Sources", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApprovalRules sets the ApprovalRules field's value.
func (s *CreatePatchBaselineInput) SetApprovalRules(v *PatchRuleGroup) *CreatePatchBaselineInput {
	s.ApprovalRules = v
	return s
}

// SetApprovedPatches sets the ApprovedPatches field's value.
func (s *CreatePatchBaselineInput) SetApprovedPatches(v []*string) *CreatePatchBaselineInput {
	s.ApprovedPatches = v
	return s
}

// SetApprovedPatchesComplianceLevel sets the ApprovedPatchesComplianceLevel field's value.
func (s *CreatePatchBaselineInput) SetApprovedPatchesComplianceLevel(v string) *CreatePatchBaselineInput {
	s.ApprovedPatchesComplianceLevel = &v
	return s
}

// SetApprovedPatchesEnableNonSecurity sets the ApprovedPatchesEnableNonSecurity field's value.
func (s *CreatePatchBaselineInput) SetApprovedPatchesEnableNonSecurity(v bool) *CreatePatchBaselineInput {
	s.ApprovedPatchesEnableNonSecurity = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreatePatchBaselineInput) SetClientToken(v string) *CreatePatchBaselineInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreatePatchBaselineInput) SetDescription(v string) *CreatePatchBaselineInput {
	s.Description = &v
	return s
}

// SetGlobalFilters sets the GlobalFilters field's value.
func (s *CreatePatchBaselineInput) SetGlobalFilters(v *PatchFilterGroup) *CreatePatchBaselineInput {
	s.GlobalFilters = v
	return s
}

// SetName sets the Name field's value.
func (s *CreatePatchBaselineInput) SetName(v string) *CreatePatchBaselineInput {
	s.Name = &v
	return s
}

// SetOperatingSystem sets the OperatingSystem field's value.
func (s *CreatePatchBaselineInput) SetOperatingSystem(v string) *CreatePatchBaselineInput {
	s.OperatingSystem = &v
	return s
}

// SetRejectedPatches sets the RejectedPatches field's value.
func (s *CreatePatchBaselineInput) SetRejectedPatches(v []*string) *CreatePatchBaselineInput {
	s.RejectedPatches = v
	return s
}

// SetRejectedPatchesAction sets the RejectedPatchesAction field's value.
func (s *CreatePatchBaselineInput) SetRejectedPatchesAction(v string) *CreatePatchBaselineInput {
	s.RejectedPatchesAction = &v
	return s
}

// SetSources sets the Sources field's value.
func (s *CreatePatchBaselineInput) SetSources(v []*PatchSource) *CreatePatchBaselineInput {
	s.Sources = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreatePatchBaselineInput) SetTags(v []*Tag) *CreatePatchBaselineInput {
	s.Tags = v
	return s
}

type CreatePatchBaselineOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the created patch baseline.
	BaselineId *string `min:"20" type:"string"`
}

// String returns the string representation
func (s CreatePatchBaselineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePatchBaselineOutput) GoString() string {
	return s.String()
}

// SetBaselineId sets the BaselineId field's value.
func (s *CreatePatchBaselineOutput) SetBaselineId(v string) *CreatePatchBaselineOutput {
	s.BaselineId = &v
	return s
}

type CreateResourceDataSyncInput struct {
	_ struct{} `type:"structure"`

	// Amazon S3 configuration details for the sync.
	//
	// S3Destination is a required field
	S3Destination *ResourceDataSyncS3Destination `type:"structure" required:"true"`

	// A name for the configuration.
	//
	// SyncName is a required field
	SyncName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateResourceDataSyncInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResourceDataSyncInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateResourceDataSyncInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateResourceDataSyncInput"}
	if s.S3Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Destination"))
	}
	if s.SyncName == nil {
		invalidParams.Add(request.NewErrParamRequired("SyncName"))
	}
	if s.SyncName != nil && len(*s.SyncName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SyncName", 1))
	}
	if s.S3Destination != nil {
		if err := s.S3Destination.Validate(); err != nil {
			invalidParams.AddNested("S3Destination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Destination sets the S3Destination field's value.
func (s *CreateResourceDataSyncInput) SetS3Destination(v *ResourceDataSyncS3Destination) *CreateResourceDataSyncInput {
	s.S3Destination = v
	return s
}

// SetSyncName sets the SyncName field's value.
func (s *CreateResourceDataSyncInput) SetSyncName(v string) *CreateResourceDataSyncInput {
	s.SyncName = &v
	return s
}

type CreateResourceDataSyncOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateResourceDataSyncOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResourceDataSyncOutput) GoString() string {
	return s.String()
}

type DeleteActivationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the activation that you want to delete.
	//
	// ActivationId is a required field
	ActivationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteActivationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteActivationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteActivationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteActivationInput"}
	if s.ActivationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ActivationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActivationId sets the ActivationId field's value.
func (s *DeleteActivationInput) SetActivationId(v string) *DeleteActivationInput {
	s.ActivationId = &v
	return s
}

type DeleteActivationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteActivationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteActivationOutput) GoString() string {
	return s.String()
}

type DeleteAssociationInput struct {
	_ struct{} `type:"structure"`

	// The association ID that you want to delete.
	AssociationId *string `type:"string"`

	// The ID of the instance.
	InstanceId *string `type:"string"`

	// The name of the Systems Manager document.
	Name *string `type:"string"`
}

// String returns the string representation
func (s DeleteAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAssociationInput) GoString() string {
	return s.String()
}

// SetAssociationId sets the AssociationId field's value.
func (s *DeleteAssociationInput) SetAssociationId(v string) *DeleteAssociationInput {
	s.AssociationId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *DeleteAssociationInput) SetInstanceId(v string) *DeleteAssociationInput {
	s.InstanceId = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteAssociationInput) SetName(v string) *DeleteAssociationInput {
	s.Name = &v
	return s
}

type DeleteAssociationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAssociationOutput) GoString() string {
	return s.String()
}

type DeleteDocumentInput struct {
	_ struct{} `type:"structure"`

	// The name of the document.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDocumentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDocumentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDocumentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDocumentInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteDocumentInput) SetName(v string) *DeleteDocumentInput {
	s.Name = &v
	return s
}

type DeleteDocumentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDocumentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDocumentOutput) GoString() string {
	return s.String()
}

type DeleteInventoryInput struct {
	_ struct{} `type:"structure"`

	// User-provided idempotency token.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// Use this option to view a summary of the deletion request without deleting
	// any data or the data type. This option is useful when you only want to understand
	// what will be deleted. Once you validate that the data to be deleted is what
	// you intend to delete, you can run the same command without specifying the
	// DryRun option.
	DryRun *bool `type:"boolean"`

	// Use the SchemaDeleteOption to delete a custom inventory type (schema). If
	// you don't choose this option, the system only deletes existing inventory
	// data associated with the custom inventory type. Choose one of the following
	// options:
	//
	// DisableSchema: If you choose this option, the system ignores all inventory
	// data for the specified version, and any earlier versions. To enable this
	// schema again, you must call the PutInventory action for a version greater
	// than the disbled version.
	//
	// DeleteSchema: This option deletes the specified custom type from the Inventory
	// service. You can recreate the schema later, if you want.
	SchemaDeleteOption *string `type:"string" enum:"InventorySchemaDeleteOption"`

	// The name of the custom inventory type for which you want to delete either
	// all previously collected data, or the inventory type itself.
	//
	// TypeName is a required field
	TypeName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteInventoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInventoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInventoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInventoryInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.TypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("TypeName"))
	}
	if s.TypeName != nil && len(*s.TypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteInventoryInput) SetClientToken(v string) *DeleteInventoryInput {
	s.ClientToken = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *DeleteInventoryInput) SetDryRun(v bool) *DeleteInventoryInput {
	s.DryRun = &v
	return s
}

// SetSchemaDeleteOption sets the SchemaDeleteOption field's value.
func (s *DeleteInventoryInput) SetSchemaDeleteOption(v string) *DeleteInventoryInput {
	s.SchemaDeleteOption = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *DeleteInventoryInput) SetTypeName(v string) *DeleteInventoryInput {
	s.TypeName = &v
	return s
}

type DeleteInventoryOutput struct {
	_ struct{} `type:"structure"`

	// Every DeleteInventory action is assigned a unique ID. This option returns
	// a unique ID. You can use this ID to query the status of a delete operation.
	// This option is useful for ensuring that a delete operation has completed
	// before you begin other actions.
	DeletionId *string `type:"string"`

	// A summary of the delete operation. For more information about this summary,
	// see Understanding the Delete Inventory Summary (http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-delete.html#sysman-inventory-delete-summary)
	// in the AWS Systems Manager User Guide.
	DeletionSummary *InventoryDeletionSummary `type:"structure"`

	// The name of the inventory data type specified in the request.
	TypeName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteInventoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInventoryOutput) GoString() string {
	return s.String()
}

// SetDeletionId sets the DeletionId field's value.
func (s *DeleteInventoryOutput) SetDeletionId(v string) *DeleteInventoryOutput {
	s.DeletionId = &v
	return s
}

// SetDeletionSummary sets the DeletionSummary field's value.
func (s *DeleteInventoryOutput) SetDeletionSummary(v *InventoryDeletionSummary) *DeleteInventoryOutput {
	s.DeletionSummary = v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *DeleteInventoryOutput) SetTypeName(v string) *DeleteInventoryOutput {
	s.TypeName = &v
	return s
}

type DeleteMaintenanceWindowInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Maintenance Window to delete.
	//
	// WindowId is a required field
	WindowId *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMaintenanceWindowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMaintenanceWindowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMaintenanceWindowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMaintenanceWindowInput"}
	if s.WindowId == nil {
		invalidParams.Add(request.NewErrParamRequired("WindowId"))
	}
	if s.WindowId != nil && len(*s.WindowId) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("WindowId", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWindowId sets the WindowId field's value.
func (s *DeleteMaintenanceWindowInput) SetWindowId(v string) *DeleteMaintenanceWindowInput {
	s.WindowId = &v
	return s
}

type DeleteMaintenanceWindowOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the deleted Maintenance Window.
	WindowId *string `min:"20" type:"string"`
}

// String returns the string representation
func (s DeleteMaintenanceWindowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMaintenanceWindowOutput) GoString() string {
	return s.String()
}

// SetWindowId sets the WindowId field's value.
func (s *DeleteMaintenanceWindowOutput) SetWindowId(v string) *DeleteMaintenanceWindowOutput {
	s.WindowId = &v
	return s
}

type DeleteParameterInput struct {
	_ struct{} `type:"structure"`

	// The name of the parameter to delete.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteParameterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteParameterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteParameterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteParameterInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteParameterInput) SetName(v string) *DeleteParameterInput {
	s.Name = &v
	return s
}

type DeleteParameterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteParameterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteParameterOutput) GoString() string {
	return s.String()
}

type DeleteParametersInput struct {
	_ struct{} `type:"structure"`

	// The names of the parameters to delete.
	//
	// Names is a required field
	Names []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteParametersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteParametersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteParametersInput"}
	if s.Names == nil {
		invalidParams.Add(request.NewErrParamRequired("Names"))
	}
	if s.Names != nil && len(s.Names) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Names", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNames sets the Names field's value.
func (s *DeleteParametersInput) SetNames(v []*string) *DeleteParametersInput {
	s.Names = v
	return s
}

type DeleteParametersOutput struct {
	_ struct{} `type:"structure"`

	// The names of the deleted parameters.
	DeletedParameters []*string `min:"1" type:"list"`

	// The names of parameters that weren't deleted because the parameters are not
	// valid.
	InvalidParameters []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s DeleteParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteParametersOutput) GoString() string {
	return s.String()
}

// SetDeletedParameters sets the DeletedParameters field's value.
func (s *DeleteParametersOutput) SetDeletedParameters(v []*string) *DeleteParametersOutput {
	s.DeletedParameters = v
	return s
}

// SetInvalidParameters sets the InvalidParameters field's value.
func (s *DeleteParametersOutput) SetInvalidParameters(v []*string) *DeleteParametersOutput {
	s.InvalidParameters = v
	return s
}

type DeletePatchBaselineInput struct {
	_ struct{} `type:"structure"`

	// The ID of the patch baseline to delete.
	//
	// BaselineId is a required field
	BaselineId *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePatchBaselineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePatchBaselineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePatchBaselineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePatchBaselineInput"}
	if s.BaselineId == nil {
		invalidParams.Add(request.NewErrParamRequired("BaselineId"))
	}
	if s.BaselineId != nil && len(*s.BaselineId) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("BaselineId", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBaselineId sets the BaselineId field's value.
func (s *DeletePatchBaselineInput) SetBaselineId(v string) *DeletePatchBaselineInput {
	s.BaselineId = &v
	return s
}

type DeletePatchBaselineOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the deleted patch baseline.
	BaselineId *string `min:"20" type:"string"`
}

// String returns the string representation
func (s DeletePatchBaselineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePatchBaselineOutput) GoString() string {
	return s.String()
}

// SetBaselineId sets the BaselineId field's value.
func (s *DeletePatchBaselineOutput) SetBaselineId(v string) *DeletePatchBaselineOutput {
	s.BaselineId = &v
	return s
}

type DeleteResourceDataSyncInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration to delete.
	//
	// SyncName is a required field
	SyncName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteResourceDataSyncInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteResourceDataSyncInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResourceDataSyncInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResourceDataSyncInput"}
	if s.SyncName == nil {
		invalidParams.Add(request.NewErrParamRequired("SyncName"))
	}
	if s.SyncName != nil && len(*s.SyncName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SyncName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSyncName sets the SyncName field's value.
func (s *DeleteResourceDataSyncInput) SetSyncName(v string) *DeleteResourceDataSyncInput {
	s.SyncName = &v
	return s
}

type DeleteResourceDataSyncOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteResourceDataSyncOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteResourceDataSyncOutput) GoString() string {
	return s.String()
}

type DeregisterManagedInstanceInput struct {
	_ struct{} `type:"structure"`

	// The ID assigned to the managed instance when you registered it using the
	// activation process.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterManagedInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterManagedInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterManagedInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterManagedInstanceInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *DeregisterManagedInstanceInput) SetInstanceId(v string) *DeregisterManagedInstanceInput {
	s.InstanceId = &v
	return s
}

type DeregisterManagedInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeregisterManagedInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterManagedInstanceOutput) GoString() string {
	return s.String()
}

type DeregisterPatchBaselineForPatchGroupInput struct {
	_ struct{} `type:"structure"`

	// The ID of the patch baseline to deregister the patch group from.
	//
	// BaselineId is a required field
	BaselineId *string `min:"20" type:"string" required:"true"`

	// The name of the patch group that should be deregistered from the patch baseline.
	//
	// PatchGroup is a required field
	PatchGroup *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterPatchBaselineForPatchGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterPatchBaselineForPatchGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterPatchBaselineForPatchGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterPatchBaselineForPatchGroupInput"}
	if s.BaselineId == nil {
		invalidParams.Add(request.NewErrParamRequired("BaselineId"))
	}
	if s.BaselineId != nil && len(*s.BaselineId) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("BaselineId", 20))
	}
	if s.PatchGroup == nil {
		invalidParams.Add(request.NewErrParamRequired("PatchGroup"))
	}
	if s.PatchGroup != nil && len(*s.PatchGroup) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PatchGroup", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBaselineId sets the BaselineId field's value.
func (s *DeregisterPatchBaselineForPatchGroupInput) SetBaselineId(v string) *DeregisterPatchBaselineForPatchGroupInput {
	s.BaselineId = &v
	return s
}

// SetPatchGroup sets the PatchGroup field's value.
func (s *DeregisterPatchBaselineForPatchGroupInput) SetPatchGroup(v string) *DeregisterPatchBaselineForPatchGroupInput {
	s.PatchGroup = &v
	return s
}

type DeregisterPatchBaselineForPatchGroupOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the patch baseline the patch group was deregistered from.
	BaselineId *string `min:"20" type:"string"`

	// The name of the patch group deregistered from the patch baseline.
	PatchGroup *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeregisterPatchBaselineForPatchGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterPatchBaselineForPatchGroupOutput) GoString() string {
	return s.String()
}

// SetBaselineId sets the BaselineId field's value.
func (s *DeregisterPatchBaselineForPatchGroupOutput) SetBaselineId(v string) *DeregisterPatchBaselineForPatchGroupOutput {
	s.BaselineId = &v
	return s
}

// SetPatchGroup sets the PatchGroup field's value.
func (s *DeregisterPatchBaselineForPatchGroupOutput) SetPatchGroup(v string) *DeregisterPatchBaselineForPatchGroupOutput {
	s.PatchGroup = &v
	return s
}

type DeregisterTargetFromMaintenanceWindowInput struct {
	_ struct{} `type:"structure"`

	// The system checks if the target is being referenced by a task. If the target
	// is being referenced, the system returns an error and does not deregister
	// the target from the Maintenance Window.
	Safe *bool `type:"boolean"`

	// The ID of the Maintenance Window the target should be removed from.
	//
	// WindowId is a required field
	WindowId *string `min:"20" type:"string" required:"true"`

	// The ID of the target definition to remove.
	//
	// WindowTargetId is a required field
	WindowTargetId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterTargetFromMaintenanceWindowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterTargetFromMaintenanceWindowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterTargetFromMaintenanceWindowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterTargetFromMaintenanceWindowInput"}
	if s.WindowId == nil {
		invalidParams.Add(request.NewErrParamRequired("WindowId"))
	}
	if s.WindowId != nil && len(*s.WindowId) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("WindowId", 20))
	}
	if s.WindowTargetId == nil {
		invalidParams.Add(request.NewErrParamRequired("WindowTargetId"))
	}
	if s.WindowTargetId != nil && len(*s.WindowTargetId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("WindowTargetId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSafe sets the Safe field's value.
func (s *DeregisterTargetFromMaintenanceWindowInput) SetSafe(v bool) *DeregisterTargetFromMaintenanceWindowInput {
	s.Safe = &v
	return s
}

// SetWindowId sets the WindowId field's value.
func (s *DeregisterTargetFromMaintenanceWindowInput) SetWindowId(v string) *DeregisterTargetFromMaintenanceWindowInput {
	s.WindowId = &v
	return s
}

// SetWindowTargetId sets the WindowTargetId field's value.
func (s *DeregisterTargetFromMaintenanceWindowInput) SetWindowTargetId(v string) *DeregisterTargetFromMaintenanceWindowInput {
	s.WindowTargetId = &v
	return s
}

type DeregisterTargetFromMaintenanceWindowOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the Maintenance Window the target was removed from.
	WindowId *string `min:"20" type:"string"`

	// The ID of the removed target definition.
	WindowTargetId *string `min:"36" type:"string"`
}

// String returns the string representation
func (s DeregisterTargetFromMaintenanceWindowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterTargetFromMaintenanceWindowOutput) GoString() string {
	return s.String()
}

// SetWindowId sets the WindowId field's value.
func (s *DeregisterTargetFromMaintenanceWindowOutput) SetWindowId(v string) *DeregisterTargetFromMaintenanceWindowOutput {
	s.WindowId = &v
	return s
}

// SetWindowTargetId sets the WindowTargetId field's value.
func (s *DeregisterTargetFromMaintenanceWindowOutput) SetWindowTargetId(v string) *DeregisterTargetFromMaintenanceWindowOutput {
	s.WindowTargetId = &v
	return s
}

type DeregisterTaskFromMaintenanceWindowInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Maintenance Window the task should be removed from.
	//
	// WindowId is a required field
	WindowId *string `min:"20" type:"string" required:"true"`

	// The ID of the task to remove from the Maintenance Window.
	//
	// WindowTaskId is a required field
	WindowTaskId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterTaskFromMaintenanceWindowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterTaskFromMaintenanceWindowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterTaskFromMaintenanceWindowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterTaskFromMaintenanceWindowInput"}
	if s.WindowId == nil {
		invalidParams.Add(request.NewErrParamRequired("WindowId"))
	}
	if s.WindowId != nil && len(*s.WindowId) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("WindowId", 20))
	}
	if s.WindowTaskId == nil {
		invalidParams.Add(request.NewErrParamRequired("WindowTaskId"))
	}
	if s.WindowTaskId != nil && len(*s.WindowTaskId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("WindowTaskId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWindowId sets the WindowId field's value.
func (s *DeregisterTaskFromMaintenanceWindowInput) SetWindowId(v string) *DeregisterTaskFromMaintenanceWindowInput {
	s.WindowId = &v
	return s
}

// SetWindowTaskId sets the WindowTaskId field's value.
func (s *DeregisterTaskFromMaintenanceWindowInput) SetWindowTaskId(v string) *DeregisterTaskFromMaintenanceWindowInput {
	s.WindowTaskId = &v
	return s
}

type DeregisterTaskFromMaintenanceWindowOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the Maintenance Window the task was removed from.
	WindowId *string `min:"20" type:"string"`

	// The ID of the task removed from the Maintenance Window.
	WindowTaskId *string `min:"36" type:"string"`
}

// String returns the string representation
func (s DeregisterTaskFromMaintenanceWindowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterTaskFromMaintenanceWindowOutput) GoString() string {
	return s.String()
}

// SetWindowId sets the WindowId field's value.
func (s *DeregisterTaskFromMaintenanceWindowOutput) SetWindowId(v string) *DeregisterTaskFromMaintenanceWindowOutput {
	s.WindowId = &v
	return s
}

// SetWindowTaskId sets the WindowTaskId field's value.
func (s *DeregisterTaskFromMaintenanceWindowOutput) SetWindowTaskId(v string) *DeregisterTaskFromMaintenanceWindowOutput {
	s.WindowTaskId = &v
	return s
}

// Filter for the DescribeActivation API.
type DescribeActivationsFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	FilterKey *string `type:"string" enum:"DescribeActivationsFilterKeys"`

	// The filter values.
	FilterValues []*string `type:"list"`
}

// String returns the string representation
func (s DescribeActivationsFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeActivationsFilter) GoString() string {
	return s.String()
}

// SetFilterKey sets the FilterKey field's value.
func (s *DescribeActivationsFilter) SetFilterKey(v string) *DescribeActivationsFilter {
	s.FilterKey = &v
	return s
}

// SetFilterValues sets the FilterValues field's value.
func (s *DescribeActivationsFilter) SetFilterValues(v []*string) *DescribeActivationsFilter {
	s.FilterValues = v
	return s
}

type DescribeActivationsInput struct {
	_ struct{} `type:"structure"`

	// A filter to view information about your activations.
	Filters []*DescribeActivationsFilter `type:"list"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token to start the list. Use this token to get the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeActivationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeActivationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeActivationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeActivationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeActivationsInput) SetFilters(v []*DescribeActivationsFilter) *DescribeActivationsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeActivationsInput) SetMaxResults(v int64) *DescribeActivationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeActivationsInput) SetNextToken(v string) *DescribeActivationsInput {
	s.NextToken = &v
	return s
}

type DescribeActivationsOutput struct {
	_ struct{} `type:"structure"`

	// A list of activations for your AWS account.
	ActivationList []*Activation `type:"list"`

	// The token for the next set of items to return. Use this token to get the
	// next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeActivationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeActivationsOutput) GoString() string {
	return s.String()
}

// SetActivationList sets the ActivationList field's value.
func (s *DescribeActivationsOutput) SetActivationList(v []*Activation) *DescribeActivationsOutput {
	s.ActivationList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeActivationsOutput) SetNextToken(v string) *DescribeActivationsOutput {
	s.NextToken = &v
	return s
}

type DescribeAssociationExecutionTargetsInput struct {
	_ struct{} `type:"structure"`

	// The association ID that includes the execution for which you want to view
	// details.
	//
	// AssociationId is a required field
	AssociationId *string `type:"string" required:"true"`

	// The execution ID for which you want to view details.
	//
	// ExecutionId is a required field
	ExecutionId *string `type:"string" required:"true"`

	// Filters for the request. You can specify the following filters and values.
	//
	// Status (EQUAL)
	//
	// ResourceId (EQUAL)
	//
	// ResourceType (EQUAL)
	Filters []*AssociationExecutionTargetsFilter `min:"1" type:"list"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token to start the list. Use this token to get the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAssociationExecutionTargetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAssociationExecutionTargetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAssociationExecutionTargetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAssociationExecutionTargetsInput"}
	if s.AssociationId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssociationId"))
	}
	if s.ExecutionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExecutionId"))
	}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssociationId sets the AssociationId field's value.
func (s *DescribeAssociationExecutionTargetsInput) SetAssociationId(v string) *DescribeAssociationExecutionTargetsInput {
	s.AssociationId = &v
	return s
}

// SetExecutionId sets the ExecutionId field's value.
func (s *DescribeAssociationExecutionTargetsInput) SetExecutionId(v string) *DescribeAssociationExecutionTargetsInput {
	s.ExecutionId = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeAssociationExecutionTargetsInput) SetFilters(v []*AssociationExecutionTargetsFilter) *DescribeAssociationExecutionTargetsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeAssociationExecutionTargetsInput) SetMaxResults(v int64) *DescribeAssociationExecutionTargetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAssociationExecutionTargetsInput) SetNextToken(v string) *DescribeAssociationExecutionTargetsInput {
	s.NextToken = &v
	return s
}

type DescribeAssociationExecutionTargetsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the execution.
	AssociationExecutionTargets []*AssociationExecutionTarget `type:"list"`

	// The token for the next set of items to return. Use this token to get the
	// next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAssociationExecutionTargetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAssociationExecutionTargetsOutput) GoString() string {
	return s.String()
}

// SetAssociationExecutionTargets sets the AssociationExecutionTargets field's value.
func (s *DescribeAssociationExecutionTargetsOutput) SetAssociationExecutionTargets(v []*AssociationExecutionTarget) *DescribeAssociationExecutionTargetsOutput {
	s.AssociationExecutionTargets = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAssociationExecutionTargetsOutput) SetNextToken(v string) *DescribeAssociationExecutionTargetsOutput {
	s.NextToken = &v
	return s
}

type DescribeAssociationExecutionsInput struct {
	_ struct{} `type:"structure"`

	// The association ID for which you want to view execution history details.
	//
	// AssociationId is a required field
	AssociationId *string `type:"string" required:"true"`

	// Filters for the request. You can specify the following filters and values.
	//
	// ExecutionId (EQUAL)
	//
	// Status (EQUAL)
	//
	// CreatedTime (EQUAL, GREATER_THAN, LESS_THAN)
	Filters []*AssociationExecutionFilter `min:"1" type:"list"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token to start the list. Use this token to get the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAssociationExecutionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAssociationExecutionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAssociationExecutionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAssociationExecutionsInput"}
	if s.AssociationId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssociationId"))
	}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssociationId sets the AssociationId field's value.
func (s *DescribeAssociationExecutionsInput) SetAssociationId(v string) *DescribeAssociationExecutionsInput {
	s.AssociationId = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeAssociationExecutionsInput) SetFilters(v []*AssociationExecutionFilter) *DescribeAssociationExecutionsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeAssociationExecutionsInput) SetMaxResults(v int64) *DescribeAssociationExecutionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAssociationExecutionsInput) SetNextToken(v string) *DescribeAssociationExecutionsInput {
	s.NextToken = &v
	return s
}

type DescribeAssociationExecutionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of the executions for the specified association ID.
	AssociationExecutions []*AssociationExecution `type:"list"`

	// The token for the next set of items to return. Use this token to get the
	// next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAssociationExecutionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAssociationExecutionsOutput) GoString() string {
	return s.String()
}

// SetAssociationExecutions sets the AssociationExecutions field's value.
func (s *DescribeAssociationExecutionsOutput) SetAssociationExecutions(v []*AssociationExecution) *DescribeAssociationExecutionsOutput {
	s.AssociationExecutions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAssociationExecutionsOutput) SetNextToken(v string) *DescribeAssociationExecutionsOutput {
	s.NextToken = &v
	return s
}

type DescribeAssociationInput struct {
	_ struct{} `type:"structure"`

	// The association ID for which you want information.
	AssociationId *string `type:"string"`

	// Specify the association version to retrieve. To view the latest version,
	// either specify $LATEST for this parameter, or omit this parameter. To view
	// a list of all associations for an instance, use ListAssociations. To get
	// a list of versions for a specific association, use ListAssociationVersions.
	AssociationVersion *string `type:"string"`

	// The instance ID.
	InstanceId *string `type:"string"`

	// The name of the Systems Manager document.
	Name *string `type:"string"`
}

// String returns the string representation
func (s DescribeAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAssociationInput) GoString() string {
	return s.String()
}

// SetAssociationId sets the AssociationId field's value.
func (s *DescribeAssociationInput) SetAssociationId(v string) *DescribeAssociationInput {
	s.AssociationId = &v
	return s
}

// SetAssociationVersion sets the AssociationVersion field's value.
func (s *DescribeAssociationInput) SetAssociationVersion(v string) *DescribeAssociationInput {
	s.AssociationVersion = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeAssociationInput) SetInstanceId(v string) *DescribeAssociationInput {
	s.InstanceId = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeAssociationInput) SetName(v string) *DescribeAssociationInput {
	s.Name = &v
	return s
}

type DescribeAssociationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the association.
	AssociationDescription *AssociationDescription `type:"structure"`
}

// String returns the string representation
func (s DescribeAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAssociationOutput) GoString() string {
	return s.String()
}

// SetAssociationDescription sets the AssociationDescription field's value.
func (s *DescribeAssociationOutput) SetAssociationDescription(v *AssociationDescription) *DescribeAssociationOutput {
	s.AssociationDescription = v
	return s
}

type DescribeAutomationExecutionsInput struct {
	_ struct{} `type:"structure"`

	// Filters used to limit the scope of executions that are requested.
	Filters []*AutomationExecutionFilter `min:"1" type:"list"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAutomationExecutionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAutomationExecutionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAutomationExecutionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAutomationExecutionsInput"}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeAutomationExecutionsInput) SetFilters(v []*AutomationExecutionFilter) *DescribeAutomationExecutionsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeAutomationExecutionsInput) SetMaxResults(v int64) *DescribeAutomationExecutionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAutomationExecutionsInput) SetNextToken(v string) *DescribeAutomationExecutionsInput {
	s.NextToken = &v
	return s
}

type DescribeAutomationExecutionsOutput struct {
	_ struct{} `type:"structure"`

	// The list of details about each automation execution which has occurred which
	// matches the filter specification, if any.
	AutomationExecutionMetadataList []*AutomationExecutionMetadata `type:"list"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAutomationExecutionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAutomationExecutionsOutput) GoString() string {
	return s.String()
}

// SetAutomationExecutionMetadataList sets the AutomationExecutionMetadataList field's value.
func (s *DescribeAutomationExecutionsOutput) SetAutomationExecutionMetadataList(v []*AutomationExecutionMetadata) *DescribeAutomationExecutionsOutput {
	s.AutomationExecutionMetadataList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAutomationExecutionsOutput) SetNextToken(v string) *DescribeAutomationExecutionsOutput {
	s.NextToken = &v
	return s
}

type DescribeAutomationStepExecutionsInput struct {
	_ struct{} `type:"structure"`

	// The Automation execution ID for which you want step execution descriptions.
	//
	// AutomationExecutionId is a required field
	AutomationExecutionId *string `min:"36" type:"string" required:"true"`

	// One or more filters to limit the number of step executions returned by the
	// request.
	Filters []*StepExecutionFilter `min:"1" type:"list"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	// A boolean that indicates whether to list step executions in reverse order
	// by start time. The default value is false.
	ReverseOrder *bool `type:"boolean"`
}

// String returns the string representation
func (s DescribeAutomationStepExecutionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAutomationStepExecutionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAutomationStepExecutionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAutomationStepExecutionsInput"}
	if s.AutomationExecutionId == nil {
		invalidParams.Add(request.NewErrParamRequired("AutomationExecutionId"))
	}
	if s.AutomationExecutionId != nil && len(*s.AutomationExecutionId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AutomationExecutionId", 36))
	}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutomationExecutionId sets the AutomationExecutionId field's value.
func (s *DescribeAutomationStepExecutionsInput) SetAutomationExecutionId(v string) *DescribeAutomationStepExecutionsInput {
	s.AutomationExecutionId = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeAutomationStepExecutionsInput) SetFilters(v []*StepExecutionFilter) *DescribeAutomationStepExecutionsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeAutomationStepExecutionsInput) SetMaxResults(v int64) *DescribeAutomationStepExecutionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAutomationStepExecutionsInput) SetNextToken(v string) *DescribeAutomationStepExecutionsInput {
	s.NextToken = &v
	return s
}

// SetReverseOrder sets the ReverseOrder field's value.
func (s *DescribeAutomationStepExecutionsInput) SetReverseOrder(v bool) *DescribeAutomationStepExecutionsInput {
	s.ReverseOrder = &v
	return s
}

type DescribeAutomationStepExecutionsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`

	// A list of details about the current state of all steps that make up an execution.
	StepExecutions []*StepExecution `type:"list"`
}

// String returns the string representation
func (s DescribeAutomationStepExecutionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAutomationStepExecutionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAutomationStepExecutionsOutput) SetNextToken(v string) *DescribeAutomationStepExecutionsOutput {
	s.NextToken = &v
	return s
}

// SetStepExecutions sets the StepExecutions field's value.
func (s *DescribeAutomationStepExecutionsOutput) SetStepExecutions(v []*StepExecution) *DescribeAutomationStepExecutionsOutput {
	s.StepExecutions = v
	return s
}

type DescribeAvailablePatchesInput struct {
	_ struct{} `type:"structure"`

	// Filters used to scope down the returned patches.
	Filters []*PatchOrchestratorFilter `type:"list"`

	// The maximum number of patches to return (per page).
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAvailablePatchesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAvailablePatchesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAvailablePatchesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAvailablePatchesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeAvailablePatchesInput) SetFilters(v []*PatchOrchestratorFilter) *DescribeAvailablePatchesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeAvailablePatchesInput) SetMaxResults(v int64) *DescribeAvailablePatchesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAvailablePatchesInput) SetNextToken(v string) *DescribeAvailablePatchesInput {
	s.NextToken = &v
	return s
}

type DescribeAvailablePatchesOutput struct {
	_ struct{} `type:"structure"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`

	// An array of patches. Each entry in the array is a patch structure.
	Patches []*Patch `type:"list"`
}

// String returns the string representation
func (s DescribeAvailablePatchesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAvailablePatchesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAvailablePatchesOutput) SetNextToken(v string) *DescribeAvailablePatchesOutput {
	s.NextToken = &v
	return s
}

// SetPatches sets the Patches field's value.
func (s *DescribeAvailablePatchesOutput) SetPatches(v []*Patch) *DescribeAvailablePatchesOutput {
	s.Patches = v
	return s
}

type DescribeDocumentInput struct {
	_ struct{} `type:"structure"`

	// The document version for which you want information. Can be a specific version
	// or the default version.
	DocumentVersion *string `type:"string"`

	// The name of the Systems Manager document.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// An optional field specifying the version of the artifact associated with
	// the document. For example, "Release 12, Update 6". This value is unique across
	// all versions of a document, and cannot be changed.
	VersionName *string `type:"string"`
}

// String returns the string representation
func (s DescribeDocumentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDocumentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDocumentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDocumentInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocumentVersion sets the DocumentVersion field's value.
func (s *DescribeDocumentInput) SetDocumentVersion(v string) *DescribeDocumentInput {
	s.DocumentVersion = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeDocumentInput) SetName(v string) *DescribeDocumentInput {
	s.Name = &v
	return s
}

// SetVersionName sets the VersionName field's value.
func (s *DescribeDocumentInput) SetVersionName(v string) *DescribeDocumentInput {
	s.VersionName = &v
	return s
}

type DescribeDocumentOutput struct {
	_ struct{} `type:"structure"`

	// Information about the Systems Manager document.
	Document *DocumentDescription `type:"structure"`
}

// String returns the string representation
func (s DescribeDocumentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDocumentOutput) GoString() string {
	return s.String()
}

// SetDocument sets the Document field's value.
func (s *DescribeDocumentOutput) SetDocument(v *DocumentDescription) *DescribeDocumentOutput {
	s.Document = v
	return s
}

type DescribeDocumentPermissionInput struct {
	_ struct{} `type:"structure"`

	// The name of the document for which you are the owner.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The permission type for the document. The permission type can be Share.
	//
	// PermissionType is a required field
	PermissionType *string `type:"string" required:"true" enum:"DocumentPermissionType"`
}

// String returns the string representation
func (s DescribeDocumentPermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDocumentPermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDocumentPermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDocumentPermissionInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.PermissionType == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DescribeDocumentPermissionInput) SetName(v string) *DescribeDocumentPermissionInput {
	s.Name = &v
	return s
}

// SetPermissionType sets the PermissionType field's value.
func (s *DescribeDocumentPermissionInput) SetPermissionType(v string) *DescribeDocumentPermissionInput {
	s.PermissionType = &v
	return s
}

type DescribeDocumentPermissionOutput struct {
	_ struct{} `type:"structure"`

	// The account IDs that have permission to use this document. The ID can be
	// either an AWS account or All.
	AccountIds []*string `type:"list"`
}

// String returns the string representation
func (s DescribeDocumentPermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDocumentPermissionOutput) GoString() string {
	return s.String()
}

// SetAccountIds sets the AccountIds field's value.
func (s *DescribeDocumentPermissionOutput) SetAccountIds(v []*string) *DescribeDocumentPermissionOutput {
	s.AccountIds = v
	return s
}

type DescribeEffectiveInstanceAssociationsInput struct {
	_ struct{} `type:"structure"`

	// The instance ID for which you want to view all associations.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeEffectiveInstanceAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEffectiveInstanceAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEffectiveInstanceAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEffectiveInstanceAssociationsInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeEffectiveInstanceAssociationsInput) SetInstanceId(v string) *DescribeEffectiveInstanceAssociationsInput {
	s.InstanceId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeEffectiveInstanceAssociationsInput) SetMaxResults(v int64) *DescribeEffectiveInstanceAssociationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeEffectiveInstanceAssociationsInput) SetNextToken(v string) *DescribeEffectiveInstanceAssociationsInput {
	s.NextToken = &v
	return s
}

type DescribeEffectiveInstanceAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// The associations for the requested instance.
	Associations []*InstanceAssociation `type:"list"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeEffectiveInstanceAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEffectiveInstanceAssociationsOutput) GoString() string {
	return s.String()
}

// SetAssociations sets the Associations field's value.
func (s *DescribeEffectiveInstanceAssociationsOutput) SetAssociations(v []*InstanceAssociation) *DescribeEffectiveInstanceAssociationsOutput {
	s.Associations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeEffectiveInstanceAssociationsOutput) SetNextToken(v string) *DescribeEffectiveInstanceAssociationsOutput {
	s.NextToken = &v
	return s
}

type DescribeEffectivePatchesForPatchBaselineInput struct {
	_ struct{} `type:"structure"`

	// The ID of the patch baseline to retrieve the effective patches for.
	//
	// BaselineId is a required field
	BaselineId *string `min:"20" type:"string" required:"true"`

	// The maximum number of patches to return (per page).
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeEffectivePatchesForPatchBaselineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEffectivePatchesForPatchBaselineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEffectivePatchesForPatchBaselineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEffectivePatchesForPatchBaselineInput"}
	if s.BaselineId == nil {
		invalidParams.Add(request.NewErrParamRequired("BaselineId"))
	}
	if s.BaselineId != nil && len(*s.BaselineId) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("BaselineId", 20))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBaselineId sets the BaselineId field's value.
func (s *DescribeEffectivePatchesForPatchBaselineInput) SetBaselineId(v string) *DescribeEffectivePatchesForPatchBaselineInput {
	s.BaselineId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeEffectivePatchesForPatchBaselineInput) SetMaxResults(v int64) *DescribeEffectivePatchesForPatchBaselineInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeEffectivePatchesForPatchBaselineInput) SetNextToken(v string) *DescribeEffectivePatchesForPatchBaselineInput {
	s.NextToken = &v
	return s
}

type DescribeEffectivePatchesForPatchBaselineOutput struct {
	_ struct{} `type:"structure"`

	// An array of patches and patch status.
	EffectivePatches []*EffectivePatch `type:"list"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeEffectivePatchesForPatchBaselineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEffectivePatchesForPatchBaselineOutput) GoString() string {
	return s.String()
}

// SetEffectivePatches sets the EffectivePatches field's value.
func (s *DescribeEffectivePatchesForPatchBaselineOutput) SetEffectivePatches(v []*EffectivePatch) *DescribeEffectivePatchesForPatchBaselineOutput {
	s.EffectivePatches = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeEffectivePatchesForPatchBaselineOutput) SetNextToken(v string) *DescribeEffectivePatchesForPatchBaselineOutput {
	s.NextToken = &v
	return s
}

type DescribeInstanceAssociationsStatusInput struct {
	_ struct{} `type:"structure"`

	// The instance IDs for which you want association status information.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeInstanceAssociationsStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstanceAssociationsStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInstanceAssociationsStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInstanceAssociationsStatusInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeInstanceAssociationsStatusInput) SetInstanceId(v string) *DescribeInstanceAssociationsStatusInput {
	s.InstanceId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeInstanceAssociationsStatusInput) SetMaxResults(v int64) *DescribeInstanceAssociationsStatusInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeInstanceAssociationsStatusInput) SetNextToken(v string) *DescribeInstanceAssociationsStatusInput {
	s.NextToken = &v
	return s
}

type DescribeInstanceAssociationsStatusOutput struct {
	_ struct{} `type:"structure"`

	// Status information about the association.
	InstanceAssociationStatusInfos []*InstanceAssociationStatusInfo `type:"list"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeInstanceAssociationsStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstanceAssociationsStatusOutput) GoString() string {
	return s.String()
}

// SetInstanceAssociationStatusInfos sets the InstanceAssociationStatusInfos field's value.
func (s *DescribeInstanceAssociationsStatusOutput) SetInstanceAssociationStatusInfos(v []*InstanceAssociationStatusInfo) *DescribeInstanceAssociationsStatusOutput {
	s.InstanceAssociationStatusInfos = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeInstanceAssociationsStatusOutput) SetNextToken(v string) *DescribeInstanceAssociationsStatusOutput {
	s.NextToken = &v
	return s
}

type DescribeInstanceInformationInput struct {
	_ struct{} `type:"structure"`

	// One or more filters. Use a filter to return a more specific list of instances.
	// You can filter on Amazon EC2 tag. Specify tags by using a key-value mapping.
	Filters []*InstanceInformationStringFilter `type:"list"`

	// This is a legacy method. We recommend that you don't use this method. Instead,
	// use the InstanceInformationFilter action. The InstanceInformationFilter action
	// enables you to return instance information by using tags that are specified
	// as a key-value mapping.
	//
	// If you do use this method, then you can't use the InstanceInformationFilter
	// action. Using this method and the InstanceInformationFilter action causes
	// an exception error.
	InstanceInformationFilterList []*InstanceInformationFilter `type:"list"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"5" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeInstanceInformationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstanceInformationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInstanceInformationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInstanceInformationInput"}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 5))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.InstanceInformationFilterList != nil {
		for i, v := range s.InstanceInformationFilterList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InstanceInformationFilterList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeInstanceInformationInput) SetFilters(v []*InstanceInformationStringFilter) *DescribeInstanceInformationInput {
	s.Filters = v
	return s
}

// SetInstanceInformationFilterList sets the InstanceInformationFilterList field's value.
func (s *DescribeInstanceInformationInput) SetInstanceInformationFilterList(v []*InstanceInformationFilter) *DescribeInstanceInformationInput {
	s.InstanceInformationFilterList = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeInstanceInformationInput) SetMaxResults(v int64) *DescribeInstanceInformationInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeInstanceInformationInput) SetNextToken(v string) *DescribeInstanceInformationInput {
	s.NextToken = &v
	return s
}

type DescribeInstanceInformationOutput struct {
	_ struct{} `type:"structure"`

	// The instance information list.
	InstanceInformationList []*InstanceInformation `type:"list"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeInstanceInformationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstanceInformationOutput) GoString() string {
	return s.String()
}

// SetInstanceInformationList sets the InstanceInformationList field's value.
func (s *DescribeInstanceInformationOutput) SetInstanceInformationList(v []*InstanceInformation) *DescribeInstanceInformationOutput {
	s.InstanceInformationList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeInstanceInformationOutput) SetNextToken(v string) *DescribeInstanceInformationOutput {
	s.NextToken = &v
	return s
}

type DescribeInstancePatchStatesForPatchGroupInput struct {
	_ struct{} `type:"structure"`

	// Each entry in the array is a structure containing:
	//
	// Key (string between 1 and 200 characters)
	//
	// Values (array containing a single string)
	//
	// Type (string "Equal", "NotEqual", "LessThan", "GreaterThan")
	Filters []*InstancePatchStateFilter `type:"list"`

	// The maximum number of patches to return (per page).
	MaxResults *int64 `min:"10" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	// The name of the patch group for which the patch state information should
	// be retrieved.
	//
	// PatchGroup is a required field
	PatchGroup *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeInstancePatchStatesForPatchGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstancePatchStatesForPatchGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInstancePatchStatesForPatchGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInstancePatchStatesForPatchGroupInput"}
	if s.MaxResults != nil && *s.MaxResults < 10 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 10))
	}
	if s.PatchGroup == nil {
		invalidParams.Add(request.NewErrParamRequired("PatchGroup"))
	}
	if s.PatchGroup != nil && len(*s.PatchGroup) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PatchGroup", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeInstancePatchStatesForPatchGroupInput) SetFilters(v []*InstancePatchStateFilter) *DescribeInstancePatchStatesForPatchGroupInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeInstancePatchStatesForPatchGroupInput) SetMaxResults(v int64) *DescribeInstancePatchStatesForPatchGroupInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeInstancePatchStatesForPatchGroupInput) SetNextToken(v string) *DescribeInstancePatchStatesForPatchGroupInput {
	s.NextToken = &v
	return s
}

// SetPatchGroup sets the PatchGroup field's value.
func (s *DescribeInstancePatchStatesForPatchGroupInput) SetPatchGroup(v string) *DescribeInstancePatchStatesForPatchGroupInput {
	s.PatchGroup = &v
	return s
}

type DescribeInstancePatchStatesForPatchGroupOutput struct {
	_ struct{} `type:"structure"`

	// The high-level patch state for the requested instances.
	InstancePatchStates []*InstancePatchState `min:"1" type:"list"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeInstancePatchStatesForPatchGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstancePatchStatesForPatchGroupOutput) GoString() string {
	return s.String()
}

// SetInstancePatchStates sets the InstancePatchStates field's value.
func (s *DescribeInstancePatchStatesForPatchGroupOutput) SetInstancePatchStates(v []*InstancePatchState) *DescribeInstancePatchStatesForPatchGroupOutput {
	s.InstancePatchStates = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeInstancePatchStatesForPatchGroupOutput) SetNextToken(v string) *DescribeInstancePatchStatesForPatchGroupOutput {
	s.NextToken = &v
	return s
}

type DescribeInstancePatchStatesInput struct {
	_ struct{} `type:"structure"`

	// The ID of the instance whose patch state information should be retrieved.
	//
	// InstanceIds is a required field
	InstanceIds []*string `type:"list" required:"true"`

	// The maximum number of instances to return (per page).
	MaxResults *int64 `min:"10" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeInstancePatchStatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstancePatchStatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInstancePatchStatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInstancePatchStatesInput"}
	if s.InstanceIds == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceIds"))
	}
	if s.MaxResults != nil && *s.MaxResults < 10 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceIds sets the InstanceIds field's value.
func (s *DescribeInstancePatchStatesInput) SetInstanceIds(v []*string) *DescribeInstancePatchStatesInput {
	s.InstanceIds = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeInstancePatchStatesInput) SetMaxResults(v int64) *DescribeInstancePatchStatesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeInstancePatchStatesInput) SetNextToken(v string) *DescribeInstancePatchStatesInput {
	s.NextToken = &v
	return s
}

type DescribeInstancePatchStatesOutput struct {
	_ struct{} `type:"structure"`

	// The high-level patch state for the requested instances.
	InstancePatchStates []*InstancePatchState `type:"list"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeInstancePatchStatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstancePatchStatesOutput) GoString() string {
	return s.String()
}

// SetInstancePatchStates sets the InstancePatchStates field's value.
func (s *DescribeInstancePatchStatesOutput) SetInstancePatchStates(v []*InstancePatchState) *DescribeInstancePatchStatesOutput {
	s.InstancePatchStates = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeInstancePatchStatesOutput) SetNextToken(v string) *DescribeInstancePatchStatesOutput {
	s.NextToken = &v
	return s
}

type DescribeInstancePatchesInput struct {
	_ struct{} `type:"structure"`

	// Each entry in the array is a structure containing:
	//
	// Key (string, between 1 and 128 characters)
	//
	// Values (array of strings, each string between 1 and 256 characters)
	Filters []*PatchOrchestratorFilter `type:"list"`

	// The ID of the instance whose patch state information should be retrieved.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	// The maximum number of patches to return (per page).
	MaxResults *int64 `min:"10" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeInstancePatchesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstancePatchesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInstancePatchesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInstancePatchesInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 10 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 10))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeInstancePatchesInput) SetFilters(v []*PatchOrchestratorFilter) *DescribeInstancePatchesInput {
	s.Filters = v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeInstancePatchesInput) SetInstanceId(v string) *DescribeInstancePatchesInput {
	s.InstanceId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeInstancePatchesInput) SetMaxResults(v int64) *DescribeInstancePatchesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeInstancePatchesInput) SetNextToken(v string) *DescribeInstancePatchesInput {
	s.NextToken = &v
	return s
}

type DescribeInstancePatchesOutput struct {
	_ struct{} `type:"structure"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`

	// Each entry in the array is a structure containing:
	//
	// Title (string)
	//
	// KBId (string)
	//
	// Classification (string)
	//
	// Severity (string)
	//
	// State (string, such as "INSTALLED" or "FAILED")
	//
	// InstalledTime (DateTime)
	//
	// InstalledBy (string)
	Patches []*PatchComplianceData `type:"list"`
}

// String returns the string representation
func (s DescribeInstancePatchesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstancePatchesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeInstancePatchesOutput) SetNextToken(v string) *DescribeInstancePatchesOutput {
	s.NextToken = &v
	return s
}

// SetPatches sets the Patches field's value.
func (s *DescribeInstancePatchesOutput) SetPatches(v []*PatchComplianceData) *DescribeInstancePatchesOutput {
	s.Patches = v
	return s
}

type DescribeInventoryDeletionsInput struct {
	_ struct{} `type:"structure"`

	// Specify the delete inventory ID for which you want information. This ID was
	// returned by the DeleteInventory action.
	DeletionId *string `type:"string"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token to start the list. Use this token to get the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeInventoryDeletionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInventoryDeletionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInventoryDeletionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInventoryDeletionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeletionId sets the DeletionId field's value.
func (s *DescribeInventoryDeletionsInput) SetDeletionId(v string) *DescribeInventoryDeletionsInput {
	s.DeletionId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeInventoryDeletionsInput) SetMaxResults(v int64) *DescribeInventoryDeletionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeInventoryDeletionsInput) SetNextToken(v string) *DescribeInventoryDeletionsInput {
	s.NextToken = &v
	return s
}

type DescribeInventoryDeletionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of status items for deleted inventory.
	InventoryDeletions []*InventoryDeletionStatusItem `type:"list"`

	// The token for the next set of items to return. Use this token to get the
	// next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeInventoryDeletionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInventoryDeletionsOutput) GoString() string {
	return s.String()
}

// SetInventoryDeletions sets the InventoryDeletions field's value.
func (s *DescribeInventoryDeletionsOutput) SetInventoryDeletions(v []*InventoryDeletionStatusItem) *DescribeInventoryDeletionsOutput {
	s.InventoryDeletions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeInventoryDeletionsOutput) SetNextToken(v string) *DescribeInventoryDeletionsOutput {
	s.NextToken = &v
	return s
}

type DescribeMaintenanceWindowExecutionTaskInvocationsInput struct {
	_ struct{} `type:"structure"`

	// Optional filters used to scope down the returned task invocations. The supported
	// filter key is STATUS with the corresponding values PENDING, IN_PROGRESS,
	// SUCCESS, FAILED, TIMED_OUT, CANCELLING, and CANCELLED.
	Filters []*MaintenanceWindowFilter `type:"list"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"10" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	// The ID of the specific task in the Maintenance Window task that should be
	// retrieved.
	//
	// TaskId is a required field
	TaskId *string `min:"36" type:"string" required:"true"`

	// The ID of the Maintenance Window execution the task is part of.
	//
	// WindowExecutionId is a required field
	WindowExecutionId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeMaintenanceWindowExecutionTaskInvocationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMaintenanceWindowExecutionTaskInvocationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMaintenanceWindowExecutionTaskInvocationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMaintenanceWindowExecutionTaskInvocationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 10 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 10))
	}
	if s.TaskId == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskId"))
	}
	if s.TaskId != nil && len(*s.TaskId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("TaskId", 36))
	}
	if s.WindowExecutionId == nil {
		invalidParams.Add(request.NewErrParamRequired("WindowExecutionId"))
	}
	if s.WindowExecutionId != nil && len(*s.WindowExecutionId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("WindowExecutionId", 36))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeMaintenanceWindowExecutionTaskInvocationsInput) SetFilters(v []*MaintenanceWindowFilter) *DescribeMaintenanceWindowExecutionTaskInvocationsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeMaintenanceWindowExecutionTaskInvocationsInput) SetMaxResults(v int64) *DescribeMaintenanceWindowExecutionTaskInvocationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeMaintenanceWindowExecutionTaskInvocationsInput) SetNextToken(v string) *DescribeMaintenanceWindowExecutionTaskInvocationsInput {
	s.NextToken = &v
	return s
}

// SetTaskId sets the TaskId field's value.
func (s *DescribeMaintenanceWindowExecutionTaskInvocationsInput) SetTaskId(v string) *DescribeMaintenanceWindowExecutionTaskInvocationsInput {
	s.TaskId = &v
	return s
}

// SetWindowExecutionId sets the WindowExecutionId field's value.
func (s *DescribeMaintenanceWindowExecutionTaskInvocationsInput) SetWindowExecutionId(v string) *DescribeMaintenanceWindowExecutionTaskInvocationsInput {
	s.WindowExecutionId = &v
	return s
}

type DescribeMaintenanceWindowExecutionTaskInvocationsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`

	// Information about the task invocation results per invocation.
	WindowExecutionTaskInvocationIdentities []*MaintenanceWindowExecutionTaskInvocationIdentity `type:"list"`
}

// String returns the string representation
func (s DescribeMaintenanceWindowExecutionTaskInvocationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMaintenanceWindowExecutionTaskInvocationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeMaintenanceWindowExecutionTaskInvocationsOutput) SetNextToken(v string) *DescribeMaintenanceWindowExecutionTaskInvocationsOutput {
	s.NextToken = &v
	return s
}

// SetWindowExecutionTaskInvocationIdentities sets the WindowExecutionTaskInvocationIdentities field's value.
func (s *DescribeMaintenanceWindowExecutionTaskInvocationsOutput) SetWindowExecutionTaskInvocationIdentities(v []*MaintenanceWindowExecutionTaskInvocationIdentity) *DescribeMaintenanceWindowExecutionTaskInvocationsOutput {
	s.WindowExecutionTaskInvocationIdentities = v
	return s
}

type DescribeMaintenanceWindowExecutionTasksInput struct {
	_ struct{} `type:"structure"`

	// Optional filters used to scope down the returned tasks. The supported filter
	// key is STATUS with the corresponding values PENDING, IN_PROGRESS, SUCCESS,
	// FAILED, TIMED_OUT, CANCELLING, and CANCELLED.
	Filters []*MaintenanceWindowFilter `type:"list"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"10" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	// The ID of the Maintenance Window execution whose task executions should be
	// retrieved.
	//
	// WindowExecutionId is a required field
	WindowExecutionId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeMaintenanceWindowExecutionTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMaintenanceWindowExecutionTasksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMaintenanceWindowExecutionTasksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMaintenanceWindowExecutionTasksInput"}
	if s.MaxResults != nil && *s.MaxResults < 10 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 10))
	}
	if s.WindowExecutionId == nil {
		invalidParams.Add(request.NewErrParamRequired("WindowExecutionId"))
	}
	if s.WindowExecutionId != nil && len(*s.WindowExecutionId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("WindowExecutionId", 36))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeMaintenanceWindowExecutionTasksInput) SetFilters(v []*MaintenanceWindowFilter) *DescribeMaintenanceWindowExecutionTasksInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeMaintenanceWindowExecutionTasksInput) SetMaxResults(v int64) *DescribeMaintenanceWindowExecutionTasksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeMaintenanceWindowExecutionTasksInput) SetNextToken(v string) *DescribeMaintenanceWindowExecutionTasksInput {
	s.NextToken = &v
	return s
}

// SetWindowExecutionId sets the WindowExecutionId field's value.
func (s *DescribeMaintenanceWindowExecutionTasksInput) SetWindowExecutionId(v string) *DescribeMaintenanceWindowExecutionTasksInput {
	s.WindowExecutionId = &v
	return s
}

type DescribeMaintenanceWindowExecutionTasksOutput struct {
	_ struct{} `type:"structure"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`

	// Information about the task executions.
	WindowExecutionTaskIdentities []*MaintenanceWindowExecutionTaskIdentity `type:"list"`
}

// String returns the string representation
func (s DescribeMaintenanceWindowExecutionTasksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMaintenanceWindowExecutionTasksOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeMaintenanceWindowExecutionTasksOutput) SetNextToken(v string) *DescribeMaintenanceWindowExecutionTasksOutput {
	s.NextToken = &v
	return s
}

// SetWindowExecutionTaskIdentities sets the WindowExecutionTaskIdentities field's value.
func (s *DescribeMaintenanceWindowExecutionTasksOutput) SetWindowExecutionTaskIdentities(v []*MaintenanceWindowExecutionTaskIdentity) *DescribeMaintenanceWindowExecutionTasksOutput {
	s.WindowExecutionTaskIdentities = v
	return s
}

type DescribeMaintenanceWindowExecutionsInput struct {
	_ struct{} `type:"structure"`

	// Each entry in the array is a structure containing:
	//
	// Key (string, between 1 and 128 characters)
	//
	// Values (array of strings, each string is between 1 and 256 characters)
	//
	// The supported Keys are ExecutedBefore and ExecutedAfter with the value being
	// a date/time string such as 2016-11-04T05:00:00Z.
	Filters []*MaintenanceWindowFilter `type:"list"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"10" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	// The ID of the Maintenance Window whose executions should be retrieved.
	//
	// WindowId is a required field
	WindowId *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeMaintenanceWindowExecutionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMaintenanceWindowExecutionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMaintenanceWindowExecutionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMaintenanceWindowExecutionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 10 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 10))
	}
	if s.WindowId == nil {
		invalidParams.Add(request.NewErrParamRequired("WindowId"))
	}
	if s.WindowId != nil && len(*s.WindowId) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("WindowId", 20))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeMaintenanceWindowExecutionsInput) SetFilters(v []*MaintenanceWindowFilter) *DescribeMaintenanceWindowExecutionsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeMaintenanceWindowExecutionsInput) SetMaxResults(v int64) *DescribeMaintenanceWindowExecutionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeMaintenanceWindowExecutionsInput) SetNextToken(v string) *DescribeMaintenanceWindowExecutionsInput {
	s.NextToken = &v
	return s
}

// SetWindowId sets the WindowId field's value.
func (s *DescribeMaintenanceWindowExecutionsInput) SetWindowId(v string) *DescribeMaintenanceWindowExecutionsInput {
	s.WindowId = &v
	return s
}

type DescribeMaintenanceWindowExecutionsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`

	// Information about the Maintenance Windows execution.
	WindowExecutions []*MaintenanceWindowExecution `type:"list"`
}

// String returns the string representation
func (s DescribeMaintenanceWindowExecutionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMaintenanceWindowExecutionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeMaintenanceWindowExecutionsOutput) SetNextToken(v string) *DescribeMaintenanceWindowExecutionsOutput {
	s.NextToken = &v
	return s
}

// SetWindowExecutions sets the WindowExecutions field's value.
func (s *DescribeMaintenanceWindowExecutionsOutput) SetWindowExecutions(v []*MaintenanceWindowExecution) *DescribeMaintenanceWindowExecutionsOutput {
	s.WindowExecutions = v
	return s
}

type DescribeMaintenanceWindowScheduleInput struct {
	_ struct{} `type:"structure"`

	// Filters used to limit the range of results. For example, you can limit Maintenance
	// Window executions to only those scheduled before or after a certain date
	// and time.
	Filters []*PatchOrchestratorFilter `type:"list"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	// The type of resource you want to retrieve information about. For example,
	// "INSTANCE".
	ResourceType *string `type:"string" enum:"MaintenanceWindowResourceType"`

	// The instance ID or key/value pair to retrieve information about.
	Targets []*Target `type:"list"`

	// The ID of the Maintenance Window to retrieve information about.
	WindowId *string `min:"20" type:"string"`
}

// String returns the string representation
func (s DescribeMaintenanceWindowScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMaintenanceWindowScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMaintenanceWindowScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMaintenanceWindowScheduleInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.WindowId != nil && len(*s.WindowId) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("WindowId", 20))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Targets != nil {
		for i, v := range s.Targets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Targets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeMaintenanceWindowScheduleInput) SetFilters(v []*PatchOrchestratorFilter) *DescribeMaintenanceWindowScheduleInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeMaintenanceWindowScheduleInput) SetMaxResults(v int64) *DescribeMaintenanceWindowScheduleInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeMaintenanceWindowScheduleInput) SetNextToken(v string) *DescribeMaintenanceWindowScheduleInput {
	s.NextToken = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *DescribeMaintenanceWindowScheduleInput) SetResourceType(v string) *DescribeMaintenanceWindowScheduleInput {
	s.ResourceType = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *DescribeMaintenanceWindowScheduleInput) SetTargets(v []*Target) *DescribeMaintenanceWindowScheduleInput {
	s.Targets = v
	return s
}

// SetWindowId sets the WindowId field's value.
func (s *DescribeMaintenanceWindowScheduleInput) SetWindowId(v string) *DescribeMaintenanceWindowScheduleInput {
	s.WindowId = &v
	return s
}

type DescribeMaintenanceWindowScheduleOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of items to return. (You use this token in the
	// next call.)
	NextToken *string `type:"string"`

	// Information about Maintenance Window executions scheduled for the specified
	// time range.
	ScheduledWindowExecutions []*ScheduledWindowExecution `type:"list"`
}

// String returns the string representation
func (s DescribeMaintenanceWindowScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMaintenanceWindowScheduleOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeMaintenanceWindowScheduleOutput) SetNextToken(v string) *DescribeMaintenanceWindowScheduleOutput {
	s.NextToken = &v
	return s
}

// SetScheduledWindowExecutions sets the ScheduledWindowExecutions field's value.
func (s *DescribeMaintenanceWindowScheduleOutput) SetScheduledWindowExecutions(v []*ScheduledWindowExecution) *DescribeMaintenanceWindowScheduleOutput {
	s.ScheduledWindowExecutions = v
	return s
}

type DescribeMaintenanceWindowTargetsInput struct {
	_ struct{} `type:"structure"`

	// Optional filters that can be used to narrow down the scope of the returned
	// window targets. The supported filter keys are Type, WindowTargetId and OwnerInformation.
	Filters []*MaintenanceWindowFilter `type:"list"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"10" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	// The ID of the Maintenance Window whose targets should be retrieved.
	//
	// WindowId is a required field
	WindowId *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeMaintenanceWindowTargetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMaintenanceWindowTargetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMaintenanceWindowTargetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMaintenanceWindowTargetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 10 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 10))
	}
	if s.WindowId == nil {
		invalidParams.Add(request.NewErrParamRequired("WindowId"))
	}
	if s.WindowId != nil && len(*s.WindowId) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("WindowId", 20))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeMaintenanceWindowTargetsInput) SetFilters(v []*MaintenanceWindowFilter) *DescribeMaintenanceWindowTargetsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeMaintenanceWindowTargetsInput) SetMaxResults(v int64) *DescribeMaintenanceWindowTargetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeMaintenanceWindowTargetsInput) SetNextToken(v string) *DescribeMaintenanceWindowTargetsInput {
	s.NextToken = &v
	return s
}

// SetWindowId sets the WindowId field's value.
func (s *DescribeMaintenanceWindowTargetsInput) SetWindowId(v string) *DescribeMaintenanceWindowTargetsInput {
	s.WindowId = &v
	return s
}

type DescribeMaintenanceWindowTargetsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`

	// Information about the targets in the Maintenance Window.
	Targets []*MaintenanceWindowTarget `type:"list"`
}

// String returns the string representation
func (s DescribeMaintenanceWindowTargetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMaintenanceWindowTargetsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeMaintenanceWindowTargetsOutput) SetNextToken(v string) *DescribeMaintenanceWindowTargetsOutput {
	s.NextToken = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *DescribeMaintenanceWindowTargetsOutput) SetTargets(v []*MaintenanceWindowTarget) *DescribeMaintenanceWindowTargetsOutput {
	s.Targets = v
	return s
}

type DescribeMaintenanceWindowTasksInput struct {
	_ struct{} `type:"structure"`

	// Optional filters used to narrow down the scope of the returned tasks. The
	// supported filter keys are WindowTaskId, TaskArn, Priority, and TaskType.
	Filters []*MaintenanceWindowFilter `type:"list"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"10" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	// The ID of the Maintenance Window whose tasks should be retrieved.
	//
	// WindowId is a required field
	WindowId *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeMaintenanceWindowTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMaintenanceWindowTasksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMaintenanceWindowTasksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMaintenanceWindowTasksInput"}
	if s.MaxResults != nil && *s.MaxResults < 10 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 10))
	}
	if s.WindowId == nil {
		invalidParams.Add(request.NewErrParamRequired("WindowId"))
	}
	if s.WindowId != nil && len(*s.WindowId) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("WindowId", 20))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeMaintenanceWindowTasksInput) SetFilters(v []*MaintenanceWindowFilter) *DescribeMaintenanceWindowTasksInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeMaintenanceWindowTasksInput) SetMaxResults(v int64) *DescribeMaintenanceWindowTasksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeMaintenanceWindowTasksInput) SetNextToken(v string) *DescribeMaintenanceWindowTasksInput {
	s.NextToken = &v
	return s
}

// SetWindowId sets the WindowId field's value.
func (s *DescribeMaintenanceWindowTasksInput) SetWindowId(v string) *DescribeMaintenanceWindowTasksInput {
	s.WindowId = &v
	return s
}

type DescribeMaintenanceWindowTasksOutput struct {
	_ struct{} `type:"structure"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`

	// Information about the tasks in the Maintenance Window.
	Tasks []*MaintenanceWindowTask `type:"list"`
}

// String returns the string representation
func (s DescribeMaintenanceWindowTasksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMaintenanceWindowTasksOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeMaintenanceWindowTasksOutput) SetNextToken(v string) *DescribeMaintenanceWindowTasksOutput {
	s.NextToken = &v
	return s
}

// SetTasks sets the Tasks field's value.
func (s *DescribeMaintenanceWindowTasksOutput) SetTasks(v []*MaintenanceWindowTask) *DescribeMaintenanceWindowTasksOutput {
	s.Tasks = v
	return s
}

type DescribeMaintenanceWindowsForTargetInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	// The type of resource you want to retrieve information about. For example,
	// "INSTANCE".
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true" enum:"MaintenanceWindowResourceType"`

	// The instance ID or key/value pair to retrieve information about.
	//
	// Targets is a required field
	Targets []*Target `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeMaintenanceWindowsForTargetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMaintenanceWindowsForTargetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMaintenanceWindowsForTargetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMaintenanceWindowsForTargetInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.Targets == nil {
		invalidParams.Add(request.NewErrParamRequired("Targets"))
	}
	if s.Targets != nil {
		for i, v := range s.Targets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Targets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeMaintenanceWindowsForTargetInput) SetMaxResults(v int64) *DescribeMaintenanceWindowsForTargetInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeMaintenanceWindowsForTargetInput) SetNextToken(v string) *DescribeMaintenanceWindowsForTargetInput {
	s.NextToken = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *DescribeMaintenanceWindowsForTargetInput) SetResourceType(v string) *DescribeMaintenanceWindowsForTargetInput {
	s.ResourceType = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *DescribeMaintenanceWindowsForTargetInput) SetTargets(v []*Target) *DescribeMaintenanceWindowsForTargetInput {
	s.Targets = v
	return s
}

type DescribeMaintenanceWindowsForTargetOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of items to return. (You use this token in the
	// next call.)
	NextToken *string `type:"string"`

	// Information about the Maintenance Window targets and tasks an instance is
	// associated with.
	WindowIdentities []*MaintenanceWindowIdentityForTarget `type:"list"`
}

// String returns the string representation
func (s DescribeMaintenanceWindowsForTargetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMaintenanceWindowsForTargetOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeMaintenanceWindowsForTargetOutput) SetNextToken(v string) *DescribeMaintenanceWindowsForTargetOutput {
	s.NextToken = &v
	return s
}

// SetWindowIdentities sets the WindowIdentities field's value.
func (s *DescribeMaintenanceWindowsForTargetOutput) SetWindowIdentities(v []*MaintenanceWindowIdentityForTarget) *DescribeMaintenanceWindowsForTargetOutput {
	s.WindowIdentities = v
	return s
}

type DescribeMaintenanceWindowsInput struct {
	_ struct{} `type:"structure"`

	// Optional filters used to narrow down the scope of the returned Maintenance
	// Windows. Supported filter keys are Name and Enabled.
	Filters []*MaintenanceWindowFilter `type:"list"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"10" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeMaintenanceWindowsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMaintenanceWindowsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMaintenanceWindowsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMaintenanceWindowsInput"}
	if s.MaxResults != nil && *s.MaxResults < 10 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 10))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeMaintenanceWindowsInput) SetFilters(v []*MaintenanceWindowFilter) *DescribeMaintenanceWindowsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeMaintenanceWindowsInput) SetMaxResults(v int64) *DescribeMaintenanceWindowsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeMaintenanceWindowsInput) SetNextToken(v string) *DescribeMaintenanceWindowsInput {
	s.NextToken = &v
	return s
}

type DescribeMaintenanceWindowsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`

	// Information about the Maintenance Windows.
	WindowIdentities []*MaintenanceWindowIdentity `type:"list"`
}

// String returns the string representation
func (s DescribeMaintenanceWindowsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMaintenanceWindowsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeMaintenanceWindowsOutput) SetNextToken(v string) *DescribeMaintenanceWindowsOutput {
	s.NextToken = &v
	return s
}

// SetWindowIdentities sets the WindowIdentities field's value.
func (s *DescribeMaintenanceWindowsOutput) SetWindowIdentities(v []*MaintenanceWindowIdentity) *DescribeMaintenanceWindowsOutput {
	s.WindowIdentities = v
	return s
}

type DescribeParametersInput struct {
	_ struct{} `type:"structure"`

	// One or more filters. Use a filter to return a more specific list of results.
	Filters []*ParametersFilter `type:"list"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	// Filters to limit the request results.
	ParameterFilters []*ParameterStringFilter `type:"list"`
}

// String returns the string representation
func (s DescribeParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeParametersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeParametersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeParametersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ParameterFilters != nil {
		for i, v := range s.ParameterFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ParameterFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeParametersInput) SetFilters(v []*ParametersFilter) *DescribeParametersInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeParametersInput) SetMaxResults(v int64) *DescribeParametersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeParametersInput) SetNextToken(v string) *DescribeParametersInput {
	s.NextToken = &v
	return s
}

// SetParameterFilters sets the ParameterFilters field's value.
func (s *DescribeParametersInput) SetParameterFilters(v []*ParameterStringFilter) *DescribeParametersInput {
	s.ParameterFilters = v
	return s
}

type DescribeParametersOutput struct {
	_ struct{} `type:"structure"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`

	// Parameters returned by the request.
	Parameters []*ParameterMetadata `type:"list"`
}

// String returns the string representation
func (s DescribeParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeParametersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeParametersOutput) SetNextToken(v string) *DescribeParametersOutput {
	s.NextToken = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *DescribeParametersOutput) SetParameters(v []*ParameterMetadata) *DescribeParametersOutput {
	s.Parameters = v
	return s
}

type DescribePatchBaselinesInput struct {
	_ struct{} `type:"structure"`

	// Each element in the array is a structure containing:
	//
	// Key: (string, "NAME_PREFIX" or "OWNER")
	//
	// Value: (array of strings, exactly 1 entry, between 1 and 255 characters)
	Filters []*PatchOrchestratorFilter `type:"list"`

	// The maximum number of patch baselines to return (per page).
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribePatchBaselinesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePatchBaselinesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePatchBaselinesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePatchBaselinesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribePatchBaselinesInput) SetFilters(v []*PatchOrchestratorFilter) *DescribePatchBaselinesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribePatchBaselinesInput) SetMaxResults(v int64) *DescribePatchBaselinesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribePatchBaselinesInput) SetNextToken(v string) *DescribePatchBaselinesInput {
	s.NextToken = &v
	return s
}

type DescribePatchBaselinesOutput struct {
	_ struct{} `type:"structure"`

	// An array of PatchBaselineIdentity elements.
	BaselineIdentities []*PatchBaselineIdentity `type:"list"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribePatchBaselinesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePatchBaselinesOutput) GoString() string {
	return s.String()
}

// SetBaselineIdentities sets the BaselineIdentities field's value.
func (s *DescribePatchBaselinesOutput) SetBaselineIdentities(v []*PatchBaselineIdentity) *DescribePatchBaselinesOutput {
	s.BaselineIdentities = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribePatchBaselinesOutput) SetNextToken(v string) *DescribePatchBaselinesOutput {
	s.NextToken = &v
	return s
}

type DescribePatchGroupStateInput struct {
	_ struct{} `type:"structure"`

	// The name of the patch group whose patch snapshot should be retrieved.
	//
	// PatchGroup is a required field
	PatchGroup *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribePatchGroupStateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePatchGroupStateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePatchGroupStateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePatchGroupStateInput"}
	if s.PatchGroup == nil {
		invalidParams.Add(request.NewErrParamRequired("PatchGroup"))
	}
	if s.PatchGroup != nil && len(*s.PatchGroup) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PatchGroup", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPatchGroup sets the PatchGroup field's value.
func (s *DescribePatchGroupStateInput) SetPatchGroup(v string) *DescribePatchGroupStateInput {
	s.PatchGroup = &v
	return s
}

type DescribePatchGroupStateOutput struct {
	_ struct{} `type:"structure"`

	// The number of instances in the patch group.
	Instances *int64 `type:"integer"`

	// The number of instances with patches from the patch baseline that failed
	// to install.
	InstancesWithFailedPatches *int64 `type:"integer"`

	// The number of instances with patches installed that aren't defined in the
	// patch baseline.
	InstancesWithInstalledOtherPatches *int64 `type:"integer"`

	// The number of instances with installed patches.
	InstancesWithInstalledPatches *int64 `type:"integer"`

	// The number of instances with patches installed that are specified in a RejectedPatches
	// list. Patches with a status of INSTALLED_REJECTED were typically installed
	// before they were added to a RejectedPatches list.
	//
	// If ALLOW_AS_DEPENDENCY is the specified option for RejectedPatchesAction,
	// the value of InstancesWithInstalledRejectedPatches will always be 0 (zero).
	InstancesWithInstalledRejectedPatches *int64 `type:"integer"`

	// The number of instances with missing patches from the patch baseline.
	InstancesWithMissingPatches *int64 `type:"integer"`

	// The number of instances with patches that aren't applicable.
	InstancesWithNotApplicablePatches *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribePatchGroupStateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePatchGroupStateOutput) GoString() string {
	return s.String()
}

// SetInstances sets the Instances field's value.
func (s *DescribePatchGroupStateOutput) SetInstances(v int64) *DescribePatchGroupStateOutput {
	s.Instances = &v
	return s
}

// SetInstancesWithFailedPatches sets the InstancesWithFailedPatches field's value.
func (s *DescribePatchGroupStateOutput) SetInstancesWithFailedPatches(v int64) *DescribePatchGroupStateOutput {
	s.InstancesWithFailedPatches = &v
	return s
}

// SetInstancesWithInstalledOtherPatches sets the InstancesWithInstalledOtherPatches field's value.
func (s *DescribePatchGroupStateOutput) SetInstancesWithInstalledOtherPatches(v int64) *DescribePatchGroupStateOutput {
	s.InstancesWithInstalledOtherPatches = &v
	return s
}

// SetInstancesWithInstalledPatches sets the InstancesWithInstalledPatches field's value.
func (s *DescribePatchGroupStateOutput) SetInstancesWithInstalledPatches(v int64) *DescribePatchGroupStateOutput {
	s.InstancesWithInstalledPatches = &v
	return s
}

// SetInstancesWithInstalledRejectedPatches sets the InstancesWithInstalledRejectedPatches field's value.
func (s *DescribePatchGroupStateOutput) SetInstancesWithInstalledRejectedPatches(v int64) *DescribePatchGroupStateOutput {
	s.InstancesWithInstalledRejectedPatches = &v
	return s
}

// SetInstancesWithMissingPatches sets the InstancesWithMissingPatches field's value.
func (s *DescribePatchGroupStateOutput) SetInstancesWithMissingPatches(v int64) *DescribePatchGroupStateOutput {
	s.InstancesWithMissingPatches = &v
	return s
}

// SetInstancesWithNotApplicablePatches sets the InstancesWithNotApplicablePatches field's value.
func (s *DescribePatchGroupStateOutput) SetInstancesWithNotApplicablePatches(v int64) *DescribePatchGroupStateOutput {
	s.InstancesWithNotApplicablePatches = &v
	return s
}

type DescribePatchGroupsInput struct {
	_ struct{} `type:"structure"`

	// One or more filters. Use a filter to return a more specific list of results.
	Filters []*PatchOrchestratorFilter `type:"list"`

	// The maximum number of patch groups to return (per page).
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribePatchGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePatchGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePatchGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePatchGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribePatchGroupsInput) SetFilters(v []*PatchOrchestratorFilter) *DescribePatchGroupsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribePatchGroupsInput) SetMaxResults(v int64) *DescribePatchGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribePatchGroupsInput) SetNextToken(v string) *DescribePatchGroupsInput {
	s.NextToken = &v
	return s
}

type DescribePatchGroupsOutput struct {
	_ struct{} `type:"structure"`

	// Each entry in the array contains:
	//
	// PatchGroup: string (between 1 and 256 characters, Regex: ^([\p{L}\p{Z}\p{N}_.:/=+\-@]*)$)
	//
	// PatchBaselineIdentity: A PatchBaselineIdentity element.
	Mappings []*PatchGroupPatchBaselineMapping `type:"list"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribePatchGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePatchGroupsOutput) GoString() string {
	return s.String()
}

// SetMappings sets the Mappings field's value.
func (s *DescribePatchGroupsOutput) SetMappings(v []*PatchGroupPatchBaselineMapping) *DescribePatchGroupsOutput {
	s.Mappings = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribePatchGroupsOutput) SetNextToken(v string) *DescribePatchGroupsOutput {
	s.NextToken = &v
	return s
}

type DescribeSessionsInput struct {
	_ struct{} `type:"structure"`

	// One or more filters to limit the type of sessions returned by the request.
	Filters []*SessionFilter `min:"1" type:"list"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	// The session status to retrieve a list of sessions for. For example, "Active".
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"SessionState"`
}

// String returns the string representation
func (s DescribeSessionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSessionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSessionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSessionsInput"}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.State == nil {
		invalidParams.Add(request.NewErrParamRequired("State"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeSessionsInput) SetFilters(v []*SessionFilter) *DescribeSessionsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeSessionsInput) SetMaxResults(v int64) *DescribeSessionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSessionsInput) SetNextToken(v string) *DescribeSessionsInput {
	s.NextToken = &v
	return s
}

// SetState sets the State field's value.
func (s *DescribeSessionsInput) SetState(v string) *DescribeSessionsInput {
	s.State = &v
	return s
}

type DescribeSessionsOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	// A list of sessions meeting the request parameters.
	Sessions []*Session `type:"list"`
}

// String returns the string representation
func (s DescribeSessionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSessionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSessionsOutput) SetNextToken(v string) *DescribeSessionsOutput {
	s.NextToken = &v
	return s
}

// SetSessions sets the Sessions field's value.
func (s *DescribeSessionsOutput) SetSessions(v []*Session) *DescribeSessionsOutput {
	s.Sessions = v
	return s
}

// A default version of a document.
type DocumentDefaultVersionDescription struct {
	_ struct{} `type:"structure"`

	// The default version of the document.
	DefaultVersion *string `type:"string"`

	// The default version of the artifact associated with the document.
	DefaultVersionName *string `type:"string"`

	// The name of the document.
	Name *string `type:"string"`
}

// String returns the string representation
func (s DocumentDefaultVersionDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocumentDefaultVersionDescription) GoString() string {
	return s.String()
}

// SetDefaultVersion sets the DefaultVersion field's value.
func (s *DocumentDefaultVersionDescription) SetDefaultVersion(v string) *DocumentDefaultVersionDescription {
	s.DefaultVersion = &v
	return s
}

// SetDefaultVersionName sets the DefaultVersionName field's value.
func (s *DocumentDefaultVersionDescription) SetDefaultVersionName(v string) *DocumentDefaultVersionDescription {
	s.DefaultVersionName = &v
	return s
}

// SetName sets the Name field's value.
func (s *DocumentDefaultVersionDescription) SetName(v string) *DocumentDefaultVersionDescription {
	s.Name = &v
	return s
}

// Describes a Systems Manager document.
type DocumentDescription struct {
	_ struct{} `type:"structure"`

	// Details about the document attachments, including names, locations, sizes,
	// etc.
	AttachmentsInformation []*AttachmentInformation `type:"list"`

	// The date when the document was created.
	CreatedDate *time.Time `type:"timestamp"`

	// The default version.
	DefaultVersion *string `type:"string"`

	// A description of the document.
	Description *string `type:"string"`

	// The document format, either JSON or YAML.
	DocumentFormat *string `type:"string" enum:"DocumentFormat"`

	// The type of document.
	DocumentType *string `type:"string" enum:"DocumentType"`

	// The document version.
	DocumentVersion *string `type:"string"`

	// The Sha256 or Sha1 hash created by the system when the document was created.
	//
	// Sha1 hashes have been deprecated.
	Hash *string `type:"string"`

	// The hash type of the document. Valid values include Sha256 or Sha1.
	//
	// Sha1 hashes have been deprecated.
	HashType *string `type:"string" enum:"DocumentHashType"`

	// The latest version of the document.
	LatestVersion *string `type:"string"`

	// The name of the Systems Manager document.
	Name *string `type:"string"`

	// The AWS user account that created the document.
	Owner *string `type:"string"`

	// A description of the parameters for a document.
	Parameters []*DocumentParameter `type:"list"`

	// The list of OS platforms compatible with this Systems Manager document.
	PlatformTypes []*string `type:"list"`

	// The schema version.
	SchemaVersion *string `type:"string"`

	// The SHA1 hash of the document, which you can use for verification.
	Sha1 *string `type:"string"`

	// The status of the Systems Manager document.
	Status *string `type:"string" enum:"DocumentStatus"`

	// A message returned by AWS Systems Manager that explains the Status value.
	// For example, a Failed status might be explained by the StatusInformation
	// message, "The specified S3 bucket does not exist. Verify that the URL of
	// the S3 bucket is correct."
	StatusInformation *string `type:"string"`

	// The tags, or metadata, that have been applied to the document.
	Tags []*Tag `type:"list"`

	// The target type which defines the kinds of resources the document can run
	// on. For example, /AWS::EC2::Instance. For a list of valid resource types,
	// see AWS Resource Types Reference (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the AWS CloudFormation User Guide.
	TargetType *string `type:"string"`

	// The version of the artifact associated with the document.
	VersionName *string `type:"string"`
}

// String returns the string representation
func (s DocumentDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocumentDescription) GoString() string {
	return s.String()
}

// SetAttachmentsInformation sets the AttachmentsInformation field's value.
func (s *DocumentDescription) SetAttachmentsInformation(v []*AttachmentInformation) *DocumentDescription {
	s.AttachmentsInformation = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *DocumentDescription) SetCreatedDate(v time.Time) *DocumentDescription {
	s.CreatedDate = &v
	return s
}

// SetDefaultVersion sets the DefaultVersion field's value.
func (s *DocumentDescription) SetDefaultVersion(v string) *DocumentDescription {
	s.DefaultVersion = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DocumentDescription) SetDescription(v string) *DocumentDescription {
	s.Description = &v
	return s
}

// SetDocumentFormat sets the DocumentFormat field's value.
func (s *DocumentDescription) SetDocumentFormat(v string) *DocumentDescription {
	s.DocumentFormat = &v
	return s
}

// SetDocumentType sets the DocumentType field's value.
func (s *DocumentDescription) SetDocumentType(v string) *DocumentDescription {
	s.DocumentType = &v
	return s
}

// SetDocumentVersion sets the DocumentVersion field's value.
func (s *DocumentDescription) SetDocumentVersion(v string) *DocumentDescription {
	s.DocumentVersion = &v
	return s
}

// SetHash sets the Hash field's value.
func (s *DocumentDescription) SetHash(v string) *DocumentDescription {
	s.Hash = &v
	return s
}

// SetHashType sets the HashType field's value.
func (s *DocumentDescription) SetHashType(v string) *DocumentDescription {
	s.HashType = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *DocumentDescription) SetLatestVersion(v string) *DocumentDescription {
	s.LatestVersion = &v
	return s
}

// SetName sets the Name field's value.
func (s *DocumentDescription) SetName(v string) *DocumentDescription {
	s.Name = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *DocumentDescription) SetOwner(v string) *DocumentDescription {
	s.Owner = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *DocumentDescription) SetParameters(v []*DocumentParameter) *DocumentDescription {
	s.Parameters = v
	return s
}

// SetPlatformTypes sets the PlatformTypes field's value.
func (s *DocumentDescription) SetPlatformTypes(v []*string) *DocumentDescription {
	s.PlatformTypes = v
	return s
}

// SetSchemaVersion sets the SchemaVersion field's value.
func (s *DocumentDescription) SetSchemaVersion(v string) *DocumentDescription {
	s.SchemaVersion = &v
	return s
}

// SetSha1 sets the Sha1 field's value.
func (s *DocumentDescription) SetSha1(v string) *DocumentDescription {
	s.Sha1 = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DocumentDescription) SetStatus(v string) *DocumentDescription {
	s.Status = &v
	return s
}

// SetStatusInformation sets the StatusInformation field's value.
func (s *DocumentDescription) SetStatusInformation(v string) *DocumentDescription {
	s.StatusInformation = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DocumentDescription) SetTags(v []*Tag) *DocumentDescription {
	s.Tags = v
	return s
}

// SetTargetType sets the TargetType field's value.
func (s *DocumentDescription) SetTargetType(v string) *DocumentDescription {
	s.TargetType = &v
	return s
}

// SetVersionName sets the VersionName field's value.
func (s *DocumentDescription) SetVersionName(v string) *DocumentDescription {
	s.VersionName = &v
	return s
}

// Describes a filter.
type DocumentFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	//
	// Key is a required field
	Key *string `locationName:"key" type:"string" required:"true" enum:"DocumentFilterKey"`

	// The value of the filter.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DocumentFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocumentFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DocumentFilter"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *DocumentFilter) SetKey(v string) *DocumentFilter {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *DocumentFilter) SetValue(v string) *DocumentFilter {
	s.Value = &v
	return s
}

// Describes the name of a Systems Manager document.
type DocumentIdentifier struct {
	_ struct{} `type:"structure"`

	// The document format, either JSON or YAML.
	DocumentFormat *string `type:"string" enum:"DocumentFormat"`

	// The document type.
	DocumentType *string `type:"string" enum:"DocumentType"`

	// The document version.
	DocumentVersion *string `type:"string"`

	// The name of the Systems Manager document.
	Name *string `type:"string"`

	// The AWS user account that created the document.
	Owner *string `type:"string"`

	// The operating system platform.
	PlatformTypes []*string `type:"list"`

	// The schema version.
	SchemaVersion *string `type:"string"`

	// The tags, or metadata, that have been applied to the document.
	Tags []*Tag `type:"list"`

	// The target type which defines the kinds of resources the document can run
	// on. For example, /AWS::EC2::Instance. For a list of valid resource types,
	// see AWS Resource Types Reference (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the AWS CloudFormation User Guide.
	TargetType *string `type:"string"`

	// An optional field specifying the version of the artifact associated with
	// the document. For example, "Release 12, Update 6". This value is unique across
	// all versions of a document, and cannot be changed.
	VersionName *string `type:"string"`
}

// String returns the string representation
func (s DocumentIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocumentIdentifier) GoString() string {
	return s.String()
}

// SetDocumentFormat sets the DocumentFormat field's value.
func (s *DocumentIdentifier) SetDocumentFormat(v string) *DocumentIdentifier {
	s.DocumentFormat = &v
	return s
}

// SetDocumentType sets the DocumentType field's value.
func (s *DocumentIdentifier) SetDocumentType(v string) *DocumentIdentifier {
	s.DocumentType = &v
	return s
}

// SetDocumentVersion sets the DocumentVersion field's value.
func (s *DocumentIdentifier) SetDocumentVersion(v string) *DocumentIdentifier {
	s.DocumentVersion = &v
	return s
}

// SetName sets the Name field's value.
func (s *DocumentIdentifier) SetName(v string) *DocumentIdentifier {
	s.Name = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *DocumentIdentifier) SetOwner(v string) *DocumentIdentifier {
	s.Owner = &v
	return s
}

// SetPlatformTypes sets the PlatformTypes field's value.
func (s *DocumentIdentifier) SetPlatformTypes(v []*string) *DocumentIdentifier {
	s.PlatformTypes = v
	return s
}

// SetSchemaVersion sets the SchemaVersion field's value.
func (s *DocumentIdentifier) SetSchemaVersion(v string) *DocumentIdentifier {
	s.SchemaVersion = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DocumentIdentifier) SetTags(v []*Tag) *DocumentIdentifier {
	s.Tags = v
	return s
}

// SetTargetType sets the TargetType field's value.
func (s *DocumentIdentifier) SetTargetType(v string) *DocumentIdentifier {
	s.TargetType = &v
	return s
}

// SetVersionName sets the VersionName field's value.
func (s *DocumentIdentifier) SetVersionName(v string) *DocumentIdentifier {
	s.VersionName = &v
	return s
}

// One or more filters. Use a filter to return a more specific list of documents.
//
// For keys, you can specify one or more tags that have been applied to a document.
//
// Other valid values include Owner, Name, PlatformTypes, and DocumentType.
//
// Note that only one Owner can be specified in a request. For example: Key=Owner,Values=Self.
//
// If you use Name as a key, you can use a name prefix to return a list of documents.
// For example, in the AWS CLI, to return a list of all documents that begin
// with Te, run the following command:
//
// aws ssm list-documents --filters Key=Name,Values=Te
//
// If you specify more than two keys, only documents that are identified by
// all the tags are returned in the results. If you specify more than two values
// for a key, documents that are identified by any of the values are returned
// in the results.
//
// To specify a custom key and value pair, use the format Key=tag:[tagName],Values=[valueName].
//
// For example, if you created a Key called region and are using the AWS CLI
// to call the list-documents command:
//
// aws ssm list-documents --filters Key=tag:region,Values=east,west Key=Owner,Values=Self
type DocumentKeyValuesFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter key.
	Key *string `min:"1" type:"string"`

	// The value for the filter key.
	Values []*string `type:"list"`
}

// String returns the string representation
func (s DocumentKeyValuesFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocumentKeyValuesFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentKeyValuesFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DocumentKeyValuesFilter"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *DocumentKeyValuesFilter) SetKey(v string) *DocumentKeyValuesFilter {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *DocumentKeyValuesFilter) SetValues(v []*string) *DocumentKeyValuesFilter {
	s.Values = v
	return s
}

// Parameters specified in a System Manager document that execute on the server
// when the command is run.
type DocumentParameter struct {
	_ struct{} `type:"structure"`

	// If specified, the default values for the parameters. Parameters without a
	// default value are required. Parameters with a default value are optional.
	DefaultValue *string `type:"string"`

	// A description of what the parameter does, how to use it, the default value,
	// and whether or not the parameter is optional.
	Description *string `type:"string"`

	// The name of the parameter.
	Name *string `type:"string"`

	// The type of parameter. The type can be either String or StringList.
	Type *string `type:"string" enum:"DocumentParameterType"`
}

// String returns the string representation
func (s DocumentParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocumentParameter) GoString() string {
	return s.String()
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *DocumentParameter) SetDefaultValue(v string) *DocumentParameter {
	s.DefaultValue = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DocumentParameter) SetDescription(v string) *DocumentParameter {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *DocumentParameter) SetName(v string) *DocumentParameter {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *DocumentParameter) SetType(v string) *DocumentParameter {
	s.Type = &v
	return s
}

// Version information about the document.
type DocumentVersionInfo struct {
	_ struct{} `type:"structure"`

	// The date the document was created.
	CreatedDate *time.Time `type:"timestamp"`

	// The document format, either JSON or YAML.
	DocumentFormat *string `type:"string" enum:"DocumentFormat"`

	// The document version.
	DocumentVersion *string `type:"string"`

	// An identifier for the default version of the document.
	IsDefaultVersion *bool `type:"boolean"`

	// The document name.
	Name *string `type:"string"`

	// The status of the Systems Manager document, such as Creating, Active, Failed,
	// and Deleting.
	Status *string `type:"string" enum:"DocumentStatus"`

	// A message returned by AWS Systems Manager that explains the Status value.
	// For example, a Failed status might be explained by the StatusInformation
	// message, "The specified S3 bucket does not exist. Verify that the URL of
	// the S3 bucket is correct."
	StatusInformation *string `type:"string"`

	// The version of the artifact associated with the document. For example, "Release
	// 12, Update 6". This value is unique across all versions of a document, and
	// cannot be changed.
	VersionName *string `type:"string"`
}

// String returns the string representation
func (s DocumentVersionInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocumentVersionInfo) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *DocumentVersionInfo) SetCreatedDate(v time.Time) *DocumentVersionInfo {
	s.CreatedDate = &v
	return s
}

// SetDocumentFormat sets the DocumentFormat field's value.
func (s *DocumentVersionInfo) SetDocumentFormat(v string) *DocumentVersionInfo {
	s.DocumentFormat = &v
	return s
}

// SetDocumentVersion sets the DocumentVersion field's value.
func (s *DocumentVersionInfo) SetDocumentVersion(v string) *DocumentVersionInfo {
	s.DocumentVersion = &v
	return s
}

// SetIsDefaultVersion sets the IsDefaultVersion field's value.
func (s *DocumentVersionInfo) SetIsDefaultVersion(v bool) *DocumentVersionInfo {
	s.IsDefaultVersion = &v
	return s
}

// SetName sets the Name field's value.
func (s *DocumentVersionInfo) SetName(v string) *DocumentVersionInfo {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DocumentVersionInfo) SetStatus(v string) *DocumentVersionInfo {
	s.Status = &v
	return s
}

// SetStatusInformation sets the StatusInformation field's value.
func (s *DocumentVersionInfo) SetStatusInformation(v string) *DocumentVersionInfo {
	s.StatusInformation = &v
	return s
}

// SetVersionName sets the VersionName field's value.
func (s *DocumentVersionInfo) SetVersionName(v string) *DocumentVersionInfo {
	s.VersionName = &v
	return s
}

// The EffectivePatch structure defines metadata about a patch along with the
// approval state of the patch in a particular patch baseline. The approval
// state includes information about whether the patch is currently approved,
// due to be approved by a rule, explicitly approved, or explicitly rejected
// and the date the patch was or will be approved.
type EffectivePatch struct {
	_ struct{} `type:"structure"`

	// Provides metadata for a patch, including information such as the KB ID, severity,
	// classification and a URL for where more information can be obtained about
	// the patch.
	Patch *Patch `type:"structure"`

	// The status of the patch in a patch baseline. This includes information about
	// whether the patch is currently approved, due to be approved by a rule, explicitly
	// approved, or explicitly rejected and the date the patch was or will be approved.
	PatchStatus *PatchStatus `type:"structure"`
}

// String returns the string representation
func (s EffectivePatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EffectivePatch) GoString() string {
	return s.String()
}

// SetPatch sets the Patch field's value.
func (s *EffectivePatch) SetPatch(v *Patch) *EffectivePatch {
	s.Patch = v
	return s
}

// SetPatchStatus sets the PatchStatus field's value.
func (s *EffectivePatch) SetPatchStatus(v *PatchStatus) *EffectivePatch {
	s.PatchStatus = v
	return s
}

// Describes a failed association.
type FailedCreateAssociation struct {
	_ struct{} `type:"structure"`

	// The association.
	Entry *CreateAssociationBatchRequestEntry `type:"structure"`

	// The source of the failure.
	Fault *string `type:"string" enum:"Fault"`

	// A description of the failure.
	Message *string `type:"string"`
}

// String returns the string representation
func (s FailedCreateAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailedCreateAssociation) GoString() string {
	return s.String()
}

// SetEntry sets the Entry field's value.
func (s *FailedCreateAssociation) SetEntry(v *CreateAssociationBatchRequestEntry) *FailedCreateAssociation {
	s.Entry = v
	return s
}

// SetFault sets the Fault field's value.
func (s *FailedCreateAssociation) SetFault(v string) *FailedCreateAssociation {
	s.Fault = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *FailedCreateAssociation) SetMessage(v string) *FailedCreateAssociation {
	s.Message = &v
	return s
}

// Information about an Automation failure.
type FailureDetails struct {
	_ struct{} `type:"structure"`

	// Detailed information about the Automation step failure.
	Details map[string][]*string `min:"1" type:"map"`

	// The stage of the Automation execution when the failure occurred. The stages
	// include the following: InputValidation, PreVerification, Invocation, PostVerification.
	FailureStage *string `type:"string"`

	// The type of Automation failure. Failure types include the following: Action,
	// Permission, Throttling, Verification, Internal.
	FailureType *string `type:"string"`
}

// String returns the string representation
func (s FailureDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailureDetails) GoString() string {
	return s.String()
}

// SetDetails sets the Details field's value.
func (s *FailureDetails) SetDetails(v map[string][]*string) *FailureDetails {
	s.Details = v
	return s
}

// SetFailureStage sets the FailureStage field's value.
func (s *FailureDetails) SetFailureStage(v string) *FailureDetails {
	s.FailureStage = &v
	return s
}

// SetFailureType sets the FailureType field's value.
func (s *FailureDetails) SetFailureType(v string) *FailureDetails {
	s.FailureType = &v
	return s
}

type GetAutomationExecutionInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for an existing automation execution to examine. The
	// execution ID is returned by StartAutomationExecution when the execution of
	// an Automation document is initiated.
	//
	// AutomationExecutionId is a required field
	AutomationExecutionId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAutomationExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAutomationExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAutomationExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAutomationExecutionInput"}
	if s.AutomationExecutionId == nil {
		invalidParams.Add(request.NewErrParamRequired("AutomationExecutionId"))
	}
	if s.AutomationExecutionId != nil && len(*s.AutomationExecutionId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AutomationExecutionId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutomationExecutionId sets the AutomationExecutionId field's value.
func (s *GetAutomationExecutionInput) SetAutomationExecutionId(v string) *GetAutomationExecutionInput {
	s.AutomationExecutionId = &v
	return s
}

type GetAutomationExecutionOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about the current state of an automation execution.
	AutomationExecution *AutomationExecution `type:"structure"`
}

// String returns the string representation
func (s GetAutomationExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAutomationExecutionOutput) GoString() string {
	return s.String()
}

// SetAutomationExecution sets the AutomationExecution field's value.
func (s *GetAutomationExecutionOutput) SetAutomationExecution(v *AutomationExecution) *GetAutomationExecutionOutput {
	s.AutomationExecution = v
	return s
}

type GetCommandInvocationInput struct {
	_ struct{} `type:"structure"`

	// (Required) The parent command ID of the invocation plugin.
	//
	// CommandId is a required field
	CommandId *string `min:"36" type:"string" required:"true"`

	// (Required) The ID of the managed instance targeted by the command. A managed
	// instance can be an Amazon EC2 instance or an instance in your hybrid environment
	// that is configured for Systems Manager.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	// (Optional) The name of the plugin for which you want detailed results. If
	// the document contains only one plugin, the name can be omitted and the details
	// will be returned.
	PluginName *string `min:"4" type:"string"`
}

// String returns the string representation
func (s GetCommandInvocationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCommandInvocationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCommandInvocationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCommandInvocationInput"}
	if s.CommandId == nil {
		invalidParams.Add(request.NewErrParamRequired("CommandId"))
	}
	if s.CommandId != nil && len(*s.CommandId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CommandId", 36))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.PluginName != nil && len(*s.PluginName) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("PluginName", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCommandId sets the CommandId field's value.
func (s *GetCommandInvocationInput) SetCommandId(v string) *GetCommandInvocationInput {
	s.CommandId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *GetCommandInvocationInput) SetInstanceId(v string) *GetCommandInvocationInput {
	s.InstanceId = &v
	return s
}

// SetPluginName sets the PluginName field's value.
func (s *GetCommandInvocationInput) SetPluginName(v string) *GetCommandInvocationInput {
	s.PluginName = &v
	return s
}

type GetCommandInvocationOutput struct {
	_ struct{} `type:"structure"`

	// CloudWatch Logs information where Systems Manager sent the command output.
	CloudWatchOutputConfig *CloudWatchOutputConfig `type:"structure"`

	// The parent command ID of the invocation plugin.
	CommandId *string `min:"36" type:"string"`

	// The comment text for the command.
	Comment *string `type:"string"`

	// The name of the document that was executed. For example, AWS-RunShellScript.
	DocumentName *string `type:"string"`

	// The SSM document version used in the request.
	DocumentVersion *string `type:"string"`

	// Duration since ExecutionStartDateTime.
	ExecutionElapsedTime *string `type:"string"`

	// The date and time the plugin was finished executing. Date and time are written
	// in ISO 8601 format. For example, June 7, 2017 is represented as 2017-06-7.
	// The following sample AWS CLI command uses the InvokedAfter filter.
	//
	// aws ssm list-commands --filters key=InvokedAfter,value=2017-06-07T00:00:00Z
	//
	// If the plugin has not started to execute, the string is empty.
	ExecutionEndDateTime *string `type:"string"`

	// The date and time the plugin started executing. Date and time are written
	// in ISO 8601 format. For example, June 7, 2017 is represented as 2017-06-7.
	// The following sample AWS CLI command uses the InvokedBefore filter.
	//
	// aws ssm list-commands --filters key=InvokedBefore,value=2017-06-07T00:00:00Z
	//
	// If the plugin has not started to execute, the string is empty.
	ExecutionStartDateTime *string `type:"string"`

	// The ID of the managed instance targeted by the command. A managed instance
	// can be an Amazon EC2 instance or an instance in your hybrid environment that
	// is configured for Systems Manager.
	InstanceId *string `type:"string"`

	// The name of the plugin for which you want detailed results. For example,
	// aws:RunShellScript is a plugin.
	PluginName *string `min:"4" type:"string"`

	// The error level response code for the plugin script. If the response code
	// is -1, then the command has not started executing on the instance, or it
	// was not received by the instance.
	ResponseCode *int64 `type:"integer"`

	// The first 8,000 characters written by the plugin to stderr. If the command
	// has not finished executing, then this string is empty.
	StandardErrorContent *string `type:"string"`

	// The URL for the complete text written by the plugin to stderr. If the command
	// has not finished executing, then this string is empty.
	StandardErrorUrl *string `type:"string"`

	// The first 24,000 characters written by the plugin to stdout. If the command
	// has not finished executing, if ExecutionStatus is neither Succeeded nor Failed,
	// then this string is empty.
	StandardOutputContent *string `type:"string"`

	// The URL for the complete text written by the plugin to stdout in Amazon S3.
	// If an Amazon S3 bucket was not specified, then this string is empty.
	StandardOutputUrl *string `type:"string"`

	// The status of this invocation plugin. This status can be different than StatusDetails.
	Status *string `type:"string" enum:"CommandInvocationStatus"`

	// A detailed status of the command execution for an invocation. StatusDetails
	// includes more information than Status because it includes states resulting
	// from error and concurrency control parameters. StatusDetails can show different
	// results than Status. For more information about these statuses, see Understanding
	// Command Statuses (http://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html)
	// in the AWS Systems Manager User Guide. StatusDetails can be one of the following
	// values:
	//
	//    * Pending: The command has not been sent to the instance.
	//
	//    * In Progress: The command has been sent to the instance but has not reached
	//    a terminal state.
	//
	//    * Delayed: The system attempted to send the command to the target, but
	//    the target was not available. The instance might not be available because
	//    of network issues, the instance was stopped, etc. The system will try
	//    to deliver the command again.
	//
	//    * Success: The command or plugin was executed successfully. This is a
	//    terminal state.
	//
	//    * Delivery Timed Out: The command was not delivered to the instance before
	//    the delivery timeout expired. Delivery timeouts do not count against the
	//    parent command's MaxErrors limit, but they do contribute to whether the
	//    parent command status is Success or Incomplete. This is a terminal state.
	//
	//    * Execution Timed Out: The command started to execute on the instance,
	//    but the execution was not complete before the timeout expired. Execution
	//    timeouts count against the MaxErrors limit of the parent command. This
	//    is a terminal state.
	//
	//    * Failed: The command wasn't executed successfully on the instance. For
	//    a plugin, this indicates that the result code was not zero. For a command
	//    invocation, this indicates that the result code for one or more plugins
	//    was not zero. Invocation failures count against the MaxErrors limit of
	//    the parent command. This is a terminal state.
	//
	//    * Canceled: The command was terminated before it was completed. This is
	//    a terminal state.
	//
	//    * Undeliverable: The command can't be delivered to the instance. The instance
	//    might not exist or might not be responding. Undeliverable invocations
	//    don't count against the parent command's MaxErrors limit and don't contribute
	//    to whether the parent command status is Success or Incomplete. This is
	//    a terminal state.
	//
	//    * Terminated: The parent command exceeded its MaxErrors limit and subsequent
	//    command invocations were canceled by the system. This is a terminal state.
	StatusDetails *string `type:"string"`
}

// String returns the string representation
func (s GetCommandInvocationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCommandInvocationOutput) GoString() string {
	return s.String()
}

// SetCloudWatchOutputConfig sets the CloudWatchOutputConfig field's value.
func (s *GetCommandInvocationOutput) SetCloudWatchOutputConfig(v *CloudWatchOutputConfig) *GetCommandInvocationOutput {
	s.CloudWatchOutputConfig = v
	return s
}

// SetCommandId sets the CommandId field's value.
func (s *GetCommandInvocationOutput) SetCommandId(v string) *GetCommandInvocationOutput {
	s.CommandId = &v
	return s
}

// SetComment sets the Comment field's value.
func (s *GetCommandInvocationOutput) SetComment(v string) *GetCommandInvocationOutput {
	s.Comment = &v
	return s
}

// SetDocumentName sets the DocumentName field's value.
func (s *GetCommandInvocationOutput) SetDocumentName(v string) *GetCommandInvocationOutput {
	s.DocumentName = &v
	return s
}

// SetDocumentVersion sets the DocumentVersion field's value.
func (s *GetCommandInvocationOutput) SetDocumentVersion(v string) *GetCommandInvocationOutput {
	s.DocumentVersion = &v
	return s
}

// SetExecutionElapsedTime sets the ExecutionElapsedTime field's value.
func (s *GetCommandInvocationOutput) SetExecutionElapsedTime(v string) *GetCommandInvocationOutput {
	s.ExecutionElapsedTime = &v
	return s
}

// SetExecutionEndDateTime sets the ExecutionEndDateTime field's value.
func (s *GetCommandInvocationOutput) SetExecutionEndDateTime(v string) *GetCommandInvocationOutput {
	s.ExecutionEndDateTime = &v
	return s
}

// SetExecutionStartDateTime sets the ExecutionStartDateTime field's value.
func (s *GetCommandInvocationOutput) SetExecutionStartDateTime(v string) *GetCommandInvocationOutput {
	s.ExecutionStartDateTime = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *GetCommandInvocationOutput) SetInstanceId(v string) *GetCommandInvocationOutput {
	s.InstanceId = &v
	return s
}

// SetPluginName sets the PluginName field's value.
func (s *GetCommandInvocationOutput) SetPluginName(v string) *GetCommandInvocationOutput {
	s.PluginName = &v
	return s
}

// SetResponseCode sets the ResponseCode field's value.
func (s *GetCommandInvocationOutput) SetResponseCode(v int64) *GetCommandInvocationOutput {
	s.ResponseCode = &v
	return s
}

// SetStandardErrorContent sets the StandardErrorContent field's value.
func (s *GetCommandInvocationOutput) SetStandardErrorContent(v string) *GetCommandInvocationOutput {
	s.StandardErrorContent = &v
	return s
}

// SetStandardErrorUrl sets the StandardErrorUrl field's value.
func (s *GetCommandInvocationOutput) SetStandardErrorUrl(v string) *GetCommandInvocationOutput {
	s.StandardErrorUrl = &v
	return s
}

// SetStandardOutputContent sets the StandardOutputContent field's value.
func (s *GetCommandInvocationOutput) SetStandardOutputContent(v string) *GetCommandInvocationOutput {
	s.StandardOutputContent = &v
	return s
}

// SetStandardOutputUrl sets the StandardOutputUrl field's value.
func (s *GetCommandInvocationOutput) SetStandardOutputUrl(v string) *GetCommandInvocationOutput {
	s.StandardOutputUrl = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetCommandInvocationOutput) SetStatus(v string) *GetCommandInvocationOutput {
	s.Status = &v
	return s
}

// SetStatusDetails sets the StatusDetails field's value.
func (s *GetCommandInvocationOutput) SetStatusDetails(v string) *GetCommandInvocationOutput {
	s.StatusDetails = &v
	return s
}

type GetConnectionStatusInput struct {
	_ struct{} `type:"structure"`

	// The ID of the instance.
	//
	// Target is a required field
	Target *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetConnectionStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConnectionStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetConnectionStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetConnectionStatusInput"}
	if s.Target == nil {
		invalidParams.Add(request.NewErrParamRequired("Target"))
	}
	if s.Target != nil && len(*s.Target) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Target", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTarget sets the Target field's value.
func (s *GetConnectionStatusInput) SetTarget(v string) *GetConnectionStatusInput {
	s.Target = &v
	return s
}

type GetConnectionStatusOutput struct {
	_ struct{} `type:"structure"`

	// The status of the connection to the instance. For example, 'Connected' or
	// 'Not Connected'.
	Status *string `type:"string" enum:"ConnectionStatus"`

	// The ID of the instance to check connection status.
	Target *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetConnectionStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConnectionStatusOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *GetConnectionStatusOutput) SetStatus(v string) *GetConnectionStatusOutput {
	s.Status = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *GetConnectionStatusOutput) SetTarget(v string) *GetConnectionStatusOutput {
	s.Target = &v
	return s
}

type GetDefaultPatchBaselineInput struct {
	_ struct{} `type:"structure"`

	// Returns the default patch baseline for the specified operating system.
	OperatingSystem *string `type:"string" enum:"OperatingSystem"`
}

// String returns the string representation
func (s GetDefaultPatchBaselineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDefaultPatchBaselineInput) GoString() string {
	return s.String()
}

// SetOperatingSystem sets the OperatingSystem field's value.
func (s *GetDefaultPatchBaselineInput) SetOperatingSystem(v string) *GetDefaultPatchBaselineInput {
	s.OperatingSystem = &v
	return s
}

type GetDefaultPatchBaselineOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the default patch baseline.
	BaselineId *string `min:"20" type:"string"`

	// The operating system for the returned patch baseline.
	OperatingSystem *string `type:"string" enum:"OperatingSystem"`
}

// String returns the string representation
func (s GetDefaultPatchBaselineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDefaultPatchBaselineOutput) GoString() string {
	return s.String()
}

// SetBaselineId sets the BaselineId field's value.
func (s *GetDefaultPatchBaselineOutput) SetBaselineId(v string) *GetDefaultPatchBaselineOutput {
	s.BaselineId = &v
	return s
}

// SetOperatingSystem sets the OperatingSystem field's value.
func (s *GetDefaultPatchBaselineOutput) SetOperatingSystem(v string) *GetDefaultPatchBaselineOutput {
	s.OperatingSystem = &v
	return s
}

type GetDeployablePatchSnapshotForInstanceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the instance for which the appropriate patch snapshot should be
	// retrieved.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	// The user-defined snapshot ID.
	//
	// SnapshotId is a required field
	SnapshotId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDeployablePatchSnapshotForInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeployablePatchSnapshotForInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeployablePatchSnapshotForInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeployablePatchSnapshotForInstanceInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.SnapshotId == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotId"))
	}
	if s.SnapshotId != nil && len(*s.SnapshotId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("SnapshotId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *GetDeployablePatchSnapshotForInstanceInput) SetInstanceId(v string) *GetDeployablePatchSnapshotForInstanceInput {
	s.InstanceId = &v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *GetDeployablePatchSnapshotForInstanceInput) SetSnapshotId(v string) *GetDeployablePatchSnapshotForInstanceInput {
	s.SnapshotId = &v
	return s
}

type GetDeployablePatchSnapshotForInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the instance.
	InstanceId *string `type:"string"`

	// Returns the specific operating system (for example Windows Server 2012 or
	// Amazon Linux 2015.09) on the instance for the specified patch snapshot.
	Product *string `type:"string"`

	// A pre-signed Amazon S3 URL that can be used to download the patch snapshot.
	SnapshotDownloadUrl *string `type:"string"`

	// The user-defined snapshot ID.
	SnapshotId *string `min:"36" type:"string"`
}

// String returns the string representation
func (s GetDeployablePatchSnapshotForInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeployablePatchSnapshotForInstanceOutput) GoString() string {
	return s.String()
}

// SetInstanceId sets the InstanceId field's value.
func (s *GetDeployablePatchSnapshotForInstanceOutput) SetInstanceId(v string) *GetDeployablePatchSnapshotForInstanceOutput {
	s.InstanceId = &v
	return s
}

// SetProduct sets the Product field's value.
func (s *GetDeployablePatchSnapshotForInstanceOutput) SetProduct(v string) *GetDeployablePatchSnapshotForInstanceOutput {
	s.Product = &v
	return s
}

// SetSnapshotDownloadUrl sets the SnapshotDownloadUrl field's value.
func (s *GetDeployablePatchSnapshotForInstanceOutput) SetSnapshotDownloadUrl(v string) *GetDeployablePatchSnapshotForInstanceOutput {
	s.SnapshotDownloadUrl = &v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *GetDeployablePatchSnapshotForInstanceOutput) SetSnapshotId(v string) *GetDeployablePatchSnapshotForInstanceOutput {
	s.SnapshotId = &v
	return s
}

type GetDocumentInput struct {
	_ struct{} `type:"structure"`

	// Returns the document in the specified format. The document format can be
	// either JSON or YAML. JSON is the default format.
	DocumentFormat *string `type:"string" enum:"DocumentFormat"`

	// The document version for which you want information.
	DocumentVersion *string `type:"string"`

	// The name of the Systems Manager document.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// An optional field specifying the version of the artifact associated with
	// the document. For example, "Release 12, Update 6". This value is unique across
	// all versions of a document, and cannot be changed.
	VersionName *string `type:"string"`
}

// String returns the string representation
func (s GetDocumentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDocumentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDocumentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDocumentInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocumentFormat sets the DocumentFormat field's value.
func (s *GetDocumentInput) SetDocumentFormat(v string) *GetDocumentInput {
	s.DocumentFormat = &v
	return s
}

// SetDocumentVersion sets the DocumentVersion field's value.
func (s *GetDocumentInput) SetDocumentVersion(v string) *GetDocumentInput {
	s.DocumentVersion = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetDocumentInput) SetName(v string) *GetDocumentInput {
	s.Name = &v
	return s
}

// SetVersionName sets the VersionName field's value.
func (s *GetDocumentInput) SetVersionName(v string) *GetDocumentInput {
	s.VersionName = &v
	return s
}

type GetDocumentOutput struct {
	_ struct{} `type:"structure"`

	// A description of the document attachments, including names, locations, sizes,
	// etc.
	AttachmentsContent []*AttachmentContent `type:"list"`

	// The contents of the Systems Manager document.
	Content *string `min:"1" type:"string"`

	// The document format, either JSON or YAML.
	DocumentFormat *string `type:"string" enum:"DocumentFormat"`

	// The document type.
	DocumentType *string `type:"string" enum:"DocumentType"`

	// The document version.
	DocumentVersion *string `type:"string"`

	// The name of the Systems Manager document.
	Name *string `type:"string"`

	// The status of the Systems Manager document, such as Creating, Active, Updating,
	// Failed, and Deleting.
	Status *string `type:"string" enum:"DocumentStatus"`

	// A message returned by AWS Systems Manager that explains the Status value.
	// For example, a Failed status might be explained by the StatusInformation
	// message, "The specified S3 bucket does not exist. Verify that the URL of
	// the S3 bucket is correct."
	StatusInformation *string `type:"string"`

	// The version of the artifact associated with the document. For example, "Release
	// 12, Update 6". This value is unique across all versions of a document, and
	// cannot be changed.
	VersionName *string `type:"string"`
}

// String returns the string representation
func (s GetDocumentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDocumentOutput) GoString() string {
	return s.String()
}

// SetAttachmentsContent sets the AttachmentsContent field's value.
func (s *GetDocumentOutput) SetAttachmentsContent(v []*AttachmentContent) *GetDocumentOutput {
	s.AttachmentsContent = v
	return s
}

// SetContent sets the Content field's value.
func (s *GetDocumentOutput) SetContent(v string) *GetDocumentOutput {
	s.Content = &v
	return s
}

// SetDocumentFormat sets the DocumentFormat field's value.
func (s *GetDocumentOutput) SetDocumentFormat(v string) *GetDocumentOutput {
	s.DocumentFormat = &v
	return s
}

// SetDocumentType sets the DocumentType field's value.
func (s *GetDocumentOutput) SetDocumentType(v string) *GetDocumentOutput {
	s.DocumentType = &v
	return s
}

// SetDocumentVersion sets the DocumentVersion field's value.
func (s *GetDocumentOutput) SetDocumentVersion(v string) *GetDocumentOutput {
	s.DocumentVersion = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetDocumentOutput) SetName(v string) *GetDocumentOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetDocumentOutput) SetStatus(v string) *GetDocumentOutput {
	s.Status = &v
	return s
}

// SetStatusInformation sets the StatusInformation field's value.
func (s *GetDocumentOutput) SetStatusInformation(v string) *GetDocumentOutput {
	s.StatusInformation = &v
	return s
}

// SetVersionName sets the VersionName field's value.
func (s *GetDocumentOutput) SetVersionName(v string) *GetDocumentOutput {
	s.VersionName = &v
	return s
}

type GetInventoryInput struct {
	_ struct{} `type:"structure"`

	// Returns counts of inventory types based on one or more expressions. For example,
	// if you aggregate by using an expression that uses the AWS:InstanceInformation.PlatformType
	// type, you can see a count of how many Windows and Linux instances exist in
	// your inventoried fleet.
	Aggregators []*InventoryAggregator `min:"1" type:"list"`

	// One or more filters. Use a filter to return a more specific list of results.
	Filters []*InventoryFilter `min:"1" type:"list"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	// The list of inventory item types to return.
	ResultAttributes []*ResultAttribute `min:"1" type:"list"`
}

// String returns the string representation
func (s GetInventoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInventoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInventoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInventoryInput"}
	if s.Aggregators != nil && len(s.Aggregators) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Aggregators", 1))
	}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResultAttributes != nil && len(s.ResultAttributes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResultAttributes", 1))
	}
	if s.Aggregators != nil {
		for i, v := range s.Aggregators {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Aggregators", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ResultAttributes != nil {
		for i, v := range s.ResultAttributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResultAttributes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAggregators sets the Aggregators field's value.
func (s *GetInventoryInput) SetAggregators(v []*InventoryAggregator) *GetInventoryInput {
	s.Aggregators = v
	return s
}

// SetFilters sets the Filters field's value.
func (s *GetInventoryInput) SetFilters(v []*InventoryFilter) *GetInventoryInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetInventoryInput) SetMaxResults(v int64) *GetInventoryInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetInventoryInput) SetNextToken(v string) *GetInventoryInput {
	s.NextToken = &v
	return s
}

// SetResultAttributes sets the ResultAttributes field's value.
func (s *GetInventoryInput) SetResultAttributes(v []*ResultAttribute) *GetInventoryInput {
	s.ResultAttributes = v
	return s
}

type GetInventoryOutput struct {
	_ struct{} `type:"structure"`

	// Collection of inventory entities such as a collection of instance inventory.
	Entities []*InventoryResultEntity `type:"list"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetInventoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInventoryOutput) GoString() string {
	return s.String()
}

// SetEntities sets the Entities field's value.
func (s *GetInventoryOutput) SetEntities(v []*InventoryResultEntity) *GetInventoryOutput {
	s.Entities = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetInventoryOutput) SetNextToken(v string) *GetInventoryOutput {
	s.NextToken = &v
	return s
}

type GetInventorySchemaInput struct {
	_ struct{} `type:"structure"`

	// Returns inventory schemas that support aggregation. For example, this call
	// returns the AWS:InstanceInformation type, because it supports aggregation
	// based on the PlatformName, PlatformType, and PlatformVersion attributes.
	Aggregator *bool `type:"boolean"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"50" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	// Returns the sub-type schema for a specified inventory type.
	SubType *bool `type:"boolean"`

	// The type of inventory item to return.
	TypeName *string `type:"string"`
}

// String returns the string representation
func (s GetInventorySchemaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInventorySchemaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInventorySchemaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInventorySchemaInput"}
	if s.MaxResults != nil && *s.MaxResults < 50 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAggregator sets the Aggregator field's value.
func (s *GetInventorySchemaInput) SetAggregator(v bool) *GetInventorySchemaInput {
	s.Aggregator = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetInventorySchemaInput) SetMaxResults(v int64) *GetInventorySchemaInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetInventorySchemaInput) SetNextToken(v string) *GetInventorySchemaInput {
	s.NextToken = &v
	return s
}

// SetSubType sets the SubType field's value.
func (s *GetInventorySchemaInput) SetSubType(v bool) *GetInventorySchemaInput {
	s.SubType = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *GetInventorySchemaInput) SetTypeName(v string) *GetInventorySchemaInput {
	s.TypeName = &v
	return s
}

type GetInventorySchemaOutput struct {
	_ struct{} `type:"structure"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`

	// Inventory schemas returned by the request.
	Schemas []*InventoryItemSchema `type:"list"`
}

// String returns the string representation
func (s GetInventorySchemaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInventorySchemaOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetInventorySchemaOutput) SetNextToken(v string) *GetInventorySchemaOutput {
	s.NextToken = &v
	return s
}

// SetSchemas sets the Schemas field's value.
func (s *GetInventorySchemaOutput) SetSchemas(v []*InventoryItemSchema) *GetInventorySchemaOutput {
	s.Schemas = v
	return s
}

type GetMaintenanceWindowExecutionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Maintenance Window execution that includes the task.
	//
	// WindowExecutionId is a required field
	WindowExecutionId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s GetMaintenanceWindowExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMaintenanceWindowExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMaintenanceWindowExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMaintenanceWindowExecutionInput"}
	if s.WindowExecutionId == nil {
		invalidParams.Add(request.NewErrParamRequired("WindowExecutionId"))
	}
	if s.WindowExecutionId != nil && len(*s.WindowExecutionId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("WindowExecutionId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWindowExecutionId sets the WindowExecutionId field's value.
func (s *GetMaintenanceWindowExecutionInput) SetWindowExecutionId(v string) *GetMaintenanceWindowExecutionInput {
	s.WindowExecutionId = &v
	return s
}

type GetMaintenanceWindowExecutionOutput struct {
	_ struct{} `type:"structure"`

	// The time the Maintenance Window finished executing.
	EndTime *time.Time `type:"timestamp"`

	// The time the Maintenance Window started executing.
	StartTime *time.Time `type:"timestamp"`

	// The status of the Maintenance Window execution.
	Status *string `type:"string" enum:"MaintenanceWindowExecutionStatus"`

	// The details explaining the Status. Only available for certain status values.
	StatusDetails *string `type:"string"`

	// The ID of the task executions from the Maintenance Window execution.
	TaskIds []*string `type:"list"`

	// The ID of the Maintenance Window execution.
	WindowExecutionId *string `min:"36" type:"string"`
}

// String returns the string representation
func (s GetMaintenanceWindowExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMaintenanceWindowExecutionOutput) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *GetMaintenanceWindowExecutionOutput) SetEndTime(v time.Time) *GetMaintenanceWindowExecutionOutput {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetMaintenanceWindowExecutionOutput) SetStartTime(v time.Time) *GetMaintenanceWindowExecutionOutput {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetMaintenanceWindowExecutionOutput) SetStatus(v string) *GetMaintenanceWindowExecutionOutput {
	s.Status = &v
	return s
}

// SetStatusDetails sets the StatusDetails field's value.
func (s *GetMaintenanceWindowExecutionOutput) SetStatusDetails(v string) *GetMaintenanceWindowExecutionOutput {
	s.StatusDetails = &v
	return s
}

// SetTaskIds sets the TaskIds field's value.
func (s *GetMaintenanceWindowExecutionOutput) SetTaskIds(v []*string) *GetMaintenanceWindowExecutionOutput {
	s.TaskIds = v
	return s
}

// SetWindowExecutionId sets the WindowExecutionId field's value.
func (s *GetMaintenanceWindowExecutionOutput) SetWindowExecutionId(v string) *GetMaintenanceWindowExecutionOutput {
	s.WindowExecutionId = &v
	return s
}

type GetMaintenanceWindowExecutionTaskInput struct {
	_ struct{} `type:"structure"`

	// The ID of the specific task execution in the Maintenance Window task that
	// should be retrieved.
	//
	// TaskId is a required field
	TaskId *string `min:"36" type:"string" required:"true"`

	// The ID of the Maintenance Window execution that includes the task.
	//
	// WindowExecutionId is a required field
	WindowExecutionId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s GetMaintenanceWindowExecutionTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMaintenanceWindowExecutionTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMaintenanceWindowExecutionTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMaintenanceWindowExecutionTaskInput"}
	if s.TaskId == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskId"))
	}
	if s.TaskId != nil && len(*s.TaskId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("TaskId", 36))
	}
	if s.WindowExecutionId == nil {
		invalidParams.Add(request.NewErrParamRequired("WindowExecutionId"))
	}
	if s.WindowExecutionId != nil && len(*s.WindowExecutionId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("WindowExecutionId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTaskId sets the TaskId field's value.
func (s *GetMaintenanceWindowExecutionTaskInput) SetTaskId(v string) *GetMaintenanceWindowExecutionTaskInput {
	s.TaskId = &v
	return s
}

// SetWindowExecutionId sets the WindowExecutionId field's value.
func (s *GetMaintenanceWindowExecutionTaskInput) SetWindowExecutionId(v string) *GetMaintenanceWindowExecutionTaskInput {
	s.WindowExecutionId = &v
	return s
}

type GetMaintenanceWindowExecutionTaskInvocationInput struct {
	_ struct{} `type:"structure"`

	// The invocation ID to retrieve.
	//
	// InvocationId is a required field
	InvocationId *string `min:"36" type:"string" required:"true"`

	// The ID of the specific task in the Maintenance Window task that should be
	// retrieved.
	//
	// TaskId is a required field
	TaskId *string `min:"36" type:"string" required:"true"`

	// The ID of the Maintenance Window execution for which the task is a part.
	//
	// WindowExecutionId is a required field
	WindowExecutionId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s GetMaintenanceWindowExecutionTaskInvocationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMaintenanceWindowExecutionTaskInvocationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMaintenanceWindowExecutionTaskInvocationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMaintenanceWindowExecutionTaskInvocationInput"}
	if s.InvocationId == nil {
		invalidParams.Add(request.NewErrParamRequired("InvocationId"))
	}
	if s.InvocationId != nil && len(*s.InvocationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("InvocationId", 36))
	}
	if s.TaskId == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskId"))
	}
	if s.TaskId != nil && len(*s.TaskId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("TaskId", 36))
	}
	if s.WindowExecutionId == nil {
		invalidParams.Add(request.NewErrParamRequired("WindowExecutionId"))
	}
	if s.WindowExecutionId != nil && len(*s.WindowExecutionId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("WindowExecutionId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInvocationId sets the InvocationId field's value.
func (s *GetMaintenanceWindowExecutionTaskInvocationInput) SetInvocationId(v string) *GetMaintenanceWindowExecutionTaskInvocationInput {
	s.InvocationId = &v
	return s
}

// SetTaskId sets the TaskId field's value.
func (s *GetMaintenanceWindowExecutionTaskInvocationInput) SetTaskId(v string) *GetMaintenanceWindowExecutionTaskInvocationInput {
	s.TaskId = &v
	return s
}

// SetWindowExecutionId sets the WindowExecutionId field's value.
func (s *GetMaintenanceWindowExecutionTaskInvocationInput) SetWindowExecutionId(v string) *GetMaintenanceWindowExecutionTaskInvocationInput {
	s.WindowExecutionId = &v
	return s
}

type GetMaintenanceWindowExecutionTaskInvocationOutput struct {
	_ struct{} `type:"structure"`

	// The time that the task finished executing on the target.
	EndTime *time.Time `type:"timestamp"`

	// The execution ID.
	ExecutionId *string `type:"string"`

	// The invocation ID.
	InvocationId *string `min:"36" type:"string"`

	// User-provided value to be included in any CloudWatch events raised while
	// running tasks for these targets in this Maintenance Window.
	OwnerInformation *string `min:"1" type:"string" sensitive:"true"`

	// The parameters used at the time that the task executed.
	Parameters *string `type:"string" sensitive:"true"`

	// The time that the task started executing on the target.
	StartTime *time.Time `type:"timestamp"`

	// The task status for an invocation.
	Status *string `type:"string" enum:"MaintenanceWindowExecutionStatus"`

	// The details explaining the status. Details are only available for certain
	// status values.
	StatusDetails *string `type:"string"`

	// The task execution ID.
	TaskExecutionId *string `min:"36" type:"string"`

	// Retrieves the task type for a Maintenance Window. Task types include the
	// following: LAMBDA, STEP_FUNCTION, AUTOMATION, RUN_COMMAND.
	TaskType *string `type:"string" enum:"MaintenanceWindowTaskType"`

	// The Maintenance Window execution ID.
	WindowExecutionId *string `min:"36" type:"string"`

	// The Maintenance Window target ID.
	WindowTargetId *string `type:"string"`
}

// String returns the string representation
func (s GetMaintenanceWindowExecutionTaskInvocationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMaintenanceWindowExecutionTaskInvocationOutput) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *GetMaintenanceWindowExecutionTaskInvocationOutput) SetEndTime(v time.Time) *GetMaintenanceWindowExecutionTaskInvocationOutput {
	s.EndTime = &v
	return s
}

// SetExecutionId sets the ExecutionId field's value.
func (s *GetMaintenanceWindowExecutionTaskInvocationOutput) SetExecutionId(v string) *GetMaintenanceWindowExecutionTaskInvocationOutput {
	s.ExecutionId = &v
	return s
}

// SetInvocationId sets the InvocationId field's value.
func (s *GetMaintenanceWindowExecutionTaskInvocationOutput) SetInvocationId(v string) *GetMaintenanceWindowExecutionTaskInvocationOutput {
	s.InvocationId = &v
	return s
}

// SetOwnerInformation sets the OwnerInformation field's value.
func (s *GetMaintenanceWindowExecutionTaskInvocationOutput) SetOwnerInformation(v string) *GetMaintenanceWindowExecutionTaskInvocationOutput {
	s.OwnerInformation = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *GetMaintenanceWindowExecutionTaskInvocationOutput) SetParameters(v string) *GetMaintenanceWindowExecutionTaskInvocationOutput {
	s.Parameters = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetMaintenanceWindowExecutionTaskInvocationOutput) SetStartTime(v time.Time) *GetMaintenanceWindowExecutionTaskInvocationOutput {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetMaintenanceWindowExecutionTaskInvocationOutput) SetStatus(v string) *GetMaintenanceWindowExecutionTaskInvocationOutput {
	s.Status = &v
	return s
}

// SetStatusDetails sets the StatusDetails field's value.
func (s *GetMaintenanceWindowExecutionTaskInvocationOutput) SetStatusDetails(v string) *GetMaintenanceWindowExecutionTaskInvocationOutput {
	s.StatusDetails = &v
	return s
}

// SetTaskExecutionId sets the TaskExecutionId field's value.
func (s *GetMaintenanceWindowExecutionTaskInvocationOutput) SetTaskExecutionId(v string) *GetMaintenanceWindowExecutionTaskInvocationOutput {
	s.TaskExecutionId = &v
	return s
}

// SetTaskType sets the TaskType field's value.
func (s *GetMaintenanceWindowExecutionTaskInvocationOutput) SetTaskType(v string) *GetMaintenanceWindowExecutionTaskInvocationOutput {
	s.TaskType = &v
	return s
}

// SetWindowExecutionId sets the WindowExecutionId field's value.
func (s *GetMaintenanceWindowExecutionTaskInvocationOutput) SetWindowExecutionId(v string) *GetMaintenanceWindowExecutionTaskInvocationOutput {
	s.WindowExecutionId = &v
	return s
}

// SetWindowTargetId sets the WindowTargetId field's value.
func (s *GetMaintenanceWindowExecutionTaskInvocationOutput) SetWindowTargetId(v string) *GetMaintenanceWindowExecutionTaskInvocationOutput {
	s.WindowTargetId = &v
	return s
}

type GetMaintenanceWindowExecutionTaskOutput struct {
	_ struct{} `type:"structure"`

	// The time the task execution completed.
	EndTime *time.Time `type:"timestamp"`

	// The defined maximum number of task executions that could be run in parallel.
	MaxConcurrency *string `min:"1" type:"string"`

	// The defined maximum number of task execution errors allowed before scheduling
	// of the task execution would have been stopped.
	MaxErrors *string `min:"1" type:"string"`

	// The priority of the task.
	Priority *int64 `type:"integer"`

	// The role that was assumed when executing the task.
	ServiceRole *string `type:"string"`

	// The time the task execution started.
	StartTime *time.Time `type:"timestamp"`

	// The status of the task.
	Status *string `type:"string" enum:"MaintenanceWindowExecutionStatus"`

	// The details explaining the Status. Only available for certain status values.
	StatusDetails *string `type:"string"`

	// The ARN of the executed task.
	TaskArn *string `min:"1" type:"string"`

	// The ID of the specific task execution in the Maintenance Window task that
	// was retrieved.
	TaskExecutionId *string `min:"36" type:"string"`

	// The parameters passed to the task when it was executed.
	//
	// TaskParameters has been deprecated. To specify parameters to pass to a task
	// when it runs, instead use the Parameters option in the TaskInvocationParameters
	// structure. For information about how Systems Manager handles these options
	// for the supported Maintenance Window task types, see MaintenanceWindowTaskInvocationParameters.
	//
	// The map has the following format:
	//
	// Key: string, between 1 and 255 characters
	//
	// Value: an array of strings, each string is between 1 and 255 characters
	TaskParameters []map[string]*MaintenanceWindowTaskParameterValueExpression `type:"list" sensitive:"true"`

	// The type of task executed.
	Type *string `type:"string" enum:"MaintenanceWindowTaskType"`

	// The ID of the Maintenance Window execution that includes the task.
	WindowExecutionId *string `min:"36" type:"string"`
}

// String returns the string representation
func (s GetMaintenanceWindowExecutionTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMaintenanceWindowExecutionTaskOutput) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *GetMaintenanceWindowExecutionTaskOutput) SetEndTime(v time.Time) *GetMaintenanceWindowExecutionTaskOutput {
	s.EndTime = &v
	return s
}

// SetMaxConcurrency sets the MaxConcurrency field's value.
func (s *GetMaintenanceWindowExecutionTaskOutput) SetMaxConcurrency(v string) *GetMaintenanceWindowExecutionTaskOutput {
	s.MaxConcurrency = &v
	return s
}

// SetMaxErrors sets the MaxErrors field's value.
func (s *GetMaintenanceWindowExecutionTaskOutput) SetMaxErrors(v string) *GetMaintenanceWindowExecutionTaskOutput {
	s.MaxErrors = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *GetMaintenanceWindowExecutionTaskOutput) SetPriority(v int64) *GetMaintenanceWindowExecutionTaskOutput {
	s.Priority = &v
	return s
}

// SetServiceRole sets the ServiceRole field's value.
func (s *GetMaintenanceWindowExecutionTaskOutput) SetServiceRole(v string) *GetMaintenanceWindowExecutionTaskOutput {
	s.ServiceRole = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetMaintenanceWindowExecutionTaskOutput) SetStartTime(v time.Time) *GetMaintenanceWindowExecutionTaskOutput {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetMaintenanceWindowExecutionTaskOutput) SetStatus(v string) *GetMaintenanceWindowExecutionTaskOutput {
	s.Status = &v
	return s
}

// SetStatusDetails sets the StatusDetails field's value.
func (s *GetMaintenanceWindowExecutionTaskOutput) SetStatusDetails(v string) *GetMaintenanceWindowExecutionTaskOutput {
	s.StatusDetails = &v
	return s
}

// SetTaskArn sets the TaskArn field's value.
func (s *GetMaintenanceWindowExecutionTaskOutput) SetTaskArn(v string) *GetMaintenanceWindowExecutionTaskOutput {
	s.TaskArn = &v
	return s
}

// SetTaskExecutionId sets the TaskExecutionId field's value.
func (s *GetMaintenanceWindowExecutionTaskOutput) SetTaskExecutionId(v string) *GetMaintenanceWindowExecutionTaskOutput {
	s.TaskExecutionId = &v
	return s
}

// SetTaskParameters sets the TaskParameters field's value.
func (s *GetMaintenanceWindowExecutionTaskOutput) SetTaskParameters(v []map[string]*MaintenanceWindowTaskParameterValueExpression) *GetMaintenanceWindowExecutionTaskOutput {
	s.TaskParameters = v
	return s
}

// SetType sets the Type field's value.
func (s *GetMaintenanceWindowExecutionTaskOutput) SetType(v string) *GetMaintenanceWindowExecutionTaskOutput {
	s.Type = &v
	return s
}

// SetWindowExecutionId sets the WindowExecutionId field's value.
func (s *GetMaintenanceWindowExecutionTaskOutput) SetWindowExecutionId(v string) *GetMaintenanceWindowExecutionTaskOutput {
	s.WindowExecutionId = &v
	return s
}

type GetMaintenanceWindowInput struct {
	_ struct{} `type:"structure"`

	// The ID of the desired Maintenance Window.
	//
	// WindowId is a required field
	WindowId *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s GetMaintenanceWindowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMaintenanceWindowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMaintenanceWindowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMaintenanceWindowInput"}
	if s.WindowId == nil {
		invalidParams.Add(request.NewErrParamRequired("WindowId"))
	}
	if s.WindowId != nil && len(*s.WindowId) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("WindowId", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWindowId sets the WindowId field's value.
func (s *GetMaintenanceWindowInput) SetWindowId(v string) *GetMaintenanceWindowInput {
	s.WindowId = &v
	return s
}

type GetMaintenanceWindowOutput struct {
	_ struct{} `type:"structure"`

	// Whether targets must be registered with the Maintenance Window before tasks
	// can be defined for those targets.
	AllowUnassociatedTargets *bool `type:"boolean"`

	// The date the Maintenance Window was created.
	CreatedDate *time.Time `type:"timestamp"`

	// The number of hours before the end of the Maintenance Window that Systems
	// Manager stops scheduling new tasks for execution.
	Cutoff *int64 `type:"integer"`

	// The description of the Maintenance Window.
	Description *string `min:"1" type:"string" sensitive:"true"`

	// The duration of the Maintenance Window in hours.
	Duration *int64 `min:"1" type:"integer"`

	// Whether the Maintenance Windows is enabled.
	Enabled *bool `type:"boolean"`

	// The date and time, in ISO-8601 Extended format, for when the Maintenance
	// Window is scheduled to become inactive. The Maintenance Window will not run
	// after this specified time.
	EndDate *string `type:"string"`

	// The date the Maintenance Window was last modified.
	ModifiedDate *time.Time `type:"timestamp"`

	// The name of the Maintenance Window.
	Name *string `min:"3" type:"string"`

	// The next time the Maintenance Window will actually run, taking into account
	// any specified times for the Maintenance Window to become active or inactive.
	NextExecutionTime *string `type:"string"`

	// The schedule of the Maintenance Window in the form of a cron or rate expression.
	Schedule *string `min:"1" type:"string"`

	// The time zone that the scheduled Maintenance Window executions are based
	// on, in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles",
	// "etc/UTC", or "Asia/Seoul". For more information, see the Time Zone Database
	// (https://www.iana.org/time-zones) on the IANA website.
	ScheduleTimezone *string `type:"string"`

	// The date and time, in ISO-8601 Extended format, for when the Maintenance
	// Window is scheduled to become active. The Maintenance Window will not run
	// before this specified time.
	StartDate *string `type:"string"`

	// The ID of the created Maintenance Window.
	WindowId *string `min:"20" type:"string"`
}

// String returns the string representation
func (s GetMaintenanceWindowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMaintenanceWindowOutput) GoString() string {
	return s.String()
}

// SetAllowUnassociatedTargets sets the AllowUnassociatedTargets field's value.
func (s *GetMaintenanceWindowOutput) SetAllowUnassociatedTargets(v bool) *GetMaintenanceWindowOutput {
	s.AllowUnassociatedTargets = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *GetMaintenanceWindowOutput) SetCreatedDate(v time.Time) *GetMaintenanceWindowOutput {
	s.CreatedDate = &v
	return s
}

// SetCutoff sets the Cutoff field's value.
func (s *GetMaintenanceWindowOutput) SetCutoff(v int64) *GetMaintenanceWindowOutput {
	s.Cutoff = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetMaintenanceWindowOutput) SetDescription(v string) *GetMaintenanceWindowOutput {
	s.Description = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *GetMaintenanceWindowOutput) SetDuration(v int64) *GetMaintenanceWindowOutput {
	s.Duration = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *GetMaintenanceWindowOutput) SetEnabled(v bool) *GetMaintenanceWindowOutput {
	s.Enabled = &v
	return s
}

// SetEndDate sets the EndDate field's value.
func (s *GetMaintenanceWindowOutput) SetEndDate(v string) *GetMaintenanceWindowOutput {
	s.EndDate = &v
	return s
}

// SetModifiedDate sets the ModifiedDate field's value.
func (s *GetMaintenanceWindowOutput) SetModifiedDate(v time.Time) *GetMaintenanceWindowOutput {
	s.ModifiedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetMaintenanceWindowOutput) SetName(v string) *GetMaintenanceWindowOutput {
	s.Name = &v
	return s
}

// SetNextExecutionTime sets the NextExecutionTime field's value.
func (s *GetMaintenanceWindowOutput) SetNextExecutionTime(v string) *GetMaintenanceWindowOutput {
	s.NextExecutionTime = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *GetMaintenanceWindowOutput) SetSchedule(v string) *GetMaintenanceWindowOutput {
	s.Schedule = &v
	return s
}

// SetScheduleTimezone sets the ScheduleTimezone field's value.
func (s *GetMaintenanceWindowOutput) SetScheduleTimezone(v string) *GetMaintenanceWindowOutput {
	s.ScheduleTimezone = &v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *GetMaintenanceWindowOutput) SetStartDate(v string) *GetMaintenanceWindowOutput {
	s.StartDate = &v
	return s
}

// SetWindowId sets the WindowId field's value.
func (s *GetMaintenanceWindowOutput) SetWindowId(v string) *GetMaintenanceWindowOutput {
	s.WindowId = &v
	return s
}

type GetMaintenanceWindowTaskInput struct {
	_ struct{} `type:"structure"`

	// The Maintenance Window ID that includes the task to retrieve.
	//
	// WindowId is a required field
	WindowId *string `min:"20" type:"string" required:"true"`

	// The Maintenance Window task ID to retrieve.
	//
	// WindowTaskId is a required field
	WindowTaskId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s GetMaintenanceWindowTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMaintenanceWindowTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMaintenanceWindowTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMaintenanceWindowTaskInput"}
	if s.WindowId == nil {
		invalidParams.Add(request.NewErrParamRequired("WindowId"))
	}
	if s.WindowId != nil && len(*s.WindowId) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("WindowId", 20))
	}
	if s.WindowTaskId == nil {
		invalidParams.Add(request.NewErrParamRequired("WindowTaskId"))
	}
	if s.WindowTaskId != nil && len(*s.WindowTaskId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("WindowTaskId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWindowId sets the WindowId field's value.
func (s *GetMaintenanceWindowTaskInput) SetWindowId(v string) *GetMaintenanceWindowTaskInput {
	s.WindowId = &v
	return s
}

// SetWindowTaskId sets the WindowTaskId field's value.
func (s *GetMaintenanceWindowTaskInput) SetWindowTaskId(v string) *GetMaintenanceWindowTaskInput {
	s.WindowTaskId = &v
	return s
}

type GetMaintenanceWindowTaskOutput struct {
	_ struct{} `type:"structure"`

	// The retrieved task description.
	Description *string `min:"1" type:"string" sensitive:"true"`

	// The location in Amazon S3 where the task results are logged.
	//
	// LoggingInfo has been deprecated. To specify an S3 bucket to contain logs,
	// instead use the OutputS3BucketName and OutputS3KeyPrefix options in the TaskInvocationParameters
	// structure. For information about how Systems Manager handles these options
	// for the supported Maintenance Window task types, see MaintenanceWindowTaskInvocationParameters.
	LoggingInfo *LoggingInfo `type:"structure"`

	// The maximum number of targets allowed to run this task in parallel.
	MaxConcurrency *string `min:"1" type:"string"`

	// The maximum number of errors allowed before the task stops being scheduled.
	MaxErrors *string `min:"1" type:"string"`

	// The retrieved task name.
	Name *string `min:"3" type:"string"`

	// The priority of the task when it executes. The lower the number, the higher
	// the priority. Tasks that have the same priority are scheduled in parallel.
	Priority *int64 `type:"integer"`

	// The IAM service role to assume during task execution.
	ServiceRoleArn *string `type:"string"`

	// The targets where the task should execute.
	Targets []*Target `type:"list"`

	// The resource that the task used during execution. For RUN_COMMAND and AUTOMATION
	// task types, the TaskArn is the Systems Manager Document name/ARN. For LAMBDA
	// tasks, the value is the function name/ARN. For STEP_FUNCTION tasks, the value
	// is the state machine ARN.
	TaskArn *string `min:"1" type:"string"`

	// The parameters to pass to the task when it executes.
	TaskInvocationParameters *MaintenanceWindowTaskInvocationParameters `type:"structure"`

	// The parameters to pass to the task when it executes.
	//
	// TaskParameters has been deprecated. To specify parameters to pass to a task
	// when it runs, instead use the Parameters option in the TaskInvocationParameters
	// structure. For information about how Systems Manager handles these options
	// for the supported Maintenance Window task types, see MaintenanceWindowTaskInvocationParameters.
	TaskParameters map[string]*MaintenanceWindowTaskParameterValueExpression `type:"map" sensitive:"true"`

	// The type of task to execute.
	TaskType *string `type:"string" enum:"MaintenanceWindowTaskType"`

	// The retrieved Maintenance Window ID.
	WindowId *string `min:"20" type:"string"`

	// The retrieved Maintenance Window task ID.
	WindowTaskId *string `min:"36" type:"string"`
}

// String returns the string representation
func (s GetMaintenanceWindowTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMaintenanceWindowTaskOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *GetMaintenanceWindowTaskOutput) SetDescription(v string) *GetMaintenanceWindowTaskOutput {
	s.Description = &v
	return s
}

// SetLoggingInfo sets the LoggingInfo field's value.
func (s *GetMaintenanceWindowTaskOutput) SetLoggingInfo(v *LoggingInfo) *GetMaintenanceWindowTaskOutput {
	s.LoggingInfo = v
	return s
}

// SetMaxConcurrency sets the MaxConcurrency field's value.
func (s *GetMaintenanceWindowTaskOutput) SetMaxConcurrency(v string) *GetMaintenanceWindowTaskOutput {
	s.MaxConcurrency = &v
	return s
}

// SetMaxErrors sets the MaxErrors field's value.
func (s *GetMaintenanceWindowTaskOutput) SetMaxErrors(v string) *GetMaintenanceWindowTaskOutput {
	s.MaxErrors = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetMaintenanceWindowTaskOutput) SetName(v string) *GetMaintenanceWindowTaskOutput {
	s.Name = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *GetMaintenanceWindowTaskOutput) SetPriority(v int64) *GetMaintenanceWindowTaskOutput {
	s.Priority = &v
	return s
}

// SetServiceRoleArn sets the ServiceRoleArn field's value.
func (s *GetMaintenanceWindowTaskOutput) SetServiceRoleArn(v string) *GetMaintenanceWindowTaskOutput {
	s.ServiceRoleArn = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *GetMaintenanceWindowTaskOutput) SetTargets(v []*Target) *GetMaintenanceWindowTaskOutput {
	s.Targets = v
	return s
}

// SetTaskArn sets the TaskArn field's value.
func (s *GetMaintenanceWindowTaskOutput) SetTaskArn(v string) *GetMaintenanceWindowTaskOutput {
	s.TaskArn = &v
	return s
}

// SetTaskInvocationParameters sets the TaskInvocationParameters field's value.
func (s *GetMaintenanceWindowTaskOutput) SetTaskInvocationParameters(v *MaintenanceWindowTaskInvocationParameters) *GetMaintenanceWindowTaskOutput {
	s.TaskInvocationParameters = v
	return s
}

// SetTaskParameters sets the TaskParameters field's value.
func (s *GetMaintenanceWindowTaskOutput) SetTaskParameters(v map[string]*MaintenanceWindowTaskParameterValueExpression) *GetMaintenanceWindowTaskOutput {
	s.TaskParameters = v
	return s
}

// SetTaskType sets the TaskType field's value.
func (s *GetMaintenanceWindowTaskOutput) SetTaskType(v string) *GetMaintenanceWindowTaskOutput {
	s.TaskType = &v
	return s
}

// SetWindowId sets the WindowId field's value.
func (s *GetMaintenanceWindowTaskOutput) SetWindowId(v string) *GetMaintenanceWindowTaskOutput {
	s.WindowId = &v
	return s
}

// SetWindowTaskId sets the WindowTaskId field's value.
func (s *GetMaintenanceWindowTaskOutput) SetWindowTaskId(v string) *GetMaintenanceWindowTaskOutput {
	s.WindowTaskId = &v
	return s
}

type GetParameterHistoryInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The name of a parameter you want to query.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	// Return decrypted values for secure string parameters. This flag is ignored
	// for String and StringList parameter types.
	WithDecryption *bool `type:"boolean"`
}

// String returns the string representation
func (s GetParameterHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetParameterHistoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetParameterHistoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetParameterHistoryInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetParameterHistoryInput) SetMaxResults(v int64) *GetParameterHistoryInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetParameterHistoryInput) SetName(v string) *GetParameterHistoryInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetParameterHistoryInput) SetNextToken(v string) *GetParameterHistoryInput {
	s.NextToken = &v
	return s
}

// SetWithDecryption sets the WithDecryption field's value.
func (s *GetParameterHistoryInput) SetWithDecryption(v bool) *GetParameterHistoryInput {
	s.WithDecryption = &v
	return s
}

type GetParameterHistoryOutput struct {
	_ struct{} `type:"structure"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`

	// A list of parameters returned by the request.
	Parameters []*ParameterHistory `type:"list"`
}

// String returns the string representation
func (s GetParameterHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetParameterHistoryOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetParameterHistoryOutput) SetNextToken(v string) *GetParameterHistoryOutput {
	s.NextToken = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *GetParameterHistoryOutput) SetParameters(v []*ParameterHistory) *GetParameterHistoryOutput {
	s.Parameters = v
	return s
}

type GetParameterInput struct {
	_ struct{} `type:"structure"`

	// The name of the parameter you want to query.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Return decrypted values for secure string parameters. This flag is ignored
	// for String and StringList parameter types.
	WithDecryption *bool `type:"boolean"`
}

// String returns the string representation
func (s GetParameterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetParameterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetParameterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetParameterInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetParameterInput) SetName(v string) *GetParameterInput {
	s.Name = &v
	return s
}

// SetWithDecryption sets the WithDecryption field's value.
func (s *GetParameterInput) SetWithDecryption(v bool) *GetParameterInput {
	s.WithDecryption = &v
	return s
}

type GetParameterOutput struct {
	_ struct{} `type:"structure"`

	// Information about a parameter.
	Parameter *Parameter `type:"structure"`
}

// String returns the string representation
func (s GetParameterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetParameterOutput) GoString() string {
	return s.String()
}

// SetParameter sets the Parameter field's value.
func (s *GetParameterOutput) SetParameter(v *Parameter) *GetParameterOutput {
	s.Parameter = v
	return s
}

type GetParametersByPathInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token to start the list. Use this token to get the next set of results.
	NextToken *string `type:"string"`

	// Filters to limit the request results.
	//
	// You can't filter using the parameter name.
	ParameterFilters []*ParameterStringFilter `type:"list"`

	// The hierarchy for the parameter. Hierarchies start with a forward slash (/)
	// and end with the parameter name. A parameter name hierarchy can have a maximum
	// of 15 levels. Here is an example of a hierarchy: /Finance/Prod/IAD/WinServ2016/license33
	//
	// Path is a required field
	Path *string `min:"1" type:"string" required:"true"`

	// Retrieve all parameters within a hierarchy.
	//
	// If a user has access to a path, then the user can access all levels of that
	// path. For example, if a user has permission to access path /a, then the user
	// can also access /a/b. Even if a user has explicitly been denied access in
	// IAM for parameter /a, they can still call the GetParametersByPath API action
	// recursively and view /a/b.
	Recursive *bool `type:"boolean"`

	// Retrieve all parameters in a hierarchy with their value decrypted.
	WithDecryption *bool `type:"boolean"`
}

// String returns the string representation
func (s GetParametersByPathInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetParametersByPathInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetParametersByPathInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetParametersByPathInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Path == nil {
		invalidParams.Add(request.NewErrParamRequired("Path"))
	}
	if s.Path != nil && len(*s.Path) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Path", 1))
	}
	if s.ParameterFilters != nil {
		for i, v := range s.ParameterFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ParameterFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetParametersByPathInput) SetMaxResults(v int64) *GetParametersByPathInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetParametersByPathInput) SetNextToken(v string) *GetParametersByPathInput {
	s.NextToken = &v
	return s
}

// SetParameterFilters sets the ParameterFilters field's value.
func (s *GetParametersByPathInput) SetParameterFilters(v []*ParameterStringFilter) *GetParametersByPathInput {
	s.ParameterFilters = v
	return s
}

// SetPath sets the Path field's value.
func (s *GetParametersByPathInput) SetPath(v string) *GetParametersByPathInput {
	s.Path = &v
	return s
}

// SetRecursive sets the Recursive field's value.
func (s *GetParametersByPathInput) SetRecursive(v bool) *GetParametersByPathInput {
	s.Recursive = &v
	return s
}

// SetWithDecryption sets the WithDecryption field's value.
func (s *GetParametersByPathInput) SetWithDecryption(v bool) *GetParametersByPathInput {
	s.WithDecryption = &v
	return s
}

type GetParametersByPathOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of items to return. Use this token to get the
	// next set of results.
	NextToken *string `type:"string"`

	// A list of parameters found in the specified hierarchy.
	Parameters []*Parameter `type:"list"`
}

// String returns the string representation
func (s GetParametersByPathOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetParametersByPathOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetParametersByPathOutput) SetNextToken(v string) *GetParametersByPathOutput {
	s.NextToken = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *GetParametersByPathOutput) SetParameters(v []*Parameter) *GetParametersByPathOutput {
	s.Parameters = v
	return s
}

type GetParametersInput struct {
	_ struct{} `type:"structure"`

	// Names of the parameters for which you want to query information.
	//
	// Names is a required field
	Names []*string `min:"1" type:"list" required:"true"`

	// Return decrypted secure string value. Return decrypted values for secure
	// string parameters. This flag is ignored for String and StringList parameter
	// types.
	WithDecryption *bool `type:"boolean"`
}

// String returns the string representation
func (s GetParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetParametersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetParametersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetParametersInput"}
	if s.Names == nil {
		invalidParams.Add(request.NewErrParamRequired("Names"))
	}
	if s.Names != nil && len(s.Names) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Names", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNames sets the Names field's value.
func (s *GetParametersInput) SetNames(v []*string) *GetParametersInput {
	s.Names = v
	return s
}

// SetWithDecryption sets the WithDecryption field's value.
func (s *GetParametersInput) SetWithDecryption(v bool) *GetParametersInput {
	s.WithDecryption = &v
	return s
}

type GetParametersOutput struct {
	_ struct{} `type:"structure"`

	// A list of parameters that are not formatted correctly or do not run when
	// executed.
	InvalidParameters []*string `min:"1" type:"list"`

	// A list of details for a parameter.
	Parameters []*Parameter `type:"list"`
}

// String returns the string representation
func (s GetParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetParametersOutput) GoString() string {
	return s.String()
}

// SetInvalidParameters sets the InvalidParameters field's value.
func (s *GetParametersOutput) SetInvalidParameters(v []*string) *GetParametersOutput {
	s.InvalidParameters = v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *GetParametersOutput) SetParameters(v []*Parameter) *GetParametersOutput {
	s.Parameters = v
	return s
}

type GetPatchBaselineForPatchGroupInput struct {
	_ struct{} `type:"structure"`

	// Returns he operating system rule specified for patch groups using the patch
	// baseline.
	OperatingSystem *string `type:"string" enum:"OperatingSystem"`

	// The name of the patch group whose patch baseline should be retrieved.
	//
	// PatchGroup is a required field
	PatchGroup *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetPatchBaselineForPatchGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPatchBaselineForPatchGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPatchBaselineForPatchGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPatchBaselineForPatchGroupInput"}
	if s.PatchGroup == nil {
		invalidParams.Add(request.NewErrParamRequired("PatchGroup"))
	}
	if s.PatchGroup != nil && len(*s.PatchGroup) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PatchGroup", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOperatingSystem sets the OperatingSystem field's value.
func (s *GetPatchBaselineForPatchGroupInput) SetOperatingSystem(v string) *GetPatchBaselineForPatchGroupInput {
	s.OperatingSystem = &v
	return s
}

// SetPatchGroup sets the PatchGroup field's value.
func (s *GetPatchBaselineForPatchGroupInput) SetPatchGroup(v string) *GetPatchBaselineForPatchGroupInput {
	s.PatchGroup = &v
	return s
}

type GetPatchBaselineForPatchGroupOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the patch baseline that should be used for the patch group.
	BaselineId *string `min:"20" type:"string"`

	// The operating system rule specified for patch groups using the patch baseline.
	OperatingSystem *string `type:"string" enum:"OperatingSystem"`

	// The name of the patch group.
	PatchGroup *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetPatchBaselineForPatchGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPatchBaselineForPatchGroupOutput) GoString() string {
	return s.String()
}

// SetBaselineId sets the BaselineId field's value.
func (s *GetPatchBaselineForPatchGroupOutput) SetBaselineId(v string) *GetPatchBaselineForPatchGroupOutput {
	s.BaselineId = &v
	return s
}

// SetOperatingSystem sets the OperatingSystem field's value.
func (s *GetPatchBaselineForPatchGroupOutput) SetOperatingSystem(v string) *GetPatchBaselineForPatchGroupOutput {
	s.OperatingSystem = &v
	return s
}

// SetPatchGroup sets the PatchGroup field's value.
func (s *GetPatchBaselineForPatchGroupOutput) SetPatchGroup(v string) *GetPatchBaselineForPatchGroupOutput {
	s.PatchGroup = &v
	return s
}

type GetPatchBaselineInput struct {
	_ struct{} `type:"structure"`

	// The ID of the patch baseline to retrieve.
	//
	// BaselineId is a required field
	BaselineId *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s GetPatchBaselineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPatchBaselineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPatchBaselineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPatchBaselineInput"}
	if s.BaselineId == nil {
		invalidParams.Add(request.NewErrParamRequired("BaselineId"))
	}
	if s.BaselineId != nil && len(*s.BaselineId) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("BaselineId", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBaselineId sets the BaselineId field's value.
func (s *GetPatchBaselineInput) SetBaselineId(v string) *GetPatchBaselineInput {
	s.BaselineId = &v
	return s
}

type GetPatchBaselineOutput struct {
	_ struct{} `type:"structure"`

	// A set of rules used to include patches in the baseline.
	ApprovalRules *PatchRuleGroup `type:"structure"`

	// A list of explicitly approved patches for the baseline.
	ApprovedPatches []*string `type:"list"`

	// Returns the specified compliance severity level for approved patches in the
	// patch baseline.
	ApprovedPatchesComplianceLevel *string `type:"string" enum:"PatchComplianceLevel"`

	// Indicates whether the list of approved patches includes non-security updates
	// that should be applied to the instances. The default value is 'false'. Applies
	// to Linux instances only.
	ApprovedPatchesEnableNonSecurity *bool `type:"boolean"`

	// The ID of the retrieved patch baseline.
	BaselineId *string `min:"20" type:"string"`

	// The date the patch baseline was created.
	CreatedDate *time.Time `type:"timestamp"`

	// A description of the patch baseline.
	Description *string `min:"1" type:"string"`

	// A set of global filters used to exclude patches from the baseline.
	GlobalFilters *PatchFilterGroup `type:"structure"`

	// The date the patch baseline was last modified.
	ModifiedDate *time.Time `type:"timestamp"`

	// The name of the patch baseline.
	Name *string `min:"3" type:"string"`

	// Returns the operating system specified for the patch baseline.
	OperatingSystem *string `type:"string" enum:"OperatingSystem"`

	// Patch groups included in the patch baseline.
	PatchGroups []*string `type:"list"`

	// A list of explicitly rejected patches for the baseline.
	RejectedPatches []*string `type:"list"`

	// The action specified to take on patches included in the RejectedPatches list.
	// A patch can be allowed only if it is a dependency of another package, or
	// blocked entirely along with packages that include it as a dependency.
	RejectedPatchesAction *string `type:"string" enum:"PatchAction"`

	// Information about the patches to use to update the instances, including target
	// operating systems and source repositories. Applies to Linux instances only.
	Sources []*PatchSource `type:"list"`
}

// String returns the string representation
func (s GetPatchBaselineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPatchBaselineOutput) GoString() string {
	return s.String()
}

// SetApprovalRules sets the ApprovalRules field's value.
func (s *GetPatchBaselineOutput) SetApprovalRules(v *PatchRuleGroup) *GetPatchBaselineOutput {
	s.ApprovalRules = v
	return s
}

// SetApprovedPatches sets the ApprovedPatches field's value.
func (s *GetPatchBaselineOutput) SetApprovedPatches(v []*string) *GetPatchBaselineOutput {
	s.ApprovedPatches = v
	return s
}

// SetApprovedPatchesComplianceLevel sets the ApprovedPatchesComplianceLevel field's value.
func (s *GetPatchBaselineOutput) SetApprovedPatchesComplianceLevel(v string) *GetPatchBaselineOutput {
	s.ApprovedPatchesComplianceLevel = &v
	return s
}

// SetApprovedPatchesEnableNonSecurity sets the ApprovedPatchesEnableNonSecurity field's value.
func (s *GetPatchBaselineOutput) SetApprovedPatchesEnableNonSecurity(v bool) *GetPatchBaselineOutput {
	s.ApprovedPatchesEnableNonSecurity = &v
	return s
}

// SetBaselineId sets the BaselineId field's value.
func (s *GetPatchBaselineOutput) SetBaselineId(v string) *GetPatchBaselineOutput {
	s.BaselineId = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *GetPatchBaselineOutput) SetCreatedDate(v time.Time) *GetPatchBaselineOutput {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetPatchBaselineOutput) SetDescription(v string) *GetPatchBaselineOutput {
	s.Description = &v
	return s
}

// SetGlobalFilters sets the GlobalFilters field's value.
func (s *GetPatchBaselineOutput) SetGlobalFilters(v *PatchFilterGroup) *GetPatchBaselineOutput {
	s.GlobalFilters = v
	return s
}

// SetModifiedDate sets the ModifiedDate field's value.
func (s *GetPatchBaselineOutput) SetModifiedDate(v time.Time) *GetPatchBaselineOutput {
	s.ModifiedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetPatchBaselineOutput) SetName(v string) *GetPatchBaselineOutput {
	s.Name = &v
	return s
}

// SetOperatingSystem sets the OperatingSystem field's value.
func (s *GetPatchBaselineOutput) SetOperatingSystem(v string) *GetPatchBaselineOutput {
	s.OperatingSystem = &v
	return s
}

// SetPatchGroups sets the PatchGroups field's value.
func (s *GetPatchBaselineOutput) SetPatchGroups(v []*string) *GetPatchBaselineOutput {
	s.PatchGroups = v
	return s
}

// SetRejectedPatches sets the RejectedPatches field's value.
func (s *GetPatchBaselineOutput) SetRejectedPatches(v []*string) *GetPatchBaselineOutput {
	s.RejectedPatches = v
	return s
}

// SetRejectedPatchesAction sets the RejectedPatchesAction field's value.
func (s *GetPatchBaselineOutput) SetRejectedPatchesAction(v string) *GetPatchBaselineOutput {
	s.RejectedPatchesAction = &v
	return s
}

// SetSources sets the Sources field's value.
func (s *GetPatchBaselineOutput) SetSources(v []*PatchSource) *GetPatchBaselineOutput {
	s.Sources = v
	return s
}

// Status information about the aggregated associations.
type InstanceAggregatedAssociationOverview struct {
	_ struct{} `type:"structure"`

	// Detailed status information about the aggregated associations.
	DetailedStatus *string `type:"string"`

	// The number of associations for the instance(s).
	InstanceAssociationStatusAggregatedCount map[string]*int64 `type:"map"`
}

// String returns the string representation
func (s InstanceAggregatedAssociationOverview) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceAggregatedAssociationOverview) GoString() string {
	return s.String()
}

// SetDetailedStatus sets the DetailedStatus field's value.
func (s *InstanceAggregatedAssociationOverview) SetDetailedStatus(v string) *InstanceAggregatedAssociationOverview {
	s.DetailedStatus = &v
	return s
}

// SetInstanceAssociationStatusAggregatedCount sets the InstanceAssociationStatusAggregatedCount field's value.
func (s *InstanceAggregatedAssociationOverview) SetInstanceAssociationStatusAggregatedCount(v map[string]*int64) *InstanceAggregatedAssociationOverview {
	s.InstanceAssociationStatusAggregatedCount = v
	return s
}

// One or more association documents on the instance.
type InstanceAssociation struct {
	_ struct{} `type:"structure"`

	// The association ID.
	AssociationId *string `type:"string"`

	// Version information for the association on the instance.
	AssociationVersion *string `type:"string"`

	// The content of the association document for the instance(s).
	Content *string `min:"1" type:"string"`

	// The instance ID.
	InstanceId *string `type:"string"`
}

// String returns the string representation
func (s InstanceAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceAssociation) GoString() string {
	return s.String()
}

// SetAssociationId sets the AssociationId field's value.
func (s *InstanceAssociation) SetAssociationId(v string) *InstanceAssociation {
	s.AssociationId = &v
	return s
}

// SetAssociationVersion sets the AssociationVersion field's value.
func (s *InstanceAssociation) SetAssociationVersion(v string) *InstanceAssociation {
	s.AssociationVersion = &v
	return s
}

// SetContent sets the Content field's value.
func (s *InstanceAssociation) SetContent(v string) *InstanceAssociation {
	s.Content = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *InstanceAssociation) SetInstanceId(v string) *InstanceAssociation {
	s.InstanceId = &v
	return s
}

// An Amazon S3 bucket where you want to store the results of this request.
type InstanceAssociationOutputLocation struct {
	_ struct{} `type:"structure"`

	// An Amazon S3 bucket where you want to store the results of this request.
	S3Location *S3OutputLocation `type:"structure"`
}

// String returns the string representation
func (s InstanceAssociationOutputLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceAssociationOutputLocation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InstanceAssociationOutputLocation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InstanceAssociationOutputLocation"}
	if s.S3Location != nil {
		if err := s.S3Location.Validate(); err != nil {
			invalidParams.AddNested("S3Location", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Location sets the S3Location field's value.
func (s *InstanceAssociationOutputLocation) SetS3Location(v *S3OutputLocation) *InstanceAssociationOutputLocation {
	s.S3Location = v
	return s
}

// The URL of Amazon S3 bucket where you want to store the results of this request.
type InstanceAssociationOutputUrl struct {
	_ struct{} `type:"structure"`

	// The URL of Amazon S3 bucket where you want to store the results of this request.
	S3OutputUrl *S3OutputUrl `type:"structure"`
}

// String returns the string representation
func (s InstanceAssociationOutputUrl) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceAssociationOutputUrl) GoString() string {
	return s.String()
}

// SetS3OutputUrl sets the S3OutputUrl field's value.
func (s *InstanceAssociationOutputUrl) SetS3OutputUrl(v *S3OutputUrl) *InstanceAssociationOutputUrl {
	s.S3OutputUrl = v
	return s
}

// Status information about the instance association.
type InstanceAssociationStatusInfo struct {
	_ struct{} `type:"structure"`

	// The association ID.
	AssociationId *string `type:"string"`

	// The name of the association applied to the instance.
	AssociationName *string `type:"string"`

	// The version of the association applied to the instance.
	AssociationVersion *string `type:"string"`

	// Detailed status information about the instance association.
	DetailedStatus *string `type:"string"`

	// The association document verions.
	DocumentVersion *string `type:"string"`

	// An error code returned by the request to create the association.
	ErrorCode *string `type:"string"`

	// The date the instance association executed.
	ExecutionDate *time.Time `type:"timestamp"`

	// Summary information about association execution.
	ExecutionSummary *string `min:"1" type:"string"`

	// The instance ID where the association was created.
	InstanceId *string `type:"string"`

	// The name of the association.
	Name *string `type:"string"`

	// A URL for an Amazon S3 bucket where you want to store the results of this
	// request.
	OutputUrl *InstanceAssociationOutputUrl `type:"structure"`

	// Status information about the instance association.
	Status *string `type:"string"`
}

// String returns the string representation
func (s InstanceAssociationStatusInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceAssociationStatusInfo) GoString() string {
	return s.String()
}

// SetAssociationId sets the AssociationId field's value.
func (s *InstanceAssociationStatusInfo) SetAssociationId(v string) *InstanceAssociationStatusInfo {
	s.AssociationId = &v
	return s
}

// SetAssociationName sets the AssociationName field's value.
func (s *InstanceAssociationStatusInfo) SetAssociationName(v string) *InstanceAssociationStatusInfo {
	s.AssociationName = &v
	return s
}

// SetAssociationVersion sets the AssociationVersion field's value.
func (s *InstanceAssociationStatusInfo) SetAssociationVersion(v string) *InstanceAssociationStatusInfo {
	s.AssociationVersion = &v
	return s
}

// SetDetailedStatus sets the DetailedStatus field's value.
func (s *InstanceAssociationStatusInfo) SetDetailedStatus(v string) *InstanceAssociationStatusInfo {
	s.DetailedStatus = &v
	return s
}

// SetDocumentVersion sets the DocumentVersion field's value.
func (s *InstanceAssociationStatusInfo) SetDocumentVersion(v string) *InstanceAssociationStatusInfo {
	s.DocumentVersion = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *InstanceAssociationStatusInfo) SetErrorCode(v string) *InstanceAssociationStatusInfo {
	s.ErrorCode = &v
	return s
}

// SetExecutionDate sets the ExecutionDate field's value.
func (s *InstanceAssociationStatusInfo) SetExecutionDate(v time.Time) *InstanceAssociationStatusInfo {
	s.ExecutionDate = &v
	return s
}

// SetExecutionSummary sets the ExecutionSummary field's value.
func (s *InstanceAssociationStatusInfo) SetExecutionSummary(v string) *InstanceAssociationStatusInfo {
	s.ExecutionSummary = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *InstanceAssociationStatusInfo) SetInstanceId(v string) *InstanceAssociationStatusInfo {
	s.InstanceId = &v
	return s
}

// SetName sets the Name field's value.
func (s *InstanceAssociationStatusInfo) SetName(v string) *InstanceAssociationStatusInfo {
	s.Name = &v
	return s
}

// SetOutputUrl sets the OutputUrl field's value.
func (s *InstanceAssociationStatusInfo) SetOutputUrl(v *InstanceAssociationOutputUrl) *InstanceAssociationStatusInfo {
	s.OutputUrl = v
	return s
}

// SetStatus sets the Status field's value.
func (s *InstanceAssociationStatusInfo) SetStatus(v string) *InstanceAssociationStatusInfo {
	s.Status = &v
	return s
}

// Describes a filter for a specific list of instances.
type InstanceInformation struct {
	_ struct{} `type:"structure"`

	// The activation ID created by Systems Manager when the server or VM was registered.
	ActivationId *string `type:"string"`

	// The version of SSM Agent running on your Linux instance.
	AgentVersion *string `type:"string"`

	// Information about the association.
	AssociationOverview *InstanceAggregatedAssociationOverview `type:"structure"`

	// The status of the association.
	AssociationStatus *string `type:"string"`

	// The fully qualified host name of the managed instance.
	ComputerName *string `min:"1" type:"string"`

	// The IP address of the managed instance.
	IPAddress *string `min:"1" type:"string"`

	// The Amazon Identity and Access Management (IAM) role assigned to the on-premises
	// Systems Manager managed instances. This call does not return the IAM role
	// for Amazon EC2 instances.
	IamRole *string `type:"string"`

	// The instance ID.
	InstanceId *string `type:"string"`

	// Indicates whether latest version of SSM Agent is running on your instance.
	// Some older versions of Windows Server use the EC2Config service to process
	// SSM requests. For this reason, this field does not indicate whether or not
	// the latest version is installed on Windows managed instances.
	IsLatestVersion *bool `type:"boolean"`

	// The date the association was last executed.
	LastAssociationExecutionDate *time.Time `type:"timestamp"`

	// The date and time when agent last pinged Systems Manager service.
	LastPingDateTime *time.Time `type:"timestamp"`

	// The last date the association was successfully run.
	LastSuccessfulAssociationExecutionDate *time.Time `type:"timestamp"`

	// The name of the managed instance.
	Name *string `type:"string"`

	// Connection status of SSM Agent.
	PingStatus *string `type:"string" enum:"PingStatus"`

	// The name of the operating system platform running on your instance.
	PlatformName *string `type:"string"`

	// The operating system platform type.
	PlatformType *string `type:"string" enum:"PlatformType"`

	// The version of the OS platform running on your instance.
	PlatformVersion *string `type:"string"`

	// The date the server or VM was registered with AWS as a managed instance.
	RegistrationDate *time.Time `type:"timestamp"`

	// The type of instance. Instances are either EC2 instances or managed instances.
	ResourceType *string `type:"string" enum:"ResourceType"`
}

// String returns the string representation
func (s InstanceInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceInformation) GoString() string {
	return s.String()
}

// SetActivationId sets the ActivationId field's value.
func (s *InstanceInformation) SetActivationId(v string) *InstanceInformation {
	s.ActivationId = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *InstanceInformation) SetAgentVersion(v string) *InstanceInformation {
	s.AgentVersion = &v
	return s
}

// SetAssociationOverview sets the AssociationOverview field's value.
func (s *InstanceInformation) SetAssociationOverview(v *InstanceAggregatedAssociationOverview) *InstanceInformation {
	s.AssociationOverview = v
	return s
}

// SetAssociationStatus sets the AssociationStatus field's value.
func (s *InstanceInformation) SetAssociationStatus(v string) *InstanceInformation {
	s.AssociationStatus = &v
	return s
}

// SetComputerName sets the ComputerName field's value.
func (s *InstanceInformation) SetComputerName(v string) *InstanceInformation {
	s.ComputerName = &v
	return s
}

// SetIPAddress sets the IPAddress field's value.
func (s *InstanceInformation) SetIPAddress(v string) *InstanceInformation {
	s.IPAddress = &v
	return s
}

// SetIamRole sets the IamRole field's value.
func (s *InstanceInformation) SetIamRole(v string) *InstanceInformation {
	s.IamRole = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *InstanceInformation) SetInstanceId(v string) *InstanceInformation {
	s.InstanceId = &v
	return s
}

// SetIsLatestVersion sets the IsLatestVersion field's value.
func (s *InstanceInformation) SetIsLatestVersion(v bool) *InstanceInformation {
	s.IsLatestVersion = &v
	return s
}

// SetLastAssociationExecutionDate sets the LastAssociationExecutionDate field's value.
func (s *InstanceInformation) SetLastAssociationExecutionDate(v time.Time) *InstanceInformation {
	s.LastAssociationExecutionDate = &v
	return s
}

// SetLastPingDateTime sets the LastPingDateTime field's value.
func (s *InstanceInformation) SetLastPingDateTime(v time.Time) *InstanceInformation {
	s.LastPingDateTime = &v
	return s
}

// SetLastSuccessfulAssociationExecutionDate sets the LastSuccessfulAssociationExecutionDate field's value.
func (s *InstanceInformation) SetLastSuccessfulAssociationExecutionDate(v time.Time) *InstanceInformation {
	s.LastSuccessfulAssociationExecutionDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *InstanceInformation) SetName(v string) *InstanceInformation {
	s.Name = &v
	return s
}

// SetPingStatus sets the PingStatus field's value.
func (s *InstanceInformation) SetPingStatus(v string) *InstanceInformation {
	s.PingStatus = &v
	return s
}

// SetPlatformName sets the PlatformName field's value.
func (s *InstanceInformation) SetPlatformName(v string) *InstanceInformation {
	s.PlatformName = &v
	return s
}

// SetPlatformType sets the PlatformType field's value.
func (s *InstanceInformation) SetPlatformType(v string) *InstanceInformation {
	s.PlatformType = &v
	return s
}

// SetPlatformVersion sets the PlatformVersion field's value.
func (s *InstanceInformation) SetPlatformVersion(v string) *InstanceInformation {
	s.PlatformVersion = &v
	return s
}

// SetRegistrationDate sets the RegistrationDate field's value.
func (s *InstanceInformation) SetRegistrationDate(v time.Time) *InstanceInformation {
	s.RegistrationDate = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *InstanceInformation) SetResourceType(v string) *InstanceInformation {
	s.ResourceType = &v
	return s
}

// Describes a filter for a specific list of instances. You can filter instances
// information by using tags. You specify tags by using a key-value mapping.
//
// Use this action instead of the DescribeInstanceInformationRequest$InstanceInformationFilterList
// method. The InstanceInformationFilterList method is a legacy method and does
// not support tags.
type InstanceInformationFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	//
	// Key is a required field
	Key *string `locationName:"key" type:"string" required:"true" enum:"InstanceInformationFilterKey"`

	// The filter values.
	//
	// ValueSet is a required field
	ValueSet []*string `locationName:"valueSet" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s InstanceInformationFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceInformationFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InstanceInformationFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InstanceInformationFilter"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.ValueSet == nil {
		invalidParams.Add(request.NewErrParamRequired("ValueSet"))
	}
	if s.ValueSet != nil && len(s.ValueSet) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValueSet", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *InstanceInformationFilter) SetKey(v string) *InstanceInformationFilter {
	s.Key = &v
	return s
}

// SetValueSet sets the ValueSet field's value.
func (s *InstanceInformationFilter) SetValueSet(v []*string) *InstanceInformationFilter {
	s.ValueSet = v
	return s
}

// The filters to describe or get information about your managed instances.
type InstanceInformationStringFilter struct {
	_ struct{} `type:"structure"`

	// The filter key name to describe your instances. For example:
	//
	// "InstanceIds"|"AgentVersion"|"PingStatus"|"PlatformTypes"|"ActivationIds"|"IamRole"|"ResourceType"|"AssociationStatus"|"Tag
	// Key"
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The filter values.
	//
	// Values is a required field
	Values []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s InstanceInformationStringFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceInformationStringFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InstanceInformationStringFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InstanceInformationStringFilter"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *InstanceInformationStringFilter) SetKey(v string) *InstanceInformationStringFilter {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *InstanceInformationStringFilter) SetValues(v []*string) *InstanceInformationStringFilter {
	s.Values = v
	return s
}

// Defines the high-level patch compliance state for a managed instance, providing
// information about the number of installed, missing, not applicable, and failed
// patches along with metadata about the operation when this information was
// gathered for the instance.
type InstancePatchState struct {
	_ struct{} `type:"structure"`

	// The ID of the patch baseline used to patch the instance.
	//
	// BaselineId is a required field
	BaselineId *string `min:"20" type:"string" required:"true"`

	// The number of patches from the patch baseline that were attempted to be installed
	// during the last patching operation, but failed to install.
	FailedCount *int64 `type:"integer"`

	// An https URL or an Amazon S3 path-style URL to a list of patches to be installed.
	// This patch installation list, which you maintain in an Amazon S3 bucket in
	// YAML format and specify in the SSM document AWS-RunPatchBaseline, overrides
	// the patches specified by the default patch baseline.
	//
	// For more information about the InstallOverrideList parameter, see About the
	// SSM Document AWS-RunPatchBaseline (http://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-about-aws-runpatchbaseline.html)
	// in the AWS Systems Manager User Guide.
	InstallOverrideList *string `min:"1" type:"string"`

	// The number of patches from the patch baseline that are installed on the instance.
	InstalledCount *int64 `type:"integer"`

	// The number of patches not specified in the patch baseline that are installed
	// on the instance.
	InstalledOtherCount *int64 `type:"integer"`

	// The number of instances with patches installed that are specified in a RejectedPatches
	// list. Patches with a status of InstalledRejected were typically installed
	// before they were added to a RejectedPatches list.
	//
	// If ALLOW_AS_DEPENDENCY is the specified option for RejectedPatchesAction,
	// the value of InstalledRejectedCount will always be 0 (zero).
	InstalledRejectedCount *int64 `type:"integer"`

	// The ID of the managed instance the high-level patch compliance information
	// was collected for.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	// The number of patches from the patch baseline that are applicable for the
	// instance but aren't currently installed.
	MissingCount *int64 `type:"integer"`

	// The number of patches from the patch baseline that aren't applicable for
	// the instance and hence aren't installed on the instance.
	NotApplicableCount *int64 `type:"integer"`

	// The type of patching operation that was performed: SCAN (assess patch compliance
	// state) or INSTALL (install missing patches).
	//
	// Operation is a required field
	Operation *string `type:"string" required:"true" enum:"PatchOperationType"`

	// The time the most recent patching operation completed on the instance.
	//
	// OperationEndTime is a required field
	OperationEndTime *time.Time `type:"timestamp" required:"true"`

	// The time the most recent patching operation was started on the instance.
	//
	// OperationStartTime is a required field
	OperationStartTime *time.Time `type:"timestamp" required:"true"`

	// Placeholder information. This field will always be empty in the current release
	// of the service.
	OwnerInformation *string `min:"1" type:"string" sensitive:"true"`

	// The name of the patch group the managed instance belongs to.
	//
	// PatchGroup is a required field
	PatchGroup *string `min:"1" type:"string" required:"true"`

	// The ID of the patch baseline snapshot used during the patching operation
	// when this compliance data was collected.
	SnapshotId *string `min:"36" type:"string"`
}

// String returns the string representation
func (s InstancePatchState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstancePatchState) GoString() string {
	return s.String()
}

// SetBaselineId sets the BaselineId field's value.
func (s *InstancePatchState) SetBaselineId(v string) *InstancePatchState {
	s.BaselineId = &v
	return s
}

// SetFailedCount sets the FailedCount field's value.
func (s *InstancePatchState) SetFailedCount(v int64) *InstancePatchState {
	s.FailedCount = &v
	return s
}

// SetInstallOverrideList sets the InstallOverrideList field's value.
func (s *InstancePatchState) SetInstallOverrideList(v string) *InstancePatchState {
	s.InstallOverrideList = &v
	return s
}

// SetInstalledCount sets the InstalledCount field's value.
func (s *InstancePatchState) SetInstalledCount(v int64) *InstancePatchState {
	s.InstalledCount = &v
	return s
}

// SetInstalledOtherCount sets the InstalledOtherCount field's value.
func (s *InstancePatchState) SetInstalledOtherCount(v int64) *InstancePatchState {
	s.InstalledOtherCount = &v
	return s
}

// SetInstalledRejectedCount sets the InstalledRejectedCount field's value.
func (s *InstancePatchState) SetInstalledRejectedCount(v int64) *InstancePatchState {
	s.InstalledRejectedCount = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *InstancePatchState) SetInstanceId(v string) *InstancePatchState {
	s.InstanceId = &v
	return s
}

// SetMissingCount sets the MissingCount field's value.
func (s *InstancePatchState) SetMissingCount(v int64) *InstancePatchState {
	s.MissingCount = &v
	return s
}

// SetNotApplicableCount sets the NotApplicableCount field's value.
func (s *InstancePatchState) SetNotApplicableCount(v int64) *InstancePatchState {
	s.NotApplicableCount = &v
	return s
}

// SetOperation sets the Operation field's value.
func (s *InstancePatchState) SetOperation(v string) *InstancePatchState {
	s.Operation = &v
	return s
}

// SetOperationEndTime sets the OperationEndTime field's value.
func (s *InstancePatchState) SetOperationEndTime(v time.Time) *InstancePatchState {
	s.OperationEndTime = &v
	return s
}

// SetOperationStartTime sets the OperationStartTime field's value.
func (s *InstancePatchState) SetOperationStartTime(v time.Time) *InstancePatchState {
	s.OperationStartTime = &v
	return s
}

// SetOwnerInformation sets the OwnerInformation field's value.
func (s *InstancePatchState) SetOwnerInformation(v string) *InstancePatchState {
	s.OwnerInformation = &v
	return s
}

// SetPatchGroup sets the PatchGroup field's value.
func (s *InstancePatchState) SetPatchGroup(v string) *InstancePatchState {
	s.PatchGroup = &v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *InstancePatchState) SetSnapshotId(v string) *InstancePatchState {
	s.SnapshotId = &v
	return s
}

// Defines a filter used in DescribeInstancePatchStatesForPatchGroup used to
// scope down the information returned by the API.
type InstancePatchStateFilter struct {
	_ struct{} `type:"structure"`

	// The key for the filter. Supported values are FailedCount, InstalledCount,
	// InstalledOtherCount, MissingCount and NotApplicableCount.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The type of comparison that should be performed for the value: Equal, NotEqual,
	// LessThan or GreaterThan.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"InstancePatchStateOperatorType"`

	// The value for the filter, must be an integer greater than or equal to 0.
	//
	// Values is a required field
	Values []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s InstancePatchStateFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstancePatchStateFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InstancePatchStateFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InstancePatchStateFilter"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *InstancePatchStateFilter) SetKey(v string) *InstancePatchStateFilter {
	s.Key = &v
	return s
}

// SetType sets the Type field's value.
func (s *InstancePatchStateFilter) SetType(v string) *InstancePatchStateFilter {
	s.Type = &v
	return s
}

// SetValues sets the Values field's value.
func (s *InstancePatchStateFilter) SetValues(v []*string) *InstancePatchStateFilter {
	s.Values = v
	return s
}

// Specifies the inventory type and attribute for the aggregation execution.
type InventoryAggregator struct {
	_ struct{} `type:"structure"`

	// Nested aggregators to further refine aggregation for an inventory type.
	Aggregators []*InventoryAggregator `min:"1" type:"list"`

	// The inventory type and attribute name for aggregation.
	Expression *string `min:"1" type:"string"`

	// A user-defined set of one or more filters on which to aggregate inventory
	// data. Groups return a count of resources that match and don't match the specified
	// criteria.
	Groups []*InventoryGroup `min:"1" type:"list"`
}

// String returns the string representation
func (s InventoryAggregator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InventoryAggregator) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InventoryAggregator) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InventoryAggregator"}
	if s.Aggregators != nil && len(s.Aggregators) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Aggregators", 1))
	}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 1))
	}
	if s.Groups != nil && len(s.Groups) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Groups", 1))
	}
	if s.Aggregators != nil {
		for i, v := range s.Aggregators {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Aggregators", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Groups != nil {
		for i, v := range s.Groups {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Groups", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAggregators sets the Aggregators field's value.
func (s *InventoryAggregator) SetAggregators(v []*InventoryAggregator) *InventoryAggregator {
	s.Aggregators = v
	return s
}

// SetExpression sets the Expression field's value.
func (s *InventoryAggregator) SetExpression(v string) *InventoryAggregator {
	s.Expression = &v
	return s
}

// SetGroups sets the Groups field's value.
func (s *InventoryAggregator) SetGroups(v []*InventoryGroup) *InventoryAggregator {
	s.Groups = v
	return s
}

// Status information returned by the DeleteInventory action.
type InventoryDeletionStatusItem struct {
	_ struct{} `type:"structure"`

	// The deletion ID returned by the DeleteInventory action.
	DeletionId *string `type:"string"`

	// The UTC timestamp when the delete operation started.
	DeletionStartTime *time.Time `type:"timestamp"`

	// Information about the delete operation. For more information about this summary,
	// see Understanding the Delete Inventory Summary (http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-delete.html#sysman-inventory-delete-summary)
	// in the AWS Systems Manager User Guide.
	DeletionSummary *InventoryDeletionSummary `type:"structure"`

	// The status of the operation. Possible values are InProgress and Complete.
	LastStatus *string `type:"string" enum:"InventoryDeletionStatus"`

	// Information about the status.
	LastStatusMessage *string `type:"string"`

	// The UTC timestamp of when the last status report.
	LastStatusUpdateTime *time.Time `type:"timestamp"`

	// The name of the inventory data type.
	TypeName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s InventoryDeletionStatusItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InventoryDeletionStatusItem) GoString() string {
	return s.String()
}

// SetDeletionId sets the DeletionId field's value.
func (s *InventoryDeletionStatusItem) SetDeletionId(v string) *InventoryDeletionStatusItem {
	s.DeletionId = &v
	return s
}

// SetDeletionStartTime sets the DeletionStartTime field's value.
func (s *InventoryDeletionStatusItem) SetDeletionStartTime(v time.Time) *InventoryDeletionStatusItem {
	s.DeletionStartTime = &v
	return s
}

// SetDeletionSummary sets the DeletionSummary field's value.
func (s *InventoryDeletionStatusItem) SetDeletionSummary(v *InventoryDeletionSummary) *InventoryDeletionStatusItem {
	s.DeletionSummary = v
	return s
}

// SetLastStatus sets the LastStatus field's value.
func (s *InventoryDeletionStatusItem) SetLastStatus(v string) *InventoryDeletionStatusItem {
	s.LastStatus = &v
	return s
}

// SetLastStatusMessage sets the LastStatusMessage field's value.
func (s *InventoryDeletionStatusItem) SetLastStatusMessage(v string) *InventoryDeletionStatusItem {
	s.LastStatusMessage = &v
	return s
}

// SetLastStatusUpdateTime sets the LastStatusUpdateTime field's value.
func (s *InventoryDeletionStatusItem) SetLastStatusUpdateTime(v time.Time) *InventoryDeletionStatusItem {
	s.LastStatusUpdateTime = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *InventoryDeletionStatusItem) SetTypeName(v string) *InventoryDeletionStatusItem {
	s.TypeName = &v
	return s
}

// Information about the delete operation.
type InventoryDeletionSummary struct {
	_ struct{} `type:"structure"`

	// Remaining number of items to delete.
	RemainingCount *int64 `type:"integer"`

	// A list of counts and versions for deleted items.
	SummaryItems []*InventoryDeletionSummaryItem `type:"list"`

	// The total number of items to delete. This count does not change during the
	// delete operation.
	TotalCount *int64 `type:"integer"`
}

// String returns the string representation
func (s InventoryDeletionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InventoryDeletionSummary) GoString() string {
	return s.String()
}

// SetRemainingCount sets the RemainingCount field's value.
func (s *InventoryDeletionSummary) SetRemainingCount(v int64) *InventoryDeletionSummary {
	s.RemainingCount = &v
	return s
}

// SetSummaryItems sets the SummaryItems field's value.
func (s *InventoryDeletionSummary) SetSummaryItems(v []*InventoryDeletionSummaryItem) *InventoryDeletionSummary {
	s.SummaryItems = v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *InventoryDeletionSummary) SetTotalCount(v int64) *InventoryDeletionSummary {
	s.TotalCount = &v
	return s
}

// Either a count, remaining count, or a version number in a delete inventory
// summary.
type InventoryDeletionSummaryItem struct {
	_ struct{} `type:"structure"`

	// A count of the number of deleted items.
	Count *int64 `type:"integer"`

	// The remaining number of items to delete.
	RemainingCount *int64 `type:"integer"`

	// The inventory type version.
	Version *string `type:"string"`
}

// String returns the string representation
func (s InventoryDeletionSummaryItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InventoryDeletionSummaryItem) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *InventoryDeletionSummaryItem) SetCount(v int64) *InventoryDeletionSummaryItem {
	s.Count = &v
	return s
}

// SetRemainingCount sets the RemainingCount field's value.
func (s *InventoryDeletionSummaryItem) SetRemainingCount(v int64) *InventoryDeletionSummaryItem {
	s.RemainingCount = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *InventoryDeletionSummaryItem) SetVersion(v string) *InventoryDeletionSummaryItem {
	s.Version = &v
	return s
}

// One or more filters. Use a filter to return a more specific list of results.
type InventoryFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter key.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The type of filter. Valid values include the following: "Equal"|"NotEqual"|"BeginWith"|"LessThan"|"GreaterThan"
	Type *string `type:"string" enum:"InventoryQueryOperatorType"`

	// Inventory filter values. Example: inventory filter where instance IDs are
	// specified as values Key=AWS:InstanceInformation.InstanceId,Values= i-a12b3c4d5e6g,
	// i-1a2b3c4d5e6,Type=Equal
	//
	// Values is a required field
	Values []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s InventoryFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InventoryFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InventoryFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InventoryFilter"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *InventoryFilter) SetKey(v string) *InventoryFilter {
	s.Key = &v
	return s
}

// SetType sets the Type field's value.
func (s *InventoryFilter) SetType(v string) *InventoryFilter {
	s.Type = &v
	return s
}

// SetValues sets the Values field's value.
func (s *InventoryFilter) SetValues(v []*string) *InventoryFilter {
	s.Values = v
	return s
}

// A user-defined set of one or more filters on which to aggregate inventory
// data. Groups return a count of resources that match and don't match the specified
// criteria.
type InventoryGroup struct {
	_ struct{} `type:"structure"`

	// Filters define the criteria for the group. The matchingCount field displays
	// the number of resources that match the criteria. The notMatchingCount field
	// displays the number of resources that don't match the criteria.
	//
	// Filters is a required field
	Filters []*InventoryFilter `min:"1" type:"list" required:"true"`

	// The name of the group.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s InventoryGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InventoryGroup) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InventoryGroup) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InventoryGroup"}
	if s.Filters == nil {
		invalidParams.Add(request.NewErrParamRequired("Filters"))
	}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *InventoryGroup) SetFilters(v []*InventoryFilter) *InventoryGroup {
	s.Filters = v
	return s
}

// SetName sets the Name field's value.
func (s *InventoryGroup) SetName(v string) *InventoryGroup {
	s.Name = &v
	return s
}

// Information collected from managed instances based on your inventory policy
// document
type InventoryItem struct {
	_ struct{} `type:"structure"`

	// The time the inventory information was collected.
	//
	// CaptureTime is a required field
	CaptureTime *string `type:"string" required:"true"`

	// The inventory data of the inventory type.
	Content []map[string]*string `type:"list"`

	// MD5 hash of the inventory item type contents. The content hash is used to
	// determine whether to update inventory information. The PutInventory API does
	// not update the inventory item type contents if the MD5 hash has not changed
	// since last update.
	ContentHash *string `type:"string"`

	// A map of associated properties for a specified inventory type. For example,
	// with this attribute, you can specify the ExecutionId, ExecutionType, ComplianceType
	// properties of the AWS:ComplianceItem type.
	Context map[string]*string `type:"map"`

	// The schema version for the inventory item.
	//
	// SchemaVersion is a required field
	SchemaVersion *string `type:"string" required:"true"`

	// The name of the inventory type. Default inventory item type names start with
	// AWS. Custom inventory type names will start with Custom. Default inventory
	// item types include the following: AWS:AWSComponent, AWS:Application, AWS:InstanceInformation,
	// AWS:Network, and AWS:WindowsUpdate.
	//
	// TypeName is a required field
	TypeName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s InventoryItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InventoryItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InventoryItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InventoryItem"}
	if s.CaptureTime == nil {
		invalidParams.Add(request.NewErrParamRequired("CaptureTime"))
	}
	if s.SchemaVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaVersion"))
	}
	if s.TypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("TypeName"))
	}
	if s.TypeName != nil && len(*s.TypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCaptureTime sets the CaptureTime field's value.
func (s *InventoryItem) SetCaptureTime(v string) *InventoryItem {
	s.CaptureTime = &v
	return s
}

// SetContent sets the Content field's value.
func (s *InventoryItem) SetContent(v []map[string]*string) *InventoryItem {
	s.Content = v
	return s
}

// SetContentHash sets the ContentHash field's value.
func (s *InventoryItem) SetContentHash(v string) *InventoryItem {
	s.ContentHash = &v
	return s
}

// SetContext sets the Context field's value.
func (s *InventoryItem) SetContext(v map[string]*string) *InventoryItem {
	s.Context = v
	return s
}

// SetSchemaVersion sets the SchemaVersion field's value.
func (s *InventoryItem) SetSchemaVersion(v string) *InventoryItem {
	s.SchemaVersion = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *InventoryItem) SetTypeName(v string) *InventoryItem {
	s.TypeName = &v
	return s
}

// Attributes are the entries within the inventory item content. It contains
// name and value.
type InventoryItemAttribute struct {
	_ struct{} `type:"structure"`

	// The data type of the inventory item attribute.
	//
	// DataType is a required field
	DataType *string `type:"string" required:"true" enum:"InventoryAttributeDataType"`

	// Name of the inventory item attribute.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s InventoryItemAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InventoryItemAttribute) GoString() string {
	return s.String()
}

// SetDataType sets the DataType field's value.
func (s *InventoryItemAttribute) SetDataType(v string) *InventoryItemAttribute {
	s.DataType = &v
	return s
}

// SetName sets the Name field's value.
func (s *InventoryItemAttribute) SetName(v string) *InventoryItemAttribute {
	s.Name = &v
	return s
}

// The inventory item schema definition. Users can use this to compose inventory
// query filters.
type InventoryItemSchema struct {
	_ struct{} `type:"structure"`

	// The schema attributes for inventory. This contains data type and attribute
	// name.
	//
	// Attributes is a required field
	Attributes []*InventoryItemAttribute `min:"1" type:"list" required:"true"`

	// The alias name of the inventory type. The alias name is used for display
	// purposes.
	DisplayName *string `type:"string"`

	// The name of the inventory type. Default inventory item type names start with
	// AWS. Custom inventory type names will start with Custom. Default inventory
	// item types include the following: AWS:AWSComponent, AWS:Application, AWS:InstanceInformation,
	// AWS:Network, and AWS:WindowsUpdate.
	//
	// TypeName is a required field
	TypeName *string `min:"1" type:"string" required:"true"`

	// The schema version for the inventory item.
	Version *string `type:"string"`
}

// String returns the string representation
func (s InventoryItemSchema) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InventoryItemSchema) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *InventoryItemSchema) SetAttributes(v []*InventoryItemAttribute) *InventoryItemSchema {
	s.Attributes = v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *InventoryItemSchema) SetDisplayName(v string) *InventoryItemSchema {
	s.DisplayName = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *InventoryItemSchema) SetTypeName(v string) *InventoryItemSchema {
	s.TypeName = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *InventoryItemSchema) SetVersion(v string) *InventoryItemSchema {
	s.Version = &v
	return s
}

// Inventory query results.
type InventoryResultEntity struct {
	_ struct{} `type:"structure"`

	// The data section in the inventory result entity JSON.
	Data map[string]*InventoryResultItem `type:"map"`

	// ID of the inventory result entity. For example, for managed instance inventory
	// the result will be the managed instance ID. For EC2 instance inventory, the
	// result will be the instance ID.
	Id *string `type:"string"`
}

// String returns the string representation
func (s InventoryResultEntity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InventoryResultEntity) GoString() string {
	return s.String()
}

// SetData sets the Data field's value.
func (s *InventoryResultEntity) SetData(v map[string]*InventoryResultItem) *InventoryResultEntity {
	s.Data = v
	return s
}

// SetId sets the Id field's value.
func (s *InventoryResultEntity) SetId(v string) *InventoryResultEntity {
	s.Id = &v
	return s
}

// The inventory result item.
type InventoryResultItem struct {
	_ struct{} `type:"structure"`

	// The time inventory item data was captured.
	CaptureTime *string `type:"string"`

	// Contains all the inventory data of the item type. Results include attribute
	// names and values.
	//
	// Content is a required field
	Content []map[string]*string `type:"list" required:"true"`

	// MD5 hash of the inventory item type contents. The content hash is used to
	// determine whether to update inventory information. The PutInventory API does
	// not update the inventory item type contents if the MD5 hash has not changed
	// since last update.
	ContentHash *string `type:"string"`

	// The schema version for the inventory result item/
	//
	// SchemaVersion is a required field
	SchemaVersion *string `type:"string" required:"true"`

	// The name of the inventory result item type.
	//
	// TypeName is a required field
	TypeName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s InventoryResultItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InventoryResultItem) GoString() string {
	return s.String()
}

// SetCaptureTime sets the CaptureTime field's value.
func (s *InventoryResultItem) SetCaptureTime(v string) *InventoryResultItem {
	s.CaptureTime = &v
	return s
}

// SetContent sets the Content field's value.
func (s *InventoryResultItem) SetContent(v []map[string]*string) *InventoryResultItem {
	s.Content = v
	return s
}

// SetContentHash sets the ContentHash field's value.
func (s *InventoryResultItem) SetContentHash(v string) *InventoryResultItem {
	s.ContentHash = &v
	return s
}

// SetSchemaVersion sets the SchemaVersion field's value.
func (s *InventoryResultItem) SetSchemaVersion(v string) *InventoryResultItem {
	s.SchemaVersion = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *InventoryResultItem) SetTypeName(v string) *InventoryResultItem {
	s.TypeName = &v
	return s
}

type LabelParameterVersionInput struct {
	_ struct{} `type:"structure"`

	// One or more labels to attach to the specified parameter version.
	//
	// Labels is a required field
	Labels []*string `min:"1" type:"list" required:"true"`

	// The parameter name on which you want to attach one or more labels.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The specific version of the parameter on which you want to attach one or
	// more labels. If no version is specified, the system attaches the label to
	// the latest version.)
	ParameterVersion *int64 `type:"long"`
}

// String returns the string representation
func (s LabelParameterVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LabelParameterVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LabelParameterVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LabelParameterVersionInput"}
	if s.Labels == nil {
		invalidParams.Add(request.NewErrParamRequired("Labels"))
	}
	if s.Labels != nil && len(s.Labels) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Labels", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLabels sets the Labels field's value.
func (s *LabelParameterVersionInput) SetLabels(v []*string) *LabelParameterVersionInput {
	s.Labels = v
	return s
}

// SetName sets the Name field's value.
func (s *LabelParameterVersionInput) SetName(v string) *LabelParameterVersionInput {
	s.Name = &v
	return s
}

// SetParameterVersion sets the ParameterVersion field's value.
func (s *LabelParameterVersionInput) SetParameterVersion(v int64) *LabelParameterVersionInput {
	s.ParameterVersion = &v
	return s
}

type LabelParameterVersionOutput struct {
	_ struct{} `type:"structure"`

	// The label does not meet the requirements. For information about parameter
	// label requirements, see Labeling Parameters (http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-labels.html)
	// in the AWS Systems Manager User Guide.
	InvalidLabels []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s LabelParameterVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LabelParameterVersionOutput) GoString() string {
	return s.String()
}

// SetInvalidLabels sets the InvalidLabels field's value.
func (s *LabelParameterVersionOutput) SetInvalidLabels(v []*string) *LabelParameterVersionOutput {
	s.InvalidLabels = v
	return s
}

type ListAssociationVersionsInput struct {
	_ struct{} `type:"structure"`

	// The association ID for which you want to view all versions.
	//
	// AssociationId is a required field
	AssociationId *string `type:"string" required:"true"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token to start the list. Use this token to get the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAssociationVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssociationVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssociationVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAssociationVersionsInput"}
	if s.AssociationId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssociationId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssociationId sets the AssociationId field's value.
func (s *ListAssociationVersionsInput) SetAssociationId(v string) *ListAssociationVersionsInput {
	s.AssociationId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAssociationVersionsInput) SetMaxResults(v int64) *ListAssociationVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssociationVersionsInput) SetNextToken(v string) *ListAssociationVersionsInput {
	s.NextToken = &v
	return s
}

type ListAssociationVersionsOutput struct {
	_ struct{} `type:"structure"`

	// Information about all versions of the association for the specified association
	// ID.
	AssociationVersions []*AssociationVersionInfo `min:"1" type:"list"`

	// The token for the next set of items to return. Use this token to get the
	// next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAssociationVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssociationVersionsOutput) GoString() string {
	return s.String()
}

// SetAssociationVersions sets the AssociationVersions field's value.
func (s *ListAssociationVersionsOutput) SetAssociationVersions(v []*AssociationVersionInfo) *ListAssociationVersionsOutput {
	s.AssociationVersions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssociationVersionsOutput) SetNextToken(v string) *ListAssociationVersionsOutput {
	s.NextToken = &v
	return s
}

type ListAssociationsInput struct {
	_ struct{} `type:"structure"`

	// One or more filters. Use a filter to return a more specific list of results.
	AssociationFilterList []*AssociationFilter `min:"1" type:"list"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAssociationsInput"}
	if s.AssociationFilterList != nil && len(s.AssociationFilterList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssociationFilterList", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.AssociationFilterList != nil {
		for i, v := range s.AssociationFilterList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AssociationFilterList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssociationFilterList sets the AssociationFilterList field's value.
func (s *ListAssociationsInput) SetAssociationFilterList(v []*AssociationFilter) *ListAssociationsInput {
	s.AssociationFilterList = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAssociationsInput) SetMaxResults(v int64) *ListAssociationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssociationsInput) SetNextToken(v string) *ListAssociationsInput {
	s.NextToken = &v
	return s
}

type ListAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// The associations.
	Associations []*Association `type:"list"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssociationsOutput) GoString() string {
	return s.String()
}

// SetAssociations sets the Associations field's value.
func (s *ListAssociationsOutput) SetAssociations(v []*Association) *ListAssociationsOutput {
	s.Associations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssociationsOutput) SetNextToken(v string) *ListAssociationsOutput {
	s.NextToken = &v
	return s
}

type ListCommandInvocationsInput struct {
	_ struct{} `type:"structure"`

	// (Optional) The invocations for a specific command ID.
	CommandId *string `min:"36" type:"string"`

	// (Optional) If set this returns the response of the command executions and
	// any command output. By default this is set to False.
	Details *bool `type:"boolean"`

	// (Optional) One or more filters. Use a filter to return a more specific list
	// of results.
	Filters []*CommandFilter `min:"1" type:"list"`

	// (Optional) The command execution details for a specific instance ID.
	InstanceId *string `type:"string"`

	// (Optional) The maximum number of items to return for this call. The call
	// also returns a token that you can specify in a subsequent call to get the
	// next set of results.
	MaxResults *int64 `min:"1" type:"integer"`

	// (Optional) The token for the next set of items to return. (You received this
	// token from a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListCommandInvocationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCommandInvocationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCommandInvocationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCommandInvocationsInput"}
	if s.CommandId != nil && len(*s.CommandId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CommandId", 36))
	}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCommandId sets the CommandId field's value.
func (s *ListCommandInvocationsInput) SetCommandId(v string) *ListCommandInvocationsInput {
	s.CommandId = &v
	return s
}

// SetDetails sets the Details field's value.
func (s *ListCommandInvocationsInput) SetDetails(v bool) *ListCommandInvocationsInput {
	s.Details = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *ListCommandInvocationsInput) SetFilters(v []*CommandFilter) *ListCommandInvocationsInput {
	s.Filters = v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *ListCommandInvocationsInput) SetInstanceId(v string) *ListCommandInvocationsInput {
	s.InstanceId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCommandInvocationsInput) SetMaxResults(v int64) *ListCommandInvocationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCommandInvocationsInput) SetNextToken(v string) *ListCommandInvocationsInput {
	s.NextToken = &v
	return s
}

type ListCommandInvocationsOutput struct {
	_ struct{} `type:"structure"`

	// (Optional) A list of all invocations.
	CommandInvocations []*CommandInvocation `type:"list"`

	// (Optional) The token for the next set of items to return. (You received this
	// token from a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListCommandInvocationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCommandInvocationsOutput) GoString() string {
	return s.String()
}

// SetCommandInvocations sets the CommandInvocations field's value.
func (s *ListCommandInvocationsOutput) SetCommandInvocations(v []*CommandInvocation) *ListCommandInvocationsOutput {
	s.CommandInvocations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCommandInvocationsOutput) SetNextToken(v string) *ListCommandInvocationsOutput {
	s.NextToken = &v
	return s
}

type ListCommandsInput struct {
	_ struct{} `type:"structure"`

	// (Optional) If provided, lists only the specified command.
	CommandId *string `min:"36" type:"string"`

	// (Optional) One or more filters. Use a filter to return a more specific list
	// of results.
	Filters []*CommandFilter `min:"1" type:"list"`

	// (Optional) Lists commands issued against this instance ID.
	InstanceId *string `type:"string"`

	// (Optional) The maximum number of items to return for this call. The call
	// also returns a token that you can specify in a subsequent call to get the
	// next set of results.
	MaxResults *int64 `min:"1" type:"integer"`

	// (Optional) The token for the next set of items to return. (You received this
	// token from a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListCommandsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCommandsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCommandsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCommandsInput"}
	if s.CommandId != nil && len(*s.CommandId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CommandId", 36))
	}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCommandId sets the CommandId field's value.
func (s *ListCommandsInput) SetCommandId(v string) *ListCommandsInput {
	s.CommandId = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *ListCommandsInput) SetFilters(v []*CommandFilter) *ListCommandsInput {
	s.Filters = v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *ListCommandsInput) SetInstanceId(v string) *ListCommandsInput {
	s.InstanceId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCommandsInput) SetMaxResults(v int64) *ListCommandsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCommandsInput) SetNextToken(v string) *ListCommandsInput {
	s.NextToken = &v
	return s
}

type ListCommandsOutput struct {
	_ struct{} `type:"structure"`

	// (Optional) The list of commands requested by the user.
	Commands []*Command `type:"list"`

	// (Optional) The token for the next set of items to return. (You received this
	// token from a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListCommandsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCommandsOutput) GoString() string {
	return s.String()
}

// SetCommands sets the Commands field's value.
func (s *ListCommandsOutput) SetCommands(v []*Command) *ListCommandsOutput {
	s.Commands = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCommandsOutput) SetNextToken(v string) *ListCommandsOutput {
	s.NextToken = &v
	return s
}

type ListComplianceItemsInput struct {
	_ struct{} `type:"structure"`

	// One or more compliance filters. Use a filter to return a more specific list
	// of results.
	Filters []*ComplianceStringFilter `type:"list"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token to start the list. Use this token to get the next set of results.
	NextToken *string `type:"string"`

	// The ID for the resources from which to get compliance information. Currently,
	// you can only specify one resource ID.
	ResourceIds []*string `min:"1" type:"list"`

	// The type of resource from which to get compliance information. Currently,
	// the only supported resource type is ManagedInstance.
	ResourceTypes []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s ListComplianceItemsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListComplianceItemsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListComplianceItemsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListComplianceItemsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceIds != nil && len(s.ResourceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceIds", 1))
	}
	if s.ResourceTypes != nil && len(s.ResourceTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceTypes", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListComplianceItemsInput) SetFilters(v []*ComplianceStringFilter) *ListComplianceItemsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListComplianceItemsInput) SetMaxResults(v int64) *ListComplianceItemsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListComplianceItemsInput) SetNextToken(v string) *ListComplianceItemsInput {
	s.NextToken = &v
	return s
}

// SetResourceIds sets the ResourceIds field's value.
func (s *ListComplianceItemsInput) SetResourceIds(v []*string) *ListComplianceItemsInput {
	s.ResourceIds = v
	return s
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *ListComplianceItemsInput) SetResourceTypes(v []*string) *ListComplianceItemsInput {
	s.ResourceTypes = v
	return s
}

type ListComplianceItemsOutput struct {
	_ struct{} `type:"structure"`

	// A list of compliance information for the specified resource ID.
	ComplianceItems []*ComplianceItem `type:"list"`

	// The token for the next set of items to return. Use this token to get the
	// next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListComplianceItemsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListComplianceItemsOutput) GoString() string {
	return s.String()
}

// SetComplianceItems sets the ComplianceItems field's value.
func (s *ListComplianceItemsOutput) SetComplianceItems(v []*ComplianceItem) *ListComplianceItemsOutput {
	s.ComplianceItems = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListComplianceItemsOutput) SetNextToken(v string) *ListComplianceItemsOutput {
	s.NextToken = &v
	return s
}

type ListComplianceSummariesInput struct {
	_ struct{} `type:"structure"`

	// One or more compliance or inventory filters. Use a filter to return a more
	// specific list of results.
	Filters []*ComplianceStringFilter `type:"list"`

	// The maximum number of items to return for this call. Currently, you can specify
	// null or 50. The call also returns a token that you can specify in a subsequent
	// call to get the next set of results.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token to start the list. Use this token to get the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListComplianceSummariesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListComplianceSummariesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListComplianceSummariesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListComplianceSummariesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListComplianceSummariesInput) SetFilters(v []*ComplianceStringFilter) *ListComplianceSummariesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListComplianceSummariesInput) SetMaxResults(v int64) *ListComplianceSummariesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListComplianceSummariesInput) SetNextToken(v string) *ListComplianceSummariesInput {
	s.NextToken = &v
	return s
}

type ListComplianceSummariesOutput struct {
	_ struct{} `type:"structure"`

	// A list of compliant and non-compliant summary counts based on compliance
	// types. For example, this call returns State Manager associations, patches,
	// or custom compliance types according to the filter criteria that you specified.
	ComplianceSummaryItems []*ComplianceSummaryItem `type:"list"`

	// The token for the next set of items to return. Use this token to get the
	// next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListComplianceSummariesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListComplianceSummariesOutput) GoString() string {
	return s.String()
}

// SetComplianceSummaryItems sets the ComplianceSummaryItems field's value.
func (s *ListComplianceSummariesOutput) SetComplianceSummaryItems(v []*ComplianceSummaryItem) *ListComplianceSummariesOutput {
	s.ComplianceSummaryItems = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListComplianceSummariesOutput) SetNextToken(v string) *ListComplianceSummariesOutput {
	s.NextToken = &v
	return s
}

type ListDocumentVersionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The name of the document about which you want version information.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListDocumentVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDocumentVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDocumentVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDocumentVersionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDocumentVersionsInput) SetMaxResults(v int64) *ListDocumentVersionsInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListDocumentVersionsInput) SetName(v string) *ListDocumentVersionsInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDocumentVersionsInput) SetNextToken(v string) *ListDocumentVersionsInput {
	s.NextToken = &v
	return s
}

type ListDocumentVersionsOutput struct {
	_ struct{} `type:"structure"`

	// The document versions.
	DocumentVersions []*DocumentVersionInfo `min:"1" type:"list"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListDocumentVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDocumentVersionsOutput) GoString() string {
	return s.String()
}

// SetDocumentVersions sets the DocumentVersions field's value.
func (s *ListDocumentVersionsOutput) SetDocumentVersions(v []*DocumentVersionInfo) *ListDocumentVersionsOutput {
	s.DocumentVersions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDocumentVersionsOutput) SetNextToken(v string) *ListDocumentVersionsOutput {
	s.NextToken = &v
	return s
}

type ListDocumentsInput struct {
	_ struct{} `type:"structure"`

	// One or more filters. Use a filter to return a more specific list of results.
	DocumentFilterList []*DocumentFilter `min:"1" type:"list"`

	// One or more filters. Use a filter to return a more specific list of results.
	Filters []*DocumentKeyValuesFilter `type:"list"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListDocumentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDocumentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDocumentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDocumentsInput"}
	if s.DocumentFilterList != nil && len(s.DocumentFilterList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentFilterList", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.DocumentFilterList != nil {
		for i, v := range s.DocumentFilterList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DocumentFilterList", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocumentFilterList sets the DocumentFilterList field's value.
func (s *ListDocumentsInput) SetDocumentFilterList(v []*DocumentFilter) *ListDocumentsInput {
	s.DocumentFilterList = v
	return s
}

// SetFilters sets the Filters field's value.
func (s *ListDocumentsInput) SetFilters(v []*DocumentKeyValuesFilter) *ListDocumentsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDocumentsInput) SetMaxResults(v int64) *ListDocumentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDocumentsInput) SetNextToken(v string) *ListDocumentsInput {
	s.NextToken = &v
	return s
}

type ListDocumentsOutput struct {
	_ struct{} `type:"structure"`

	// The names of the Systems Manager documents.
	DocumentIdentifiers []*DocumentIdentifier `type:"list"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListDocumentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDocumentsOutput) GoString() string {
	return s.String()
}

// SetDocumentIdentifiers sets the DocumentIdentifiers field's value.
func (s *ListDocumentsOutput) SetDocumentIdentifiers(v []*DocumentIdentifier) *ListDocumentsOutput {
	s.DocumentIdentifiers = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDocumentsOutput) SetNextToken(v string) *ListDocumentsOutput {
	s.NextToken = &v
	return s
}

type ListInventoryEntriesInput struct {
	_ struct{} `type:"structure"`

	// One or more filters. Use a filter to return a more specific list of results.
	Filters []*InventoryFilter `min:"1" type:"list"`

	// The instance ID for which you want inventory information.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	// The type of inventory item for which you want information.
	//
	// TypeName is a required field
	TypeName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListInventoryEntriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInventoryEntriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInventoryEntriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInventoryEntriesInput"}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.TypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("TypeName"))
	}
	if s.TypeName != nil && len(*s.TypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TypeName", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListInventoryEntriesInput) SetFilters(v []*InventoryFilter) *ListInventoryEntriesInput {
	s.Filters = v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *ListInventoryEntriesInput) SetInstanceId(v string) *ListInventoryEntriesInput {
	s.InstanceId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListInventoryEntriesInput) SetMaxResults(v int64) *ListInventoryEntriesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInventoryEntriesInput) SetNextToken(v string) *ListInventoryEntriesInput {
	s.NextToken = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *ListInventoryEntriesInput) SetTypeName(v string) *ListInventoryEntriesInput {
	s.TypeName = &v
	return s
}

type ListInventoryEntriesOutput struct {
	_ struct{} `type:"structure"`

	// The time that inventory information was collected for the instance(s).
	CaptureTime *string `type:"string"`

	// A list of inventory items on the instance(s).
	Entries []map[string]*string `type:"list"`

	// The instance ID targeted by the request to query inventory information.
	InstanceId *string `type:"string"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`

	// The inventory schema version used by the instance(s).
	SchemaVersion *string `type:"string"`

	// The type of inventory item returned by the request.
	TypeName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListInventoryEntriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInventoryEntriesOutput) GoString() string {
	return s.String()
}

// SetCaptureTime sets the CaptureTime field's value.
func (s *ListInventoryEntriesOutput) SetCaptureTime(v string) *ListInventoryEntriesOutput {
	s.CaptureTime = &v
	return s
}

// SetEntries sets the Entries field's value.
func (s *ListInventoryEntriesOutput) SetEntries(v []map[string]*string) *ListInventoryEntriesOutput {
	s.Entries = v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *ListInventoryEntriesOutput) SetInstanceId(v string) *ListInventoryEntriesOutput {
	s.InstanceId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInventoryEntriesOutput) SetNextToken(v string) *ListInventoryEntriesOutput {
	s.NextToken = &v
	return s
}

// SetSchemaVersion sets the SchemaVersion field's value.
func (s *ListInventoryEntriesOutput) SetSchemaVersion(v string) *ListInventoryEntriesOutput {
	s.SchemaVersion = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *ListInventoryEntriesOutput) SetTypeName(v string) *ListInventoryEntriesOutput {
	s.TypeName = &v
	return s
}

type ListResourceComplianceSummariesInput struct {
	_ struct{} `type:"structure"`

	// One or more filters. Use a filter to return a more specific list of results.
	Filters []*ComplianceStringFilter `type:"list"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token to start the list. Use this token to get the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListResourceComplianceSummariesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourceComplianceSummariesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourceComplianceSummariesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResourceComplianceSummariesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListResourceComplianceSummariesInput) SetFilters(v []*ComplianceStringFilter) *ListResourceComplianceSummariesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResourceComplianceSummariesInput) SetMaxResults(v int64) *ListResourceComplianceSummariesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceComplianceSummariesInput) SetNextToken(v string) *ListResourceComplianceSummariesInput {
	s.NextToken = &v
	return s
}

type ListResourceComplianceSummariesOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of items to return. Use this token to get the
	// next set of results.
	NextToken *string `type:"string"`

	// A summary count for specified or targeted managed instances. Summary count
	// includes information about compliant and non-compliant State Manager associations,
	// patch status, or custom items according to the filter criteria that you specify.
	ResourceComplianceSummaryItems []*ResourceComplianceSummaryItem `type:"list"`
}

// String returns the string representation
func (s ListResourceComplianceSummariesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourceComplianceSummariesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceComplianceSummariesOutput) SetNextToken(v string) *ListResourceComplianceSummariesOutput {
	s.NextToken = &v
	return s
}

// SetResourceComplianceSummaryItems sets the ResourceComplianceSummaryItems field's value.
func (s *ListResourceComplianceSummariesOutput) SetResourceComplianceSummaryItems(v []*ResourceComplianceSummaryItem) *ListResourceComplianceSummariesOutput {
	s.ResourceComplianceSummaryItems = v
	return s
}

type ListResourceDataSyncInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token to start the list. Use this token to get the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListResourceDataSyncInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourceDataSyncInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourceDataSyncInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResourceDataSyncInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResourceDataSyncInput) SetMaxResults(v int64) *ListResourceDataSyncInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceDataSyncInput) SetNextToken(v string) *ListResourceDataSyncInput {
	s.NextToken = &v
	return s
}

type ListResourceDataSyncOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of items to return. Use this token to get the
	// next set of results.
	NextToken *string `type:"string"`

	// A list of your current Resource Data Sync configurations and their statuses.
	ResourceDataSyncItems []*ResourceDataSyncItem `type:"list"`
}

// String returns the string representation
func (s ListResourceDataSyncOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourceDataSyncOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceDataSyncOutput) SetNextToken(v string) *ListResourceDataSyncOutput {
	s.NextToken = &v
	return s
}

// SetResourceDataSyncItems sets the ResourceDataSyncItems field's value.
func (s *ListResourceDataSyncOutput) SetResourceDataSyncItems(v []*ResourceDataSyncItem) *ListResourceDataSyncOutput {
	s.ResourceDataSyncItems = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The resource ID for which you want to see a list of tags.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// Returns a list of tags for a specific resource type.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true" enum:"ResourceTypeForTagging"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *ListTagsForResourceInput) SetResourceId(v string) *ListTagsForResourceInput {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ListTagsForResourceInput) SetResourceType(v string) *ListTagsForResourceInput {
	s.ResourceType = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A list of tags.
	TagList []*Tag `type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTagList sets the TagList field's value.
func (s *ListTagsForResourceOutput) SetTagList(v []*Tag) *ListTagsForResourceOutput {
	s.TagList = v
	return s
}

// Information about an Amazon S3 bucket to write instance-level logs to.
//
// LoggingInfo has been deprecated. To specify an S3 bucket to contain logs,
// instead use the OutputS3BucketName and OutputS3KeyPrefix options in the TaskInvocationParameters
// structure. For information about how Systems Manager handles these options
// for the supported Maintenance Window task types, see MaintenanceWindowTaskInvocationParameters.
type LoggingInfo struct {
	_ struct{} `type:"structure"`

	// The name of an Amazon S3 bucket where execution logs are stored .
	//
	// S3BucketName is a required field
	S3BucketName *string `min:"3" type:"string" required:"true"`

	// (Optional) The Amazon S3 bucket subfolder.
	S3KeyPrefix *string `type:"string"`

	// The region where the Amazon S3 bucket is located.
	//
	// S3Region is a required field
	S3Region *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s LoggingInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoggingInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoggingInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LoggingInfo"}
	if s.S3BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("S3BucketName"))
	}
	if s.S3BucketName != nil && len(*s.S3BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("S3BucketName", 3))
	}
	if s.S3Region == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Region"))
	}
	if s.S3Region != nil && len(*s.S3Region) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("S3Region", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *LoggingInfo) SetS3BucketName(v string) *LoggingInfo {
	s.S3BucketName = &v
	return s
}

// SetS3KeyPrefix sets the S3KeyPrefix field's value.
func (s *LoggingInfo) SetS3KeyPrefix(v string) *LoggingInfo {
	s.S3KeyPrefix = &v
	return s
}

// SetS3Region sets the S3Region field's value.
func (s *LoggingInfo) SetS3Region(v string) *LoggingInfo {
	s.S3Region = &v
	return s
}

// The parameters for an AUTOMATION task type.
type MaintenanceWindowAutomationParameters struct {
	_ struct{} `type:"structure"`

	// The version of an Automation document to use during task execution.
	DocumentVersion *string `type:"string"`

	// The parameters for the AUTOMATION task.
	//
	// For information about specifying and updating task parameters, see RegisterTaskWithMaintenanceWindow
	// and UpdateMaintenanceWindowTask.
	//
	// LoggingInfo has been deprecated. To specify an S3 bucket to contain logs,
	// instead use the OutputS3BucketName and OutputS3KeyPrefix options in the TaskInvocationParameters
	// structure. For information about how Systems Manager handles these options
	// for the supported Maintenance Window task types, see MaintenanceWindowTaskInvocationParameters.
	//
	// TaskParameters has been deprecated. To specify parameters to pass to a task
	// when it runs, instead use the Parameters option in the TaskInvocationParameters
	// structure. For information about how Systems Manager handles these options
	// for the supported Maintenance Window task types, see MaintenanceWindowTaskInvocationParameters.
	//
	// For AUTOMATION task types, Systems Manager ignores any values specified for
	// these parameters.
	Parameters map[string][]*string `min:"1" type:"map"`
}

// String returns the string representation
func (s MaintenanceWindowAutomationParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MaintenanceWindowAutomationParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MaintenanceWindowAutomationParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MaintenanceWindowAutomationParameters"}
	if s.Parameters != nil && len(s.Parameters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Parameters", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocumentVersion sets the DocumentVersion field's value.
func (s *MaintenanceWindowAutomationParameters) SetDocumentVersion(v string) *MaintenanceWindowAutomationParameters {
	s.DocumentVersion = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *MaintenanceWindowAutomationParameters) SetParameters(v map[string][]*string) *MaintenanceWindowAutomationParameters {
	s.Parameters = v
	return s
}

// Describes the information about an execution of a Maintenance Window.
type MaintenanceWindowExecution struct {
	_ struct{} `type:"structure"`

	// The time the execution finished.
	EndTime *time.Time `type:"timestamp"`

	// The time the execution started.
	StartTime *time.Time `type:"timestamp"`

	// The status of the execution.
	Status *string `type:"string" enum:"MaintenanceWindowExecutionStatus"`

	// The details explaining the Status. Only available for certain status values.
	StatusDetails *string `type:"string"`

	// The ID of the Maintenance Window execution.
	WindowExecutionId *string `min:"36" type:"string"`

	// The ID of the Maintenance Window.
	WindowId *string `min:"20" type:"string"`
}

// String returns the string representation
func (s MaintenanceWindowExecution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MaintenanceWindowExecution) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *MaintenanceWindowExecution) SetEndTime(v time.Time) *MaintenanceWindowExecution {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *MaintenanceWindowExecution) SetStartTime(v time.Time) *MaintenanceWindowExecution {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *MaintenanceWindowExecution) SetStatus(v string) *MaintenanceWindowExecution {
	s.Status = &v
	return s
}

// SetStatusDetails sets the StatusDetails field's value.
func (s *MaintenanceWindowExecution) SetStatusDetails(v string) *MaintenanceWindowExecution {
	s.StatusDetails = &v
	return s
}

// SetWindowExecutionId sets the WindowExecutionId field's value.
func (s *MaintenanceWindowExecution) SetWindowExecutionId(v string) *MaintenanceWindowExecution {
	s.WindowExecutionId = &v
	return s
}

// SetWindowId sets the WindowId field's value.
func (s *MaintenanceWindowExecution) SetWindowId(v string) *MaintenanceWindowExecution {
	s.WindowId = &v
	return s
}

// Information about a task execution performed as part of a Maintenance Window
// execution.
type MaintenanceWindowExecutionTaskIdentity struct {
	_ struct{} `type:"structure"`

	// The time the task execution finished.
	EndTime *time.Time `type:"timestamp"`

	// The time the task execution started.
	StartTime *time.Time `type:"timestamp"`

	// The status of the task execution.
	Status *string `type:"string" enum:"MaintenanceWindowExecutionStatus"`

	// The details explaining the status of the task execution. Only available for
	// certain status values.
	StatusDetails *string `type:"string"`

	// The ARN of the executed task.
	TaskArn *string `min:"1" type:"string"`

	// The ID of the specific task execution in the Maintenance Window execution.
	TaskExecutionId *string `min:"36" type:"string"`

	// The type of executed task.
	TaskType *string `type:"string" enum:"MaintenanceWindowTaskType"`

	// The ID of the Maintenance Window execution that ran the task.
	WindowExecutionId *string `min:"36" type:"string"`
}

// String returns the string representation
func (s MaintenanceWindowExecutionTaskIdentity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MaintenanceWindowExecutionTaskIdentity) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *MaintenanceWindowExecutionTaskIdentity) SetEndTime(v time.Time) *MaintenanceWindowExecutionTaskIdentity {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *MaintenanceWindowExecutionTaskIdentity) SetStartTime(v time.Time) *MaintenanceWindowExecutionTaskIdentity {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *MaintenanceWindowExecutionTaskIdentity) SetStatus(v string) *MaintenanceWindowExecutionTaskIdentity {
	s.Status = &v
	return s
}

// SetStatusDetails sets the StatusDetails field's value.
func (s *MaintenanceWindowExecutionTaskIdentity) SetStatusDetails(v string) *MaintenanceWindowExecutionTaskIdentity {
	s.StatusDetails = &v
	return s
}

// SetTaskArn sets the TaskArn field's value.
func (s *MaintenanceWindowExecutionTaskIdentity) SetTaskArn(v string) *MaintenanceWindowExecutionTaskIdentity {
	s.TaskArn = &v
	return s
}

// SetTaskExecutionId sets the TaskExecutionId field's value.
func (s *MaintenanceWindowExecutionTaskIdentity) SetTaskExecutionId(v string) *MaintenanceWindowExecutionTaskIdentity {
	s.TaskExecutionId = &v
	return s
}

// SetTaskType sets the TaskType field's value.
func (s *MaintenanceWindowExecutionTaskIdentity) SetTaskType(v string) *MaintenanceWindowExecutionTaskIdentity {
	s.TaskType = &v
	return s
}

// SetWindowExecutionId sets the WindowExecutionId field's value.
func (s *MaintenanceWindowExecutionTaskIdentity) SetWindowExecutionId(v string) *MaintenanceWindowExecutionTaskIdentity {
	s.WindowExecutionId = &v
	return s
}

// Describes the information about a task invocation for a particular target
// as part of a task execution performed as part of a Maintenance Window execution.
type MaintenanceWindowExecutionTaskInvocationIdentity struct {
	_ struct{} `type:"structure"`

	// The time the invocation finished.
	EndTime *time.Time `type:"timestamp"`

	// The ID of the action performed in the service that actually handled the task
	// invocation. If the task type is RUN_COMMAND, this value is the command ID.
	ExecutionId *string `type:"string"`

	// The ID of the task invocation.
	InvocationId *string `min:"36" type:"string"`

	// User-provided value that was specified when the target was registered with
	// the Maintenance Window. This was also included in any CloudWatch events raised
	// during the task invocation.
	OwnerInformation *string `min:"1" type:"string" sensitive:"true"`

	// The parameters that were provided for the invocation when it was executed.
	Parameters *string `type:"string" sensitive:"true"`

	// The time the invocation started.
	StartTime *time.Time `type:"timestamp"`

	// The status of the task invocation.
	Status *string `type:"string" enum:"MaintenanceWindowExecutionStatus"`

	// The details explaining the status of the task invocation. Only available
	// for certain Status values.
	StatusDetails *string `type:"string"`

	// The ID of the specific task execution in the Maintenance Window execution.
	TaskExecutionId *string `min:"36" type:"string"`

	// The task type.
	TaskType *string `type:"string" enum:"MaintenanceWindowTaskType"`

	// The ID of the Maintenance Window execution that ran the task.
	WindowExecutionId *string `min:"36" type:"string"`

	// The ID of the target definition in this Maintenance Window the invocation
	// was performed for.
	WindowTargetId *string `type:"string"`
}

// String returns the string representation
func (s MaintenanceWindowExecutionTaskInvocationIdentity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MaintenanceWindowExecutionTaskInvocationIdentity) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *MaintenanceWindowExecutionTaskInvocationIdentity) SetEndTime(v time.Time) *MaintenanceWindowExecutionTaskInvocationIdentity {
	s.EndTime = &v
	return s
}

// SetExecutionId sets the ExecutionId field's value.
func (s *MaintenanceWindowExecutionTaskInvocationIdentity) SetExecutionId(v string) *MaintenanceWindowExecutionTaskInvocationIdentity {
	s.ExecutionId = &v
	return s
}

// SetInvocationId sets the InvocationId field's value.
func (s *MaintenanceWindowExecutionTaskInvocationIdentity) SetInvocationId(v string) *MaintenanceWindowExecutionTaskInvocationIdentity {
	s.InvocationId = &v
	return s
}

// SetOwnerInformation sets the OwnerInformation field's value.
func (s *MaintenanceWindowExecutionTaskInvocationIdentity) SetOwnerInformation(v string) *MaintenanceWindowExecutionTaskInvocationIdentity {
	s.OwnerInformation = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *MaintenanceWindowExecutionTaskInvocationIdentity) SetParameters(v string) *MaintenanceWindowExecutionTaskInvocationIdentity {
	s.Parameters = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *MaintenanceWindowExecutionTaskInvocationIdentity) SetStartTime(v time.Time) *MaintenanceWindowExecutionTaskInvocationIdentity {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *MaintenanceWindowExecutionTaskInvocationIdentity) SetStatus(v string) *MaintenanceWindowExecutionTaskInvocationIdentity {
	s.Status = &v
	return s
}

// SetStatusDetails sets the StatusDetails field's value.
func (s *MaintenanceWindowExecutionTaskInvocationIdentity) SetStatusDetails(v string) *MaintenanceWindowExecutionTaskInvocationIdentity {
	s.StatusDetails = &v
	return s
}

// SetTaskExecutionId sets the TaskExecutionId field's value.
func (s *MaintenanceWindowExecutionTaskInvocationIdentity) SetTaskExecutionId(v string) *MaintenanceWindowExecutionTaskInvocationIdentity {
	s.TaskExecutionId = &v
	return s
}

// SetTaskType sets the TaskType field's value.
func (s *MaintenanceWindowExecutionTaskInvocationIdentity) SetTaskType(v string) *MaintenanceWindowExecutionTaskInvocationIdentity {
	s.TaskType = &v
	return s
}

// SetWindowExecutionId sets the WindowExecutionId field's value.
func (s *MaintenanceWindowExecutionTaskInvocationIdentity) SetWindowExecutionId(v string) *MaintenanceWindowExecutionTaskInvocationIdentity {
	s.WindowExecutionId = &v
	return s
}

// SetWindowTargetId sets the WindowTargetId field's value.
func (s *MaintenanceWindowExecutionTaskInvocationIdentity) SetWindowTargetId(v string) *MaintenanceWindowExecutionTaskInvocationIdentity {
	s.WindowTargetId = &v
	return s
}

// Filter used in the request. Supported filter keys are Name and Enabled.
type MaintenanceWindowFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	Key *string `min:"1" type:"string"`

	// The filter values.
	Values []*string `type:"list"`
}

// String returns the string representation
func (s MaintenanceWindowFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MaintenanceWindowFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MaintenanceWindowFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MaintenanceWindowFilter"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *MaintenanceWindowFilter) SetKey(v string) *MaintenanceWindowFilter {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *MaintenanceWindowFilter) SetValues(v []*string) *MaintenanceWindowFilter {
	s.Values = v
	return s
}

// Information about the Maintenance Window.
type MaintenanceWindowIdentity struct {
	_ struct{} `type:"structure"`

	// The number of hours before the end of the Maintenance Window that Systems
	// Manager stops scheduling new tasks for execution.
	Cutoff *int64 `type:"integer"`

	// A description of the Maintenance Window.
	Description *string `min:"1" type:"string" sensitive:"true"`

	// The duration of the Maintenance Window in hours.
	Duration *int64 `min:"1" type:"integer"`

	// Whether the Maintenance Window is enabled.
	Enabled *bool `type:"boolean"`

	// The date and time, in ISO-8601 Extended format, for when the Maintenance
	// Window is scheduled to become inactive.
	EndDate *string `type:"string"`

	// The name of the Maintenance Window.
	Name *string `min:"3" type:"string"`

	// The next time the Maintenance Window will actually run, taking into account
	// any specified times for the Maintenance Window to become active or inactive.
	NextExecutionTime *string `type:"string"`

	// The schedule of the Maintenance Window in the form of a cron or rate expression.
	Schedule *string `min:"1" type:"string"`

	// The time zone that the scheduled Maintenance Window executions are based
	// on, in Internet Assigned Numbers Authority (IANA) format.
	ScheduleTimezone *string `type:"string"`

	// The date and time, in ISO-8601 Extended format, for when the Maintenance
	// Window is scheduled to become active.
	StartDate *string `type:"string"`

	// The ID of the Maintenance Window.
	WindowId *string `min:"20" type:"string"`
}

// String returns the string representation
func (s MaintenanceWindowIdentity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MaintenanceWindowIdentity) GoString() string {
	return s.String()
}

// SetCutoff sets the Cutoff field's value.
func (s *MaintenanceWindowIdentity) SetCutoff(v int64) *MaintenanceWindowIdentity {
	s.Cutoff = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *MaintenanceWindowIdentity) SetDescription(v string) *MaintenanceWindowIdentity {
	s.Description = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *MaintenanceWindowIdentity) SetDuration(v int64) *MaintenanceWindowIdentity {
	s.Duration = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *MaintenanceWindowIdentity) SetEnabled(v bool) *MaintenanceWindowIdentity {
	s.Enabled = &v
	return s
}

// SetEndDate sets the EndDate field's value.
func (s *MaintenanceWindowIdentity) SetEndDate(v string) *MaintenanceWindowIdentity {
	s.EndDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *MaintenanceWindowIdentity) SetName(v string) *MaintenanceWindowIdentity {
	s.Name = &v
	return s
}

// SetNextExecutionTime sets the NextExecutionTime field's value.
func (s *MaintenanceWindowIdentity) SetNextExecutionTime(v string) *MaintenanceWindowIdentity {
	s.NextExecutionTime = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *MaintenanceWindowIdentity) SetSchedule(v string) *MaintenanceWindowIdentity {
	s.Schedule = &v
	return s
}

// SetScheduleTimezone sets the ScheduleTimezone field's value.
func (s *MaintenanceWindowIdentity) SetScheduleTimezone(v string) *MaintenanceWindowIdentity {
	s.ScheduleTimezone = &v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *MaintenanceWindowIdentity) SetStartDate(v string) *MaintenanceWindowIdentity {
	s.StartDate = &v
	return s
}

// SetWindowId sets the WindowId field's value.
func (s *MaintenanceWindowIdentity) SetWindowId(v string) *MaintenanceWindowIdentity {
	s.WindowId = &v
	return s
}

// The Maintenance Window to which the specified target belongs.
type MaintenanceWindowIdentityForTarget struct {
	_ struct{} `type:"structure"`

	// The name of the Maintenance Window.
	Name *string `min:"3" type:"string"`

	// The ID of the Maintenance Window.
	WindowId *string `min:"20" type:"string"`
}

// String returns the string representation
func (s MaintenanceWindowIdentityForTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MaintenanceWindowIdentityForTarget) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *MaintenanceWindowIdentityForTarget) SetName(v string) *MaintenanceWindowIdentityForTarget {
	s.Name = &v
	return s
}

// SetWindowId sets the WindowId field's value.
func (s *MaintenanceWindowIdentityForTarget) SetWindowId(v string) *MaintenanceWindowIdentityForTarget {
	s.WindowId = &v
	return s
}

// The parameters for a LAMBDA task type.
//
// For information about specifying and updating task parameters, see RegisterTaskWithMaintenanceWindow
// and UpdateMaintenanceWindowTask.
//
// LoggingInfo has been deprecated. To specify an S3 bucket to contain logs,
// instead use the OutputS3BucketName and OutputS3KeyPrefix options in the TaskInvocationParameters
// structure. For information about how Systems Manager handles these options
// for the supported Maintenance Window task types, see MaintenanceWindowTaskInvocationParameters.
//
// TaskParameters has been deprecated. To specify parameters to pass to a task
// when it runs, instead use the Parameters option in the TaskInvocationParameters
// structure. For information about how Systems Manager handles these options
// for the supported Maintenance Window task types, see MaintenanceWindowTaskInvocationParameters.
//
// For Lambda tasks, Systems Manager ignores any values specified for TaskParameters
// and LoggingInfo.
type MaintenanceWindowLambdaParameters struct {
	_ struct{} `type:"structure"`

	// Pass client-specific information to the Lambda function that you are invoking.
	// You can then process the client information in your Lambda function as you
	// choose through the context variable.
	ClientContext *string `min:"1" type:"string"`

	// JSON to provide to your Lambda function as input.
	//
	// Payload is automatically base64 encoded/decoded by the SDK.
	Payload []byte `type:"blob" sensitive:"true"`

	// (Optional) Specify a Lambda function version or alias name. If you specify
	// a function version, the action uses the qualified function ARN to invoke
	// a specific Lambda function. If you specify an alias name, the action uses
	// the alias ARN to invoke the Lambda function version to which the alias points.
	Qualifier *string `min:"1" type:"string"`
}

// String returns the string representation
func (s MaintenanceWindowLambdaParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MaintenanceWindowLambdaParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MaintenanceWindowLambdaParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MaintenanceWindowLambdaParameters"}
	if s.ClientContext != nil && len(*s.ClientContext) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientContext", 1))
	}
	if s.Qualifier != nil && len(*s.Qualifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Qualifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientContext sets the ClientContext field's value.
func (s *MaintenanceWindowLambdaParameters) SetClientContext(v string) *MaintenanceWindowLambdaParameters {
	s.ClientContext = &v
	return s
}

// SetPayload sets the Payload field's value.
func (s *MaintenanceWindowLambdaParameters) SetPayload(v []byte) *MaintenanceWindowLambdaParameters {
	s.Payload = v
	return s
}

// SetQualifier sets the Qualifier field's value.
func (s *MaintenanceWindowLambdaParameters) SetQualifier(v string) *MaintenanceWindowLambdaParameters {
	s.Qualifier = &v
	return s
}

// The parameters for a RUN_COMMAND task type.
//
// For information about specifying and updating task parameters, see RegisterTaskWithMaintenanceWindow
// and UpdateMaintenanceWindowTask.
//
// LoggingInfo has been deprecated. To specify an S3 bucket to contain logs,
// instead use the OutputS3BucketName and OutputS3KeyPrefix options in the TaskInvocationParameters
// structure. For information about how Systems Manager handles these options
// for the supported Maintenance Window task types, see MaintenanceWindowTaskInvocationParameters.
//
// TaskParameters has been deprecated. To specify parameters to pass to a task
// when it runs, instead use the Parameters option in the TaskInvocationParameters
// structure. For information about how Systems Manager handles these options
// for the supported Maintenance Window task types, see MaintenanceWindowTaskInvocationParameters.
//
// For Run Command tasks, Systems Manager uses specified values for TaskParameters
// and LoggingInfo only if no values are specified for TaskInvocationParameters.
type MaintenanceWindowRunCommandParameters struct {
	_ struct{} `type:"structure"`

	// Information about the command(s) to execute.
	Comment *string `type:"string"`

	// The SHA-256 or SHA-1 hash created by the system when the document was created.
	// SHA-1 hashes have been deprecated.
	DocumentHash *string `type:"string"`

	// SHA-256 or SHA-1. SHA-1 hashes have been deprecated.
	DocumentHashType *string `type:"string" enum:"DocumentHashType"`

	// Configurations for sending notifications about command status changes on
	// a per-instance basis.
	NotificationConfig *NotificationConfig `type:"structure"`

	// The name of the Amazon S3 bucket.
	OutputS3BucketName *string `min:"3" type:"string"`

	// The Amazon S3 bucket subfolder.
	OutputS3KeyPrefix *string `type:"string"`

	// The parameters for the RUN_COMMAND task execution.
	Parameters map[string][]*string `type:"map"`

	// The IAM service role to assume during task execution.
	ServiceRoleArn *string `type:"string"`

	// If this time is reached and the command has not already started executing,
	// it doesn't run.
	TimeoutSeconds *int64 `min:"30" type:"integer"`
}

// String returns the string representation
func (s MaintenanceWindowRunCommandParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MaintenanceWindowRunCommandParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MaintenanceWindowRunCommandParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MaintenanceWindowRunCommandParameters"}
	if s.OutputS3BucketName != nil && len(*s.OutputS3BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("OutputS3BucketName", 3))
	}
	if s.TimeoutSeconds != nil && *s.TimeoutSeconds < 30 {
		invalidParams.Add(request.NewErrParamMinValue("TimeoutSeconds", 30))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComment sets the Comment field's value.
func (s *MaintenanceWindowRunCommandParameters) SetComment(v string) *MaintenanceWindowRunCommandParameters {
	s.Comment = &v
	return s
}

// SetDocumentHash sets the DocumentHash field's value.
func (s *MaintenanceWindowRunCommandParameters) SetDocumentHash(v string) *MaintenanceWindowRunCommandParameters {
	s.DocumentHash = &v
	return s
}

// SetDocumentHashType sets the DocumentHashType field's value.
func (s *MaintenanceWindowRunCommandParameters) SetDocumentHashType(v string) *MaintenanceWindowRunCommandParameters {
	s.DocumentHashType = &v
	return s
}

// SetNotificationConfig sets the NotificationConfig field's value.
func (s *MaintenanceWindowRunCommandParameters) SetNotificationConfig(v *NotificationConfig) *MaintenanceWindowRunCommandParameters {
	s.NotificationConfig = v
	return s
}

// SetOutputS3BucketName sets the OutputS3BucketName field's value.
func (s *MaintenanceWindowRunCommandParameters) SetOutputS3BucketName(v string) *MaintenanceWindowRunCommandParameters {
	s.OutputS3BucketName = &v
	return s
}

// SetOutputS3KeyPrefix sets the OutputS3KeyPrefix field's value.
func (s *MaintenanceWindowRunCommandParameters) SetOutputS3KeyPrefix(v string) *MaintenanceWindowRunCommandParameters {
	s.OutputS3KeyPrefix = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *MaintenanceWindowRunCommandParameters) SetParameters(v map[string][]*string) *MaintenanceWindowRunCommandParameters {
	s.Parameters = v
	return s
}

// SetServiceRoleArn sets the ServiceRoleArn field's value.
func (s *MaintenanceWindowRunCommandParameters) SetServiceRoleArn(v string) *MaintenanceWindowRunCommandParameters {
	s.ServiceRoleArn = &v
	return s
}

// SetTimeoutSeconds sets the TimeoutSeconds field's value.
func (s *MaintenanceWindowRunCommandParameters) SetTimeoutSeconds(v int64) *MaintenanceWindowRunCommandParameters {
	s.TimeoutSeconds = &v
	return s
}

// The parameters for a STEP_FUNCTION task.
//
// For information about specifying and updating task parameters, see RegisterTaskWithMaintenanceWindow
// and UpdateMaintenanceWindowTask.
//
// LoggingInfo has been deprecated. To specify an S3 bucket to contain logs,
// instead use the OutputS3BucketName and OutputS3KeyPrefix options in the TaskInvocationParameters
// structure. For information about how Systems Manager handles these options
// for the supported Maintenance Window task types, see MaintenanceWindowTaskInvocationParameters.
//
// TaskParameters has been deprecated. To specify parameters to pass to a task
// when it runs, instead use the Parameters option in the TaskInvocationParameters
// structure. For information about how Systems Manager handles these options
// for the supported Maintenance Window task types, see MaintenanceWindowTaskInvocationParameters.
//
// For Step Functions tasks, Systems Manager ignores any values specified for
// TaskParameters and LoggingInfo.
type MaintenanceWindowStepFunctionsParameters struct {
	_ struct{} `type:"structure"`

	// The inputs for the STEP_FUNCTION task.
	Input *string `type:"string" sensitive:"true"`

	// The name of the STEP_FUNCTION task.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s MaintenanceWindowStepFunctionsParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MaintenanceWindowStepFunctionsParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MaintenanceWindowStepFunctionsParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MaintenanceWindowStepFunctionsParameters"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInput sets the Input field's value.
func (s *MaintenanceWindowStepFunctionsParameters) SetInput(v string) *MaintenanceWindowStepFunctionsParameters {
	s.Input = &v
	return s
}

// SetName sets the Name field's value.
func (s *MaintenanceWindowStepFunctionsParameters) SetName(v string) *MaintenanceWindowStepFunctionsParameters {
	s.Name = &v
	return s
}

// The target registered with the Maintenance Window.
type MaintenanceWindowTarget struct {
	_ struct{} `type:"structure"`

	// A description of the target.
	Description *string `min:"1" type:"string" sensitive:"true"`

	// The target name.
	Name *string `min:"3" type:"string"`

	// User-provided value that will be included in any CloudWatch events raised
	// while running tasks for these targets in this Maintenance Window.
	OwnerInformation *string `min:"1" type:"string" sensitive:"true"`

	// The type of target.
	ResourceType *string `type:"string" enum:"MaintenanceWindowResourceType"`

	// The targets (either instances or tags). Instances are specified using Key=instanceids,Values=<instanceid1>,<instanceid2>.
	// Tags are specified using Key=<tag name>,Values=<tag value>.
	Targets []*Target `type:"list"`

	// The Maintenance Window ID where the target is registered.
	WindowId *string `min:"20" type:"string"`

	// The ID of the target.
	WindowTargetId *string `min:"36" type:"string"`
}

// String returns the string representation
func (s MaintenanceWindowTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MaintenanceWindowTarget) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *MaintenanceWindowTarget) SetDescription(v string) *MaintenanceWindowTarget {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *MaintenanceWindowTarget) SetName(v string) *MaintenanceWindowTarget {
	s.Name = &v
	return s
}

// SetOwnerInformation sets the OwnerInformation field's value.
func (s *MaintenanceWindowTarget) SetOwnerInformation(v string) *MaintenanceWindowTarget {
	s.OwnerInformation = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *MaintenanceWindowTarget) SetResourceType(v string) *MaintenanceWindowTarget {
	s.ResourceType = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *MaintenanceWindowTarget) SetTargets(v []*Target) *MaintenanceWindowTarget {
	s.Targets = v
	return s
}

// SetWindowId sets the WindowId field's value.
func (s *MaintenanceWindowTarget) SetWindowId(v string) *MaintenanceWindowTarget {
	s.WindowId = &v
	return s
}

// SetWindowTargetId sets the WindowTargetId field's value.
func (s *MaintenanceWindowTarget) SetWindowTargetId(v string) *MaintenanceWindowTarget {
	s.WindowTargetId = &v
	return s
}

// Information about a task defined for a Maintenance Window.
type MaintenanceWindowTask struct {
	_ struct{} `type:"structure"`

	// A description of the task.
	Description *string `min:"1" type:"string" sensitive:"true"`

	// Information about an Amazon S3 bucket to write task-level logs to.
	//
	// LoggingInfo has been deprecated. To specify an S3 bucket to contain logs,
	// instead use the OutputS3BucketName and OutputS3KeyPrefix options in the TaskInvocationParameters
	// structure. For information about how Systems Manager handles these options
	// for the supported Maintenance Window task types, see MaintenanceWindowTaskInvocationParameters.
	LoggingInfo *LoggingInfo `type:"structure"`

	// The maximum number of targets this task can be run for in parallel.
	MaxConcurrency *string `min:"1" type:"string"`

	// The maximum number of errors allowed before this task stops being scheduled.
	MaxErrors *string `min:"1" type:"string"`

	// The task name.
	Name *string `min:"3" type:"string"`

	// The priority of the task in the Maintenance Window. The lower the number,
	// the higher the priority. Tasks that have the same priority are scheduled
	// in parallel.
	Priority *int64 `type:"integer"`

	// The role that should be assumed when executing the task
	ServiceRoleArn *string `type:"string"`

	// The targets (either instances or tags). Instances are specified using Key=instanceids,Values=<instanceid1>,<instanceid2>.
	// Tags are specified using Key=<tag name>,Values=<tag value>.
	Targets []*Target `type:"list"`

	// The resource that the task uses during execution. For RUN_COMMAND and AUTOMATION
	// task types, TaskArn is the Systems Manager document name or ARN. For LAMBDA
	// tasks, it's the function name or ARN. For STEP_FUNCTION tasks, it's the state
	// machine ARN.
	TaskArn *string `min:"1" type:"string"`

	// The parameters that should be passed to the task when it is executed.
	//
	// TaskParameters has been deprecated. To specify parameters to pass to a task
	// when it runs, instead use the Parameters option in the TaskInvocationParameters
	// structure. For information about how Systems Manager handles these options
	// for the supported Maintenance Window task types, see MaintenanceWindowTaskInvocationParameters.
	TaskParameters map[string]*MaintenanceWindowTaskParameterValueExpression `type:"map" sensitive:"true"`

	// The type of task. The type can be one of the following: RUN_COMMAND, AUTOMATION,
	// LAMBDA, or STEP_FUNCTION.
	Type *string `type:"string" enum:"MaintenanceWindowTaskType"`

	// The Maintenance Window ID where the task is registered.
	WindowId *string `min:"20" type:"string"`

	// The task ID.
	WindowTaskId *string `min:"36" type:"string"`
}

// String returns the string representation
func (s MaintenanceWindowTask) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MaintenanceWindowTask) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *MaintenanceWindowTask) SetDescription(v string) *MaintenanceWindowTask {
	s.Description = &v
	return s
}

// SetLoggingInfo sets the LoggingInfo field's value.
func (s *MaintenanceWindowTask) SetLoggingInfo(v *LoggingInfo) *MaintenanceWindowTask {
	s.LoggingInfo = v
	return s
}

// SetMaxConcurrency sets the MaxConcurrency field's value.
func (s *MaintenanceWindowTask) SetMaxConcurrency(v string) *MaintenanceWindowTask {
	s.MaxConcurrency = &v
	return s
}

// SetMaxErrors sets the MaxErrors field's value.
func (s *MaintenanceWindowTask) SetMaxErrors(v string) *MaintenanceWindowTask {
	s.MaxErrors = &v
	return s
}

// SetName sets the Name field's value.
func (s *MaintenanceWindowTask) SetName(v string) *MaintenanceWindowTask {
	s.Name = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *MaintenanceWindowTask) SetPriority(v int64) *MaintenanceWindowTask {
	s.Priority = &v
	return s
}

// SetServiceRoleArn sets the ServiceRoleArn field's value.
func (s *MaintenanceWindowTask) SetServiceRoleArn(v string) *MaintenanceWindowTask {
	s.ServiceRoleArn = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *MaintenanceWindowTask) SetTargets(v []*Target) *MaintenanceWindowTask {
	s.Targets = v
	return s
}

// SetTaskArn sets the TaskArn field's value.
func (s *MaintenanceWindowTask) SetTaskArn(v string) *MaintenanceWindowTask {
	s.TaskArn = &v
	return s
}

// SetTaskParameters sets the TaskParameters field's value.
func (s *MaintenanceWindowTask) SetTaskParameters(v map[string]*MaintenanceWindowTaskParameterValueExpression) *MaintenanceWindowTask {
	s.TaskParameters = v
	return s
}

// SetType sets the Type field's value.
func (s *MaintenanceWindowTask) SetType(v string) *MaintenanceWindowTask {
	s.Type = &v
	return s
}

// SetWindowId sets the WindowId field's value.
func (s *MaintenanceWindowTask) SetWindowId(v string) *MaintenanceWindowTask {
	s.WindowId = &v
	return s
}

// SetWindowTaskId sets the WindowTaskId field's value.
func (s *MaintenanceWindowTask) SetWindowTaskId(v string) *MaintenanceWindowTask {
	s.WindowTaskId = &v
	return s
}

// The parameters for task execution.
type MaintenanceWindowTaskInvocationParameters struct {
	_ struct{} `type:"structure"`

	// The parameters for an AUTOMATION task type.
	Automation *MaintenanceWindowAutomationParameters `type:"structure"`

	// The parameters for a LAMBDA task type.
	Lambda *MaintenanceWindowLambdaParameters `type:"structure"`

	// The parameters for a RUN_COMMAND task type.
	RunCommand *MaintenanceWindowRunCommandParameters `type:"structure"`

	// The parameters for a STEP_FUNCTION task type.
	StepFunctions *MaintenanceWindowStepFunctionsParameters `type:"structure"`
}

// String returns the string representation
func (s MaintenanceWindowTaskInvocationParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MaintenanceWindowTaskInvocationParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MaintenanceWindowTaskInvocationParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MaintenanceWindowTaskInvocationParameters"}
	if s.Automation != nil {
		if err := s.Automation.Validate(); err != nil {
			invalidParams.AddNested("Automation", err.(request.ErrInvalidParams))
		}
	}
	if s.Lambda != nil {
		if err := s.Lambda.Validate(); err != nil {
			invalidParams.AddNested("Lambda", err.(request.ErrInvalidParams))
		}
	}
	if s.RunCommand != nil {
		if err := s.RunCommand.Validate(); err != nil {
			invalidParams.AddNested("RunCommand", err.(request.ErrInvalidParams))
		}
	}
	if s.StepFunctions != nil {
		if err := s.StepFunctions.Validate(); err != nil {
			invalidParams.AddNested("StepFunctions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutomation sets the Automation field's value.
func (s *MaintenanceWindowTaskInvocationParameters) SetAutomation(v *MaintenanceWindowAutomationParameters) *MaintenanceWindowTaskInvocationParameters {
	s.Automation = v
	return s
}

// SetLambda sets the Lambda field's value.
func (s *MaintenanceWindowTaskInvocationParameters) SetLambda(v *MaintenanceWindowLambdaParameters) *MaintenanceWindowTaskInvocationParameters {
	s.Lambda = v
	return s
}

// SetRunCommand sets the RunCommand field's value.
func (s *MaintenanceWindowTaskInvocationParameters) SetRunCommand(v *MaintenanceWindowRunCommandParameters) *MaintenanceWindowTaskInvocationParameters {
	s.RunCommand = v
	return s
}

// SetStepFunctions sets the StepFunctions field's value.
func (s *MaintenanceWindowTaskInvocationParameters) SetStepFunctions(v *MaintenanceWindowStepFunctionsParameters) *MaintenanceWindowTaskInvocationParameters {
	s.StepFunctions = v
	return s
}

// Defines the values for a task parameter.
type MaintenanceWindowTaskParameterValueExpression struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// This field contains an array of 0 or more strings, each 1 to 255 characters
	// in length.
	Values []*string `type:"list" sensitive:"true"`
}

// String returns the string representation
func (s MaintenanceWindowTaskParameterValueExpression) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MaintenanceWindowTaskParameterValueExpression) GoString() string {
	return s.String()
}

// SetValues sets the Values field's value.
func (s *MaintenanceWindowTaskParameterValueExpression) SetValues(v []*string) *MaintenanceWindowTaskParameterValueExpression {
	s.Values = v
	return s
}

type ModifyDocumentPermissionInput struct {
	_ struct{} `type:"structure"`

	// The AWS user accounts that should have access to the document. The account
	// IDs can either be a group of account IDs or All.
	AccountIdsToAdd []*string `type:"list"`

	// The AWS user accounts that should no longer have access to the document.
	// The AWS user account can either be a group of account IDs or All. This action
	// has a higher priority than AccountIdsToAdd. If you specify an account ID
	// to add and the same ID to remove, the system removes access to the document.
	AccountIdsToRemove []*string `type:"list"`

	// The name of the document that you want to share.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The permission type for the document. The permission type can be Share.
	//
	// PermissionType is a required field
	PermissionType *string `type:"string" required:"true" enum:"DocumentPermissionType"`
}

// String returns the string representation
func (s ModifyDocumentPermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDocumentPermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyDocumentPermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyDocumentPermissionInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.PermissionType == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIdsToAdd sets the AccountIdsToAdd field's value.
func (s *ModifyDocumentPermissionInput) SetAccountIdsToAdd(v []*string) *ModifyDocumentPermissionInput {
	s.AccountIdsToAdd = v
	return s
}

// SetAccountIdsToRemove sets the AccountIdsToRemove field's value.
func (s *ModifyDocumentPermissionInput) SetAccountIdsToRemove(v []*string) *ModifyDocumentPermissionInput {
	s.AccountIdsToRemove = v
	return s
}

// SetName sets the Name field's value.
func (s *ModifyDocumentPermissionInput) SetName(v string) *ModifyDocumentPermissionInput {
	s.Name = &v
	return s
}

// SetPermissionType sets the PermissionType field's value.
func (s *ModifyDocumentPermissionInput) SetPermissionType(v string) *ModifyDocumentPermissionInput {
	s.PermissionType = &v
	return s
}

type ModifyDocumentPermissionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ModifyDocumentPermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyDocumentPermissionOutput) GoString() string {
	return s.String()
}

// A summary of resources that are not compliant. The summary is organized according
// to resource type.
type NonCompliantSummary struct {
	_ struct{} `type:"structure"`

	// The total number of compliance items that are not compliant.
	NonCompliantCount *int64 `type:"integer"`

	// A summary of the non-compliance severity by compliance type
	SeveritySummary *SeveritySummary `type:"structure"`
}

// String returns the string representation
func (s NonCompliantSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NonCompliantSummary) GoString() string {
	return s.String()
}

// SetNonCompliantCount sets the NonCompliantCount field's value.
func (s *NonCompliantSummary) SetNonCompliantCount(v int64) *NonCompliantSummary {
	s.NonCompliantCount = &v
	return s
}

// SetSeveritySummary sets the SeveritySummary field's value.
func (s *NonCompliantSummary) SetSeveritySummary(v *SeveritySummary) *NonCompliantSummary {
	s.SeveritySummary = v
	return s
}

// Configurations for sending notifications.
type NotificationConfig struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) for a Simple Notification Service (SNS) topic.
	// Run Command pushes notifications about command status changes to this topic.
	NotificationArn *string `type:"string"`

	// The different events for which you can receive notifications. These events
	// include the following: All (events), InProgress, Success, TimedOut, Cancelled,
	// Failed. To learn more about these events, see Configuring Amazon SNS Notifications
	// for Run Command (http://docs.aws.amazon.com/systems-manager/latest/userguide/rc-sns-notifications.html)
	// in the AWS Systems Manager User Guide.
	NotificationEvents []*string `type:"list"`

	// Command: Receive notification when the status of a command changes. Invocation:
	// For commands sent to multiple instances, receive notification on a per-instance
	// basis when the status of a command changes.
	NotificationType *string `type:"string" enum:"NotificationType"`
}

// String returns the string representation
func (s NotificationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotificationConfig) GoString() string {
	return s.String()
}

// SetNotificationArn sets the NotificationArn field's value.
func (s *NotificationConfig) SetNotificationArn(v string) *NotificationConfig {
	s.NotificationArn = &v
	return s
}

// SetNotificationEvents sets the NotificationEvents field's value.
func (s *NotificationConfig) SetNotificationEvents(v []*string) *NotificationConfig {
	s.NotificationEvents = v
	return s
}

// SetNotificationType sets the NotificationType field's value.
func (s *NotificationConfig) SetNotificationType(v string) *NotificationConfig {
	s.NotificationType = &v
	return s
}

// Information about the source where the association execution details are
// stored.
type OutputSource struct {
	_ struct{} `type:"structure"`

	// The ID of the output source, for example the URL of an Amazon S3 bucket.
	OutputSourceId *string `min:"36" type:"string"`

	// The type of source where the association execution details are stored, for
	// example, Amazon S3.
	OutputSourceType *string `type:"string"`
}

// String returns the string representation
func (s OutputSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OutputSource) GoString() string {
	return s.String()
}

// SetOutputSourceId sets the OutputSourceId field's value.
func (s *OutputSource) SetOutputSourceId(v string) *OutputSource {
	s.OutputSourceId = &v
	return s
}

// SetOutputSourceType sets the OutputSourceType field's value.
func (s *OutputSource) SetOutputSourceType(v string) *OutputSource {
	s.OutputSourceType = &v
	return s
}

// An Amazon EC2 Systems Manager parameter in Parameter Store.
type Parameter struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the parameter.
	ARN *string `type:"string"`

	// Date the parameter was last changed or updated and the parameter version
	// was created.
	LastModifiedDate *time.Time `type:"timestamp"`

	// The name of the parameter.
	Name *string `min:"1" type:"string"`

	// Either the version number or the label used to retrieve the parameter value.
	// Specify selectors by using one of the following formats:
	//
	// parameter_name:version
	//
	// parameter_name:label
	Selector *string `type:"string"`

	// Applies to parameters that reference information in other AWS services. SourceResult
	// is the raw result or response from the source.
	SourceResult *string `type:"string"`

	// The type of parameter. Valid values include the following: String, String
	// list, Secure string.
	Type *string `type:"string" enum:"ParameterType"`

	// The parameter value.
	Value *string `min:"1" type:"string"`

	// The parameter version.
	Version *int64 `type:"long"`
}

// String returns the string representation
func (s Parameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Parameter) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *Parameter) SetARN(v string) *Parameter {
	s.ARN = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *Parameter) SetLastModifiedDate(v time.Time) *Parameter {
	s.LastModifiedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *Parameter) SetName(v string) *Parameter {
	s.Name = &v
	return s
}

// SetSelector sets the Selector field's value.
func (s *Parameter) SetSelector(v string) *Parameter {
	s.Selector = &v
	return s
}

// SetSourceResult sets the SourceResult field's value.
func (s *Parameter) SetSourceResult(v string) *Parameter {
	s.SourceResult = &v
	return s
}

// SetType sets the Type field's value.
func (s *Parameter) SetType(v string) *Parameter {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Parameter) SetValue(v string) *Parameter {
	s.Value = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *Parameter) SetVersion(v int64) *Parameter {
	s.Version = &v
	return s
}

// Information about parameter usage.
type ParameterHistory struct {
	_ struct{} `type:"structure"`

	// Parameter names can include the following letters and symbols.
	//
	// a-zA-Z0-9_.-
	AllowedPattern *string `type:"string"`

	// Information about the parameter.
	Description *string `type:"string"`

	// The ID of the query key used for this parameter.
	KeyId *string `min:"1" type:"string"`

	// Labels assigned to the parameter version.
	Labels []*string `min:"1" type:"list"`

	// Date the parameter was last changed or updated.
	LastModifiedDate *time.Time `type:"timestamp"`

	// Amazon Resource Name (ARN) of the AWS user who last changed the parameter.
	LastModifiedUser *string `type:"string"`

	// The name of the parameter.
	Name *string `min:"1" type:"string"`

	// The type of parameter used.
	Type *string `type:"string" enum:"ParameterType"`

	// The parameter value.
	Value *string `min:"1" type:"string"`

	// The parameter version.
	Version *int64 `type:"long"`
}

// String returns the string representation
func (s ParameterHistory) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ParameterHistory) GoString() string {
	return s.String()
}

// SetAllowedPattern sets the AllowedPattern field's value.
func (s *ParameterHistory) SetAllowedPattern(v string) *ParameterHistory {
	s.AllowedPattern = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ParameterHistory) SetDescription(v string) *ParameterHistory {
	s.Description = &v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *ParameterHistory) SetKeyId(v string) *ParameterHistory {
	s.KeyId = &v
	return s
}

// SetLabels sets the Labels field's value.
func (s *ParameterHistory) SetLabels(v []*string) *ParameterHistory {
	s.Labels = v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *ParameterHistory) SetLastModifiedDate(v time.Time) *ParameterHistory {
	s.LastModifiedDate = &v
	return s
}

// SetLastModifiedUser sets the LastModifiedUser field's value.
func (s *ParameterHistory) SetLastModifiedUser(v string) *ParameterHistory {
	s.LastModifiedUser = &v
	return s
}

// SetName sets the Name field's value.
func (s *ParameterHistory) SetName(v string) *ParameterHistory {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *ParameterHistory) SetType(v string) *ParameterHistory {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ParameterHistory) SetValue(v string) *ParameterHistory {
	s.Value = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *ParameterHistory) SetVersion(v int64) *ParameterHistory {
	s.Version = &v
	return s
}

// Metada includes information like the ARN of the last user and the date/time
// the parameter was last used.
type ParameterMetadata struct {
	_ struct{} `type:"structure"`

	// A parameter name can include only the following letters and symbols.
	//
	// a-zA-Z0-9_.-
	AllowedPattern *string `type:"string"`

	// Description of the parameter actions.
	Description *string `type:"string"`

	// The ID of the query key used for this parameter.
	KeyId *string `min:"1" type:"string"`

	// Date the parameter was last changed or updated.
	LastModifiedDate *time.Time `type:"timestamp"`

	// Amazon Resource Name (ARN) of the AWS user who last changed the parameter.
	LastModifiedUser *string `type:"string"`

	// The parameter name.
	Name *string `min:"1" type:"string"`

	// The type of parameter. Valid parameter types include the following: String,
	// String list, Secure string.
	Type *string `type:"string" enum:"ParameterType"`

	// The parameter version.
	Version *int64 `type:"long"`
}

// String returns the string representation
func (s ParameterMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ParameterMetadata) GoString() string {
	return s.String()
}

// SetAllowedPattern sets the AllowedPattern field's value.
func (s *ParameterMetadata) SetAllowedPattern(v string) *ParameterMetadata {
	s.AllowedPattern = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ParameterMetadata) SetDescription(v string) *ParameterMetadata {
	s.Description = &v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *ParameterMetadata) SetKeyId(v string) *ParameterMetadata {
	s.KeyId = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *ParameterMetadata) SetLastModifiedDate(v time.Time) *ParameterMetadata {
	s.LastModifiedDate = &v
	return s
}

// SetLastModifiedUser sets the LastModifiedUser field's value.
func (s *ParameterMetadata) SetLastModifiedUser(v string) *ParameterMetadata {
	s.LastModifiedUser = &v
	return s
}

// SetName sets the Name field's value.
func (s *ParameterMetadata) SetName(v string) *ParameterMetadata {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *ParameterMetadata) SetType(v string) *ParameterMetadata {
	s.Type = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *ParameterMetadata) SetVersion(v int64) *ParameterMetadata {
	s.Version = &v
	return s
}

// One or more filters. Use a filter to return a more specific list of results.
//
// The Name field can't be used with the GetParametersByPath API action.
type ParameterStringFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Valid options are Equals and BeginsWith. For Path filter, valid options are
	// Recursive and OneLevel.
	Option *string `min:"1" type:"string"`

	// The value you want to search for.
	Values []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s ParameterStringFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ParameterStringFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ParameterStringFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ParameterStringFilter"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Option != nil && len(*s.Option) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Option", 1))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *ParameterStringFilter) SetKey(v string) *ParameterStringFilter {
	s.Key = &v
	return s
}

// SetOption sets the Option field's value.
func (s *ParameterStringFilter) SetOption(v string) *ParameterStringFilter {
	s.Option = &v
	return s
}

// SetValues sets the Values field's value.
func (s *ParameterStringFilter) SetValues(v []*string) *ParameterStringFilter {
	s.Values = v
	return s
}

// This data type is deprecated. Instead, use ParameterStringFilter.
type ParametersFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	//
	// Key is a required field
	Key *string `type:"string" required:"true" enum:"ParametersFilterKey"`

	// The filter values.
	//
	// Values is a required field
	Values []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s ParametersFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ParametersFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ParametersFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ParametersFilter"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *ParametersFilter) SetKey(v string) *ParametersFilter {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *ParametersFilter) SetValues(v []*string) *ParametersFilter {
	s.Values = v
	return s
}

// Represents metadata about a patch.
type Patch struct {
	_ struct{} `type:"structure"`

	// The classification of the patch (for example, SecurityUpdates, Updates, CriticalUpdates).
	Classification *string `type:"string"`

	// The URL where more information can be obtained about the patch.
	ContentUrl *string `type:"string"`

	// The description of the patch.
	Description *string `type:"string"`

	// The ID of the patch (this is different than the Microsoft Knowledge Base
	// ID).
	Id *string `min:"1" type:"string"`

	// The Microsoft Knowledge Base ID of the patch.
	KbNumber *string `type:"string"`

	// The language of the patch if it's language-specific.
	Language *string `type:"string"`

	// The ID of the MSRC bulletin the patch is related to.
	MsrcNumber *string `type:"string"`

	// The severity of the patch (for example Critical, Important, Moderate).
	MsrcSeverity *string `type:"string"`

	// The specific product the patch is applic