#ifndef _USB_REDIRECTOR_API_H_
#define _USB_REDIRECTOR_API_H_

#include "apidef.h"

#ifdef USBRDRAPI_EXPORTS
#define USBRDR_API __declspec(dllexport)
#else
#define USBRDR_API __declspec(dllimport)
#endif

#ifdef __cplusplus
extern "C"
{
#endif // __cplusplus

USBRDR_API
BOOL
InitUsbRedirectorApi();

USBRDR_API
BOOL
DeInitUsbRedirectorApi();

USBRDR_API
ULONG
GetUSBRedirectorLastError(ULONG *lpulArg1);

USBRDR_API
BOOL
SetNotificationEvent(HANDLE hEvent);

USBRDR_API
BOOL 
GetIPFilters(CHAR *Buffer, ULONG *lpulSize);

USBRDR_API
BOOL 
SetIPFilters(CHAR *Buffer);

USBRDR_API
BOOL 
AddIPFilter(CHAR *Buffer);

USBRDR_API
BOOL 
RemoveIPFilter(CHAR *Buffer);

USBRDR_API
BOOL
AddUSBServer(LPCSTR lpHostName, uint16 uTcpPort, uint32 *lpHandle);

USBRDR_API
BOOL
EstablishCallBackConnectionWithUsbServer(LPCSTR lpHostName, uint32 *lpHandle);

USBRDR_API
BOOL
RemoveUSBServer(uint32 hServer);

USBRDR_API
BOOL
GetUSBServerDescriptor(uint32 hServer, PSERVER_DESCRIPTOR lpDescriptor);

USBRDR_API
BOOL
ChangeUSBServerProperties(uint32 hServer, uint32 ulProperties);

USBRDR_API
BOOL
EnumUSBServers(SERVER_DESCRIPTOR *lpDescriptor, ULONG *lpulSize);

USBRDR_API
BOOL 
EnumConnectedClients(SERVER_DESCRIPTOR *lpDescriptor, ULONG *lpulSize);

USBRDR_API
BOOL
EnumRemoteUSBDevices(uint32 hServer, DEVICE_DESCRIPTOR *lpDescriptor, ULONG *lpulSize);

USBRDR_API
BOOL
EnumLocalUSBDevices(DEVICE_DESCRIPTOR *lpDescriptor, ULONG *lpulSize);

USBRDR_API
BOOL
ShareUSBDevice(uint32 hDevice);

USBRDR_API
BOOL
StopSharingUSBDevice(uint32 hDevice);

USBRDR_API
BOOL
AddUSBDeviceToExclusionList(uint32 hServer, uint32 hDevice);

USBRDR_API
BOOL
RemoveUSBDeviceFromExclusionList(uint32 hServer, uint32 hDevice);

USBRDR_API
BOOL
ConnectUSBDevice(uint32 hServer, uint32 hDevice);

USBRDR_API
BOOL
ConnectUSBDeviceToClient(uint32 hDevice, uint32 hClient);

USBRDR_API
BOOL
DisconnectUSBDevice(uint32 hServer, uint32 hDevice);

USBRDR_API
BOOL
DisconnectUSBDeviceFromClient(uint32 hDevice);

USBRDR_API
BOOL
ChangeUSBDeviceProperties(uint32 hServer, uint32 hDevice, uint32 ulProperties);

USBRDR_API
BOOL
GetUSBDeviceDescriptor(
	uint32 hServer, 
	uint32 hDevice, 
	PDEVICE_DESCRIPTOR lpDeviceDescriptor);

USBRDR_API
BOOL
ChangeNetworkProperties(uint16 tcpport);

USBRDR_API
BOOL
SetInactiveTimeoutForDevice(uint32 hDevice, uint32 ulTimeout);

USBRDR_API
BOOL
SetNickNameForDevice(uint32 hDevice, LPCSTR lpNickName);

USBRDR_API
BOOL
CreateCallBackConnectionToUsbClient(LPCSTR lpHostName, uint16 uTcpPort, uint32 *lpCallBackHandle);

USBRDR_API
BOOL
CloseCallBackConnectionToUsbClient(uint32 hCallBackHandle);

USBRDR_API
BOOL 
EnumCallBackConnectionsToUsbClients(SERVER_DESCRIPTOR *lpDescriptor, ULONG *lpulSize);

#ifdef __cplusplus
}
#endif // __cplusplus

#endif // _USB_REDIRECTOR_API_H_