
#include "pch.h"

#include <cstdio>
#include <exception>

#include "usb_criteria.h"
#include "debug.h"

#define USB_CLASS_DEVICE        0x00
#define USB_CLASS_AUDIO         0x01
#define USB_CLASS_COMMUNICATION 0x02
#define USB_CLASS_HID           0x03
#define USB_CLASS_PHYSICAL      0x05
#define USB_CLASS_STILL_IMAGING 0x06
#define USB_CLASS_PRINTER       0x07
#define USB_CLASS_MASS_STORAGE  0x08
#define USB_CLASS_HUB           0x09
#define USB_CLASS_CDC           0x0A
#define USB_CLASS_SMART_CARD    0x0B
#define USB_CLASS_SECURITY      0x0D
#define USB_CLASS_VIDEO         0x0E
#define USB_CLASS_HEALTHCARE    0x0F
#define USB_CLASS_DIAGNOSTIC    0xDC
#define USB_CLASS_WIRELESS      0xE0
#define USB_CLASS_MISCELLANEOUS 0xEF
#define USB_CLASS_APPLICATION   0xFE
#define USB_CLASS_VENDOR        0xFF

UsbCriteria::UsbCriteria(const char *params)
{
    ASSERT(params != NULL);

    if (sscanf(params, "%d,%d,%d,%d,%d",
            &_class, &_vender, &_product, &_revision, &_action) != 5) {
        throw std::invalid_argument((fmt("%s: invalid criteria's parameters (%s)") %
                    __FUNCTION__ % params).str().c_str());
    }
}

UsbCriteria::~UsbCriteria()
{

}

int UsbCriteria::match(const DEVICE_DESCRIPTOR& desc)
{
    if (((_class == ANY) || (_class == desc.zero_iface.DeviceClass)) &&
        ((_vender == ANY) || (_vender == desc.hwid.VendorId)) &&
        ((_product == ANY) || (_product == desc.hwid.ProductId)) &&
        ((_revision == ANY) || (_revision == desc.hwid.Revision)))
    {
        return _action;
    }

    return MISMATCH;
}
