#ifndef _H_DEBUG
#define _H_DEBUG

#include <iostream>
#include <sstream>

// Used to log just about everything that might be useful (or not).
#define LOG_TRACE(message) { \
    std::ostringstream os; \
    os << __FUNCTION__ << ": " << message << std::endl; \
    std::cout << os.str().c_str(); \
    std::cout.flush(); \
}

// Used to log debug information which doesn't inflate the log with useless
// and repeated messages.
#define LOG_DEBUG(message) { \
    std::ostringstream os; \
    os << __FUNCTION__ << ": " << message << std::endl; \
    std::cout << os.str().c_str(); \
    std::cout.flush(); \
}

// Used to log the program flow.
#define LOG_INFO(message) { \
    std::ostringstream os; \
    os << __FUNCTION__ << ": " << message << std::endl; \
    std::cout << os.str().c_str(); \
    std::cout.flush(); \
}

// Used to log errors which are handled by the program.
#define LOG_WARN(message) { \
    std::ostringstream os; \
    os << __FUNCTION__ << ": " << message << std::endl; \
    std::cout << os.str().c_str(); \
    std::cout.flush(); \
}

// Used to log errors that can't be handled by the program.
#define LOG_ERROR(message) { \
    std::ostringstream os; \
    os << __FUNCTION__ << ": " << message << std::endl; \
    std::cout << os.str().c_str(); \
    std::cout.flush(); \
}

// Used to log errors that can't happen (even if they do!).
#define LOG_FATAL(message) { \
    std::ostringstream os; \
    os << __FUNCTION__ << ": " << message << std::endl; \
    std::cout << os.str().c_str(); \
    std::cout.flush(); \
}

#endif // _H_DEBUG
