
#ifndef _APPLICATION_H_INCLUDED_
#define _APPLICATION_H_INCLUDED_

#include <deque>

#include <boost/thread/condition.hpp>
#include <boost/function.hpp>
#include <boost/thread.hpp>

#include "foreign_menu.h"

class UsbServer;

class Application : public ForeignMenuListener
{
public:
    Application();
    ~Application();

    bool parse_command_line(std::vector<std::string>& args);
    int execute();

    void on_usb_notification();

    virtual void on_menu_item_click(uint32_t id);
    virtual void on_menu_activate();
    virtual void on_menu_deactivate();
    virtual void on_connection_close();

private:
    typedef boost::function<void ()> Message;

private:
    int process_messages();
    void push_message(Application::Message *msg);
    Application::Message* pop_message();

    void handle_usb_notification();

    void handle_menu_item_click(uint32_t hdev);
    void handle_menu_activate();
    void handle_menu_deactivate();
    void handle_connection_close();

private:
    std::string _host_name;
    uint16_t _host_port;
    std::string _pipe_name;
    std::string _filter;
    std::string _menu_title_text;
    std::string _no_devices_text;
    std::string _not_installed_text;
    bool _auto_share;
    int _exit_code;

    std::auto_ptr<UsbServer> _usb_server;
    std::auto_ptr<ForeignMenu> _foreign_menu;

    std::deque<Application::Message*> _queue;
    boost::mutex _protect_queue;
    boost::condition _drain_cond;
};

#endif // _APPLICATION_H_INCLUDED_
