// SpiceX.cpp : Implementation of DLL Exports.


#include "stdafx.h"
#include "resource.h"
#include "SpiceX.h"


class CSpiceXModule : public CAtlDllModuleT< CSpiceXModule >
{
public :
	DECLARE_LIBID(LIBID_SpiceXLib)
	DECLARE_REGISTRY_APPID_RESOURCEID(IDR_SPICEX, "{E0D3BDEC-DF76-449B-9944-1935A6D73E72}")
};

CSpiceXModule _AtlModule;


#ifdef _MANAGED
#pragma managed(push, off)
#endif

// DLL Entry Point
extern "C" BOOL WINAPI DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID lpReserved)
{
	hInstance;
	switch (dwReason) {
	case DLL_PROCESS_ATTACH:
		spicex_init_logger();
		break;
	case DLL_PROCESS_DETACH:
		spicex_log_cleanup();
		break;
	};
	return _AtlModule.DllMain(dwReason, lpReserved); 
}

#ifdef _MANAGED
#pragma managed(pop)
#endif




// Used to determine whether the DLL can be unloaded by OLE
STDAPI DllCanUnloadNow(void)
{
    return _AtlModule.DllCanUnloadNow();
}


// Returns a class factory to create an object of the requested type
STDAPI DllGetClassObject(REFCLSID rclsid, REFIID riid, LPVOID* ppv)
{
    return _AtlModule.DllGetClassObject(rclsid, riid, ppv);
}


// DllRegisterServer - Adds entries to the system registry
STDAPI DllRegisterServer(void)
{
    // registers object, typelib and all interfaces in typelib
    HRESULT hr = _AtlModule.DllRegisterServer();
	return hr;
}


// DllUnregisterServer - Removes entries from the system registry
STDAPI DllUnregisterServer(void)
{
	HRESULT hr = _AtlModule.DllUnregisterServer();
	return hr;
}

STDAPI DllInstall(BOOL bInstall, LPCWSTR pszCmdLine)
{
    HRESULT hr = E_FAIL;
    static const wchar_t szUserSwitch[] = _T("user");
    bool doPerUserRegistration = false;

    if (pszCmdLine != NULL) {
        if (_wcsnicmp(pszCmdLine, szUserSwitch, _countof(szUserSwitch)) == 0) {
            doPerUserRegistration = true;
        }
    }

    AtlSetPerUserRegistration(doPerUserRegistration);

    if (bInstall) {
        hr = DllRegisterServer();
        if (FAILED(hr)) {
            DllUnregisterServer();
        }
    } else {
        hr = DllUnregisterServer();
    }

    return hr;
}
