package org.ovirt.engine.ui.uicommonweb.models.users;

import org.ovirt.engine.core.common.businessentities.DbUser;
import org.ovirt.engine.core.common.businessentities.LdapRefStatus;
import org.ovirt.engine.core.compat.StringHelper;
import org.ovirt.engine.ui.uicommonweb.models.EntityModel;
import org.ovirt.engine.ui.uicompat.ConstantsManager;
import org.ovirt.engine.ui.uicompat.PropertyChangedEventArgs;

@SuppressWarnings("unused")
public class UserGeneralModel extends EntityModel
{
    public UserGeneralModel()
    {
        setTitle(ConstantsManager.getInstance().getConstants().generalTitle());
        setHashName("general"); //$NON-NLS-1$
    }

    private String domain;

    public String getDomain()
    {
        return domain;
    }

    public void setDomain(String value)
    {
        if (!StringHelper.stringsEqual(domain, value))
        {
            domain = value;
            onPropertyChanged(new PropertyChangedEventArgs("Domain")); //$NON-NLS-1$
        }
    }

    private String email;

    public String getEmail()
    {
        return email;
    }

    public void setEmail(String value)
    {
        if (!StringHelper.stringsEqual(email, value))
        {
            email = value;
            onPropertyChanged(new PropertyChangedEventArgs("Email")); //$NON-NLS-1$
        }
    }

    private LdapRefStatus status;

    public LdapRefStatus getStatus()
    {
        return status;
    }

    public void setStatus(LdapRefStatus value)
    {
        if (status != value)
        {
            status = value;
            onPropertyChanged(new PropertyChangedEventArgs("Status")); //$NON-NLS-1$
        }
    }

    @Override
    protected void onEntityChanged()
    {
        super.onEntityChanged();

        if (getEntity() != null)
        {
            updateProperties();
        }
    }

    @Override
    protected void entityPropertyChanged(Object sender, PropertyChangedEventArgs e)
    {
        super.entityPropertyChanged(sender, e);

        updateProperties();
    }

    private void updateProperties()
    {
        DbUser user = (DbUser) getEntity();

        setDomain(user.getDomain());
        setEmail(user.getEmail());
        setStatus(user.getLdapStatus());

    }
}
