@echo off

if "%1%" == "-h" goto Syntax
if "%1%" == "--help" goto Syntax

SET sqlServer="%1%"
if "%1%" == "" set sqlServer=.\sqlexpress

SET dbname=%2%
if "%2%" == "" set dbname=rhevm

SET user=%3%

SET pass=%4%

SET dbcmd=-b -S %sqlServer% -d %dbname% 
if not "%user%" == "" set dbcmd=-b -S %sqlServer% -d %dbname% -U %user% -P %pass% 


for %%v in (%0) do set MyPath=%%~dpv
pushd "%MyPath%"

echo server - %sqlServer%
echo dbname - %dbname%

REM -------------------------------------------------------------------------------
REM Upgrading VDS,Vds_group,VM_pool,Tag & Bokkmark ids from INT to UUID
REM -------------------------------------------------------------------------------

REM Skip INT 2 UUID conversion if already done, trying to select a column that is added
REM after the INT 2 UUID conversion is completed, if column is already there , skip the 
REM drop constrains, int2uuid and create constrains steps.
REM Checking if INT to UUID conversion has been done by retrieving vds_static vds_id column type
sqlcmd  %dbcmd% -h-1 -Q"set nocount on;select data_type  from information_schema.columns Where table_name = 'vds_static' and column_name = 'vds_id'" > tmpfile
set /p dt=<tmpfile
set dt=%dt:~0,3%
del tmpfile
if "%dt%" NEQ "int" goto UPGRADE
sqlcmd  %dbcmd% -i DropConstrains.sql
if %ERRORLEVEL% NEQ 0 goto ERROR
sqlcmd  %dbcmd% -v db=%dbname% dbname=%dbname% -i INT2UUIDUpgrade.sql
if %ERRORLEVEL% NEQ 0 goto ERROR
REM Cleanup all *___old tables and columns
sqlcmd  %dbcmd% -i Cleanup.sql
if %ERRORLEVEL% NEQ 0 goto ERROR
sqlcmd  %dbcmd% -i CreateConstrains.sql
if %ERRORLEVEL% NEQ 0 goto ERROR

:UPGRADE
echo create functions...
sqlcmd  %dbcmd% -v dbname=%dbname% -i functions.sql
if %ERRORLEVEL% NEQ 0 goto ERROR
sqlcmd  %dbcmd% -v dbname=%dbname% -i upgradeToEAP4_6.sql
if %ERRORLEVEL% NEQ 0 goto ERROR
echo refreshing Views and SPs...
call .\refreshStoredProcedures.cmd %1 %2 %3 %4
if %ERRORLEVEL% NEQ 0 goto ERROR


echo inserting pre-defined roles...
sqlcmd  %dbcmd% -i insert_predefined_roles.sql
if %ERRORLEVEL% NEQ 0 goto ERROR

echo Done.

popd

goto:EOF


:Syntax
echo %0 script-path [server] [dbname] [user] [password] [debug]
echo	 script-path - the path to the sql scripts folder
echo     server      - the sql server to access (default = .\sqlexpress)
echo     dbname      - the database name to access/create (default = rhevm)
echo	 user        - the dbo user name (default is to use integrated authentication)
echo	 password    - the dbo password (default is to use integrated authentication)


goto:EOF
:ERROR
exit /b 1
