
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'RethrowError')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].RethrowError AS RETURN')
END
GO

print 'Step 1 done.'
go


ALTER PROCEDURE RethrowError AS
    /* Return if there is no error information to retrieve. */
    IF ERROR_NUMBER() IS NULL
        RETURN;

    DECLARE
        @ErrorMessage    NVARCHAR(4000),
        @ErrorNumber     INT,
        @ErrorSeverity   INT,
        @ErrorState      INT,
        @ErrorLine       INT,
        @ErrorProcedure  NVARCHAR(200); 

    /* Assign variables to error-handling functions that
       capture information for RAISERROR. */

    SELECT
        @ErrorNumber = ERROR_NUMBER(),
        @ErrorSeverity = ERROR_SEVERITY(),
        @ErrorState = ERROR_STATE(),
        @ErrorLine = ERROR_LINE(),
		@ErrorMessage = ERROR_MESSAGE(),
        @ErrorProcedure = ISNULL(ERROR_PROCEDURE(), '-'); 

		-- Insert error to DB log if in debug
		IF ($(debug) = 'true')
		BEGIN	
			INSERT vdc_db_log    
		   (error_code, error_message, error_proc, error_line)
			 VALUES
		   (@ErrorNumber, @ErrorMessage, @ErrorProcedure, @ErrorLine )
		END

    /* Building the message string that will contain original
       error information. */

    SELECT @ErrorMessage = 
        N'Error %d, Level %d, State %d, Procedure %s, Line %d, ' + 
         'Message: '+ ERROR_MESSAGE(); 

    /* Raise an error: msg_str parameter of RAISERROR will contain
	   the original error information. */

    RAISERROR(@ErrorMessage, @ErrorSeverity, 1,
        @ErrorNumber,    /* parameter: original error number. */
        @ErrorSeverity,  /* parameter: original error severity. */
        @ErrorState,     /* parameter: original error state. */
        @ErrorProcedure, /* parameter: original error procedure name. */
        @ErrorLine       /* parameter: original error line number. */
        );


GO

print 'Step 2 done.'
go


/* ---------------------------------------------------------------------- */
/* License Usage                                                          */
/* ---------------------------------------------------------------------- */

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'rhevm_record_license_usage')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].rhevm_record_license_usage AS RETURN')
END
GO

print 'Step 3 done.'
go


ALTER PROCEDURE [dbo].[rhevm_record_license_usage] (
    @dt datetime,
	@lic_desktops int, 
	@used_desktops int, 
	@lic_sockets int , 
	@used_sockets int 
)
AS
BEGIN
	declare @current_lic_desktops int
	declare @current_used_desktops int 
	declare @current_lic_sockets int
	declare @current_used_sockets int 
	declare @month int
	declare @year nchar(4)
	declare @quarter nchar(7)
	declare @now datetime
	if (@dt is NULL) 
		set @dt = getdate()
	set @month = datepart(Month, @dt)
	set @year = cast(datepart(Year, @dt) as nchar)
	if (@month > 0 and @month < 4)
		set @quarter = 'Q1 ' + @year
	else if (@month > 3 and @month < 7)
		set @quarter = 'Q2 ' + @year
	else if (@month > 6 and @month < 10)
		set @quarter = 'Q3 ' + @year
	else
		set @quarter = 'Q4 ' + @year
	if exists (select quarter from rhevm_license_usage where quarter = @quarter)
	begin
		declare @update_info bit
		select @current_lic_desktops = lic_desktops,
               @current_used_desktops = max_used_desktops,
			   @current_lic_sockets = lic_sockets,
			   @current_used_sockets = max_used_sockets
		from rhevm_license_usage
		where quarter = @quarter
				
		set @update_info = 0
		if (@used_desktops > @current_used_desktops or 
            @used_sockets > @current_used_sockets or 
            @lic_desktops > @current_lic_desktops or
            @lic_sockets > @current_lic_sockets)
				set @update_info = 1
		if (@used_desktops <= @current_used_desktops)
			set @used_desktops = @current_used_desktops

		if (@used_sockets <= @current_used_sockets)
			set @used_sockets = @current_used_sockets
		
		if (@update_info = 1)
			update rhevm_license_usage
			set date = @dt,
				lic_desktops = @lic_desktops,
				lic_sockets = @lic_sockets,
				max_used_desktops = @used_desktops,
				max_used_sockets = @used_sockets
			where quarter = @quarter		
	end
	else
	begin
		insert rhevm_license_usage values(@dt,@quarter,@lic_desktops,@used_desktops,@lic_sockets,@used_sockets)
	end
	
	SET NOCOUNT ON;	
	
END
GO

print 'Step 4 done.'
go




IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'attach_user_to_su_role')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].attach_user_to_su_role AS RETURN')
END
GO

print 'Step 5 done.'
go


ALTER PROCEDURE attach_user_to_su_role AS
SET NOCOUNT ON

declare @user_id uniqueidentifier
declare @name varchar(255)
declare @domain varchar(255)
declare @user_name varchar(255)

select @user_id=option_value  from vdc_options where option_name='AdUserId'
select @name=option_value from vdc_options where option_name='AdUserName'
select @domain=option_value from vdc_options where option_name='DomainName'

DECLARE @document varchar(64)
declare @index int

-- find if name already includes domain (@)
SELECT @index = CHARINDEX('@', @name)

if (@index = 0) 
	set @user_name = @name + '@' + @domain
else 
	set @user_name = @name



if not exists (select user_id from users where user_id = @user_id)
begin
	PRINT 'INSERTING Super User USER'
	insert into users ([user_id],[name],[domain],[username],[groups],[status]) 
	values(@user_id, @name, @domain, @user_name,'',1)
end

if not exists (select id from permissions where role_id = '00000000-0000-0000-0000-000000000001' and
               ad_element_id = @user_id and object_id = dbo.getGlobalIds('system'))
begin
	PRINT 'INSERTING Super User PERMISSION'
	insert into permissions (id, role_id, ad_element_id, object_id, object_type_id)
	values(newid(), '00000000-0000-0000-0000-000000000001', @user_id, dbo.getGlobalIds('system'), 1)
end
GO

print 'Step 6 done.'
go



IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'CheckDBConnection')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[CheckDBConnection] AS RETURN')
END

GO

print 'Step 7 done.'
go


ALTER PROCEDURE [dbo].[CheckDBConnection]
AS
BEGIN

    SELECT 1

END

GO 
print 'Step 8 done.'
go

