USE [$(db)]
GO

print 'Step 1 done.'
go


SET ANSI_NULLS ON
GO

print 'Step 2 done.'
go


SET QUOTED_IDENTIFIER ON
GO

print 'Step 3 done.'
go


SET NOCOUNT ON
GO

print 'Step 4 done.'
go


print 'INT to UUID script started...'
go

print 'Step 5 done.'
go


/****************************************************
	           INT ID to UUID Upgrade
****************************************************/


--0) fix problems that might occur as a result of missing constrains
--1) rename all relevant tables adding a suffix "___old"
--2) add a new table per entity with same id name (uniqueidentifier) and <name>___old column at last place
--3) insert data from ___old tables to new created with newid() for new ID
--4) update all relevant tables new ID column with the new generated uniqueidentifier from the mapping table.

	--0) fix problems that might occur as a result of missing constrains 
delete  from vm_statistics where vm_guid not in (select vm_guid from vm_static)
go

print 'Step 6 done.'
go


	--1) rename all relevant tables adding a prefix "___old"
	-------------------------------------------------------
print 'Renaming all relevant tables adding a suffix "___old...'
go

print 'Step 7 done.'
go


declare @int_type int
select @int_type =  system_type_id from sys.types where name = 'int'
if (exists (select name from sys.columns where name = 'vds_id' and 
                                         object_id = object_id('vds_static') and
                                          system_type_id = @int_type))
begin
	exec sp_rename 'vds_static' ,'vds_static___old'	
end

if (exists (select name from sys.columns where name = 'vds_id' and 
                                         object_id = object_id('vds_dynamic') and
                                          system_type_id = @int_type))
begin
	exec sp_rename 'vds_dynamic' ,'vds_dynamic___old'
end
if (exists (select name from sys.columns where name = 'vds_id' and 
                                         object_id = object_id('vds_statistics') and
                                          system_type_id = @int_type))
begin
	exec sp_rename 'vds_statistics' ,'vds_statistics___old'
end

if (exists (select name from sys.columns where name = 'vds_group_id' and 
                                         object_id = object_id('vds_groups') and
                                          system_type_id = @int_type))
begin
	exec sp_rename 'vds_groups' ,'vds_groups___old'
end

if (exists (select name from sys.columns where name = 'cluster_id' and 
                                         object_id = object_id('network_cluster') and
                                          system_type_id = @int_type))
begin
	exec sp_rename 'network_cluster' ,'network_cluster___old'
end

if (exists (select name from sys.columns where name = 'vm_pool_id' and 
                                         object_id = object_id('vm_pools') and
                                          system_type_id = @int_type))
begin
	exec sp_rename 'vm_pools' ,'vm_pools___old'
end

if (exists (select name from sys.columns where name = 'tag_id' and 
                                         object_id = object_id('tags') and
                                          system_type_id = @int_type))
begin
	exec sp_rename 'tags' ,'tags___old'
end

if (exists (select name from sys.columns where name = 'bookmark_id' and 
                                         object_id = object_id('bookmarks') and
                                          system_type_id = @int_type))
begin
	exec sp_rename 'bookmarks' ,'bookmarks___old'
end
go

print 'Step 8 done.'
go


print 'Creating new tables for changed entities...'
go

print 'Step 9 done.'
go



declare @int_type int
select @int_type =  system_type_id from sys.types where name = 'int'

	--2) add a new table per entity with same id name (uniqueidentifier) and <name>___old column at last place
if (not exists (select TABLE_NAME from INFORMATION_SCHEMA.TABLES where TABLE_NAME = 'vds_static'))
begin

	CREATE TABLE [vds_static] (
		[vds_id] uniqueidentifier NOT NULL,
		[vds_name] NVARCHAR(255) NOT NULL,
		[ip] NVARCHAR(40),
		[vds_unique_id] NVARCHAR(128) NULL,
		[host_name] NVARCHAR(255) NOT NULL,
		[port] INTEGER NOT NULL,
		[vds_group_id] uniqueidentifier NOT NULL,
		[server_SSL_enabled] bit,
		[vds_type] int NOT NULL  DEFAULT 0,
		[subnet_mask] nvarchar(255),
		[vds_strength] int NOT NULL  DEFAULT 100,
		[pm_type] nvarchar(20) NULL,
		[pm_user] nvarchar(50) NULL,
		[pm_password] nvarchar(50) NULL,
		[pm_port] integer null,
		[pm_options] nvarchar(max) not null default '',
		[pm_enabled] bit default 0 not null,
		[_create_date] datetime default getdate(),
		[_update_date] datetime NULL,
		[vds_id___old] INTEGER IDENTITY(1,1) NOT NULL ,
		[vds_group_id___old] INTEGER NOT NULL  default -100
	)
end
if (not exists (select TABLE_NAME from INFORMATION_SCHEMA.TABLES where TABLE_NAME = 'vds_dynamic'))
begin


	CREATE TABLE [dbo].[vds_dynamic](
		[vds_id] uniqueidentifier NOT NULL,
		[status] [int] NOT NULL,
		[cpu_cores] [int] NULL,
		[cpu_model] [nvarchar](255)  NULL,
		[cpu_speed_mh] [decimal](18, 0) NULL,
		[if_total_speed] [nvarchar](40)  NULL,
		[kvm_enabled] [bit] NULL,
		[physical_mem_mb] [int] NULL,
		[mem_commited] [int] NULL  DEFAULT 0,
		[vm_active] [int] NULL DEFAULT 0,
		[vm_count] [int] NULL DEFAULT 0,
		[vm_migrating] [int] NULL DEFAULT 0,
		[reserved_mem] [int] NULL,
		[guest_overhead] [int] NULL,
		[software_version] [varchar](40)  NULL,
		[version_name] [varchar](40)  NULL,
		[build_name] [varchar](40)  NULL,
		[previous_status] [int] NULL,
		[cpu_flags] [NVARCHAR](max) NULL,
		[cpu_over_commit_time_stamp] [datetime] NULL,
		[hypervisor_type] [int] NULL,
		[vms_cores_count] [int] NULL,
		[pending_vcpus_count] [int] NULL,
		[cpu_sockets] [int] NULL,
		[net_config_dirty] [bit] NULL,
		[supported_cluster_levels] NVARCHAR(40) NULL,
		[supported_rhevms] NVARCHAR(40) NULL,
		[host_os] [nvarchar](max)  NULL,
		[kvm_version] [nvarchar](max)  NULL,
		[spice_version] [nvarchar](max)  NULL,
		[kernel_version] [nvarchar](max)  NULL,
		[vds_id___old] [int] NOT NULL  default -100		

	)
end
if (not exists (select TABLE_NAME from INFORMATION_SCHEMA.TABLES where TABLE_NAME = 'vds_statistics'))
begin


	CREATE TABLE [dbo].[vds_statistics](
		[vds_id] uniqueidentifier NOT NULL,
		[cpu_idle] [decimal](18, 0) NULL DEFAULT 0,
		[cpu_load] [decimal](18, 0) NULL DEFAULT 0,
		[cpu_sys] [decimal](18, 0) NULL DEFAULT 0,
		[cpu_user] [decimal](18, 0) NULL DEFAULT 0,
		[usage_mem_percent] [int] NULL DEFAULT 0,
		[usage_cpu_percent] [int] NULL DEFAULT 0,
		[usage_network_percent] [int] NULL,
		[mem_available] [BIGINT] NULL,
		[mem_shared] [BIGINT] NULL,
		[swap_free] [BIGINT] NULL,
		[swap_total] [BIGINT] NULL,
		[ksm_cpu_percent] [int] NULL DEFAULT 0,
		[ksm_pages] [BIGINT] NULL,
		[ksm_state] bit NULL ,
		[vds_id___old] [int] NOT NULL default -100
	)

end

if (not exists (select TABLE_NAME from INFORMATION_SCHEMA.TABLES where TABLE_NAME = 'vds_groups'))
begin

	CREATE TABLE [vds_groups] (
		[vds_group_id] uniqueidentifier NOT NULL,
		[name] NVARCHAR(40) NOT NULL,
		[description] NVARCHAR(max),
		[cpu_name] NVARCHAR(255),
		[_create_date] datetime default getdate(),
		[_update_date] datetime NULL,
		[selection_algorithm] int NOT NULL DEFAULT 0,
		[high_utilization] int NOT NULL DEFAULT 75,
		[low_utilization] int NOT NULL DEFAULT 0,
		[cpu_over_commit_duration_minutes] int NOT NULL DEFAULT 2,
		[hypervisor_type] int NOT NULL DEFAULT 0,
		[storage_pool_id] uniqueidentifier NULL,
		[is_initialized] bit NOT NULL DEFAULT 0,
		[max_vds_memory_over_commit] int NOT NULL DEFAULT 100,
		[compatibility_version] NVARCHAR(40) NOT NULL DEFAULT '2.2',
		[vds_group_id___old] INTEGER  IDENTITY(1,1) NOT NULL 
	)
end
if (not exists (select TABLE_NAME from INFORMATION_SCHEMA.TABLES where TABLE_NAME = 'network_cluster'))
begin

	CREATE TABLE [dbo].[network_cluster](
		[network_id] [uniqueidentifier] NOT NULL,
		[cluster_id] [uniqueidentifier] NOT NULL,
		[status] [int] NOT NULL DEFAULT 0,
		[is_display] [bit] NOT NULL DEFAULT 0,
		[cluster_id___old] [int] NOT NULL default -100
	)

end

if (not exists (select TABLE_NAME from INFORMATION_SCHEMA.TABLES where TABLE_NAME = 'vm_pools'))
begin

	CREATE TABLE [vm_pools](
		[vm_pool_id] uniqueidentifier NOT NULL, 
		[vm_pool_name] NVARCHAR(255) NOT NULL,
		[vm_pool_description] NVARCHAR(max) NOT NULL,
		[vm_pool_type] int,
		[parameters]  NVARCHAR(200),
		[vds_group_id] uniqueidentifier,
		[vm_pool_id___old] INTEGER  IDENTITY(1,1) NOT NULL ,
		[vds_group_id___old] int  default -100
	)
	
end

if (not exists (select TABLE_NAME from INFORMATION_SCHEMA.TABLES where TABLE_NAME = 'tags'))
begin

	CREATE TABLE [tags](
		[tag_id] uniqueidentifier NOT NULL,
		[tag_name] NVARCHAR(50) default '' NOT NULL,
		[description] NVARCHAR(max),
		[parent_id]  uniqueidentifier,
		[readonly]  bit,
		[type] int NOT NULL DEFAULT 0,	
		[tag_id___old] INTEGER IDENTITY(1,1) NOT NULL,
		[parent_id___old]  int default -100
	)
	
end

if (not exists (select TABLE_NAME from INFORMATION_SCHEMA.TABLES where TABLE_NAME = 'bookmarks'))
begin

	CREATE TABLE [bookmarks](
		[bookmark_Id] uniqueidentifier NOT NULL,
		[bookmark_name]  NVARCHAR(40),
		[bookmark_value] NVARCHAR(300) NOT NULL,
	    [bookmark_Id___old] INTEGER  IDENTITY(1,1) NOT NULL 
	)
end
go

print 'Step 10 done.'
go

	


--4) insert data from ___old tables to new created with newid() for new uniqueidentifier
print 'Populating new tables with data from old tables...'
go

print 'Step 11 done.'
go


set NOCOUNT ON
declare @int_type int
select @int_type =  system_type_id from sys.types where name = 'uniqueidentifier'
if (exists (select name from sys.columns where name = 'vds_id' and 
                                         object_id = object_id('vds_static') and
                                          system_type_id = @int_type))
begin
	truncate table vds_static
end

if (exists (select name from sys.columns where name = 'vds_id' and 
                                         object_id = object_id('vds_dynamic') and
                                          system_type_id = @int_type))
begin
	truncate table vds_dynamic
end

if (exists (select name from sys.columns where name = 'vds_id' and 
                                         object_id = object_id('vds_statistics') and
                                          system_type_id = @int_type))
begin
	truncate table vds_statistics
end


if (exists (select name from sys.columns where name = 'vds_group_id' and 
                                         object_id = object_id('vds_groups') and
                                          system_type_id = @int_type))
begin
	truncate table vds_groups
end

if (exists (select name from sys.columns where name = 'cluster_id' and 
                                         object_id = object_id('network_cluster') and
                                          system_type_id = @int_type))
begin
	truncate table network_cluster
end

if (exists (select name from sys.columns where name = 'vm_pool_id' and 
                                         object_id = object_id('vm_pools') and
                                          system_type_id = @int_type))
begin
	truncate table vm_pools
end
if (exists (select name from sys.columns where name = 'tag_id' and 
                                         object_id = object_id('tags') and
                                          system_type_id = @int_type))
begin
	truncate table tags
end
if (exists (select name from sys.columns where name = 'bookmark_id' and 
                                         object_id = object_id('bookmarks') and
                                          system_type_id = @int_type))
begin
	truncate table bookmarks
end
go

print 'Step 12 done.'
go


declare @int_type int
select @int_type =  system_type_id from sys.types where name = 'uniqueidentifier'
if (exists (select name from sys.columns where name = 'vds_id' and 
                                         object_id = object_id('vds_static') and
                                          system_type_id = @int_type))
begin
	SET IDENTITY_INSERT vds_static ON
	insert into vds_static (vds_id,vds_name, ip, vds_unique_id, host_name, port, vds_group_id, server_SSL_enabled, vds_type, subnet_mask, vds_strength, pm_type, pm_user, pm_password, pm_port, pm_options, pm_enabled, _create_date, _update_date,vds_id___old,vds_group_id___old)
						   (select newid(), vds_name, ip, vds_unique_id, host_name, port, newid(), server_SSL_enabled, vds_type, subnet_mask, vds_strength, pm_type, pm_user, pm_password, pm_port, pm_options, pm_enabled, _create_date, _update_date,vds_id,vds_group_id from vds_static___old)
	SET IDENTITY_INSERT vds_static OFF
end

if (exists (select name from sys.columns where name = 'vds_id' and 
                                         object_id = object_id('vds_dynamic') and
                                          system_type_id = @int_type))
begin
	insert into vds_dynamic (vds_id, status, cpu_cores, cpu_model, cpu_speed_mh, if_total_speed, kvm_enabled, physical_mem_mb, mem_commited, vm_active, vm_count, vm_migrating, reserved_mem, guest_overhead, software_version, version_name, build_name, previous_status, cpu_flags, cpu_over_commit_time_stamp, hypervisor_type, vms_cores_count, pending_vcpus_count, cpu_sockets, net_config_dirty, supported_cluster_levels, supported_rhevms, host_os, kvm_version, spice_version, kernel_version,vds_id___old)
						   (select newid(), status, cpu_cores, cpu_model, cpu_speed_mh, if_total_speed, kvm_enabled, physical_mem_mb, mem_commited, vm_active, vm_count, vm_migrating, reserved_mem, guest_overhead, software_version, version_name, build_name, previous_status, cpu_flags, cpu_over_commit_time_stamp, hypervisor_type, vms_cores_count, pending_vcpus_count, cpu_sockets, net_config_dirty, supported_cluster_levels, supported_rhevms, host_os, kvm_version, spice_version, kernel_version,vds_id from vds_dynamic___old)
end

if (exists (select name from sys.columns where name = 'vds_id' and 
                                         object_id = object_id('vds_statistics') and
                                          system_type_id = @int_type))
begin
	insert into vds_statistics (vds_id, cpu_idle, cpu_load, cpu_sys, cpu_user, usage_mem_percent, usage_cpu_percent, usage_network_percent, mem_available, mem_shared, swap_free, swap_total, ksm_cpu_percent, ksm_pages, ksm_state,vds_id___old)
						   (select newid(), cpu_idle, cpu_load, cpu_sys, cpu_user, usage_mem_percent, usage_cpu_percent, usage_network_percent, mem_available, mem_shared, swap_free, swap_total, ksm_cpu_percent, ksm_pages, ksm_state,vds_id from vds_statistics___old)
end

if (exists (select name from sys.columns where name = 'vds_group_id' and 
                                         object_id = object_id('vds_groups') and
                                          system_type_id = @int_type))
begin

    SET IDENTITY_INSERT vds_groups ON
	insert into vds_groups (vds_group_id, name, description, cpu_name, _create_date, _update_date, selection_algorithm, high_utilization, low_utilization, cpu_over_commit_duration_minutes, hypervisor_type, storage_pool_id, is_initialized, max_vds_memory_over_commit, compatibility_version,vds_group_id___old)
						   (select newid(), name, description, cpu_name, _create_date, _update_date, selection_algorithm, high_utilization, low_utilization, cpu_over_commit_duration_minutes, hypervisor_type, storage_pool_id, is_initialized, max_vds_memory_over_commit, compatibility_version,vds_group_id from vds_groups___old)
	SET IDENTITY_INSERT vds_groups OFF
end

if (exists (select name from sys.columns where name = 'cluster_id' and 
                                         object_id = object_id('network_cluster') and
                                          system_type_id = @int_type))
begin
	insert into network_cluster (network_id, cluster_id, status, is_display,cluster_id___old)
						   (select network_id, newid(),status, is_display,cluster_id from network_cluster___old)
end


if (exists (select name from sys.columns where name = 'vm_pool_id' and 
                                         object_id = object_id('vm_pools') and
                                          system_type_id = @int_type))
begin
    SET IDENTITY_INSERT vm_pools ON
	insert into vm_pools (vm_pool_id,vm_pool_name, vm_pool_description, vm_pool_type, parameters, vds_group_id,vds_group_id___old,vm_pool_id___old)
						   (select newid(), vm_pool_name, vm_pool_description, vm_pool_type, parameters, newid(),vds_group_id,vm_pool_id from vm_pools___old)
	SET IDENTITY_INSERT vm_pools OFF
end

if (exists (select name from sys.columns where name = 'tag_id' and 
                                         object_id = object_id('tags') and
                                          system_type_id = @int_type))
begin
	SET IDENTITY_INSERT tags ON
	insert into tags (tag_id, tag_name, description, parent_id, readonly, type,tag_id___old,parent_id___old)
						   (select newid(), tag_name, description, newid(), readonly, type,tag_id,parent_id from tags___old)
	SET IDENTITY_INSERT tags OFF
end

if (exists (select name from sys.columns where name = 'bookmark_id' and 
                                         object_id = object_id('bookmarks') and
                                          system_type_id = @int_type))
begin
	SET IDENTITY_INSERT bookmarks ON
	insert into bookmarks (bookmark_Id, bookmark_name, bookmark_value,bookmark_id___old)
						   (select newid(),bookmark_name, bookmark_value,bookmark_id from bookmarks___old)
	SET IDENTITY_INSERT bookmarks OFF
end
go

print 'Step 13 done.'
go




--update
print 'Updating references...'
go

print 'Step 14 done.'
go


update vds_dynamic set vds_id = (select vds_id from vds_static 
								   where  vds_dynamic.vds_id___old = vds_static.vds_id___old)

update vds_statistics set vds_id = (select vds_id from vds_static 
								   where  vds_statistics.vds_id___old = vds_static.vds_id___old)

update vds_static set vds_group_id = (select vds_group_id from vds_groups 
							   where vds_static.vds_group_id___old = vds_groups.vds_group_id___old)
update network_cluster set cluster_id = (select vds_group_id from vds_groups 
							   where  network_cluster.cluster_id___old = vds_groups.vds_group_id___old)

update vm_pools set vds_group_id = (select vds_group_id from vds_groups 
							   where  vm_pools.vds_group_id___old is not null and
							   vm_pools.vds_group_id___old = vds_groups.vds_group_id___old)

-- Update the parent id of all the tags that are children of a not
-- root tag:
update tags set parent_id = (
  select
    t1.tag_id
  from
    tags as t1
  where
    t1.tag_id___old = tags.parent_id___old
)

-- Make sure that all the tags that are direct children of the
-- root (the tag with id -1) get the all zeros id:
update tags set parent_id = '00000000-0000-0000-0000-000000000000' where parent_id___old = -1

go

print 'Step 15 done.'
go



--5) update all relevant tables new ID column with the new generated uniqueidentifier from the mapping table.
--VDS
declare @int_type int
select @int_type =  system_type_id from sys.types where name = 'int'
if (not exists (select name from sys.columns where name = 'vds_id___old' and 
                                         object_id = object_id('audit_log') and
                                          system_type_id = @int_type))
begin
	exec sp_rename 'audit_log.vds_id' , 'vds_id___old'
	alter table audit_log add  vds_id uniqueidentifier null default newid()
end
if (not exists (select name from sys.columns where name = 'vds_id___old' and 
                                         object_id = object_id('interface_statistics') and
                                          system_type_id = @int_type))
begin
	exec sp_rename 'interface_statistics.vds_id' , 'vds_id___old'
	alter table interface_statistics add  vds_id uniqueidentifier null default newid()
end
if (not exists (select name from sys.columns where name = 'vds_id___old' and 
                                         object_id = object_id('tags_vds_map') and
                                          system_type_id = @int_type))
begin
	exec sp_rename 'tags_vds_map.vds_id' , 'vds_id___old'
	alter table tags_vds_map add  vds_id uniqueidentifier not null default newid()
end
if (not exists (select name from sys.columns where name = 'vds_id___old' and 
                                         object_id = object_id('vds_interface') and
                                          system_type_id = @int_type))
begin
	exec sp_rename 'vds_interface.vds_id' , 'vds_id___old'
	alter table vds_interface add  vds_id uniqueidentifier null default newid()
end
if (not exists (select name from sys.columns where name = 'vds_id___old' and 
                                         object_id = object_id('vds_spm_id_map') and
                                          system_type_id = @int_type))
begin
	exec sp_rename 'vds_spm_id_map.vds_id' , 'vds_id___old'
	alter table vds_spm_id_map add  vds_id uniqueidentifier not null default newid()
end
if (not exists (select name from sys.columns where name = 'run_on_vds___old' and 
                                         object_id = object_id('vm_dynamic') and
                                          system_type_id = @int_type))
begin
	exec sp_rename 'vm_dynamic.run_on_vds' , 'run_on_vds___old'
	alter table vm_dynamic add  run_on_vds uniqueidentifier  null default newid()
end
if (not exists (select name from sys.columns where name = 'last_vds_run_on___old' and 
                                         object_id = object_id('vm_dynamic') and
                                          system_type_id = @int_type))
begin
	exec sp_rename 'vm_dynamic.last_vds_run_on' , 'last_vds_run_on___old'
	alter table vm_dynamic add  last_vds_run_on uniqueidentifier  null default newid()
end
if (not exists (select name from sys.columns where name = 'migrating_to_vds___old' and 
                                         object_id = object_id('vm_dynamic') and
                                          system_type_id = @int_type))
begin
	exec sp_rename 'vm_dynamic.migrating_to_vds' , 'migrating_to_vds___old'
	alter table vm_dynamic add  migrating_to_vds uniqueidentifier  null default newid()
end

if (not exists (select name from sys.columns where name = 'spm_vds_id___old' and 
                                         object_id = object_id('storage_pool') and
                                          system_type_id = @int_type))
begin
	exec sp_rename 'storage_pool.spm_vds_id' , 'spm_vds_id___old'
	alter table storage_pool add  spm_vds_id uniqueidentifier  null default newid()
end
if (not exists (select name from sys.columns where name = 'dedicated_vm_for_vds___old' and 
                                         object_id = object_id('vm_static') and
                                          system_type_id = @int_type))
begin
	exec sp_rename 'vm_static.dedicated_vm_for_vds' , 'dedicated_vm_for_vds___old'
	alter table vm_static add  dedicated_vm_for_vds uniqueidentifier  null default newid()
end
go

print 'Step 16 done.'
go


--setting defaults
declare @int_type int
select @int_type =  system_type_id from sys.types where name = 'int'
if ((exists (select name from sys.columns where name = 'vds_id___old' and 
                                         object_id = object_id('tags_vds_map') and
                                          system_type_id = @int_type)) and 
    (not exists(SELECT [name] FROM syscolumns WHERE id = object_id('tags_vds_map') and 
    [name] = 'vds_id___old' AND cdefault > 0)))
begin
	alter table tags_vds_map add constraint DF_tags_vds_map_vds_id___old default  -100 for vds_id___old
end

if ((exists (select name from sys.columns where name = 'vds_id___old' and 
                                         object_id = object_id('vds_spm_id_map') and
                                          system_type_id = @int_type))and 
    (not exists(SELECT [name] FROM syscolumns WHERE id = object_id('vds_spm_id_map') and 
    [name] = 'vds_id___old' AND cdefault > 0)))
begin
	alter table vds_spm_id_map add constraint DF_vds_spm_id_map__vds_id___old default  -100 for vds_id___old
end
go

print 'Step 17 done.'
go


declare @int_type int
select @int_type =  system_type_id from sys.types where name = 'uniqueidentifier'
if (exists (select name from sys.columns where name = 'vds_id' and 
                                         object_id = object_id('audit_log') and
                                          system_type_id = @int_type))
begin
	update audit_log set vds_id = (select vds_id from vds_static 
								   where  audit_log.vds_id___old is not null and
								   audit_log.vds_id___old = vds_static.vds_id___old)
end

if (exists (select name from sys.columns where name = 'vds_id' and 
                                         object_id = object_id('interface_statistics') and
                                          system_type_id = @int_type))
begin
	update interface_statistics set vds_id = (select vds_id from vds_static 
								   where  interface_statistics.vds_id___old is not null and
								   interface_statistics.vds_id___old = vds_static.vds_id___old)
end

if (exists (select name from sys.columns where name = 'vds_id' and 
                                         object_id = object_id('tags_vds_map') and
                                          system_type_id = @int_type))
begin
	update tags_vds_map set vds_id = (select vds_id from vds_static 
								   where  tags_vds_map.vds_id___old = vds_static.vds_id___old)
end

if (exists (select name from sys.columns where name = 'vds_id' and 
                                         object_id = object_id('vds_interface') and
                                          system_type_id = @int_type))
begin
	update vds_interface set vds_id = (select vds_id from vds_static 
								   where  vds_interface.vds_id___old is not null and
								   vds_interface.vds_id___old = vds_static.vds_id___old)
end

if (exists (select name from sys.columns where name = 'vds_id' and 
                                         object_id = object_id('vds_spm_id_map') and
                                          system_type_id = @int_type))
begin
	update vds_spm_id_map set vds_id = (select vds_id from vds_static 
								   where  vds_spm_id_map.vds_id___old = vds_static.vds_id___old)
end

if (exists (select name from sys.columns where name = 'run_on_vds' and 
                                         object_id = object_id('vm_dynamic') and
                                          system_type_id = @int_type))
begin
	update vm_dynamic set run_on_vds = (select vds_id from vds_static 
								   where  vm_dynamic.run_on_vds___old is not null and
								   vm_dynamic.run_on_vds___old = vds_static.vds_id___old)
end

if (exists (select name from sys.columns where name = 'last_vds_run_on' and 
                                         object_id = object_id('vm_dynamic') and
                                          system_type_id = @int_type))
begin
	update vm_dynamic set last_vds_run_on = (select vds_id from vds_static 
								   where  vm_dynamic.last_vds_run_on___old is not null and
								   vm_dynamic.last_vds_run_on___old = vds_static.vds_id___old)
end

if (exists (select name from sys.columns where name = 'migrating_to_vds' and 
                                         object_id = object_id('vm_dynamic') and
                                          system_type_id = @int_type))
begin
	update vm_dynamic set migrating_to_vds = (select vds_id from vds_static 
								   where  vm_dynamic.migrating_to_vds___old is not null and
								   vm_dynamic.migrating_to_vds___old = vds_static.vds_id___old)
end


if (exists (select name from sys.columns where name = 'spm_vds_id' and 
                                         object_id = object_id('storage_pool') and
                                          system_type_id = @int_type))
begin
	update storage_pool set spm_vds_id = (select vds_id from vds_static 
								   where  storage_pool.spm_vds_id___old is not null and
								   storage_pool.spm_vds_id___old = vds_static.vds_id___old)
end

if (exists (select name from sys.columns where name = 'dedicated_vm_for_vds' and 
                                         object_id = object_id('vm_static') and
                                          system_type_id = @int_type))
begin
	update vm_static set dedicated_vm_for_vds = (select vds_id from vds_static 
								   where  vm_static.dedicated_vm_for_vds___old is not null and
								   vm_static.dedicated_vm_for_vds___old = vds_static.vds_id___old)
end
go

print 'Step 18 done.'
go


-- VDS GROUPS
declare @int_type int
select @int_type =  system_type_id from sys.types where name = 'int'
if (not exists (select name from sys.columns where name = 'vds_group_id___old' and 
                                         object_id = object_id('vm_pools') and
                                          system_type_id = @int_type))
begin
	exec sp_rename 'vm_pools.vds_group_id' , 'vds_group_id___old'
	alter table vm_pools add  vds_group_id uniqueidentifier null default newid()
end
if (not exists (select name from sys.columns where name = 'vds_group_id___old' and 
                                         object_id = object_id('vm_static') and
                                          system_type_id = @int_type))
begin
	exec sp_rename 'vm_static.vds_group_id' , 'vds_group_id___old'
	alter table vm_static add  vds_group_id uniqueidentifier not null default newid()
end
if (not exists (select name from sys.columns where name = 'vds_group_id___old' and 
                                         object_id = object_id('vm_templates') and
                                          system_type_id = @int_type))
begin
	exec sp_rename 'vm_templates.vds_group_id' , 'vds_group_id___old'
	alter table vm_templates add  vds_group_id uniqueidentifier not null default newid()
end
go

print 'Step 19 done.'
go

--setting defaults

declare @int_type int
select @int_type =  system_type_id from sys.types where name = 'int'
if ((exists (select name from sys.columns where name = 'vds_group_id___old' and 
                                         object_id = object_id('vm_static') and
                                          system_type_id = @int_type)) and 
    (not exists(SELECT [name] FROM syscolumns WHERE id = object_id('vm_static') and 
    [name] = 'vds_group_id___old' AND cdefault > 0)))
begin
	alter table vm_static add constraint DF_vm_static_vds_group_id___old default  -100 for vds_group_id___old
end
if ((exists (select name from sys.columns where name = 'vds_group_id___old' and 
                                         object_id = object_id('vm_templates') and
                                          system_type_id = @int_type)) and 
    (not exists(SELECT [name] FROM syscolumns WHERE id = object_id('vm_templates') and 
    [name] = 'vds_group_id___old' AND cdefault > 0)))
begin
	alter table vm_templates add constraint DF_vm_templates__vds_group_id___old default  -100 for vds_group_id___old
end
go

print 'Step 20 done.'
go



declare @int_type int
select @int_type =  system_type_id from sys.types where name = 'uniqueidentifier'

if (exists (select name from sys.columns where name = 'vds_group_id' and 
                                         object_id = object_id('vm_pools') and
                                          system_type_id = @int_type))
begin
	update vm_pools set vds_group_id = (select vds_group_id from vds_groups 
								   where  vm_pools.vds_group_id___old is not null and
								   vm_pools.vds_group_id___old = vds_groups.vds_group_id___old)
end

if (exists (select name from sys.columns where name = 'vds_group_id' and 
                                         object_id = object_id('vm_static') and
                                          system_type_id = @int_type))
begin
	update vm_static set vds_group_id = (select vds_group_id from vds_groups 
								   where  vm_static.vds_group_id___old = vds_groups.vds_group_id___old)
end

if (exists (select name from sys.columns where name = 'vds_group_id' and 
                                         object_id = object_id('vm_templates') and
                                          system_type_id = @int_type))
begin
	update vm_templates set vds_group_id = (select vds_group_id from vds_groups 
								   where  vm_templates.vds_group_id___old = vds_groups.vds_group_id___old)
end
go

print 'Step 21 done.'
go


-- VM Pools
declare @int_type int
select @int_type =  system_type_id from sys.types where name = 'int'
if (not exists (select name from sys.columns where name = 'vm_pool_id___old' and 
                                         object_id = object_id('tags_vm_pool_map') and
                                          system_type_id = @int_type))
begin
	exec sp_rename 'tags_vm_pool_map.vm_pool_id' , 'vm_pool_id___old'
	alter table tags_vm_pool_map add  vm_pool_id uniqueidentifier not null default newid()
end
if (not exists (select name from sys.columns where name = 'vm_pool_id___old' and 
                                         object_id = object_id('time_lease_vm_pool_map') and
                                          system_type_id = @int_type))
begin
	exec sp_rename 'time_lease_vm_pool_map.vm_pool_id' , 'vm_pool_id___old'
	alter table time_lease_vm_pool_map add  vm_pool_id uniqueidentifier not null default newid()
end
if (not exists (select name from sys.columns where name = 'vm_pool_id___old' and 
                                         object_id = object_id('vm_pool_map') and
                                          system_type_id = @int_type))
begin
	exec sp_rename 'vm_pool_map.vm_pool_id' , 'vm_pool_id___old'
	alter table vm_pool_map add  vm_pool_id uniqueidentifier null default newid()
end
go

print 'Step 22 done.'
go


-- setting defaults
declare @int_type int
select @int_type =  system_type_id from sys.types where name = 'int'
if ((exists (select name from sys.columns where name = 'vm_pool_id___old' and 
                                         object_id = object_id('tags_vm_pool_map') and
                                          system_type_id = @int_type)) and 
    (not exists(SELECT [name] FROM syscolumns WHERE id = object_id('tags_vm_pool_map') and 
    [name] = 'vm_pool_id___old' AND cdefault > 0)))
begin
	alter table tags_vm_pool_map add constraint DF_tags_vm_pool_map_vm_pool_id___old default  -100 for vm_pool_id___old
end
if ((exists (select name from sys.columns where name = 'vm_pool_id___old' and 
                                         object_id = object_id('time_lease_vm_pool_map') and
                                          system_type_id = @int_type)) and 
    (not exists(SELECT [name] FROM syscolumns WHERE id = object_id('time_lease_vm_pool_map') and 
    [name] = 'vm_pool_id___old' AND cdefault > 0)))
begin
	alter table time_lease_vm_pool_map add constraint DF_time_lease_vm_pool_map_vm_pool_id___old default  -100 for vm_pool_id___old
end
go

print 'Step 23 done.'
go




declare @int_type int
select @int_type =  system_type_id from sys.types where name = 'uniqueidentifier'
if (exists (select name from sys.columns where name = 'vm_pool_id' and 
                                         object_id = object_id('tags_vm_pool_map') and
                                          system_type_id = @int_type))
begin
	update tags_vm_pool_map set vm_pool_id = (select vm_pool_id from vm_pools 
								   where  tags_vm_pool_map.vm_pool_id___old = vm_pools.vm_pool_id___old)
end

if (exists (select name from sys.columns where name = 'vm_pool_id' and 
                                         object_id = object_id('time_lease_vm_pool_map') and
                                          system_type_id = @int_type))
begin
	update time_lease_vm_pool_map set vm_pool_id = (select vm_pool_id from vm_pools 
								   where  time_lease_vm_pool_map.vm_pool_id___old = vm_pools.vm_pool_id___old)
end

if (exists (select name from sys.columns where name = 'vm_pool_id' and 
                                         object_id = object_id('vm_pool_map') and
                                          system_type_id = @int_type))
begin
	update vm_pool_map set vm_pool_id = (select vm_pool_id from vm_pools 
								   where  vm_pool_map.vm_pool_id___old is not null and
								   vm_pool_map.vm_pool_id___old = vm_pools.vm_pool_id___old)
end
go

print 'Step 24 done.'
go


-- TAGS
declare @int_type int
select @int_type =  system_type_id from sys.types where name = 'int'
if (not exists (select name from sys.columns where name = 'tag_id___old' and 
                                         object_id = object_id('tags_permissions_map') and
                                          system_type_id = @int_type))
begin
	exec sp_rename 'tags_permissions_map.tag_id' , 'tag_id___old'
	alter table tags_permissions_map add  tag_id uniqueidentifier not null default newid()
end
if (not exists (select name from sys.columns where name = 'tag_id___old' and 
                                         object_id = object_id('tags_user_group_map') and
                                          system_type_id = @int_type))
begin
	exec sp_rename 'tags_user_group_map.tag_id' , 'tag_id___old'
	alter table tags_user_group_map add  tag_id uniqueidentifier not null default newid()
end
if (not exists (select name from sys.columns where name = 'tag_id___old' and 
                                         object_id = object_id('tags_user_map') and
                                          system_type_id = @int_type))
begin
	exec sp_rename 'tags_user_map.tag_id' , 'tag_id___old'
	alter table tags_user_map add  tag_id uniqueidentifier not null default newid()
end
if (not exists (select name from sys.columns where name = 'tag_id___old' and 
                                         object_id = object_id('tags_vds_map') and
                                          system_type_id = @int_type))
begin
	exec sp_rename 'tags_vds_map.tag_id' , 'tag_id___old'
	alter table tags_vds_map add  tag_id uniqueidentifier not null default newid()
end
if (not exists (select name from sys.columns where name = 'tag_id___old' and 
                                         object_id = object_id('tags_vm_map') and
                                          system_type_id = @int_type))
begin
	exec sp_rename 'tags_vm_map.tag_id' , 'tag_id___old'
	alter table tags_vm_map add  tag_id uniqueidentifier not null default newid()
end
if (not exists (select name from sys.columns where name = 'tag_id___old' and 
                                         object_id = object_id('tags_vm_pool_map') and
                                          system_type_id = @int_type))
begin
	exec sp_rename 'tags_vm_pool_map.tag_id' , 'tag_id___old'
	alter table tags_vm_pool_map add  tag_id uniqueidentifier not null default newid()
end

go

print 'Step 25 done.'
go


-- setting defaults
declare @int_type int
select @int_type =  system_type_id from sys.types where name = 'int'
if ((exists (select name from sys.columns where name = 'tag_id___old' and 
                                         object_id = object_id('tags_permissions_map') and
                                          system_type_id = @int_type)) and 
    (not exists(SELECT [name] FROM syscolumns WHERE id = object_id('tags_permissions_map') and 
    [name] = 'tag_id___old' AND cdefault > 0)))
begin
	alter table tags_permissions_map add constraint DF_tags_permissions_map_tag_id___old default  -100 for tag_id___old			
end
if ((exists (select name from sys.columns where name = 'tag_id___old' and 
                                         object_id = object_id('tags_user_group_map') and
                                          system_type_id = @int_type)) and 
    (not exists(SELECT [name] FROM syscolumns WHERE id = object_id('tags_user_group_map') and 
    [name] = 'tag_id___old' AND cdefault > 0)))
begin
	alter table tags_user_group_map add constraint DF_tags_user_group_map_tag_id___old default  -100 for tag_id___old
end
if ((exists (select name from sys.columns where name = 'tag_id___old' and 
                                         object_id = object_id('tags_user_map') and
                                          system_type_id = @int_type)) and 
    (not exists(SELECT [name] FROM syscolumns WHERE id = object_id('tags_user_map') and 
    [name] = 'tag_id___old' AND cdefault > 0)))
begin
	alter table tags_user_map add constraint DF_tags_user_map_tag_id___old default  -100 for tag_id___old	
end
if ((exists (select name from sys.columns where name = 'tag_id___old' and 
                                         object_id = object_id('tags_vds_map') and
                                          system_type_id = @int_type)) and 
    (not exists(SELECT [name] FROM syscolumns WHERE id = object_id('tags_vds_map') and 
    [name] = 'tag_id___old' AND cdefault > 0)))
begin
	alter table tags_vds_map add constraint DF_tags_vds_map_tag_id___old default  -100 for tag_id___old		
end
if ((exists (select name from sys.columns where name = 'tag_id___old' and 
                                         object_id = object_id('tags_vm_map') and
                                          system_type_id = @int_type)) and 
    (not exists(SELECT [name] FROM syscolumns WHERE id = object_id('tags_vm_map') and 
    [name] = 'tag_id___old' AND cdefault > 0)))
begin
	alter table tags_vm_map add constraint DF_tags_vm_map_tag_id___old default  -100 for tag_id___old		
end
if ((exists (select name from sys.columns where name = 'tag_id___old' and 
                                         object_id = object_id('tags_vm_pool_map') and
                                          system_type_id = @int_type)) and 
    (not exists(SELECT [name] FROM syscolumns WHERE id = object_id('tags_vm_pool_map') and 
    [name] = 'tag_id___old' AND cdefault > 0)))
begin
	alter table tags_vm_pool_map add constraint DF_tags_vm_pool_map_tag_id___old default  -100 for tag_id___old		
end
go

print 'Step 26 done.'
go


declare @int_type int
select @int_type =  system_type_id from sys.types where name = 'uniqueidentifier'
if (exists (select name from sys.columns where name = 'tag_id' and 
                                         object_id = object_id('tags_permissions_map') and
                                          system_type_id = @int_type))
begin
	update tags_permissions_map set tag_id = (select tag_id from tags 
								   where  tags_permissions_map.tag_id___old = tags.tag_id___old)
end

if (exists (select name from sys.columns where name = 'tag_id' and 
                                         object_id = object_id('tags_user_group_map') and
                                          system_type_id = @int_type))
begin
	update tags_user_group_map set tag_id = (select tag_id from tags 
								   where  tags_user_group_map.tag_id___old = tags.tag_id___old)
end

if (exists (select name from sys.columns where name = 'tag_id' and 
                                         object_id = object_id('tags_user_map') and
                                          system_type_id = @int_type))
begin
	update tags_user_map set tag_id = (select tag_id from tags 
								   where  tags_user_map.tag_id___old = tags.tag_id___old)
end

if (exists (select name from sys.columns where name = 'tag_id' and 
                                         object_id = object_id('tags_vds_map') and
                                          system_type_id = @int_type))
begin
	update tags_vds_map set tag_id = (select tag_id from tags 
								   where  tags_vds_map.tag_id___old = tags.tag_id___old)
end

if (exists (select name from sys.columns where name = 'tag_id' and 
                                         object_id = object_id('tags_vm_map') and
                                          system_type_id = @int_type))
begin
	update tags_vm_map set tag_id = (select tag_id from tags 
								   where  tags_vm_map.tag_id___old = tags.tag_id___old)
end

if (exists (select name from sys.columns where name = 'tag_id' and 
                                         object_id = object_id('tags_vm_pool_map') and
                                          system_type_id = @int_type))
begin
	update tags_vm_pool_map set tag_id = (select tag_id from tags 
								   where  tags_vm_pool_map.tag_id___old = tags.tag_id___old)
end
go

print 'Step 27 done.'
go



-- Cleanup
declare @table varchar(128)
declare @col varchar(128)
declare @statement nvarchar(max)
DECLARE DropOldColumnsCursor CURSOR FOR
	select object_name(object_id) as [table], [name]  from sys.columns where name like '%___old' 	
OPEN DropOldColumnsCursor

FETCH NEXT FROM DropOldColumnsCursor INTO @table, @col

WHILE @@FETCH_STATUS = 0
BEGIN
	if ((@table = 'tags' and @col = 'tag_id___old') or
		(@table = 'vds_static' and @col = 'vds_id___old') or
		(@table = 'vds_groups' and @col = 'vds_group_id___old') or
		(@table = 'bookmarks' and @col = 'bookmark_Id___old') or
		(@table = 'vm_pools' and @col = 'vm_pool_id___old'))
	begin -- do not delete *___old fields that served as PK
			FETCH NEXT FROM DropOldColumnsCursor INTO  @table, @col
			continue
	end
	else
	begin
		-- find first if there are constrainst defined on the column and delete them
		declare @name nvarchar(128)	
		declare @actual_col_name varchar(128)
		set @actual_col_name = substring(@col,1,len(@col) - 6)
		-- find constraint name
		select top 1 @name = O.name 
		from sysobjects AS O
		left join sysobjects AS T
			on O.parent_obj = T.id
		where isnull(objectproperty(O.id,'IsMSShipped'),1) = 0
			and O.name not like '%dtproper%'
			and O.name not like 'dt[_]%'
			and T.name = @table
			and (O.name like 'DF_%' + @table + '__' + @actual_col_name + '%' or
                 O.name like 'DF_%' + @table + '__' + @col + '%' or
				 O.name like 'DF_%' + @table + '_' + @actual_col_name + '%' or
                 O.name like 'DF_%' + @table + '_' + @col + '%' or -- handling non-standard names
                 O.name like 'DF__vds_stati__vds_g__%' or
                 O.name like 'DF__vds_stati__vds_i__%' or
				 O.name like 'DF__network_c__clust__%' or
				 O.name like 'DF__vm_pools__vds_gr__%' or 
				 O.name like 'DF__vds_dynam__vds_i__%')
		-- delete if found
		if not @name is null
		begin
			select @statement = 'ALTER TABLE ' + @table + ' DROP CONSTRAINT [' + @name + ']'
			print 'Executing ' + @statement + '...'
			execute sp_executesql @statement
			set @name = null
		end

		set @statement = 'ALTER TABLE ' + @table + ' DROP Column ' + @col
		print 'Executing ' + @statement + '...'
		exec sp_executesql @statement
	end
	FETCH NEXT FROM DropOldColumnsCursor INTO  @table, @col
END
CLOSE DropOldColumnsCursor
DEALLOCATE DropOldColumnsCursor
go

print 'Step 28 done.'
go


/****************************************************
	        END of INT ID to UUID Upgrade
****************************************************/
waitfor delay '00:00:5'
print 'INT to UUID script completed...'
go

print 'Step 29 done.'
go

