#!/usr/bin/python
#
#  Copyright 2011 Red Hat 
#  
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#  
#  http://www.apache.org/licenses/LICENSE-2.0
#  
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

import ConfigParser
import urllib
import urllib2
import base64
import sys
import getopt
import os
from xml.etree import ElementTree

ADDR            = ""
USER            = ""
PASSWD          = ""
API_PORT        = "8443"
VALIDATION      = ""
URL             = ""
PATH_VALIDATION = ""

def usage():
	print "Usage: %s [options] arg\n" % (sys.argv[0])

	print "Options:\n"
	print "\t-h, --help                        \t Show this help message and exit"
	print "\t-i IP, --ip=IP                    \t IP address or host of RHEV-M"
	print "\t-u USER, --user=USER              \t User to login, include @domain. Ex: rhevm@ad.rhev3.com"
	print "\t-p PASSWD, --passw=PASSWD         \t Password"
	print "\t-v PATH_DIR, --validation=PATH_DIR\t Path to the backup dir generated by powershell"

	print "\nExample"
	print "\t%s -i 192.168.123.176 -u rhevm@ad.rhev3.com -p T0pSecreT! -v myBackup_dir_rhev2.2" % (sys.argv[0])

def readCount(config, name):
	value = None
	try:
		value = config.get(name, "count")
	except ConfigParser.NoOptionError:
		print "Cannot find count for: %s" % name
		sys.exit(2)
	return int(value)

def getNumber(apiName):

        if apiName == "datacenters":
                searchStr = "data_center" + "/name"
        elif apiName == "storagedomains":
                searchStr = "storage_domain" + "/name"
        else:
                # [:-1] - remove the last caracter in the string - in this case 's'
                # We use this approach to re-use the string of URL into the XML search (see below)
                searchStr = apiName[:-1] + "/name"

        # First try to get the count from the summary, if available:
        tree = getTree("")
        value = tree.findtext("summary/" + apiName + "/total")
        if value:
                return int(value)
        
        # If no summary is available then load the collection and
        # count the elements using paging, in order to avoid
        # problems when there are more than 100 elements in the
        # collection:
        count = 0
        page = 1
        while True:
                 tree = getTree(apiName, search="page %d" % page)
                 if tree:
                         list = tree.findall(searchStr)
                         count += len(list)
                         page += 1
                 else:
                         break
        return count
            
def getTree(path, **parameters):
        url = "https://" + ADDR + ":" + API_PORT + "/api/" + path
        if parameters:
                url = url + "?" + urllib.urlencode(parameters)

        request = urllib2.Request(url)

        base64string = base64.encodestring('%s:%s' % (USER, PASSWD)).strip()
        request.add_header("Authorization", "Basic %s" % base64string)

        try:
                xmldata = urllib2.urlopen(request).read()
        except urllib2.URLError, e:
                print "Error: cannot connect to REST API: %s" % (e)
                print "Try to login using the same user/pass by the Admin Portal and check the error!"
                sys.exit(2)

        return ElementTree.XML(xmldata)

if __name__ == "__main__":

	try:
		opts, args = getopt.getopt(sys.argv[1:], "hi:u:p:v:", ["help", "user", "passwd", "validation"])
	except getopt.error, msg:
		print msg
		print "for help use --help"
		sys.exit(2)

	# Checking number of arguments	
	if len(opts) < 3:
		print "please check the number of arguments required"
		usage()
		sys.exit()

	# process options
	for o, argument in opts:
		if o in ("-h", "--help"):
			usage()
			sys.exit(0)

		if o in ("-i", "--ip"):
			ADDR = argument

		if o in ("-u", "--user"):
			USER = argument

		if o in ("-p", "--passwd"):
			PASSWD = argument

		if o in ("-v", "--validation"):
			VALIDATION = argument

	# process arguments
	for arg in args:
		process(arg) # process() is defined elsewhere

	# Getting info from REST API
	rhev3_number_clusters       = getNumber("clusters")
	rhev3_number_datacenters    = getNumber("datacenters")
	rhev3_number_hosts          = getNumber("hosts")
	rhev3_number_storagedomains = getNumber("storagedomains")
	rhev3_number_templates      = getNumber("templates")
	rhev3_number_vms	    = getNumber("vms")

	# RHEV 3 - beta 3 will include /users in API
	#nro_users_rhev3 = getNumber("users")

	# DEBUG
	"""
	print "rhev3_number_clusters: %d" % (rhev3_number_clusters)
	print "rhev3_number_datacenters: %s"    % rhev3_number_datacenters
	print "rhev3_number_hosts: %s"          % rhev3_number_hosts
	print "rhev3_number_storagedomains: %s" % rhev3_number_storagedomains
	print "rhev3_number_templates: %s"      % rhev3_number_templates
	print "rhev3_number_vms %s"             % rhev3_number_vms
	"""

	# Checking validation path
	if os.path.exists(VALIDATION) == False:
		print "Cannot find the directory: %s" % (VALIDATION)
		sys.exit(2)

	# Read the file with the results from Windows
	windows_results_file = os.path.join(VALIDATION, "results.ini")
	if not os.path.exists(windows_results_file):
		print "Cannot find the file: %s" % windows_results_file
		sys.exit(2)
	windows_results = ConfigParser.RawConfigParser()
	windows_results.read(windows_results_file)

	rhev2_number_clusters       = readCount(windows_results, "cluster")
	rhev2_number_datacenters    = readCount(windows_results, "dataCenter")
	rhev2_number_hosts	    = readCount(windows_results, "host")
	rhev2_number_storagedomains = readCount(windows_results, "storageDomain")
	rhev2_number_templates	    = readCount(windows_results, "template")
	rhev2_number_vms	    = readCount(windows_results, "vm")

	# DEBUG
	"""
	print "rhev2_number_clusters: %s"       % rhev2_number_clusters
	print "rhev2_number_datacenters: %s"    % rhev2_number_datacenters
	print "rhev2_number_hosts: %s"          % rhev2_number_hosts
	print "rhev2_number_storagedomains: %s" % rhev2_number_storagedomains
	print "rhev2_number_templates: %s"      % rhev2_number_templates
	print "rhev2_number_vms %s"             % rhev2_number_vms
	"""

	if rhev2_number_clusters != rhev3_number_clusters:
		print "Please contact Red Hat support, your database needs to be reviewed (clusters)"
		print "rhev2_number_clusters: %s rhev3_number_clusters: %s" %(rhev2_number_clusters, rhev3_number_clusters)
		sys.exit(-1)
	else:
		print "database check: clusters [OK]"

	if rhev2_number_datacenters != rhev3_number_datacenters:
		print "Please contact Red Hat support, your database needs to be reviewed (datacenters)"
		print "rhev2_number_datacenters: %s rhev3_number_datacenters: %s" %(rhev2_number_datacenters, rhev3_number_datacenters)
		sys.exit(-1)
	else:
		print "database check: datacenters [OK]"

	if rhev2_number_hosts != rhev3_number_hosts:
		print "Please contact Red Hat support, your database needs to be reviewed (hosts)"
		print "rhev2_number_hosts: %s rhev3_number_hosts: %s" %(rhev2_number_hosts, rhev3_number_hosts)
		sys.exit(-1)
	else:
		print "database check: hosts [OK]"

	if rhev2_number_storagedomains != rhev3_number_storagedomains:
		print "Please contact Red Hat support, your database needs to be reviewed (storagedomains)"
		print "rhev2_number_storagedomains: %s rhev3_number_storagedomains: %s" %(rhev2_number_storagedomains, rhev3_number_storagedomains)
		sys.exit(-1)
	else:
		print "database check: storagedomains [OK]"

	if rhev2_number_templates != rhev3_number_templates:
		print "Please contact Red Hat support, your database needs to be reviewed (templates)"
		print "rhev2_number_templates: %s rhev3_number_templates: %s" %(rhev2_number_templates, rhev3_number_templates)
		sys.exit(-1)
	else:
		print "database check: templates [OK]"

	if rhev2_number_vms != rhev3_number_vms:
		print "Please contact Red Hat support, your database needs to be reviewed (vms)"
		print "rhev2_number_vms: %s rhev3_number_vms: %s" %(rhev2_number_vms, rhev3_number_vms)
		sys.exit(-1)
	else:
		print "database check: vms [OK]"

	print "Approved! Done!"
	sys.exit(0)
