@ECHO OFF

IF (%3)==() GOTO Usage
IF NOT EXIST %1 GOTO noManifest

set curDir=%2
IF NOT EXIST %curDir% GOTO noDir
set curDir=%3
IF NOT EXIST %curDir% GOTO noDir

set JV_HOME=%JAVA_HOME:Program Files (x86)=PROGRA~2%
set JV_HOME=%JAVA_HOME:Program Files=PROGRA~1%

set MY_JAVA=java
%MY_JAVA% -help >NUL 2>&1 || set MY_JAVA=%JV_HOME%\bin\java 
%MY_JAVA% -help >NUL 2>&1 || GOTO noJava
set MY_JAVAC=javac
%MY_JAVAC% -help >NUL 2>&1 || set MY_JAVAC=%JV_HOME%\bin\javac 
%MY_JAVAC% -help >NUL 2>&1 || GOTO noJava

IF NOT EXIST ManifestUtil.class (
        %MY_JAVAC% ManifestUtil.java
)

%MY_JAVA% ManifestUtil -csv=%1 -ear=%2 -root=%3 %4
EXIT /B %ERRORLEVEL%

:Usage
ECHO test-manifest.bat- validate manifest file relevance.
ECHO Usage: 
ECHO     test-manifest [csv] [ear] [root] [-debug]
ECHO     ie: test-manifest.bat manifest-3.0.csv ..\ear\target\rhevm C:\dev\rhevm.git
ECHO Where:
ECHO	 csv	= Path to manifest file.
ECHO	 ear	= Path to EAR folder
ECHO	 root	= Path to project root folder
ECHO	 -debug	= A flag to print lots of ugly messages (optional)
Exit /B 1

:noDir
ECHO Directory %curDIR% does not exist!
Exit /B 1

:noManifest
ECHO Manifest file %1 does not exist!
Exit /B 1

:noJava
ECHO This script requiers either java and javac are in the PATH or JAVA_HOME defined.
Exit /B 1
