using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using Microsoft.Practices.Unity;
using VdcCommon.BusinessEntities;
using org.ovirt.engine.ui.uicommon;
using org.ovirt.engine.ui.uicommon.models.users;
using org.ovirt.engine.ui.uicommon.models.configure;

namespace UI.WPFClient
{
	public partial class UserListView
	{
		private WindowView view;

		public new UserListModel Model
		{
			get { return base.Model as UserListModel; }
			set { base.Model = value; }
		}

		public UserListView()
		{
			InitializeComponent();
		}

		protected override void ModelPropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			base.ModelPropertyChanged(sender, e);

			if (e.PropertyName != "Window") return;

			if (Model.Window != null)
			{
				if (Model.LastExecutedCommand == Model.AddCommand)
				{
					view = TypeResolver.Instance.Resolve<FindUserView>();
				}
				else if (Model.LastExecutedCommand == Model.RemoveCommand)
				{
					view = TypeResolver.Instance.Resolve<RemoveView>();
				}
				else if (Model.LastExecutedCommand == Model.AssignTagsCommand)
				{
					view = TypeResolver.Instance.Resolve<AssignTagsView>();
				}
				else
				{
					throw new NotImplementedException();
				}

				view.Model = Model.Window;
				WindowManager.AddWindow(view);
			}
			else
			{
				WindowManager.RemoveWindow(view);
				view = null;
			}
		}

		private void RemoveCommand_Executed(object sender, ExecutedRoutedEventArgs e)
		{
			Model.RemoveCommand.Execute();
		}

		private void RemoveCommand_CanExecute(object sender, CanExecuteRoutedEventArgs e)
		{
			e.CanExecute = Model.RemoveCommand.IsExecutionAllowed;
		}

		private void NewCommand_Executed(object sender, ExecutedRoutedEventArgs e)
		{
			Model.AddCommand.Execute();
		}
	}
}
