using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using org.ovirt.engine.ui.uicommon;
using System.Windows.Interop;
using System.Configuration;
using org.ovirt.engine.ui.uicommon.models;
using org.ovirt.engine.ui.uicompat;
using System.Globalization;
using Microsoft.Practices.Unity;

namespace UI.WPFClient
{
	public partial class LoginView
	{
		private WindowView view;

		public new LoginModel Model
		{
			get { return base.Model as LoginModel; }
			set { base.Model = value; }
		}


		public LoginView()
		{
			InitializeComponent();

			UpdateCertCookie();

			Loaded += new RoutedEventHandler(LoginView_Loaded);
		}

		void LoginView_Loaded(object sender, RoutedEventArgs e)
		{
			Model.UserName.PropertyChanged += new PropertyChangedEventHandler(LoginCommand_PropertyChanged);
		}

		void LoginCommand_PropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			if (e.PropertyName == "IsChangable" && Model != null && Model.UserName.IsChangable)
			{
				Keyboard.Focus(UserNameTextBox);
			}
		}

		protected override void ModelPropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			base.ModelPropertyChanged(sender, e);

			if (e.PropertyName != "Window") return;

			if (Model.Window != null)
			{
				if (Model.LastExecutedCommand == Model.AboutCommand)
				{
					view = TypeResolver.Instance.Resolve<AboutView>();
				}
				else
				{
					throw new NotImplementedException();
				}

				view.Model = Model.Window;
				WindowManager.AddWindow(view);
			}
			else
			{
				WindowManager.RemoveWindow(view);
				view = null;
			}
		}

		private void UpdateCertCookie()
		{
			try
			{
				// Write Application Certificate cookie:
				string rhevmCookieName = ConfigurationManager.AppSettings["RhevmCertCookieName"];
				string rhevmCookieValue = ConfigurationManager.AppSettings["RhevmCertCookieValue"];
				WriteCookie(rhevmCookieName, rhevmCookieValue);

				if (BrowserInteropHelper.Source.Scheme == "https")
				{
					// Write Server Certificate cookie (only in case of https):
					string serverCookieName = ConfigurationManager.AppSettings["ServerCertCookieName"];
					string serverCookieValue = ConfigurationManager.AppSettings["ServerCertCookieValue"];
					WriteCookie(serverCookieName, serverCookieValue);
				}
			}
			catch (Exception ex)
			{
				Logger.Warn("LoginView:UpdateCertCookie: Error while writing certificate-related cookies: " + ex.Message);
			}
		}

		private static void WriteCookie(string cookieName, string cookieValue)
		{
			string expires =
				DateTime.Now.AddDays(1000.0).ToString("ddd, dd-MMM-yyyy HH:mm:ss", CultureInfo.InstalledUICulture);
			string updatedCookie = string.Format("{0}={1}; expires={2}", cookieName, cookieValue, expires);
			Application.SetCookie(BrowserInteropHelper.Source, updatedCookie);
		}

		private void AboutCommand_Executed(object sender, ExecutedRoutedEventArgs e)
		{
			Model.AboutCommand.Execute();
		}

#if DEBUG
		protected override void ModelChanged()
		{
			base.ModelChanged();

			if (Model == null) return;

			Model.LoginCommand.PropertyChanged +=
				(s, args) =>
				{
					if (Model == null) return;

					if (!Model.LoginCommand.IsExecutionAllowed) return;

					Model.UserName.Entity = "vdcadmin";
					Model.Password.Entity = "123456";
					Model.Domain.SelectedItem = "qa.lab.tlv.redhat.com";
					Model.LoginCommand.Execute();
				};
		}
#endif
	}
}
