using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using org.ovirt.engine.ui.uicompat;
using Microsoft.Practices.Unity;
using org.ovirt.engine.ui.uicommon;
using VdcCommon.BusinessEntities;
using org.ovirt.engine.ui.uicommon.models.clusters;
using org.ovirt.engine.ui.uicommon.models;
using org.ovirt.engine.ui.uicommon.models.hosts;
using org.ovirt.engine.ui.uicommon.models.configure;

namespace UI.WPFClient
{
	public partial class ClusterListView
	{
		private WindowView view1;
		private WindowView view2;

		public new ClusterListModel Model
		{
			get { return base.Model as ClusterListModel; }
			set { base.Model = value; }
		}


		public ClusterListView()
		{
			InitializeComponent();
		}

		protected override void ModelPropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			base.ModelPropertyChanged(sender, e);

			if (e.PropertyName == "Window")
			{
				if (Model.Window != null)
				{
					if (Model.LastExecutedCommand == Model.NewCommand)
					{
						view1 = TypeResolver.Instance.Resolve<ClusterView>();
					}
					else if (Model.LastExecutedCommand == Model.EditCommand)
					{
						view1 = TypeResolver.Instance.Resolve<ClusterView>();
					}
					else if (Model.LastExecutedCommand == Model.RemoveCommand)
					{
						view1 = TypeResolver.Instance.Resolve<RemoveView>();
					}
					else if (Model.LastExecutedCommand == Model.GuideCommand)
					{
						view1 = TypeResolver.Instance.Resolve<ClusterGuideView>();
					}
					else
					{
						throw new NotImplementedException();
					}

					view1.Model = Model.Window;
					WindowManager.AddWindow(view1);
				}
				else
				{
					WindowManager.RemoveWindow(view1);
					view1 = null;
				}
			}

			if (e.PropertyName == "ConfirmWindow")
			{
				if (Model.ConfirmWindow != null)
				{
					view2 = TypeResolver.Instance.Resolve<ConfirmationView>();
					WindowManager.AddWindow(view2);
					view2.Model = Model.ConfirmWindow;
				}
				else
				{
					WindowManager.RemoveWindow(view2);
					view2 = null;
				}
			}
		}

		private void RemoveCommand_Executed(object sender, ExecutedRoutedEventArgs e)
		{
			Model.RemoveCommand.Execute();
		}

		private void RemoveCommand_CanExecute(object sender, CanExecuteRoutedEventArgs e)
		{
			e.CanExecute = Model.RemoveCommand.IsExecutionAllowed;
		}

		private void EditCommand_Executed(object sender, ExecutedRoutedEventArgs e)
		{
			Model.EditCommand.Execute();
		}

		private void EditCommand_CanExecute(object sender, CanExecuteRoutedEventArgs e)
		{
			e.CanExecute = Model.EditCommand.IsExecutionAllowed;
		}

		private void NewCommand_Executed(object sender, ExecutedRoutedEventArgs e)
		{
			Model.NewCommand.Execute();
		}

		private void GuideMeButton_Click(object sender, RoutedEventArgs e)
		{
			if (Model.Window != null && Model.Window.GetType() == typeof(ClusterGuideModel))
			{
				return;
			}
			VDSGroup cluster = (VDSGroup)Model.SelectedItem;
			Model.GuideContext = cluster.ID;
			Model.GuideCommand.Execute();
		}
	}
}
