﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;

namespace UI.WPFClient
{
	public class EditableComboBox : System.Windows.Controls.ComboBox
	{
		private System.Windows.Controls.TextBox textBox;
		private bool selectionChanged;

		public EditableComboBox()
		{
			Loaded += new RoutedEventHandler(EditableComboBox_Loaded);
			SelectionChanged += new System.Windows.Controls.SelectionChangedEventHandler(EditableComboBox_SelectionChanged);
		}

		void EditableComboBox_Loaded(object sender, RoutedEventArgs e)
		{
			textBox = (System.Windows.Controls.TextBox)GetTemplateChild("PART_EditableTextBox");
			if (textBox != null)
			{
				textBox.SelectionLength = 0;
				textBox.SelectionChanged += new RoutedEventHandler(textBox_SelectionChanged);
			}
		}

		void EditableComboBox_SelectionChanged(object sender, System.Windows.Controls.SelectionChangedEventArgs e)
		{
			selectionChanged = true;
		}

		void textBox_SelectionChanged(object sender, RoutedEventArgs e)
		{
			if (textBox.SelectionLength > 0 && selectionChanged)
			{
				textBox.SelectionLength = 0;
				selectionChanged = false;
			}
		}
	}
}
