﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;
using System.Windows.Interactivity;

namespace UI.WPFClient
{
	public class DraggableBehavior : Behavior<FrameworkElement>
	{
		#region Properties

		//Not supported.
		public bool BringOnTopWhenDragging { get; set; }
		public bool LeaveOnTopAfterDrag { get; set; }
		public bool AllowHorizontalDrag { get; set; }
		public bool AllowVerticalDrag { get; set; }


		public static bool GetIsDragging(DependencyObject obj)
		{
			return (bool)obj.GetValue(IsDraggingProperty);
		}

		public static void SetIsDragging(DependencyObject obj, bool value)
		{
			obj.SetValue(IsDraggingProperty, value);
		}

		public static readonly DependencyProperty IsDraggingProperty =
			DependencyProperty.RegisterAttached("IsDragging", typeof(bool), typeof(DraggableBehavior), new UIPropertyMetadata(false));


		public FrameworkElement DragHandle
		{
			get { return (FrameworkElement)GetValue(DragHandleProperty); }
			set { SetValue(DragHandleProperty, value); }
		}
		public static readonly DependencyProperty DragHandleProperty =
			DependencyProperty.Register("DragHandle", typeof(FrameworkElement), typeof(DraggableBehavior), new UIPropertyMetadata(null));

		#endregion

		public DraggableBehavior()
		{
			AllowHorizontalDrag = true;
			AllowVerticalDrag = true;

			mainWindow = Application.Current.MainWindow;
		}

		protected override void OnAttached()
		{
			base.OnAttached();

			var dragHandle = DragHandle ?? AssociatedObject;

			dragHandle.MouseLeftButtonDown += AssociatedObject_MouseLeftButtonDown;
		}

		protected override void OnDetaching()
		{
			base.OnDetaching();

			var dragHandle = DragHandle ?? AssociatedObject;

			dragHandle.MouseLeftButtonDown -= AssociatedObject_MouseLeftButtonDown;
		}

		private double xOffset;
		private double yOffset;
		private readonly Window mainWindow;

		void AssociatedObject_MouseLeftButtonDown(object sender, MouseButtonEventArgs e)
		{
			if (e.LeftButton == MouseButtonState.Pressed)
			{
				Point mousePosition = Mouse.GetPosition(mainWindow);

				xOffset = AssociatedObject.Margin.Left - mousePosition.X;
				yOffset = AssociatedObject.Margin.Top - mousePosition.Y;

				mainWindow.MouseMove += mainWindow_MouseMove;
				mainWindow.MouseLeftButtonUp += mainWindow_MouseLeftButtonUp;

				SetIsDragging(AssociatedObject, true);
			}
		}

		void mainWindow_MouseLeftButtonUp(object sender, MouseButtonEventArgs e)
		{
			SetIsDragging(AssociatedObject, false);

			mainWindow.MouseMove -= mainWindow_MouseMove;
			mainWindow.MouseLeftButtonUp -= mainWindow_MouseLeftButtonUp;

			xOffset = 0;
			yOffset = 0;
		}

		void mainWindow_MouseMove(object sender, MouseEventArgs e)
		{
			Point mousePosition = Mouse.GetPosition(mainWindow);
			AssociatedObject.Margin = new Thickness(AllowHorizontalDrag ? mousePosition.X + xOffset : AssociatedObject.Margin.Left, AllowVerticalDrag ? mousePosition.Y + yOffset : AssociatedObject.Margin.Top, 0, 0);
		}
	}
}
