using System.Collections.Generic;
using System.Runtime.Remoting.Messaging;
using System.ServiceModel;
using System.Web;

namespace VdcUtils
{
    public interface IDataProvider
    {
        object GetData(string key);
        void SetData(string key, object value);
        object GetData(string sessionId, string key);
        void SetData(string sessionId,string key, object value);
    }
    public class ContextDataProvider :  IDataProvider
    {
        private Dictionary<string, Dictionary<string, object>>  _context = new
            Dictionary<string, Dictionary<string, object>>();
        private const string DefaultSession ="defaultSession";
        #region IDataProvider Members

        public object GetData(string key)
        {
            string sessionId;
            if (OperationContext.Current != null)
            {
                sessionId = OperationContext.Current.SessionId;
            }
            else
            {
                sessionId =  DefaultSession;
            }
            return GetData(sessionId, key);
        }

        public void SetData(string key, object value)
        {
            string sessionId = null;
            try
            {
                //client side
				if (//Config.GetValue<bool>(ConfigValues.RemoteBackend) &&
					//Config.GetValue<string>(ConfigValues.RemoteInterface) != "Remoting" && 
                    SessionContainer.Instance.Director != null)
                {
                    SessionContainer.Instance.Director.SetSessionData(key, value);
                }
                else if (OperationContext.Current != null)
                {
                    sessionId = OperationContext.Current.SessionId;
                }
                sessionId = sessionId ?? DefaultSession;
            }
            catch
            {
                return;
            }
            SetData(sessionId,key,value);
            //Dictionary<string, object> currentContext = null;
            //if (!_context.TryGetValue(sessionId, out currentContext))
            //{
            //    currentContext = new Dictionary<string, object>();
            //    _context.Add(sessionId,currentContext);
            //}
            //currentContext[key] = value;
        }

        public object GetData(string sessionId, string key)
        {
            object returnValue = null;
            Dictionary<string, object> currentContext;
            if (_context.TryGetValue(sessionId,out currentContext))
            {
                currentContext.TryGetValue(key, out returnValue);
            }
            return returnValue;
        }

        public void SetData(string sessionId, string key, object value)
        {
            Dictionary<string, object> currentContext = null;
            if (!_context.TryGetValue(sessionId, out currentContext))
            {
                currentContext = new Dictionary<string, object>();
                _context.Add(sessionId, currentContext);
            }
            currentContext[key] = value;
        }

        #endregion
    }

    public sealed class SessionContainer
    {
        #region Singleton
        private static readonly SessionContainer _instance = new SessionContainer();
        public static SessionContainer Instance
        {
            get
            {
                return _instance;
            }
        }

        
        static SessionContainer()
        {}
        private SessionContainer ()
        {
                _provider = new ContextDataProvider();
            }
        #endregion
        private readonly IDataProvider _provider;
        private ISession _director;
        public ISession Director
        {
            get { return _director; }
            set { _director = value; }
        }
        public object GetData(string key)
        {
            if (_provider != null)
            {
                return _provider.GetData(key);
            }
            else
            {
                return null;
            }
        }
        public object GetData(string sessionId,string key)
        {
            if (_provider != null)
            {
                return _provider.GetData(sessionId, key);
            }
            else
            {
                return null;
            }
        }
        public void SetData(string key, object value)
        {
            if (_provider != null)
            {
                _provider.SetData(key, value);
            }
        }
        public void SetData(string sessionId, string key, object value)
        {
            if (_provider != null)
            {
                _provider.SetData(sessionId,key, value);
            }
        }
    }
}
