﻿using System;

namespace org.ovirt.engine.ui.uicommon.validation
{
	public class LengthValidation : IValidation
	{
		public int MaxLength { get; set; }

		public LengthValidation()
		{
			MaxLength = Int32.MaxValue;
		}

		public ValidationResult Validate(object value)
		{
			ValidationResult result = new ValidationResult();

			if (value != null && value is String && ((string)value).Length > MaxLength)
			{
				result.Success = false;
				result.Reasons.Add(String.Format("Field content must not exceed {0} characters.", MaxLength));
			}

			return result;
		}
	}
}