using System;
using System.Collections.Generic;
using System.Text;

using System.ComponentModel;
using org.ovirt.engine.ui.uicommon.dataprovider;
using VdcCommon.BusinessEntities;
using VdcFrontend;

namespace org.ovirt.engine.ui.uicommon.models.vms
{
	public class VmMonitorModel : EntityModel
	{
		#region Commands

		public UICommand RefreshCommand { get; private set; }

		#endregion

		#region Properties

		private int cpuUsage;
		public int CpuUsage
		{
			get { return cpuUsage; }
			set
			{
				if (cpuUsage != value)
				{
					cpuUsage = value;
					OnPropertyChanged(new PropertyChangedEventArgs("CpuUsage"));
				}
			}
		}

		private int memoryUsage;
		public int MemoryUsage
		{
			get { return memoryUsage; }
			set
			{
				if (memoryUsage != value)
				{
					memoryUsage = value;
					OnPropertyChanged(new PropertyChangedEventArgs("MemoryUsage"));
				}
			}
		}

		private int networkUsage;
		public int NetworkUsage
		{
			get { return networkUsage; }
			set
			{
				if (networkUsage != value)
				{
					networkUsage = value;
					OnPropertyChanged(new PropertyChangedEventArgs("NetworkUsage"));
				}
			}
		}

		#endregion

		public VmMonitorModel()
		{
			Title = "Monitor";

			RefreshCommand = new UICommand("Refresh", this);
		}

		public override void ExecuteCommand(UICommand command)
		{
			base.ExecuteCommand(command);

			if (command == RefreshCommand)
			{
				Refresh();
			}
		}

		private void Refresh()
		{
			if (Entity == null)
			{
				return;
			}

			VM vm = (VM)Entity;
			AsyncQuery _asyncQuery = new AsyncQuery();
			_asyncQuery.Model = this;
			/*START_DELEGATE*/_asyncQuery.asyncCallback = delegate(Object model, Object result)
			{
				VM vm1 = (VM)result;
				VmMonitorModel vmMonitorModel = (VmMonitorModel) model;
				vmMonitorModel.CpuUsage = vm1.usage_cpu_percent.GetValueOrDefault();
				vmMonitorModel.MemoryUsage = vm1.usage_mem_percent.GetValueOrDefault();
				vmMonitorModel.NetworkUsage = vm1.usage_network_percent.GetValueOrDefault();
			};//END_DELEGATE
			AsyncDataProvider.GetVmById(_asyncQuery, vm.vm_guid);
		}
	}
}
