using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using System.Windows;
using org.ovirt.engine.ui.uicompat;
using VdcCommon.BusinessEntities;

namespace org.ovirt.engine.ui.uicommon.models.vms
{
	public abstract class ConsoleModel : EntityModel
	{
		public const string EjectLabel = "[Eject]";

		#region Event

		public static EventDefinition ErrorEventDefinition;
		public Event ErrorEvent { get; private set; }

		#endregion

		#region Commands

		public UICommand ConnectCommand { get; private set; }

		#endregion

		#region Properties

		private bool isConnected;
		public bool IsConnected
		{
			get { return isConnected; }
			set
			{
				if (isConnected != value)
				{
					isConnected = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsConnected"));
				}
			}
		}

		private bool forceVmStatusUp;
		public bool ForceVmStatusUp
		{
			get { return forceVmStatusUp; }
			set
			{
				if (forceVmStatusUp != value)
				{
					forceVmStatusUp = value;
					OnPropertyChanged(new PropertyChangedEventArgs("ForceVmStatusUp"));
				}
			}
		}

		public new VM Entity
		{
			get { return (VM)base.Entity; }
			set { base.Entity = value; }
		}

		#endregion

		static ConsoleModel()
		{
			ErrorEventDefinition = new EventDefinition("Error", typeof(ConsoleModel));
		}

		protected ConsoleModel()
		{
			ErrorEvent = new Event(ErrorEventDefinition);

			ConnectCommand = new UICommand("Connect", this);
		}

		protected abstract void Connect();

		protected override void OnEntityChanged()
		{
			base.OnEntityChanged();

			UpdateActionAvailability();
		}

		protected override void EntityPropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			base.EntityPropertyChanged(sender, e);

			if (e.PropertyName == "status")
			{
				UpdateActionAvailability();
			}
		}

		protected virtual void UpdateActionAvailability()
		{
		}

		public override void ExecuteCommand(UICommand command)
		{
			base.ExecuteCommand(command);

			if (command == ConnectCommand)
			{
				Connect();
			}
		}

		public bool IsVmConnectReady()
		{
			if (ForceVmStatusUp)
			{
				return Entity.status == VMStatus.Up;
			}
			
			return IsVmUp();
		}

		public bool IsVmUp()
		{
			switch (Entity.status)
			{
				case VMStatus.PoweringUp:
				case VMStatus.Up:
				case VMStatus.RebootInProgress:
				case VMStatus.PoweringDown:
				case VMStatus.Paused:
					return true;

				default:
					return false;
			}
		}
	}
}
