using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using VdcCommon.VdcQueries;
using VdcFrontend;
using VdcCommon.Interfaces;
using VdcCommon.BusinessEntities;
using System.Collections.ObjectModel;
using System.Collections;
using System.ComponentModel;
using org.ovirt.engine.ui.uicommon.dataprovider;
using org.ovirt.engine.ui.uicompat;

namespace org.ovirt.engine.ui.uicommon.models.users
{
	public class AdElementListModel : SearchableListModel
	{
		#region Properties

		public IEnumerable ExcludeItems { get; set; }
		public ListModel Domain { get; private set; }
		public ListModel Role { get; private set; }

		public EntityModel SelectAll { get; set; }

		public bool IsRoleListHidden { get; set; }

		private bool isEveryoneSelected;
		public bool IsEveryoneSelected
		{
			get { return isEveryoneSelected; }
			set
			{
				if (isEveryoneSelected != value)
				{
					isEveryoneSelected = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsEveryoneSelected"));
				}
			}
		}

		#endregion


		public AdElementListModel()
		{
			Role = new ListModel();
			Domain = new ListModel();
			
			SelectAll = new EntityModel();
			SelectAll.Entity = false;
			SelectAll.EntityChangedEvent.addListener(this);

			AsyncQuery _asyncQuery = new AsyncQuery();
			_asyncQuery.Model = this;
			/*START_DELEGATE*/_asyncQuery.asyncCallback = delegate(Object model, Object result)
											{
												AdElementListModel adElementListModel = (AdElementListModel)model;
												List<string> domains = (List<string>)result;
												adElementListModel.Domain.Items = domains;
												adElementListModel.Domain.SelectedItem = Linq.FirstOrDefault(domains);
												AsyncQuery _asyncQuery1 = new AsyncQuery();
												_asyncQuery1.Model = adElementListModel;
												/*START_DELEGATE*/_asyncQuery1.asyncCallback = delegate(Object model1, Object result1)
																				{
																					AdElementListModel adElementListModel1 = (AdElementListModel)model1;
																					roles roleValue = null;
																					bool first = true;
																					List<roles> roles = (List<roles>)result1;
																					foreach (roles r in roles)
																					{
																						if (first)
																						{
																							roleValue = r;
																							first = false;
																						}
																						if (r.Id != null && r.Id.Equals(new Guid("00000000-0000-0000-0001-000000000001")))
																						{
																							roleValue = r;
																							break;
																						}
																					}

																					adElementListModel1.Role.Items = roles;
																					adElementListModel1.Role.SelectedItem = roleValue;

																				};//END_DELEGATE
												AsyncDataProvider.GetRoleList(_asyncQuery1);
											};//END_DELEGATE
			AsyncDataProvider.GetDomainList(_asyncQuery, false);
		}

		protected override void SyncSearch()
		{
			base.SyncSearch();
			//			var exclude = ExcludeItems != null ? ExcludeItems.Cast<DbUser>() : new List<DbUser>();


			string domain = (string) Domain.SelectedItem;

			AsyncQuery _asyncQuery = new AsyncQuery();
			_asyncQuery.Model = this;
			/*START_DELEGATE*/_asyncQuery.asyncCallback = delegate(Object model, Object ReturnValue)
			                            	{
			                            		AdElementListModel adElementListModel = (AdElementListModel) model;
		                            			HashSet<guid> excludeUsers = new HashSet<guid>();
		                            			if (ExcludeItems != null)
		                            			{
		                            				foreach (object item in ExcludeItems)
		                            				{
		                            					DbUser a = (DbUser) item;

		                            					excludeUsers.Add(a.user_id);
		                            				}
		                            			}
		                            			users = new List<EntityModel>();
		                            			foreach (IVdcQueryable item in (List<IVdcQueryable>)((VdcQueryReturnValue)ReturnValue).ReturnValue)
		                            			{
		                            				AdUser a = (AdUser) item;
		                            				if (!excludeUsers.Contains(a.UserId))
		                            				{
		                            					DbUser user =
		                            						new DbUser
		                            							{
		                            								user_id = a.UserId,
		                            								IsGroup = false,
		                            								name = a.Name,
		                            								surname = a.SurName,
		                            								username = a.UserName,
		                            								domain = a.DomainControler
		                            							};

		                            					users.Add(new EntityModel {Entity = user});
		                            				}
		                            			}
			                            		OnUserAndAdGroupsLoaded(adElementListModel);
			                            	};//END_DELEGATE
			Frontend.RunQuery(VdcQueryType.Search,
			                  new SearchParameters(
			                  	"ADUSER@" + domain + ": allnames=" + (String.IsNullOrEmpty(SearchString) ? "*" : SearchString),
			                  	SearchType.AdUser), _asyncQuery);
			_asyncQuery = new AsyncQuery();
			_asyncQuery.Model = this;
			/*START_DELEGATE*/_asyncQuery.asyncCallback = delegate(Object model, Object ReturnValue)
			                            	{
			                            		AdElementListModel adElementListModel = (AdElementListModel) model;
			                            		HashSet<guid> excludeUsers = new HashSet<guid>();
			                            		if (adElementListModel.ExcludeItems != null)
			                            		{
			                            			foreach (object item in adElementListModel.ExcludeItems)
			                            			{
			                            				DbUser a = (DbUser) item;

			                            				excludeUsers.Add(a.user_id);
			                            			}
			                            		}
			                            		adElementListModel.groups = new List<EntityModel>();
			                            		foreach (IVdcQueryable item in (List<IVdcQueryable>) ((VdcQueryReturnValue)ReturnValue).ReturnValue)
			                            		{
			                            			ad_groups a = (ad_groups) item;
			                            			if (!excludeUsers.Contains(a.id))
			                            			{
			                            				DbUser user =
			                            					new DbUser
			                            						{
			                            							user_id = a.id,
			                            							IsGroup = true,
			                            							name = a.name,
			                            							surname = string.Empty,
			                            							username = string.Empty,
			                            							domain = a.domain
			                            						};

			                            				adElementListModel.groups.Add(new EntityModel {Entity = user});
			                            			}
			                            		}

			                            		OnUserAndAdGroupsLoaded(adElementListModel);
			                            	};//END_DELEGATE

			Frontend.RunQuery(VdcQueryType.Search,
			                  new SearchParameters(
			                  	"ADGROUP@" + domain + ": name=" + (String.IsNullOrEmpty(SearchString) ? "*" : SearchString),
			                  	SearchType.AdGroup), _asyncQuery);
		}

		private void OnUserAndAdGroupsLoaded(AdElementListModel adElementListModel)
		{
			if (adElementListModel.users != null && adElementListModel.groups != null)
			{
				List<EntityModel> items = new List<EntityModel>();
				items.AddRange(users);
				items.AddRange(groups);
				adElementListModel.SelectAll.Entity = false;
				adElementListModel.Items = items;
				groups = users = null;

				IsEmpty = items.Count == 0;
			}
		}

		protected override void AsyncSearch()
		{
			base.AsyncSearch();
			SyncSearch();
		}

		#region IFrontendQueryAsyncCallback Members
		public List<EntityModel> users { get; set; }
		public List<EntityModel> groups { get; set; }

		#endregion

		public override void eventRaised(Event ev, object sender, EventArgs args)
		{
			base.eventRaised(ev, sender, args);

			if (sender == SelectAll)
			{
				if (Items == null)
				{
					return;
				}
				bool selectAll = (bool) SelectAll.Entity;
				EntityModel entityModel;
				foreach (object item in Items)
				{
					entityModel = (EntityModel)item;
					entityModel.IsSelected = selectAll;
				}
			}
		}
	}
}
