﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using org.ovirt.engine.ui.uicommon.models.templates;
using VdcCommon;
using VdcFrontend;
using VdcCommon.BusinessEntities;
using VdcCommon.Interfaces;

namespace org.ovirt.engine.ui.uicommon.models.userportal
{
	class UserPortalTemplateListModel : TemplateListModel, IFrontendMultipleQueryAsyncCallback
	{
		protected override void SyncSearch()
		{
			MultilevelAdministrationByAdElementIdParameters parameters = new MultilevelAdministrationByAdElementIdParameters(Frontend.LoggedInUser.UserId);

			// Get user permissions and send them to PostGetUserPermissions:
			AsyncQuery _asyncQuery = new AsyncQuery();
			_asyncQuery.Model = this;
			/*START_DELEGATE*/_asyncQuery.asyncCallback = delegate(Object model, Object ReturnValue)
			{
				UserPortalTemplateListModel userPortalTemplateListModel = (UserPortalTemplateListModel)model;
				List<permissions> userPermissions =
					ReturnValue != null ?
					(List<permissions>)((VdcQueryReturnValue)ReturnValue).ReturnValue :
					new List<permissions>();

				userPortalTemplateListModel.PostGetUserPermissions(userPermissions);
			};//END_DELEGATE

			Frontend.RunQuery(VdcQueryType.GetPermissionsByAdElementId, parameters, _asyncQuery);
		}

		public override void Search()
		{
			EnsureAsyncSearchStopped();
			SyncSearch();
		}

		public void PostGetUserPermissions(List<permissions> userPermissions)
		{
			List<VdcQueryType> listQueryType = new List<VdcQueryType>();
			List<VdcQueryParametersBase> listQueryParameters = new List<VdcQueryParametersBase>();

			foreach (permissions userPermission in userPermissions)
			{
				if (userPermission.ObjectType == VdcObjectType.System)
				{
					// User has a permission on System -> Get all templates in the system:
					listQueryType.Add(VdcQueryType.Search);
					SearchParameters searchParams = new SearchParameters("Template:", SearchType.VmTemplate);
					searchParams.MaxCount = 9999;
					listQueryParameters.Add(searchParams);
					break;
				}
				else
				{
					// if user has a permission on a Template, add a query-request for that template:
					if (userPermission.ObjectType == VdcObjectType.VmTemplate)
					{
						listQueryType.Add(VdcQueryType.GetVmTemplate);
						listQueryParameters.Add(new GetVmTemplateParameters(userPermission.ObjectId));
					}
					// if user has a permission on a DataCenter, add a query-request for all the templates in that DataCenter:
					else if (userPermission.ObjectType == VdcObjectType.StoragePool)
					{
						listQueryType.Add(VdcQueryType.Search);
						SearchParameters searchParams = new SearchParameters("Template: datacenter = " + userPermission.ObjectName, SearchType.VmTemplate);
						searchParams.MaxCount = 9999;
						listQueryParameters.Add(searchParams);
					}
				}
			}

			GetUserTemplates(listQueryType, listQueryParameters);
		}

		private void GetUserTemplates(List<VdcQueryType> listQueryType, List<VdcQueryParametersBase> listQueryParameters)
		{
			if (listQueryType.Count == 0)
			{
				Items = new List<VmTemplate>();
			}
			else
			{
				Frontend.RunMultipleQueries(listQueryType, listQueryParameters, this);
			}
		}

		#region IFrontendMultipleQueryAsyncCallback Members

		public void Executed(FrontendMultipleQueryAsyncResult result)
		{
			List<VmTemplate> items = new List<VmTemplate>();

			if (result != null)
			{
				IList<VdcQueryType> listQueryType = result.QueryTypes;
				IList<VdcQueryReturnValue> listReturnValue = result.ReturnValues;
				for (int i = 0; i < listQueryType.Count; i++)
				{
					switch (listQueryType[i])
					{
						case VdcQueryType.GetVmTemplate:
							if (listReturnValue[i] != null && listReturnValue[i].Succeeded && listReturnValue[i].ReturnValue != null)
							{
								VmTemplate template = (VmTemplate) listReturnValue[i].ReturnValue;
								items.Add(template);
							}
							break;

						case VdcQueryType.Search:
							if (listReturnValue[i] != null && listReturnValue[i].Succeeded && listReturnValue[i].ReturnValue != null)
							{
								List<VmTemplate> templateList = (List<VmTemplate>) listReturnValue[i].ReturnValue;
								items.AddRange(templateList);
							}
							break;
					}
				}
			}

			// Sort templates list
			List<VmTemplate> list = new List<VmTemplate>();
			VmTemplate blankTemplate = new VmTemplate();
			foreach (VmTemplate template in items)
			{
				if (template.Id.Equals(Guid.Empty))
				{
					blankTemplate = template;
					continue;
				}
				list.Add(template);
			}
			list.Sort(new Linq.VmTemplateByNameComparer());
			if (items.Contains(blankTemplate))
			{
				list.Insert(0, blankTemplate);
			}

			Items = list;
		}

		protected override void UpdateActionAvailability()
		{
			VmTemplate item = (VmTemplate)SelectedItem;
			if (item != null)
			{
				ArrayList items = new ArrayList();
				items.Add(item);
				EditCommand.IsExecutionAllowed = item.status != VmTemplateStatus.Locked && !item.Id.Equals(Guid.Empty);
				RemoveCommand.IsExecutionAllowed = VdcActionUtils.CanExecute(items, typeof(VmTemplate), VdcActionType.RemoveVmTemplate);
			}
			else
			{
				EditCommand.IsExecutionAllowed = false;
				RemoveCommand.IsExecutionAllowed = false;
			}
		}

		#endregion
	}
}
