﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using org.ovirt.engine.ui.uicompat;
using VdcCommon.BusinessEntities;

namespace org.ovirt.engine.ui.uicommon.models.configure.roles_ui
{
    public class RoleNode
    {
        private static Translator actionGroupTranslator = EnumTranslator.Create<ActionGroup>();
        public RoleNode(string name, RoleNode[] leafs)
        {
            this.Name = name;
            this.LeafRoles = new List<RoleNode>();
            foreach (RoleNode roleNode in leafs)
            {
                this.LeafRoles.Add(roleNode);
            }
        }

		public RoleNode(string name, string tooltip, RoleNode[] leafs) : this(name, leafs)
		{
			this.Tooltip = tooltip;
		}

        public RoleNode(string name, RoleNode leaf)
        {
            this.Name = name;
            this.LeafRoles = new List<RoleNode>();
            this.LeafRoles.Add(leaf);
        }
        public RoleNode(ActionGroup actionGroup, string tooltip)
        {
            this.Name = actionGroup.ToString();
        	this.Tooltip = tooltip;
            this.Desc = RoleNode.actionGroupTranslator[actionGroup];
        }
        public RoleNode(string name, string desc)
        {
            this.Name = name;
            this.Desc = desc;
        }
        public string Name { get; private set; }
		public string Tooltip { get; private set; }
        public string Desc { get; private set; }
        public List<RoleNode> LeafRoles { get; private set; }
    }
}
