using System;
using System.Text;
using System.Diagnostics;

namespace org.ovirt.engine.ui.uicompat
{
	public class EnumTranslator : Translator
	{
		public static Translator Create(Type type)
		{
			return Create(type, new EnumTranslationStrategy(type));
		}

		public static Translator Create<T>()
		{
			return Create(typeof(T));
		}

		public static Translator Create<T>(Array values)
		{
			Type type = typeof(T);
			return Create(type, new EnumTranslationStrategy(values));
		}
	}
}
