﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
//using VdcUtils;

namespace SearchBackend
{
    public class SyntaxCheckerFactory
    {
        private const string UISyntaxChecker = "UISyntaxChecker";
        private const string BackendSyntaxChecker = "BackendSyntaxChecker";
        private const string ADSyntaxChecker = "ADSyntaxChecker";
        private static readonly Dictionary <string, ISyntaxChecker> syntaxCheckers = new Dictionary<string, ISyntaxChecker>();

        public static string ConfigAuthenticationMethod;

        public static ISyntaxChecker CreateUISyntaxChecker(
            string AuthenticationMethod
            )
        {
            ConfigAuthenticationMethod = AuthenticationMethod;

            lock (syntaxCheckers)
            {
                if (!syntaxCheckers.ContainsKey(UISyntaxChecker))
                {
                    SyntaxChecker checker = new SyntaxChecker(100,true);
                    syntaxCheckers.Add(UISyntaxChecker, checker);
                }
                return syntaxCheckers[UISyntaxChecker];
            }
        }

        //public static ISyntaxChecker CreateUISyntaxCheckerServersOnly()
        //{
        //    lock (syntaxCheckers)
        //    {
        //        if (!syntaxCheckers.ContainsKey(UISyntaxChecker))
        //        {
        //            SyntaxChecker checker = new SyntaxChecker(100, false);
        //            syntaxCheckers.Add(UISyntaxChecker, checker);
        //        }
        //        return syntaxCheckers[UISyntaxChecker];
        //    }
        //}

        //public static ISyntaxChecker CreateBackendSyntaxChecker()
        //{
        //    lock (syntaxCheckers)
        //    {
        //        if (!syntaxCheckers.ContainsKey(BackendSyntaxChecker))
        //        {
        //            SyntaxChecker checker = new SyntaxChecker(ConfigSearchResultsLimit,true);
        //            syntaxCheckers.Add(BackendSyntaxChecker, checker);
        //        }
        //        return syntaxCheckers[BackendSyntaxChecker];
        //    }
        //}

        //public static ISyntaxChecker CreateBackendSyntaxCheckerServersOnly()
        //{
        //    lock (syntaxCheckers)
        //    {
        //        if (!syntaxCheckers.ContainsKey(BackendSyntaxChecker))
        //        {
        //            SyntaxChecker checker = new SyntaxChecker(ConfigSearchResultsLimit, false);
        //            syntaxCheckers.Add(BackendSyntaxChecker, checker);
        //        }
        //        return syntaxCheckers[BackendSyntaxChecker];
        //    }
        //}

        //public static ISyntaxChecker CreateADSyntaxChecker()
        //{
        //    lock (syntaxCheckers)
        //    {
        //        if (!syntaxCheckers.ContainsKey(ADSyntaxChecker))
        //        {
        //            ADSyntaxChecker checker = new ADSyntaxChecker();
        //            syntaxCheckers.Add(ADSyntaxChecker, checker);
        //        }
        //        return syntaxCheckers[ADSyntaxChecker];
        //    }
        //}

    }
}
