﻿using System;
using System.Runtime.Serialization;

namespace VdcCommon.BusinessEntities
{
    #region IsVmTemlateWithSameNameExistParameters
    
    public partial class IsVmTemlateWithSameNameExistParameters : VdcQueryParametersBase
    {
        public IsVmTemlateWithSameNameExistParameters() { }

        public IsVmTemlateWithSameNameExistParameters(string name)
        {
            Name = name;
        }

        public override RegisterableQueryReturnDataType GetReturnedDataTypeByVdcQueryType(VdcQueryType queryType)
        {
            return RegisterableQueryReturnDataType.UNDEFINED;
        }
    }
    #endregion IsVmTemlateWithSameNameExistParameters

    #region GetVmTemplateParameters
    
    public partial class GetVmTemplateParameters : VdcQueryParametersBase
    {
        public GetVmTemplateParameters() { }

        public GetVmTemplateParameters(Guid id)
        {
            Id = id;
        }

        public override RegisterableQueryReturnDataType GetReturnedDataTypeByVdcQueryType(VdcQueryType queryType)
        {
            switch (queryType)
            {
                case(VdcQueryType.GetVmTemplate):
                    return RegisterableQueryReturnDataType.IQUERYABLE;
                case(VdcQueryType.GetTemplateInterfacesByTemplateId):
                    return RegisterableQueryReturnDataType.LIST_IQUERYABLE;
                default:
                    return RegisterableQueryReturnDataType.UNDEFINED;
            }
        }
    }
    #endregion GetVmTemplateParameters

    #region GetVmsByVmTemplateGuidParameters
    
    public partial class GetVmsByVmTemplateGuidParameters : VdcQueryParametersBase
    {
        public GetVmsByVmTemplateGuidParameters() { }

        public GetVmsByVmTemplateGuidParameters(Guid id)
        {
            Id = id;
        }
    }
    #endregion GetVmsByVmTemplateGuidParameters
	
    public partial class GetVmTemplatesDisksParameters : GetVmsByVmTemplateGuidParameters
	{
        public GetVmTemplatesDisksParameters() { }

		public GetVmTemplatesDisksParameters(Guid vmTemplateId)
			: base(vmTemplateId)
		{
		}
    }
    #region GetVmTemplatesByStoragePoolIdParameters
    
    public partial class GetVmTemplatesByStoragePoolIdParameters : VdcQueryParametersBase
    {
        public GetVmTemplatesByStoragePoolIdParameters() { }

        public GetVmTemplatesByStoragePoolIdParameters(Guid storagePoolId)
        {
            StoragePoolId = storagePoolId;
        }

    }
    #endregion GetVmTemplatesByStoragePoolIdParameters

}
