﻿using System;
using System.Collections.Generic;
using System.Text;
using VdcCommon.BusinessEntities;
using System.Runtime.Serialization;
using System.Xml.Serialization;

namespace VdcCommon.BusinessEntities
{
	#region Bookmarks Parameters
	
    public partial class GetBookmarkByIdParameters : VdcQueryParametersBase
	{
        public GetBookmarkByIdParameters() { }

        public GetBookmarkByIdParameters(Guid bookmarkId)
		{
			BookmarkId = bookmarkId;
		}

      
        public override RegisterableQueryReturnDataType GetReturnedDataTypeByVdcQueryType(VdcQueryType queryType)
        {
            return RegisterableQueryReturnDataType.UNDEFINED;
        }
	}
	
    public partial class GetBookmarkByNameParameters : VdcQueryParametersBase
	{
        public GetBookmarkByNameParameters() { }

		public GetBookmarkByNameParameters(string bookmarkName)
		{
			BookmarkName = bookmarkName;
		}

        public override RegisterableQueryReturnDataType GetReturnedDataTypeByVdcQueryType(VdcQueryType queryType)
        {
            return RegisterableQueryReturnDataType.UNDEFINED;
        }

	}
	#endregion
	
    public partial class GetConfigurationValueParameters : VdcQueryParametersBase
	{
        public GetConfigurationValueParameters() { }

		public GetConfigurationValueParameters(ConfigurationValues cVal)
		{
			ConfigValue = cVal;
		}

     public override RegisterableQueryReturnDataType GetReturnedDataTypeByVdcQueryType(VdcQueryType queryType)
        {
            return RegisterableQueryReturnDataType.UNDEFINED;
        }
	}
    	
	public partial class GetAvailableClusterVersionsByStoragePoolParameters : VdcQueryParametersBase
	{
		public GetAvailableClusterVersionsByStoragePoolParameters()
		{
		}
		public GetAvailableClusterVersionsByStoragePoolParameters(Guid storagePoolId)
		{
			StoragePoolId = storagePoolId;
		}
		
	}
}
