﻿using System.Collections.Generic;
using System.Runtime.Serialization;
using VdcCommon.BusinessEntities;
using System.Linq;
using System;

namespace VdcCommon.BusinessEntities
{
	public partial class VdsActionParameters : VdcActionParametersBase
	{
		public VdsActionParameters() { }

		public VdsActionParameters(Guid vdsId)
		{
			VdsId = vdsId;
		}
	}

	public partial class FenceVdsActionParameters : VdsActionParameters
	{
		public FenceVdsActionParameters() { }

		public FenceVdsActionParameters(Guid vdsId, FenceActionType action)
			: base(vdsId)
		{
			_action = action;
		}
	}

	public partial class VdsOperationActionParameters : VdsActionParameters
	{
		public VdsOperationActionParameters()
		{
		}

		public VdsOperationActionParameters(VDS Vds, string rootPassword)
			: base(Vds.vds_id)
		{
			if (Vds.ManagmentIp == string.Empty)
			{
				Vds.ManagmentIp = null;
			}
			vds = Vds;
			RootPassword = rootPassword;
		}
	}

	public partial class MaintananceNumberOfVdssParameters : VdcActionParametersBase
	{
		public MaintananceNumberOfVdssParameters() { }
		public MaintananceNumberOfVdssParameters(IEnumerable<guid> vdsIdList, bool isInternal)
		{
			_vdsIdList = vdsIdList.ToArray();
			_isInternal = isInternal;
		}
	}

	public partial class InstallVdsParameters : VdsActionParameters
	{
		public InstallVdsParameters() { }

		public InstallVdsParameters(Guid vdsId, string password)
			: base(vdsId)
		{
			RootPassword = password;
		}
	}
	public partial class ApproveVdsParameters : InstallVdsParameters
	{
		public ApproveVdsParameters() { }

		public ApproveVdsParameters(Guid vdsId)
			: base(vdsId, string.Empty)
		{
		}
	}

	public partial class AttachNetworkToVdsParameters : VdsActionParameters
	{
		public AttachNetworkToVdsParameters() { }

		public AttachNetworkToVdsParameters(Guid vdsId, network net, VdsNetworkInterface iface)
			: base(vdsId)
		{
			CheckConnectivity = false;
			Network = net;
			Interface = iface;
		}
	}

	public partial class UpdateNetworkToVdsParameters : AttachNetworkToVdsParameters
	{
		public UpdateNetworkToVdsParameters() { }

		public UpdateNetworkToVdsParameters(Guid vdsId, network net, List<VdsNetworkInterface> interfaces) :
			base(vdsId, net, null)
		{
			Interfaces = interfaces.ToArray();
		}
	}

	public partial class RemoveBondParameters : VdsActionParameters
	{
		public RemoveBondParameters() { }

		public RemoveBondParameters(Guid vdsId, string bondName)
			: base(vdsId)
		{
			BondName = bondName;
		}
	}

	public partial class AddBondParameters : RemoveBondParameters
	{
		public AddBondParameters() { }

		public AddBondParameters(Guid vdsId, string bondName, network network, string[] nics)
			: base(vdsId, bondName)
		{
			Nics = nics;
			Network = network;
		}
	}

	public partial class ChangeVDSClusterParameters : VdsActionParameters
	{
		public ChangeVDSClusterParameters() { }

		public ChangeVDSClusterParameters(Guid clusterId, Guid vdsId)
		{
			this.clusterId = clusterId;
			this.VdsId = vdsId;
		}
	}
}
