﻿using System;
using System.Runtime.Serialization;

namespace VdcCommon.BusinessEntities
{
    #region ActiveDirectory Handling
    //
    public partial class AdElementParametersBase : VdcActionParametersBase
    {
    //    [DataMember]
    //    private readonly Guid _adElementId;
        public AdElementParametersBase() { }

        public AdElementParametersBase(Guid adElementId)
        {
            _adElementId = adElementId;
        }

    //    public Guid AdElementId
    //    {
    //        get { return _adElementId; }
    //    }
    }

    //
    public partial class AdGroupElementParametersBase : AdElementParametersBase
    {
    //    [DataMember]
    //    private readonly ad_groups _adGroup;
        public AdGroupElementParametersBase() { }

        public AdGroupElementParametersBase(ad_groups adGroup)
            : base(adGroup.id)
        {
            _adGroup = adGroup;
        }

    //    public ad_groups AdGroup
    //    {
    //        get { return _adGroup; }
    //    }
    }

    //
    public partial class VmToAdGroupParameters : AdGroupElementParametersBase
    {
    //    [DataMember]
    //    private readonly Guid _vmId;
        public VmToAdGroupParameters() { }

        public VmToAdGroupParameters(Guid vmId, ad_groups adGroup)
            : base(adGroup)
        {
            VmId = vmId;
        }

    //    public Guid VmId
    //    {
    //        get
    //        {
    //            return _vmId;
    //        }
    //    }
    }

    //
    public partial class VmToAdElementParameters : AdElementParametersBase
    {
    //    [DataMember]
    //    private readonly Guid _vmId;
        public VmToAdElementParameters() { }

        public VmToAdElementParameters(Guid adElementId, Guid vmId)
            : base(adElementId)
        {
            VmId = vmId;
        }

    //    public Guid VmId
    //    {
    //        get { return _vmId; }
    //    }
    }
    //
    public partial class VmPoolToAdElementParameters : AdElementParametersBase
    {
    //    [DataMember]
    //    private readonly int _vmPoolId;
        public VmPoolToAdElementParameters() { }

        public VmPoolToAdElementParameters(Guid adElementId, Guid vmPoolId)
            : base(adElementId)
        {
            _vmPoolId = vmPoolId;
        }

    //    public int VmPoolId
    //    {
    //        get { return _vmPoolId; }
    //    }
    }

    //
    public partial class VmPoolToAdGroupParameters : AdGroupElementParametersBase
    {
        public VmPoolToAdGroupParameters() { }
        public VmPoolToAdGroupParameters(Guid vmPoolId, ad_groups group, bool isInternal)
            : base(group)
        {
            VmPoolId = vmPoolId;
            IsInternal = isInternal;
        }

    //    [DataMember]
    //    public int VmPoolId
    //    {
    //        get;
    //        private set;
    //    }

    //    [DataMember]
    //    public bool IsInternal
    //    {
    //        get;
    //        private set;
    //    }
    }

    //
    public partial class DetachAdGroupFromTimeLeasedPoolParameters : VmPoolToAdElementParameters
    {
    //    [DataMember]
    //    private readonly bool _isInternal;
        public DetachAdGroupFromTimeLeasedPoolParameters() { }
        public DetachAdGroupFromTimeLeasedPoolParameters(Guid adElementId, Guid vmPoolId, bool isInternal) :
            base(adElementId, vmPoolId)
        {
            _isInternal = isInternal;
        }

    //    public bool IsInternal
    //    {
    //        get { return _isInternal; }
    //    }
    }
    //
    public partial class ADElementTimeLeasedVmPoolParametersBase : VmPoolToAdElementParameters
    {
    //    [DataMember]
    //    private readonly time_lease_vm_pool_map _map;
        public ADElementTimeLeasedVmPoolParametersBase() { }
        public ADElementTimeLeasedVmPoolParametersBase(time_lease_vm_pool_map map)
            : base(map.id, map.vm_pool_id)
        {
            _map = map;
        }

    //    public time_lease_vm_pool_map TimeLeasedVmPoolMap
    //    {
    //        get { return _map; }
    //    }
    }
    //
    public partial class AttachAdGroupTimeLeasedPoolCommandParameters : ADElementTimeLeasedVmPoolParametersBase
    {
    //    [DataMember]
    //    private readonly ad_groups _adGroup;
        public AttachAdGroupTimeLeasedPoolCommandParameters() { }
        public AttachAdGroupTimeLeasedPoolCommandParameters(ad_groups group, time_lease_vm_pool_map map) :
            base(map)
        {
            _adGroup = group;
        }

    //    public ad_groups AdGroup
    //    {
    //        get { return _adGroup; }
    //    }
    }
    //
    public partial class SetAdGroupRoleParameters : AdGroupElementParametersBase
    {
    //    [DataMember]
    //    private readonly bool _isRestored;
        public SetAdGroupRoleParameters() { }

        public SetAdGroupRoleParameters(ad_groups adGroup, bool isRestored)
            : base(adGroup)
        {
            _isRestored = isRestored;
        }

    //    public bool IsRestored
    //    {
    //        get { return _isRestored; }
    //    }
    }
    #endregion

    #region UserHandling
    //
    public partial class VmToUserParameters : VmToAdElementParameters
    {
        //[DataMember]
        //private readonly VdcUser _user;
        public VmToUserParameters() { }
        public VmToUserParameters(VdcUser user, Guid vmId)
            : base(user.UserId, vmId)
        {
            User = user;
        }

        //public VdcUser User
        //{
        //    get { return _user; }
        //}
    }

    //
    public partial class SetUserRoleParameters : VdcActionParametersBase
    {
    //    [DataMember]
    //    private readonly VdcUser _user;
    //    [DataMember]
    //    private readonly VdcRole _role;
        public SetUserRoleParameters() { }

        public SetUserRoleParameters(VdcUser user, VdcRole role)
        {
            User = user;
            Role = role;
        }

    //    public VdcUser User
    //    {
    //        get { return _user; }
    //    }

    //    public VdcRole Role
    //    {
    //        get { return _role; }
    //    }
    }

    
    //[Serializable]
    public partial class LoginUserParameters : VdcActionParametersBase
    {
        //[DataMember]
        //private string _userName;
        //[DataMember]
        //private readonly string _userPassword;
        //[DataMember]
        //private readonly string _domain;
        //[DataMember]
        //private readonly string _os;
        //[DataMember]
        //private readonly string _browser;
        //[DataMember]
        //private readonly string _clientType;
        //[DataMember]
        //private VdcActionType _actionType;

        public LoginUserParameters(string _userName, string _userPassword, string _domain, string _os, string _browser, string _clientType)
        {
            ActionType = VdcActionType.LoginUser;
            userName = _userName;
            userPassword = _userPassword;
            domain = _domain.Trim();
            os = _os;
            browser = _browser;
            clientType = _clientType;
        }

        public LoginUserParameters()
        {
            actionType = VdcActionType.LoginUser;
        }

        //public string UserName
        //{
        //    get { return _userName; }
        //    set { _userName = value; }
        //}

        //public string UserPassword
        //{
        //    get { return _userPassword; }
        //}

        //public string Domain
        //{
        //    get { return _domain; }
        //}

        //public string Os
        //{
        //    get { return _os; }
        //}

        //public string Browser
        //{
        //    get { return _browser; }
        //}

        //public string ClientType
        //{
        //    get { return _clientType; }
        //}

        //[DataMember]
        //public VdcActionType ActionType
        //{
        //    get { return _actionType; }
        //    set { _actionType = value; }
        //}

        //[DataMember]
        //public bool IsAdmin { get; set; }
    }
    
    //
    ////[Serializable]
    public partial class LogoutUserParameters : VdcActionParametersBase
    {
       
    //    [DataMember]
    //    private readonly Guid _userId;
        public LogoutUserParameters() { }

        public LogoutUserParameters(Guid userId)
        {
            UserId = userId;
        }

    //    public Guid UserId
    //    {
    //        get { return _userId; }
    //    }
        
    }
    
	
	//[Serializable]
	public partial class ChangeUserPasswordParameters : VdcActionParametersBase
	{
        //[DataMember]
        //private readonly string _userName;
        //[DataMember]
        //private readonly string _userPassword;
        //[DataMember]
        //private readonly string _newPassword;
        //[DataMember]
        //private readonly string _domain;
        public ChangeUserPasswordParameters() { }

		public ChangeUserPasswordParameters(string userName, string userPassword, string newPassword, string domain)
		{
			_userName = userName;
			_userPassword = userPassword;
			_newPassword = newPassword;
			_domain = domain;
		}

        //public string UserName
        //{
        //    get { return _userName; }
        //}

        //public string UserPassword
        //{
        //    get { return _userPassword; }
        //}

        //public string NewPassword
        //{
        //    get { return _newPassword; }
        //}

        //public string Domain
        //{
        //    get { return _domain; }
        //}
	}

    //
    //[Serializable]
    public partial class CreateComputerAccountParameters : VdcActionParametersBase
    {
        //[DataMember]
        //private readonly string _path;
        //[DataMember]
        //private readonly Guid _vmId;

        //[DataMember]
        //private readonly string _userName;
        //[DataMember]
        //private readonly string _userPassword;
        //[DataMember]
        //private readonly string _domain;
        public CreateComputerAccountParameters() { }

        public CreateComputerAccountParameters(string path, Guid vmId, string userName, string userPassword,  string domain)
        {
            _path = path;
            VmId = vmId;
            _userName = userName;
            _userPassword = userPassword;
            _domain = domain;
        }

        //public string Path
        //{
        //    get { return _path; }
        //}

        //public Guid VmId
        //{
        //    get { return _vmId; }
        //}

        //public string UserName
        //{
        //    get { return _userName; }
        //}

        //public string UserPassword
        //{
        //    get { return _userPassword; }
        //}       

        //public string Domain
        //{
        //    get { return _domain; }
        //}
    }
    #endregion
}
