﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;
using VdcCommon.BusinessEntities;
using VdcCommon.AsyncTasks;
using VdcCommon.Errors;

namespace VdcCommon.BusinessEntities
{
	public enum VDSCommandType
	{
		#region vds broker commands
		AddVds,
		RemoveVds,
		ActivateVds,
        FenceVds,
		CreateVm,
		DestroyVm,
		Pause,
		Hibernate,
		Resume,
		Migrate,
		ChangeDisk,
		ChangeFloppy,
		VmLogon,
		VmLogoff,
		VmLock,
		VmMonitorCommand,
		SetVmTicket,
		SetVdsStatus,
		FailedToRunVm,
		SetVmStatus,
		IsVmDuringInitiating,
		StartSpice,
		RunVmHyperChannelCommand,
		ShutdownVds,
		UpdateVdsVMsCleared,
        AddNetwork,
        RemoveNetwork,
        EditNetwork,
        SetSafeNetworkConfig,
		ConnectStorageServer,
		DisconnectStorageServer,
		ValidateStorageServerConnection,
		GetStorageConnectionsList,
		ConnectStoragePool,
		DisconnectStoragePool,
		DiscoverSendTargets,
		RefreshStoragePool,
		CreateStoragePool,
		ReconstructMaster,
		SpmStart,
		SpmStop,
		SpmStatus,
		FenceSpmStorage,
		HSMGetAllTasksStatuses,
		HSMGetTaskStatus,
		HSMGetAllTasksInfo,
		HSMGetTaskInfo,
		HSMStopTask,
		HSMClearTask,
		HSMRevertTask,
		GetStorageSessionsList,
		UpdateVmDynamicData,
		UpdateVdsDynamicData,
        CollectVdsNetworkData,
        GetVmsInfo,
        GetVmsList,
		HSMGetStorageDomainInfo,
		HSMGetStorageDomainsList,
		#endregion
		#region irs broker commands
		CreateImage,
		ListImageIds,
		DestroyImage,
		GetImageInfo,
        DoesImageExist,
		CopyImage,
		CreateSnapshot,
		MergeSnapshots,
		SetImageDescription,
		IsMonitorValid,
		IsValid,
		IsoPrefix,
		IsoDirectory,
		SetImageLegality,
		ResetIrs,
		GetImportCandidates,
		GetImportCandidatesInfo,
		GetCandidateInfo,
		ImportCandidate,
		GetIsoList,
        HsmGetIsoList,
		GetFloppyList,
		CurrentVdsId,
		ExportCandidate,
		CreateStorageDomain,
		ValidateStorageDomain,
		ActivateStorageDomain,
		DeactivateStorageDomain,
		DetachStorageDomain,
		AttachStorageDomain,
		FormatStorageDomain,
		SetStorageDomainDescription,
		GetStorageDomainInfo,
		GetStorageDomainStats,
		SetStoragePoolDescription,
		GetStoragePoolInfo,
		DestroyStoragePool,
		DeleteImageGroup,
		MoveImageGroup,
		MoveMultipleImageGroups,
		GetImageDomainsList,
		CreateVG,
		RemoveVG,
		GetVGList,
		GetVGInfo,
		GetDeviceList,
		GetDeviceInfo,
		SetMaxHosts,
		SPMGetAllTasksStatuses,
		SPMGetTaskStatus,
		SPMGetAllTasksInfo,
		SPMGetTaskInfo,
		SPMStopTask,
		SPMClearTask,
		SPMRevertTask,
		UpdateVM,
		RemoveVM,
		SpmStopOnIrs,
		ResetISOPath,
		ExtendStorageDomain
		#endregion
	}

	[DataContract]
	[KnownType(typeof(DiskImage))]
	[KnownType(typeof(VMStatus))]
	[KnownType(typeof(Guid[]))]
	[KnownType(typeof(List<string>))]
	[KnownType(typeof(IrsStatus))]
	[KnownType(typeof(VmStatic))]
	[KnownType(typeof(List<storage_server_connections>))]
	[KnownType(typeof(storage_domain_static))]
	[KnownType(typeof(storage_domain_dynamic))]
	[KnownType(typeof(storage_domains))]
	[KnownType(typeof(storage_pool))]
	[KnownType(typeof(Dictionary<storage_pool, List<storage_domain_static>>))]
	[KnownType(typeof(VDSError))]
	[KnownType(typeof(VdcBllErrors))]
	public partial class VDSReturnValue
	{
		private bool _succeeded;
		private string _exceptionString;
		private object _returnValue;
		private Exception _exceptionObject;
        
		[DataMember]
		public object ReturnValue
		{
			get { return _returnValue; }
			set { _returnValue = value; }
		}
		[DataMember]
		public string ExceptionString
		{
			get { return _exceptionString; }
			set { _exceptionString = value; }
		}
		[DataMember]
		public bool Succeeded
		{
			get { return _succeeded; }
			set { _succeeded = value; }
		}

		public Exception ExceptionObject
		{
			get { return _exceptionObject; }
			set { _exceptionObject = value; }
		}

		[DataMember]
		public AsyncTaskCreationInfo CreationInfo { get; set; }

		[DataMember]
		public VDSError VdsError
		{
			get;
			set;
		}
	}
}
