'''
Created on Oct 30, 2010

@author: mpastern@redhat.com
'''

class Parameter(object):
    '''
    This class represent method's argument
    '''
    __type = ''
    __fqName = ''
    __uniqueName = ''
    __shift = 0
    __options = ''
    
    def __init__(self, type, fqName, options=''):
        self.__type = type
        self.__fqName = unicode.encode(fqName)      
        self.__shift = 1
        self.__options = options
        self.__setDefaultUniqueName()

    def __setDefaultUniqueName(self):
        paramTree = self.__fqName.split('.')
        if(paramTree.__class__ is list and paramTree.__len__() > 0 and \
            paramTree.__len__()>=self.__shift):
            self.__uniqueName = self.__createUNameByFqName(paramTree)
        else: 
            self.__uniqueName = self.__fqName
    
    def __createUNameByFqName(self,tree=[]):
        i = (tree.__len__() - self.__shift)
        newUName = ''  
        while (i <= (tree.__len__()-1)):
            newUName+=tree[i]+"."
            i+=1
        return newUName[0:(newUName.__len__()-1)]
    
    def extendUniqueName(self):
        self.__shift+=1
        self.__setDefaultUniqueName()        
    
    def __str__(self):
         return 'Type: '+self.__type+\
                ', FQName: '+self.__fqName+\
                ', UniqueName: '+self.__uniqueName+\
                ', Options: '+self.__options
                
    def get_type(self):
        return self.__type

    def get_fq_name(self):
        return self.__fqName

    def get_unique_name(self):
        return self.__uniqueName

    def get_options(self):
        return self.__options

    def set_type(self, value):
        self.__type = value


    def set_fq_name(self, value):
        self.__fqName = value


    def set_options(self, value):
        self.__options = value

    def del_type(self):
        del self.__type


    def del_fq_name(self):
        del self.__fqName

    def del_options(self):
        del self.__options

    type = property(get_type, set_type, del_type, "type's docstring")
    fqName = property(get_fq_name, set_fq_name, del_fq_name, "fqName's docstring")
    uniqueName = property(get_unique_name, "uniqueName's docstring")
    options = property(get_options, set_options, del_options, "options's docstring")
