PRINT 'Processing vms_sp.sql'

----------------------------------------------------------------
-- [dbo].[vm_statistics] Table
--

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'InsertVmStatistics')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[InsertVmStatistics] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[InsertVmStatistics]
	@cpu_sys decimal(18,0) = NULL,
	@cpu_user decimal(18,0) = NULL,
	@elapsed_time decimal(18,0) = NULL,
	@usage_cpu_percent int = NULL,
	@usage_mem_percent int = NULL,
	@usage_network_percent int = NULL,
	@vm_guid uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[vm_statistics] ([cpu_sys], [cpu_user], [elapsed_time], [usage_cpu_percent], [usage_mem_percent], [usage_network_percent], [vm_guid])
	VALUES (@cpu_sys, @cpu_user, @elapsed_time, @usage_cpu_percent, @usage_mem_percent, @usage_network_percent, @vm_guid)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'UpdateVmStatistics')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[UpdateVmStatistics] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[UpdateVmStatistics]
	@cpu_sys decimal(18,0) = NULL,
	@cpu_user decimal(18,0) = NULL,
	@elapsed_time decimal(18,0) = NULL,
	@usage_cpu_percent int = NULL,
	@usage_mem_percent int = NULL,
	@usage_network_percent int = NULL,
	@vm_guid uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON

	BEGIN TRY
	UPDATE [dbo].[vm_statistics] 
	SET [cpu_sys] = @cpu_sys, [cpu_user] = @cpu_user, [elapsed_time] = @elapsed_time, [usage_cpu_percent] = @usage_cpu_percent, [usage_mem_percent] = @usage_mem_percent, [usage_network_percent] = @usage_network_percent 
	WHERE [vm_guid]=@vm_guid

	IF @@ROWCOUNT = 0
	BEGIN
		RAISERROR('Update statement affected 0 rows.', 16, 2)
	END
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH	

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'DeleteVmStatistics')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[DeleteVmStatistics] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[DeleteVmStatistics]
	 @vm_guid uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON
	BEGIN TRY
		DELETE FROM [dbo].[vm_statistics]
		WHERE [vm_guid]=@vm_guid
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromVmStatistics')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromVmStatistics] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromVmStatistics]
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[vm_statistics].[cpu_sys] AS 'cpu_sys',
		[vm_statistics].[cpu_user] AS 'cpu_user',
		[vm_statistics].[elapsed_time] AS 'elapsed_time',
		[vm_statistics].[usage_cpu_percent] AS 'usage_cpu_percent',
		[vm_statistics].[usage_mem_percent] AS 'usage_mem_percent',
		[vm_statistics].[usage_network_percent] AS 'usage_network_percent',
		[vm_statistics].[vm_guid] AS 'vm_guid'
	FROM [dbo].[vm_statistics] [vm_statistics]
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVmStatisticsByVmGuid')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVmStatisticsByVmGuid] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVmStatisticsByVmGuid] 
	@vm_guid uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[vm_statistics].[cpu_sys] AS 'cpu_sys',
		[vm_statistics].[cpu_user] AS 'cpu_user',
		[vm_statistics].[elapsed_time] AS 'elapsed_time',
		[vm_statistics].[usage_cpu_percent] AS 'usage_cpu_percent',
		[vm_statistics].[usage_mem_percent] AS 'usage_mem_percent',
		[vm_statistics].[usage_network_percent] AS 'usage_network_percent',
		[vm_statistics].[vm_guid] AS 'vm_guid'
		FROM [dbo].[vm_statistics] [vm_statistics]
		WHERE [vm_guid]=@vm_guid
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO
----------------------------------------------------------------
-- [dbo].[vm_dynamic] Table
--

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'InsertVmDynamic')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[InsertVmDynamic] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[InsertVmDynamic]
	@app_list nvarchar(max) = NULL,
	@guest_cur_user_id uniqueidentifier = NULL,
	@guest_cur_user_name nvarchar(255) = NULL,
	@guest_last_login_time datetime = NULL,
	@guest_last_logout_time datetime = NULL,
	@guest_os nvarchar(255) = NULL,
	@migrating_to_vds uniqueidentifier = NULL,
	@run_on_vds uniqueidentifier = NULL,
	@status int,
	@vm_guid uniqueidentifier,
	@vm_host varchar(255) = NULL,
	@vm_ip nvarchar(255) = NULL,
	@vm_last_boot_time datetime = NULL,
	@vm_last_up_time datetime = NULL,
	@vm_pid int = NULL,
	@display int = NULL,
	@acpi_enable BIT = NULL,
	@session INTEGER = NULL,
	@display_ip VARCHAR(255) = NULL,
	@display_type INTEGER = NULL,
	@kvm_enable BIT = NULL,
	@boot_sequence INTEGER = NULL,
	@display_secure_port INTEGER = NULL,
	@utc_diff INTEGER = NULL,
	@last_vds_run_on uniqueidentifier = NULL,
	@client_ip nvarchar(255)= NULL,
	@guest_requested_memory  int = NULL,
	@hibernation_vol_handle varchar(255) = null,
	@exit_status int,
	@pause_status int,
	@exit_message nvarchar(MAX)=NULL
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[vm_dynamic] ([app_list],	[guest_cur_user_id], [guest_cur_user_name], [guest_last_login_time], [guest_last_logout_time], [guest_os], [migrating_to_vds], [run_on_vds], [status], [vm_guid], [vm_host], [vm_ip], [vm_last_boot_time], [vm_last_up_time], [vm_pid], [display], [acpi_enable], [session], [display_ip], [display_type], [kvm_enable], [boot_sequence], [display_secure_port], [utc_diff], [last_vds_run_on], [client_ip], [guest_requested_memory], [hibernation_vol_handle],[exit_status],[pause_status],[exit_message])
	VALUES (@app_list, @guest_cur_user_id, @guest_cur_user_name, @guest_last_login_time, @guest_last_logout_time, @guest_os, @migrating_to_vds, @run_on_vds, @status, @vm_guid, @vm_host, @vm_ip, @vm_last_boot_time, @vm_last_up_time, @vm_pid, @display, @acpi_enable, @session, @display_ip, @display_type, @kvm_enable, @boot_sequence, @display_secure_port, @utc_diff, @last_vds_run_on, @client_ip, @guest_requested_memory, @hibernation_vol_handle, @exit_status, @pause_status, @exit_message)
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'UpdateVmDynamic')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[UpdateVmDynamic] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[UpdateVmDynamic]
	@app_list nvarchar(max) = NULL,
	@guest_cur_user_id uniqueidentifier = NULL,
	@guest_cur_user_name nvarchar(255) = NULL,
	@guest_last_login_time datetime = NULL,
	@guest_last_logout_time datetime = NULL,
	@guest_os nvarchar(255) = NULL,
	@migrating_to_vds uniqueidentifier = NULL,
	@run_on_vds uniqueidentifier = NULL,
	@status int,
	@vm_guid uniqueidentifier,
	@vm_host varchar(255) = NULL,
	@vm_ip nvarchar(255) = NULL,
	@vm_last_boot_time datetime = NULL,
	@vm_last_up_time datetime = NULL,
	@vm_pid int = NULL,
	@display int = NULL,
	@acpi_enable BIT = NULL,
	@session INTEGER = NULL,
	@display_ip VARCHAR(255) = NULL,
	@display_type INTEGER = NULL,
	@kvm_enable BIT = NULL,
	@boot_sequence INTEGER = NULL,
	@display_secure_port INTEGER = NULL,
	@utc_diff INTEGER = NULL,
	@last_vds_run_on uniqueidentifier = NULL,
	@client_ip nvarchar(255) = NULL,
	@guest_requested_memory int = NULL,
	@hibernation_vol_handle varchar(255) = null,
	@exit_status int,
	@pause_status int,
	@exit_message nvarchar(MAX)=NULL
AS
BEGIN

	--The [dbo].[vm_dynamic] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY
	UPDATE [dbo].[vm_dynamic] 
	SET [app_list] = @app_list,	[guest_cur_user_id] = @guest_cur_user_id, [guest_cur_user_name] = @guest_cur_user_name, [guest_last_login_time] = @guest_last_login_time, [guest_last_logout_time] = @guest_last_logout_time, [guest_os] = @guest_os, [migrating_to_vds] = @migrating_to_vds, [run_on_vds] = @run_on_vds, [status] = @status, [vm_host] = @vm_host, [vm_ip] = @vm_ip, [vm_last_boot_time] = @vm_last_boot_time, [vm_last_up_time] = @vm_last_up_time, [vm_pid] = @vm_pid, [display] = @display, [acpi_enable] = @acpi_enable, [session] = @session, [display_ip] = @display_ip, [display_type] = @display_type, [kvm_enable] = @kvm_enable, [boot_sequence] = @boot_sequence, [display_secure_port] = @display_secure_port, [utc_diff] = @utc_diff, [last_vds_run_on] = @last_vds_run_on, [client_ip] = @client_ip, [guest_requested_memory] = @guest_requested_memory, [hibernation_vol_handle] = @hibernation_vol_handle,[exit_status] = @exit_status, [pause_status] = @pause_status, [exit_message] = @exit_message
	WHERE [vm_guid]=@vm_guid

	IF @@ROWCOUNT = 0
	BEGIN
		RAISERROR('Update statement affected 0 rows.', 16, 2)
	END
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH	

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'UpdateVmDynamicStatus')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[UpdateVmDynamicStatus] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[UpdateVmDynamicStatus]
	@vm_guid uniqueidentifier,
	@status int
AS
BEGIN

	SET NOCOUNT ON

	BEGIN TRY
	UPDATE [dbo].[vm_dynamic] 
	SET [status] = @status
	WHERE [vm_guid]=@vm_guid

    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH	

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'DeleteVmDynamic')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[DeleteVmDynamic] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[DeleteVmDynamic]
	 @vm_guid uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON
	BEGIN TRY
		DELETE FROM [dbo].[vm_dynamic]
		WHERE [vm_guid]=@vm_guid
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromVmDynamic')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromVmDynamic] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromVmDynamic]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[vm_dynamic].[app_list] AS 'app_list',
		[vm_dynamic].[guest_cur_user_id] AS 'guest_cur_user_id',
		[vm_dynamic].[guest_cur_user_name] AS 'guest_cur_user_name',
		[vm_dynamic].[guest_last_login_time] AS 'guest_last_login_time',
		[vm_dynamic].[guest_last_logout_time] AS 'guest_last_logout_time',
		[vm_dynamic].[guest_os] AS 'guest_os',
		[vm_dynamic].[migrating_to_vds] AS 'migrating_to_vds',
		[vm_dynamic].[run_on_vds] AS 'run_on_vds',
		[vm_dynamic].[status] AS 'status',
		[vm_dynamic].[vm_guid] AS 'vm_guid',
		[vm_dynamic].[vm_host] AS 'vm_host',
		[vm_dynamic].[vm_ip] AS 'vm_ip',
		[vm_dynamic].[vm_last_boot_time] AS 'vm_last_boot_time',
		[vm_dynamic].[vm_last_up_time] AS 'vm_last_up_time',
		[vm_dynamic].[vm_pid] AS 'vm_pid',
		[vm_dynamic].[display] AS 'display',
		[vm_dynamic].[acpi_enable] AS 'acpi_enable',
		[vm_dynamic].[session] AS 'session',
		[vm_dynamic].[display_ip] AS 'display_ip',
		[vm_dynamic].[display_type] AS 'display_type',
		[vm_dynamic].[kvm_enable] AS 'kvm_enable',
		[vm_dynamic].[boot_sequence] AS 'boot_sequence',
		[vm_dynamic].[display_secure_port] AS 'display_secure_port',
		[vm_dynamic].[utc_diff] AS 'utc_diff',
		[vm_dynamic].[last_vds_run_on] as 'last_vds_run_on',
		[vm_dynamic].[client_ip] as 'client_ip',
		[vm_dynamic].[guest_requested_memory] as 'guest_requested_memory',
		[vm_dynamic].[hibernation_vol_handle] as 'hibernation_vol_handle'
		
	FROM [dbo].[vm_dynamic] [vm_dynamic]
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVmDynamicByVmGuid')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVmDynamicByVmGuid] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVmDynamicByVmGuid] 
	@vm_guid uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[vm_dynamic].[app_list] AS 'app_list',
		[vm_dynamic].[guest_cur_user_id] AS 'guest_cur_user_id',
		[vm_dynamic].[guest_cur_user_name] AS 'guest_cur_user_name',
		[vm_dynamic].[guest_last_login_time] AS 'guest_last_login_time',
		[vm_dynamic].[guest_last_logout_time] AS 'guest_last_logout_time',
		[vm_dynamic].[guest_os] AS 'guest_os',
		[vm_dynamic].[migrating_to_vds] AS 'migrating_to_vds',
		[vm_dynamic].[run_on_vds] AS 'run_on_vds',
		[vm_dynamic].[status] AS 'status',
		[vm_dynamic].[vm_guid] AS 'vm_guid',
		[vm_dynamic].[vm_host] AS 'vm_host',
		[vm_dynamic].[vm_ip] AS 'vm_ip',
		[vm_dynamic].[vm_last_boot_time] AS 'vm_last_boot_time',
		[vm_dynamic].[vm_last_up_time] AS 'vm_last_up_time',
		[vm_dynamic].[vm_pid] AS 'vm_pid',
		[vm_dynamic].[display] AS 'display',
		[vm_dynamic].[acpi_enable] AS 'acpi_enable',
		[vm_dynamic].[session] AS 'session',
		[vm_dynamic].[display_ip] AS 'display_ip',
		[vm_dynamic].[display_type] AS 'display_type',
		[vm_dynamic].[kvm_enable] AS 'kvm_enable',
		[vm_dynamic].[boot_sequence] AS 'boot_sequence',
		[vm_dynamic].[display_secure_port] AS 'display_secure_port',
		[vm_dynamic].[utc_diff] AS 'utc_diff',
		[vm_dynamic].[last_vds_run_on] as 'last_vds_run_on',
		[vm_dynamic].[client_ip] as 'client_ip',
		[vm_dynamic].[guest_requested_memory] as 'guest_requested_memory',
		[vm_dynamic].[hibernation_vol_handle] as 'hibernation_vol_handle',
		[vm_dynamic].[exit_status] as 'exit_status',
		[vm_dynamic].[pause_status] as 'pause_status',
		[vm_dynamic].[exit_message] as 'exit_message'

		FROM [dbo].[vm_dynamic] [vm_dynamic]
		WHERE [vm_guid]=@vm_guid
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

----------------------------------------------------------------
-- [dbo].[vm_static] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'InsertVmStatic')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[InsertVmStatic] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[InsertVmStatic]
    @description nvarchar(max) = NULL, 
 @mem_size_mb int, 
 @os nvarchar(40), 
 @vds_group_id uniqueidentifier, 
 @vm_guid uniqueidentifier, 
 @vm_name nvarchar(255),
 @vmt_guid uniqueidentifier,
 @domain  NVARCHAR(40),
 @creation_date datetime,
 @num_of_monitors int,
 @is_initialized bit,
    @is_auto_suspend bit,
    @num_of_sockets int,
    @cpu_per_socket int,
 @usb_policy int,
 @time_zone varchar(40) = NULL,
 @auto_startup bit,
 @is_stateless bit,
 @dedicated_vm_for_vds uniqueidentifier = NULL,
    @fail_back bit = NULL,
    @vm_type int = 0,
    @hypervisor_type int = null,
    @operation_mode int = null,
 @nice_level int,
    @default_boot_sequence int,
 @default_display_type int,
 @priority int,
    @iso_path nvarchar(max) = null,
    @origin int = 0,
    @initrd_url    nvarchar(max) = null,
    @kernel_url    nvarchar(max) = null,
    @kernel_params nvarchar(max) = null,
    @migration_support int = 0,
    @predefined_properties varchar(max) = null,
    @userdefined_properties varchar(max) = null,
    @min_allocated_mem int
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[vm_static] ([description], [mem_size_mb], [os], [vds_group_id], [vm_guid], [vm_name], [vmt_guid],[domain],[creation_date],[num_of_monitors],[is_initialized],[is_auto_suspend],[num_of_sockets],[cpu_per_socket],[usb_policy], [time_zone],[auto_startup],[is_stateless],[dedicated_vm_for_vds], [fail_back], [default_boot_sequence], [vm_type], [hypervisor_type], [operation_mode], [nice_level], [default_display_type], [priority],[iso_path],[origin],[initrd_url],[kernel_url],[kernel_params],[migration_support],[predefined_properties],[userdefined_properties],[min_allocated_mem])
	VALUES (@description,  @mem_size_mb, @os, @vds_group_id, @vm_guid, @vm_name, @vmt_guid, @domain, @creation_date, @num_of_monitors, @is_initialized, @is_auto_suspend, @num_of_sockets, @cpu_per_socket, @usb_policy, @time_zone, @auto_startup,@is_stateless,@dedicated_vm_for_vds,@fail_back, @default_boot_sequence, @vm_type, @hypervisor_type, @operation_mode, @nice_level, @default_display_type, @priority,@iso_path,@origin,@initrd_url,@kernel_url,@kernel_params,@migration_support,@predefined_properties,@userdefined_properties,@min_allocated_mem)

    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'UpdateVmStatic')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[UpdateVmStatic] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[UpdateVmStatic]
    @description nvarchar(max) = NULL,
 @mem_size_mb int,
 @os nvarchar(40),
 @vds_group_id uniqueidentifier,
 @vm_guid uniqueidentifier,
 @vm_name nvarchar(255),
 @vmt_guid uniqueidentifier,
 @domain  NVARCHAR(40),
 @creation_date datetime,
 @num_of_monitors int,
 @is_initialized bit,
 @is_auto_suspend bit,
    @num_of_sockets int,
    @cpu_per_socket int,
 @usb_policy  int,
 @time_zone varchar(40) = NULL,
 @auto_startup bit,
 @is_stateless bit,
 @dedicated_vm_for_vds uniqueidentifier = NULL,
    @fail_back bit = NULL,
    @vm_type int = 0,
    @hypervisor_type int = null,
    @operation_mode int = null,
    @nice_level int,
    @default_boot_sequence int,
 @default_display_type int,
 @priority int,
    @iso_path nvarchar(max) = null,
    @origin int = 0,
    @initrd_url    nvarchar(max) = null,
    @kernel_url    nvarchar(max) = null,
    @kernel_params nvarchar(max) = null,
    @migration_support int = 0,
@predefined_properties varchar(max)=null,
@userdefined_properties varchar(max) = null,
@min_allocated_mem int
AS
BEGIN

	--The [dbo].[vm_static] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY
	UPDATE [dbo].[vm_static] 
	SET [description] = @description, [mem_size_mb] = @mem_size_mb, [os] = @os, [vds_group_id] = @vds_group_id, [vm_name] = @vm_name, [vmt_guid] = @vmt_guid, [domain] = @domain, [creation_date] = @creation_date, [num_of_monitors] = @num_of_monitors, [is_initialized]= @is_initialized, [is_auto_suspend]= @is_auto_suspend, [num_of_sockets]=@num_of_sockets, [cpu_per_socket]=@cpu_per_socket, [usb_policy]=@usb_policy, [time_zone] = @time_zone, [auto_startup] = @auto_startup, [is_stateless] = @is_stateless,[dedicated_vm_for_vds] = @dedicated_vm_for_vds, [fail_back] = @fail_back, [vm_type] = @vm_type, [hypervisor_type] = @hypervisor_type, [nice_level] = @nice_level, [operation_mode] = @operation_mode, _update_date = getdate(),
	[default_boot_sequence] = @default_boot_sequence, [default_display_type] = @default_display_type, [priority] = @priority,[iso_path] = @iso_path, [origin] = @origin, [initrd_url] = @initrd_url, [kernel_url] = @kernel_url, [kernel_params] = @kernel_params, [migration_support] = @migration_support,[predefined_properties] = @predefined_properties, [userdefined_properties] = @userdefined_properties, [min_allocated_mem] = @min_allocated_mem
	WHERE [vm_guid]=@vm_guid

	IF @@ROWCOUNT = 0
	BEGIN
		RAISERROR('Concurrent update error. Updated aborted.', 16, 2)
	END
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH	

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'DeleteVmStatic')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[DeleteVmStatic] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[DeleteVmStatic]
	 @vm_guid uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON
	BEGIN TRY
			declare @val uniqueidentifier
			-- Get (and keep) a shared lock with "right to upgrade to exclusive"
			-- in order to force locking parent before children 
			SELECT @val = [vm_guid]
			FROM [dbo].[vm_static] WITH (UPDLOCK)
			WHERE [vm_guid] = @vm_guid

			DELETE FROM [dbo].[vm_static]
			WHERE [vm_guid]=@vm_guid

			-- delete VM permissions --
			DELETE FROM [dbo].[permissions] where object_id = @vm_guid 
			
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH
	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromVmStatic')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromVmStatic] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromVmStatic]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
		[vm_static].[description] AS 'description',
		[vm_static].[mem_size_mb] AS 'mem_size_mb',
		[vm_static].[os] AS 'os',
		[vm_static].[vds_group_id] AS 'vds_group_id',
		[vm_static].[vm_guid] AS 'vm_guid',
		[vm_static].[vm_name] AS 'vm_name',
		[vm_static].[vmt_guid] AS 'vmt_guid',
		[vm_static].[domain]  AS 'domain',
		[vm_static].[creation_date] AS 'creation_date',
		[vm_static].[num_of_monitors]	AS 'num_of_monitors',
		[vm_static].[is_initialized]	AS 'is_initialized',
		[vm_static].[is_auto_suspend]	AS 'is_auto_suspend',
		[vm_static].[num_of_sockets]	AS 'num_of_sockets',
		[vm_static].[cpu_per_socket]	AS 'cpu_per_socket',
		[vm_static].[usb_policy]	AS 'usb_policy',
		[vm_static].[time_zone] AS 'time_zone',
		[vm_static].[auto_startup]  AS 'auto_startup',
		[vm_static].[is_stateless] AS 'is_stateless',
		[vm_static].[dedicated_vm_for_vds]  AS 'dedicated_vm_for_vds',
		[vm_static].[fail_back] as 'fail_back',
		[vm_static].[vm_type] as 'vm_type',
		[vm_static].[hypervisor_type] as 'hypervisor_type',
		[vm_static].[operation_mode] as 'operation_mode',
		[vm_static].[nice_level] as 'nice_level',
		[vm_static].[default_boot_sequence] as 'default_boot_sequence',
		[vm_static].[default_display_type] as 'default_display_type',
		[vm_static].[priority] as 'priority',
		[vm_static].[iso_path] as 'iso_path',
		[vm_static].[origin] as 'origin',
		[vm_static].[initrd_url] as 'initrd_url',
		[vm_static].[kernel_url] as 'kernel_url',
		[vm_static].[kernel_params] as 'kernel_params',
		[vm_static].[migration_support] as 'migration_support',
		[vm_static].[predefined_properties] as 'predefined_properties',
		[vm_static].[userdefined_properties] as 'userdefined_properties',
		[vm_static].[min_allocated_mem] as 'min_allocated_mem'

FROM [dbo].[vm_static] [vm_static]

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromVmStaticByStoragePoolId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromVmStaticByStoragePoolId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromVmStaticByStoragePoolId]
    @sp_id as uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON

	SELECT
		[vm_static].[description] AS 'description',
		[vm_static].[mem_size_mb] AS 'mem_size_mb',
		[vm_static].[os] AS 'os',
		[vm_static].[vds_group_id] AS 'vds_group_id',
		[vm_static].[vm_guid] AS 'vm_guid',
		[vm_static].[vm_name] AS 'vm_name',
		[vm_static].[vmt_guid] AS 'vmt_guid',
		[vm_static].[domain]  AS 'domain',
		[vm_static].[creation_date] AS 'creation_date',
		[vm_static].[num_of_monitors]	AS 'num_of_monitors',
		[vm_static].[is_initialized]	AS 'is_initialized',
		[vm_static].[is_auto_suspend]	AS 'is_auto_suspend',
		[vm_static].[num_of_sockets]	AS 'num_of_sockets',
		[vm_static].[cpu_per_socket]	AS 'cpu_per_socket',
		[vm_static].[usb_policy]	AS 'usb_policy',
		[vm_static].[time_zone] AS 'time_zone',
		[vm_static].[auto_startup]  AS 'auto_startup',
		[vm_static].[is_stateless] AS 'is_stateless',
		[vm_static].[dedicated_vm_for_vds]  AS 'dedicated_vm_for_vds',
		[vm_static].[fail_back] as 'fail_back',
		[vm_static].[vm_type] as 'vm_type',
		[vm_static].[hypervisor_type] as 'hypervisor_type',
		[vm_static].[operation_mode] as 'operation_mode',
		[vm_static].[nice_level] as 'nice_level',
		[vm_static].[default_boot_sequence] as 'default_boot_sequence',
		[vm_static].[default_display_type] as 'default_display_type',
		[vm_static].[priority] as 'priority',
		[vm_static].[iso_path] as 'iso_path',
		[vm_static].[origin] as 'origin',
		[vm_static].[initrd_url] as 'initrd_url',
		[vm_static].[kernel_url] as 'kernel_url',
		[vm_static].[kernel_params] as 'kernel_params',
		[vm_static].[migration_support] as 'migration_support',
		[vm_static].[predefined_properties] as 'predefined_properties',
		[vm_static].[userdefined_properties] as 'userdefined_properties',
		[vm_static].[min_allocated_mem] as 'min_allocated_mem'

FROM [dbo].[vm_static] INNER JOIN
          dbo.vm_dynamic ON dbo.vm_static.vm_guid = dbo.vm_dynamic.vm_guid INNER JOIN
          dbo.vds_groups ON dbo.vm_static.vds_group_id = dbo.vds_groups.vds_group_id LEFT OUTER JOIN
          dbo.storage_pool ON dbo.vm_static.vds_group_id = dbo.vds_groups.vds_group_id 
          and dbo.vds_groups.storage_pool_id = dbo.storage_pool.id
WHERE @sp_id = dbo.storage_pool.id

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVmStaticByVmGuid')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVmStaticByVmGuid] AS RETURN')
END

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVmStaticByVmGuid')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVmStaticByVmGuid] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVmStaticByVmGuid] 
	@vm_guid uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON

	SELECT
		[vm_static].[description] AS 'description',
		[vm_static].[mem_size_mb] AS 'mem_size_mb',
		[vm_static].[os] AS 'os',
		[vm_static].[vds_group_id] AS 'vds_group_id',
		[vm_static].[vm_guid] AS 'vm_guid',
		[vm_static].[vm_name] AS 'vm_name',
		[vm_static].[vmt_guid] AS 'vmt_guid',
		[vm_static].[domain]  AS 'domain',
		[vm_static].[creation_date] AS 'creation_date',
		[vm_static].[num_of_monitors]	AS 'num_of_monitors',
		[vm_static].[is_initialized]	AS 'is_initialized',
		[vm_static].[is_auto_suspend]	AS 'is_auto_suspend',
		[vm_static].[num_of_sockets]	AS 'num_of_sockets',
		[vm_static].[cpu_per_socket]	AS 'cpu_per_socket',
		[vm_static].[usb_policy]	AS 'usb_policy',
		[vm_static].[time_zone] AS 'time_zone',
		[vm_static].[auto_startup]	AS 'auto_startup',
		[vm_static].[is_stateless] AS 'is_stateless',
		[vm_static].[dedicated_vm_for_vds]  AS 'dedicated_vm_for_vds',
		[vm_static].[fail_back] as 'fail_back',
		[vm_static].[vm_type] as 'vm_type',
		[vm_static].[hypervisor_type] as 'hypervisor_type',
		[vm_static].[operation_mode] as 'operation_mode',
		[vm_static].[nice_level] as 'nice_level',
		[vm_static].[default_boot_sequence] as 'default_boot_sequence',
		[vm_static].[default_display_type] as 'default_display_type',
		[vm_static].[priority] as 'priority',
		[vm_static].[iso_path] as 'iso_path',
		[vm_static].[origin] as 'origin',
		[vm_static].[initrd_url] as 'initrd_url',
		[vm_static].[kernel_url] as 'kernel_url',
		[vm_static].[kernel_params] as 'kernel_params',
		[vm_static].[migration_support] as 'migration_support',
		[vm_static].[predefined_properties] as 'predefined_properties',
		[vm_static].[userdefined_properties] as 'userdefined_properties',
		[vm_static].[min_allocated_mem] as 'min_allocated_mem'
	
	FROM [dbo].[vm_static] [vm_static]
	WHERE [vm_guid]=@vm_guid

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVmStaticByName')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVmStaticByName] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVmStaticByName] 
	@vm_name nvarchar(255)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	SELECT
		[vm_static].[description] AS 'description',
		[vm_static].[mem_size_mb] AS 'mem_size_mb',
		[vm_static].[os] AS 'os',
		[vm_static].[vds_group_id] AS 'vds_group_id',
		[vm_static].[vm_guid] AS 'vm_guid',
		[vm_static].[vm_name] AS 'vm_name',
		[vm_static].[vmt_guid] AS 'vmt_guid',
		[vm_static].[domain]  AS 'domain',
		[vm_static].[creation_date] AS 'creation_date',
		[vm_static].[num_of_monitors]	AS 'num_of_monitors',
		[vm_static].[is_initialized]	AS 'is_initialized',
		[vm_static].[is_auto_suspend]	AS 'is_auto_suspend',
		[vm_static].[num_of_sockets]	AS 'num_of_sockets',
		[vm_static].[cpu_per_socket]	AS 'cpu_per_socket',
		[vm_static].[usb_policy]	AS 'usb_policy',
		[vm_static].[time_zone] AS 'time_zone',
		[vm_static].[auto_startup]	AS 'auto_startup',
		[vm_static].[is_stateless] AS 'is_stateless',
		[vm_static].[dedicated_vm_for_vds]  AS 'dedicated_vm_for_vds',
		[vm_static].[fail_back] as 'fail_back',
		[vm_static].[vm_type] as 'vm_type',
		[vm_static].[hypervisor_type] as 'hypervisor_type',
		[vm_static].[operation_mode] as 'operation_mode',
		[vm_static].[nice_level] as 'nice_level',
		[vm_static].[default_boot_sequence] as 'default_boot_sequence',
		[vm_static].[default_display_type] as 'default_display_type',
		[vm_static].[priority] as 'priority',
		[vm_static].[iso_path] as 'iso_path',
		[vm_static].[origin] as 'origin',
		[vm_static].[initrd_url] as 'initrd_url',
		[vm_static].[kernel_url] as 'kernel_url',
		[vm_static].[kernel_params] as 'kernel_params',
		[vm_static].[migration_support] as 'migration_support',
		[vm_static].[predefined_properties] as 'predefined_properties',
		[vm_static].[userdefined_properties] as 'userdefined_properties',
		[vm_static].[min_allocated_mem] as 'min_allocated_mem'
	
	FROM [dbo].[vm_static] [vm_static]
	WHERE [vm_name]=@vm_name

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVmStaticByVdsGroup')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVmStaticByVdsGroup] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVmStaticByVdsGroup] 
 @vds_group_id uniqueidentifier  
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
		[vm_static].[description] AS 'description',
		[vm_static].[mem_size_mb] AS 'mem_size_mb',
		[vm_static].[os] AS 'os',
		[vm_static].[vds_group_id] AS 'vds_group_id',
		[vm_static].[vm_guid] AS 'vm_guid',
		[vm_static].[vm_name] AS 'vm_name',
		[vm_static].[vmt_guid] AS 'vmt_guid',
		[vm_static].[domain]  AS 'domain',
		[vm_static].[creation_date] AS 'creation_date',
		[vm_static].[num_of_monitors]	AS 'num_of_monitors',
		[vm_static].[is_initialized]	AS 'is_initialized',
		[vm_static].[is_auto_suspend]	AS 'is_auto_suspend',
		[vm_static].[num_of_sockets]	AS 'num_of_sockets',
		[vm_static].[cpu_per_socket]	AS 'cpu_per_socket',
		[vm_static].[usb_policy]	AS 'usb_policy',
		[vm_static].[time_zone] AS 'time_zone',
		[vm_static].[auto_startup]	AS 'auto_startup',
		[vm_static].[is_stateless] AS 'is_stateless',
		[vm_static].[dedicated_vm_for_vds]  AS 'dedicated_vm_for_vds',
		[vm_static].[fail_back] as 'fail_back',
		[vm_static].[vm_type] as 'vm_type',
		[vm_static].[hypervisor_type] as 'hypervisor_type',
		[vm_static].[operation_mode] as 'operation_mode',
		[vm_static].[nice_level] as 'nice_level',
		[vm_static].[default_boot_sequence] as 'default_boot_sequence',
		[vm_static].[default_display_type] as 'default_display_type',
		[vm_static].[priority] as 'priority',
		[vm_static].[iso_path] as 'iso_path',
		[vm_static].[origin] as 'origin',
		[vm_static].[initrd_url] as 'initrd_url',
		[vm_static].[kernel_url] as 'kernel_url',
		[vm_static].[kernel_params] as 'kernel_params',
		[vm_static].[migration_support] as 'migration_support',
		[vm_static].[predefined_properties] as 'predefined_properties',
		[vm_static].[userdefined_properties] as 'userdefined_properties',
		[vm_static].[min_allocated_mem] as 'min_allocated_mem'
	
	FROM [dbo].[vm_static] [vm_static]
	WHERE [vds_group_id]=@vds_group_id

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVmStaticWithFailbackByVdsId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVmStaticWithFailbackByVdsId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVmStaticWithFailbackByVdsId] 
 @vds_id uniqueidentifier  
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
		[vm_static].[description] AS 'description',
		[vm_static].[mem_size_mb] AS 'mem_size_mb',
		[vm_static].[os] AS 'os',
		[vm_static].[vds_group_id] AS 'vds_group_id',
		[vm_static].[vm_guid] AS 'vm_guid',
		[vm_static].[vm_name] AS 'vm_name',
		[vm_static].[vmt_guid] AS 'vmt_guid',
		[vm_static].[domain]  AS 'domain',
		[vm_static].[creation_date] AS 'creation_date',
		[vm_static].[num_of_monitors]	AS 'num_of_monitors',
		[vm_static].[is_initialized]	AS 'is_initialized',
		[vm_static].[is_auto_suspend]	AS 'is_auto_suspend',
		[vm_static].[num_of_sockets]	AS 'num_of_sockets',
		[vm_static].[cpu_per_socket]	AS 'cpu_per_socket',
		[vm_static].[usb_policy]	AS 'usb_policy',
		[vm_static].[time_zone] AS 'time_zone',
		[vm_static].[auto_startup]	AS 'auto_startup',
		[vm_static].[is_stateless] AS 'is_stateless',
		[vm_static].[dedicated_vm_for_vds]  AS 'dedicated_vm_for_vds',
		[vm_static].[fail_back] as 'fail_back',
		[vm_static].[vm_type] as 'vm_type',
		[vm_static].[hypervisor_type] as 'hypervisor_type',
		[vm_static].[operation_mode] as 'operation_mode',
		[vm_static].[nice_level] as 'nice_level',
		[vm_static].[default_boot_sequence] as 'default_boot_sequence',
		[vm_static].[default_display_type] as 'default_display_type',
		[vm_static].[priority] as 'priority',
		[vm_static].[iso_path] as 'iso_path',
		[vm_static].[origin] as 'origin',
		[vm_static].[initrd_url] as 'initrd_url',
		[vm_static].[kernel_url] as 'kernel_url',
		[vm_static].[kernel_params] as 'kernel_params',
		[vm_static].[migration_support] as 'migration_support',
		[vm_static].[predefined_properties] as 'predefined_properties',
		[vm_static].[userdefined_properties] as 'userdefined_properties',
		[vm_static].[min_allocated_mem] as 'min_allocated_mem'
	
	FROM [dbo].[vm_static] [vm_static]
	WHERE [dedicated_vm_for_vds]=@vds_id and [fail_back] = 1

	SET NOCOUNT OFF
END

GO
-----------------------------------------------------------------------------------------
---   [dbo].[vms] - view
-----------------------------------------------------------------------------------------



IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromVms')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromVms] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromVms]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
		SELECT
		distinct([vms].[vm_guid]) AS 'vm_guid',
		[vms].[vm_name] AS 'vm_name',
		[vms].[vm_mem_size_mb] AS 'vm_mem_size_mb',
		[vms].[vmt_guid] AS 'vmt_guid',
		[vms].[vm_os] AS 'vm_os',
		[vms].[vm_description] AS 'vm_description',
		[vms].[vds_group_id] AS 'vds_group_id',
		[vms].[vm_domain] AS 'vm_domain',
		[vms].[vm_creation_date] AS 'vm_creation_date',
		[vms].[vds_group_name] AS 'vds_group_name',
		[vms].[vds_group_description] AS 'vds_group_description',
		[vms].[vmt_name] AS 'vmt_name',
		[vms].[vmt_mem_size_mb] AS 'vmt_mem_size_mb',
		[vms].[vmt_os] AS 'vmt_os',
		[vms].[vmt_creation_date] AS 'vmt_creation_date',
		[vms].[vmt_child_count] AS 'vmt_child_count',
		[vms].[vmt_num_of_cpus] AS 'vmt_num_of_cpus',
		[vms].[vmt_num_of_sockets] AS 'vmt_num_of_sockets',
		[vms].[vmt_cpu_per_socket] AS 'vmt_cpu_per_socket',
		[vms].[vmt_description] AS 'vmt_description',
		[vms].[status] AS 'status',
		[vms].[vm_ip] AS 'vm_ip',
		[vms].[vm_host] AS 'vm_host',
		[vms].[vm_pid] AS 'vm_pid',
		[vms].[vm_last_up_time] AS 'vm_last_up_time',
		[vms].[vm_last_boot_time] AS 'vm_last_boot_time',
		[vms].[guest_cur_user_name] AS 'guest_cur_user_name',
		[vms].[guest_last_login_time] AS 'guest_last_login_time',
		[vms].[guest_cur_user_id] AS 'guest_cur_user_id',
		[vms].[guest_last_logout_time] AS 'guest_last_logout_time',
		[vms].[guest_os] AS 'guest_os',
		[vms].[cpu_user] AS 'cpu_user',
		[vms].[cpu_sys] AS 'cpu_sys',
		[vms].[elapsed_time] AS 'elapsed_time',
		[vms].[usage_network_percent] AS 'usage_network_percent',
		[vms].[usage_mem_percent] AS 'usage_mem_percent',
		[vms].[usage_cpu_percent] AS 'usage_cpu_percent',
		[vms].[run_on_vds] AS 'run_on_vds',
		[vms].[migrating_to_vds] AS 'migrating_to_vds',
		[vms].[app_list] AS 'app_list',
		[vms].[display] AS 'display',
		[vms].[vm_pool_name] AS 'vm_pool_name',
		[vms].[vm_pool_id] AS 'vm_pool_id',
		[vms].[num_of_monitors]	AS 'num_of_monitors',
		[vms].[is_initialized]  AS 'is_initialized',
		[vms].[is_auto_suspend]  AS 'is_auto_suspend',
		[vms].[num_of_cpus]	AS 'num_of_cpus',
		[vms].[num_of_sockets]	AS 'num_of_sockets',
		[vms].[cpu_per_socket]	AS 'cpu_per_socket',
		[vms].[usb_policy]	AS 'usb_policy',
		[vms].[acpi_enable]	AS 'acpi_enable',
		[vms].[session]	AS 'session',
		[vms].[display_ip] AS 'display_ip',
		[vms].[display_type] AS 'display_type',
		[vms].[kvm_enable] AS 'kvm_enable',
		[vms].[boot_sequence] AS 'boot_sequence',
		[vms].[run_on_vds_name] AS 'run_on_vds_name',
		[vms].[time_zone] AS 'time_zone',
		[vms].[display_secure_port] AS 'display_secure_port',
		[vms].[utc_diff] AS 'utc_diff',
		[vms].[auto_startup] AS 'auto_startup',
		[vms].[is_stateless] AS 'is_stateless',
		[vms].[dedicated_vm_for_vds] as 'dedicated_vm_for_vds',
		[vms].[fail_back] as 'fail_back',
		[vms].[last_vds_run_on] as 'last_vds_run_on',
		[vms].[client_ip] as 'client_ip',
		[vms].[guest_requested_memory] as 'guest_requested_memory',
		[vms].[vds_group_cpu_name] as 'vds_group_cpu_name',
		[vms].[vm_type] as 'vm_type',
		[vms].[storage_pool_id] as 'storage_pool_id',
		[vms].[storage_pool_name] as 'storage_pool_name',
		[vms].[hypervisor_type] as 'hypervisor_type',
		[vms].[operation_mode] as 'operation_mode',
		[vms].[selection_algorithm] as 'selection_algorithm',
		[vms].[transparent_hugepages] as 'transparent_hugepages',
		[vms].[nice_level] as 'nice_level',
		[vms].[hibernation_vol_handle] as 'hibernation_vol_handle',
		[vms].[default_boot_sequence] as 'default_boot_sequence',
		[vms].[default_display_type] as 'default_display_type',
		[vms].[priority] as 'priority',
		[vms].[iso_path] as 'iso_path',	
		[vms].[origin] as 'origin',
		[vms].[vds_group_compatibility_version] as 'vds_group_compatibility_version',
		[vms].[initrd_url] as 'initrd_url',
		[vms].[kernel_url] as 'kernel_url',
		[vms].[kernel_params] as 'kernel_params',
		[vms].[exit_status] as 'exit_status',
		[vms].[pause_status] as 'pause_status',
		[vms].[exit_message] as 'exit_message',
		[vms].[migration_support] as 'migration_support',
		[vms].[predefined_properties] as 'predefined_properties',
		[vms].[userdefined_properties] as 'userdefined_properties',
		[vms].[min_allocated_mem] as 'min_allocated_mem'

	
FROM [dbo].[vms] [vms]

	SET NOCOUNT OFF
END

GO


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVmByVmGuid')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVmByVmGuid] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVmByVmGuid]   
	@vm_guid uniqueidentifier 
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
		SELECT
		distinct([vms].[vm_guid]) AS 'vm_guid',
		[vms].[vm_name] AS 'vm_name',
		[vms].[vm_mem_size_mb] AS 'vm_mem_size_mb',
		[vms].[vmt_guid] AS 'vmt_guid',
		[vms].[vm_os] AS 'vm_os',
		[vms].[vm_description] AS 'vm_description',
		[vms].[vds_group_id] AS 'vds_group_id',
		[vms].[vm_domain] AS 'vm_domain',
		[vms].[vm_creation_date] AS 'vm_creation_date',
		[vms].[vds_group_name] AS 'vds_group_name',
		[vms].[vds_group_description] AS 'vds_group_description',
		[vms].[vmt_name] AS 'vmt_name',
		[vms].[vmt_mem_size_mb] AS 'vmt_mem_size_mb',
		[vms].[vmt_os] AS 'vmt_os',
		[vms].[vmt_creation_date] AS 'vmt_creation_date',
		[vms].[vmt_child_count] AS 'vmt_child_count',
		[vms].[vmt_num_of_cpus] AS 'vmt_num_of_cpus',
		[vms].[vmt_num_of_sockets] AS 'vmt_num_of_sockets',
		[vms].[vmt_cpu_per_socket] AS 'vmt_cpu_per_socket',
		[vms].[vmt_description] AS 'vmt_description',
		[vms].[status] AS 'status',
		[vms].[vm_ip] AS 'vm_ip',
		[vms].[vm_host] AS 'vm_host',
		[vms].[vm_pid] AS 'vm_pid',
		[vms].[vm_last_up_time] AS 'vm_last_up_time',
		[vms].[vm_last_boot_time] AS 'vm_last_boot_time',
		[vms].[guest_cur_user_name] AS 'guest_cur_user_name',
		[vms].[guest_last_login_time] AS 'guest_last_login_time',
		[vms].[guest_cur_user_id] AS 'guest_cur_user_id',
		[vms].[guest_last_logout_time] AS 'guest_last_logout_time',
		[vms].[guest_os] AS 'guest_os',
		[vms].[cpu_user] AS 'cpu_user',
		[vms].[cpu_sys] AS 'cpu_sys',
		[vms].[elapsed_time] AS 'elapsed_time',
		[vms].[usage_network_percent] AS 'usage_network_percent',
		[vms].[usage_mem_percent] AS 'usage_mem_percent',
		[vms].[usage_cpu_percent] AS 'usage_cpu_percent',
		[vms].[run_on_vds] AS 'run_on_vds',
		[vms].[migrating_to_vds] AS 'migrating_to_vds',
		[vms].[app_list] AS 'app_list',
		[vms].[display] AS 'display',
		[vms].[vm_pool_name] AS 'vm_pool_name',
		[vms].[vm_pool_id] AS 'vm_pool_id',
		[vms].[num_of_monitors]	AS 'num_of_monitors',
		[vms].[is_initialized]  AS 'is_initialized',
		[vms].[is_auto_suspend]  AS 'is_auto_suspend',
		[vms].[num_of_cpus]	AS 'num_of_cpus',
		[vms].[num_of_sockets]	AS 'num_of_sockets',
		[vms].[cpu_per_socket]	AS 'cpu_per_socket',
		[vms].[usb_policy]	AS 'usb_policy',
		[vms].[acpi_enable]	AS 'acpi_enable',
		[vms].[session]	AS 'session',
		[vms].[display_ip] AS 'display_ip',
		[vms].[display_type] AS 'display_type',
		[vms].[kvm_enable] AS 'kvm_enable',
		[vms].[boot_sequence] AS 'boot_sequence',
		[vms].[run_on_vds_name] AS 'run_on_vds_name',
		[vms].[time_zone] AS 'time_zone',
		[vms].[display_secure_port] AS 'display_secure_port',
		[vms].[utc_diff] AS 'utc_diff',
		[vms].[auto_startup] AS 'auto_startup',
		[vms].[is_stateless] AS 'is_stateless',
		[vms].[dedicated_vm_for_vds] AS 'dedicated_vm_for_vds',
		[vms].[fail_back] as 'fail_back',
		[vms].[last_vds_run_on] as 'last_vds_run_on',
		[vms].[client_ip] as 'client_ip',
		[vms].[guest_requested_memory] as 'guest_requested_memory',
		[vms].[vds_group_cpu_name] as 'vds_group_cpu_name',
		[vms].[vm_type] as 'vm_type',
		[vms].[storage_pool_id] as 'storage_pool_id',
		[vms].[storage_pool_name] as 'storage_pool_name',
		[vms].[hypervisor_type] as 'hypervisor_type',
		[vms].[operation_mode] as 'operation_mode',
		[vms].[selection_algorithm] as 'selection_algorithm',
		[vms].[transparent_hugepages] as 'transparent_hugepages',
		[vms].[nice_level] as 'nice_level',
		[vms].[hibernation_vol_handle] as 'hibernation_vol_handle',
		[vms].[default_boot_sequence] as 'default_boot_sequence',
		[vms].[default_display_type] as 'default_display_type',
		[vms].[priority] as 'priority',
		[vms].[iso_path] as 'iso_path',	
		[vms].[origin] as 'origin',
		[vms].[vds_group_compatibility_version] as 'vds_group_compatibility_version',
		[vms].[initrd_url] as 'initrd_url',
		[vms].[kernel_url] as 'kernel_url',
		[vms].[kernel_params] as 'kernel_params',
		[vms].[exit_status] as 'exit_status',
		[vms].[pause_status] as 'pause_status',
		[vms].[exit_message] as 'exit_message',
		[vms].[migration_support] as 'migration_support',
		[vms].[predefined_properties] as 'predefined_properties',
		[vms].[userdefined_properties] as 'userdefined_properties',
		[vms].[min_allocated_mem] as 'min_allocated_mem'
	
	
FROM [dbo].[vms] [vms]
WHERE [vm_guid]=@vm_guid
	SET NOCOUNT OFF
END

GO


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVmsByVmtGuid')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVmsByVmtGuid] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVmsByVmtGuid]   
	@vmt_guid uniqueidentifier 
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
		distinct([vms].[vm_guid]) AS 'vm_guid',
		[vms].[vm_name] AS 'vm_name',
		[vms].[vm_mem_size_mb] AS 'vm_mem_size_mb',
		[vms].[vmt_guid] AS 'vmt_guid',
		[vms].[vm_os] AS 'vm_os',
		[vms].[vm_description] AS 'vm_description',
		[vms].[vds_group_id] AS 'vds_group_id',
		[vms].[vm_domain] AS 'vm_domain',
		[vms].[vm_creation_date] AS 'vm_creation_date',
		[vms].[vds_group_name] AS 'vds_group_name',
		[vms].[vds_group_description] AS 'vds_group_description',
		[vms].[vmt_name] AS 'vmt_name',
		[vms].[vmt_mem_size_mb] AS 'vmt_mem_size_mb',
		[vms].[vmt_os] AS 'vmt_os',
		[vms].[vmt_creation_date] AS 'vmt_creation_date',
		[vms].[vmt_child_count] AS 'vmt_child_count',
		[vms].[vmt_num_of_cpus] AS 'vmt_num_of_cpus',
		[vms].[vmt_num_of_sockets] AS 'vmt_num_of_sockets',
		[vms].[vmt_cpu_per_socket] AS 'vmt_cpu_per_socket',
		[vms].[vmt_description] AS 'vmt_description',
		[vms].[status] AS 'status',
		[vms].[vm_ip] AS 'vm_ip',
		[vms].[vm_host] AS 'vm_host',
		[vms].[vm_pid] AS 'vm_pid',
		[vms].[vm_last_up_time] AS 'vm_last_up_time',
		[vms].[vm_last_boot_time] AS 'vm_last_boot_time',
		[vms].[guest_cur_user_name] AS 'guest_cur_user_name',
		[vms].[guest_last_login_time] AS 'guest_last_login_time',
		[vms].[guest_cur_user_id] AS 'guest_cur_user_id',
		[vms].[guest_last_logout_time] AS 'guest_last_logout_time',
		[vms].[guest_os] AS 'guest_os',
		[vms].[cpu_user] AS 'cpu_user',
		[vms].[cpu_sys] AS 'cpu_sys',
		[vms].[elapsed_time] AS 'elapsed_time',
		[vms].[usage_network_percent] AS 'usage_network_percent',
		[vms].[usage_mem_percent] AS 'usage_mem_percent',
		[vms].[usage_cpu_percent] AS 'usage_cpu_percent',
		[vms].[run_on_vds] AS 'run_on_vds',
		[vms].[migrating_to_vds] AS 'migrating_to_vds',
		[vms].[app_list] AS 'app_list',
		[vms].[display] AS 'display',
		[vms].[vm_pool_name] AS 'vm_pool_name',
		[vms].[vm_pool_id] AS 'vm_pool_id',
		[vms].[num_of_monitors]	AS 'num_of_monitors',
		[vms].[is_initialized]  AS 'is_initialized',
		[vms].[is_auto_suspend]  AS 'is_auto_suspend',
		[vms].[num_of_cpus]	AS 'num_of_cpus',
		[vms].[num_of_sockets]	AS 'num_of_sockets',
		[vms].[cpu_per_socket]	AS 'cpu_per_socket',
		[vms].[usb_policy]	AS 'usb_policy',
		[vms].[acpi_enable]	AS 'acpi_enable',
		[vms].[session]	AS 'session',
		[vms].[display_ip] AS 'display_ip',
		[vms].[display_type] AS 'display_type',
		[vms].[kvm_enable] AS 'kvm_enable',
		[vms].[boot_sequence] AS 'boot_sequence',
		[vms].[run_on_vds_name] AS 'run_on_vds_name',
		[vms].[time_zone] AS 'time_zone',
		[vms].[display_secure_port] AS 'display_secure_port',
		[vms].[utc_diff] AS 'utc_diff',
		[vms].[auto_startup] AS 'auto_startup',
		[vms].[is_stateless] AS 'is_stateless',
		[vms].[dedicated_vm_for_vds] AS 'dedicated_vm_for_vds',
		[vms].[fail_back] as 'fail_back',
		[vms].[last_vds_run_on] as 'last_vds_run_on',
		[vms].[client_ip] as 'client_ip',
		[vms].[guest_requested_memory] as 'guest_requested_memory',
		[vms].[vds_group_cpu_name] as 'vds_group_cpu_name',
		[vms].[vm_type] as 'vm_type',
		[vms].[storage_pool_id] as 'storage_pool_id',
		[vms].[storage_pool_name] as 'storage_pool_name',
		[vms].[hypervisor_type] as 'hypervisor_type',
		[vms].[operation_mode] as 'operation_mode',
		[vms].[selection_algorithm] as 'selection_algorithm',
		[vms].[transparent_hugepages] as 'transparent_hugepages',
		[vms].[nice_level] as 'nice_level',
		[vms].[hibernation_vol_handle] as 'hibernation_vol_handle',
		[vms].[default_boot_sequence] as 'default_boot_sequence',
		[vms].[default_display_type] as 'default_display_type',
		[vms].[priority] as 'priority',
		[vms].[iso_path] as 'iso_path',	
		[vms].[origin] as 'origin',
		[vms].[vds_group_compatibility_version] as 'vds_group_compatibility_version',
		[vms].[initrd_url] as 'initrd_url',
		[vms].[kernel_url] as 'kernel_url',
		[vms].[kernel_params] as 'kernel_params',
		[vms].[exit_status] as 'exit_status',
		[vms].[pause_status] as 'pause_status',
		[vms].[exit_message] as 'exit_message',
		[vms].[migration_support] as 'migration_support',
		[vms].[predefined_properties] as 'predefined_properties',
		[vms].[userdefined_properties] as 'userdefined_properties',
		[vms].[min_allocated_mem] as 'min_allocated_mem'
	
FROM [dbo].[vms] [vms]
WHERE [vmt_guid]=@vmt_guid
	SET NOCOUNT OFF
END

GO



IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVmsByUserId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVmsByUserId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVmsByUserId]   
	@user_id uniqueidentifier 
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	select vms.* from vms
		inner join permissions on vms.vm_guid = permissions.object_id
	WHERE [permissions].ad_element_id=@user_id
	SET NOCOUNT OFF
END

GO



IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVmsByUserIdWithGroupsAndUserRoles')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVmsByUserIdWithGroupsAndUserRoles] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVmsByUserIdWithGroupsAndUserRoles]
	@user_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	select distinct([vms].[vm_guid]) AS 'vm_guid',
		[vms].[vm_name] AS 'vm_name',
		[vms].[vm_mem_size_mb] AS 'vm_mem_size_mb',
		[vms].[vmt_guid] AS 'vmt_guid',
		[vms].[vm_os] AS 'vm_os',
		[vms].[vm_description] AS 'vm_description',
		[vms].[vds_group_id] AS 'vds_group_id',
		[vms].[vm_domain] AS 'vm_domain',
		[vms].[vm_creation_date] AS 'vm_creation_date',
		[vms].[vds_group_name] AS 'vds_group_name',
		[vms].[vds_group_description] AS 'vds_group_description',
		[vms].[vmt_name] AS 'vmt_name',
		[vms].[vmt_mem_size_mb] AS 'vmt_mem_size_mb',
		[vms].[vmt_os] AS 'vmt_os',
		[vms].[vmt_creation_date] AS 'vmt_creation_date',
		[vms].[vmt_child_count] AS 'vmt_child_count',
		[vms].[vmt_num_of_cpus] AS 'vmt_num_of_cpus',
		[vms].[vmt_num_of_sockets] AS 'vmt_num_of_sockets',
		[vms].[vmt_cpu_per_socket] AS 'vmt_cpu_per_socket',
		[vms].[vmt_description] AS 'vmt_description',
		[vms].[status] AS 'status',
		[vms].[vm_ip] AS 'vm_ip',
		[vms].[vm_host] AS 'vm_host',
		[vms].[vm_pid] AS 'vm_pid',
		[vms].[vm_last_up_time] AS 'vm_last_up_time',
		[vms].[vm_last_boot_time] AS 'vm_last_boot_time',
		[vms].[guest_cur_user_name] AS 'guest_cur_user_name',
		[vms].[guest_last_login_time] AS 'guest_last_login_time',
		[vms].[guest_cur_user_id] AS 'guest_cur_user_id',
		[vms].[guest_last_logout_time] AS 'guest_last_logout_time',
		[vms].[guest_os] AS 'guest_os',
		[vms].[cpu_user] AS 'cpu_user',
		[vms].[cpu_sys] AS 'cpu_sys',
		[vms].[elapsed_time] AS 'elapsed_time',
		[vms].[usage_network_percent] AS 'usage_network_percent',
		[vms].[usage_mem_percent] AS 'usage_mem_percent',
		[vms].[usage_cpu_percent] AS 'usage_cpu_percent',
		[vms].[run_on_vds] AS 'run_on_vds',
		[vms].[migrating_to_vds] AS 'migrating_to_vds',
		[vms].[app_list] AS 'app_list',
		[vms].[display] AS 'display',
		[vms].[vm_pool_name] AS 'vm_pool_name',
		[vms].[vm_pool_id] AS 'vm_pool_id',
		[vms].[num_of_monitors]	AS 'num_of_monitors',
		[vms].[is_initialized]  AS 'is_initialized',
		[vms].[is_auto_suspend]  AS 'is_auto_suspend',
		[vms].[num_of_cpus]	AS 'num_of_cpus',
		[vms].[num_of_sockets]	AS 'num_of_sockets',
		[vms].[cpu_per_socket]	AS 'cpu_per_socket',
		[vms].[usb_policy]	AS 'usb_policy',
		[vms].[acpi_enable]	AS 'acpi_enable',
		[vms].[session]	AS 'session',
		[vms].[display_ip] AS 'display_ip',
		[vms].[display_type] AS 'display_type',
		[vms].[kvm_enable] AS 'kvm_enable',
		[vms].[boot_sequence] AS 'boot_sequence',
		[vms].[run_on_vds_name] AS 'run_on_vds_name',
		[vms].[time_zone] AS 'time_zone',
		[vms].[display_secure_port] AS 'display_secure_port',
		[vms].[utc_diff] AS 'utc_diff',
		[vms].[auto_startup] AS 'auto_startup',
		[vms].[is_stateless] AS 'is_stateless',
		[vms].[dedicated_vm_for_vds] AS 'dedicated_vm_for_vds',
		[vms].[fail_back] as 'fail_back',
		[vms].[last_vds_run_on] as 'last_vds_run_on',
		[vms].[client_ip] as 'client_ip',
		[vms].[guest_requested_memory] as 'guest_requested_memory',
		[vms].[vds_group_cpu_name] as 'vds_group_cpu_name',
		[vms].[vm_type] as 'vm_type',
		[vms].[storage_pool_id] as 'storage_pool_id',
		[vms].[storage_pool_name] as 'storage_pool_name',
		[vms].[hypervisor_type] as 'hypervisor_type',
		[vms].[operation_mode] as 'operation_mode',
		[vms].[selection_algorithm] as 'selection_algorithm',
		[vms].[transparent_hugepages] as 'transparent_hugepages',
		[vms].[nice_level] as 'nice_level',
		[vms].[hibernation_vol_handle] as 'hibernation_vol_handle',
		[vms].[default_boot_sequence] as 'default_boot_sequence',
		[vms].[default_display_type] as 'default_display_type',
		[vms].[iso_path] as 'iso_path',
		[vms].[origin] as 'origin',
		[vms].[priority] as 'priority',
		[vms].[vds_group_compatibility_version] as 'vds_group_compatibility_version',
		[vms].[initrd_url] as 'initrd_url',
		[vms].[kernel_url] as 'kernel_url',
		[vms].[kernel_params] as 'kernel_params',
		[vms].[exit_status] as 'exit_status',
		[vms].[pause_status] as 'pause_status',
		[vms].[exit_message] as 'exit_message',
		[vms].[migration_support] as 'migration_support',
		[vms].[predefined_properties] as 'predefined_properties',
		[vms].[userdefined_properties] as 'userdefined_properties',
		[vms].[min_allocated_mem] as 'min_allocated_mem'
	from vms
		inner join permissions_view as perms on vms.vm_guid = perms.object_id
	WHERE perms.ad_element_id in (select id from getUserAndGroupsById(@user_id)) and
		perms.role_type = 2

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVmsRunningOnVds')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVmsRunningOnVds] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVmsRunningOnVds]   
 @vds_id uniqueidentifier   
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
		distinct([vms].[vm_guid]) AS 'vm_guid',
		[vms].[vm_name] AS 'vm_name',
		[vms].[vm_mem_size_mb] AS 'vm_mem_size_mb',
		[vms].[vmt_guid] AS 'vmt_guid',
		[vms].[vm_os] AS 'vm_os',
		[vms].[vm_description] AS 'vm_description',
		[vms].[vds_group_id] AS 'vds_group_id',
		[vms].[vm_domain] AS 'vm_domain',
		[vms].[vm_creation_date] AS 'vm_creation_date',
		[vms].[vds_group_name] AS 'vds_group_name',
		[vms].[vds_group_description] AS 'vds_group_description',
		[vms].[vmt_name] AS 'vmt_name',
		[vms].[vmt_mem_size_mb] AS 'vmt_mem_size_mb',
		[vms].[vmt_os] AS 'vmt_os',
		[vms].[vmt_creation_date] AS 'vmt_creation_date',
		[vms].[vmt_child_count] AS 'vmt_child_count',
		[vms].[vmt_num_of_cpus] AS 'vmt_num_of_cpus',
		[vms].[vmt_num_of_sockets] AS 'vmt_num_of_sockets',
		[vms].[vmt_cpu_per_socket] AS 'vmt_cpu_per_socket',
		[vms].[vmt_description] AS 'vmt_description',
		[vms].[status] AS 'status',
		[vms].[vm_ip] AS 'vm_ip',
		[vms].[vm_host] AS 'vm_host',
		[vms].[vm_pid] AS 'vm_pid',
		[vms].[vm_last_up_time] AS 'vm_last_up_time',
		[vms].[vm_last_boot_time] AS 'vm_last_boot_time',
		[vms].[guest_cur_user_name] AS 'guest_cur_user_name',
		[vms].[guest_last_login_time] AS 'guest_last_login_time',
		[vms].[guest_cur_user_id] AS 'guest_cur_user_id',
		[vms].[guest_last_logout_time] AS 'guest_last_logout_time',
		[vms].[guest_os] AS 'guest_os',
		[vms].[cpu_user] AS 'cpu_user',
		[vms].[cpu_sys] AS 'cpu_sys',
		[vms].[elapsed_time] AS 'elapsed_time',
		[vms].[usage_network_percent] AS 'usage_network_percent',
		[vms].[usage_mem_percent] AS 'usage_mem_percent',
		[vms].[usage_cpu_percent] AS 'usage_cpu_percent',
		[vms].[run_on_vds] AS 'run_on_vds',
		[vms].[migrating_to_vds] AS 'migrating_to_vds',
		[vms].[app_list] AS 'app_list',
		[vms].[display] AS 'display',
		[vms].[vm_pool_name] AS 'vm_pool_name',
		[vms].[vm_pool_id] AS 'vm_pool_id',
		[vms].[num_of_monitors]	AS 'num_of_monitors',
		[vms].[is_initialized]  AS 'is_initialized',
		[vms].[is_auto_suspend]  AS 'is_auto_suspend',
		[vms].[num_of_cpus]	AS 'num_of_cpus',
		[vms].[num_of_sockets]	AS 'num_of_sockets',
		[vms].[cpu_per_socket]	AS 'cpu_per_socket',
		[vms].[usb_policy]	AS 'usb_policy',
		[vms].[acpi_enable]	AS 'acpi_enable',
		[vms].[session]	AS 'session',
		[vms].[display_ip] AS 'display_ip',
		[vms].[display_type] AS 'display_type',
		[vms].[kvm_enable] AS 'kvm_enable',
		[vms].[boot_sequence] AS 'boot_sequence',
		[vms].[run_on_vds_name] AS 'run_on_vds_name',
		[vms].[time_zone] AS 'time_zone',
		[vms].[display_secure_port] AS 'display_secure_port',
		[vms].[utc_diff] AS 'utc_diff',
		[vms].[auto_startup] AS 'auto_startup',
		[vms].[is_stateless] AS 'is_stateless',
		[vms].[dedicated_vm_for_vds] AS 'dedicated_vm_for_vds',
		[vms].[fail_back] as 'fail_back',
		[vms].[last_vds_run_on] as 'last_vds_run_on',
		[vms].[client_ip] as 'client_ip',
		[vms].[guest_requested_memory] as 'guest_requested_memory',
		[vms].[vds_group_cpu_name] as 'vds_group_cpu_name',
		[vms].[vm_type] as 'vm_type',
		[vms].[storage_pool_id] as 'storage_pool_id',
		[vms].[storage_pool_name] as 'storage_pool_name',
		[vms].[hypervisor_type] as 'hypervisor_type',
		[vms].[operation_mode] as 'operation_mode',
		[vms].[selection_algorithm] as 'selection_algorithm',
		[vms].[transparent_hugepages] as 'transparent_hugepages',
		[vms].[nice_level] as 'nice_level',
		[vms].[hibernation_vol_handle] as 'hibernation_vol_handle',
		[vms].[default_boot_sequence] as 'default_boot_sequence',
		[vms].[default_display_type] as 'default_display_type',
		[vms].[priority] as 'priority',
		[vms].[iso_path] as 'iso_path',	
		[vms].[origin] as 'origin',
		[vms].[vds_group_compatibility_version] as 'vds_group_compatibility_version',
		[vms].[initrd_url] as 'initrd_url',
		[vms].[kernel_url] as 'kernel_url',
		[vms].[kernel_params] as 'kernel_params',
		[vms].[exit_status] as 'exit_status',
		[vms].[pause_status] as 'pause_status',
		[vms].[exit_message] as 'exit_message',
		[vms].[migration_support] as 'migration_support',
		[vms].[predefined_properties] as 'predefined_properties',
		[vms].[userdefined_properties] as 'userdefined_properties',
		[vms].[min_allocated_mem] as 'min_allocated_mem'
	
FROM [dbo].[vms] [vms]
WHERE [run_on_vds]=@vds_id

	SET NOCOUNT OFF
END

GO


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVmsDynamicRunningOnVds')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVmsDynamicRunningOnVds] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVmsDynamicRunningOnVds]   
	@vds_id uniqueidentifier 
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[vm_dynamic].[app_list] AS 'app_list',
		[vm_dynamic].[guest_cur_user_id] AS 'guest_cur_user_id',
		[vm_dynamic].[guest_cur_user_name] AS 'guest_cur_user_name',
		[vm_dynamic].[guest_last_login_time] AS 'guest_last_login_time',
		[vm_dynamic].[guest_last_logout_time] AS 'guest_last_logout_time',
		[vm_dynamic].[guest_os] AS 'guest_os',
		[vm_dynamic].[migrating_to_vds] AS 'migrating_to_vds',
		[vm_dynamic].[run_on_vds] AS 'run_on_vds',
		[vm_dynamic].[status] AS 'status',
		[vm_dynamic].[vm_guid] AS 'vm_guid',
		[vm_dynamic].[vm_host] AS 'vm_host',
		[vm_dynamic].[vm_ip] AS 'vm_ip',
		[vm_dynamic].[vm_last_boot_time] AS 'vm_last_boot_time',
		[vm_dynamic].[vm_last_up_time] AS 'vm_last_up_time',
		[vm_dynamic].[vm_pid] AS 'vm_pid',
		[vm_dynamic].[display] AS 'display',
		[vm_dynamic].[acpi_enable] AS 'acpi_enable',
		[vm_dynamic].[session] AS 'session',
		[vm_dynamic].[display_ip] AS 'display_ip',
		[vm_dynamic].[display_type] AS 'display_type',
		[vm_dynamic].[kvm_enable] AS 'kvm_enable',
		[vm_dynamic].[boot_sequence] AS 'boot_sequence',
		[vm_dynamic].[display_secure_port] AS 'display_secure_port',
		[vm_dynamic].[utc_diff] AS 'utc_diff',
		[vm_dynamic].[last_vds_run_on] as 'last_vds_run_on',
		[vm_dynamic].[client_ip] as 'client_ip',
		[vm_dynamic].[guest_requested_memory] as 'guest_requested_memory',
		[vm_dynamic].[hibernation_vol_handle] as 'hibernation_vol_handle',
		[vm_dynamic].[exit_status] as 'exit_status',
		[vm_dynamic].[pause_status] as 'pause_status',
		[vm_dynamic].[exit_message] as 'exit_message'
		
		FROM [dbo].[vm_dynamic] [vm_dynamic]
		WHERE [run_on_vds]=@vds_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO



IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'InsertVm')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[InsertVm] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[InsertVm]
    @description nvarchar(max) = NULL,
 @mem_size_mb int,
 @os nvarchar(40),
 @vds_group_id uniqueidentifier,
 @vm_guid uniqueidentifier,
 @vm_name nvarchar(255),
 @vmt_guid uniqueidentifier,
 @num_of_monitors int,
 @is_initialized   bit,
 @is_auto_suspend   bit,
    @num_of_sockets int,
    @cpu_per_socket int,
 @usb_policy int,
 @time_zone varchar(40) = null,
 @auto_startup bit,
 @is_stateless bit,
 @dedicated_vm_for_vds uniqueidentifier = null,
    @fail_back bit = null,
    @vm_type int = 0,
    @hypervisor_type int = null,
    @operation_mode int = null,
    @nice_level int,
    @default_boot_sequence int,
 @default_display_type int,
 @priority int,
    @iso_path nvarchar(max) = null,
    @origin int = 0,
    @initrd_url nvarchar(max) = null,
    @kernel_url nvarchar(max) = null,
    @kernel_params nvarchar(max) = null,
    @migration_support int = 0,
    @predefined_properties varchar(max) = null,
    @userdefined_properties varchar(max) = null,
	@min_allocated_mem int
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[vm_static] ([description], [mem_size_mb], [os], [vds_group_id], [vm_guid], [vm_name], [vmt_guid], [num_of_monitors], [is_initialized], [is_auto_suspend], [num_of_sockets], [cpu_per_socket], [usb_policy], [time_zone],[auto_startup],[is_stateless],[dedicated_vm_for_vds],[fail_back],[vm_type],[hypervisor_type],[operation_mode],[nice_level],[default_boot_sequence],[default_display_type],[priority],[iso_path],[origin],[initrd_url],[kernel_url],[kernel_params],[migration_support],[predefined_properties],[userdefined_properties],[min_allocated_mem])
	VALUES (@description, @mem_size_mb, @os, @vds_group_id, @vm_guid, @vm_name, @vmt_guid, @num_of_monitors, @is_initialized, @is_auto_suspend, @num_of_sockets, @cpu_per_socket, @usb_policy, @time_zone,@auto_startup,@is_stateless,@dedicated_vm_for_vds,@fail_back,@vm_type,@hypervisor_type,@operation_mode,@nice_level,@default_boot_sequence,@default_display_type,@priority,@iso_path,@origin,@initrd_url,@kernel_url,@kernel_params,@migration_support,@predefined_properties,@userdefined_properties,@min_allocated_mem)
	INSERT INTO [dbo].[vm_dynamic] ([vm_guid], [status]) VALUES (@vm_guid, 0)
	INSERT INTO [dbo].[vm_statistics] ([vm_guid]) VALUES (@vm_guid)

	UPDATE [dbo].[vm_templates]
	SET [child_count] = (SELECT COUNT(*) FROM [dbo].[vm_static] WHERE [vmt_guid]=@vmt_guid)
	WHERE [vmt_guid]=@vmt_guid

    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'DeleteVm')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[DeleteVm] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[DeleteVm]
	 @vm_guid uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON
	BEGIN TRY
			DECLARE @vmt_guid uniqueidentifier
			SELECT @vmt_guid = [vm_static].[vmt_guid] FROM [dbo].[vm_static] WHERE [vm_guid]=@vm_guid 
			
			UPDATE [dbo].[vm_templates]
			SET [child_count] = (SELECT COUNT(*) FROM [dbo].[vm_static] WHERE [vmt_guid]= @vmt_guid) -1
			WHERE [vmt_guid]=@vmt_guid 

			DELETE FROM [dbo].[tags_vm_map]
			WHERE [vm_id] = @vm_guid

			DELETE FROM [dbo].[vm_statistics] WHERE [vm_guid]=@vm_guid
			DELETE FROM [dbo].[vm_dynamic] WHERE [vm_guid]=@vm_guid
			DELETE FROM [dbo].[vm_static] WHERE [vm_guid]=@vm_guid
			DELETE FROM [dbo].[permissions] where object_id = @vm_guid 
    END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    SET NOCOUNT OFF
END

GO


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVmsByAdGroupNames')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].GetVmsByAdGroupNames AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVmsByAdGroupNames]   
	@ad_group_names varchar(250)  
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON	
	select distinct vms.* from vms 
		inner join permissions on vms.vm_guid = permissions.object_id
		inner join ad_groups on ad_groups.id = [permissions].ad_element_id
	WHERE (dbo.ad_groups.name in (select Id from fnSplitter(@ad_group_names)))
	SET NOCOUNT OFF
END

GO

/* stateless vm sps */
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Insertstateless_vm_image_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Insertstateless_vm_image_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Insertstateless_vm_image_map]
	@image_guid uniqueidentifier,
	@internal_drive_mapping varchar(50) = NULL,
	@vm_guid uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[stateless_vm_image_map] ([image_guid], [internal_drive_mapping], [vm_guid])
	VALUES (@image_guid, @internal_drive_mapping, @vm_guid)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Updatestateless_vm_image_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Updatestateless_vm_image_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Updatestateless_vm_image_map]
    @image_guid uniqueidentifier,
	@internal_drive_mapping varchar(50) = NULL,
	@vm_guid uniqueidentifier
AS
BEGIN

	--The [dbo].[stateless_vm_image_map] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY
	UPDATE [dbo].[stateless_vm_image_map] 
	SET [internal_drive_mapping] = @internal_drive_mapping, [vm_guid] = @vm_guid
	WHERE [image_guid]=@image_guid

	IF @@ROWCOUNT = 0
	BEGIN
		RAISERROR('Concurrent update error. Updated aborted.', 16, 2)
	END
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH	

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Deletestateless_vm_image_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Deletestateless_vm_image_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Deletestateless_vm_image_map]
	 @image_guid uniqueidentifier
AS
BEGIN
	SET NOCOUNT ON
	
    DELETE FROM [dbo].[stateless_vm_image_map]
	WHERE [image_guid]=@image_guid
    
    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromstateless_vm_image_map')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromstateless_vm_image_map] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromstateless_vm_image_map]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[stateless_vm_image_map].[image_guid] AS 'image_guid',
	[stateless_vm_image_map].[internal_drive_mapping] AS 'internal_drive_mapping',
	[stateless_vm_image_map].[vm_guid] AS 'vm_guid'
FROM [dbo].[stateless_vm_image_map] [stateless_vm_image_map]

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getstateless_vm_image_mapByimage_guid')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getstateless_vm_image_mapByimage_guid] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getstateless_vm_image_mapByimage_guid] 
	@image_guid uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[stateless_vm_image_map].[image_guid] AS 'image_guid',
	[stateless_vm_image_map].[internal_drive_mapping] AS 'internal_drive_mapping',
	[stateless_vm_image_map].[vm_guid] AS 'vm_guid'
	FROM [dbo].[stateless_vm_image_map] [stateless_vm_image_map]
	WHERE [image_guid]=@image_guid

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getstateless_vm_image_mapByvm_guid')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[Getstateless_vm_image_mapByvm_guid] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[Getstateless_vm_image_mapByvm_guid] 
	@vm_guid uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[stateless_vm_image_map].[image_guid] AS 'image_guid',
	[stateless_vm_image_map].[internal_drive_mapping] AS 'internal_drive_mapping',
	[stateless_vm_image_map].[vm_guid] AS 'vm_guid'
	FROM [dbo].[stateless_vm_image_map] [stateless_vm_image_map]
	WHERE [vm_guid]=@vm_guid

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVmsDedicatedToPowerClientByVdsId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVmsDedicatedToPowerClientByVdsId] AS RETURN')
END

GO
ALTER PROCEDURE [dbo].[GetVmsDedicatedToPowerClientByVdsId]   
 @dedicated_vm_for_vds uniqueidentifier   
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
		distinct([vms].[vm_guid]) AS 'vm_guid',
		[vms].[vm_name] AS 'vm_name',
		[vms].[vm_mem_size_mb] AS 'vm_mem_size_mb',
		[vms].[vmt_guid] AS 'vmt_guid',
		[vms].[vm_os] AS 'vm_os',
		[vms].[vm_description] AS 'vm_description',
		[vms].[vds_group_id] AS 'vds_group_id',
		[vms].[vm_domain] AS 'vm_domain',
		[vms].[vm_creation_date] AS 'vm_creation_date',
		[vms].[vds_group_name] AS 'vds_group_name',
		[vms].[vds_group_description] AS 'vds_group_description',
		[vms].[vmt_name] AS 'vmt_name',
		[vms].[vmt_mem_size_mb] AS 'vmt_mem_size_mb',
		[vms].[vmt_os] AS 'vmt_os',
		[vms].[vmt_creation_date] AS 'vmt_creation_date',
		[vms].[vmt_child_count] AS 'vmt_child_count',
		[vms].[vmt_num_of_cpus] AS 'vmt_num_of_cpus',
		[vms].[vmt_num_of_sockets] AS 'vmt_num_of_sockets',
		[vms].[vmt_cpu_per_socket] AS 'vmt_cpu_per_socket',
		[vms].[vmt_description] AS 'vmt_description',
		[vms].[status] AS 'status',
		[vms].[vm_ip] AS 'vm_ip',
		[vms].[vm_host] AS 'vm_host',
		[vms].[vm_pid] AS 'vm_pid',
		[vms].[vm_last_up_time] AS 'vm_last_up_time',
		[vms].[vm_last_boot_time] AS 'vm_last_boot_time',
		[vms].[guest_cur_user_name] AS 'guest_cur_user_name',
		[vms].[guest_last_login_time] AS 'guest_last_login_time',
		[vms].[guest_cur_user_id] AS 'guest_cur_user_id',
		[vms].[guest_last_logout_time] AS 'guest_last_logout_time',
		[vms].[guest_os] AS 'guest_os',
		[vms].[cpu_user] AS 'cpu_user',
		[vms].[cpu_sys] AS 'cpu_sys',
		[vms].[elapsed_time] AS 'elapsed_time',
		[vms].[usage_network_percent] AS 'usage_network_percent',
		[vms].[usage_mem_percent] AS 'usage_mem_percent',
		[vms].[usage_cpu_percent] AS 'usage_cpu_percent',
		[vms].[run_on_vds] AS 'run_on_vds',
		[vms].[migrating_to_vds] AS 'migrating_to_vds',
		[vms].[app_list] AS 'app_list',
		[vms].[display] AS 'display',
		[vms].[vm_pool_name] AS 'vm_pool_name',
		[vms].[vm_pool_id] AS 'vm_pool_id',
		[vms].[num_of_monitors]	AS 'num_of_monitors',
		[vms].[is_initialized]  AS 'is_initialized',
		[vms].[is_auto_suspend]  AS 'is_auto_suspend',
		[vms].[num_of_cpus]	AS 'num_of_cpus',
		[vms].[num_of_sockets]	AS 'num_of_sockets',
		[vms].[cpu_per_socket]	AS 'cpu_per_socket',
		[vms].[usb_policy]	AS 'usb_policy',
		[vms].[acpi_enable]	AS 'acpi_enable',
		[vms].[session]	AS 'session',
		[vms].[display_ip] AS 'display_ip',
		[vms].[display_type] AS 'display_type',
		[vms].[kvm_enable] AS 'kvm_enable',
		[vms].[boot_sequence] AS 'boot_sequence',
		[vms].[run_on_vds_name] AS 'run_on_vds_name',
		[vms].[time_zone] AS 'time_zone',
		[vms].[display_secure_port] AS 'display_secure_port',
		[vms].[utc_diff] AS 'utc_diff',
		[vms].[auto_startup] AS 'auto_startup',
		[vms].[is_stateless] AS 'is_stateless',
		[vms].[dedicated_vm_for_vds] AS 'dedicated_vm_for_vds',
		[vms].[fail_back] as 'fail_back',
		[vms].[last_vds_run_on] as 'last_vds_run_on',
		[vms].[client_ip] as 'client_ip',
		[vms].[guest_requested_memory] as 'guest_requested_memory',
		[vms].[vds_group_cpu_name] as 'vds_group_cpu_name',
		[vms].[vm_type] as 'vm_type',
		[vms].[storage_pool_id] as 'storage_pool_id',
		[vms].[storage_pool_name] as 'storage_pool_name',
		[vms].[hypervisor_type] as 'hypervisor_type',
		[vms].[operation_mode] as 'operation_mode',
		[vms].[selection_algorithm] as 'selection_algorithm',
		[vms].[transparent_hugepages] as 'transparent_hugepages',
		[vms].[nice_level] as 'nice_level',
		[vms].[hibernation_vol_handle] as 'hibernation_vol_handle',
		[vms].[default_boot_sequence] as 'default_boot_sequence',
		[vms].[default_display_type] as 'default_display_type',
		[vms].[priority] as 'priority',
		[vms].[iso_path] as 'iso_path',
		[vms].origin as 'origin',
		[vms].[vds_group_compatibility_version] as 'vds_group_compatibility_version',
		[vms].[initrd_url] as 'initrd_url',
		[vms].[kernel_url] as 'kernel_url',
		[vms].[kernel_params] as 'kernel_params',
		[vms].[exit_status] as 'exit_status',
		[vms].[pause_status] as 'pause_status',
		[vms].[exit_message] as 'exit_message',
		[vms].[migration_support] as 'migration_support',
		[vms].[predefined_properties] as 'predefined_properties',
		[vms].[userdefined_properties] as 'userdefined_properties',
		[vms].[min_allocated_mem] as 'min_allocated_mem'

FROM [dbo].[vms] inner join
	[dbo].[vds_static] on [dbo].[vms].[dedicated_vm_for_vds] = [dbo].[vds_static].[vds_id]
		WHERE [dbo].[vms].[dedicated_vm_for_vds]=@dedicated_vm_for_vds
		and [dbo].[vds_static].[vds_type]=1
	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVmByImageId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVmByImageId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVmByImageId] 
	@image_guid uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		distinct([vms].[vm_guid]) AS 'vm_guid',
		[vms].[vm_name] AS 'vm_name',
		[vms].[vm_mem_size_mb] AS 'vm_mem_size_mb',
		[vms].[vmt_guid] AS 'vmt_guid',
		[vms].[vm_os] AS 'vm_os',
		[vms].[vm_description] AS 'vm_description',
		[vms].[vds_group_id] AS 'vds_group_id',
		[vms].[vm_domain] AS 'vm_domain',
		[vms].[vm_creation_date] AS 'vm_creation_date',
		[vms].[vds_group_name] AS 'vds_group_name',
		[vms].[vds_group_description] AS 'vds_group_description',
		[vms].[vmt_name] AS 'vmt_name',
		[vms].[vmt_mem_size_mb] AS 'vmt_mem_size_mb',
		[vms].[vmt_os] AS 'vmt_os',
		[vms].[vmt_creation_date] AS 'vmt_creation_date',
		[vms].[vmt_child_count] AS 'vmt_child_count',
		[vms].[vmt_num_of_cpus] AS 'vmt_num_of_cpus',
		[vms].[vmt_num_of_sockets] AS 'vmt_num_of_sockets',
		[vms].[vmt_cpu_per_socket] AS 'vmt_cpu_per_socket',
		[vms].[vmt_description] AS 'vmt_description',
		[vms].[status] AS 'status',
		[vms].[vm_ip] AS 'vm_ip',
		[vms].[vm_host] AS 'vm_host',
		[vms].[vm_pid] AS 'vm_pid',
		[vms].[vm_last_up_time] AS 'vm_last_up_time',
		[vms].[vm_last_boot_time] AS 'vm_last_boot_time',
		[vms].[guest_cur_user_name] AS 'guest_cur_user_name',
		[vms].[guest_last_login_time] AS 'guest_last_login_time',
		[vms].[guest_cur_user_id] AS 'guest_cur_user_id',
		[vms].[guest_last_logout_time] AS 'guest_last_logout_time',
		[vms].[guest_os] AS 'guest_os',
		[vms].[cpu_user] AS 'cpu_user',
		[vms].[cpu_sys] AS 'cpu_sys',
		[vms].[elapsed_time] AS 'elapsed_time',
		[vms].[usage_network_percent] AS 'usage_network_percent',
		[vms].[usage_mem_percent] AS 'usage_mem_percent',
		[vms].[usage_cpu_percent] AS 'usage_cpu_percent',
		[vms].[run_on_vds] AS 'run_on_vds',
		[vms].[migrating_to_vds] AS 'migrating_to_vds',
		[vms].[app_list] AS 'app_list',
		[vms].[display] AS 'display',
		[vms].[vm_pool_name] AS 'vm_pool_name',
		[vms].[vm_pool_id] AS 'vm_pool_id',
		[vms].[num_of_monitors]	AS 'num_of_monitors',
		[vms].[is_initialized]  AS 'is_initialized',
		[vms].[is_auto_suspend]  AS 'is_auto_suspend',
		[vms].[num_of_cpus]	AS 'num_of_cpus',
		[vms].[num_of_sockets]	AS 'num_of_sockets',
		[vms].[cpu_per_socket]	AS 'cpu_per_socket',
		[vms].[usb_policy]	AS 'usb_policy',
		[vms].[acpi_enable]	AS 'acpi_enable',
		[vms].[session]	AS 'session',
		[vms].[display_ip] AS 'display_ip',
		[vms].[display_type] AS 'display_type',
		[vms].[kvm_enable] AS 'kvm_enable',
		[vms].[boot_sequence] AS 'boot_sequence',
		[vms].[run_on_vds_name] AS 'run_on_vds_name',
		[vms].[time_zone] AS 'time_zone',
		[vms].[display_secure_port] AS 'display_secure_port',
		[vms].[utc_diff] AS 'utc_diff',
		[vms].[auto_startup] AS 'auto_startup',
		[vms].[is_stateless] AS 'is_stateless',
		[vms].[dedicated_vm_for_vds] AS 'dedicated_vm_for_vds',
		[vms].[fail_back] as 'fail_back',
		[vms].[last_vds_run_on] as 'last_vds_run_on',
		[vms].[client_ip] as 'client_ip',
		[vms].[guest_requested_memory] as 'guest_requested_memory',
		[vms].[vds_group_cpu_name] as 'vds_group_cpu_name',
		[vms].[vm_type] as 'vm_type',
		[vms].[storage_pool_id] as 'storage_pool_id',
		[vms].[storage_pool_name] as 'storage_pool_name',
		[vms].[hypervisor_type] as 'hypervisor_type',
		[vms].[operation_mode] as 'operation_mode',
 		[vms].[selection_algorithm] as 'selection_algorithm',
		[vms].[transparent_hugepages] as 'transparent_hugepages',
		[vms].[nice_level] as 'nice_level',
		[vms].[hibernation_vol_handle] as 'hibernation_vol_handle',
		[vms].[default_boot_sequence] as 'default_boot_sequence',
		[vms].[default_display_type] as 'default_display_type',
		[vms].[priority] as 'priority',
		[vms].[iso_path] as 'iso_path',
		[vms].origin as 'origin',
		[vms].[vds_group_compatibility_version] as 'vds_group_compatibility_version',
		[vms].[initrd_url] as 'initrd_url',
		[vms].[kernel_url] as 'kernel_url',
		[vms].[kernel_params] as 'kernel_params',
		[vms].[exit_status] as 'exit_status',
		[vms].[pause_status] as 'pause_status',
		[vms].[exit_message] as 'exit_message',
		[vms].[migration_support] as 'migration_support',
		[vms].[predefined_properties] as 'predefined_properties',
		[vms].[userdefined_properties] as 'userdefined_properties',
		[vms].[min_allocated_mem] as 'min_allocated_mem'
		FROM [dbo].[vms] [vms]
		inner join [image_vm_map] on [vms].[vm_guid] = [image_vm_map].[vm_id]
		WHERE [image_vm_map].[image_id]=@image_guid
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVmByImageGroupId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVmByImageGroupId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVmByImageGroupId] 
	@image_group_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		distinct([vms].[vm_guid]) AS 'vm_guid',
		[vms].[vm_name] AS 'vm_name',
		[vms].[vm_mem_size_mb] AS 'vm_mem_size_mb',
		[vms].[vmt_guid] AS 'vmt_guid',
		[vms].[vm_os] AS 'vm_os',
		[vms].[vm_description] AS 'vm_description',
		[vms].[vds_group_id] AS 'vds_group_id',
		[vms].[vm_domain] AS 'vm_domain',
		[vms].[vm_creation_date] AS 'vm_creation_date',
		[vms].[vds_group_name] AS 'vds_group_name',
		[vms].[vds_group_description] AS 'vds_group_description',
		[vms].[vmt_name] AS 'vmt_name',
		[vms].[vmt_mem_size_mb] AS 'vmt_mem_size_mb',
		[vms].[vmt_os] AS 'vmt_os',
		[vms].[vmt_creation_date] AS 'vmt_creation_date',
		[vms].[vmt_child_count] AS 'vmt_child_count',
		[vms].[vmt_num_of_cpus] AS 'vmt_num_of_cpus',
		[vms].[vmt_num_of_sockets] AS 'vmt_num_of_sockets',
		[vms].[vmt_cpu_per_socket] AS 'vmt_cpu_per_socket',
		[vms].[vmt_description] AS 'vmt_description',
		[vms].[status] AS 'status',
		[vms].[vm_ip] AS 'vm_ip',
		[vms].[vm_host] AS 'vm_host',
		[vms].[vm_pid] AS 'vm_pid',
		[vms].[vm_last_up_time] AS 'vm_last_up_time',
		[vms].[vm_last_boot_time] AS 'vm_last_boot_time',
		[vms].[guest_cur_user_name] AS 'guest_cur_user_name',
		[vms].[guest_last_login_time] AS 'guest_last_login_time',
		[vms].[guest_cur_user_id] AS 'guest_cur_user_id',
		[vms].[guest_last_logout_time] AS 'guest_last_logout_time',
		[vms].[guest_os] AS 'guest_os',
		[vms].[cpu_user] AS 'cpu_user',
		[vms].[cpu_sys] AS 'cpu_sys',
		[vms].[elapsed_time] AS 'elapsed_time',
		[vms].[usage_network_percent] AS 'usage_network_percent',
		[vms].[usage_mem_percent] AS 'usage_mem_percent',
		[vms].[usage_cpu_percent] AS 'usage_cpu_percent',
		[vms].[run_on_vds] AS 'run_on_vds',
		[vms].[migrating_to_vds] AS 'migrating_to_vds',
		[vms].[app_list] AS 'app_list',
		[vms].[display] AS 'display',
		[vms].[vm_pool_name] AS 'vm_pool_name',
		[vms].[vm_pool_id] AS 'vm_pool_id',
		[vms].[num_of_monitors]	AS 'num_of_monitors',
		[vms].[is_initialized]  AS 'is_initialized',
		[vms].[is_auto_suspend]  AS 'is_auto_suspend',
		[vms].[num_of_cpus]	AS 'num_of_cpus',
		[vms].[num_of_sockets]	AS 'num_of_sockets',
		[vms].[cpu_per_socket]	AS 'cpu_per_socket',
		[vms].[usb_policy]	AS 'usb_policy',
		[vms].[acpi_enable]	AS 'acpi_enable',
		[vms].[session]	AS 'session',
		[vms].[display_ip] AS 'display_ip',
		[vms].[display_type] AS 'display_type',
		[vms].[kvm_enable] AS 'kvm_enable',
		[vms].[boot_sequence] AS 'boot_sequence',
		[vms].[run_on_vds_name] AS 'run_on_vds_name',
		[vms].[time_zone] AS 'time_zone',
		[vms].[display_secure_port] AS 'display_secure_port',
		[vms].[utc_diff] AS 'utc_diff',
		[vms].[auto_startup] AS 'auto_startup',
		[vms].[is_stateless] AS 'is_stateless',
		[vms].[dedicated_vm_for_vds] AS 'dedicated_vm_for_vds',
		[vms].[fail_back] as 'fail_back',
		[vms].[last_vds_run_on] as 'last_vds_run_on',
		[vms].[client_ip] as 'client_ip',
		[vms].[guest_requested_memory] as 'guest_requested_memory',
		[vms].[vds_group_cpu_name] as 'vds_group_cpu_name',
		[vms].[vm_type] as 'vm_type',
		[vms].[storage_pool_id] as 'storage_pool_id',
		[vms].[storage_pool_name] as 'storage_pool_name',
		[vms].[hypervisor_type] as 'hypervisor_type',
		[vms].[operation_mode] as 'operation_mode',
		[vms].[selection_algorithm] as 'selection_algorithm',
		[vms].[transparent_hugepages] as 'transparent_hugepages',
		[vms].[nice_level] as 'nice_level',
		[vms].[hibernation_vol_handle] as 'hibernation_vol_handle',
		[vms].[default_boot_sequence] as 'default_boot_sequence',
		[vms].[default_display_type] as 'default_display_type',
		[vms].[priority] as 'priority',
		[vms].[iso_path] as 'iso_path',
		[vms].origin as 'origin',
		[vms].[vds_group_compatibility_version] as 'vds_group_compatibility_version',
		[vms].[initrd_url] as 'initrd_url',
		[vms].[kernel_url] as 'kernel_url',
		[vms].[kernel_params] as 'kernel_params',
		[vms].[exit_status] as 'exit_status',
		[vms].[pause_status] as 'pause_status',
		[vms].[exit_message] as 'exit_message',
		[vms].[migration_support] as 'migration_support',
		[vms].[predefined_properties] as 'predefined_properties',
		[vms].[userdefined_properties] as 'userdefined_properties',
		[vms].[min_allocated_mem] as 'min_allocated_mem'
		FROM [dbo].[vms] [vms]
		inner join image_vm_map on vms.vm_guid = image_vm_map.vm_id
		inner join images on image_vm_map.image_id = images.image_guid
					and images.image_guid in (select image_guid 
								from images where image_group_id = @image_group_id)
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVmByHibernationImageId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVmByHibernationImageId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVmByHibernationImageId] 
	@image_id varchar(max)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		distinct([vms].[vm_guid]) AS 'vm_guid',
		[vms].[vm_name] AS 'vm_name',
		[vms].[vm_mem_size_mb] AS 'vm_mem_size_mb',
		[vms].[vmt_guid] AS 'vmt_guid',
		[vms].[vm_os] AS 'vm_os',
		[vms].[vm_description] AS 'vm_description',
		[vms].[vds_group_id] AS 'vds_group_id',
		[vms].[vm_domain] AS 'vm_domain',
		[vms].[vm_creation_date] AS 'vm_creation_date',
		[vms].[vds_group_name] AS 'vds_group_name',
		[vms].[vds_group_description] AS 'vds_group_description',
		[vms].[vmt_name] AS 'vmt_name',
		[vms].[vmt_mem_size_mb] AS 'vmt_mem_size_mb',
		[vms].[vmt_os] AS 'vmt_os',
		[vms].[vmt_creation_date] AS 'vmt_creation_date',
		[vms].[vmt_child_count] AS 'vmt_child_count',
		[vms].[vmt_num_of_cpus] AS 'vmt_num_of_cpus',
		[vms].[vmt_num_of_sockets] AS 'vmt_num_of_sockets',
		[vms].[vmt_cpu_per_socket] AS 'vmt_cpu_per_socket',
		[vms].[vmt_description] AS 'vmt_description',
		[vms].[status] AS 'status',
		[vms].[vm_ip] AS 'vm_ip',
		[vms].[vm_host] AS 'vm_host',
		[vms].[vm_pid] AS 'vm_pid',
		[vms].[vm_last_up_time] AS 'vm_last_up_time',
		[vms].[vm_last_boot_time] AS 'vm_last_boot_time',
		[vms].[guest_cur_user_name] AS 'guest_cur_user_name',
		[vms].[guest_last_login_time] AS 'guest_last_login_time',
		[vms].[guest_cur_user_id] AS 'guest_cur_user_id',
		[vms].[guest_last_logout_time] AS 'guest_last_logout_time',
		[vms].[guest_os] AS 'guest_os',
		[vms].[cpu_user] AS 'cpu_user',
		[vms].[cpu_sys] AS 'cpu_sys',
		[vms].[elapsed_time] AS 'elapsed_time',
		[vms].[usage_network_percent] AS 'usage_network_percent',
		[vms].[usage_mem_percent] AS 'usage_mem_percent',
		[vms].[usage_cpu_percent] AS 'usage_cpu_percent',
		[vms].[run_on_vds] AS 'run_on_vds',
		[vms].[migrating_to_vds] AS 'migrating_to_vds',
		[vms].[app_list] AS 'app_list',
		[vms].[display] AS 'display',
		[vms].[vm_pool_name] AS 'vm_pool_name',
		[vms].[vm_pool_id] AS 'vm_pool_id',
		[vms].[num_of_monitors]	AS 'num_of_monitors',
		[vms].[is_initialized]  AS 'is_initialized',
		[vms].[is_auto_suspend]  AS 'is_auto_suspend',
		[vms].[num_of_cpus]	AS 'num_of_cpus',
		[vms].[num_of_sockets]	AS 'num_of_sockets',
		[vms].[cpu_per_socket]	AS 'cpu_per_socket',
		[vms].[usb_policy]	AS 'usb_policy',
		[vms].[acpi_enable]	AS 'acpi_enable',
		[vms].[session]	AS 'session',
		[vms].[display_ip] AS 'display_ip',
		[vms].[display_type] AS 'display_type',
		[vms].[kvm_enable] AS 'kvm_enable',
		[vms].[boot_sequence] AS 'boot_sequence',
		[vms].[run_on_vds_name] AS 'run_on_vds_name',
		[vms].[time_zone] AS 'time_zone',
		[vms].[display_secure_port] AS 'display_secure_port',
		[vms].[utc_diff] AS 'utc_diff',
		[vms].[auto_startup] AS 'auto_startup',
		[vms].[is_stateless] AS 'is_stateless',
		[vms].[dedicated_vm_for_vds] AS 'dedicated_vm_for_vds',
		[vms].[fail_back] as 'fail_back',
		[vms].[last_vds_run_on] as 'last_vds_run_on',
		[vms].[client_ip] as 'client_ip',
		[vms].[guest_requested_memory] as 'guest_requested_memory',
		[vms].[vds_group_cpu_name] as 'vds_group_cpu_name',
		[vms].[vm_type] as 'vm_type',
		[vms].[storage_pool_id] as 'storage_pool_id',
		[vms].[storage_pool_name] as 'storage_pool_name',
		[vms].[hypervisor_type] as 'hypervisor_type',
		[vms].[operation_mode] as 'operation_mode',
		[vms].[selection_algorithm] as 'selection_algorithm',
		[vms].[transparent_hugepages] as 'transparent_hugepages',
		[vms].[nice_level] as 'nice_level',
		[vms].[hibernation_vol_handle] as 'hibernation_vol_handle',
		[vms].[default_boot_sequence] as 'default_boot_sequence',
		[vms].[default_display_type] as 'default_display_type',
		[vms].[priority] as 'priority',
		[vms].[iso_path] as 'iso_path',
		[vms].origin as 'origin',
		[vms].[vds_group_compatibility_version] as 'vds_group_compatibility_version',
		[vms].[initrd_url] as 'initrd_url',
		[vms].[kernel_url] as 'kernel_url',
		[vms].[kernel_params] as 'kernel_params',
		[vms].[exit_status] as 'exit_status',
		[vms].[pause_status] as 'pause_status',
		[vms].[exit_message] as 'exit_message',
		[vms].[migration_support] as 'migration_support',
		[vms].[predefined_properties] as 'predefined_properties',
		[vms].[userdefined_properties] as 'userdefined_properties',
		[vms].[min_allocated_mem] as 'min_allocated_mem'

		FROM [dbo].[vms] [vms]
		WHERE [hibernation_vol_handle] like '%' + @image_id + '%'
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetRunningVmsByStorageDomainId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetRunningVmsByStorageDomainId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetRunningVmsByStorageDomainId] 
	@storage_domain_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		distinct([vms].[vm_guid]) AS 'vm_guid',
		[vms].[vm_name] AS 'vm_name',
		[vms].[vm_mem_size_mb] AS 'vm_mem_size_mb',
		[vms].[vmt_guid] AS 'vmt_guid',
		[vms].[vm_os] AS 'vm_os',
		[vms].[vm_description] AS 'vm_description',
		[vms].[vds_group_id] AS 'vds_group_id',
		[vms].[vm_domain] AS 'vm_domain',
		[vms].[vm_creation_date] AS 'vm_creation_date',
		[vms].[vds_group_name] AS 'vds_group_name',
		[vms].[vds_group_description] AS 'vds_group_description',
		[vms].[vmt_name] AS 'vmt_name',
		[vms].[vmt_mem_size_mb] AS 'vmt_mem_size_mb',
		[vms].[vmt_os] AS 'vmt_os',
		[vms].[vmt_creation_date] AS 'vmt_creation_date',
		[vms].[vmt_child_count] AS 'vmt_child_count',
		[vms].[vmt_num_of_cpus] AS 'vmt_num_of_cpus',
		[vms].[vmt_num_of_sockets] AS 'vmt_num_of_sockets',
		[vms].[vmt_cpu_per_socket] AS 'vmt_cpu_per_socket',
		[vms].[vmt_description] AS 'vmt_description',
		[vms].[status] AS 'status',
		[vms].[vm_ip] AS 'vm_ip',
		[vms].[vm_host] AS 'vm_host',
		[vms].[vm_pid] AS 'vm_pid',
		[vms].[vm_last_up_time] AS 'vm_last_up_time',
		[vms].[vm_last_boot_time] AS 'vm_last_boot_time',
		[vms].[guest_cur_user_name] AS 'guest_cur_user_name',
		[vms].[guest_last_login_time] AS 'guest_last_login_time',
		[vms].[guest_cur_user_id] AS 'guest_cur_user_id',
		[vms].[guest_last_logout_time] AS 'guest_last_logout_time',
		[vms].[guest_os] AS 'guest_os',
		[vms].[cpu_user] AS 'cpu_user',
		[vms].[cpu_sys] AS 'cpu_sys',
		[vms].[elapsed_time] AS 'elapsed_time',
		[vms].[usage_network_percent] AS 'usage_network_percent',
		[vms].[usage_mem_percent] AS 'usage_mem_percent',
		[vms].[usage_cpu_percent] AS 'usage_cpu_percent',
		[vms].[run_on_vds] AS 'run_on_vds',
		[vms].[migrating_to_vds] AS 'migrating_to_vds',
		[vms].[app_list] AS 'app_list',
		[vms].[display] AS 'display',
		[vms].[vm_pool_name] AS 'vm_pool_name',
		[vms].[vm_pool_id] AS 'vm_pool_id',
		[vms].[num_of_monitors]	AS 'num_of_monitors',
		[vms].[is_initialized]  AS 'is_initialized',
		[vms].[is_auto_suspend]  AS 'is_auto_suspend',
		[vms].[num_of_cpus]	AS 'num_of_cpus',
		[vms].[num_of_sockets]	AS 'num_of_sockets',
		[vms].[cpu_per_socket]	AS 'cpu_per_socket',
		[vms].[usb_policy]	AS 'usb_policy',
		[vms].[acpi_enable]	AS 'acpi_enable',
		[vms].[session]	AS 'session',
		[vms].[display_ip] AS 'display_ip',
		[vms].[display_type] AS 'display_type',
		[vms].[kvm_enable] AS 'kvm_enable',
		[vms].[boot_sequence] AS 'boot_sequence',
		[vms].[run_on_vds_name] AS 'run_on_vds_name',
		[vms].[time_zone] AS 'time_zone',
		[vms].[display_secure_port] AS 'display_secure_port',
		[vms].[utc_diff] AS 'utc_diff',
		[vms].[auto_startup] AS 'auto_startup',
		[vms].[is_stateless] AS 'is_stateless',
		[vms].[dedicated_vm_for_vds] AS 'dedicated_vm_for_vds',
		[vms].[fail_back] as 'fail_back',
		[vms].[last_vds_run_on] as 'last_vds_run_on',
		[vms].[client_ip] as 'client_ip',
		[vms].[guest_requested_memory] as 'guest_requested_memory',
		[vms].[vds_group_cpu_name] as 'vds_group_cpu_name',
		[vms].[vm_type] as 'vm_type',
		[vms].[storage_pool_id] as 'storage_pool_id',
		[vms].[storage_pool_name] as 'storage_pool_name',
		[vms].[hypervisor_type] as 'hypervisor_type',
		[vms].[operation_mode] as 'operation_mode',
		[vms].[selection_algorithm] as 'selection_algorithm',
		[vms].[transparent_hugepages] as 'transparent_hugepages',
		[vms].[nice_level] as 'nice_level',
		[vms].[hibernation_vol_handle] as 'hibernation_vol_handle',
		[vms].[default_boot_sequence] as 'default_boot_sequence',
		[vms].[default_display_type] as 'default_display_type',
		[vms].[priority] as 'priority',
		[vms].[iso_path] as 'iso_path',
		[vms].origin as 'origin',
		[vms].[vds_group_compatibility_version] as 'vds_group_compatibility_version',
		[vms].[initrd_url] as 'initrd_url',
		[vms].[kernel_url] as 'kernel_url',
		[vms].[kernel_params] as 'kernel_params',
		[vms].[exit_status] as 'exit_status',
		[vms].[pause_status] as 'pause_status',
		[vms].[exit_message] as 'exit_message',
		[vms].[migration_support] as 'migration_support',
		[vms].[predefined_properties] as 'predefined_properties',
		[vms].[userdefined_properties] as 'userdefined_properties',
		[vms].[min_allocated_mem] as 'min_allocated_mem'

		FROM [dbo].[vms] [vms]
		inner join image_vm_map on vms.vm_guid = image_vm_map.vm_id
		inner join images on image_vm_map.image_id = images.image_guid
					and images.image_guid in (select image_guid 
								from images where storage_id = @storage_domain_id)
		WHERE [status] <> 0
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVmsByStorageDomainId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVmsByStorageDomainId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVmsByStorageDomainId] 
	@storage_domain_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		distinct([vms].[vm_guid]) AS 'vm_guid',
		[vms].[vm_name] AS 'vm_name',
		[vms].[vm_mem_size_mb] AS 'vm_mem_size_mb',
		[vms].[vmt_guid] AS 'vmt_guid',
		[vms].[vm_os] AS 'vm_os',
		[vms].[vm_description] AS 'vm_description',
		[vms].[vds_group_id] AS 'vds_group_id',
		[vms].[vm_domain] AS 'vm_domain',
		[vms].[vm_creation_date] AS 'vm_creation_date',
		[vms].[vds_group_name] AS 'vds_group_name',
		[vms].[vds_group_description] AS 'vds_group_description',
		[vms].[vmt_name] AS 'vmt_name',
		[vms].[vmt_mem_size_mb] AS 'vmt_mem_size_mb',
		[vms].[vmt_os] AS 'vmt_os',
		[vms].[vmt_creation_date] AS 'vmt_creation_date',
		[vms].[vmt_child_count] AS 'vmt_child_count',
		[vms].[vmt_num_of_cpus] AS 'vmt_num_of_cpus',
		[vms].[vmt_num_of_sockets] AS 'vmt_num_of_sockets',
		[vms].[vmt_cpu_per_socket] AS 'vmt_cpu_per_socket',
		[vms].[vmt_description] AS 'vmt_description',
		[vms].[status] AS 'status',
		[vms].[vm_ip] AS 'vm_ip',
		[vms].[vm_host] AS 'vm_host',
		[vms].[vm_pid] AS 'vm_pid',
		[vms].[vm_last_up_time] AS 'vm_last_up_time',
		[vms].[vm_last_boot_time] AS 'vm_last_boot_time',
		[vms].[guest_cur_user_name] AS 'guest_cur_user_name',
		[vms].[guest_last_login_time] AS 'guest_last_login_time',
		[vms].[guest_cur_user_id] AS 'guest_cur_user_id',
		[vms].[guest_last_logout_time] AS 'guest_last_logout_time',
		[vms].[guest_os] AS 'guest_os',
		[vms].[cpu_user] AS 'cpu_user',
		[vms].[cpu_sys] AS 'cpu_sys',
		[vms].[elapsed_time] AS 'elapsed_time',
		[vms].[usage_network_percent] AS 'usage_network_percent',
		[vms].[usage_mem_percent] AS 'usage_mem_percent',
		[vms].[usage_cpu_percent] AS 'usage_cpu_percent',
		[vms].[run_on_vds] AS 'run_on_vds',
		[vms].[migrating_to_vds] AS 'migrating_to_vds',
		[vms].[app_list] AS 'app_list',
		[vms].[display] AS 'display',
		[vms].[vm_pool_name] AS 'vm_pool_name',
		[vms].[vm_pool_id] AS 'vm_pool_id',
		[vms].[num_of_monitors]	AS 'num_of_monitors',
		[vms].[is_initialized]  AS 'is_initialized',
		[vms].[is_auto_suspend]  AS 'is_auto_suspend',
		[vms].[num_of_cpus]	AS 'num_of_cpus',
		[vms].[num_of_sockets]	AS 'num_of_sockets',
		[vms].[cpu_per_socket]	AS 'cpu_per_socket',
		[vms].[usb_policy]	AS 'usb_policy',
		[vms].[acpi_enable]	AS 'acpi_enable',
		[vms].[session]	AS 'session',
		[vms].[display_ip] AS 'display_ip',
		[vms].[display_type] AS 'display_type',
		[vms].[kvm_enable] AS 'kvm_enable',
		[vms].[boot_sequence] AS 'boot_sequence',
		[vms].[run_on_vds_name] AS 'run_on_vds_name',
		[vms].[time_zone] AS 'time_zone',
		[vms].[display_secure_port] AS 'display_secure_port',
		[vms].[utc_diff] AS 'utc_diff',
		[vms].[auto_startup] AS 'auto_startup',
		[vms].[is_stateless] AS 'is_stateless',
		[vms].[dedicated_vm_for_vds] AS 'dedicated_vm_for_vds',
		[vms].[fail_back] as 'fail_back',
		[vms].[last_vds_run_on] as 'last_vds_run_on',
		[vms].[client_ip] as 'client_ip',
		[vms].[guest_requested_memory] as 'guest_requested_memory',
		[vms].[vds_group_cpu_name] as 'vds_group_cpu_name',
		[vms].[vm_type] as 'vm_type',
		[vms].[storage_pool_id] as 'storage_pool_id', 
		[vms].[storage_pool_name] as 'storage_pool_name',
		[vms].[hypervisor_type] as 'hypervisor_type',
		[vms].[operation_mode] as 'operation_mode',
		[vms].[selection_algorithm] as 'selection_algorithm',
		[vms].[transparent_hugepages] as 'transparent_hugepages',
		[vms].[nice_level] as 'nice_level',
		[vms].[hibernation_vol_handle] as 'hibernation_vol_handle',
		[vms].[default_boot_sequence] as 'default_boot_sequence',
		[vms].[default_display_type] as 'default_display_type',
		[vms].[iso_path] as 'iso_path',
		[vms].[origin] as 'origin',
		[vms].[priority] as 'priority',
		[vms].[vds_group_compatibility_version] as 'vds_group_compatibility_version',
		[vms].[initrd_url] as 'initrd_url',
		[vms].[kernel_url] as 'kernel_url',
		[vms].[kernel_params] as 'kernel_params',
		[vms].[exit_status] as 'exit_status',
		[vms].[pause_status] as 'pause_status',
		[vms].[exit_message] as 'exit_message',
		[vms].[migration_support] as 'migration_support',
		[vms].[predefined_properties] as 'predefined_properties',
		[vms].[userdefined_properties] as 'userdefined_properties',
		[vms].[min_allocated_mem] as 'min_allocated_mem'

		FROM [dbo].[vms] [vms]
			inner join image_vm_map on vms.vm_guid = image_vm_map.vm_id
			inner join images on image_vm_map.image_id = images.image_guid
				and images.image_guid in (select image_guid 
							from images where storage_id = @storage_domain_id)
		
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'UpdateIsInitialized')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[UpdateIsInitialized] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[UpdateIsInitialized]
 @vm_guid uniqueidentifier,
 @is_initialized bit
AS
BEGIN

	--The [dbo].[vm_static] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY
	UPDATE [dbo].[vm_static] 
	SET [is_initialized]= @is_initialized
	WHERE [vm_guid]=@vm_guid

	IF @@ROWCOUNT = 0
	BEGIN
		RAISERROR('Concurrent update error. Updated aborted.', 16, 2)
	END
	END TRY

	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetOrderedVmGuidsForRunMultipleActions')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetOrderedVmGuidsForRunMultipleActions] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetOrderedVmGuidsForRunMultipleActions] 
	@vm_guids varchar(max)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	declare @statement nvarchar(max)
	set @statement = 'SELECT vm_guid from [vm_static] where vm_guid in (' + @vm_guids + ') order by [migration_support] desc,[auto_startup] desc, [priority] desc'
	exec sp_executesql @statement
	
	SET NOCOUNT OFF
END

GO
