
----------------------------------------------------------------
-- [dbo].[vds_statistics] Table
--

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'InsertVdsStatistics')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[InsertVdsStatistics] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[InsertVdsStatistics]
 @cpu_idle decimal(18,0) = NULL,  
 @cpu_load decimal(18,0) = NULL,  
 @cpu_sys decimal(18,0) = NULL,  
 @cpu_user decimal(18,0) = NULL,  
 @usage_cpu_percent int = NULL,  
 @usage_mem_percent int = NULL,  
 @usage_network_percent int = NULL,  
 @vds_id uniqueidentifier,  
 @mem_available BIGINT = NULL,  
 @mem_shared BIGINT = NULL,  
    @swap_free BIGINT = NULL,  
 @swap_total BIGINT = NULL,   
 @ksm_cpu_percent int = NULL,  
 @ksm_pages BIGINT = NULL,  
 @ksm_state bit = NULL  
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[vds_statistics] ([cpu_idle], [cpu_load], [cpu_sys], [cpu_user], [usage_cpu_percent], [usage_mem_percent], [usage_network_percent], [vds_id], [mem_available], [mem_shared],[swap_free],[swap_total],[ksm_cpu_percent],[ksm_pages],[ksm_state])
	VALUES (@cpu_idle, @cpu_load, @cpu_sys, @cpu_user, @usage_cpu_percent, @usage_mem_percent, @usage_network_percent, @vds_id, @mem_available, @mem_shared,@swap_free,@swap_total,@ksm_cpu_percent,@ksm_pages,@ksm_state)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'UpdateVdsStatistics')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[UpdateVdsStatistics] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[UpdateVdsStatistics]
 @cpu_idle decimal(18,0) = NULL,  
 @cpu_load decimal(18,0) = NULL,  
 @cpu_sys decimal(18,0) = NULL,  
 @cpu_user decimal(18,0) = NULL,  
 @usage_cpu_percent int = NULL,  
 @usage_mem_percent int = NULL,  
 @usage_network_percent int = NULL,  
 @vds_id uniqueidentifier,  
 @mem_available BIGINT = NULL,  
 @mem_shared BIGINT = NULL,  
    @swap_free BIGINT = NULL,  
 @swap_total BIGINT = NULL,  
 @ksm_cpu_percent int = NULL,  
 @ksm_pages BIGINT = NULL,  
 @ksm_state bit = NULL  
AS
BEGIN

	--The [dbo].[vds_dynamic] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY
	UPDATE [dbo].[vds_statistics] 
	SET [cpu_idle] = @cpu_idle, [cpu_load] = @cpu_load, [cpu_sys] = @cpu_sys, [cpu_user] = @cpu_user, [usage_cpu_percent] = @usage_cpu_percent, [usage_mem_percent] = @usage_mem_percent, [usage_network_percent] = @usage_network_percent, [mem_available] = @mem_available, [mem_shared] = @mem_shared,
        [swap_free] = @swap_free, [swap_total] = @swap_total, [ksm_cpu_percent] = @ksm_cpu_percent, [ksm_pages] = @ksm_pages, [ksm_state] = @ksm_state
	WHERE [vds_id]=@vds_id

	IF @@ROWCOUNT = 0
	BEGIN
		RAISERROR('Update statement affected 0 rows.', 16, 2)
	END
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH	

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'DeleteVdsStatistics')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[DeleteVdsStatistics] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[DeleteVdsStatistics]
  @vds_id uniqueidentifier  
AS
BEGIN
	SET NOCOUNT ON
	BEGIN TRY
		DELETE FROM [dbo].[vds_statistics]
		WHERE [vds_id]=@vds_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromVdsStatistics')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromVdsStatistics] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromVdsStatistics]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[vds_statistics].[cpu_idle] AS 'cpu_idle',
		[vds_statistics].[cpu_load] AS 'cpu_load',
		[vds_statistics].[cpu_sys] AS 'cpu_sys',
		[vds_statistics].[cpu_user] AS 'cpu_user',
		[vds_statistics].[usage_cpu_percent] AS 'usage_cpu_percent',
		[vds_statistics].[usage_mem_percent] AS 'usage_mem_percent',
		[vds_statistics].[usage_network_percent] AS 'usage_network_percent',
		[vds_statistics].[vds_id] AS 'vds_id',
		[vds_statistics].[mem_available] AS 'mem_available',
		[vds_statistics].[mem_shared] AS 'mem_shared',
		[vds_statistics].[swap_free] AS 'swap_free',
		[vds_statistics].[swap_total] AS 'swap_total',
		[vds_statistics].[ksm_cpu_percent] AS 'ksm_cpu_percent',
		[vds_statistics].[ksm_pages] AS 'ksm_pages',
		[vds_statistics].[ksm_state] AS 'ksm_state'
		FROM [dbo].[vds_statistics] [vds_statistics]
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH
	

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVdsStatisticsByVdsId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVdsStatisticsByVdsId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVdsStatisticsByVdsId] 
 @vds_id uniqueidentifier  
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[vds_statistics].[cpu_idle] AS 'cpu_idle',
		[vds_statistics].[cpu_load] AS 'cpu_load',
		[vds_statistics].[cpu_sys] AS 'cpu_sys',
		[vds_statistics].[cpu_user] AS 'cpu_user',
		[vds_statistics].[usage_cpu_percent] AS 'usage_cpu_percent',
		[vds_statistics].[usage_mem_percent] AS 'usage_mem_percent',
		[vds_statistics].[usage_network_percent] AS 'usage_network_percent',
		[vds_statistics].[vds_id] AS 'vds_id',
		[vds_statistics].[mem_available] AS 'mem_available',
		[vds_statistics].[mem_shared] AS 'mem_shared',
		[vds_statistics].[swap_free] AS 'swap_free',
		[vds_statistics].[swap_total] AS 'swap_total',
		[vds_statistics].[ksm_cpu_percent] AS 'ksm_cpu_percent',
		[vds_statistics].[ksm_pages] AS 'ksm_pages',
		[vds_statistics].[ksm_state] AS 'ksm_state'

		FROM [dbo].[vds_statistics] [vds_statistics]
		WHERE [vds_id]=@vds_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO


----------------------------------------------------------------
-- [dbo].[vds_dynamic] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'InsertVdsDynamic')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[InsertVdsDynamic] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[InsertVdsDynamic]
    @cpu_cores int = NULL,  
 @cpu_model nvarchar(255) = NULL,  
 @cpu_speed_mh decimal(18,0) = NULL,  
 @if_total_speed nvarchar(40) = NULL,  
 @kvm_enabled bit = NULL,  
 @mem_commited int = NULL,  
 @physical_mem_mb int = NULL,  
 @status int,  
 @vds_id uniqueidentifier,  
 @vm_active int = NULL,  
 @vm_count int = 0,  
 @vms_cores_count int = NULL,  
 @vm_migrating int = NULL,  
 @reserved_mem int = NULL,  
 @guest_overhead int = NULL,  
 @software_version nvarchar(40) = NULL,  
 @version_name nvarchar(40) = NULL,  
 @build_name nvarchar(40) = NULL,  
 @previous_status int = NULL,  
 @cpu_flags nvarchar(max) = NULL,  
 @cpu_over_commit_time_stamp datetime = NULL,  
 @hypervisor_type int = NULL,  
 @pending_vcpus_count int = NULL,  
 @pending_vmem_size int = 0,  
 @cpu_sockets int = NULL,  
 @net_config_dirty bit = NULL,  
 @supported_cluster_levels nvarchar(40) = NULL,  
 @supported_rhevms nvarchar(40) = NULL,  
 @host_os nvarchar(max) = NULL,  
 @kvm_version nvarchar(max) = NULL,  
 @spice_version nvarchar(max) = NULL,  
 @kernel_version nvarchar(max) = NULL,
 @iscsi_initiator_name varchar(max) = NULL,
 @transparent_hugepages_state int = 0,
 @anonymous_hugepages int = 0,
 @hooks nvarchar(max)=''
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[vds_dynamic] ([cpu_cores], [cpu_model], [cpu_speed_mh], [if_total_speed], [kvm_enabled], [mem_commited], [physical_mem_mb],	[status], [vds_id], [vm_active], [vm_count], [vm_migrating], [reserved_mem], [guest_overhead], [software_version], [version_name], [build_name], [previous_status], [cpu_flags], [cpu_over_commit_time_stamp], [hypervisor_type], [vms_cores_count], [pending_vcpus_count], [pending_vmem_size],[cpu_sockets],[net_config_dirty], [supported_cluster_levels], [supported_rhevms], [host_os], [kvm_version], [spice_version], [kernel_version], [iscsi_initiator_name], [transparent_hugepages_state], [anonymous_hugepages],[hooks])
	VALUES (@cpu_cores,	@cpu_model,	@cpu_speed_mh,	@if_total_speed, @kvm_enabled, @mem_commited, @physical_mem_mb,	@status, @vds_id, @vm_active, @vm_count, @vm_migrating,	@reserved_mem, @guest_overhead, @software_version, @version_name, @build_name, @previous_status, @cpu_flags, @cpu_over_commit_time_stamp, @hypervisor_type, @vms_cores_count,@pending_vcpus_count, @pending_vmem_size, @cpu_sockets, @net_config_dirty, @supported_cluster_levels, @supported_rhevms, @host_os, @kvm_version, @spice_version, @kernel_version, @iscsi_initiator_name, @transparent_hugepages_state, @anonymous_hugepages,@hooks)
    
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'UpdateVdsDynamic')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[UpdateVdsDynamic] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[UpdateVdsDynamic]
    @cpu_cores int = NULL,  
 @cpu_model nvarchar(255) = NULL,  
 @cpu_speed_mh decimal(18,0) = NULL,  
 @if_total_speed nvarchar(40) = NULL,  
 @kvm_enabled bit = NULL,  
 @mem_commited int = NULL,  
 @physical_mem_mb int = NULL,  
 @status int,  
 @vds_id uniqueidentifier,  
 @vm_active int = NULL,  
 @vm_count int = NULL,  
 @vms_cores_count int = NULL,  
 @vm_migrating int = NULL,  
 @reserved_mem int = NULL,  
 @guest_overhead int = NULL,  
 @software_version nvarchar(40) = NULL,  
 @version_name nvarchar(40) = NULL,  
 @build_name nvarchar(40) = NULL,  
 @previous_status int = NULL,  
 @cpu_flags nvarchar(max) = NULL,  
 @cpu_over_commit_time_stamp datetime = NULL,  
 @hypervisor_type int = NULL,  
 @pending_vcpus_count int = NULL,  
 @pending_vmem_size int = 0,  
 @cpu_sockets int = NULL,  
 @net_config_dirty bit = NULL,  
 @supported_cluster_levels nvarchar(40) = NULL,  
 @supported_rhevms nvarchar(40) = NULL,  
 @host_os nvarchar(max) = NULL,  
 @kvm_version nvarchar(max) = NULL,  
 @spice_version nvarchar(max) = NULL,  
 @kernel_version nvarchar(max) = NULL,
 @iscsi_initiator_name varchar(max) = NULL,
 @transparent_hugepages_state int = 0,
 @anonymous_hugepages int = 0,
 @hooks nvarchar(max)='',
 @non_operational_reason int =0

AS
BEGIN

	--The [dbo].[vds_dynamic] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY
	UPDATE [dbo].[vds_dynamic] 
	SET [cpu_cores] = @cpu_cores, [cpu_model] = @cpu_model, [cpu_speed_mh] = @cpu_speed_mh, [if_total_speed] = @if_total_speed, [kvm_enabled] = @kvm_enabled, [mem_commited] = @mem_commited, [physical_mem_mb] = @physical_mem_mb, [status] = @status, [vm_active] = @vm_active, [vm_count] = @vm_count, [vm_migrating] = @vm_migrating, [reserved_mem] = @reserved_mem, [guest_overhead] = @guest_overhead, [software_version] = @software_version, [version_name] = @version_name, [build_name] = @build_name, [previous_status] = @previous_status, [cpu_flags] = @cpu_flags,
	[cpu_over_commit_time_stamp] = @cpu_over_commit_time_stamp, [hypervisor_type] = @hypervisor_type, [vms_cores_count] = @vms_cores_count, [pending_vcpus_count] = @pending_vcpus_count, [pending_vmem_size] = @pending_vmem_size, [cpu_sockets] = @cpu_sockets,[net_config_dirty] = @net_config_dirty, [supported_cluster_levels] = @supported_cluster_levels, [supported_rhevms] = @supported_rhevms, [host_os] = @host_os, [kvm_version] = @kvm_version, [spice_version] = @spice_version, [kernel_version] = @kernel_version, [iscsi_initiator_name] = @iscsi_initiator_name, [transparent_hugepages_state] = @transparent_hugepages_state, [anonymous_hugepages] = @anonymous_hugepages,[hooks]=@hooks,[_update_date]=getdate(),[non_operational_reason]=@non_operational_reason
	WHERE [vds_id]=@vds_id

	IF @@ROWCOUNT = 0
	BEGIN
		RAISERROR('Update statement affected 0 rows.', 16, 2)
	END
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH	

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'DeleteVdsDynamic')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[DeleteVdsDynamic] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[DeleteVdsDynamic]
  @vds_id uniqueidentifier  
AS
BEGIN
	SET NOCOUNT ON
	BEGIN TRY
		DELETE FROM [dbo].[vds_dynamic]
		WHERE [vds_id]=@vds_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromVdsDynamic')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromVdsDynamic] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromVdsDynamic]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[vds_dynamic].[cpu_cores] AS 'cpu_cores',
		[vds_dynamic].[cpu_model] AS 'cpu_model',
		[vds_dynamic].[cpu_speed_mh] AS 'cpu_speed_mh',
		[vds_dynamic].[if_total_speed] AS 'if_total_speed',
		[vds_dynamic].[kvm_enabled] AS 'kvm_enabled',
		[vds_dynamic].[mem_commited] AS 'mem_commited',
		[vds_dynamic].[physical_mem_mb] AS 'physical_mem_mb',
		[vds_dynamic].[status] AS 'status',
		[vds_dynamic].[vds_id] AS 'vds_id',
		[vds_dynamic].[vm_active] AS 'vm_active',
		[vds_dynamic].[vm_count] AS 'vm_count',
		[vds_dynamic].[vms_cores_count] AS 'vms_cores_count',
		[vds_dynamic].[vm_migrating] AS 'vm_migrating',
		[vds_dynamic].[reserved_mem] AS 'reserved_mem',
		[vds_dynamic].[guest_overhead] AS 'guest_overhead',
		[vds_dynamic].[software_version] AS 'software_version',
		[vds_dynamic].[version_name] AS 'version_name',
		[vds_dynamic].[build_name] AS 'build_name',
		[vds_dynamic].[previous_status] AS 'previous_status',
		[vds_dynamic].[cpu_flags] AS 'cpu_flags',
		[vds_dynamic].[cpu_over_commit_time_stamp] AS 'cpu_over_commit_time_stamp',
		[vds_dynamic].[hypervisor_type] AS 'hypervisor_type',
		[vds_dynamic].[pending_vcpus_count] AS 'pending_vcpus_count',
        [vds_dynamic].[pending_vmem_size] AS 'pending_vmem_size',
		[vds_dynamic].[cpu_sockets] AS 'cpu_sockets',
		[vds_dynamic].[net_config_dirty] AS 'net_config_dirty',
		[vds_dynamic].[supported_cluster_levels] as 'supported_cluster_levels',
		[vds_dynamic].[supported_rhevms] as 'supported_rhevms',
		[vds_dynamic].[host_os] AS 'host_os',
		[vds_dynamic].[kvm_version] AS 'kvm_version',
		[vds_dynamic].[spice_version] AS 'spice_version',
		[vds_dynamic].[kernel_version] AS 'kernel_version',
		[vds_dynamic].[iscsi_initiator_name] AS 'iscsi_initiator_name',
		[vds_dynamic].[transparent_hugepages_state] AS 'transparent_hugepages_state',
		[vds_dynamic].[anonymous_hugepages] AS 'anonymous_hugepages',
		[vds_dynamic].[hooks] AS 'hooks',
		[vds_dynamic].[non_operational_reason] AS 'non_operational_reason'

		FROM [dbo].[vds_dynamic] [vds_dynamic]
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH
	
	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVdsDynamicByVdsId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVdsDynamicByVdsId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVdsDynamicByVdsId] 
 @vds_id uniqueidentifier  
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[vds_dynamic].[cpu_cores] AS 'cpu_cores',
		[vds_dynamic].[cpu_model] AS 'cpu_model',
		[vds_dynamic].[cpu_speed_mh] AS 'cpu_speed_mh',
		[vds_dynamic].[if_total_speed] AS 'if_total_speed',
		[vds_dynamic].[kvm_enabled] AS 'kvm_enabled',
		[vds_dynamic].[mem_commited] AS 'mem_commited',
		[vds_dynamic].[physical_mem_mb] AS 'physical_mem_mb',
		[vds_dynamic].[status] AS 'status',
		[vds_dynamic].[vds_id] AS 'vds_id',
		[vds_dynamic].[vm_active] AS 'vm_active',
		[vds_dynamic].[vm_count] AS 'vm_count',
		[vds_dynamic].[vms_cores_count] AS 'vms_cores_count',
		[vds_dynamic].[vm_migrating] AS 'vm_migrating',
		[vds_dynamic].[reserved_mem] AS 'reserved_mem',
		[vds_dynamic].[guest_overhead] AS 'guest_overhead',
		[vds_dynamic].[software_version] AS 'software_version',
		[vds_dynamic].[version_name] AS 'version_name',
		[vds_dynamic].[build_name] AS 'build_name',
		[vds_dynamic].[previous_status] AS 'previous_status',
		[vds_dynamic].[cpu_flags] AS 'cpu_flags',
		[vds_dynamic].[cpu_over_commit_time_stamp] AS 'cpu_over_commit_time_stamp',
		[vds_dynamic].[hypervisor_type] AS 'hypervisor_type',
		[vds_dynamic].[pending_vcpus_count] AS 'pending_vcpus_count',
		[vds_dynamic].[pending_vmem_size] AS 'pending_vmem_size',
		[vds_dynamic].[cpu_sockets] AS 'cpu_sockets',
		[vds_dynamic].[net_config_dirty] AS 'net_config_dirty',
		[vds_dynamic].[supported_cluster_levels] as 'supported_cluster_levels',
		[vds_dynamic].[supported_rhevms] as 'supported_rhevms',
		[vds_dynamic].[host_os] AS 'host_os',
		[vds_dynamic].[kvm_version] AS 'kvm_version',
		[vds_dynamic].[spice_version] AS 'spice_version',
		[vds_dynamic].[kernel_version] AS 'kernel_version',
		[vds_dynamic].[iscsi_initiator_name] AS 'iscsi_initiator_name', 
		[vds_dynamic].[transparent_hugepages_state] AS 'transparent_hugepages_state',
		[vds_dynamic].[anonymous_hugepages] AS 'anonymous_hugepages',
		[vds_dynamic].[hooks] AS 'hooks',
		[vds_dynamic].[non_operational_reason] AS 'non_operational_reason'

		FROM [dbo].[vds_dynamic] [vds_dynamic]
		WHERE [vds_id]=@vds_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

----------------------------------------------------------------
-- [dbo].[vds_static] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'InsertVdsStatic')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[InsertVdsStatic] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[InsertVdsStatic]
    @host_name nvarchar(255),
	@ip nvarchar(255) = null,
    @vds_unique_id nvarchar(128) = null,
	@port int,
	@vds_group_id uniqueidentifier,
	@vds_id uniqueidentifier OUT,
	@vds_name nvarchar(255),
	@server_SSL_enabled bit = null,
	@vds_type int,
	@vds_strength int,
    @pm_type nvarchar(20) = null,
	@pm_user nvarchar(50) = null,
    @pm_password nvarchar(50) = null,
    @pm_port int = 0,
    @pm_options nvarchar(max) = '',
    @pm_enabled bit = 0
AS
BEGIN
	SET NOCOUNT ON
		IF @vds_unique_id IS NULL OR NOT EXISTS (SELECT [vds_name] FROM [dbo].[vds_static] WHERE [vds_unique_id] = @vds_unique_id)
		BEGIN
			BEGIN TRY
			SET @vds_id = newid()
			INSERT INTO [dbo].[vds_static] ([vds_id],[host_name], [ip], [vds_unique_id], [port], [vds_group_id], [vds_name], [server_SSL_enabled],[vds_type],[vds_strength],[pm_type],[pm_user],[pm_password],[pm_port],[pm_options],[pm_enabled])
			VALUES (@vds_id,@host_name, @ip, @vds_unique_id, @port, @vds_group_id, @vds_name, @server_SSL_enabled,@vds_type,@vds_strength,@pm_type,@pm_user,@pm_password,@pm_port,@pm_options,@pm_enabled)
			
			END TRY

			BEGIN CATCH
				EXEC RethrowError;
			END CATCH
		END
    SET NOCOUNT OFF
END     

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'UpdateVdsStatic')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[UpdateVdsStatic] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[UpdateVdsStatic]
    @host_name nvarchar(255),
	@ip nvarchar(255) = null,
    @vds_unique_id nvarchar(128)= null,
	@port int,
	@vds_group_id uniqueidentifier,
	@vds_id uniqueidentifier,
	@vds_name nvarchar(255),
	@server_SSL_enabled bit = null,
	@vds_type int,
	@vds_strength int,
    @pm_type nvarchar(20) = null,
	@pm_user nvarchar(50) = null,
    @pm_password nvarchar(50) = null,
    @pm_port int = 0,
    @pm_options nvarchar(max) = '',
    @pm_enabled bit = 0
AS
BEGIN

	--The [dbo].[vds_static] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY
	UPDATE [dbo].[vds_static] 
	SET [host_name] = @host_name, [ip] = @ip, [vds_unique_id] = @vds_unique_id, [port] = @port, [vds_group_id] = @vds_group_id, [vds_name] = @vds_name, [server_SSL_enabled] = @server_SSL_enabled, [vds_type]=@vds_type, _update_date = getdate(), [vds_strength] = @vds_strength, [pm_type] = @pm_type, [pm_user] = @pm_user, [pm_password] = @pm_password, [pm_port] = @pm_port, [pm_options] = @pm_options, [pm_enabled] = @pm_enabled
	WHERE [vds_id]=@vds_id

	IF @@ROWCOUNT = 0
	BEGIN
		RAISERROR('Update statement affected 0 rows.', 16, 2)
	END
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH	

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'DeleteVdsStatic')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[DeleteVdsStatic] AS RETURN')
END

GO

ALTER  PROCEDURE [dbo].[DeleteVdsStatic]  
  @vds_id uniqueidentifier  
AS  
BEGIN  
 SET NOCOUNT ON  
 BEGIN TRY  
   UPDATE [dbo].[vm_static]  
    SET [dedicated_vm_for_vds] = null   
   WHERE [dedicated_vm_for_vds] = @vds_id  
   DELETE FROM [dbo].[tags_vds_map]  
   WHERE [vds_id] = @vds_id  
   -- Delete all Vds Alerts from the database  
   exec dbo.DeleteAuditLogAlertsByVdsID @vds_id  
   DELETE FROM [dbo].[vds_static]  
   WHERE [vds_id]=@vds_id
	-- delete VDS permissions --
	DELETE FROM [dbo].[permissions] where object_id = @vds_id  
 END TRY  
 BEGIN CATCH  
  EXEC RethrowError;  
 END CATCH  
       
    SET NOCOUNT OFF  
END  
go

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromVdsStatic')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromVdsStatic] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromVdsStatic]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[vds_static].[host_name] AS 'host_name',
	[vds_static].[ip] AS 'ip',
    [vds_static].[vds_unique_id] AS 'vds_unique_id',
	[vds_static].[port] AS 'port',
	[vds_static].[vds_group_id] AS 'vds_group_id',
	[vds_static].[vds_id] AS 'vds_id',
	[vds_static].[vds_name] AS 'vds_name',
	[vds_static].[server_SSL_enabled] AS 'server_SSL_enabled',
	[vds_static].[vds_type] AS 'vds_type',
	[vds_static].[vds_strength] AS 'vds_strength',
	[vds_static].[pm_type] AS 'pm_type',
	[vds_static].[pm_user] AS 'pm_user',
	[vds_static].[pm_password] AS 'pm_password',
    [vds_static].[pm_port] as 'pm_port',
    [vds_static].[pm_options] as 'pm_options',
    [vds_static].[pm_enabled] as 'pm_enabled'

FROM [dbo].[vds_static] [vds_static]

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVdsStaticByVdsId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVdsStaticByVdsId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVdsStaticByVdsId] 
 @vds_id uniqueidentifier  
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[vds_static].[host_name] AS 'host_name',
		[vds_static].[ip] AS 'ip',
		[vds_static].[vds_unique_id] AS 'vds_unique_id',        
		[vds_static].[port] AS 'port',
		[vds_static].[vds_group_id] AS 'vds_group_id',
		[vds_static].[vds_id] AS 'vds_id',
		[vds_static].[vds_name] AS 'vds_name',
		[vds_static].[server_SSL_enabled] AS 'server_SSL_enabled',
		[vds_static].[vds_type] AS 'vds_type',
		[vds_static].[vds_strength] AS 'vds_strength',
		[vds_static].[pm_type] AS 'pm_type',
		[vds_static].[pm_user] AS 'pm_user',
		[vds_static].[pm_password] AS 'pm_password',
	        [vds_static].[pm_port] as 'pm_port',
	        [vds_static].[pm_options] as 'pm_options',
		[vds_static].[pm_enabled] as 'pm_enabled'
		FROM [dbo].[vds_static] [vds_static]
		WHERE [vds_id]=@vds_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

--Vitaly add 
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVdsStaticByVdsName')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVdsStaticByVdsName] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVdsStaticByVdsName] 
	@vds_name nvarchar(255)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[vds_static].[host_name] AS 'host_name',
		[vds_static].[ip] AS 'ip',
        [vds_static].[vds_unique_id] AS 'vds_unique_id', 
		[vds_static].[port] AS 'port',
		[vds_static].[vds_group_id] AS 'vds_group_id',
		[vds_static].[vds_id] AS 'vds_id',
		[vds_static].[vds_name] AS 'vds_name',
		[vds_static].[server_SSL_enabled] AS 'server_SSL_enabled',
		[vds_static].[vds_type] as 'vds_type',
		[vds_static].[vds_strength] AS 'vds_strength',
		[vds_static].[pm_type] AS 'pm_type',
		[vds_static].[pm_user] AS 'pm_user',
		[vds_static].[pm_password] AS 'pm_password',
        [vds_static].[pm_port] as 'pm_port',
        [vds_static].[pm_options] as 'pm_options',
		[vds_static].[pm_enabled] as 'pm_enabled'

		FROM [dbo].[vds_static] [vds_static]
		WHERE [vds_name]=@vds_name
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVdsStaticByHostName')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVdsStaticByHostName] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVdsStaticByHostName] 
	@host_name nvarchar(255)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	
	SELECT
	[vds_static].[host_name] AS 'host_name',
	[vds_static].[ip] AS 'ip',
    [vds_static].[vds_unique_id] AS 'vds_unique_id', 
	[vds_static].[port] AS 'port',
	[vds_static].[vds_group_id] AS 'vds_group_id',
	[vds_static].[vds_id] AS 'vds_id',
	[vds_static].[vds_name] AS 'vds_name',
	[vds_static].[server_SSL_enabled] AS 'server_SSL_enabled',
	[vds_static].[vds_type] AS 'vds_type',
	[vds_static].[vds_strength] AS 'vds_strength',
	[vds_static].[pm_type] AS 'pm_type',
	[vds_static].[pm_user] AS 'pm_user',
	[vds_static].[pm_password] AS 'pm_password',
    [vds_static].[pm_port] as 'pm_port',
    [vds_static].[pm_options] as 'pm_options',
	[vds_static].[pm_enabled] as 'pm_enabled'

	FROM [dbo].[vds_static] [vds_static]
	WHERE [host_name]=@host_name

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVdsStaticByIp')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVdsStaticByIp] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVdsStaticByIp] 
	@ip nvarchar(40)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[vds_static].[host_name] AS 'host_name',
		[vds_static].[ip] AS 'ip',
        [vds_static].[vds_unique_id] AS 'vds_unique_id',
		[vds_static].[port] AS 'port',
		[vds_static].[vds_group_id] AS 'vds_group_id',
		[vds_static].[vds_id] AS 'vds_id',
		[vds_static].[vds_name] AS 'vds_name',
		[vds_static].[server_SSL_enabled] AS 'server_SSL_enabled',
		[vds_static].[vds_type] AS 'vds_type',
		[vds_static].[vds_strength] AS 'vds_strength',
		[vds_static].[pm_type] AS 'pm_type',
		[vds_static].[pm_user] AS 'pm_user',
		[vds_static].[pm_password] AS 'pm_password',
        [vds_static].[pm_port] as 'pm_port',
        [vds_static].[pm_options] as 'pm_options',
		[vds_static].[pm_enabled] as 'pm_enabled'
		FROM [dbo].[vds_static] [vds_static]
		WHERE [ip]=@ip
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVdsByUniqueID')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVdsByUniqueID] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVdsByUniqueID] 
	@vds_unique_id nvarchar(128)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		distinct([vds].[vds_id]) AS 'vds_id',
		[vds].[vds_group_id] AS 'vds_group_id',
		[vds].[vds_group_name] AS 'vds_group_name',
		[vds].[vds_group_description] AS 'vds_group_description',
		[vds].[vds_name] AS 'vds_name',
		[vds].[ip] AS 'ip',
        [vds].[vds_unique_id] AS 'vds_unique_id',
		[vds].[server_SSL_enabled] AS 'server_SSL_enabled',
		[vds].[host_name] AS 'host_name',
		[vds].[port] AS 'port',
		[vds].[status] AS 'status',
		[vds].[cpu_cores] AS 'cpu_cores',
		[vds].[cpu_model] AS 'cpu_model',
		[vds].[cpu_speed_mh] AS 'cpu_speed_mh',
		[vds].[if_total_speed] AS 'if_total_speed',
		[vds].[kvm_enabled] AS 'kvm_enabled',
		[vds].[physical_mem_mb] AS 'physical_mem_mb',
		[vds].[cpu_idle] AS 'cpu_idle',
		[vds].[cpu_load] AS 'cpu_load',
		[vds].[cpu_sys] AS 'cpu_sys',
		[vds].[cpu_user] AS 'cpu_user',
		[vds].[mem_commited] AS 'mem_commited',
		[vds].[vm_active] AS 'vm_active',
		[vds].[vm_count] AS 'vm_count',
		[vds].[vms_cores_count] AS 'vms_cores_count',
		[vds].[vm_migrating] AS 'vm_migrating',
		[vds].[usage_cpu_percent] AS 'usage_cpu_percent',
		[vds].[usage_mem_percent] AS 'usage_mem_percent',
		[vds].[usage_network_percent] AS 'usage_network_percent',
		[vds].[reserved_mem] AS 'reserved_mem',
		[vds].[guest_overhead] AS 'guest_overhead',
		[vds].[software_version] AS 'software_version',
		[vds].[version_name] AS 'version_name',
		[vds].[build_name] AS 'build_name',
		[vds].[previous_status] AS 'previous_status',
		[vds].[mem_available] AS 'mem_available',
		[vds].[mem_shared] AS 'mem_shared',
		[vds].[vds_type] as 'vds_type',
		[vds].[cpu_flags] AS 'cpu_flags',
		[vds].[vds_group_cpu_name] as 'vds_group_cpu_name',
		[vds].[cpu_over_commit_time_stamp] as 'cpu_over_commit_time_stamp',
		[vds].[hypervisor_type] as 'hypervisor_type',
		[vds].[high_utilization] as 'high_utilization',
		[vds].[low_utilization] as 'low_utilization',
		[vds].[cpu_over_commit_duration_minutes] as 'cpu_over_commit_duration_minutes',
		[vds].[storage_pool_id] as 'storage_pool_id',
		[vds].[storage_pool_name] as 'storage_pool_name',
		[vds].[selection_algorithm] as 'selection_algorithm',
		[vds].[pending_vcpus_count] as 'pending_vcpus_count',
		[vds].[pending_vmem_size] AS 'pending_vmem_size',
		[vds].[vds_strength] AS 'vds_strength',
		[vds].[max_vds_memory_over_commit] AS 'max_vds_memory_over_commit',
        [vds].[cpu_sockets] as 'cpu_sockets',
        [vds].[vds_spm_id] as 'vds_spm_id',
        [vds].[net_config_dirty] as 'net_config_dirty',
        [vds].[pm_type] as 'pm_type',
		[vds].[pm_user] as 'pm_user',
		[vds].[pm_password] as 'pm_password',
        [vds].[pm_port] as 'pm_port',
        [vds].[pm_options] as 'pm_options',
        [vds].[pm_enabled] as 'pm_enabled',
		[vds].[spm_status] as 'spm_status',
		[vds].[swap_free] AS 'swap_free',
		[vds].[swap_total] AS 'swap_total',
		[vds].[ksm_cpu_percent] AS 'ksm_cpu_percent',
		[vds].[ksm_pages] AS 'ksm_pages',
		[vds].[ksm_state] AS 'ksm_state',
		[vds].[supported_cluster_levels] as 'supported_cluster_levels',
		[vds].[supported_rhevms] as 'supported_rhevms',
		[vds].[vds_group_compatibility_version] as 'vds_group_compatibility_version',
		[vds].[host_os] AS 'host_os',
		[vds].[kvm_version] AS 'kvm_version',
		[vds].[spice_version] AS 'spice_version',
		[vds].[kernel_version] AS 'kernel_version',
		[vds].[iscsi_initiator_name] AS 'iscsi_initiator_name',
		[vds].[transparent_hugepages_state] AS 'transparent_hugepages_state',
		[vds].[anonymous_hugepages] AS 'anonymous_hugepages',
		[vds].[hooks] AS 'hooks',
		[vds].[non_operational_reason] AS 'non_operational_reason'
		FROM [dbo].[vds] [vds]
		WHERE [vds_unique_id]=@vds_unique_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

--end Vitaly add

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVdsStaticByVdsGroupId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVdsStaticByVdsGroupId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVdsStaticByVdsGroupId] 
 @vds_group_id uniqueidentifier  
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[vds_static].[host_name] AS 'host_name',
		[vds_static].[ip] AS 'ip',
        [vds_static].[vds_unique_id] AS 'vds_unique_id',
		[vds_static].[port] AS 'port',
		[vds_static].[vds_group_id] AS 'vds_group_id',
		[vds_static].[vds_id] AS 'vds_id',
		[vds_static].[vds_name] AS 'vds_name',
		[vds_static].[server_SSL_enabled] AS 'server_SSL_enabled',
		[vds_static].[vds_type] AS 'vds_type',
		[vds_static].[vds_strength] AS 'vds_strength',
		[vds_static].[pm_type] AS 'pm_type',
		[vds_static].[pm_user] AS 'pm_user',
		[vds_static].[pm_password] AS 'pm_password',
        [vds_static].[pm_port] as 'pm_port',
        [vds_static].[pm_options] as 'pm_options',
		[vds_static].[pm_enabled] as 'pm_enabled'
		FROM [dbo].[vds_static] [vds_static]
		WHERE [vds_group_id]=@vds_group_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO


---------------------------------------------------------------------------------------------------
--    [dbo].[vds] - view
---------------------------------------------------------------------------------------------------

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromVds')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromVds] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromVds]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		distinct([vds].[vds_id]) AS 'vds_id',
		[vds].[vds_group_id] AS 'vds_group_id',
		[vds].[vds_group_name] AS 'vds_group_name',
		[vds].[vds_group_description] AS 'vds_group_description',
		[vds].[vds_name] AS 'vds_name',
		[vds].[ip] AS 'ip',
        [vds].[vds_unique_id] AS 'vds_unique_id',
		[vds].[server_SSL_enabled] AS 'server_SSL_enabled',
		[vds].[host_name] AS 'host_name',
		[vds].[port] AS 'port',
		[vds].[status] AS 'status',
		[vds].[cpu_cores] AS 'cpu_cores',
		[vds].[cpu_model] AS 'cpu_model',
		[vds].[cpu_speed_mh] AS 'cpu_speed_mh',
		[vds].[if_total_speed] AS 'if_total_speed',
		[vds].[kvm_enabled] AS 'kvm_enabled',
		[vds].[physical_mem_mb] AS 'physical_mem_mb',
		[vds].[cpu_idle] AS 'cpu_idle',
		[vds].[cpu_load] AS 'cpu_load',
		[vds].[cpu_sys] AS 'cpu_sys',
		[vds].[cpu_user] AS 'cpu_user',
		[vds].[mem_commited] AS 'mem_commited',
		[vds].[vm_active] AS 'vm_active',
		[vds].[vm_count] AS 'vm_count',
		[vds].[vms_cores_count] AS 'vms_cores_count',
		[vds].[vm_migrating] AS 'vm_migrating',
		[vds].[usage_cpu_percent] AS 'usage_cpu_percent',
		[vds].[usage_mem_percent] AS 'usage_mem_percent',
		[vds].[usage_network_percent] AS 'usage_network_percent',
		[vds].[reserved_mem] AS 'reserved_mem',
		[vds].[guest_overhead] AS 'guest_overhead',
		[vds].[software_version] AS 'software_version',
		[vds].[version_name] AS 'version_name',
		[vds].[build_name] AS 'build_name',
		[vds].[previous_status] AS 'previous_status',
		[vds].[mem_available] AS 'mem_available',
		[vds].[mem_shared] AS 'mem_shared',
		[vds].[vds_type] as 'vds_type',
		[vds].[cpu_flags] AS 'cpu_flags',
		[vds].[vds_group_cpu_name] as 'vds_group_cpu_name',
		[vds].[cpu_over_commit_time_stamp] as 'cpu_over_commit_time_stamp',
		[vds].[hypervisor_type] as 'hypervisor_type',
		[vds].[high_utilization] as 'high_utilization',
		[vds].[low_utilization] as 'low_utilization',
		[vds].[cpu_over_commit_duration_minutes] as 'cpu_over_commit_duration_minutes',
		[vds].[storage_pool_id] as 'storage_pool_id',
		[vds].[storage_pool_name] as 'storage_pool_name',
		[vds].[selection_algorithm] as 'selection_algorithm',
		[vds].[pending_vcpus_count] as 'pending_vcpus_count',
		[vds].[pending_vmem_size] AS 'pending_vmem_size',
		[vds].[vds_strength] AS 'vds_strength',
		[vds].[max_vds_memory_over_commit] AS 'max_vds_memory_over_commit',
        [vds].[cpu_sockets] as 'cpu_sockets',
        [vds].[vds_spm_id] as 'vds_spm_id',
        [vds].[net_config_dirty] as 'net_config_dirty',
        [vds].[pm_type] as 'pm_type',
		[vds].[pm_user] as 'pm_user',
		[vds].[pm_password] as 'pm_password',
        [vds].[pm_port] as 'pm_port',
        [vds].[pm_options] as 'pm_options',
		[vds].[pm_enabled] as 'pm_enabled',
		[vds].[spm_status] as 'spm_status',
		[vds].[swap_free] AS 'swap_free',
		[vds].[swap_total] AS 'swap_total',
		[vds].[ksm_cpu_percent] AS 'ksm_cpu_percent',
		[vds].[ksm_pages] AS 'ksm_pages',
		[vds].[ksm_state] AS 'ksm_state',
		[vds].[supported_cluster_levels] as 'supported_cluster_levels',
		[vds].[supported_rhevms] as 'supported_rhevms',
		[vds].[vds_group_compatibility_version] as 'vds_group_compatibility_version',
		[vds].[host_os] AS 'host_os',
		[vds].[kvm_version] AS 'kvm_version',
		[vds].[spice_version] AS 'spice_version',
		[vds].[kernel_version] AS 'kernel_version',
		[vds].[iscsi_initiator_name] AS 'iscsi_initiator_name',
		[vds].[transparent_hugepages_state] AS 'transparent_hugepages_state',
		[vds].[anonymous_hugepages] AS 'anonymous_hugepages',
		[vds].[hooks] AS 'hooks',
		[vds].[non_operational_reason] AS 'non_operational_reason'

	FROM [dbo].[vds] [vds]

	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH
	

	SET NOCOUNT OFF
END

GO


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVdsByVdsId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVdsByVdsId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVdsByVdsId]
 @vds_id uniqueidentifier      
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		distinct([vds].[vds_id]) AS 'vds_id',
		[vds].[vds_group_id] AS 'vds_group_id',
		[vds].[vds_group_name] AS 'vds_group_name',
		[vds].[vds_group_description] AS 'vds_group_description',
		[vds].[vds_name] AS 'vds_name',
		[vds].[ip] AS 'ip',
        [vds].[vds_unique_id] AS 'vds_unique_id',
		[vds].[server_SSL_enabled] AS 'server_SSL_enabled',
		[vds].[host_name] AS 'host_name',
		[vds].[port] AS 'port',
		[vds].[status] AS 'status',
		[vds].[cpu_cores] AS 'cpu_cores',
		[vds].[cpu_model] AS 'cpu_model',
		[vds].[cpu_speed_mh] AS 'cpu_speed_mh',
		[vds].[if_total_speed] AS 'if_total_speed',
		[vds].[kvm_enabled] AS 'kvm_enabled',
		[vds].[physical_mem_mb] AS 'physical_mem_mb',
		[vds].[cpu_idle] AS 'cpu_idle',
		[vds].[cpu_load] AS 'cpu_load',
		[vds].[cpu_sys] AS 'cpu_sys',
		[vds].[cpu_user] AS 'cpu_user',
		[vds].[mem_commited] AS 'mem_commited',
		[vds].[vm_active] AS 'vm_active',
		[vds].[vm_count] AS 'vm_count',
		[vds].[vms_cores_count] AS 'vms_cores_count',
		[vds].[vm_migrating] AS 'vm_migrating',
		[vds].[usage_cpu_percent] AS 'usage_cpu_percent',
		[vds].[usage_mem_percent] AS 'usage_mem_percent',
		[vds].[usage_network_percent] AS 'usage_network_percent',
		[vds].[reserved_mem] AS 'reserved_mem',
		[vds].[guest_overhead] AS 'guest_overhead',
		[vds].[software_version] AS 'software_version',
		[vds].[version_name] AS 'version_name',
		[vds].[build_name] AS 'build_name',
		[vds].[previous_status] AS 'previous_status',
		[vds].[mem_available] AS 'mem_available',
		[vds].[mem_shared] AS 'mem_shared',
		[vds].[vds_type] as 'vds_type',
		[vds].[cpu_flags] AS 'cpu_flags',
		[vds].[vds_group_cpu_name] as 'vds_group_cpu_name',
		[vds].[cpu_over_commit_time_stamp] as 'cpu_over_commit_time_stamp',
		[vds].[hypervisor_type] as 'hypervisor_type',
		[vds].[high_utilization] as 'high_utilization',
		[vds].[low_utilization] as 'low_utilization',
		[vds].[cpu_over_commit_duration_minutes] as 'cpu_over_commit_duration_minutes',
		[vds].[storage_pool_id] as 'storage_pool_id',
		[vds].[storage_pool_name] as 'storage_pool_name',
		[vds].[selection_algorithm] as 'selection_algorithm',
		[vds].[pending_vcpus_count] as 'pending_vcpus_count',
		[vds].[pending_vmem_size] AS 'pending_vmem_size',
		[vds].[vds_strength] AS 'vds_strength',
		[vds].[max_vds_memory_over_commit] AS 'max_vds_memory_over_commit',
        [vds].[cpu_sockets] as 'cpu_sockets',
        [vds].[vds_spm_id] as 'vds_spm_id',
        [vds].[net_config_dirty] as 'net_config_dirty',
        [vds].[pm_type] as 'pm_type',
		[vds].[pm_user] as 'pm_user',
		[vds].[pm_password] as 'pm_password',
        [vds].[pm_port] as 'pm_port',
        [vds].[pm_options] as 'pm_options',
		[vds].[pm_enabled] as 'pm_enabled',
		[vds].[spm_status] as 'spm_status',
		[vds].[swap_free] AS 'swap_free',
		[vds].[swap_total] AS 'swap_total',
		[vds].[ksm_cpu_percent] AS 'ksm_cpu_percent',
		[vds].[ksm_pages] AS 'ksm_pages',
		[vds].[ksm_state] AS 'ksm_state',
		[vds].[supported_cluster_levels] as 'supported_cluster_levels',
		[vds].[supported_rhevms] as 'supported_rhevms',
		[vds].[vds_group_compatibility_version] as 'vds_group_compatibility_version',
		[vds].[host_os] AS 'host_os',
		[vds].[kvm_version] AS 'kvm_version',
		[vds].[spice_version] AS 'spice_version',
		[vds].[kernel_version] AS 'kernel_version',
		[vds].[iscsi_initiator_name] AS 'iscsi_initiator_name',
		[vds].[transparent_hugepages_state] AS 'transparent_hugepages_state',
		[vds].[anonymous_hugepages] AS 'anonymous_hugepages',
		[vds].[hooks] AS 'hooks',
		[vds].[non_operational_reason] AS 'non_operational_reason'

		FROM [dbo].[vds] [vds]
		WHERE [vds_id]=@vds_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVdsWithoutMigratingVmsByVdsGroupId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVdsWithoutMigratingVmsByVdsGroupId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVdsWithoutMigratingVmsByVdsGroupId]
	@vds_group_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	-- this sp returns all vds in given cluster that have no pending vms and no vms in migration states
	BEGIN TRY
		SELECT
		distinct([vds].[vds_id]) AS 'vds_id',
		[vds].[vds_group_id] AS 'vds_group_id',
		[vds].[vds_group_name] AS 'vds_group_name',
		[vds].[vds_group_description] AS 'vds_group_description',
		[vds].[vds_name] AS 'vds_name',
		[vds].[ip] AS 'ip',
        [vds].[vds_unique_id] AS 'vds_unique_id',
		[vds].[server_SSL_enabled] AS 'server_SSL_enabled',
		[vds].[host_name] AS 'host_name',
		[vds].[port] AS 'port',
		[vds].[status] AS 'status',
		[vds].[cpu_cores] AS 'cpu_cores',
		[vds].[cpu_model] AS 'cpu_model',
		[vds].[cpu_speed_mh] AS 'cpu_speed_mh',
		[vds].[if_total_speed] AS 'if_total_speed',
		[vds].[kvm_enabled] AS 'kvm_enabled',
		[vds].[physical_mem_mb] AS 'physical_mem_mb',
		[vds].[cpu_idle] AS 'cpu_idle',
		[vds].[cpu_load] AS 'cpu_load',
		[vds].[cpu_sys] AS 'cpu_sys',
		[vds].[cpu_user] AS 'cpu_user',
		[vds].[mem_commited] AS 'mem_commited',
		[vds].[vm_active] AS 'vm_active',
		[vds].[vm_count] AS 'vm_count',
		[vds].[vms_cores_count] AS 'vms_cores_count',
		[vds].[vm_migrating] AS 'vm_migrating',
		[vds].[usage_cpu_percent] AS 'usage_cpu_percent',
		[vds].[usage_mem_percent] AS 'usage_mem_percent',
		[vds].[usage_network_percent] AS 'usage_network_percent',
		[vds].[reserved_mem] AS 'reserved_mem',
		[vds].[guest_overhead] AS 'guest_overhead',
		[vds].[software_version] AS 'software_version',
		[vds].[version_name] AS 'version_name',
		[vds].[build_name] AS 'build_name',
		[vds].[previous_status] AS 'previous_status',
		[vds].[mem_available] AS 'mem_available',
		[vds].[mem_shared] AS 'mem_shared',
		[vds].[vds_type] as 'vds_type',
		[vds].[cpu_flags] AS 'cpu_flags',
		[vds].[vds_group_cpu_name] as 'vds_group_cpu_name',
		[vds].[cpu_over_commit_time_stamp] as 'cpu_over_commit_time_stamp',
		[vds].[hypervisor_type] as 'hypervisor_type',
		[vds].[high_utilization] as 'high_utilization',
		[vds].[low_utilization] as 'low_utilization',
		[vds].[cpu_over_commit_duration_minutes] as 'cpu_over_commit_duration_minutes',
		[vds].[storage_pool_id] as 'storage_pool_id',
		[vds].[storage_pool_name] as 'storage_pool_name',
		[vds].[selection_algorithm] as 'selection_algorithm',
		[vds].[pending_vcpus_count] as 'pending_vcpus_count',
		[vds].[pending_vmem_size] AS 'pending_vmem_size',
		[vds].[vds_strength] AS 'vds_strength',
		[vds].[max_vds_memory_over_commit] AS 'max_vds_memory_over_commit',
        [vds].[cpu_sockets] as 'cpu_sockets',
        [vds].[vds_spm_id] as 'vds_spm_id',
        [vds].[net_config_dirty] as 'net_config_dirty',
        [vds].[pm_type] as 'pm_type',
		[vds].[pm_user] as 'pm_user',
		[vds].[pm_password] as 'pm_password',
        [vds].[pm_port] as 'pm_port',
        [vds].[pm_options] as 'pm_options',
		[vds].[pm_enabled] as 'pm_enabled',
		[vds].[spm_status] as 'spm_status',
		[vds].[swap_free] AS 'swap_free',
		[vds].[swap_total] AS 'swap_total',
		[vds].[ksm_cpu_percent] AS 'ksm_cpu_percent',
		[vds].[ksm_pages] AS 'ksm_pages',
		[vds].[ksm_state] AS 'ksm_state',
		[vds].[supported_cluster_levels] as 'supported_cluster_levels',
		[vds].[supported_rhevms] as 'supported_rhevms',
		[vds].[vds_group_compatibility_version] as 'vds_group_compatibility_version',
		[vds].[host_os] AS 'host_os',
		[vds].[kvm_version] AS 'kvm_version',
		[vds].[spice_version] AS 'spice_version',
		[vds].[kernel_version] AS 'kernel_version',
		[vds].[iscsi_initiator_name] AS 'iscsi_initiator_name',
		[vds].[transparent_hugepages_state] AS 'transparent_hugepages_state',
		[vds].[anonymous_hugepages] AS 'anonymous_hugepages',
		[vds].[hooks] as 'hooks',
		[vds].[non_operational_reason] AS 'non_operational_reason'

		FROM [dbo].[vds] [vds]
		WHERE [vds_group_id] = @vds_group_id and 
		[pending_vcpus_count] = 0 
		and	[vds].[status] = 3
		and	[vds_id] not in (
		select distinct [run_on_vds] from vm_dynamic 
					where [status] in (5,6,11,12)
		)
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO



IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'InsertVds')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[InsertVds] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[InsertVds]
    @host_name nvarchar(255),  
 @ip nvarchar(40) = null,  
    @vds_unique_id nvarchar(128) = null,  
 @port int,  
 @vds_group_id uniqueidentifier,  
 @vds_id uniqueidentifier OUT,  
 @vds_name nvarchar(255),  
 @server_SSL_enabled bit = null,  
 @vds_type int,  
 @vds_strength int,  
    @pm_type nvarchar(20) = null,  
 @pm_user nvarchar(50) = null,  
    @pm_password nvarchar(50) = null,  
 @pm_port int = 0,  
    @pm_options nvarchar(max) = '',  
    @pm_enabled bit = 0  

AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    SET @vds_id = newid()
	INSERT INTO [dbo].[vds_static] ([vds_id],[host_name], [ip], [vds_unique_id], [port], [vds_group_id], [vds_name], [server_SSL_enabled],[vds_type],[vds_strength],[pm_type],[pm_user],[pm_password], [pm_port], [pm_options], [pm_enabled])
	VALUES (@vds_id,@host_name, @ip, @vds_unique_id, @port, @vds_group_id, @vds_name, @server_SSL_enabled,@vds_type, @vds_strength,@pm_type,@pm_user,@pm_password,@pm_port, @pm_options, @pm_enabled)
    
    INSERT INTO [dbo].[vds_dynamic] ([vds_id], [status]) VALUES (@vds_id, 0)
    INSERT INTO [dbo].[vds_statistics] ([vds_id]) VALUES (@vds_id)
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    
GO


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'DeleteVds')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[DeleteVds] AS RETURN')
END

GO

ALTER  PROCEDURE [dbo].[DeleteVds]  
  @vds_id uniqueidentifier  
AS  
BEGIN  
 SET NOCOUNT ON  
 BEGIN TRY  
   UPDATE [dbo].[vm_static]  
    SET [dedicated_vm_for_vds] = null   
   WHERE [dedicated_vm_for_vds] = @vds_id  
  
   DELETE FROM [dbo].[tags_vds_map]  
   WHERE [vds_id] = @vds_id  
   -- Delete all Vds Alerts from the database  
   exec dbo.DeleteAuditLogAlertsByVdsID @vds_id  
  
   DELETE FROM [dbo].[vds_statistics] WHERE [vds_id]=@vds_id  
   DELETE FROM [dbo].[vds_dynamic] WHERE [vds_id]=@vds_id  
   DELETE FROM [dbo].[vds_static] WHERE [vds_id]=@vds_id 
   DELETE FROM [dbo].[permissions] where object_id = @vds_id  
 END TRY  
 BEGIN CATCH  
  EXEC RethrowError;  
 END CATCH  
    SET NOCOUNT OFF  
END  
go

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVdsByType')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVdsByType] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVdsByType]
	@vds_type int    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		distinct([vds].[vds_id]) AS 'vds_id',
		[vds].[vds_group_id] AS 'vds_group_id',
		[vds].[vds_group_name] AS 'vds_group_name',
		[vds].[vds_group_description] AS 'vds_group_description',
		[vds].[vds_name] AS 'vds_name',
		[vds].[ip] AS 'ip',
		[vds].[vds_unique_id] AS 'vds_unique_id',
		[vds].[server_SSL_enabled] AS 'server_SSL_enabled',
		[vds].[host_name] AS 'host_name',
		[vds].[port] AS 'port',
		[vds].[status] AS 'status',
		[vds].[cpu_cores] AS 'cpu_cores',
		[vds].[cpu_model] AS 'cpu_model',
		[vds].[cpu_speed_mh] AS 'cpu_speed_mh',
		[vds].[if_total_speed] AS 'if_total_speed',
		[vds].[kvm_enabled] AS 'kvm_enabled',
		[vds].[physical_mem_mb] AS 'physical_mem_mb',
		[vds].[cpu_idle] AS 'cpu_idle',
		[vds].[cpu_load] AS 'cpu_load',
		[vds].[cpu_sys] AS 'cpu_sys',
		[vds].[cpu_user] AS 'cpu_user',
		[vds].[mem_commited] AS 'mem_commited',
		[vds].[vm_active] AS 'vm_active',
		[vds].[vm_count] AS 'vm_count',
		[vds].[vms_cores_count] AS 'vms_cores_count',
		[vds].[vm_migrating] AS 'vm_migrating',
		[vds].[usage_cpu_percent] AS 'usage_cpu_percent',
		[vds].[usage_mem_percent] AS 'usage_mem_percent',
		[vds].[usage_network_percent] AS 'usage_network_percent',
		[vds].[reserved_mem] AS 'reserved_mem',
		[vds].[guest_overhead] AS 'guest_overhead',
		[vds].[software_version] AS 'software_version',
		[vds].[version_name] AS 'version_name',
		[vds].[build_name] AS 'build_name',
		[vds].[previous_status] AS 'previous_status',
		[vds].[mem_available] AS 'mem_available',
		[vds].[mem_shared] AS 'mem_shared',
		[vds].[vds_type] as 'vds_type',
		[vds].[cpu_flags] AS 'cpu_flags',
		[vds].[vds_group_cpu_name] as 'vds_group_cpu_name',
		[vds].[cpu_over_commit_time_stamp] as 'cpu_over_commit_time_stamp',
		[vds].[hypervisor_type] as 'hypervisor_type',
		[vds].[high_utilization] as 'high_utilization',
		[vds].[low_utilization] as 'low_utilization',
		[vds].[cpu_over_commit_duration_minutes] as 'cpu_over_commit_duration_minutes',
		[vds].[storage_pool_id] as 'storage_pool_id',
		[vds].[storage_pool_name] as 'storage_pool_name',
		[vds].[selection_algorithm] as 'selection_algorithm',
		[vds].[pending_vcpus_count] as 'pending_vcpus_count',
		[vds].[pending_vmem_size] AS 'pending_vmem_size',
		[vds].[vds_strength] AS 'vds_strength',
		[vds].[max_vds_memory_over_commit] AS 'max_vds_memory_over_commit',
        [vds].[cpu_sockets] as 'cpu_sockets',
        [vds].[vds_spm_id] as 'vds_spm_id',
        [vds].[net_config_dirty] as 'net_config_dirty',
        [vds].[pm_type] as 'pm_type',
		[vds].[pm_user] as 'pm_user',
		[vds].[pm_password] as 'pm_password',
        [vds].[pm_port] as 'pm_port',
        [vds].[pm_options] as 'pm_options',
		[vds].[pm_enabled] as 'pm_enabled',
		[vds].[spm_status] as 'spm_status',
		[vds].[swap_free] AS 'swap_free',
		[vds].[swap_total] AS 'swap_total',
		[vds].[ksm_cpu_percent] AS 'ksm_cpu_percent',
		[vds].[ksm_pages] AS 'ksm_pages',
		[vds].[ksm_state] AS 'ksm_state',
		[vds].[supported_cluster_levels] as 'supported_cluster_levels',
		[vds].[supported_rhevms] as 'supported_rhevms',
		[vds].[vds_group_compatibility_version] as 'vds_group_compatibility_version',
		[vds].[host_os] AS 'host_os',
		[vds].[kvm_version] AS 'kvm_version',
		[vds].[spice_version] AS 'spice_version',
		[vds].[kernel_version] AS 'kernel_version',
		[vds].[iscsi_initiator_name] AS 'iscsi_initiator_name',
		[vds].[transparent_hugepages_state] AS 'transparent_hugepages_state',
		[vds].[anonymous_hugepages] AS 'anonymous_hugepages',
		[vds].[hooks] AS 'hooks',
		[vds].[non_operational_reason] AS 'non_operational_reason'

		FROM [dbo].[vds] [vds]
		WHERE [vds_type]=@vds_type
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END
GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVdsByName')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVdsByName] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVdsByName]
	@vds_name nvarchar(255)   
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		distinct([vds].[vds_id]) AS 'vds_id',
		[vds].[vds_group_id] AS 'vds_group_id',
		[vds].[vds_group_name] AS 'vds_group_name',
		[vds].[vds_group_description] AS 'vds_group_description',
		[vds].[vds_name] AS 'vds_name',
		[vds].[ip] AS 'ip',
        [vds].[vds_unique_id] AS 'vds_unique_id',
		[vds].[server_SSL_enabled] AS 'server_SSL_enabled',
		[vds].[host_name] AS 'host_name',
		[vds].[port] AS 'port',
		[vds].[status] AS 'status',
		[vds].[cpu_cores] AS 'cpu_cores',
		[vds].[cpu_model] AS 'cpu_model',
		[vds].[cpu_speed_mh] AS 'cpu_speed_mh',
		[vds].[if_total_speed] AS 'if_total_speed',
		[vds].[kvm_enabled] AS 'kvm_enabled',
		[vds].[physical_mem_mb] AS 'physical_mem_mb',
		[vds].[cpu_idle] AS 'cpu_idle',
		[vds].[cpu_load] AS 'cpu_load',
		[vds].[cpu_sys] AS 'cpu_sys',
		[vds].[cpu_user] AS 'cpu_user',
		[vds].[mem_commited] AS 'mem_commited',
		[vds].[vm_active] AS 'vm_active',
		[vds].[vm_count] AS 'vm_count',
		[vds].[vms_cores_count] AS 'vms_cores_count',
		[vds].[vm_migrating] AS 'vm_migrating',
		[vds].[usage_cpu_percent] AS 'usage_cpu_percent',
		[vds].[usage_mem_percent] AS 'usage_mem_percent',
		[vds].[usage_network_percent] AS 'usage_network_percent',
		[vds].[reserved_mem] AS 'reserved_mem',
		[vds].[guest_overhead] AS 'guest_overhead',
		[vds].[software_version] AS 'software_version',
		[vds].[version_name] AS 'version_name',
		[vds].[build_name] AS 'build_name',
		[vds].[previous_status] AS 'previous_status',
		[vds].[mem_available] AS 'mem_available',
		[vds].[mem_shared] AS 'mem_shared',
		[vds].[vds_type] as 'vds_type',
		[vds].[cpu_flags] AS 'cpu_flags',
		[vds].[vds_group_cpu_name] as 'vds_group_cpu_name',
		[vds].[cpu_over_commit_time_stamp] as 'cpu_over_commit_time_stamp',
		[vds].[hypervisor_type] as 'hypervisor_type',
		[vds].[high_utilization] as 'high_utilization',
		[vds].[low_utilization] as 'low_utilization',
		[vds].[cpu_over_commit_duration_minutes] as 'cpu_over_commit_duration_minutes',
		[vds].[storage_pool_id] as 'storage_pool_id',
		[vds].[storage_pool_name] as 'storage_pool_name',
		[vds].[selection_algorithm] as 'selection_algorithm',
		[vds].[pending_vcpus_count] as 'pending_vcpus_count',
		[vds].[pending_vmem_size] AS 'pending_vmem_size',
		[vds].[vds_strength] AS 'vds_strength',
		[vds].[max_vds_memory_over_commit] AS 'max_vds_memory_over_commit',
        [vds].[cpu_sockets] as 'cpu_sockets',
        [vds].[vds_spm_id] as 'vds_spm_id',
        [vds].[net_config_dirty] as 'net_config_dirty',
        [vds].[pm_type] as 'pm_type',
		[vds].[pm_user] as 'pm_user',
		[vds].[pm_password] as 'pm_password',
        [vds].[pm_port] as 'pm_port',
        [vds].[pm_options] as 'pm_options',
        [vds].[pm_enabled] as 'pm_enabled',
		[vds].[spm_status] as 'spm_status',
		[vds].[swap_free] AS 'swap_free',
		[vds].[swap_total] AS 'swap_total',
		[vds].[ksm_cpu_percent] AS 'ksm_cpu_percent',
		[vds].[ksm_pages] AS 'ksm_pages',
		[vds].[ksm_state] AS 'ksm_state',
		[vds].[supported_cluster_levels] as 'supported_cluster_levels',
		[vds].[supported_rhevms] as 'supported_rhevms',
		[vds].[vds_group_compatibility_version] as 'vds_group_compatibility_version',
		[vds].[host_os] AS 'host_os',
		[vds].[kvm_version] AS 'kvm_version',
		[vds].[spice_version] AS 'spice_version',
		[vds].[kernel_version] AS 'kernel_version',
		[vds].[iscsi_initiator_name] AS 'iscsi_initiator_name',
		[vds].[transparent_hugepages_state] AS 'transparent_hugepages_state',
		[vds].[anonymous_hugepages] AS 'anonymous_hugepages',
		[vds].[hooks] as 'hooks',
		[vds].[non_operational_reason] AS 'non_operational_reason'

		FROM [dbo].[vds] [vds]
		WHERE [vds_name]=@vds_name
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END
GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVdsByHostName')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVdsByHostName] AS RETURN')
END
GO

ALTER PROCEDURE [dbo].[GetVdsByHostName]
	@host_name nvarchar(255)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		distinct([vds].[vds_id]) AS 'vds_id',
		[vds].[vds_group_id] AS 'vds_group_id',
		[vds].[vds_group_name] AS 'vds_group_name',
		[vds].[vds_group_description] AS 'vds_group_description',
		[vds].[vds_name] AS 'vds_name',
		[vds].[ip] AS 'ip',
        [vds].[vds_unique_id] AS 'vds_unique_id',
		[vds].[server_SSL_enabled] AS 'server_SSL_enabled',
		[vds].[host_name] AS 'host_name',
		[vds].[port] AS 'port',
		[vds].[status] AS 'status',
		[vds].[cpu_cores] AS 'cpu_cores',
		[vds].[cpu_model] AS 'cpu_model',
		[vds].[cpu_speed_mh] AS 'cpu_speed_mh',
		[vds].[if_total_speed] AS 'if_total_speed',
		[vds].[kvm_enabled] AS 'kvm_enabled',
		[vds].[physical_mem_mb] AS 'physical_mem_mb',
		[vds].[cpu_idle] AS 'cpu_idle',
		[vds].[cpu_load] AS 'cpu_load',
		[vds].[cpu_sys] AS 'cpu_sys',
		[vds].[cpu_user] AS 'cpu_user',
		[vds].[mem_commited] AS 'mem_commited',
		[vds].[vm_active] AS 'vm_active',
		[vds].[vm_count] AS 'vm_count',
		[vds].[vms_cores_count] AS 'vms_cores_count',
		[vds].[vm_migrating] AS 'vm_migrating',
		[vds].[usage_cpu_percent] AS 'usage_cpu_percent',
		[vds].[usage_mem_percent] AS 'usage_mem_percent',
		[vds].[usage_network_percent] AS 'usage_network_percent',
		[vds].[reserved_mem] AS 'reserved_mem',
		[vds].[guest_overhead] AS 'guest_overhead',
		[vds].[software_version] AS 'software_version',
		[vds].[version_name] AS 'version_name',
		[vds].[build_name] AS 'build_name',
		[vds].[previous_status] AS 'previous_status',
		[vds].[mem_available] AS 'mem_available',
		[vds].[mem_shared] AS 'mem_shared',
		[vds].[vds_type] as 'vds_type',
		[vds].[cpu_flags] AS 'cpu_flags',
		[vds].[vds_group_cpu_name] as 'vds_group_cpu_name',
		[vds].[cpu_over_commit_time_stamp] as 'cpu_over_commit_time_stamp',
		[vds].[hypervisor_type] as 'hypervisor_type',
		[vds].[high_utilization] as 'high_utilization',
		[vds].[low_utilization] as 'low_utilization',
		[vds].[cpu_over_commit_duration_minutes] as 'cpu_over_commit_duration_minutes',
		[vds].[storage_pool_id] as 'storage_pool_id',
		[vds].[storage_pool_name] as 'storage_pool_name',
		[vds].[selection_algorithm] as 'selection_algorithm',
		[vds].[pending_vcpus_count] as 'pending_vcpus_count',
		[vds].[pending_vmem_size] AS 'pending_vmem_size',
		[vds].[vds_strength] AS 'vds_strength',
		[vds].[max_vds_memory_over_commit] AS 'max_vds_memory_over_commit',
        [vds].[cpu_sockets] as 'cpu_sockets',
        [vds].[vds_spm_id] as 'vds_spm_id',
        [vds].[net_config_dirty] as 'net_config_dirty',
        [vds].[pm_type] as 'pm_type',
		[vds].[pm_user] as 'pm_user',
		[vds].[pm_password] as 'pm_password',
        [vds].[pm_port] as 'pm_port',
        [vds].[pm_options] as 'pm_options',
        [vds].[pm_enabled] as 'pm_enabled',
		[vds].[spm_status] as 'spm_status',
		[vds].[swap_free] AS 'swap_free',
		[vds].[swap_total] AS 'swap_total',
		[vds].[ksm_cpu_percent] AS 'ksm_cpu_percent',
		[vds].[ksm_pages] AS 'ksm_pages',
		[vds].[ksm_state] AS 'ksm_state',
		[vds].[supported_cluster_levels] as 'supported_cluster_levels',
		[vds].[supported_rhevms] as 'supported_rhevms',
		[vds].[vds_group_compatibility_version] as 'vds_group_compatibility_version',
		[vds].[host_os] AS 'host_os',
		[vds].[kvm_version] AS 'kvm_version',
		[vds].[spice_version] AS 'spice_version',
		[vds].[kernel_version] AS 'kernel_version',
		[vds].[iscsi_initiator_name] AS 'iscsi_initiator_name',
		[vds].[transparent_hugepages_state] AS 'transparent_hugepages_state',
		[vds].[anonymous_hugepages] AS 'anonymous_hugepages',
		[vds].[hooks] AS 'hooks',
		[vds].[non_operational_reason] AS 'non_operational_reason'

		FROM [dbo].[vds] [vds]
		WHERE [host_name]=@host_name
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END
GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVdsByIp')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVdsByIp] AS RETURN')
END
GO

ALTER PROCEDURE [dbo].[GetVdsByIp]
	@ip nvarchar(40)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		distinct([vds].[vds_id]) AS 'vds_id',
		[vds].[vds_group_id] AS 'vds_group_id',
		[vds].[vds_group_name] AS 'vds_group_name',
		[vds].[vds_group_description] AS 'vds_group_description',
		[vds].[vds_name] AS 'vds_name',
		[vds].[ip] AS 'ip',
        [vds].[vds_unique_id] AS 'vds_unique_id',
		[vds].[server_SSL_enabled] AS 'server_SSL_enabled',
		[vds].[host_name] AS 'host_name',
		[vds].[port] AS 'port',
		[vds].[status] AS 'status',
		[vds].[cpu_cores] AS 'cpu_cores',
		[vds].[cpu_model] AS 'cpu_model',
		[vds].[cpu_speed_mh] AS 'cpu_speed_mh',
		[vds].[if_total_speed] AS 'if_total_speed',
		[vds].[kvm_enabled] AS 'kvm_enabled',
		[vds].[physical_mem_mb] AS 'physical_mem_mb',
		[vds].[cpu_idle] AS 'cpu_idle',
		[vds].[cpu_load] AS 'cpu_load',
		[vds].[cpu_sys] AS 'cpu_sys',
		[vds].[cpu_user] AS 'cpu_user',
		[vds].[mem_commited] AS 'mem_commited',
		[vds].[vm_active] AS 'vm_active',
		[vds].[vm_count] AS 'vm_count',
		[vds].[vms_cores_count] AS 'vms_cores_count',
		[vds].[vm_migrating] AS 'vm_migrating',
		[vds].[usage_cpu_percent] AS 'usage_cpu_percent',
		[vds].[usage_mem_percent] AS 'usage_mem_percent',
		[vds].[usage_network_percent] AS 'usage_network_percent',
		[vds].[reserved_mem] AS 'reserved_mem',
		[vds].[guest_overhead] AS 'guest_overhead',
		[vds].[software_version] AS 'software_version',
		[vds].[version_name] AS 'version_name',
		[vds].[build_name] AS 'build_name',
		[vds].[previous_status] AS 'previous_status',
		[vds].[mem_available] AS 'mem_available',
		[vds].[mem_shared] AS 'mem_shared',
		[vds].[vds_type] as 'vds_type',
		[vds].[cpu_flags] AS 'cpu_flags',
		[vds].[vds_group_cpu_name] as 'vds_group_cpu_name',
		[vds].[cpu_over_commit_time_stamp] as 'cpu_over_commit_time_stamp',
		[vds].[hypervisor_type] as 'hypervisor_type',
		[vds].[high_utilization] as 'high_utilization',
		[vds].[low_utilization] as 'low_utilization',
		[vds].[cpu_over_commit_duration_minutes] as 'cpu_over_commit_duration_minutes',
		[vds].[storage_pool_id] as 'storage_pool_id',
		[vds].[storage_pool_name] as 'storage_pool_name',
		[vds].[selection_algorithm] as 'selection_algorithm',
		[vds].[pending_vcpus_count] as 'pending_vcpus_count',
		[vds].[pending_vmem_size] AS 'pending_vmem_size',
		[vds].[vds_strength] AS 'vds_strength',
		[vds].[max_vds_memory_over_commit] AS 'max_vds_memory_over_commit',
        [vds].[cpu_sockets] as 'cpu_sockets',
        [vds].[vds_spm_id] as 'vds_spm_id',
        [vds].[net_config_dirty] as 'net_config_dirty',
        [vds].[pm_type] as 'pm_type',
		[vds].[pm_user] as 'pm_user',
		[vds].[pm_password] as 'pm_password',
        [vds].[pm_port] as 'pm_port',
        [vds].[pm_options] as 'pm_options',
        [vds].[pm_enabled] as 'pm_enabled',
		[vds].[spm_status] as 'spm_status',
		[vds].[swap_free] AS 'swap_free',
		[vds].[swap_total] AS 'swap_total',
		[vds].[ksm_cpu_percent] AS 'ksm_cpu_percent',
		[vds].[ksm_pages] AS 'ksm_pages',
		[vds].[ksm_state] AS 'ksm_state',
		[vds].[supported_cluster_levels] as 'supported_cluster_levels',
		[vds].[supported_rhevms] as 'supported_rhevms',
		[vds].[vds_group_compatibility_version] as 'vds_group_compatibility_version',
		[vds].[host_os] AS 'host_os',
		[vds].[kvm_version] AS 'kvm_version',
		[vds].[spice_version] AS 'spice_version',
		[vds].[kernel_version] AS 'kernel_version',
		[vds].[iscsi_initiator_name] AS 'iscsi_initiator_name',
		[vds].[transparent_hugepages_state] AS 'transparent_hugepages_state',
		[vds].[anonymous_hugepages] AS 'anonymous_hugepages',
		[vds].[hooks] AS 'hooks',
		[vds].[non_operational_reason] AS 'non_operational_reason'

		FROM [dbo].[vds] [vds]
		WHERE ip=@ip
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END
GO


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVdsByVdsGroupId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVdsByVdsGroupId] AS RETURN')
END
GO

ALTER PROCEDURE [dbo].[GetVdsByVdsGroupId]
	@vds_group_id uniqueidentifier
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	-- this sp returns all vds for a given cluster
	BEGIN TRY
		SELECT
		distinct([vds].[vds_id]) AS 'vds_id',
		[vds].[vds_group_id] AS 'vds_group_id',
		[vds].[vds_group_name] AS 'vds_group_name',
		[vds].[vds_group_description] AS 'vds_group_description',
		[vds].[vds_name] AS 'vds_name',
		[vds].[ip] AS 'ip',
        [vds].[vds_unique_id] AS 'vds_unique_id',
		[vds].[server_SSL_enabled] AS 'server_SSL_enabled',
		[vds].[host_name] AS 'host_name',
		[vds].[port] AS 'port',
		[vds].[status] AS 'status',
		[vds].[cpu_cores] AS 'cpu_cores',
		[vds].[cpu_model] AS 'cpu_model',
		[vds].[cpu_speed_mh] AS 'cpu_speed_mh',
		[vds].[if_total_speed] AS 'if_total_speed',
		[vds].[kvm_enabled] AS 'kvm_enabled',
		[vds].[physical_mem_mb] AS 'physical_mem_mb',
		[vds].[cpu_idle] AS 'cpu_idle',
		[vds].[cpu_load] AS 'cpu_load',
		[vds].[cpu_sys] AS 'cpu_sys',
		[vds].[cpu_user] AS 'cpu_user',
		[vds].[mem_commited] AS 'mem_commited',
		[vds].[vm_active] AS 'vm_active',
		[vds].[vm_count] AS 'vm_count',
		[vds].[vms_cores_count] AS 'vms_cores_count',
		[vds].[vm_migrating] AS 'vm_migrating',
		[vds].[usage_cpu_percent] AS 'usage_cpu_percent',
		[vds].[usage_mem_percent] AS 'usage_mem_percent',
		[vds].[usage_network_percent] AS 'usage_network_percent',
		[vds].[reserved_mem] AS 'reserved_mem',
		[vds].[guest_overhead] AS 'guest_overhead',
		[vds].[software_version] AS 'software_version',
		[vds].[version_name] AS 'version_name',
		[vds].[build_name] AS 'build_name',
		[vds].[previous_status] AS 'previous_status',
		[vds].[mem_available] AS 'mem_available',
		[vds].[mem_shared] AS 'mem_shared',
		[vds].[vds_type] as 'vds_type',
		[vds].[cpu_flags] AS 'cpu_flags',
		[vds].[vds_group_cpu_name] as 'vds_group_cpu_name',
		[vds].[cpu_over_commit_time_stamp] as 'cpu_over_commit_time_stamp',
		[vds].[hypervisor_type] as 'hypervisor_type',
		[vds].[high_utilization] as 'high_utilization',
		[vds].[low_utilization] as 'low_utilization',
		[vds].[cpu_over_commit_duration_minutes] as 'cpu_over_commit_duration_minutes',
		[vds].[storage_pool_id] as 'storage_pool_id',
		[vds].[storage_pool_name] as 'storage_pool_name',
		[vds].[selection_algorithm] as 'selection_algorithm',
		[vds].[pending_vcpus_count] as 'pending_vcpus_count',
		[vds].[pending_vmem_size] AS 'pending_vmem_size',
		[vds].[vds_strength] AS 'vds_strength',
		[vds].[max_vds_memory_over_commit] AS 'max_vds_memory_over_commit',
        [vds].[cpu_sockets] as 'cpu_sockets',
        [vds].[vds_spm_id] as 'vds_spm_id',
        [vds].[net_config_dirty] as 'net_config_dirty',
        [vds].[pm_type] as 'pm_type',
		[vds].[pm_user] as 'pm_user',
		[vds].[pm_password] as 'pm_password',
        [vds].[pm_port] as 'pm_port',
        [vds].[pm_options] as 'pm_options',
		[vds].[pm_enabled] as 'pm_enabled',
		[vds].[spm_status] as 'spm_status',
		[vds].[swap_free] AS 'swap_free',
		[vds].[swap_total] AS 'swap_total',
		[vds].[ksm_cpu_percent] AS 'ksm_cpu_percent',
		[vds].[ksm_pages] AS 'ksm_pages',
		[vds].[ksm_state] AS 'ksm_state',
		[vds].[supported_cluster_levels] as 'supported_cluster_levels',
		[vds].[supported_rhevms] as 'supported_rhevms',
		[vds].[vds_group_compatibility_version] as 'vds_group_compatibility_version',
		[vds].[host_os] AS 'host_os',
		[vds].[kvm_version] AS 'kvm_version',
		[vds].[spice_version] AS 'spice_version',
		[vds].[kernel_version] AS 'kernel_version',
		[vds].[iscsi_initiator_name] AS 'iscsi_initiator_name',
		[vds].[transparent_hugepages_state] AS 'transparent_hugepages_state',
		[vds].[anonymous_hugepages] AS 'anonymous_hugepages',
		[vds].[hooks] as 'hooks',
		[vds].[non_operational_reason] AS 'non_operational_reason'

		FROM [dbo].[vds] [vds]
		WHERE [vds_group_id] = @vds_group_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO
