PRINT 'Processing system_sp.sql'

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'Getsystem_statistics')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].Getsystem_statistics AS RETURN')
END

GO

ALTER proc [dbo].[Getsystem_statistics]
@entity nvarchar(10), -- {VM,HOST,USER,SD}
@status nvarchar(20) = '' -- comma seperated list of status values 
as
begin
	DECLARE @i INT
	declare @sql nvarchar(max)
	declare @parm nvarchar(20)
	set @sql = NULL
	SET @parm = N'@i int OUTPUT'

	set @entity = upper(@entity)
	if (@entity = 'VM')
		set @sql = 'select @i = count(vm_guid) from vm_dynamic'
	else if (@entity = 'HOST')
		set @sql = 'select @i = count(vds_id)  from vds_dynamic'
	else if (@entity = 'USER')
		set @sql = 'select @i = count(user_id) from users'
	else if (@entity = 'TSD')
		set @sql = 'select @i = count(id) from storage_domain_static'
	else if (@entity = 'ASD')
		set @sql = 'select @i = count(storage_id) from storage_pool_iso_map'

	if (@status != '' and @entity != 'TSD')
			set @sql = @sql + ' where status in (' + @status + ')'
	EXEC sp_executesql @sql, @parm, @i OUTPUT
	select @i val
    
end
go

